/*
 * Decompiled with CFR 0.152.
 */
package Allocator;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_BytecodeMap;
import Clazz.jq_Class;
import Clazz.jq_CompiledCode;
import Clazz.jq_InstanceField;
import Clazz.jq_Method;
import Clazz.jq_StaticField;
import Clazz.jq_TryCatch;
import Memory.Address;
import Memory.CodeAddress;
import Run_Time.ExceptionDeliverer;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class CodeAllocator {
    public static boolean TRACE = false;
    private static final SortedMap compiledMethods = new TreeMap();
    private static CodeAddress lowAddress;
    private static CodeAddress highAddress;
    public static final jq_StaticField _lowAddress;
    public static final jq_StaticField _highAddress;

    public abstract void init();

    public abstract x86CodeBuffer getCodeBuffer(int var1, int var2, int var3);

    public abstract void patchAbsolute(Address var1, Address var2);

    public abstract void patchRelativeOffset(CodeAddress var1, CodeAddress var2);

    public static void initializeCompiledMethodMap() {
        lowAddress = (CodeAddress)CodeAddress.getNull().offset(Integer.MAX_VALUE);
        highAddress = CodeAddress.getNull();
        jq_CompiledCode jq_CompiledCode2 = new jq_CompiledCode(null, highAddress, 0, highAddress, null, null, null, 0, null, null);
        compiledMethods.put(jq_CompiledCode2, jq_CompiledCode2);
    }

    public static void registerCode(jq_CompiledCode jq_CompiledCode2) {
        if (TRACE) {
            System.out.println("Registering code: " + jq_CompiledCode2);
        }
        if (lowAddress == null || jq_CompiledCode2.getStart().difference(lowAddress) < 0) {
            lowAddress = jq_CompiledCode2.getStart();
        }
        if (highAddress == null || highAddress.difference(jq_CompiledCode2.getStart().offset(jq_CompiledCode2.getLength())) < 0) {
            highAddress = (CodeAddress)jq_CompiledCode2.getStart().offset(jq_CompiledCode2.getLength());
        }
        compiledMethods.put(jq_CompiledCode2, jq_CompiledCode2);
    }

    public static jq_CompiledCode getCodeContaining(CodeAddress codeAddress) {
        InstructionPointer instructionPointer = new InstructionPointer(codeAddress);
        return (jq_CompiledCode)compiledMethods.get(instructionPointer);
    }

    public static CodeAddress getLowAddress() {
        return lowAddress;
    }

    public static CodeAddress getHighAddress() {
        return highAddress;
    }

    public static Iterator getCompiledMethods() {
        Iterator iterator = compiledMethods.keySet().iterator();
        iterator.next();
        return iterator;
    }

    public static int getNumberOfCompiledMethods() {
        return compiledMethods.keySet().size() - 1;
    }

    static {
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LAllocator/CodeAllocator;");
        _lowAddress = jq_Class2.getOrCreateStaticField("lowAddress", "LMemory/CodeAddress;");
        _highAddress = jq_Class2.getOrCreateStaticField("highAddress", "LMemory/CodeAddress;");
    }

    public static abstract class x86CodeBuffer {
        public abstract int getCurrentOffset();

        public abstract CodeAddress getStartAddress();

        public abstract CodeAddress getCurrentAddress();

        public abstract void setEntrypoint();

        public abstract void add1(byte var1);

        public abstract void add2_endian(int var1);

        public abstract void add2(int var1);

        public abstract void add3(int var1);

        public abstract void add4_endian(int var1);

        public abstract byte get1(int var1);

        public abstract int get4_endian(int var1);

        public abstract void put1(int var1, byte var2);

        public abstract void put4_endian(int var1, int var2);

        public abstract void skip(int var1);

        public abstract jq_CompiledCode allocateCodeBlock(jq_Method var1, jq_TryCatch[] var2, jq_BytecodeMap var3, ExceptionDeliverer var4, int var5, List var6, List var7);
    }

    public static class InstructionPointer
    implements Comparable {
        public static final jq_InstanceField _ip;
        private final CodeAddress ip;

        public CodeAddress getIP() {
            return this.ip;
        }

        public int compareTo(jq_CompiledCode jq_CompiledCode2) {
            CodeAddress codeAddress = this.getIP();
            CodeAddress codeAddress2 = jq_CompiledCode2.getStart();
            if (codeAddress2.difference(codeAddress) >= 0) {
                return -1;
            }
            if (codeAddress2.offset(jq_CompiledCode2.getLength()).difference(codeAddress) < 0) {
                return 1;
            }
            return 0;
        }

        public int compareTo(InstructionPointer instructionPointer) {
            if (this.ip.difference(instructionPointer.ip) < 0) {
                return -1;
            }
            if (this.ip.difference(instructionPointer.ip) > 0) {
                return 1;
            }
            return 0;
        }

        public int compareTo(Object object) {
            if (object instanceof jq_CompiledCode) {
                return this.compareTo((jq_CompiledCode)object);
            }
            return this.compareTo((InstructionPointer)object);
        }

        public boolean equals(jq_CompiledCode jq_CompiledCode2) {
            CodeAddress codeAddress;
            CodeAddress codeAddress2 = this.getIP();
            if (codeAddress2.difference(codeAddress = jq_CompiledCode2.getStart()) < 0) {
                return false;
            }
            return codeAddress2.difference(codeAddress.offset(jq_CompiledCode2.getLength())) <= 0;
        }

        public boolean equals(InstructionPointer instructionPointer) {
            boolean bl = false;
            if (this.ip.difference(instructionPointer.ip) == 0) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof jq_CompiledCode) {
                return this.equals((jq_CompiledCode)object);
            }
            return this.equals((InstructionPointer)object);
        }

        public int hashCode() {
            return 0;
        }

        public InstructionPointer(CodeAddress codeAddress) {
            this.ip = codeAddress;
        }

        static {
            jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LAllocator/CodeAllocator$InstructionPointer;");
            _ip = jq_Class2.getOrCreateInstanceField("ip", "I");
        }
    }
}

