/*
 * Decompiled with CFR 0.152.
 */
package Allocator;

import Memory.HeapAddress;
import Run_Time.Unsafe;

public abstract class ObjectLayoutMethods {
    public static Object initializeObject(HeapAddress heapAddress, Object object, int n) {
        heapAddress = (HeapAddress)heapAddress.offset(8);
        heapAddress.offset(-4).poke(HeapAddress.addressOf(object));
        return heapAddress.asObject();
    }

    public static Object initializeArray(HeapAddress heapAddress, Object object, int n, int n2) {
        heapAddress = (HeapAddress)heapAddress.offset(12);
        heapAddress.offset(-12).poke4(n);
        heapAddress.offset(-4).poke(HeapAddress.addressOf(object));
        return heapAddress.asObject();
    }

    public static int getArrayLength(Object object) {
        HeapAddress heapAddress = HeapAddress.addressOf(object);
        return heapAddress.offset(-12).peek4();
    }

    public static void setArrayLength(Object object, int n) {
        HeapAddress heapAddress = HeapAddress.addressOf(object);
        heapAddress.offset(-12).poke4(n);
    }

    public static Object getVTable(Object object) {
        HeapAddress heapAddress = HeapAddress.addressOf(object);
        return ((HeapAddress)heapAddress.offset(-4).peek()).asObject();
    }

    public static boolean testAndMark(Object object, int n) {
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(object).offset(-8);
        do {
            int n2;
            int n3;
            if ((n3 = heapAddress.peek4()) == (n2 = n3 & 0xFFFFFFFB | n)) {
                return false;
            }
            heapAddress.atomicCas4(n3, n2);
        } while (!Unsafe.isEQ());
        return true;
    }

    public static boolean testMarkBit(Object object, int n) {
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(object).offset(-8);
        int n2 = heapAddress.peek4();
        boolean bl = false;
        if ((n2 & 4) == n) {
            bl = true;
        }
        return bl;
    }

    public static void writeMarkBit(Object object, int n) {
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(object).offset(-8);
        int n2 = heapAddress.peek4();
        int n3 = n2 & 0xFFFFFFFB | n;
        heapAddress.poke4(n3);
    }
}

