/*
 * Decompiled with CFR 0.152.
 */
package Allocator;

import Allocator.CodeAllocator;
import Allocator.HeapAllocator;
import Clazz.jq_BytecodeMap;
import Clazz.jq_CompiledCode;
import Clazz.jq_Method;
import Clazz.jq_TryCatch;
import Memory.Address;
import Memory.CodeAddress;
import Run_Time.ExceptionDeliverer;
import Run_Time.SystemInterface;
import Util.Assert;
import Util.Strings;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RuntimeCodeAllocator
extends CodeAllocator {
    public static final int BLOCK_SIZE = 131072;
    private CodeAddress heapStart;
    private CodeAddress heapCurrent;
    private CodeAddress heapEnd;
    private CodeAddress heapFirst;
    private int maxFreePrevious;
    volatile boolean isGenerating;

    public void init() throws OutOfMemoryError {
        this.heapStart = this.heapFirst = (CodeAddress)SystemInterface.syscalloc(131072);
        if (this.heapStart.isNull()) {
            HeapAllocator.outOfMemory();
        }
        this.heapStart.poke(null);
        this.heapEnd = (CodeAddress)this.heapStart.offset(131072 - CodeAddress.size());
        this.heapStart.offset(CodeAddress.size()).poke(this.heapEnd);
        this.heapCurrent = (CodeAddress)this.heapStart.offset(CodeAddress.size() * 2);
        this.heapEnd.poke(this.heapCurrent);
    }

    public CodeAllocator.x86CodeBuffer getCodeBuffer(int n, int n2, int n3) {
        Assert._assert(this.isGenerating ^ true);
        if (TRACE) {
            SystemInterface.debugwriteln("Code generation started: " + this);
        }
        this.isGenerating = true;
        CodeAddress codeAddress = (CodeAddress)this.heapCurrent.offset(n2);
        if (n3 > 0) {
            codeAddress.align(n3);
        }
        if (codeAddress.offset(n - n2).difference(this.heapEnd) <= 0) {
            return new Runtimex86CodeBuffer((CodeAddress)codeAddress.offset(-n2), this.heapEnd);
        }
        if (n < this.maxFreePrevious) {
            if (TRACE) {
                SystemInterface.debugwriteln("Estimated size (" + Strings.hex(n) + " fits within a prior block: maxfreeprev=" + Strings.hex(this.maxFreePrevious));
            }
            CodeAddress codeAddress2 = this.heapFirst;
            while (true) {
                Assert._assert(codeAddress2.isNull() ^ true);
                CodeAddress codeAddress3 = (CodeAddress)codeAddress2.offset(CodeAddress.size()).peek();
                CodeAddress codeAddress4 = (CodeAddress)codeAddress3.peek();
                if (codeAddress3.difference(codeAddress4) >= n) {
                    return new Runtimex86CodeBuffer(codeAddress4, codeAddress3);
                }
                codeAddress2 = (CodeAddress)codeAddress2.peek();
            }
        }
        this.allocateNewBlock(Math.max(n, 131072));
        return new Runtimex86CodeBuffer(this.heapCurrent, this.heapEnd);
    }

    private final void allocateNewBlock(int n) throws OutOfMemoryError {
        this.heapStart.offset(CodeAddress.size()).poke(this.heapCurrent);
        CodeAddress codeAddress = (CodeAddress)SystemInterface.syscalloc(n);
        if (codeAddress.isNull()) {
            HeapAllocator.outOfMemory();
        }
        this.heapStart.poke(codeAddress);
        this.heapStart = codeAddress;
        this.heapStart.poke(null);
        this.heapEnd = (CodeAddress)codeAddress.offset(n - CodeAddress.size());
        this.heapStart.offset(CodeAddress.size()).poke(this.heapEnd);
        this.heapCurrent = (CodeAddress)codeAddress.offset(CodeAddress.size() * 2);
        this.heapEnd.poke(this.heapCurrent);
    }

    public void patchAbsolute(Address address, Address address2) {
        address.poke(address2);
    }

    public void patchRelativeOffset(CodeAddress codeAddress, CodeAddress codeAddress2) {
        codeAddress.poke4(codeAddress2.difference(codeAddress) - 4);
    }

    public static short endian2(int n) {
        return (short)(n >> 8 & 0xFF | n << 8);
    }

    private final /* synthetic */ void this() {
        this.isGenerating = false;
    }

    public RuntimeCodeAllocator() {
        this.this();
    }

    public class Runtimex86CodeBuffer
    extends CodeAllocator.x86CodeBuffer {
        private CodeAddress startAddress;
        private CodeAddress entrypointAddress;
        private CodeAddress currentAddress;
        private CodeAddress endAddress;

        public int getCurrentOffset() {
            return this.currentAddress.difference(this.startAddress) + 1;
        }

        public CodeAddress getStartAddress() {
            return this.startAddress;
        }

        public CodeAddress getCurrentAddress() {
            return (CodeAddress)this.currentAddress.offset(1);
        }

        public CodeAddress getStart() {
            return this.startAddress;
        }

        public CodeAddress getCurrent() {
            return (CodeAddress)this.currentAddress.offset(1);
        }

        public CodeAddress getEntry() {
            return this.entrypointAddress;
        }

        public CodeAddress getEnd() {
            return this.endAddress;
        }

        public void setEntrypoint() {
            this.entrypointAddress = this.getCurrent();
        }

        public void checkSize(int n) {
            if (this.currentAddress.offset(n).difference(this.endAddress) < 0) {
                return;
            }
            int n2 = this.endAddress.difference(this.startAddress) << 1;
            RuntimeCodeAllocator.this.allocateNewBlock(Math.max(131072, n2));
            boolean bl = false;
            if (this.currentAddress.difference(this.startAddress) + n < RuntimeCodeAllocator.this.heapEnd.difference(RuntimeCodeAllocator.this.heapCurrent)) {
                bl = true;
            }
            Assert._assert(bl);
            SystemInterface.mem_cpy(RuntimeCodeAllocator.this.heapCurrent, this.startAddress, this.currentAddress.difference(this.startAddress));
            if (!this.entrypointAddress.isNull()) {
                this.entrypointAddress = (CodeAddress)RuntimeCodeAllocator.this.heapCurrent.offset(this.entrypointAddress.difference(this.startAddress));
            }
            this.currentAddress = (CodeAddress)RuntimeCodeAllocator.this.heapCurrent.offset(this.currentAddress.difference(this.startAddress));
            this.startAddress = RuntimeCodeAllocator.this.heapCurrent;
            this.endAddress = RuntimeCodeAllocator.this.heapEnd;
        }

        public void add1(byte by) {
            this.checkSize(1);
            this.currentAddress = (CodeAddress)this.currentAddress.offset(1);
            this.currentAddress.poke1(by);
        }

        public void add2_endian(int n) {
            this.checkSize(2);
            this.currentAddress.offset(1).poke2((short)n);
            this.currentAddress = (CodeAddress)this.currentAddress.offset(2);
        }

        public void add2(int n) {
            this.checkSize(2);
            this.currentAddress.offset(1).poke2(RuntimeCodeAllocator.endian2(n));
            this.currentAddress = (CodeAddress)this.currentAddress.offset(2);
        }

        public void add3(int n) {
            this.checkSize(3);
            this.currentAddress.offset(1).poke1((byte)(n >> 16));
            this.currentAddress.offset(2).poke2(RuntimeCodeAllocator.endian2(n));
            this.currentAddress = (CodeAddress)this.currentAddress.offset(3);
        }

        public void add4_endian(int n) {
            this.checkSize(4);
            this.currentAddress.offset(1).poke4(n);
            this.currentAddress = (CodeAddress)this.currentAddress.offset(4);
        }

        public byte get1(int n) {
            return this.startAddress.offset(n).peek1();
        }

        public int get4_endian(int n) {
            return this.startAddress.offset(n).peek4();
        }

        public void put1(int n, byte by) {
            this.startAddress.offset(n).poke1(by);
        }

        public void put4_endian(int n, int n2) {
            this.startAddress.offset(n).poke4(n2);
        }

        public void skip(int n) {
            this.currentAddress = (CodeAddress)this.currentAddress.offset(n);
        }

        public jq_CompiledCode allocateCodeBlock(jq_Method jq_Method2, jq_TryCatch[] jq_TryCatchArray, jq_BytecodeMap jq_BytecodeMap2, ExceptionDeliverer exceptionDeliverer, int n, List list, List list2) {
            Object object;
            Assert._assert(RuntimeCodeAllocator.this.isGenerating);
            CodeAddress codeAddress = this.getStart();
            CodeAddress codeAddress2 = this.getEntry();
            CodeAddress codeAddress3 = this.getCurrent();
            CodeAddress codeAddress4 = this.getEnd();
            boolean bl = false;
            if (codeAddress3.difference(codeAddress4) <= 0) {
                bl = true;
            }
            Assert._assert(bl);
            if (codeAddress4 != RuntimeCodeAllocator.this.heapEnd) {
                if (TRACE) {
                    SystemInterface.debugwriteln("Prior block, recalculating maxfreeprevious (was " + Strings.hex(RuntimeCodeAllocator.this.maxFreePrevious) + ')');
                }
                codeAddress4.poke(codeAddress3);
                RuntimeCodeAllocator.this.maxFreePrevious = 0;
                object = RuntimeCodeAllocator.this.heapFirst;
                while (!((CodeAddress)object).isNull()) {
                    CodeAddress codeAddress5 = (CodeAddress)((CodeAddress)object).offset(CodeAddress.size());
                    CodeAddress codeAddress6 = (CodeAddress)codeAddress5.peek();
                    int n2 = codeAddress5.difference(codeAddress6);
                    RuntimeCodeAllocator.this.maxFreePrevious = Math.max(RuntimeCodeAllocator.this.maxFreePrevious, n2);
                    object = (CodeAddress)((CodeAddress)object).peek();
                }
                if (TRACE) {
                    SystemInterface.debugwriteln("New maxfreeprevious: " + Strings.hex(RuntimeCodeAllocator.this.maxFreePrevious));
                }
            } else {
                RuntimeCodeAllocator.this.heapCurrent = codeAddress3;
                RuntimeCodeAllocator.this.heapEnd.poke(RuntimeCodeAllocator.this.heapCurrent);
            }
            RuntimeCodeAllocator.this.isGenerating = false;
            if (TRACE) {
                SystemInterface.debugwriteln("Code generation completed: " + this);
            }
            object = new jq_CompiledCode(jq_Method2, codeAddress, codeAddress3.difference(codeAddress), codeAddress2, jq_TryCatchArray, jq_BytecodeMap2, exceptionDeliverer, n, list, list2);
            CodeAllocator.registerCode((jq_CompiledCode)object);
            return object;
        }

        Runtimex86CodeBuffer(CodeAddress codeAddress, CodeAddress codeAddress2) {
            this.startAddress = codeAddress;
            this.endAddress = codeAddress2;
            this.currentAddress = (CodeAddress)codeAddress.offset(-1);
        }
    }
}

