/*
 * Decompiled with CFR 0.152.
 */
package Assembler.x86;

import Allocator.DefaultCodeAllocator;
import Assembler.x86.Reloc;
import Clazz.jq_CompiledCode;
import Clazz.jq_Method;
import Memory.CodeAddress;
import Util.Assert;
import java.io.DataOutput;
import java.io.IOException;

public class DirectBindCall
extends Reloc {
    private CodeAddress source;
    private jq_Method target;

    public void patch() {
        this.patchTo(this.target.getDefaultCompiledVersion());
    }

    public void patchTo(jq_CompiledCode jq_CompiledCode2) {
        boolean bl = false;
        if (jq_CompiledCode2 != null) {
            bl = true;
        }
        Assert._assert(bl);
        DefaultCodeAllocator.patchRelativeOffset(this.source, jq_CompiledCode2.getEntrypoint());
    }

    public CodeAddress getSource() {
        return this.source;
    }

    public jq_Method getTarget() {
        return this.target;
    }

    public String toString() {
        return "from code:" + this.source.stringRep() + " to method:" + this.target;
    }

    public void dumpCOFF(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.source.to32BitValue());
        dataOutput.writeInt(0);
        dataOutput.writeChar(6);
    }

    public DirectBindCall(CodeAddress codeAddress, jq_Method jq_Method2) {
        this.source = codeAddress;
        this.target = jq_Method2;
    }
}

