/*
 * Decompiled with CFR 0.152.
 */
package Assembler.x86;

import Assembler.x86.Reloc;
import Memory.HeapAddress;
import Util.Assert;
import java.io.DataOutput;
import java.io.IOException;

public class ExternalReference
extends Reloc {
    private HeapAddress heap_from;
    private int symbol_ndx;
    private String external_name;

    public void setSymbolIndex(int n) {
        boolean bl = false;
        if (n != 0) {
            bl = true;
        }
        Assert._assert(bl);
        this.symbol_ndx = n;
    }

    public void dumpCOFF(DataOutput dataOutput) throws IOException {
        boolean bl = false;
        if (this.symbol_ndx != 0) {
            bl = true;
        }
        Assert._assert(bl);
        dataOutput.writeInt(this.heap_from.to32BitValue());
        dataOutput.writeInt(this.symbol_ndx);
        dataOutput.writeChar(6);
    }

    public HeapAddress getAddress() {
        return this.heap_from;
    }

    public int getSymbolIndex() {
        return this.symbol_ndx;
    }

    public String getName() {
        return this.external_name;
    }

    public void patch() {
        Assert.UNREACHABLE();
    }

    public String toString() {
        return "from heap:" + this.heap_from.stringRep() + " to external:" + this.external_name + " (symndx " + this.symbol_ndx + ')';
    }

    public ExternalReference(HeapAddress heapAddress, String string) {
        this.heap_from = heapAddress;
        this.external_name = string;
    }
}

