/*
 * Decompiled with CFR 0.152.
 */
package Assembler.x86;

import Allocator.DefaultCodeAllocator;
import Assembler.x86.Reloc;
import Memory.CodeAddress;
import Memory.HeapAddress;
import java.io.DataOutput;
import java.io.IOException;

public class Heap2CodeReference
extends Reloc {
    HeapAddress from_heaploc;
    CodeAddress to_codeloc;

    public HeapAddress getFrom() {
        return this.from_heaploc;
    }

    public CodeAddress getTo() {
        return this.to_codeloc;
    }

    public void patch() {
        DefaultCodeAllocator.patchAbsolute(this.from_heaploc, this.to_codeloc);
    }

    public void dumpCOFF(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.from_heaploc.to32BitValue());
        dataOutput.writeInt(0);
        dataOutput.writeChar(6);
    }

    public String toString() {
        return "from heap:" + this.from_heaploc.stringRep() + " to code:" + this.to_codeloc.stringRep();
    }

    public Heap2CodeReference(HeapAddress heapAddress, CodeAddress codeAddress) {
        this.from_heaploc = heapAddress;
        this.to_codeloc = codeAddress;
    }
}

