/*
 * Decompiled with CFR 0.152.
 */
package Bootstrap;

import Allocator.CodeAllocator;
import Assembler.x86.Code2CodeReference;
import Assembler.x86.Code2HeapReference;
import Assembler.x86.DirectBindCall;
import Assembler.x86.ExternalReference;
import Assembler.x86.Heap2CodeReference;
import Assembler.x86.Heap2HeapReference;
import Assembler.x86.Reloc;
import Bootstrap.BootstrapAddress;
import Bootstrap.BootstrapCodeAllocator;
import Bootstrap.BootstrapHeapAddress;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_CompiledCode;
import Clazz.jq_Field;
import Clazz.jq_InstanceField;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Linker.ELF.ELF;
import Linker.ELF.ELFConstants;
import Linker.ELF.ELFOutput;
import Linker.ELF.RelocEntry;
import Linker.ELF.Section;
import Linker.ELF.SymbolTableEntry;
import Memory.Address;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Run_Time.ExceptionDeliverer;
import Run_Time.Reflection;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.jq_NativeThread;
import Util.Assert;
import Util.Collections.IdentityHashCodeWrapper;
import Util.IO.ExtendedDataOutput;
import Util.Strings;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BootImage
implements ELFConstants {
    public static boolean TRACE = false;
    public static final PrintStream out = System.out;
    public static final BootImage DEFAULT = new BootImage(BootstrapCodeAllocator.DEFAULT);
    public static boolean IGNORE_UNKNOWN_OBJECTS = false;
    public static int UPDATE_PERIOD = 10000;
    public static final char F_RELFLG = '\u0001';
    public static final char F_EXEC = '\u0002';
    public static final char F_LNNO = '\u0004';
    public static final char F_LSYMS = '\b';
    public static final char F_AR32WR = '\u0100';
    public static final int STYP_TEXT = 32;
    public static final int STYP_DATA = 64;
    public static final int STYP_BSS = 128;
    public static final int STYP_RELOV = 0x1000000;
    public static final int STYP_EXEC = 0x20000000;
    public static final int STYP_READ = 0x40000000;
    public static final int STYP_WRITE = Integer.MIN_VALUE;
    public static final char RELOC_ADDR32 = '\u0006';
    public static final char RELOC_REL32 = '\u0014';
    public static final short N_UNDEF = 0;
    public static final short N_ABS = -1;
    public static final short N_DEBUG = -2;
    public static final char T_NULL = '\u0000';
    public static final char T_VOID = '\u0001';
    public static final char T_CHAR = '\u0002';
    public static final char T_SHORT = '\u0003';
    public static final char T_INT = '\u0004';
    public static final char T_LONG = '\u0005';
    public static final char T_FLOAT = '\u0006';
    public static final char T_DOUBLE = '\u0007';
    public static final char T_STRUCT = '\b';
    public static final char T_UNION = '\t';
    public static final char T_ENUM = '\n';
    public static final char T_MOE = '\u000b';
    public static final char T_UCHAR = '\f';
    public static final char T_USHORT = '\r';
    public static final char T_UINT = '\u000e';
    public static final char T_ULONG = '\u000f';
    public static final char T_LNGDBL = '\u0010';
    public static final char DT_NON = '\u0000';
    public static final char DT_PTR = '\u0100';
    public static final char DT_FCN = '\u0200';
    public static final char DT_ARY = '\u0300';
    public static final byte C_NULL = 0;
    public static final byte C_AUTO = 1;
    public static final byte C_EXT = 2;
    public static final byte C_STAT = 3;
    public static final byte C_REG = 4;
    public static final byte C_EXTDEF = 5;
    public static final byte C_LABEL = 6;
    public static final byte C_ULABEL = 7;
    public static final byte C_MOS = 8;
    public static final byte C_ARG = 9;
    public static final byte C_STRTAG = 10;
    public static final byte C_MOU = 11;
    public static final byte C_UNTAG = 12;
    public static final byte C_TPDEF = 13;
    public static final byte C_USTATIC = 14;
    public static final byte C_ENTAG = 15;
    public static final byte C_MOE = 16;
    public static final byte C_REGPARM = 17;
    public static final byte C_FIELD = 18;
    public static final byte C_AUTOARG = 19;
    public static final byte C_LASTENT = 20;
    public static final byte C_BLOCK = 100;
    public static final byte C_FCN = 101;
    public static final byte C_EOS = 102;
    public static final byte C_FILE = 103;
    public static final byte C_SECTION = 104;
    public static final byte C_WEAKEXT = 105;
    public static final byte C_EFCN = -1;
    public static boolean USE_MICROSOFT_STYLE_MUNGE = true;
    public static final int NUM_OF_EXTERNAL_SYMS = 7;
    public static final jq_StaticField _DEFAULT;
    private final Map hash;
    private final ArrayList entries;
    private int heapCurrent;
    private final int startAddress;
    private BootstrapCodeAllocator bca;
    private List data_relocs;
    public Set boot_types;
    private boolean alloc_enabled;
    int stringTableOffset;
    List stringTable;

    public final HeapAddress addressOf(Object object) {
        Assert._assert(object instanceof BootstrapAddress ^ true);
        return this.getOrAllocateObject(object);
    }

    public final void addCodeReloc(HeapAddress heapAddress, CodeAddress codeAddress) {
        Heap2CodeReference heap2CodeReference = new Heap2CodeReference(heapAddress, codeAddress);
        this.data_relocs.add(heap2CodeReference);
    }

    public final void addDataReloc(HeapAddress heapAddress, HeapAddress heapAddress2) {
        Heap2HeapReference heap2HeapReference = new Heap2HeapReference(heapAddress, heapAddress2);
        this.data_relocs.add(heap2HeapReference);
    }

    public final void invokeclinit(jq_Class jq_Class2) {
        String string = jq_Class2.getName().toString();
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ERROR: bootstrapping jvm cannot find class " + string);
            Assert.UNREACHABLE();
        }
    }

    public void enableAllocations() {
        this.alloc_enabled = true;
    }

    public void disableAllocations() {
        this.alloc_enabled = false;
    }

    public HeapAddress getOrAllocateObject(Object object) {
        int n;
        int n2;
        if (object == null) {
            return HeapAddress.getNull();
        }
        IdentityHashCodeWrapper identityHashCodeWrapper = IdentityHashCodeWrapper.create(object);
        Entry entry = (Entry)this.hash.get(identityHashCodeWrapper);
        if (entry != null) {
            return entry.getAddress();
        }
        Assert._assert(this.alloc_enabled);
        Class<?> clazz = object.getClass();
        jq_Reference jq_Reference2 = (jq_Reference)Reflection.getJQType(clazz);
        if (!this.boot_types.contains(jq_Reference2)) {
            System.err.println("--> class " + jq_Reference2 + " is not in the set of boot types!");
            return HeapAddress.getNull();
        }
        if (jq_Reference2.isArrayType()) {
            n2 = this.heapCurrent + 12;
            n = ((jq_Array)jq_Reference2).getInstanceSize(Array.getLength(object));
            n = n + 3 & 0xFFFFFFFC;
            if (TRACE) {
                out.println("Allocating entry " + this.entries.size() + ": " + clazz + " length " + Array.getLength(object) + " size " + n + ' ' + Strings.hex(System.identityHashCode(object)) + " at " + Strings.hex(n2));
            }
        } else {
            Assert._assert(jq_Reference2.isClassType());
            n2 = this.heapCurrent + 8;
            n = ((jq_Class)jq_Reference2).getInstanceSize();
            if (TRACE) {
                out.println("Allocating entry " + this.entries.size() + ": " + clazz + " size " + n + ' ' + Strings.hex(System.identityHashCode(object)) + " at " + Strings.hex(n2) + (object instanceof jq_Type ? ": " + object : ""));
            }
        }
        this.heapCurrent += n;
        BootstrapHeapAddress bootstrapHeapAddress = new BootstrapHeapAddress(n2);
        entry = Entry.create(object, bootstrapHeapAddress);
        this.hash.put(identityHashCodeWrapper, entry);
        this.entries.add(entry);
        return bootstrapHeapAddress;
    }

    public HeapAddress getAddressOf(Object object) {
        Assert._assert(object instanceof BootstrapAddress ^ true);
        if (object == null) {
            return HeapAddress.getNull();
        }
        IdentityHashCodeWrapper identityHashCodeWrapper = IdentityHashCodeWrapper.create(object);
        Entry entry = (Entry)this.hash.get(identityHashCodeWrapper);
        if (entry == null) {
            System.err.println("Unknown object of type: " + object.getClass() + " address: " + Strings.hex(System.identityHashCode(object)) + " value: " + object);
            if (IGNORE_UNKNOWN_OBJECTS) {
                return HeapAddress.getNull();
            }
            throw new UnknownObjectException(object);
        }
        Class<?> clazz = object.getClass();
        jq_Reference jq_Reference2 = (jq_Reference)Reflection.getJQType(clazz);
        Assert._assert(jq_Reference2.isClsInitialized(), jq_Reference2.toString());
        return entry.getAddress();
    }

    public Object getObject(int n) {
        Entry entry = (Entry)this.entries.get(n);
        return entry.getObject();
    }

    public void addStaticFieldReloc(jq_StaticField jq_StaticField2) {
        Object object;
        jq_Type jq_Type2 = jq_StaticField2.getType();
        if (jq_StaticField2.isCodeAddressType()) {
            CodeAddress codeAddress = (CodeAddress)Reflection.getstatic_P(jq_StaticField2);
            if (codeAddress != null && !codeAddress.isNull()) {
                if (TRACE) {
                    out.println("Adding code reloc for " + jq_StaticField2 + ": " + jq_StaticField2.getAddress().stringRep() + ' ' + codeAddress.stringRep());
                }
                this.addCodeReloc(jq_StaticField2.getAddress(), codeAddress);
            }
        } else if (jq_StaticField2.isHeapAddressType()) {
            HeapAddress heapAddress = (HeapAddress)Reflection.getstatic_P(jq_StaticField2);
            if (heapAddress != null && !heapAddress.isNull()) {
                if (TRACE) {
                    out.println("Adding data reloc for " + jq_StaticField2 + ": " + jq_StaticField2.getAddress().stringRep() + ' ' + heapAddress.stringRep());
                }
                this.addDataReloc(jq_StaticField2.getAddress(), heapAddress);
            }
        } else if (jq_Type2.isReferenceType() && (object = Reflection.getstatic_A(jq_StaticField2)) != null) {
            if (object instanceof BootstrapAddress) {
                Assert.UNREACHABLE("Error: " + jq_StaticField2 + " contains " + ((Address)object).stringRep());
            }
            HeapAddress heapAddress = HeapAddress.addressOf(object);
            if (TRACE) {
                out.println("Adding data reloc for " + jq_StaticField2 + ": " + jq_StaticField2.getAddress().stringRep() + ' ' + heapAddress.stringRep());
            }
            this.addDataReloc(jq_StaticField2.getAddress(), heapAddress);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initStaticField(jq_StaticField jq_StaticField2) {
        jq_Class jq_Class2 = jq_StaticField2.getDeclaringClass();
        jq_Type jq_Type2 = jq_StaticField2.getType();
        if (jq_Type2.isPrimitiveType()) {
            if (jq_Type2 == jq_Primitive.INT) {
                int n = Reflection.getstatic_I(jq_StaticField2);
                jq_Class2.setStaticData(jq_StaticField2, n);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                float f = Reflection.getstatic_F(jq_StaticField2);
                jq_Class2.setStaticData(jq_StaticField2, f);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                long l = Reflection.getstatic_L(jq_StaticField2);
                jq_Class2.setStaticData(jq_StaticField2, l);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                double d = Reflection.getstatic_D(jq_StaticField2);
                jq_Class2.setStaticData(jq_StaticField2, d);
            } else if (jq_Type2 == jq_Primitive.BOOLEAN) {
                int n = Reflection.getstatic_Z(jq_StaticField2);
                jq_Class2.setStaticData(jq_StaticField2, n);
            } else if (jq_Type2 == jq_Primitive.BYTE) {
                byte by = Reflection.getstatic_B(jq_StaticField2);
                jq_Class2.setStaticData(jq_StaticField2, by);
            } else if (jq_Type2 == jq_Primitive.SHORT) {
                short s = Reflection.getstatic_S(jq_StaticField2);
                jq_Class2.setStaticData(jq_StaticField2, s);
            } else if (jq_Type2 == jq_Primitive.CHAR) {
                char c = Reflection.getstatic_C(jq_StaticField2);
                jq_Class2.setStaticData(jq_StaticField2, c);
            } else {
                Assert.UNREACHABLE();
            }
        } else if (jq_Type2.isAddressType()) {
            void var4_14;
            Address address = Reflection.getstatic_P(jq_StaticField2);
            if (address == null) {
                HeapAddress object = HeapAddress.getNull();
            }
            if (TRACE) {
                out.println("Initializing static field " + jq_StaticField2 + " to " + var4_14.stringRep());
            }
            jq_Class2.setStaticData(jq_StaticField2, (Address)var4_14);
        } else {
            Object object = Reflection.getstatic_A(jq_StaticField2);
            HeapAddress heapAddress = HeapAddress.addressOf(object);
            if (TRACE) {
                out.println("Initializing static field " + jq_StaticField2 + " to " + heapAddress.stringRep());
            }
            jq_Class2.setStaticData(jq_StaticField2, heapAddress);
        }
    }

    public int numOfEntries() {
        return this.entries.size();
    }

    public void find_reachable(int n) {
        while (n < this.entries.size()) {
            Entry entry;
            Object object;
            if (n % UPDATE_PERIOD == 0) {
                out.print("Scanning: " + n + '/' + this.entries.size() + " objects, memory used: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + "   \r");
            }
            if ((object = (entry = (Entry)this.entries.get(n)).getObject()) != null) {
                Object object2;
                jq_Type jq_Type2;
                HeapAddress heapAddress = entry.getAddress();
                Assert._assert(heapAddress.isNull() ^ true);
                Class<?> clazz = object.getClass();
                jq_Reference jq_Reference2 = (jq_Reference)Reflection.getJQType(clazz);
                if (TRACE) {
                    out.println("Entry " + n + ": " + clazz + ' ' + Strings.hex(System.identityHashCode(object)));
                }
                this.addDataReloc((HeapAddress)heapAddress.offset(-4), this.getOrAllocateObject(jq_Reference2));
                if (jq_Reference2.isArrayType()) {
                    jq_Type2 = ((jq_Array)jq_Reference2).getElementType();
                    if (!jq_Type2.isAddressType() && jq_Type2.isReferenceType()) {
                        int n2 = Array.getLength(object);
                        Object[] objectArray = (Object[])object;
                        int n3 = 0;
                        while (n3 < n2) {
                            object2 = Reflection.arrayload_A(objectArray, n3);
                            if (object2 != null) {
                                this.addDataReloc((HeapAddress)heapAddress.offset(n3 * HeapAddress.size()), this.getOrAllocateObject(object2));
                            }
                            ++n3;
                        }
                    }
                } else {
                    Assert._assert(jq_Reference2.isClassType());
                    jq_Type2 = (jq_Class)jq_Reference2;
                    jq_InstanceField[] jq_InstanceFieldArray = ((jq_Class)jq_Type2).getInstanceFields();
                    int n4 = 0;
                    while (n4 < jq_InstanceFieldArray.length) {
                        Object object3;
                        jq_InstanceField jq_InstanceField2 = jq_InstanceFieldArray[n4];
                        object2 = jq_InstanceField2.getType();
                        if (jq_InstanceField2.isCodeAddressType()) {
                            object3 = (CodeAddress)Reflection.getfield_P(object, jq_InstanceField2);
                            if (object3 != null && !((CodeAddress)object3).isNull()) {
                                this.addCodeReloc((HeapAddress)heapAddress.offset(jq_InstanceField2.getOffset()), (CodeAddress)object3);
                            }
                        } else if (jq_InstanceField2.isHeapAddressType()) {
                            object3 = (HeapAddress)Reflection.getfield_P(object, jq_InstanceField2);
                            if (object3 != null && !((HeapAddress)object3).isNull()) {
                                this.addDataReloc((HeapAddress)heapAddress.offset(jq_InstanceField2.getOffset()), (HeapAddress)object3);
                            }
                        } else if (!jq_InstanceField2.isStackAddressType() && ((jq_Type)object2).isReferenceType() && (object3 = Reflection.getfield_A(object, jq_InstanceField2)) != null) {
                            this.addDataReloc((HeapAddress)heapAddress.offset(jq_InstanceField2.getOffset()), this.getOrAllocateObject(object3));
                        }
                        ++n4;
                    }
                }
            }
            ++n;
        }
    }

    public int size() {
        return this.heapCurrent - this.startAddress;
    }

    public void dumpFILHDR(ExtendedDataOutput extendedDataOutput, int n, int n2) throws IOException {
        extendedDataOutput.writeUShort(332);
        extendedDataOutput.writeUShort(2);
        long l = System.currentTimeMillis();
        int n3 = (int)(l / 1000L);
        extendedDataOutput.writeUInt(n3);
        extendedDataOutput.writeUInt(n);
        extendedDataOutput.writeUInt(n2);
        extendedDataOutput.writeUShort(0);
        extendedDataOutput.writeUShort(268);
    }

    public void dumpTEXTSCNHDR(ExtendedDataOutput extendedDataOutput, int n, int n2) throws IOException {
        BootImage.write_bytes(extendedDataOutput, ".text", 8);
        extendedDataOutput.writeUInt(0);
        extendedDataOutput.writeUInt(0);
        extendedDataOutput.writeUInt(n);
        extendedDataOutput.writeUInt(100);
        extendedDataOutput.writeUInt(100 + n);
        extendedDataOutput.writeUInt(0);
        if (n2 > (char)-1) {
            extendedDataOutput.writeUShort((char)-1);
        } else {
            extendedDataOutput.writeUShort((char)n2);
        }
        extendedDataOutput.writeUShort(0);
        if (n2 > (char)-1) {
            extendedDataOutput.writeUInt(-1056964576);
        } else {
            extendedDataOutput.writeUInt(-1073741792);
        }
    }

    public void dumpDATASCNHDR(ExtendedDataOutput extendedDataOutput, int n, int n2, int n3) throws IOException {
        BootImage.write_bytes(extendedDataOutput, ".data", 8);
        extendedDataOutput.writeUInt(0);
        extendedDataOutput.writeUInt(0);
        extendedDataOutput.writeUInt(n2);
        extendedDataOutput.writeUInt(n);
        extendedDataOutput.writeUInt(n + n2);
        extendedDataOutput.writeUInt(0);
        if (n3 > (char)-1) {
            extendedDataOutput.writeUShort((char)-1);
        } else {
            extendedDataOutput.writeUShort((char)n3);
        }
        extendedDataOutput.writeUShort(0);
        if (n3 > (char)-1) {
            extendedDataOutput.writeUInt(-1056964544);
        } else {
            extendedDataOutput.writeUInt(-1073741760);
        }
    }

    public void dumpLINENO(ExtendedDataOutput extendedDataOutput, int n, char c) throws IOException {
        extendedDataOutput.writeUInt(n);
        extendedDataOutput.writeUShort(c);
    }

    public void dumpSECTIONSYMENTs(ExtendedDataOutput extendedDataOutput) throws IOException {
        BootImage.write_bytes(extendedDataOutput, ".text", 8);
        extendedDataOutput.writeUInt(0);
        extendedDataOutput.writeShort(1);
        extendedDataOutput.writeUShort(0);
        extendedDataOutput.writeUByte(3);
        extendedDataOutput.writeUByte(0);
        BootImage.write_bytes(extendedDataOutput, ".data", 8);
        extendedDataOutput.writeUInt(0);
        extendedDataOutput.writeShort(2);
        extendedDataOutput.writeUShort(0);
        extendedDataOutput.writeUByte(3);
        extendedDataOutput.writeUByte(0);
    }

    public void dumpEXTSYMENTs(ExtendedDataOutput extendedDataOutput, jq_StaticMethod jq_StaticMethod2) throws IOException {
        String string = USE_MICROSOFT_STYLE_MUNGE ? "_entry@0" : "entry";
        BootImage.write_bytes(extendedDataOutput, string, 8);
        CodeAddress codeAddress = jq_StaticMethod2.getDefaultCompiledVersion().getEntrypoint();
        extendedDataOutput.writeUInt(codeAddress.to32BitValue());
        extendedDataOutput.writeShort(1);
        extendedDataOutput.writeUShort(512);
        extendedDataOutput.writeUByte(2);
        extendedDataOutput.writeUByte(0);
        extendedDataOutput.writeUInt(0);
        string = USE_MICROSOFT_STYLE_MUNGE ? "_trap_handler@4" : "trap_handler";
        int n = this.alloc_string(string);
        extendedDataOutput.writeUInt(n);
        codeAddress = ExceptionDeliverer._trap_handler.getDefaultCompiledVersion().getEntrypoint();
        extendedDataOutput.writeUInt(codeAddress.to32BitValue());
        extendedDataOutput.writeShort(1);
        extendedDataOutput.writeUShort(512);
        extendedDataOutput.writeUByte(2);
        extendedDataOutput.writeUByte(0);
        extendedDataOutput.writeUInt(0);
        string = USE_MICROSOFT_STYLE_MUNGE ? "_debug_trap_handler@4" : "debug_trap_handler";
        n = this.alloc_string(string);
        extendedDataOutput.writeUInt(n);
        codeAddress = ExceptionDeliverer._debug_trap_handler.getDefaultCompiledVersion().getEntrypoint();
        extendedDataOutput.writeUInt(codeAddress.to32BitValue());
        extendedDataOutput.writeShort(1);
        extendedDataOutput.writeUShort(512);
        extendedDataOutput.writeUByte(2);
        extendedDataOutput.writeUByte(0);
        extendedDataOutput.writeUInt(0);
        string = USE_MICROSOFT_STYLE_MUNGE ? "_threadSwitch@4" : "threadSwitch";
        n = this.alloc_string(string);
        extendedDataOutput.writeUInt(n);
        codeAddress = jq_NativeThread._threadSwitch.getDefaultCompiledVersion().getEntrypoint();
        extendedDataOutput.writeUInt(codeAddress.to32BitValue());
        extendedDataOutput.writeShort(1);
        extendedDataOutput.writeUShort(512);
        extendedDataOutput.writeUByte(2);
        extendedDataOutput.writeUByte(0);
        extendedDataOutput.writeUInt(0);
        string = USE_MICROSOFT_STYLE_MUNGE ? "_ctrl_break_handler@0" : "ctrl_break_handler";
        n = this.alloc_string(string);
        extendedDataOutput.writeUInt(n);
        codeAddress = jq_NativeThread._ctrl_break_handler.getDefaultCompiledVersion().getEntrypoint();
        extendedDataOutput.writeUInt(codeAddress.to32BitValue());
        extendedDataOutput.writeShort(1);
        extendedDataOutput.writeUShort(512);
        extendedDataOutput.writeUByte(2);
        extendedDataOutput.writeUByte(0);
        extendedDataOutput.writeUInt(0);
        string = USE_MICROSOFT_STYLE_MUNGE ? "_joeq_code_startaddress" : "joeq_code_startaddress";
        n = this.alloc_string(string);
        extendedDataOutput.writeUInt(n);
        extendedDataOutput.writeUInt(0);
        extendedDataOutput.writeShort(1);
        extendedDataOutput.writeUShort(257);
        extendedDataOutput.writeUByte(2);
        extendedDataOutput.writeUByte(0);
        extendedDataOutput.writeUInt(0);
        string = USE_MICROSOFT_STYLE_MUNGE ? "_joeq_data_startaddress" : "joeq_data_startaddress";
        n = this.alloc_string(string);
        extendedDataOutput.writeUInt(n);
        extendedDataOutput.writeUInt(0);
        extendedDataOutput.writeShort(2);
        extendedDataOutput.writeUShort(257);
        extendedDataOutput.writeUByte(2);
        extendedDataOutput.writeUByte(0);
    }

    public void dumpEXTDEFSYMENTs(ExtendedDataOutput extendedDataOutput, List list) throws IOException {
        Iterator iterator = list.iterator();
        int n = 9;
        while (iterator.hasNext()) {
            ExternalReference externalReference = (ExternalReference)iterator.next();
            boolean bl = false;
            if (externalReference.getSymbolIndex() == n) {
                bl = true;
            }
            Assert._assert(bl);
            String string = externalReference.getName();
            if (string.length() <= 8) {
                BootImage.write_bytes(extendedDataOutput, string, 8);
            } else {
                extendedDataOutput.writeUInt(0);
                int n2 = this.alloc_string(string);
                extendedDataOutput.writeUInt(n2);
            }
            extendedDataOutput.writeUInt(0);
            extendedDataOutput.writeShort(0);
            extendedDataOutput.writeUShort(512);
            extendedDataOutput.writeUByte(2);
            extendedDataOutput.writeUByte(0);
            ++n;
        }
    }

    public void dumpSFIELDSYMENT(ExtendedDataOutput extendedDataOutput, jq_StaticField jq_StaticField2) throws IOException {
        String string = this.mungeMemberName(jq_StaticField2);
        if (string.length() <= 8) {
            BootImage.write_bytes(extendedDataOutput, string, 8);
        } else {
            extendedDataOutput.writeUInt(0);
            int n = this.alloc_string(string);
            extendedDataOutput.writeUInt(n);
        }
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        extendedDataOutput.writeUInt(heapAddress.to32BitValue());
        extendedDataOutput.writeShort(2);
        jq_Type jq_Type2 = jq_StaticField2.getType();
        int n = 0;
        if (jq_Type2.isArrayType()) {
            jq_Type2 = ((jq_Array)jq_Type2).getElementType();
            n = 768;
        } else if (jq_Type2.isReferenceType()) {
            n = 256;
        }
        if (jq_Type2.isPrimitiveType()) {
            if (jq_Type2 == jq_Primitive.INT) {
                n = (char)(n | 5);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                n = (char)(n | 0x10);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                n = (char)(n | 6);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                n = (char)(n | 7);
            } else if (jq_Type2 == jq_Primitive.BYTE) {
                n = (char)(n | 2);
            } else if (jq_Type2 == jq_Primitive.BOOLEAN) {
                n = (char)(n | 0xC);
            } else if (jq_Type2 == jq_Primitive.SHORT) {
                n = (char)(n | 3);
            } else if (jq_Type2 == jq_Primitive.CHAR) {
                n = (char)(n | 0xD);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            n = (char)(n | 8);
        }
        extendedDataOutput.writeUShort(n);
        extendedDataOutput.writeUByte(3);
        extendedDataOutput.writeUByte(0);
    }

    public void dumpIFIELDSYMENT(ExtendedDataOutput extendedDataOutput, jq_InstanceField jq_InstanceField2) throws IOException {
        int n;
        String string = jq_InstanceField2.getName().toString();
        if (string.length() <= 8) {
            BootImage.write_bytes(extendedDataOutput, string, 8);
        } else {
            extendedDataOutput.writeUInt(0);
            n = this.alloc_string(string);
            extendedDataOutput.writeUInt(n);
        }
        n = jq_InstanceField2.getOffset();
        extendedDataOutput.writeUInt(n);
        extendedDataOutput.writeShort(2);
        jq_Type jq_Type2 = jq_InstanceField2.getType();
        int n2 = 0;
        if (jq_Type2.isArrayType()) {
            jq_Type2 = ((jq_Array)jq_Type2).getElementType();
            n2 = 768;
        } else if (jq_Type2.isReferenceType()) {
            n2 = 256;
        }
        if (jq_Type2.isPrimitiveType()) {
            if (jq_Type2 == jq_Primitive.INT) {
                n2 = (char)(n2 | 5);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                n2 = (char)(n2 | 0x10);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                n2 = (char)(n2 | 6);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                n2 = (char)(n2 | 7);
            } else if (jq_Type2 == jq_Primitive.BYTE) {
                n2 = (char)(n2 | 2);
            } else if (jq_Type2 == jq_Primitive.BOOLEAN) {
                n2 = (char)(n2 | 0xC);
            } else if (jq_Type2 == jq_Primitive.SHORT) {
                n2 = (char)(n2 | 3);
            } else if (jq_Type2 == jq_Primitive.CHAR) {
                n2 = (char)(n2 | 0xD);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            n2 = (char)(n2 | 8);
        }
        extendedDataOutput.writeUShort(n2);
        extendedDataOutput.writeUByte(8);
        extendedDataOutput.writeUByte(0);
    }

    public void dumpMETHODSYMENT(ExtendedDataOutput extendedDataOutput, jq_CompiledCode jq_CompiledCode2) throws IOException {
        jq_Method jq_Method2 = jq_CompiledCode2.getMethod();
        String string = jq_Method2 == null ? "unknown@" + jq_CompiledCode2.getEntrypoint().stringRep() : this.mungeMemberName(jq_Method2);
        if (string.length() <= 8) {
            BootImage.write_bytes(extendedDataOutput, string, 8);
        } else {
            extendedDataOutput.writeUInt(0);
            int n = this.alloc_string(string);
            extendedDataOutput.writeUInt(n);
        }
        CodeAddress codeAddress = jq_CompiledCode2.getEntrypoint();
        extendedDataOutput.writeUInt(codeAddress.to32BitValue());
        extendedDataOutput.writeShort(1);
        extendedDataOutput.writeUShort(512);
        extendedDataOutput.writeUByte(2);
        extendedDataOutput.writeUByte(0);
    }

    public void addSystemInterfaceRelocs_COFF(List list, List list2) {
        jq_StaticField[] jq_StaticFieldArray = SystemInterface._class.getDeclaredStaticFields();
        int n = 8;
        int n2 = 0;
        while (n2 < jq_StaticFieldArray.length) {
            jq_StaticField jq_StaticField2 = jq_StaticFieldArray[n2];
            if (!jq_StaticField2.isFinal() && jq_StaticField2.getType() == CodeAddress._class) {
                String string = jq_StaticField2.getName().toString();
                int n3 = string.lastIndexOf(95);
                string = USE_MICROSOFT_STYLE_MUNGE ? "_" + string.substring(0, n3) + '@' + string.substring(n3 + 1) : string.substring(0, n3);
                if (TRACE) {
                    System.out.println("External ref=" + jq_StaticField2 + ", symndx=" + (n + 1) + " address=" + jq_StaticField2.getAddress().stringRep());
                }
                ExternalReference externalReference = new ExternalReference(jq_StaticField2.getAddress(), string);
                externalReference.setSymbolIndex(++n);
                list.add(externalReference);
                list2.add(externalReference);
            }
            ++n2;
        }
    }

    public void addSystemInterfaceRelocs_ELF(List list, List list2) {
        jq_StaticField[] jq_StaticFieldArray = SystemInterface._class.getDeclaredStaticFields();
        int n = 8;
        int n2 = 0;
        while (n2 < jq_StaticFieldArray.length) {
            jq_StaticField jq_StaticField2 = jq_StaticFieldArray[n2];
            if (!jq_StaticField2.isFinal() && jq_StaticField2.getType() == CodeAddress._class) {
                String string = jq_StaticField2.getName().toString();
                int n3 = string.lastIndexOf(95);
                string = string.substring(0, n3);
                if (TRACE) {
                    System.out.println("External ref=" + jq_StaticField2 + ", symndx=" + (n + 1) + " address=" + jq_StaticField2.getAddress().stringRep());
                }
                ExternalReference externalReference = new ExternalReference(jq_StaticField2.getAddress(), string);
                externalReference.setSymbolIndex(++n);
                list.add(externalReference);
                list2.add(externalReference);
            }
            ++n2;
        }
    }

    public int addVTableRelocs(List list) {
        int n = 0;
        Iterator iterator = this.boot_types.iterator();
        while (iterator.hasNext()) {
            jq_Type jq_Type2 = (jq_Type)iterator.next();
            if (!jq_Type2.isReferenceType() || jq_Type2 == Unsafe._class) continue;
            try {
                if (TRACE) {
                    System.out.println("Adding vtable relocs for: " + jq_Type2);
                }
                Address[] addressArray = (Address[])((jq_Reference)jq_Type2).getVTable();
                HeapAddress heapAddress = this.getAddressOf(addressArray);
                Heap2HeapReference heap2HeapReference = new Heap2HeapReference(heapAddress, (HeapAddress)addressArray[0]);
                list.add(heap2HeapReference);
                int n2 = 1;
                while (n2 < addressArray.length) {
                    Heap2CodeReference heap2CodeReference = new Heap2CodeReference((HeapAddress)heapAddress.offset(CodeAddress.size() * n2), (CodeAddress)addressArray[n2]);
                    list.add(heap2CodeReference);
                    ++n2;
                }
                n += addressArray.length;
            }
            catch (UnknownObjectException unknownObjectException) {
                unknownObjectException.appendMessage("vtable for " + jq_Type2);
                unknownObjectException.setObject(null);
                throw unknownObjectException;
            }
        }
        return n;
    }

    public void dumpCOFF(ExtendedDataOutput extendedDataOutput, jq_StaticMethod jq_StaticMethod2) throws IOException {
        Object object;
        Reloc reloc;
        List list = this.bca.getAllCodeRelocs();
        List list2 = this.bca.getAllDataRelocs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ((Reloc)e).patch();
            if (!(e instanceof DirectBindCall)) continue;
            iterator.remove();
        }
        int n = this.bca.size();
        LinkedList linkedList = new LinkedList();
        int n2 = list.size() + list2.size();
        if (n2 > (char)-1) {
            ++n2;
        }
        int n3 = 100 + n + 10 * n2;
        int n4 = this.heapCurrent;
        int n5 = this.addVTableRelocs(this.data_relocs);
        this.addSystemInterfaceRelocs_COFF(linkedList, this.data_relocs);
        int n6 = this.data_relocs.size();
        if (n6 > (char)-1) {
            ++n6;
        }
        int n7 = n3 + n4 + 10 * n6;
        int n8 = CodeAllocator.getNumberOfCompiledMethods();
        int n9 = 9 + n8 + linkedList.size();
        if (TRACE) {
            System.out.println("Text size=" + n);
            System.out.println("Num text relocs=" + n2);
            System.out.println("Data start=" + n3);
            System.out.println("Data size=" + n4);
            System.out.println("Num of VTable relocs=" + n5);
            System.out.println("Num data relocs=" + n2);
            System.out.println("Sym tab start=" + n7);
            System.out.println("Num syms=" + n9);
        }
        this.dumpFILHDR(extendedDataOutput, n7, n9);
        this.dumpTEXTSCNHDR(extendedDataOutput, n, n2);
        this.dumpDATASCNHDR(extendedDataOutput, n3, n4, n6);
        this.bca.dump(extendedDataOutput);
        if (n2 > (char)-1) {
            extendedDataOutput.writeUInt(n2);
            extendedDataOutput.writeUInt(0);
            extendedDataOutput.writeUShort(0);
        }
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            reloc = (Reloc)iterator2.next();
            reloc.dumpCOFF(extendedDataOutput);
        }
        iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            reloc = (Reloc)iterator2.next();
            reloc.dumpCOFF(extendedDataOutput);
        }
        try {
            this.dumpHeap(extendedDataOutput);
        }
        catch (UnknownObjectException unknownObjectException) {
            Object object2 = unknownObjectException.getObject();
            HashSet hashSet = new HashSet();
            this.findReferencePath(object2, unknownObjectException, hashSet);
            throw unknownObjectException;
        }
        int n10 = 0;
        if (n6 > (char)-1) {
            extendedDataOutput.writeUInt(n6);
            extendedDataOutput.writeUInt(0);
            extendedDataOutput.writeUShort(0);
            ++n10;
        }
        iterator2 = this.data_relocs.iterator();
        while (iterator2.hasNext()) {
            if (n10 % UPDATE_PERIOD == 0) {
                out.print("Written: " + n10 + '/' + n6 + " relocations\r");
            }
            object = (Reloc)iterator2.next();
            ((Reloc)object).dumpCOFF(extendedDataOutput);
            ++n10;
        }
        out.println("Written: " + n6 + " relocations                    \n");
        boolean bl = false;
        if (n10 == n6) {
            bl = true;
        }
        Assert._assert(bl);
        this.dumpSECTIONSYMENTs(extendedDataOutput);
        this.dumpEXTSYMENTs(extendedDataOutput, jq_StaticMethod2);
        this.dumpEXTDEFSYMENTs(extendedDataOutput, linkedList);
        iterator2 = CodeAllocator.getCompiledMethods();
        n10 = 0;
        while (iterator2.hasNext()) {
            object = (jq_CompiledCode)iterator2.next();
            this.dumpMETHODSYMENT(extendedDataOutput, (jq_CompiledCode)object);
            ++n10;
        }
        boolean bl2 = false;
        if (n10 == n8) {
            bl2 = true;
        }
        Assert._assert(bl2);
        this.dump_strings(extendedDataOutput);
    }

    private final jq_StaticField searchStaticVariables(Object object) {
        Iterator iterator = PrimordialClassLoader.loader.getAllTypes().iterator();
        while (iterator.hasNext()) {
            jq_Class jq_Class2;
            Object e = iterator.next();
            if (!(e instanceof jq_Class) || !(jq_Class2 = (jq_Class)e).isLoaded()) continue;
            jq_StaticField[] jq_StaticFieldArray = jq_Class2.getDeclaredStaticFields();
            int n = 0;
            while (n < jq_StaticFieldArray.length) {
                Object object2;
                jq_StaticField jq_StaticField2 = jq_StaticFieldArray[n];
                if (!jq_StaticField2.getType().isAddressType() && jq_StaticField2.getType().isReferenceType() && (object2 = Reflection.getstatic_A(jq_StaticField2)) == object) {
                    return jq_StaticField2;
                }
                ++n;
            }
        }
        return null;
    }

    private final boolean findReferencePath(Object object, UnknownObjectException unknownObjectException, HashSet hashSet) {
        jq_StaticField jq_StaticField2 = this.searchStaticVariables(object);
        if (jq_StaticField2 != null) {
            unknownObjectException.appendMessage("" + jq_StaticField2.getDeclaringClass() + '.' + jq_StaticField2.getName());
            return true;
        }
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Object object2;
            jq_Type jq_Type2;
            Entry entry = (Entry)iterator.next();
            Object object3 = entry.getObject();
            IdentityHashCodeWrapper identityHashCodeWrapper = IdentityHashCodeWrapper.create(object3);
            if (hashSet.contains(identityHashCodeWrapper)) continue;
            Class<?> clazz = object3.getClass();
            jq_Reference jq_Reference2 = (jq_Reference)Reflection.getJQType(clazz);
            if (jq_Reference2.isArrayType()) {
                jq_Type2 = ((jq_Array)jq_Reference2).getElementType();
                if (jq_Type2.isAddressType() || !jq_Type2.isReferenceType()) continue;
                int n = Array.getLength(object3);
                Object[] objectArray = (Object[])object3;
                int n2 = 0;
                while (n2 < n) {
                    object2 = Reflection.arrayload_A(objectArray, n2);
                    if (object2 == object) {
                        System.err.println("Possible path: [" + n2 + ']');
                        hashSet.add(identityHashCodeWrapper);
                        if (this.findReferencePath(object3, unknownObjectException, hashSet)) {
                            unknownObjectException.appendMessage("[" + n2 + ']');
                            return true;
                        }
                        System.err.println("Backtracking [" + n2 + ']');
                    }
                    ++n2;
                }
                continue;
            }
            Assert._assert(jq_Reference2.isClassType());
            jq_Type2 = (jq_Class)jq_Reference2;
            jq_InstanceField[] jq_InstanceFieldArray = ((jq_Class)jq_Type2).getInstanceFields();
            int n = 0;
            while (n < jq_InstanceFieldArray.length) {
                Object object4;
                jq_InstanceField jq_InstanceField2 = jq_InstanceFieldArray[n];
                object2 = jq_InstanceField2.getType();
                if (!((jq_Type)object2).isAddressType() && ((jq_Type)object2).isReferenceType() && (object4 = Reflection.getfield_A(object3, jq_InstanceField2)) == object) {
                    System.err.println("Possible path: ." + jq_InstanceField2.getName());
                    hashSet.add(identityHashCodeWrapper);
                    if (this.findReferencePath(object3, unknownObjectException, hashSet)) {
                        unknownObjectException.appendMessage("." + jq_InstanceField2.getName());
                        return true;
                    }
                    System.err.println("Backtracking ." + jq_InstanceField2.getName());
                }
                ++n;
            }
        }
        return false;
    }

    private final void dumpHeap(ExtendedDataOutput extendedDataOutput) throws IOException {
        Assert._assert(true);
        Assert._assert(true);
        Assert._assert(true);
        Assert._assert(true);
        Assert._assert(true);
        Iterator iterator = this.entries.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            HeapAddress heapAddress;
            if (n2 % UPDATE_PERIOD == 0) {
                System.out.print("Written: " + n2 + '/' + this.entries.size() + " objects, " + n + '/' + this.heapCurrent + " bytes\r");
            }
            Entry entry = (Entry)iterator.next();
            Object object3 = entry.getObject();
            HeapAddress heapAddress2 = entry.getAddress();
            Class<?> clazz = object3.getClass();
            jq_Reference jq_Reference2 = (jq_Reference)Reflection.getJQType(clazz);
            if (TRACE) {
                out.println("Dumping entry " + n2 + ": " + clazz + ' ' + Strings.hex(System.identityHashCode(object3)) + " addr " + heapAddress2.stringRep());
            }
            Assert._assert(jq_Reference2.isAddressType() ^ true);
            if (!jq_Reference2.isClsInitialized()) {
                Assert.UNREACHABLE(jq_Reference2.toString());
                return;
            }
            try {
                heapAddress = this.getAddressOf(jq_Reference2.getVTable());
            }
            catch (UnknownObjectException unknownObjectException) {
                unknownObjectException.appendMessage("vtable for " + jq_Reference2);
                unknownObjectException.setObject(null);
                throw unknownObjectException;
            }
            if (jq_Reference2.isArrayType()) {
                while (n + 12 < heapAddress2.to32BitValue()) {
                    extendedDataOutput.writeByte(0);
                    ++n;
                }
                int n3 = Array.getLength(object3);
                extendedDataOutput.writeUInt(n3);
                extendedDataOutput.writeUInt(0);
                extendedDataOutput.writeUInt(heapAddress.to32BitValue());
                boolean bl = false;
                if (heapAddress2.to32BitValue() == (n += 12)) {
                    bl = true;
                }
                Assert._assert(bl);
                object2 = ((jq_Array)jq_Reference2).getElementType();
                if (((jq_Type)object2).isPrimitiveType()) {
                    if (object2 == jq_Primitive.INT) {
                        int[] nArray = (int[])object3;
                        int n4 = 0;
                        while (n4 < n3) {
                            extendedDataOutput.writeUInt(nArray[n4]);
                            ++n4;
                        }
                        n += n3 << 2;
                    } else if (object2 == jq_Primitive.FLOAT) {
                        float[] fArray = (float[])object3;
                        int n5 = 0;
                        while (n5 < n3) {
                            extendedDataOutput.writeUInt(Float.floatToRawIntBits(fArray[n5]));
                            ++n5;
                        }
                        n += n3 << 2;
                    } else if (object2 == jq_Primitive.LONG) {
                        long[] lArray = (long[])object3;
                        int n6 = 0;
                        while (n6 < n3) {
                            extendedDataOutput.writeULong(lArray[n6]);
                            ++n6;
                        }
                        n += n3 << 3;
                    } else if (object2 == jq_Primitive.DOUBLE) {
                        double[] dArray = (double[])object3;
                        int n7 = 0;
                        while (n7 < n3) {
                            extendedDataOutput.writeULong(Double.doubleToRawLongBits(dArray[n7]));
                            ++n7;
                        }
                        n += n3 << 3;
                    } else if (object2 == jq_Primitive.BOOLEAN) {
                        boolean[] blArray = (boolean[])object3;
                        int n8 = 0;
                        while (n8 < n3) {
                            extendedDataOutput.writeUByte(blArray[n8]);
                            ++n8;
                        }
                        n += n3;
                    } else if (object2 == jq_Primitive.BYTE) {
                        byte[] byArray = (byte[])object3;
                        int n9 = 0;
                        while (n9 < n3) {
                            extendedDataOutput.writeByte(byArray[n9]);
                            ++n9;
                        }
                        n += n3;
                    } else if (object2 == jq_Primitive.SHORT) {
                        short[] sArray = (short[])object3;
                        int n10 = 0;
                        while (n10 < n3) {
                            extendedDataOutput.writeShort(sArray[n10]);
                            ++n10;
                        }
                        n += n3 << 1;
                    } else if (object2 == jq_Primitive.CHAR) {
                        char[] cArray = (char[])object3;
                        int n11 = 0;
                        while (n11 < n3) {
                            extendedDataOutput.writeUShort(cArray[n11]);
                            ++n11;
                        }
                        n += n3 << 1;
                    } else {
                        Assert.UNREACHABLE();
                    }
                } else if (((jq_Type)object2).isAddressType()) {
                    Address[] addressArray = (Address[])object3;
                    int n12 = 0;
                    while (n12 < n3) {
                        int n13 = 0;
                        if (addressArray[n12] != null) {
                            n13 = addressArray[n12].to32BitValue();
                        }
                        extendedDataOutput.writeUInt(n13);
                        ++n12;
                    }
                    n += n3 << 2;
                } else {
                    Object[] objectArray = (Object[])object3;
                    int n14 = 0;
                    while (n14 < n3) {
                        object = Reflection.arrayload_A(objectArray, n14);
                        try {
                            extendedDataOutput.writeUInt(this.getAddressOf(object).to32BitValue());
                        }
                        catch (UnknownObjectException unknownObjectException) {
                            System.err.println("Object array element #" + n14);
                            throw unknownObjectException;
                        }
                        ++n14;
                    }
                    n += n3 << 2;
                }
            } else {
                Assert._assert(jq_Reference2.isClassType());
                jq_Class jq_Class2 = (jq_Class)jq_Reference2;
                while (n + 8 < heapAddress2.to32BitValue()) {
                    extendedDataOutput.writeByte(0);
                    ++n;
                }
                extendedDataOutput.writeUInt(0);
                extendedDataOutput.writeUInt(heapAddress.to32BitValue());
                boolean bl = false;
                if (heapAddress2.to32BitValue() == (n += 8)) {
                    bl = true;
                }
                Assert._assert(bl);
                object2 = jq_Class2.getInstanceFields();
                int n15 = 0;
                while (n15 < ((Object)object2).length) {
                    Object object4 = object2[n15];
                    object = ((jq_Field)object4).getType();
                    int n16 = ((jq_InstanceField)object4).getOffset();
                    if (TRACE) {
                        out.println("Field " + object4 + " offset " + Strings.shex(n16) + ": " + System.identityHashCode(Reflection.getfield(object3, (jq_InstanceField)object4)));
                    }
                    while (n != heapAddress2.offset(n16).to32BitValue()) {
                        extendedDataOutput.writeByte(0);
                        ++n;
                    }
                    if (((jq_Type)object).isPrimitiveType()) {
                        if (object == jq_Primitive.INT) {
                            extendedDataOutput.writeUInt(Reflection.getfield_I(object3, (jq_InstanceField)object4));
                        } else if (object == jq_Primitive.FLOAT) {
                            extendedDataOutput.writeUInt(Float.floatToRawIntBits(Reflection.getfield_F(object3, (jq_InstanceField)object4)));
                        } else if (object == jq_Primitive.LONG) {
                            extendedDataOutput.writeULong(Reflection.getfield_L(object3, (jq_InstanceField)object4));
                        } else if (object == jq_Primitive.DOUBLE) {
                            extendedDataOutput.writeULong(Double.doubleToRawLongBits(Reflection.getfield_D(object3, (jq_InstanceField)object4)));
                        } else if (object == jq_Primitive.BOOLEAN) {
                            extendedDataOutput.writeUByte(Reflection.getfield_Z(object3, (jq_InstanceField)object4) ? 1 : 0);
                        } else if (object == jq_Primitive.BYTE) {
                            extendedDataOutput.writeByte(Reflection.getfield_B(object3, (jq_InstanceField)object4));
                        } else if (object == jq_Primitive.SHORT) {
                            extendedDataOutput.writeShort(Reflection.getfield_S(object3, (jq_InstanceField)object4));
                        } else if (object == jq_Primitive.CHAR) {
                            extendedDataOutput.writeUShort(Reflection.getfield_C(object3, (jq_InstanceField)object4));
                        } else {
                            Assert.UNREACHABLE();
                        }
                    } else if (((jq_Type)object).isAddressType()) {
                        Address address = Reflection.getfield_P(object3, (jq_InstanceField)object4);
                        int n17 = 0;
                        if (address != null) {
                            n17 = address.to32BitValue();
                        }
                        extendedDataOutput.writeUInt(n17);
                    } else {
                        try {
                            extendedDataOutput.writeUInt(this.getAddressOf(Reflection.getfield_A(object3, (jq_InstanceField)object4)).to32BitValue());
                        }
                        catch (UnknownObjectException unknownObjectException) {
                            System.err.println("Instance field " + object4);
                            throw unknownObjectException;
                        }
                    }
                    n += ((jq_InstanceField)object4).getSize();
                    ++n15;
                }
            }
            ++n2;
        }
        while (n < this.heapCurrent) {
            extendedDataOutput.writeByte(0);
            ++n;
        }
        System.out.println("Written: " + n2 + " objects, " + this.heapCurrent + " bytes                    ");
    }

    public static void write_bytes(ExtendedDataOutput extendedDataOutput, String string, int n) throws IOException {
        boolean bl = false;
        if (string.length() <= n) {
            bl = true;
        }
        Assert._assert(bl);
        int n2 = 0;
        while (true) {
            if (n2 == string.length()) {
                while (n2 < n) {
                    extendedDataOutput.write(0);
                    ++n2;
                }
                return;
            }
            extendedDataOutput.write((byte)string.charAt(n2));
            ++n2;
        }
    }

    private final String mungeMemberName(jq_Member jq_Member2) {
        String string = jq_Member2.getDeclaringClass().getName().toString() + '_' + jq_Member2.getName() + '_' + jq_Member2.getDesc();
        return string;
    }

    private final int alloc_string(String string) {
        int n = this.stringTableOffset;
        byte[] byArray = SystemInterface.toCString(string);
        this.stringTable.add(byArray);
        this.stringTableOffset += byArray.length;
        return n;
    }

    private final void dump_strings(ExtendedDataOutput extendedDataOutput) throws IOException {
        Iterator iterator = this.stringTable.iterator();
        extendedDataOutput.writeUInt(this.stringTableOffset);
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            extendedDataOutput.write(byArray);
        }
    }

    public void dumpELF(ExtendedDataOutput extendedDataOutput, jq_StaticMethod jq_StaticMethod2) throws IOException {
        Object object;
        Object object2;
        List list = this.bca.getAllCodeRelocs();
        List list2 = this.bca.getAllDataRelocs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ((Reloc)e).patch();
            if (!(e instanceof DirectBindCall)) continue;
            iterator.remove();
        }
        System.out.print("Initializing ELF data structures...");
        long l = System.currentTimeMillis();
        ELFOutput eLFOutput = new ELFOutput(1, 1, 3, 0, extendedDataOutput);
        eLFOutput.setLittleEndian();
        Section.NullSection nullSection = Section.NullSection.INSTANCE;
        Section.StrTabSection strTabSection = new Section.StrTabSection(".shstrtab", 0, 0);
        Section.StrTabSection strTabSection2 = new Section.StrTabSection(".strtab", 0, 0);
        Section.SymTabSection symTabSection = new Section.SymTabSection(".symtab", 0, 0, strTabSection2);
        TextSection textSection = new TextSection();
        DataSection dataSection = new DataSection();
        Section.RelSection relSection = new Section.RelSection(".rel.text", 0, 0, symTabSection, textSection);
        Section.RelSection relSection2 = new Section.RelSection(".rel.data", 0, 0, symTabSection, dataSection);
        eLFOutput.setSectionHeaderStringTable(strTabSection);
        eLFOutput.addSection(nullSection);
        eLFOutput.addSection(strTabSection);
        eLFOutput.addSection(strTabSection2);
        eLFOutput.addSection(symTabSection);
        eLFOutput.addSection(textSection);
        eLFOutput.addSection(dataSection);
        eLFOutput.addSection(relSection);
        eLFOutput.addSection(relSection2);
        LinkedList linkedList = new LinkedList();
        int n = this.addVTableRelocs(this.data_relocs);
        this.addSystemInterfaceRelocs_ELF(linkedList, this.data_relocs);
        symTabSection.addSymbol(new SymbolTableEntry("", 0, 0, 0, 0, nullSection));
        SymbolTableEntry symbolTableEntry = new SymbolTableEntry("", 0, 0, 0, 3, textSection);
        SymbolTableEntry symbolTableEntry2 = new SymbolTableEntry("", 0, 0, 0, 3, dataSection);
        symTabSection.addSymbol(symbolTableEntry);
        symTabSection.addSymbol(symbolTableEntry2);
        Iterator iterator2 = linkedList.iterator();
        while (iterator2.hasNext()) {
            object2 = (ExternalReference)iterator2.next();
            object = new SymbolTableEntry(((ExternalReference)object2).getName(), 0, 0, 1, 2, nullSection);
            symTabSection.addSymbol((SymbolTableEntry)object);
            relSection2.addReloc(new RelocEntry(((ExternalReference)object2).getAddress().to32BitValue(), (SymbolTableEntry)object, 1));
        }
        iterator2 = CodeAllocator.getCompiledMethods();
        while (iterator2.hasNext()) {
            object2 = (jq_CompiledCode)iterator2.next();
            object = ((jq_CompiledCode)object2).getMethod();
            String string = object == null ? "unknown@" + ((jq_CompiledCode)object2).getEntrypoint().stringRep() : this.mungeMemberName((jq_Member)object);
            SymbolTableEntry symbolTableEntry3 = new SymbolTableEntry(string, ((jq_CompiledCode)object2).getEntrypoint().to32BitValue(), ((jq_CompiledCode)object2).getLength(), 0, 2, textSection);
            symTabSection.addSymbol(symbolTableEntry3);
        }
        object2 = jq_StaticMethod2.getDefaultCompiledVersion();
        object = new SymbolTableEntry("entry", ((jq_CompiledCode)object2).getEntrypoint().to32BitValue(), ((jq_CompiledCode)object2).getLength(), 1, 2, textSection);
        symTabSection.addSymbol((SymbolTableEntry)object);
        object2 = ExceptionDeliverer._trap_handler.getDefaultCompiledVersion();
        object = new SymbolTableEntry("trap_handler", ((jq_CompiledCode)object2).getEntrypoint().to32BitValue(), ((jq_CompiledCode)object2).getLength(), 1, 2, textSection);
        symTabSection.addSymbol((SymbolTableEntry)object);
        object2 = ExceptionDeliverer._debug_trap_handler.getDefaultCompiledVersion();
        object = new SymbolTableEntry("debug_trap_handler", ((jq_CompiledCode)object2).getEntrypoint().to32BitValue(), ((jq_CompiledCode)object2).getLength(), 1, 2, textSection);
        symTabSection.addSymbol((SymbolTableEntry)object);
        object2 = jq_NativeThread._threadSwitch.getDefaultCompiledVersion();
        object = new SymbolTableEntry("threadSwitch", ((jq_CompiledCode)object2).getEntrypoint().to32BitValue(), ((jq_CompiledCode)object2).getLength(), 1, 2, textSection);
        symTabSection.addSymbol((SymbolTableEntry)object);
        object2 = jq_NativeThread._ctrl_break_handler.getDefaultCompiledVersion();
        object = new SymbolTableEntry("ctrl_break_handler", ((jq_CompiledCode)object2).getEntrypoint().to32BitValue(), ((jq_CompiledCode)object2).getLength(), 1, 2, textSection);
        symTabSection.addSymbol((SymbolTableEntry)object);
        object = new SymbolTableEntry("joeq_code_startaddress", 0, 0, 1, 1, textSection);
        symTabSection.addSymbol((SymbolTableEntry)object);
        object = new SymbolTableEntry("joeq_data_startaddress", 0, 0, 1, 1, dataSection);
        symTabSection.addSymbol((SymbolTableEntry)object);
        iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            object2 = (Reloc)iterator2.next();
            if (object2 instanceof Code2CodeReference) {
                object = (Code2CodeReference)object2;
                relSection.addReloc(new RelocEntry(((Code2CodeReference)object).getFrom().to32BitValue(), symbolTableEntry2, 1));
                continue;
            }
            Assert.UNREACHABLE(object2.toString());
        }
        iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            object2 = (Reloc)iterator2.next();
            if (object2 instanceof Code2HeapReference) {
                object = (Code2HeapReference)object2;
                relSection.addReloc(new RelocEntry(((Code2HeapReference)object).getFrom().to32BitValue(), symbolTableEntry2, 1));
                continue;
            }
            Assert.UNREACHABLE(object2.toString());
        }
        iterator2 = this.data_relocs.iterator();
        while (iterator2.hasNext()) {
            object2 = (Reloc)iterator2.next();
            if (object2 instanceof Heap2HeapReference) {
                object = (Heap2HeapReference)object2;
                relSection2.addReloc(new RelocEntry(((Heap2HeapReference)object).getFrom().to32BitValue(), symbolTableEntry2, 1));
                continue;
            }
            if (object2 instanceof Heap2CodeReference) {
                object = (Heap2CodeReference)object2;
                relSection2.addReloc(new RelocEntry(((Heap2CodeReference)object).getFrom().to32BitValue(), symbolTableEntry, 1));
                continue;
            }
            if (object2 instanceof ExternalReference) continue;
            Assert.UNREACHABLE(object2.toString());
        }
        l = System.currentTimeMillis() - l;
        System.out.println("done. (" + (double)l / 1000.0 + " seconds)");
        eLFOutput.write();
    }

    private final /* synthetic */ void this() {
        this.alloc_enabled = false;
        this.stringTableOffset = 4;
        this.stringTable = new LinkedList();
    }

    public BootImage(BootstrapCodeAllocator bootstrapCodeAllocator, int n, float f) {
        this.this();
        this.hash = new HashMap(n, f);
        this.entries = new ArrayList(n);
        this.bca = bootstrapCodeAllocator;
        this.startAddress = 0;
        this.heapCurrent = 0;
        this.data_relocs = new LinkedList();
    }

    public BootImage(BootstrapCodeAllocator bootstrapCodeAllocator, int n) {
        this.this();
        this.hash = new HashMap(n);
        this.entries = new ArrayList(n);
        this.bca = bootstrapCodeAllocator;
        this.startAddress = 0;
        this.heapCurrent = 0;
        this.data_relocs = new LinkedList();
    }

    public BootImage(BootstrapCodeAllocator bootstrapCodeAllocator) {
        this.this();
        this.hash = new HashMap();
        this.entries = new ArrayList();
        this.bca = bootstrapCodeAllocator;
        this.startAddress = 0;
        this.heapCurrent = 0;
        this.data_relocs = new LinkedList();
    }

    static {
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LBootstrap/BootImage;");
        _DEFAULT = jq_Class2.getOrCreateStaticField("DEFAULT", "LBootstrap/BootImage;");
    }

    private static class Entry {
        private Object o;
        private HeapAddress address;

        static Entry create(Object object, HeapAddress heapAddress) {
            boolean bl = false;
            if (object != null) {
                bl = true;
            }
            Assert._assert(bl);
            return new Entry(object, heapAddress);
        }

        Object getObject() {
            return this.o;
        }

        HeapAddress getAddress() {
            return this.address;
        }

        private Entry(Object object, HeapAddress heapAddress) {
            this.o = object;
            this.address = heapAddress;
        }
    }

    static class UnknownObjectException
    extends RuntimeException {
        Object o;
        StringBuffer message;

        void setObject(Object object) {
            this.o = object;
        }

        Object getObject() {
            return this.o;
        }

        void prependMessage(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(this.message);
            this.message = stringBuffer;
        }

        void appendMessage(String string) {
            this.message.append(string);
        }

        public String toString() {
            return this.message.toString();
        }

        UnknownObjectException(Object object) {
            this.o = object;
            this.message = new StringBuffer();
            this.message.append("type: ");
            this.message.append(object.getClass().toString());
            this.message.append(" address: ");
            this.message.append(Strings.hex(System.identityHashCode(object)));
            this.message.append(' ');
        }
    }

    class TextSection
    extends Section.ProgBitsSection {
        public int getSize() {
            return BootImage.this.bca.size();
        }

        public int getAddrAlign() {
            return 64;
        }

        public void writeData(ELF eLF) throws IOException {
            ExtendedDataOutput extendedDataOutput = (ExtendedDataOutput)((ELFOutput)eLF).getOutput();
            BootImage.this.bca.dump(extendedDataOutput);
        }

        public void load(Section.UnloadedSection unloadedSection, ELF eLF) throws IOException {
            Assert.UNREACHABLE();
        }

        TextSection() {
            super(".text", 7, 0);
        }
    }

    class DataSection
    extends Section.ProgBitsSection {
        public int getSize() {
            return BootImage.this.heapCurrent;
        }

        public int getAddrAlign() {
            return 64;
        }

        public void writeData(ELF eLF) throws IOException {
            try {
                ExtendedDataOutput extendedDataOutput = (ExtendedDataOutput)((ELFOutput)eLF).getOutput();
                BootImage.this.dumpHeap(extendedDataOutput);
            }
            catch (UnknownObjectException unknownObjectException) {
                Object object = unknownObjectException.getObject();
                HashSet hashSet = new HashSet();
                BootImage.this.findReferencePath(object, unknownObjectException, hashSet);
                throw unknownObjectException;
            }
        }

        public void load(Section.UnloadedSection unloadedSection, ELF eLF) throws IOException {
            Assert.UNREACHABLE();
        }

        DataSection() {
            super(".data", 3, 0);
        }
    }
}

