/*
 * Decompiled with CFR 0.152.
 */
package Bootstrap;

import Allocator.CodeAllocator;
import Bootstrap.BootstrapCodeAddress;
import Clazz.jq_BytecodeMap;
import Clazz.jq_CompiledCode;
import Clazz.jq_Method;
import Clazz.jq_TryCatch;
import Memory.Address;
import Memory.CodeAddress;
import Run_Time.ExceptionDeliverer;
import Util.Assert;
import Util.Convert;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class BootstrapCodeAllocator
extends CodeAllocator {
    public static final BootstrapCodeAllocator DEFAULT = new BootstrapCodeAllocator();
    private static final int bundle_shift = 12;
    private static final int bundle_size = 4096;
    private static final int bundle_mask = 4095;
    private Vector bundles;
    private byte[] current_bundle;
    private int bundle_idx;
    private int idx;
    private List all_code_relocs;
    private List all_data_relocs;

    public void init() {
        if (TRACE) {
            System.out.println("Initializing " + this);
        }
        this.bundles = new Vector();
        this.current_bundle = new byte[4096];
        this.bundles.addElement(this.current_bundle);
        this.bundle_idx = 0;
        this.idx = -1;
        this.all_code_relocs = new LinkedList();
        this.all_data_relocs = new LinkedList();
    }

    public CodeAllocator.x86CodeBuffer getCodeBuffer(int n, int n2, int n3) {
        int n4 = this.size() + n2;
        if (n3 > 1) {
            n4 += n3 - 1;
            n4 &= ~(n3 - 1);
        }
        this.idx += n4 - n2 - this.size();
        return new Bootstrapx86CodeBuffer(n4 - n2, n);
    }

    public int size() {
        return 4096 * this.bundle_idx + this.idx + 1;
    }

    public void ensureCapacity(int n) {
        int n2 = n >> 12;
        while (n2 + 1 >= this.bundles.size()) {
            this.bundles.addElement(new byte[4096]);
        }
    }

    public List getAllCodeRelocs() {
        return this.all_code_relocs;
    }

    public List getAllDataRelocs() {
        return this.all_data_relocs;
    }

    public void dump(DataOutput dataOutput) throws IOException {
        int n = 0;
        while (n < this.bundle_idx) {
            byte[] byArray = (byte[])this.bundles.elementAt(n);
            dataOutput.write(byArray);
            ++n;
        }
        dataOutput.write(this.current_bundle, 0, this.idx + 1);
    }

    public void patchAbsolute(Address address, Address address2) {
        this.poke((CodeAddress)address, address2);
    }

    public void patchRelativeOffset(CodeAddress codeAddress, CodeAddress codeAddress2) {
        this.poke4(codeAddress, codeAddress2.difference(codeAddress) - 4);
    }

    public void poke(CodeAddress codeAddress, Address address) {
        this.poke4(codeAddress, address.to32BitValue());
    }

    public void poke1(CodeAddress codeAddress, byte by) {
        int n = codeAddress.to32BitValue();
        int n2 = n >> 12;
        int n3 = n & 0xFFF;
        byte[] byArray = (byte[])this.bundles.elementAt(n2);
        byArray[n3] = by;
    }

    public void poke2(CodeAddress codeAddress, short s) {
        this.poke1(codeAddress, (byte)s);
        this.poke1((CodeAddress)codeAddress.offset(1), (byte)(s >> 8));
    }

    public void poke4(CodeAddress codeAddress, int n) {
        this.poke2(codeAddress, (short)n);
        this.poke2((CodeAddress)codeAddress.offset(2), (short)(n >> 16));
    }

    public void poke8(CodeAddress codeAddress, long l) {
        this.poke4(codeAddress, (int)l);
        this.poke4((CodeAddress)codeAddress.offset(4), (int)(l >> 32));
    }

    public Address peek(CodeAddress codeAddress) {
        return new BootstrapCodeAddress(this.peek4(codeAddress));
    }

    public byte peek1(CodeAddress codeAddress) {
        int n = codeAddress.to32BitValue();
        int n2 = n >> 12;
        int n3 = n & 0xFFF;
        byte[] byArray = (byte[])this.bundles.elementAt(n2);
        return byArray[n3];
    }

    public short peek2(CodeAddress codeAddress) {
        return Convert.twoBytesToShort(this.peek1(codeAddress), this.peek1((CodeAddress)codeAddress.offset(1)));
    }

    public int peek4(CodeAddress codeAddress) {
        return Convert.fourBytesToInt(this.peek1(codeAddress), this.peek1((CodeAddress)codeAddress.offset(1)), this.peek1((CodeAddress)codeAddress.offset(2)), this.peek1((CodeAddress)codeAddress.offset(3)));
    }

    public long peek8(CodeAddress codeAddress) {
        return Convert.twoIntsToLong(this.peek4(codeAddress), this.peek4((CodeAddress)codeAddress.offset(4)));
    }

    public class Bootstrapx86CodeBuffer
    extends CodeAllocator.x86CodeBuffer {
        private int startIndex;
        private int entryIndex;

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEntryIndex() {
            return this.entryIndex;
        }

        public int getCurrentOffset() {
            return BootstrapCodeAllocator.this.size() - this.startIndex;
        }

        public CodeAddress getStartAddress() {
            return new BootstrapCodeAddress(this.getStartIndex());
        }

        public CodeAddress getCurrentAddress() {
            return new BootstrapCodeAddress(BootstrapCodeAllocator.this.size());
        }

        public void setEntrypoint() {
            this.entryIndex = BootstrapCodeAllocator.this.size();
        }

        public void checkSize() {
            if (BootstrapCodeAllocator.this.idx >= 4095) {
                if (BootstrapCodeAllocator.this.bundle_idx < BootstrapCodeAllocator.this.bundles.size() - 1) {
                    if (TRACE) {
                        System.out.println("getting next bundle idx " + (BootstrapCodeAllocator.this.bundle_idx + 1));
                    }
                    Vector vector = BootstrapCodeAllocator.this.bundles;
                    BootstrapCodeAllocator bootstrapCodeAllocator = BootstrapCodeAllocator.this;
                    int n = bootstrapCodeAllocator.bundle_idx + 1;
                    bootstrapCodeAllocator.bundle_idx = n;
                    BootstrapCodeAllocator.this.current_bundle = (byte[])vector.get(n);
                    BootstrapCodeAllocator bootstrapCodeAllocator2 = BootstrapCodeAllocator.this;
                    bootstrapCodeAllocator2.idx = bootstrapCodeAllocator2.idx - 4096;
                } else {
                    if (TRACE) {
                        System.out.println("allocing new bundle idx " + (BootstrapCodeAllocator.this.bundle_idx + 1));
                    }
                    Vector vector = BootstrapCodeAllocator.this.bundles;
                    byte[] byArray = new byte[4096];
                    BootstrapCodeAllocator.this.current_bundle = byArray;
                    vector.addElement(byArray);
                    BootstrapCodeAllocator bootstrapCodeAllocator = BootstrapCodeAllocator.this;
                    bootstrapCodeAllocator.bundle_idx = bootstrapCodeAllocator.bundle_idx + 1;
                    BootstrapCodeAllocator bootstrapCodeAllocator3 = BootstrapCodeAllocator.this;
                    bootstrapCodeAllocator3.idx = bootstrapCodeAllocator3.idx - 4096;
                }
            }
        }

        public void add1(byte by) {
            this.checkSize();
            byte[] byArray = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator = BootstrapCodeAllocator.this;
            int n = bootstrapCodeAllocator.idx + 1;
            bootstrapCodeAllocator.idx = n;
            byArray[n] = by;
        }

        public void add2_endian(int n) {
            this.checkSize();
            byte[] byArray = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator = BootstrapCodeAllocator.this;
            int n2 = bootstrapCodeAllocator.idx + 1;
            bootstrapCodeAllocator.idx = n2;
            byArray[n2] = (byte)n;
            this.checkSize();
            byte[] byArray2 = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator2 = BootstrapCodeAllocator.this;
            int n3 = bootstrapCodeAllocator2.idx + 1;
            bootstrapCodeAllocator2.idx = n3;
            byArray2[n3] = (byte)(n >> 8);
        }

        public void add2(int n) {
            this.checkSize();
            byte[] byArray = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator = BootstrapCodeAllocator.this;
            int n2 = bootstrapCodeAllocator.idx + 1;
            bootstrapCodeAllocator.idx = n2;
            byArray[n2] = (byte)(n >> 8);
            this.checkSize();
            byte[] byArray2 = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator2 = BootstrapCodeAllocator.this;
            int n3 = bootstrapCodeAllocator2.idx + 1;
            bootstrapCodeAllocator2.idx = n3;
            byArray2[n3] = (byte)n;
        }

        public void add3(int n) {
            this.checkSize();
            byte[] byArray = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator = BootstrapCodeAllocator.this;
            int n2 = bootstrapCodeAllocator.idx + 1;
            bootstrapCodeAllocator.idx = n2;
            byArray[n2] = (byte)(n >> 16);
            this.checkSize();
            byte[] byArray2 = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator2 = BootstrapCodeAllocator.this;
            int n3 = bootstrapCodeAllocator2.idx + 1;
            bootstrapCodeAllocator2.idx = n3;
            byArray2[n3] = (byte)(n >> 8);
            this.checkSize();
            byte[] byArray3 = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator3 = BootstrapCodeAllocator.this;
            int n4 = bootstrapCodeAllocator3.idx + 1;
            bootstrapCodeAllocator3.idx = n4;
            byArray3[n4] = (byte)n;
        }

        public void add4_endian(int n) {
            this.checkSize();
            byte[] byArray = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator = BootstrapCodeAllocator.this;
            int n2 = bootstrapCodeAllocator.idx + 1;
            bootstrapCodeAllocator.idx = n2;
            byArray[n2] = (byte)n;
            this.checkSize();
            byte[] byArray2 = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator2 = BootstrapCodeAllocator.this;
            int n3 = bootstrapCodeAllocator2.idx + 1;
            bootstrapCodeAllocator2.idx = n3;
            byArray2[n3] = (byte)(n >> 8);
            this.checkSize();
            byte[] byArray3 = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator3 = BootstrapCodeAllocator.this;
            int n4 = bootstrapCodeAllocator3.idx + 1;
            bootstrapCodeAllocator3.idx = n4;
            byArray3[n4] = (byte)(n >> 16);
            this.checkSize();
            byte[] byArray4 = BootstrapCodeAllocator.this.current_bundle;
            BootstrapCodeAllocator bootstrapCodeAllocator4 = BootstrapCodeAllocator.this;
            int n5 = bootstrapCodeAllocator4.idx + 1;
            bootstrapCodeAllocator4.idx = n5;
            byArray4[n5] = (byte)(n >> 24);
        }

        public byte get1(int n) {
            return BootstrapCodeAllocator.this.peek1(new BootstrapCodeAddress(n + this.startIndex));
        }

        public int get4_endian(int n) {
            return BootstrapCodeAllocator.this.peek4(new BootstrapCodeAddress(n + this.startIndex));
        }

        public void put1(int n, byte by) {
            BootstrapCodeAllocator.this.poke1(new BootstrapCodeAddress(n + this.startIndex), by);
        }

        public void put4_endian(int n, int n2) {
            BootstrapCodeAllocator.this.poke4(new BootstrapCodeAddress(n + this.startIndex), n2);
        }

        public void skip(int n) {
            boolean bl = false;
            if (n < 4096) {
                bl = true;
            }
            Assert._assert(bl);
            BootstrapCodeAllocator bootstrapCodeAllocator = BootstrapCodeAllocator.this;
            bootstrapCodeAllocator.idx = bootstrapCodeAllocator.idx + n;
        }

        public jq_CompiledCode allocateCodeBlock(jq_Method jq_Method2, jq_TryCatch[] jq_TryCatchArray, jq_BytecodeMap jq_BytecodeMap2, ExceptionDeliverer exceptionDeliverer, int n, List list, List list2) {
            int n2 = this.getCurrentOffset();
            int n3 = this.getStartIndex();
            int n4 = this.getEntryIndex();
            if (list != null) {
                BootstrapCodeAllocator.this.all_code_relocs.addAll(list);
            }
            if (list2 != null) {
                BootstrapCodeAllocator.this.all_data_relocs.addAll(list2);
            }
            jq_CompiledCode jq_CompiledCode2 = new jq_CompiledCode(jq_Method2, new BootstrapCodeAddress(n3), n2, new BootstrapCodeAddress(n4), jq_TryCatchArray, jq_BytecodeMap2, exceptionDeliverer, n, list, list2);
            CodeAllocator.registerCode(jq_CompiledCode2);
            return jq_CompiledCode2;
        }

        Bootstrapx86CodeBuffer(int n, int n2) {
            this.startIndex = n;
            BootstrapCodeAllocator.this.ensureCapacity(n + n2);
        }
    }
}

