/*
 * Decompiled with CFR 0.152.
 */
package Bootstrap;

import ClassLib.ClassLibInterface;
import Clazz.jq_Class;
import Clazz.jq_InstanceField;
import Clazz.jq_StaticField;
import Main.jq;
import Run_Time.Reflection;
import UTF.Utf8;
import Util.Assert;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Iterator;

public abstract class ObjectTraverser {
    public static boolean TRACE = false;
    public static final PrintStream out = System.out;
    public static final Object NO_OBJECT = new Object();

    public abstract void initialize();

    public abstract Object mapStaticField(jq_StaticField var1);

    public abstract Object mapInstanceField(Object var1, jq_InstanceField var2);

    public abstract Object mapValue(Object var1);

    public Object getStaticFieldValue(jq_StaticField jq_StaticField2) {
        String string;
        Class clazz;
        Object object;
        if (jq.IsBootstrapping && (object = this.mapStaticField(jq_StaticField2)) != NO_OBJECT) {
            return this.mapValue(object);
        }
        if (TRACE) {
            out.println("Getting value of static field " + jq_StaticField2 + " via reflection");
        }
        if ((object = (Field)jq_StaticField2.getJavaLangReflectMemberObject()) == null && (object = ObjectTraverser.lookupField(clazz = Reflection.getJDKType(jq_StaticField2.getDeclaringClass()), string = jq_StaticField2.getName().toString())) == null) {
            out.println("Cannot find static field " + jq_StaticField2);
            return null;
        }
        return this.getStaticFieldValue_reflection((Field)object);
    }

    public static Field lookupField(Class clazz, String string) {
        Field field = Reflection.getJDKField(clazz, string);
        if (field == null) {
            jq_Class jq_Class2 = (jq_Class)Reflection.getJQType(clazz);
            Iterator iterator = ClassLibInterface.DEFAULT.getImplementationClassDescs(jq_Class2.getDesc());
            while (iterator.hasNext()) {
                Utf8 utf8 = (Utf8)iterator.next();
                if (TRACE) {
                    out.println("Checking mirror class " + utf8);
                }
                String string2 = utf8.toString();
                boolean bl = false;
                if (string2.charAt(0) == 'L') {
                    bl = true;
                }
                Assert._assert(bl);
                try {
                    clazz = Class.forName(string2.substring(1, string2.length() - 1).replace('/', '.'));
                    field = Reflection.getJDKField(clazz, string);
                    if (field == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!TRACE) continue;
                    out.println("Mirror class " + string2 + " doesn't exist");
                }
            }
        }
        return field;
    }

    public Object getStaticFieldValue_reflection(Field field) {
        field.setAccessible(true);
        boolean bl = false;
        if ((field.getModifiers() & 8) != 0) {
            bl = true;
        }
        Assert._assert(bl);
        try {
            Object object = field.get(null);
            if (jq.IsBootstrapping) {
                object = this.mapValue(object);
            }
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.UNREACHABLE();
            return null;
        }
    }

    public Object getInstanceFieldValue(Object object, jq_InstanceField jq_InstanceField2) {
        String string;
        Class clazz;
        Object object2;
        if (jq.IsBootstrapping && (object2 = this.mapInstanceField(object, jq_InstanceField2)) != NO_OBJECT) {
            return this.mapValue(object2);
        }
        if (TRACE) {
            out.println("Getting value of instance field " + jq_InstanceField2 + " via reflection");
        }
        if ((object2 = (Field)jq_InstanceField2.getJavaLangReflectMemberObject()) == null && (object2 = ObjectTraverser.lookupField(clazz = Reflection.getJDKType(jq_InstanceField2.getDeclaringClass()), string = jq_InstanceField2.getName().toString())) == null) {
            out.println("Cannot find instance field " + jq_InstanceField2);
            return null;
        }
        return this.getInstanceFieldValue_reflection(object, (Field)object2);
    }

    public Object getInstanceFieldValue_reflection(Object object, Field field) {
        field.setAccessible(true);
        boolean bl = false;
        if ((field.getModifiers() & 8) == 0) {
            bl = true;
        }
        Assert._assert(bl);
        try {
            Object object2 = field.get(object);
            if (jq.IsBootstrapping) {
                object2 = this.mapValue(object2);
            }
            return object2;
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.UNREACHABLE();
            return null;
        }
    }

    public void putStaticFieldValue(jq_StaticField jq_StaticField2, Object object) {
        Field field = (Field)jq_StaticField2.getJavaLangReflectMemberObject();
        if (field == null) {
            Class clazz = Reflection.getJDKType(jq_StaticField2.getDeclaringClass());
            String string = jq_StaticField2.getName().toString();
            field = ObjectTraverser.lookupField(clazz, string);
        }
        this.putStaticFieldValue_reflection(field, object);
    }

    public void putStaticFieldValue_reflection(Field field, Object object) {
        if (TRACE) {
            out.println("Setting value of static field " + field + " via reflection");
        }
        field.setAccessible(true);
        boolean bl = false;
        if ((field.getModifiers() & 8) != 0) {
            bl = true;
        }
        Assert._assert(bl);
        try {
            field.set(null, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.UNREACHABLE();
        }
    }

    public void putInstanceFieldValue(Object object, jq_InstanceField jq_InstanceField2, Object object2) {
        Field field = (Field)jq_InstanceField2.getJavaLangReflectMemberObject();
        if (field == null) {
            Class clazz = Reflection.getJDKType(jq_InstanceField2.getDeclaringClass());
            String string = jq_InstanceField2.getName().toString();
            field = ObjectTraverser.lookupField(clazz, string);
        }
        this.putInstanceFieldValue_reflection(object, field, object2);
    }

    public void putInstanceFieldValue_reflection(Object object, Field field, Object object2) {
        if (TRACE) {
            out.println("Setting value of static field " + field + " via reflection");
        }
        field.setAccessible(true);
        boolean bl = false;
        if ((field.getModifiers() & 8) == 0) {
            bl = true;
        }
        Assert._assert(bl);
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.UNREACHABLE();
        }
    }
}

