/*
 * Decompiled with CFR 0.152.
 */
package ClassLib;

import Bootstrap.PrimordialClassLoader;
import ClassLib.Common.Interface;
import ClassLib.Common.NullInterfaceImpl;
import Clazz.jq_Class;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Member;
import Clazz.jq_NameAndDesc;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Main.jq;
import Run_Time.Debug;
import UTF.Utf8;
import Util.Assert;
import java.io.IOException;
import java.util.zip.Inflater;
import java.util.zip.ZipFile;

public abstract class ClassLibInterface {
    public static boolean USE_JOEQ_CLASSLIB;
    public static final Interface DEFAULT;
    public static final jq_Class _class;
    public static boolean TRACE;
    static /* synthetic */ Class class$ClassLib$ClassLibInterface;

    public static final void useJoeqClasslib(boolean bl) {
        USE_JOEQ_CLASSLIB = bl;
    }

    private static final Interface attemptClassLibInterface(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (Interface)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find class library interface " + string + ": " + classNotFoundException);
            System.err.println("Please check the version of your virtual machine.");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Cannot instantiate class library interface " + string + ": " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access class library interface " + string + ": " + illegalAccessException);
        }
        return null;
    }

    public static jq_NameAndDesc convertClassLibNameAndDesc(jq_Class jq_Class2, jq_NameAndDesc jq_NameAndDesc2) {
        String string;
        Utf8 utf8 = ClassLibInterface.convertClassLibDesc(jq_NameAndDesc2.getDesc());
        Utf8 utf82 = jq_NameAndDesc2.getName();
        if (jq_Class2.getDesc().toString().endsWith("/java/lang/Object;") && (string = utf82.toString()).charAt(0) == '_') {
            utf82 = Utf8.get(string.substring(1));
            if (TRACE) {
                Debug.writeln("special case for java.lang.Object: " + utf82 + ' ' + utf8);
            }
            return new jq_NameAndDesc(utf82, utf8);
        }
        if (utf8 == jq_NameAndDesc2.getDesc()) {
            return jq_NameAndDesc2;
        }
        return new jq_NameAndDesc(utf82, utf8);
    }

    public static Utf8 convertClassLibDesc(Utf8 utf8) {
        return Utf8.get(ClassLibInterface.convertClassLibDesc(utf8.toString()));
    }

    public static String convertClassLibDesc(String string) {
        int n = string.indexOf("ClassLib/");
        if (n != -1) {
            int n2;
            int n3;
            while ((n3 = string.indexOf(59, n + 10)) != -1 && (n2 = string.indexOf(47, n + 10)) != -1 && n2 <= n3) {
                int n4 = string.indexOf(59, n2);
                String string2 = string.substring(n2 + 1, n4).replace('/', '.');
                try {
                    Class clazz = class$ClassLib$ClassLibInterface;
                    if (clazz == null) {
                        clazz = ClassLibInterface.class$("[LClassLib.ClassLibInterface;", false);
                    }
                    Class.forName(string2, false, clazz.getClassLoader());
                    string = string.substring(0, n) + string.substring(n2 + 1);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if ((n = string.indexOf("ClassLib/", n + 1)) != -1) continue;
                break;
            }
        }
        return string;
    }

    public static jq_Member convertClassLibCPEntry(jq_Member jq_Member2) {
        jq_NameAndDesc jq_NameAndDesc2 = ClassLibInterface.convertClassLibNameAndDesc(jq_Member2.getDeclaringClass(), jq_Member2.getNameAndDesc());
        Utf8 utf8 = ClassLibInterface.convertClassLibDesc(jq_Member2.getDeclaringClass().getDesc());
        if (jq_NameAndDesc2 == jq_Member2.getNameAndDesc() && utf8 == jq_Member2.getDeclaringClass().getDesc()) {
            return jq_Member2;
        }
        jq_Class jq_Class2 = utf8 != jq_Member2.getDeclaringClass().getDesc() ? (jq_Class)PrimordialClassLoader.getOrCreateType(jq_Member2.getDeclaringClass().getClassLoader(), utf8) : jq_Member2.getDeclaringClass();
        if (jq_Member2 instanceof jq_InstanceField) {
            return jq_Class2.getOrCreateInstanceField(jq_NameAndDesc2);
        }
        if (jq_Member2 instanceof jq_StaticField) {
            return jq_Class2.getOrCreateStaticField(jq_NameAndDesc2);
        }
        if (jq_Member2 instanceof jq_InstanceMethod) {
            return jq_Class2.getOrCreateInstanceMethod(jq_NameAndDesc2);
        }
        if (jq_Member2 instanceof jq_StaticMethod) {
            return jq_Class2.getOrCreateStaticMethod(jq_NameAndDesc2);
        }
        Assert.UNREACHABLE();
        return null;
    }

    public static jq_Reference convertClassLibCPEntry(jq_Reference jq_Reference2) {
        Utf8 utf8 = ClassLibInterface.convertClassLibDesc(jq_Reference2.getDesc());
        if (utf8 == jq_Reference2.getDesc()) {
            return jq_Reference2;
        }
        return (jq_Reference)PrimordialClassLoader.getOrCreateType(jq_Reference2.getClassLoader(), utf8);
    }

    public static void init_zipfile_static(ZipFile zipFile, String string) {
        try {
            DEFAULT.init_zipfile(zipFile, string);
        }
        catch (IOException iOException) {
            System.err.println("Note: cannot reopen zip file " + string);
            try {
                zipFile.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
    }

    public static void init_inflater_static(Inflater inflater, boolean bl) throws IOException {
        DEFAULT.init_inflater(inflater, bl);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Interface interface_ = null;
        String string = System.getProperty("joeq.classlibinterface");
        boolean bl = jq.nullVM;
        if (string != null) {
            interface_ = ClassLibInterface.attemptClassLibInterface(string);
        }
        if (bl) {
            interface_ = new NullInterfaceImpl();
        }
        if (interface_ == null) {
            String string2 = System.getProperty("classlibrary");
            if (string2 == null) {
                String string3 = System.getProperty("java.vm.vendor");
                String string4 = System.getProperty("java.runtime.version");
                String string5 = System.getProperty("os.arch");
                String string6 = System.getProperty("os.name");
                if (!string5.equals("x86") && !string5.equals("i386")) {
                    System.err.println("Warning: architecture " + string5 + " is not yet supported.");
                }
                if (string3.equals("Sun Microsystems Inc.")) {
                    if (string4.equals("1.3.1_01")) {
                        string2 = "sun13_";
                    } else if (string4.equals("1.4.0-b92")) {
                        string2 = "sun14_";
                    } else if (string4.startsWith("1.4.2")) {
                        string2 = "sun142_";
                    } else {
                        string2 = string4.startsWith("1.4") ? "sun14_" : "sun13_";
                        System.err.println("Warning: class library version " + string4 + " is not yet supported, trying default " + string2);
                    }
                } else if (string3.equals("IBM Corporation")) {
                    if (string4.equals("1.3.0")) {
                        string2 = "ibm13_";
                    } else {
                        string2 = "ibm13_";
                        System.err.println("Warning: class library version " + string4 + " is not yet supported, trying default " + string2);
                    }
                } else if (string3.equals("Apple Computer, Inc.")) {
                    if (string4.equals("1.3.1")) {
                        string2 = "apple13_";
                    } else {
                        string2 = "apple13_";
                        System.err.println("Warning: class library version " + string4 + " is not yet supported, trying default " + string2);
                    }
                } else {
                    string2 = "sun13_";
                    System.err.println("Warning: vm vendor " + string3 + " is not yet supported, trying default " + string2);
                }
                if (string6.startsWith("Windows")) {
                    string2 = string2 + "win32";
                } else if (string6.equals("Linux")) {
                    string2 = string2 + "linux";
                } else if (string6.equals("Mac OS X")) {
                    string2 = string2 + "osx";
                } else {
                    string2 = string2 + "win32";
                    System.err.println("Warning: OS " + string6 + " is not yet supported, trying " + string2);
                }
            }
            interface_ = ClassLibInterface.attemptClassLibInterface("ClassLib." + string2 + ".Interface");
        }
        if (interface_ == null) {
            interface_ = new NullInterfaceImpl();
        }
        DEFAULT = interface_;
        _class = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LClassLib/ClassLibInterface;");
        TRACE = false;
    }
}

