/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.io;

import Bootstrap.MethodInvocation;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_DontAlign;
import Clazz.jq_NameAndDesc;
import Clazz.jq_StaticMethod;
import Main.jq;
import Memory.Address;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Util.Assert;
import java.io.File;
import java.io.IOException;

public abstract class UnixFileSystem {
    static final int S_IFMT = 61440;
    static final int S_IFSOCK = 49152;
    static final int S_IFLNK = 40960;
    static final int S_IFREG = 32768;
    static final int S_IFBLK = 24576;
    static final int S_IFDIR = 16384;
    static final int S_IFCHR = 8192;
    static final int S_IFIFO = 4096;
    static final int S_ISUID = 2048;
    static final int S_ISGID = 1024;
    static final int S_ISVTX = 512;
    static final int S_IRWXU = 448;
    static final int S_IRUSR = 256;
    static final int S_IWUSR = 128;
    static final int S_IXUSR = 64;
    static final int S_IRWXG = 56;
    static final int S_IRGRP = 32;
    static final int S_IWGRP = 16;
    static final int S_IXGRP = 8;
    static final int S_IRWXO = 7;
    static final int S_IROTH = 4;
    static final int S_IWOTH = 2;
    static final int S_IXOTH = 1;
    public static final int BA_EXISTS = 1;
    public static final int BA_REGULAR = 2;
    public static final int BA_DIRECTORY = 4;
    public static final int BA_HIDDEN = 8;
    static final int R_OK = 4;
    static final int W_OK = 2;
    static final int X_OK = 1;
    static final int F_OK = 0;
    public static SystemInterface.ExternalLink _access;

    public long getLength(File file) {
        return SystemInterface.fs_stat_size(file.getPath());
    }

    public boolean delete(File file) {
        int n = SystemInterface.fs_remove(file.getPath());
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public long getLastModifiedTime(File file) {
        long l = SystemInterface.fs_getfiletime(file.getPath());
        return l;
    }

    public boolean rename(File file, File file2) {
        int n = SystemInterface.fs_rename(file.getPath(), file2.getPath());
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public String[] list(File file) {
        String[] stringArray;
        Address address;
        int n = SystemInterface.fs_opendir(file.getPath());
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[16];
        int n2 = 0;
        while (!(address = SystemInterface.fs_readdir(n)).isNull()) {
            if (n2 == stringArray2.length) {
                stringArray = new String[stringArray2.length << 1];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                stringArray2 = stringArray;
            }
            stringArray2[n2] = SystemInterface.fromCString(address.offset(11));
            if (stringArray2[n2].equals(".") || stringArray2[n2].equals("..")) {
                --n2;
            }
            ++n2;
        }
        SystemInterface.fs_closedir(n);
        stringArray = new String[n2];
        System.arraycopy(stringArray2, 0, stringArray, 0, n2);
        return stringArray;
    }

    public boolean createDirectory(File file) {
        int n = SystemInterface.fs_mkdir(file.getPath());
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean setLastModifiedTime(File file, long l) {
        int n = SystemInterface.fs_setfiletime(file.getPath(), l);
        boolean bl = false;
        if (n != 0) {
            bl = true;
        }
        return bl;
    }

    public String canonicalize(String string) throws IOException {
        return string;
    }

    public int getBooleanAttributes0(File file) {
        linux_stat linux_stat2 = new linux_stat();
        int n = SystemInterface.file_stat(file.getPath(), linux_stat2);
        if (n != 0) {
            return 0;
        }
        int n2 = 1;
        if ((linux_stat2.st_mode & 0x4000) != 0) {
            n2 |= 4;
        }
        if ((linux_stat2.st_mode & 0x8000) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    public static int access(String string, int n) {
        if (_access == null) {
            return -1;
        }
        byte[] byArray = SystemInterface.toCString(string);
        try {
            CodeAddress codeAddress = _access.resolve();
            Unsafe.pushArg(n);
            HeapAddress heapAddress = HeapAddress.addressOf(byArray);
            Unsafe.pushArgA(heapAddress);
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n2 = (int)Unsafe.invoke(codeAddress);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n2;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public boolean checkAccess(File file, boolean bl) {
        int n = bl ? 2 : 4;
        int n2 = UnixFileSystem.access(file.getPath(), n);
        boolean bl2 = false;
        if (n2 == 0) {
            bl2 = true;
        }
        return bl2;
    }

    public static void boot() {
        SystemInterface.Library library = SystemInterface.registerLibrary("libc.so.6");
        _access = library != null ? library.resolve("access") : null;
    }

    private static final void initIDs() {
    }

    static {
        if (jq.RunningNative) {
            UnixFileSystem.boot();
        } else if (jq.on_vm_startup != null) {
            jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("Ljava/io/UnixFileSystem;");
            jq_StaticMethod jq_StaticMethod2 = jq_Class2.getDeclaredStaticMethod(new jq_NameAndDesc("boot", "()V"));
            MethodInvocation methodInvocation = new MethodInvocation(jq_StaticMethod2, null);
            jq.on_vm_startup.add(methodInvocation);
        }
    }

    public static class linux_stat
    extends SystemInterface.Stat
    implements jq_DontAlign {
        long st_dev;
        int __pad1;
        int st_ino;
        int st_mode;
        int st_nlink;
        int st_uid;
        int st_gid;
        long st_rdev;
        int __pad2;
        int st_size;
        int st_blksize;
        int st_blocks;
        int st_atime;
        int __unused1;
        int st_mtime;
        int __unused2;
        int st_ctime;
        int __unused3;
        int __unused4;
        int __unused5;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{st_dev=");
            stringBuffer.append(this.st_dev);
            stringBuffer.append(",st_ino=");
            stringBuffer.append(this.st_ino);
            stringBuffer.append(",st_mode=");
            stringBuffer.append(this.st_mode);
            stringBuffer.append(",st_nlink=");
            stringBuffer.append(this.st_nlink);
            stringBuffer.append(",st_uid=");
            stringBuffer.append(this.st_uid);
            stringBuffer.append(",st_gid=");
            stringBuffer.append(this.st_gid);
            stringBuffer.append(",st_rdev=");
            stringBuffer.append(this.st_rdev);
            stringBuffer.append(",st_size=");
            stringBuffer.append(this.st_size);
            stringBuffer.append(",st_blksize=");
            stringBuffer.append(this.st_blksize);
            stringBuffer.append(",st_blocks=");
            stringBuffer.append(this.st_blocks);
            stringBuffer.append(",st_atime=");
            stringBuffer.append(this.st_atime);
            stringBuffer.append(",st_mtime=");
            stringBuffer.append(this.st_mtime);
            stringBuffer.append(",st_ctime=");
            stringBuffer.append(this.st_ctime);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }
}

