/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.io;

import Memory.Address;
import Memory.HeapAddress;
import Run_Time.SystemInterface;
import java.io.File;
import java.io.IOException;

public abstract class Win32FileSystem {
    public static final int BA_EXISTS = 1;
    public static final int BA_REGULAR = 2;
    public static final int BA_DIRECTORY = 4;
    public static final int BA_HIDDEN = 8;

    public String canonicalize(String string) throws IOException {
        if (string.indexOf(42) >= 0 || string.indexOf(63) >= 0) {
            throw new IOException("wildcards not allowed in file name: " + string);
        }
        byte[] byArray = new byte[256];
        int n = SystemInterface.fs_fullpath(string, byArray);
        if (n == 0) {
            throw new IOException("fullpath returned error on: " + string);
        }
        String string2 = SystemInterface.fromCString(HeapAddress.addressOf(byArray));
        int n2 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        if (string2.startsWith("\\\\")) {
            n3 = string2.indexOf(92, 2);
            if (n3 == -1) {
                throw new IOException("invalid UNC pathname: " + string);
            }
            stringBuffer.append(string2.substring(0, n3));
        } else if (string2.charAt(1) == ':') {
            stringBuffer.append(Character.toUpperCase(string2.charAt(0)));
            stringBuffer.append(':');
            n3 = 2;
        }
        while (n3 < n2) {
            stringBuffer.append('\\');
            int n4 = string2.indexOf(92, n3);
            if (n4 == -1) {
                stringBuffer.append(string2.substring(n3));
                return stringBuffer.toString();
            }
            String string3 = string2.substring(n3, n4);
            Address address = SystemInterface.fs_gettruename(string3);
            if (address.isNull()) {
                stringBuffer.append(string2.substring(n3));
                return stringBuffer.toString();
            }
            stringBuffer.append(SystemInterface.fromCString(address));
            n3 = n4 + 1;
        }
        return stringBuffer.toString();
    }

    public int getBooleanAttributes(File file) {
        int n = SystemInterface.fs_getfileattributes(file.getPath());
        if (n == -1) {
            return 0;
        }
        return 1 | ((n & 0x10) != 0 ? 4 : 2) | ((n & 2) != 0 ? 8 : 0);
    }

    public boolean checkAccess(File file, boolean bl) {
        int n = SystemInterface.fs_access(file.getPath(), bl ? 2 : 4);
        boolean bl2 = false;
        if (n == 0) {
            bl2 = true;
        }
        return bl2;
    }

    public long getLastModifiedTime(File file) {
        long l = SystemInterface.fs_getfiletime(file.getPath());
        return l;
    }

    public long getLength(File file) {
        return SystemInterface.fs_stat_size(file.getPath());
    }

    public boolean delete(File file) {
        int n = SystemInterface.fs_remove(file.getPath());
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public String[] list(File file) {
        String[] stringArray;
        Address address;
        int n = SystemInterface.fs_opendir(file.getPath());
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = new String[16];
        int n2 = 0;
        while (!(address = SystemInterface.fs_readdir(n)).isNull()) {
            if (n2 == stringArray2.length) {
                stringArray = new String[stringArray2.length << 1];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                stringArray2 = stringArray;
            }
            stringArray2[n2] = SystemInterface.fromCString(address.offset(11));
            if (stringArray2[n2].equals(".") || stringArray2[n2].equals("..")) {
                --n2;
            }
            ++n2;
        }
        SystemInterface.fs_closedir(n);
        stringArray = new String[n2];
        System.arraycopy(stringArray2, 0, stringArray, 0, n2);
        return stringArray;
    }

    public boolean createDirectory(File file) {
        int n = SystemInterface.fs_mkdir(file.getPath());
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean rename(File file, File file2) {
        int n = SystemInterface.fs_rename(file.getPath(), file2.getPath());
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean setLastModifiedTime(File file, long l) {
        int n = SystemInterface.fs_setfiletime(file.getPath(), l);
        boolean bl = false;
        if (n != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean setReadOnly(File file) {
        int n = SystemInterface.fs_chmod(file.getPath(), 256);
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    private static final int listRoots0() {
        return SystemInterface.fs_getlogicaldrives();
    }

    private static final void initIDs() {
    }
}

