/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.lang;

import Bootstrap.PrimordialClassLoader;
import ClassLib.Common.java.lang.Class;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_CompiledCode;
import Clazz.jq_Reference;
import Clazz.jq_Type;
import Main.jq;
import Memory.StackAddress;
import Run_Time.Reflection;
import Run_Time.StackCodeWalker;
import UTF.Utf8;
import Util.Assert;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;

public abstract class ClassLoader {
    private static ClassLoader scl;
    private boolean initialized;
    private java.lang.ClassLoader parent;
    private final Map desc2type;

    void addClass(java.lang.Class clazz) {
    }

    native boolean isAncestor(ClassLoader var1);

    static native RuntimePermission getGetClassLoaderPerm();

    public native Class loadClass(String var1);

    public static java.lang.ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        Object object = PrimordialClassLoader.loader;
        scl = (ClassLoader)object;
        if (scl == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != scl) {
            try {
                if (!scl.isAncestor(classLoader)) {
                    securityManager.checkPermission(ClassLoader.getGetClassLoaderPerm());
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                Assert.UNREACHABLE();
            }
        }
        object = scl;
        return (java.lang.ClassLoader)object;
    }

    public java.lang.Class defineClass0(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, n, n2));
        if (string == null) {
            throw new ClassFormatError("name cannot be null when defining class");
        }
        if (string.startsWith("[")) {
            throw new ClassFormatError("cannot define array class with defineClass: " + string);
        }
        Utf8 utf8 = Utf8.get("L" + string.replace('.', '/') + ';');
        if (this.getType(utf8) != null) {
            throw new ClassFormatError("class " + string + " already defined");
        }
        ClassLoader classLoader = this;
        jq_Class jq_Class2 = jq_Class.newClass((java.lang.ClassLoader)((Object)classLoader), utf8);
        Map map = this.desc2type;
        map.put(utf8, jq_Class2);
        jq_Class2.load(dataInputStream);
        return Reflection.getJDKType(jq_Class2);
    }

    private final void resolveClass0(Class clazz) {
        jq_Type jq_Type2 = clazz.jq_type;
        jq_Type2.load();
        jq_Type2.verify();
        jq_Type2.prepare();
    }

    private final java.lang.Class findBootstrapClass(String string) throws ClassNotFoundException {
        PrimordialClassLoader primordialClassLoader = PrimordialClassLoader.loader;
        boolean bl = false;
        if (this == primordialClassLoader) {
            bl = true;
        }
        Assert._assert(bl);
        if (!string.startsWith("[")) {
            string = "L" + string + ';';
        }
        Utf8 utf8 = Utf8.get(string.replace('.', '/'));
        jq_Type jq_Type2 = this.getOrCreateType(utf8);
        try {
            jq_Type2.load();
        }
        catch (ClassFormatError classFormatError) {
            throw classFormatError;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.unloadType(jq_Type2);
            throw new ClassNotFoundException(string);
        }
        return Reflection.getJDKType(jq_Type2);
    }

    protected final java.lang.Class findLoadedClass(String string) {
        Utf8 utf8;
        jq_Reference jq_Reference2;
        if (!string.startsWith("[")) {
            string = "L" + string + ';';
        }
        if ((jq_Reference2 = (jq_Reference)this.getType(utf8 = Utf8.get(string.replace('.', '/')))) == null) {
            return null;
        }
        if (jq_Reference2.getState() == 0) {
            jq_Reference2.load();
        }
        return Reflection.getJDKType(jq_Reference2);
    }

    static ClassLoader getCallerClassLoader() {
        StackCodeWalker stackCodeWalker = new StackCodeWalker(null, StackAddress.getBasePointer());
        stackCodeWalker.gotoNext();
        stackCodeWalker.gotoNext();
        stackCodeWalker.gotoNext();
        jq_CompiledCode jq_CompiledCode2 = stackCodeWalker.getCode();
        if (jq_CompiledCode2 == null) {
            return null;
        }
        java.lang.ClassLoader classLoader = jq_CompiledCode2.getMethod().getDeclaringClass().getClassLoader();
        return (ClassLoader)((Object)classLoader);
    }

    public jq_Type getType(Utf8 utf8) {
        Assert._assert(jq.RunningNative);
        Map map = this.desc2type;
        jq_Type jq_Type2 = (jq_Type)map.get(utf8);
        return jq_Type2;
    }

    public static jq_Type getOrCreateType(java.lang.ClassLoader classLoader, Utf8 utf8) {
        java.lang.ClassLoader classLoader2 = classLoader;
        return ((ClassLoader)((Object)classLoader2)).getOrCreateType(utf8);
    }

    public jq_Type getOrCreateType(Utf8 utf8) {
        if (!jq.RunningNative) {
            return PrimordialClassLoader.loader.getOrCreateBSType(utf8);
        }
        Map map = this.desc2type;
        jq_Type jq_Type2 = (jq_Type)map.get(utf8);
        if (jq_Type2 == null) {
            if (utf8.isDescriptor((byte)76)) {
                ClassLoader classLoader = this;
                jq_Type2 = jq_Class.newClass((java.lang.ClassLoader)((Object)classLoader), utf8);
            } else {
                if (!utf8.isDescriptor((byte)91)) {
                    Assert.UNREACHABLE("bad descriptor! " + utf8);
                }
                Utf8 utf82 = utf8.getArrayElementDescriptor();
                jq_Type jq_Type3 = this.getOrCreateType(utf82);
                ClassLoader classLoader = this;
                jq_Type2 = jq_Array.newArray(utf8, (java.lang.ClassLoader)((Object)classLoader), jq_Type3);
            }
            map.put(utf8, jq_Type2);
        }
        return jq_Type2;
    }

    public void unloadType(jq_Type jq_Type2) {
        if (!jq.RunningNative) {
            PrimordialClassLoader.loader.unloadBSType(jq_Type2);
            return;
        }
        Map map = this.desc2type;
        map.remove(jq_Type2.getDesc());
    }

    protected ClassLoader(java.lang.ClassLoader classLoader) {
        HashMap hashMap;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        boolean bl = false;
        if (classLoader != null) {
            bl = true;
        }
        Assert._assert(bl);
        this.parent = classLoader;
        this.desc2type = hashMap = new HashMap();
        this.initialized = true;
    }

    protected ClassLoader() {
        HashMap hashMap;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        java.lang.ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        boolean bl = false;
        if (classLoader != null) {
            bl = true;
        }
        Assert._assert(bl);
        this.parent = classLoader;
        this.desc2type = hashMap = new HashMap();
        this.initialized = true;
    }
}

