/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.lang.reflect;

import ClassLib.ClassLibInterface;
import ClassLib.Common.ClassUtils;
import ClassLib.Common.java.lang.reflect.AccessibleObject;
import Clazz.jq_Class;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Method;
import Clazz.jq_NameAndDesc;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_Type;
import Main.jq;
import Memory.HeapAddress;
import Run_Time.Reflection;
import Run_Time.TypeCheck;
import UTF.Utf8;
import Util.Assert;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class Method
extends AccessibleObject {
    public final jq_Method jq_method;
    private Class clazz;
    private String name;
    private Class[] parameterTypes;
    private Class returnType;
    private Class[] exceptionTypes;
    private int modifiers;
    private int slot;

    public Object invoke(Object object, Object[] objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        jq_Type jq_Type2;
        int n;
        int n2;
        jq_Reference jq_Reference2;
        jq_Method jq_Method2 = this.jq_method;
        jq_Class jq_Class2 = jq_Method2.getDeclaringClass();
        if (!jq_Method2.isStatic() && !TypeCheck.isAssignable(jq_Reference2 = jq_Reference.getTypeOf(object), jq_Class2)) {
            throw new IllegalArgumentException(jq_Reference2 + " is not assignable to " + jq_Class2);
        }
        if (!this.isAccessible()) {
            ClassUtils.checkCallerAccess(jq_Method2, 2);
        }
        if (jq_Method2.isStatic()) {
            object = null;
            n2 = 0;
        } else {
            n2 = 1;
        }
        jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
        int n3 = 0;
        if (objectArray != null) {
            n3 = objectArray.length;
        }
        if ((n = n3) != jq_TypeArray.length - n2) {
            throw new IllegalArgumentException();
        }
        if (jq_Method2.isStatic()) {
            jq_Class2.cls_initialize();
        } else {
            jq_Type2 = jq_Reference.getTypeOf(object);
            jq_Method2 = ((jq_Reference)jq_Type2).getVirtualMethod(jq_Method2.getNameAndDesc());
            if (jq_Method2 == null || jq_Method2.isAbstract()) {
                throw new AbstractMethodError();
            }
        }
        jq_Type2 = jq_Method2.getReturnType();
        if (jq_Type2.isReferenceType()) {
            return ((HeapAddress)Reflection.invokeA(jq_Method2, object, objectArray)).asObject();
        }
        long l = Reflection.invoke(jq_Method2, object, objectArray);
        if (jq_Type2 == jq_Primitive.VOID) {
            return null;
        }
        if (jq_Type2 == jq_Primitive.INT) {
            return new Integer((int)l);
        }
        if (jq_Type2 == jq_Primitive.LONG) {
            return new Long(l);
        }
        if (jq_Type2 == jq_Primitive.FLOAT) {
            return new Float(Float.intBitsToFloat((int)l));
        }
        if (jq_Type2 == jq_Primitive.DOUBLE) {
            return new Double(Double.longBitsToDouble(l));
        }
        if (jq_Type2 == jq_Primitive.BOOLEAN) {
            boolean bl = false;
            if ((int)l != 0) {
                bl = true;
            }
            return new Boolean(bl);
        }
        if (jq_Type2 == jq_Primitive.BYTE) {
            return new Byte((byte)l);
        }
        if (jq_Type2 == jq_Primitive.SHORT) {
            return new Short((short)l);
        }
        if (jq_Type2 == jq_Primitive.CHAR) {
            return new Character((char)l);
        }
        Assert.UNREACHABLE();
        return null;
    }

    public static java.lang.reflect.Method createNewMethod(jq_Method jq_Method2) {
        Method method = new Method(jq_Method2);
        return (java.lang.reflect.Method)((Object)method);
    }

    public static void initNewMethod(Method method, jq_Method jq_Method2) {
        String string;
        if (!jq.RunningNative) {
            return;
        }
        method.name = string = jq_Method2.getName().toString();
        Class clazz = jq_Method2.getDeclaringClass().getJavaLangClassObject();
        boolean bl = false;
        if (clazz != null) {
            bl = true;
        }
        Assert._assert(bl);
        method.clazz = clazz;
        Class clazz2 = jq_Method2.getReturnType().getJavaLangClassObject();
        boolean bl2 = false;
        if (clazz2 != null) {
            bl2 = true;
        }
        Assert._assert(bl2);
        method.returnType = clazz2;
        jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
        int n = jq_Method2 instanceof jq_InstanceMethod ? 1 : 0;
        Class[] classArray = new Class[jq_TypeArray.length - n];
        int n2 = n;
        while (n2 < jq_TypeArray.length) {
            classArray[n2 - n] = Reflection.getJDKType(jq_TypeArray[n2]);
            boolean bl3 = false;
            if (classArray[n2 - n] != null) {
                bl3 = true;
            }
            Assert._assert(bl3);
            ++n2;
        }
        method.parameterTypes = classArray;
        Class[] classArray2 = new Class[]{};
        method.exceptionTypes = classArray2;
        char c = jq_Method2.getAccessFlags();
        method.modifiers = c;
    }

    private Method(jq_Method jq_Method2) {
        this.jq_method = jq_Method2;
    }

    private Method(Class clazz, String string, Class[] classArray, Class clazz2, Class[] classArray2, int n, int n2) {
        this.clazz = clazz;
        this.name = string;
        this.parameterTypes = classArray;
        this.returnType = clazz2;
        this.exceptionTypes = classArray2;
        this.modifiers = n;
        this.slot = n2;
        jq_Class jq_Class2 = (jq_Class)ClassLibInterface.DEFAULT.getJQType(clazz);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n3 = 0;
        while (n3 < classArray.length) {
            stringBuffer.append(Reflection.getJQType(classArray[n3]).getDesc().toString());
            ++n3;
        }
        stringBuffer.append(')');
        stringBuffer.append(Reflection.getJQType(clazz2).getDesc().toString());
        jq_NameAndDesc jq_NameAndDesc2 = new jq_NameAndDesc(Utf8.get(string), Utf8.get(stringBuffer.toString()));
        jq_NameAndDesc2 = ClassLibInterface.convertClassLibNameAndDesc(jq_Class2, jq_NameAndDesc2);
        jq_Method jq_Method2 = (jq_Method)jq_Class2.getDeclaredMember(jq_NameAndDesc2);
        if (jq_Method2 == null) {
            jq_Method2 = Modifier.isStatic(n) ? jq_Class2.getOrCreateStaticMethod(jq_NameAndDesc2) : jq_Class2.getOrCreateInstanceMethod(jq_NameAndDesc2);
        }
        this.jq_method = jq_Method2;
    }
}

