/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.util.zip;

import java.util.zip.Checksum;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class CRC32
implements Checksum {
    private static int[] crc_table = CRC32.make_crc_table();
    private int crc;

    private static final int[] make_crc_table() {
        int[] nArray = new int[256];
        int n = 0;
        while (n < 256) {
            int n2 = n;
            int n3 = 8;
            while (--n3 >= 0) {
                if ((n2 & 1) != 0) {
                    n2 = 0xEDB88320 ^ n2 >>> 1;
                    continue;
                }
                n2 >>>= 1;
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    public void reset() {
        this.crc = 0;
    }

    public void update(int n) {
        int n2 = ~this.crc;
        n2 = crc_table[(n2 ^ n) & 0xFF] ^ n2 >>> 8;
        this.crc = ~n2;
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = ~this.crc;
        while (--n2 >= 0) {
            n3 = crc_table[(n3 ^ byArray[n++]) & 0xFF] ^ n3 >>> 8;
        }
        this.crc = ~n3;
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    private final /* synthetic */ void this() {
        this.crc = 0;
    }

    public CRC32() {
        this.this();
    }
}

