/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.util.zip;

import ClassLib.Common.java.util.zip.ZipFile;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class InflaterInputStreamWrapper
extends InflaterInputStream {
    private boolean isClosed;
    private boolean eof;
    private final ZipFile zf;

    public void close() throws IOException {
        if (!this.isClosed) {
            this.zf.releaseInflater0(this.inf);
            this.in.close();
            this.isClosed = true;
        }
    }

    protected void fill() throws IOException {
        if (this.eof) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len == -1) {
            this.buf[0] = 0;
            this.len = 1;
            this.eof = true;
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    public int available() throws IOException {
        if (super.available() != 0) {
            return this.in.available();
        }
        return 0;
    }

    public InflaterInputStreamWrapper(ZipFile zipFile, InputStream inputStream, Inflater inflater) {
        super(inputStream, inflater);
        this.zf = zipFile;
        this.isClosed = false;
        this.eof = false;
    }
}

