/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.util.zip;

import ClassLib.Common.java.util.zip.InflaterInputStreamWrapper;
import ClassLib.Common.java.util.zip.ZipConstants;
import ClassLib.Common.java.util.zip.ZipEntry;
import Util.Assert;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public abstract class ZipFile
implements ZipConstants {
    public static final boolean TRACE = false;
    private static final int INBUFSIZ = 64;
    private String name;
    private RandomAccessFile raf;
    private Hashtable entries;
    private long cenpos;
    private long pos;

    private static final void initIDs() {
    }

    public native void __init__(String var1) throws IOException;

    public java.util.zip.ZipEntry getEntry(String string) {
        Hashtable hashtable = this.entries;
        if (hashtable == null) {
            return null;
        }
        return (java.util.zip.ZipEntry)hashtable.get(string);
    }

    public Enumeration entries() {
        Hashtable hashtable = this.entries;
        return hashtable.elements();
    }

    public int size() {
        Hashtable hashtable = this.entries;
        if (hashtable == null) {
            return 0;
        }
        return hashtable.size();
    }

    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        if (randomAccessFile != null) {
            randomAccessFile.close();
            this.raf = null;
        }
        this.entries = null;
    }

    private final InputStream getInputStream(String string) throws IOException {
        java.util.zip.ZipEntry zipEntry = this.getEntry(string);
        return this.getInputStream((ZipEntry)((Object)zipEntry));
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (zipEntry == null) {
            return null;
        }
        ZipFileInputStream zipFileInputStream = new ZipFileInputStream(this, zipEntry);
        switch (zipEntry.getMethod()) {
            case 0: {
                return zipFileInputStream;
            }
            case 8: {
                Inflater inflater = this.getInflater();
                return new InflaterInputStreamWrapper(this, zipFileInputStream, inflater);
            }
        }
        throw new ZipException("invalid compression method");
    }

    private final native Inflater getInflater();

    private final native void releaseInflater(Inflater var1);

    void releaseInflater0(Inflater inflater) {
        this.releaseInflater(inflater);
    }

    private final int read(long l, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        RandomAccessFile randomAccessFile = this.raf;
        if (randomAccessFile == null) {
            throw new IOException();
        }
        if (l != this.pos) {
            randomAccessFile.seek(l);
        }
        if ((n3 = randomAccessFile.read(byArray, n, n2)) > 0) {
            this.pos = l + (long)n3;
        }
        return n3;
    }

    private final int read(long l) throws IOException {
        int n;
        RandomAccessFile randomAccessFile = this.raf;
        if (randomAccessFile == null) {
            throw new IOException();
        }
        if (l != this.pos) {
            randomAccessFile.seek(l);
        }
        if ((n = randomAccessFile.read()) > 0) {
            this.pos = l + 1L;
        }
        return n;
    }

    private final void readCEN() throws IOException {
        Hashtable<String, ZipEntry> hashtable;
        long l;
        long l2 = this.findEND();
        byte[] byArray = new byte[22];
        RandomAccessFile randomAccessFile = this.raf;
        randomAccessFile.readFully(byArray);
        if (ZipFile.get32(byArray, 0) != 101010256L) {
            throw new ZipException("invalid END header signature");
        }
        this.cenpos = l = ZipFile.get32(byArray, 16);
        int n = (int)ZipFile.get32(byArray, 12);
        if (l + (long)n != l2) {
            throw new ZipException("invalid END header format");
        }
        int n2 = ZipFile.get16(byArray, 10);
        if (n2 * 46 > n) {
            throw new ZipException("invalid END header format");
        }
        if (ZipFile.get16(byArray, 8) != n2) {
            throw new ZipException("cannot have more than one drive");
        }
        randomAccessFile.seek(l);
        byte[] byArray2 = new byte[n];
        randomAccessFile.readFully(byArray2);
        this.entries = hashtable = new Hashtable<String, ZipEntry>(n2);
        int n3 = 0;
        while (n3 < n) {
            if (ZipFile.get32(byArray2, n3) != 33639248L) {
                throw new ZipException("invalid CEN header signature");
            }
            ZipEntry zipEntry = new ZipEntry();
            int n4 = zipEntry.load(byArray2, n3, l, n);
            n3 += n4;
            String string = zipEntry.getName();
            hashtable.put(string, zipEntry);
        }
    }

    private final long findEND() throws IOException {
        if (this.raf == null) {
            throw new IOException();
        }
        long l = this.raf.length();
        this.raf.seek(l);
        long l2 = Math.max(0L, l - 65535L);
        byte[] byArray = new byte[68];
        long l3 = 0L;
        l3 = l;
        while (l3 > l2) {
            int n = Math.min((int)(l3 - l2), 64);
            this.raf.seek(l3 -= (long)n);
            this.raf.readFully(byArray, 0, n);
            while (--n > 0) {
                long l4;
                if (ZipFile.get32(byArray, n) != 101010256L || l - (l4 = l3 + (long)n) < 22L) continue;
                this.raf.seek(l4);
                byte[] byArray2 = new byte[22];
                this.raf.readFully(byArray2);
                int n2 = ZipFile.get16(byArray2, 20);
                if (l4 + 22L + (long)n2 != l) continue;
                this.raf.seek(l4);
                this.pos = l4;
                return l4;
            }
        }
        throw new ZipException("not a ZIP file (END header not found)");
    }

    static final int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    static final long get32(byte[] byArray, int n) {
        return (long)ZipFile.get16(byArray, n) | (long)ZipFile.get16(byArray, n + 2) << 16;
    }

    private static final void freeEntry(long l, long l2) {
        Assert.UNREACHABLE();
    }

    public ZipFile(String string) throws IOException {
        this.__init__(string);
    }

    public ZipFile(File file, int n) throws IOException {
        this(file.getPath());
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        Assert._assert(bl);
    }

    private static class ZipFileInputStream
    extends InputStream {
        private ZipFile zf;
        private ZipEntry ze;
        private long pos;
        private long count;

        public int read(byte[] byArray, int n, int n2) throws IOException {
            long l;
            ZipFile zipFile;
            long l2 = this.count;
            if (l2 == 0L) {
                return -1;
            }
            if ((long)n2 > l2) {
                n2 = (int)Math.min(l2, Integer.MAX_VALUE);
            }
            if ((n2 = (zipFile = this.zf).read(l = this.pos, byArray, n, n2)) == -1) {
                throw new ZipException("premature EOF");
            }
            this.pos = l + (long)n2;
            this.count = l2 - (long)n2;
            return n2;
        }

        public int read() throws IOException {
            long l = this.count;
            if (l == 0L) {
                return -1;
            }
            ZipFile zipFile = this.zf;
            long l2 = this.pos;
            int n = zipFile.read(l2);
            if (n == -1) {
                throw new ZipException("premature EOF");
            }
            this.pos = l2 + 1L;
            this.count = l - 1L;
            return n;
        }

        public long skip(long l) {
            long l2 = this.count;
            if (l > l2) {
                l = l2;
            }
            long l3 = this.pos;
            this.pos = l3 + l;
            this.count = l2 - l;
            return l;
        }

        public int available() {
            long l = this.count;
            return (int)Math.min(l, Integer.MAX_VALUE);
        }

        private final void cleanup() {
        }

        public void close() {
            this.cleanup();
        }

        private final void readLOC() throws IOException {
            long l;
            long l2;
            byte[] byArray = new byte[30];
            ZipFile zipFile = this.zf;
            ZipEntry zipEntry = this.ze;
            long l3 = zipEntry.getOffset();
            zipFile.read(l3, byArray, 0, 30);
            if (ZipFile.get32(byArray, 0) != 67324752L) {
                throw new ZipException("invalid LOC header signature");
            }
            this.count = l2 = zipEntry.getCompressedSize();
            this.pos = l = zipEntry.getOffset() + 30L + (long)ZipFile.get16(byArray, 26) + (long)ZipFile.get16(byArray, 28);
            long l4 = zipFile.cenpos;
            if (l + l2 > l4) {
                throw new ZipException("invalid LOC header format");
            }
        }

        public ZipFileInputStream(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
            this.zf = zipFile;
            this.ze = zipEntry;
            this.readLOC();
        }
    }
}

