/*
 * Decompiled with CFR 0.152.
 */
package Clazz;

import Bootstrap.PrimordialClassLoader;
import Clazz.NullDelegates;
import Clazz.jq_BytecodeMap;
import Clazz.jq_Class;
import Clazz.jq_InstanceField;
import Clazz.jq_Method;
import Clazz.jq_TryCatch;
import Main.jq;
import Memory.CodeAddress;
import Memory.StackAddress;
import Run_Time.Debug;
import Util.Assert;
import java.util.Iterator;
import java.util.List;

public class jq_CompiledCode
implements Comparable {
    public static boolean TRACE = false;
    public static boolean TRACE_REDIRECT = false;
    private static Delegate _delegate;
    public static final jq_InstanceField _entrypoint;
    protected final CodeAddress entrypoint;
    protected final jq_Method method;
    protected final CodeAddress start;
    protected final int length;
    protected final jq_TryCatch[] handlers;
    protected final jq_BytecodeMap bcm;
    protected final Object ed;
    protected final int stackframesize;
    protected final List code_reloc;
    protected final List data_reloc;

    public jq_Method getMethod() {
        return this.method;
    }

    public CodeAddress getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public CodeAddress getEntrypoint() {
        return this.entrypoint;
    }

    public int getStackFrameSize() {
        return this.stackframesize;
    }

    public jq_TryCatch findCatchBlock(CodeAddress codeAddress, jq_Class jq_Class2) {
        int n = codeAddress.difference(this.start);
        if (this.handlers == null) {
            if (TRACE) {
                Debug.writeln("no handlers in " + this);
            }
            return null;
        }
        int n2 = 0;
        while (n2 < this.handlers.length) {
            jq_TryCatch jq_TryCatch2 = this.handlers[n2];
            if (TRACE) {
                Debug.writeln("checking handler: " + jq_TryCatch2);
            }
            if (jq_TryCatch2.catches(n, jq_Class2)) {
                return jq_TryCatch2;
            }
            if (TRACE) {
                Debug.writeln("does not catch");
            }
            ++n2;
        }
        if (TRACE) {
            Debug.writeln("no appropriate handler found in " + this);
        }
        return null;
    }

    public void deliverException(jq_TryCatch jq_TryCatch2, StackAddress stackAddress, Throwable throwable) {
        boolean bl = false;
        if (this.ed != null) {
            bl = true;
        }
        Assert._assert(bl);
        CodeAddress codeAddress = (CodeAddress)this.start.offset(jq_TryCatch2.getHandlerEntry());
        _delegate.deliverToStackFrame(this.ed, this, throwable, jq_TryCatch2, codeAddress, stackAddress);
    }

    public Object getThisPointer(CodeAddress codeAddress, StackAddress stackAddress) {
        boolean bl = false;
        if (this.ed != null) {
            bl = true;
        }
        Assert._assert(bl);
        return _delegate.getThisPointer(this.ed, this, codeAddress, stackAddress);
    }

    public int getBytecodeIndex(CodeAddress codeAddress) {
        if (this.bcm == null) {
            return -1;
        }
        return this.bcm.getBytecodeIndex(codeAddress.difference(this.start));
    }

    public void redirect(jq_CompiledCode jq_CompiledCode2) {
        CodeAddress codeAddress = jq_CompiledCode2.getEntrypoint();
        if (TRACE_REDIRECT) {
            Debug.writeln("redirecting " + this + " to point to " + jq_CompiledCode2);
        }
        if (this.entrypoint.difference(this.start.offset(5)) >= 0) {
            if (TRACE_REDIRECT) {
                Debug.writeln("redirecting via trampoline");
            }
            boolean bl = false;
            if (this.entrypoint.peek1() == codeAddress.peek1()) {
                bl = true;
            }
            Assert._assert(bl);
            this.entrypoint.offset(-4).poke4(codeAddress.difference(this.entrypoint) + 1);
            this.entrypoint.offset(-5).poke1((byte)-23);
            this.entrypoint.offset(1).poke2((short)-1813);
        } else {
            if (TRACE_REDIRECT) {
                Debug.writeln("redirecting by rewriting targets");
            }
            Iterator iterator = _delegate.getCompiledMethods();
            while (iterator.hasNext()) {
                jq_CompiledCode jq_CompiledCode3 = (jq_CompiledCode)iterator.next();
                jq_CompiledCode3.patchDirectBindCalls(this.method, jq_CompiledCode2);
            }
        }
    }

    public String toString() {
        return this.method + " address: (" + this.start.stringRep() + '-' + this.start.offset(this.length).stringRep() + ')';
    }

    public boolean contains(CodeAddress codeAddress) {
        boolean bl = false;
        if (codeAddress.difference(this.start) >= 0 && codeAddress.difference(this.start.offset(this.length)) < 0) {
            bl = true;
        }
        return bl;
    }

    public void patchDirectBindCalls() {
        Assert._assert(jq.RunningNative);
        if (this.code_reloc != null) {
            Iterator iterator = this.code_reloc.iterator();
            _delegate.patchDirectBindCalls(iterator);
        }
    }

    public void patchDirectBindCalls(jq_Method jq_Method2, jq_CompiledCode jq_CompiledCode2) {
        Assert._assert(jq.RunningNative);
        if (this.code_reloc != null) {
            Iterator iterator = this.code_reloc.iterator();
            _delegate.patchDirectBindCalls(iterator, jq_Method2, jq_CompiledCode2);
        }
    }

    public int compareTo(jq_CompiledCode jq_CompiledCode2) {
        if (this == jq_CompiledCode2) {
            return 0;
        }
        if (this.start.difference(jq_CompiledCode2.start) < 0) {
            return -1;
        }
        if (this.start.difference(jq_CompiledCode2.start.offset(jq_CompiledCode2.length)) < 0) {
            Assert.UNREACHABLE(this + " overlaps " + jq_CompiledCode2);
        }
        return 1;
    }

    public int compareTo(Object object) {
        if (object instanceof jq_CompiledCode) {
            return this.compareTo((jq_CompiledCode)object);
        }
        return -((Comparable)object).compareTo(this);
    }

    public boolean equals(Object object) {
        if (object instanceof jq_CompiledCode) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            }
            return bl;
        }
        return object.equals(this);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static final Delegate attemptDelegate(String string) {
        String string2 = "compiled code delegate";
        try {
            Class<?> clazz = Class.forName(string);
            return (Delegate)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find " + string2 + ' ' + string + ": " + classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Cannot instantiate " + string2 + ' ' + string + ": " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access " + string2 + ' ' + string + ": " + illegalAccessException);
        }
        return null;
    }

    public jq_CompiledCode(jq_Method jq_Method2, CodeAddress codeAddress, int n, CodeAddress codeAddress2, jq_TryCatch[] jq_TryCatchArray, jq_BytecodeMap jq_BytecodeMap2, Object object, int n2, List list, List list2) {
        this.method = jq_Method2;
        this.entrypoint = codeAddress2;
        this.start = codeAddress;
        this.length = n;
        this.handlers = jq_TryCatchArray;
        this.bcm = jq_BytecodeMap2;
        this.ed = object;
        this.stackframesize = n2;
        this.code_reloc = list;
        this.data_reloc = list2;
    }

    static {
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LClazz/jq_CompiledCode;");
        _entrypoint = jq_Class2.getOrCreateInstanceField("entrypoint", "LMemory/CodeAddress;");
        _delegate = null;
        boolean bl = jq.nullVM;
        if (!bl) {
            _delegate = jq_CompiledCode.attemptDelegate("Clazz.Delegates$CompiledCode");
        }
        if (_delegate == null) {
            _delegate = new NullDelegates.CompiledCode();
        }
    }

    static interface Delegate {
        public void patchDirectBindCalls(Iterator var1);

        public void patchDirectBindCalls(Iterator var1, jq_Method var2, jq_CompiledCode var3);

        public Iterator getCompiledMethods();

        public void deliverToStackFrame(Object var1, jq_CompiledCode var2, Throwable var3, jq_TryCatch var4, CodeAddress var5, StackAddress var6);

        public Object getThisPointer(Object var1, jq_CompiledCode var2, CodeAddress var3, StackAddress var4);
    }
}

