/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPA;

import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_Field;
import Clazz.jq_Initializer;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Type;
import Clazz.jq_TypeVisitor;
import Compil3r.Analysis.FlowInsensitive.MethodSummary;
import Compil3r.Quad.CallGraph;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Util.Assert;
import Util.Graphs.Navigator;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ClassInvariantAnalysis
implements jq_TypeVisitor {
    public static final boolean TRACE = true;
    public static final boolean TRACE_INTRA = true;
    public static final PrintStream out = System.out;
    MethodSummary summary;
    MethodSummary.ParamNode dis;
    Map returned;
    Map thrown;

    public void initialize(jq_Class jq_Class2) {
        jq_InstanceMethod[] jq_InstanceMethodArray = jq_Class2.getDeclaredInstanceMethods();
        jq_Initializer jq_Initializer2 = null;
        int n = 0;
        while (n < jq_InstanceMethodArray.length) {
            if (jq_InstanceMethodArray[n] instanceof jq_Initializer) {
                jq_Initializer2 = (jq_Initializer)jq_InstanceMethodArray[n];
                break;
            }
            ++n;
        }
        this.dis = new MethodSummary.ParamNode(jq_Initializer2, 0, jq_Class2);
        this.summary = new MethodSummary(new MethodSummary.ParamNode[]{this.dis});
        this.returned = new HashMap();
        this.thrown = new HashMap();
    }

    static MethodSummary getSummary(jq_Method jq_Method2) {
        if (jq_Method2.getBytecode() == null) {
            return null;
        }
        ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
        MethodSummary methodSummary = MethodSummary.getSummary(controlFlowGraph);
        return methodSummary;
    }

    public void instantiateLocalCalls(jq_Method jq_Method2) {
    }

    public void visitMethod(jq_Method jq_Method2) {
        if (jq_Method2.getBytecode() == null) {
            out.println("NOTE: " + jq_Method2.getName() + "() is a native method, we don't know what goes on in there.");
            return;
        }
        jq_Method2.isPrivate();
        ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
        MethodSummary methodSummary = MethodSummary.getSummary(controlFlowGraph);
        if (jq_Method2.isStatic()) {
            out.println(jq_Method2.getName() + "() is static.");
        } else {
            MethodSummary.ParamNode paramNode = methodSummary.getParamNode(0);
            paramNode.replaceBy(Collections.singleton(this.dis), true);
            MethodSummary.NodeSet nodeSet = new MethodSummary.NodeSet(methodSummary.getReturned());
            if (nodeSet.remove(paramNode)) {
                nodeSet.add(this.dis);
            }
            this.returned.put(jq_Method2, nodeSet);
            MethodSummary.NodeSet nodeSet2 = new MethodSummary.NodeSet(methodSummary.getThrown());
            if (nodeSet2.remove(paramNode)) {
                nodeSet2.add(this.dis);
            }
            this.thrown.put(jq_Method2, nodeSet2);
        }
    }

    public void unifyAccessPathEdges(MethodSummary.Node node) {
        if (node instanceof MethodSummary.UnknownTypeNode) {
            return;
        }
        out.println("Unifying access path edges from: " + node);
        if (node.hasAccessPathEdges()) {
            Iterator iterator = node.getAccessPathEdges().iterator();
            while (iterator.hasNext()) {
                MethodSummary.FieldNode fieldNode;
                Map.Entry entry = (Map.Entry)iterator.next();
                jq_Field jq_Field2 = (jq_Field)entry.getKey();
                Object v = entry.getValue();
                boolean bl = false;
                if (v != null) {
                    bl = true;
                }
                Assert._assert(bl);
                if (v instanceof MethodSummary.FieldNode) {
                    fieldNode = (MethodSummary.FieldNode)v;
                    continue;
                }
                Set set = MethodSummary.NodeSet.FACTORY.makeSet((Set)v);
                if (set.size() == 0) {
                    iterator.remove();
                    continue;
                }
                if (set.size() == 1) {
                    fieldNode = (MethodSummary.FieldNode)set.iterator().next();
                    entry.setValue(fieldNode);
                    continue;
                }
                out.println("Node " + node + " has duplicate access path edges on field " + jq_Field2 + ": " + set);
                fieldNode = MethodSummary.FieldNode.unify(jq_Field2, set);
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    Set set2;
                    MethodSummary.FieldNode fieldNode2 = (MethodSummary.FieldNode)iterator2.next();
                    Iterator iterator3 = this.returned.values().iterator();
                    while (iterator3.hasNext()) {
                        set2 = (Set)iterator3.next();
                        if (!set2.remove(fieldNode2)) continue;
                        set2.add(fieldNode);
                    }
                    iterator3 = this.thrown.values().iterator();
                    while (iterator3.hasNext()) {
                        set2 = (Set)iterator3.next();
                        if (!set2.remove(fieldNode2)) continue;
                        set2.add(fieldNode);
                    }
                }
                entry.setValue(fieldNode);
            }
        }
    }

    public void finish() {
        jq_Member jq_Member2;
        Map.Entry entry;
        this.unifyAccessPathEdges(this.dis);
        Iterator<Object> iterator = this.dis.getAccessPathEdges().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            jq_Member2 = (jq_Field)entry.getKey();
            System.out.println("Field " + jq_Member2.getName() + " = " + this.dis.getAllEdges((jq_Field)jq_Member2));
        }
        iterator = this.returned.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            jq_Member2 = (jq_Method)entry.getKey();
            System.out.println("Method " + jq_Member2.getName() + " returns " + entry.getValue());
        }
    }

    public void visitClass(jq_Class jq_Class2) {
        this.initialize(jq_Class2);
        Iterator<jq_InstanceMethod> iterator = Arrays.asList(jq_Class2.getDeclaredInstanceMethods()).iterator();
        while (iterator.hasNext()) {
            jq_Method jq_Method2 = iterator.next();
            this.visitMethod(jq_Method2);
        }
        this.finish();
    }

    public void visitArray(jq_Array jq_Array2) {
    }

    public void visitPrimitive(jq_Primitive jq_Primitive2) {
    }

    public void visitType(jq_Type jq_Type2) {
    }

    static class LocalCallGraphNavigator
    implements Navigator {
        jq_Class klass;
        CallGraph cg;

        public Collection next(Object object) {
            jq_Method jq_Method2 = (jq_Method)object;
            Collection collection = this.cg.getCallees(jq_Method2);
            LinkedList<jq_Method> linkedList = new LinkedList<jq_Method>();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                jq_Method jq_Method3 = (jq_Method)iterator.next();
                if (!this.klass.isSubtypeOf(jq_Method3.getDeclaringClass())) continue;
                linkedList.add(jq_Method3);
            }
            return linkedList;
        }

        public Collection prev(Object object) {
            jq_Method jq_Method2 = (jq_Method)object;
            Collection collection = this.cg.getCallerMethods(jq_Method2);
            LinkedList<jq_Method> linkedList = new LinkedList<jq_Method>();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                jq_Method jq_Method3 = (jq_Method)iterator.next();
                if (!jq_Method3.getDeclaringClass().isSubtypeOf(this.klass)) continue;
                linkedList.add(jq_Method3);
            }
            return collection;
        }

        LocalCallGraphNavigator() {
        }
    }
}

