/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPA;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_Field;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_NameAndDesc;
import Clazz.jq_Reference;
import Clazz.jq_Type;
import Compil3r.Analysis.FlowInsensitive.MethodSummary;
import Compil3r.Analysis.IPA.CollectionType;
import Compil3r.Analysis.IPA.PA;
import Compil3r.Analysis.IPA.PACallGraph;
import Compil3r.Analysis.IPA.PointerAnalysisResults;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Analysis.IPSSA.ContextSet;
import Compil3r.Analysis.IPSSA.SSALocation;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.CallGraph;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.LoadedCallGraph;
import Compil3r.Quad.Operand;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Compil3r.Quad.RegisterFactory;
import Main.Driver;
import Main.HostedVM;
import Util.Assert;
import Util.Collections.HashWorklist;
import Util.Collections.IndexMap;
import Util.Collections.LinearSet;
import Util.Collections.Pair;
import Util.Collections.Triple;
import Util.Collections.UnmodifiableIterator;
import Util.Graphs.Navigator;
import Util.Graphs.PathNumbering;
import Util.Graphs.SCCPathNumbering;
import Util.Graphs.SCCTopSortedGraph;
import Util.Graphs.SCComponent;
import Util.IO.SourceLister;
import Util.IO.Textualizable;
import Util.Strings;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.sf.javabdd.BDD;
import org.sf.javabdd.BDDDomain;
import org.sf.javabdd.BDDFactory;
import org.sf.javabdd.BDDPairing;
import org.sf.javabdd.TypedBDDFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PAResults
implements PointerAnalysisResults {
    public static final int DEFAULT_NUM_TO_PRINT = 10;
    public static double p0 = 0.85;
    final PA r;
    CallGraph cg;
    private HashMap storedBDDs;
    int heapConnectivityQueries;
    int heapConnectivitySteps;
    BDDDomain H3;
    BDDPairing H1toH3;
    BDD alwaysfail;
    BDD perfectcasts;
    BDD emptycasts;
    BDD casts;
    static /* synthetic */ Class class$Compil3r$Analysis$IPA$PA;
    static /* synthetic */ Class class$org$sf$javabdd$BDD;
    static /* synthetic */ Class class$Compil3r$Analysis$IPA$PAResults;
    static /* synthetic */ Class class$org$sf$javabdd$BDDPairing;

    public PA getPAResults() {
        return this.r;
    }

    public static void main(String[] stringArray) throws IOException {
        PAResults.initialize(null);
        PAResults pAResults = PAResults.loadResults(stringArray, null);
        if (System.getProperty("pa.stats") != null) {
            pAResults.printStats();
        } else {
            pAResults.interactive();
        }
    }

    public static void initialize(String string) {
        CodeCache.AlwaysMap = true;
        HostedVM.initialize();
        if (string != null) {
            PrimordialClassLoader.loader.addToClasspath(string);
        }
    }

    public static PAResults loadResults(String[] stringArray, String string) throws IOException {
        String string2;
        String string3;
        if (stringArray != null && stringArray.length > 0) {
            string3 = stringArray[0];
            string2 = System.getProperty("file.separator");
            if (!string3.endsWith(string2)) {
                string3 = string3 + string2;
            }
        } else {
            string3 = "";
        }
        string2 = System.getProperty("pa.results", "pa");
        String string4 = "typed";
        PAResults pAResults = PAResults.loadResults(string4, string3, string2);
        return pAResults;
    }

    public static PAResults loadResults(String string, String string2, String string3) throws IOException {
        PA pA = PA.loadResults(string, string2, string3);
        PAResults pAResults = new PAResults(pA);
        pAResults.loadCallGraph(string2 + "callgraph");
        if (pA.CONTEXT_SENSITIVE || pA.OBJECT_SENSITIVE) {
            pA.addDefaults();
            pA.numberPaths(pAResults.cg, pA.ocg, false);
        }
        return pAResults;
    }

    public void loadCallGraph(String string) throws IOException {
        this.cg = new LoadedCallGraph(string);
    }

    public void interactive() {
        int n = 1;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DataInput dataInput = new DataInputStream(System.in);
        CollectionType collectionType = null;
        Stack<DataInputStream> stack = new Stack<DataInputStream>();
        while (true) {
            boolean bl = true;
            int n2 = 10;
            try {
                StringTokenizer stringTokenizer;
                String string;
                if (stack.isEmpty()) {
                    System.out.print(n + "> ");
                }
                if ((string = dataInput.readLine()) == null) {
                    if (stack.isEmpty()) {
                        return;
                    }
                    dataInput = (DataInput)stack.pop();
                    continue;
                }
                if (!stack.isEmpty()) {
                    System.out.println(n + "> " + string);
                }
                if (!(stringTokenizer = new StringTokenizer(string)).hasMoreElements()) continue;
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("quit") || string2.equals("exit")) break;
                if (string2.equals("include")) {
                    stack.push((DataInputStream)dataInput);
                    dataInput = new DataInputStream(new FileInputStream(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("relprod")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD2 = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD3 = this.parseBDDset(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD4 = (TypedBDDFactory.TypedBDD)typedBDD.relprod((BDD)typedBDD2, (BDD)typedBDD3);
                    arrayList.add(typedBDD4);
                } else if (string2.equals("replace")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    String string3 = stringTokenizer.nextToken();
                    BDDPairing bDDPairing = this.parsePairing(string3);
                    if (bDDPairing != null) {
                        arrayList.add(typedBDD.replace(bDDPairing));
                    } else {
                        System.out.println("No such pairing: " + string3);
                        bl = false;
                    }
                } else if (string2.equals("restrict")) {
                    TypedBDDFactory.TypedBDD typedBDD;
                    TypedBDDFactory.TypedBDD typedBDD5 = typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    while (stringTokenizer.hasMoreTokens()) {
                        TypedBDDFactory.TypedBDD typedBDD6 = this.parseBDD(arrayList, stringTokenizer.nextToken());
                        typedBDD5 = (TypedBDDFactory.TypedBDD)typedBDD5.restrict((BDD)typedBDD6);
                    }
                    arrayList.add(typedBDD5);
                } else if (string2.equals("exist")) {
                    TypedBDDFactory.TypedBDD typedBDD;
                    TypedBDDFactory.TypedBDD typedBDD7 = typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    while (stringTokenizer.hasMoreTokens()) {
                        TypedBDDFactory.TypedBDD typedBDD8 = this.parseBDDset(arrayList, stringTokenizer.nextToken());
                        typedBDD7 = (TypedBDDFactory.TypedBDD)typedBDD7.exist((BDD)typedBDD8);
                    }
                    arrayList.add(typedBDD7);
                } else if (string2.equals("diff")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD9 = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD10 = (TypedBDDFactory.TypedBDD)typedBDD.apply((BDD)typedBDD9, BDDFactory.diff);
                    arrayList.add(typedBDD10);
                } else if (string2.equals("and")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD11 = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD12 = (TypedBDDFactory.TypedBDD)typedBDD.and((BDD)typedBDD11);
                    arrayList.add(typedBDD12);
                } else if (string2.equals("cmp") || string2.equals("equals")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD13 = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    System.out.println(string2 + ' ' + typedBDD.equals((BDD)typedBDD13));
                    bl = false;
                } else if (string2.equals("or")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD14 = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD15 = (TypedBDDFactory.TypedBDD)typedBDD.or((BDD)typedBDD14);
                    arrayList.add(typedBDD15);
                } else if (string2.equals("findpath")) {
                    int n3;
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    SCCPathNumbering.Path path = this.findPath(n4, n3 = Integer.parseInt(stringTokenizer.nextToken()));
                    if (path != null) {
                        System.out.println(this.getMethod(n3));
                        this.printTrace(System.out, path);
                    } else {
                        System.out.println("there is no path from " + this.getMethod(n4) + " to " + this.getMethod(n3));
                    }
                    bl = false;
                } else if (string2.equals("store")) {
                    String string4 = stringTokenizer.nextToken();
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    this.storedBDDs.put(string4, typedBDD);
                    System.out.println("Stored BDD under name `" + string4 + '\'');
                    bl = false;
                } else if (string2.equals("satcount")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDDWithCheck(arrayList, stringTokenizer.nextToken());
                    System.out.println("Domains:  " + typedBDD.getDomainSet());
                    System.out.println("satCount: " + typedBDD.satCount((BDD)this.getDomains(typedBDD)));
                    bl = false;
                } else if (string2.equals("showdomains")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDDWithCheck(arrayList, stringTokenizer.nextToken());
                    System.out.println("Domains: " + typedBDD.getDomainSet());
                    bl = false;
                } else if (string2.equals("source")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDDWithCheck(arrayList, stringTokenizer.nextToken());
                    int n5 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : SourceLister.defaultLinesBefore;
                    int n6 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : SourceLister.defaultLinesAfter;
                    this.showSource(typedBDD, n5, n6);
                    bl = false;
                } else if (string2.equals("list")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDDWithCheck(arrayList, stringTokenizer.nextToken());
                    arrayList.add(typedBDD);
                    n2 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : -1;
                    System.out.println("Domains: " + typedBDD.getDomainSet());
                } else if (string2.equals("contextvar") || string2.equals("stacktracevar")) {
                    int n7 = Integer.parseInt(stringTokenizer.nextToken());
                    MethodSummary.Node node = this.getVariableNode(n7);
                    if (node == null) {
                        System.out.println("No method for node " + node);
                    } else {
                        jq_Method jq_Method2 = node.getDefiningMethod();
                        BigInteger bigInteger = new BigInteger(stringTokenizer.nextToken(), 10);
                        if (jq_Method2 == null) {
                            System.out.println("No method for node " + node);
                        } else {
                            SCCPathNumbering.Path path = ((SCCPathNumbering)this.r.vCnumbering).getPath(jq_Method2, bigInteger);
                            if (string2.equals("stacktracevar")) {
                                System.out.println(jq_Method2 + " called in context #" + bigInteger);
                                this.printTrace(System.out, path);
                            } else {
                                System.out.println(jq_Method2 + " context " + bigInteger + ":\n" + path);
                            }
                        }
                    }
                    bl = false;
                } else if (string2.equals("contextheap") || string2.equals("stacktraceheap")) {
                    int n8 = Integer.parseInt(stringTokenizer.nextToken());
                    MethodSummary.Node node = this.getHeapNode(n8);
                    if (node == null) {
                        System.out.println("No method for node " + node);
                    } else {
                        jq_Method jq_Method3 = node.getDefiningMethod();
                        BigInteger bigInteger = new BigInteger(stringTokenizer.nextToken(), 10);
                        if (jq_Method3 == null) {
                            System.out.println("No method for node " + node);
                        } else {
                            SCCPathNumbering.Path path = ((SCCPathNumbering)this.r.hCnumbering).getPath(jq_Method3, bigInteger);
                            if (string2.equals("stacktraceheap")) {
                                System.out.println(jq_Method3 + " called in context #" + bigInteger);
                                this.printTrace(System.out, path);
                            } else {
                                System.out.println(jq_Method3 + " context " + bigInteger + ": " + path);
                            }
                        }
                    }
                    bl = false;
                } else if (string2.equals("type")) {
                    jq_Class jq_Class2 = this.parseClassName(stringTokenizer.nextToken());
                    if (jq_Class2 == null || !jq_Class2.isLoaded()) {
                        System.out.println("Cannot find class");
                        bl = false;
                    } else {
                        System.out.println("Class: " + jq_Class2);
                        int n9 = this.getTypeIndex(jq_Class2);
                        arrayList.add(this.r.T1.ithVar(n9));
                    }
                } else if (string2.equals("method") || string2.equals("callsin") || string2.equals("summary") || string2.equals("params")) {
                    jq_Class jq_Class3 = this.parseClassName(stringTokenizer.nextToken());
                    if (jq_Class3 == null || !jq_Class3.isLoaded()) {
                        System.out.println("Cannot find class");
                        bl = false;
                    } else {
                        Textualizable textualizable;
                        Object object;
                        String string5 = stringTokenizer.nextToken();
                        jq_Method jq_Method4 = stringTokenizer.hasMoreTokens() ? (jq_Method)jq_Class3.getDeclaredMember(string5, stringTokenizer.nextToken()) : jq_Class3.getDeclaredMethod(string5);
                        if (jq_Method4 == null || !jq_Method4.isLoaded()) {
                            System.out.println("Cannot find method");
                            bl = false;
                        } else if (string2.equals("method")) {
                            int n10 = this.getMethodIndex(jq_Method4);
                            int n11 = this.getNameIndex(jq_Method4);
                            System.out.println("Method: " + jq_Method4 + " N(" + n11 + ')');
                            if (this.r.vCnumbering instanceof SCCPathNumbering) {
                                object = ((SCCPathNumbering)this.r.vCnumbering).getSCC(jq_Method4);
                                textualizable = ((SCCPathNumbering)this.r.vCnumbering).getRange(jq_Method4);
                                if (object != null) {
                                    System.out.println("is located in SCC #" + System.identityHashCode(object) + " of size " + ((SCComponent)object).size() + "; context range is " + textualizable);
                                }
                            }
                            arrayList.add(this.r.M.ithVar(n10));
                        } else {
                            MethodSummary methodSummary = MethodSummary.getSummary(CodeCache.getCode(jq_Method4));
                            if (string2.equals("callsin")) {
                                TypedBDDFactory.TypedBDD typedBDD = (TypedBDDFactory.TypedBDD)this.r.bdd.zero();
                                object = methodSummary.getCalls().iterator();
                                while (object.hasNext()) {
                                    textualizable = (ProgramLocation)object.next();
                                    int n12 = this.getInvokeIndex((ProgramLocation)textualizable);
                                    if (n12 == -1) {
                                        System.out.println("callsite not in index: " + textualizable + " at " + ((ProgramLocation)textualizable).toStringLong());
                                        continue;
                                    }
                                    typedBDD.orWith(this.r.I.ithVar(n12));
                                }
                                arrayList.add(typedBDD);
                            } else if (string2.equals("params")) {
                                int n13 = 0;
                                while (n13 < methodSummary.getNumOfParams()) {
                                    object = methodSummary.getParamNode(n13);
                                    System.out.println("\t" + object);
                                    ++n13;
                                }
                                bl = false;
                            } else {
                                System.out.println(methodSummary);
                                bl = false;
                            }
                        }
                    }
                } else if (string2.equals("field")) {
                    jq_Class jq_Class4 = this.parseClassName(stringTokenizer.nextToken());
                    if (jq_Class4 == null || !jq_Class4.isLoaded()) {
                        System.out.println("Cannot find class");
                        bl = false;
                    } else {
                        jq_Field jq_Field2 = jq_Class4.getDeclaredField(stringTokenizer.nextToken());
                        if (jq_Field2 == null) {
                            System.out.println("Cannot find field");
                            bl = false;
                        } else {
                            System.out.println("Field: " + jq_Field2);
                            int n14 = this.getFieldIndex(jq_Field2);
                            arrayList.add(this.r.F.ithVar(n14));
                        }
                    }
                } else if (string2.equals("thread")) {
                    int n15 = Integer.parseInt(stringTokenizer.nextToken());
                    jq_Method jq_Method5 = null;
                    Iterator iterator = PA.thread_runs.keySet().iterator();
                    while (--n15 >= 0) {
                        jq_Method5 = (jq_Method)iterator.next();
                    }
                    System.out.println(n15 + ": " + jq_Method5);
                    int n16 = this.getMethodIndex(jq_Method5);
                    arrayList.add(this.r.M.ithVar(n16));
                } else if (string2.equals("threadlocal")) {
                    TypedBDDFactory.TypedBDD typedBDD = (TypedBDDFactory.TypedBDD)this.getThreadLocalObjects();
                    arrayList.add(typedBDD);
                } else if (string2.equals("reachable")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD16 = (TypedBDDFactory.TypedBDD)this.getReachableVars((BDD)typedBDD);
                    arrayList.add(typedBDD16);
                } else if (string2.equals("usedef")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    BDD bDD = this.calculateUseDef((BDD)typedBDD);
                    arrayList.add(bDD);
                } else if (string2.equals("printusedef")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    this.printUseDefChain((BDD)typedBDD);
                    bl = false;
                } else if (string2.equals("dumpusedef")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream("usedef.dot"));
                    this.defUseGraph((BDD)typedBDD, false, dataOutputStream);
                    bl = false;
                } else if (string2.equals("defuse")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    BDD bDD = this.calculateDefUse((BDD)typedBDD);
                    arrayList.add(bDD);
                } else if (string2.equals("dumpdefuse")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream("defuse.dot"));
                    this.defUseGraph((BDD)typedBDD, true, dataOutputStream);
                    bl = false;
                } else if (string2.equals("encapsulation")) {
                    BDD bDD = this.getEncapsulatedHeapObjects();
                    arrayList.add(bDD);
                } else if (string2.equals("collectiontypes")) {
                    collectionType = new CollectionType(this);
                    TypedBDDFactory.TypedBDD typedBDD = collectionType.findCollectionTypes(stringTokenizer.hasMoreTokens());
                    arrayList.add(typedBDD);
                } else if (string2.equals("getsupertypes")) {
                    TypedBDDFactory.TypedBDD typedBDD = collectionType.determineSupertypes(stringTokenizer.hasMoreTokens());
                    arrayList.add(typedBDD);
                } else if (string2.equals("checkmusthaves")) {
                    TypedBDDFactory.TypedBDD typedBDD = collectionType.checkMustHaves(stringTokenizer.hasMoreTokens());
                    arrayList.add(typedBDD);
                } else if (string2.equals("checkbadtypes")) {
                    TypedBDDFactory.TypedBDD typedBDD = collectionType.checkBadTypes(stringTokenizer.hasMoreTokens());
                    arrayList.add(typedBDD);
                } else if (string2.equals("aando")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.listAppleAndOranges(stringTokenizer.hasMoreTokens());
                    arrayList.add(typedBDD);
                } else if (string2.equals("showargs")) {
                    TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(arrayList, stringTokenizer.nextToken());
                    TypedBDDFactory.TypedBDD typedBDD17 = this.showArguments(typedBDD);
                    arrayList.add(typedBDD17);
                } else if (string2.equals("castprecision")) {
                    int n17 = stringTokenizer.countTokens();
                    boolean bl2 = false;
                    if (n17 > 0) {
                        bl2 = true;
                    }
                    this.computeCastPrecision(bl2);
                    bl = false;
                } else if (string2.equals("gini")) {
                    this.computeGini(this.r.vCnumbering);
                    bl = false;
                } else if (string2.equals("stats")) {
                    this.printStats();
                    bl = false;
                } else if (string2.equals("help")) {
                    this.printHelp(arrayList);
                    bl = false;
                } else {
                    bl = false;
                    if (string2.equals("driver")) {
                        string2 = stringTokenizer.nextToken();
                    }
                    String[] stringArray = new String[stringTokenizer.countTokens() + 1];
                    stringArray[0] = string2;
                    int n18 = 1;
                    while (n18 < stringArray.length) {
                        stringArray[n18] = stringTokenizer.nextToken();
                        ++n18;
                    }
                    n18 = 0;
                    while (n18 < stringArray.length) {
                        n18 = Driver.processCommand(stringArray, n18);
                        ++n18;
                    }
                }
                if (!bl) continue;
                TypedBDDFactory.TypedBDD typedBDD = (TypedBDDFactory.TypedBDD)arrayList.get(n - 1);
                System.out.println(n + " -> " + this.toString(typedBDD, n2));
                boolean bl3 = false;
                if (n == arrayList.size()) {
                    bl3 = true;
                }
                Assert._assert(bl3);
                ++n;
            }
            catch (Exception exception) {
                System.err.println("Error: " + exception);
                exception.printStackTrace();
                bl = false;
            }
        }
    }

    public void printHelp(List list) {
        System.out.println("BDD manipulation:");
        System.out.println("relprod b1 b2 bs:                 relational product of b1 and b2 w.r.t. set bs");
        System.out.println("replace b1 pair:                  replace b1 according to pair");
        System.out.println("restrict b1 b2 (bi)*:             restrict b2 to bi in b1");
        System.out.println("exist b1 bs1 (bsi)*:              exist bs2 to bsi in b1");
        System.out.println("(and|or|diff) b1 b2:              compute b1 and|or|diff b2");
        System.out.println("(equals|cmp) b1 b2:               compare bdds b1 and b2");
        System.out.println("list b1 [#n]:                     list #n (or all) elements of bdd b1");
        System.out.println("showdomains b1:                   show domains of bdd b1");
        System.out.println("satcount b1:                      print satcount (restricted by domain)");
        System.out.println("store name b1:                    store BDD b1 under name");
        System.out.println("\nAnalysis Results:");
        System.out.println("dumpconnect # <fn>:               dump heap connectivity graph for heap object # to file fn");
        System.out.println("dumpallconnect <fn>:              dump entire heap connectivity graph to file fn");
        System.out.println("dumpdefuse b1:                    dump def/use graph to defuse.dot, bdd must be in V1xV1c");
        System.out.println("dumpusedef b1:                    dump use/def graph to usedef.dot, bdd must be in V1xV1c");
        System.out.println("threadlocal:                      run escape analysis");
        System.out.println("stats:                            print general statistics");
        System.out.println("contextvar #vidx #cidx:           show path in vCnumbering for var #vidx in context #");
        System.out.println("stacktracevar #vidx #cidx:        like contextvar, except print as stacktrace");
        System.out.println("contextheap #hidx #cidx:          show path in hCnumbering for heap obj #hidx in context #");
        System.out.println("stacktraceheap #hidx #cidx:       like contextheap, except print as stacktrace");
        System.out.println("findpath #from #to:               find a path in callgraph from method #from to #to");
        System.out.println("gini:                             compute unbiased Gini-coefficient for callgraph and show SCCs");
        System.out.println("\nProgram Information:");
        System.out.println("method  class name [signature]:   lookup method in class, shows M and N indices");
        System.out.println("callsin class name [signature]:   list all call sites in a given method");
        System.out.println("summary class name [signature]:   list method summary for a given method");
        System.out.println("params class name [signature]:    list method parameters for a given method");
        System.out.println("source bdd [#before [#after]]:    show source code surrounding items in bdd");
        System.out.println("field class name:                 show information about field name in class");
        System.out.println("\nHow to use this driver:");
        System.out.println("include file:                     execute commands in file");
        System.out.println("[driver] arg0 arg1 ...:           pass args to Main.Driver for interpretation");
        this.printAvailableBDDs(list);
    }

    public void printAvailableBDDs(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.r.bdd.numberOfDomains()) {
            arrayList.add(this.r.bdd.getDomain(n));
            ++n;
        }
        Class clazz = class$Compil3r$Analysis$IPA$PA;
        if (clazz == null) {
            clazz = class$Compil3r$Analysis$IPA$PA = PAResults.class$("[LCompil3r.Analysis.IPA.PA;", false);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            try {
                Class<?> clazz2 = fieldArray[n2].getType();
                Class clazz3 = class$org$sf$javabdd$BDD;
                if (clazz3 == null) {
                    clazz3 = PAResults.class$("[Lorg.sf.javabdd.BDD;", false);
                }
                if (clazz2 == clazz3 && fieldArray[n2].get(this.r) != null) {
                    if (n2 % 12 == 0) {
                        arrayList.add("\n" + fieldArray[n2].getName());
                    } else {
                        arrayList.add(fieldArray[n2].getName());
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++n2;
        }
        Class clazz4 = class$Compil3r$Analysis$IPA$PAResults;
        if (clazz4 == null) {
            clazz4 = class$Compil3r$Analysis$IPA$PAResults = PAResults.class$("[LCompil3r.Analysis.IPA.PAResults;", false);
        }
        fieldArray = clazz4.getDeclaredFields();
        n2 = 0;
        while (n2 < fieldArray.length) {
            try {
                Class<?> clazz5 = fieldArray[n2].getType();
                Class clazz6 = class$org$sf$javabdd$BDD;
                if (clazz6 == null) {
                    clazz6 = PAResults.class$("[Lorg.sf.javabdd.BDD;", false);
                }
                if (clazz5 == clazz6 && fieldArray[n2].get(this) != null) {
                    arrayList.add(fieldArray[n2].getName());
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++n2;
        }
        if (this.storedBDDs.size() > 0) {
            arrayList.add("stored BDDs " + this.storedBDDs.keySet() + '\n');
        }
        if (list.size() >= 1) {
            arrayList.add("and previous results 1.." + list.size());
        }
        System.out.println("\ncurrently known BDDs are " + arrayList);
    }

    public void printTrace(PrintStream printStream, SCCPathNumbering.Path path) {
        int n = path.size() - 1;
        while (n >= 0) {
            Object object = path.get(n);
            if (object instanceof ProgramLocation) {
                printStream.println(" at " + ((ProgramLocation)object).toStringLong());
            }
            --n;
        }
    }

    SCCPathNumbering.Path findPath(int n, int n2) {
        Collection<Object> collection;
        Object object;
        jq_Method jq_Method2 = this.getMethod(n);
        jq_Method jq_Method3 = this.getMethod(n2);
        if (jq_Method2 == null || jq_Method3 == null) {
            return null;
        }
        Navigator navigator = this.cg.getCallSiteNavigator();
        LinkedList<jq_Method> linkedList = new LinkedList<jq_Method>();
        HashMap hashMap = new HashMap();
        linkedList.addLast(jq_Method2);
        hashMap.put(jq_Method2, null);
        block0: while (linkedList.size() != 0) {
            object = linkedList.removeFirst();
            collection = navigator.next(object);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!hashMap.containsKey(e)) {
                    hashMap.put((jq_Method)e, object);
                    linkedList.addLast((jq_Method)e);
                }
                if (e == jq_Method3) break block0;
            }
        }
        if (!hashMap.containsKey(jq_Method3)) {
            return null;
        }
        object = new SCCPathNumbering.Path(jq_Method3);
        collection = hashMap.get(jq_Method3);
        while (collection != null) {
            object = new SCCPathNumbering.Path(collection, (SCCPathNumbering.Path)object);
            collection = hashMap.get(collection);
        }
        return object;
    }

    public jq_Class parseClassName(String string) {
        jq_Class jq_Class2 = (jq_Class)jq_Type.parseType(string);
        if (jq_Class2 != null) {
            return jq_Class2;
        }
        Iterator iterator = PrimordialClassLoader.loader.getAllTypes().iterator();
        while (iterator.hasNext()) {
            jq_Type jq_Type2 = (jq_Type)iterator.next();
            if (!(jq_Type2 instanceof jq_Class) || !(jq_Class2 = (jq_Class)jq_Type2).getJDKName().endsWith(string)) continue;
            return jq_Class2;
        }
        return null;
    }

    public MethodSummary.Node getVariableNode(int n) {
        if (n < 0 || n >= this.r.Vmap.size()) {
            return null;
        }
        MethodSummary.Node node = (MethodSummary.Node)this.r.Vmap.get(n);
        return node;
    }

    public int getVariableIndex(MethodSummary.Node node) {
        if (!this.r.Vmap.contains(node)) {
            return -1;
        }
        int n = this.r.Vmap.get(node);
        return n;
    }

    public ProgramLocation getInvoke(int n) {
        if (n < 0 || n >= this.r.Imap.size()) {
            return null;
        }
        ProgramLocation programLocation = (ProgramLocation)this.r.Imap.get(n);
        return programLocation;
    }

    public int getInvokeIndex(ProgramLocation programLocation) {
        if (!this.r.Imap.contains(programLocation = LoadedCallGraph.mapCall(programLocation))) {
            return -1;
        }
        int n = this.r.Imap.get(programLocation);
        return n;
    }

    public MethodSummary.Node getHeapNode(int n) {
        if (n < 0 || n >= this.r.Hmap.size()) {
            return null;
        }
        MethodSummary.Node node = (MethodSummary.Node)this.r.Hmap.get(n);
        return node;
    }

    public int getHeapIndex(MethodSummary.Node node) {
        if (!this.r.Hmap.contains(node)) {
            return -1;
        }
        int n = this.r.Hmap.get(node);
        return n;
    }

    public jq_Field getField(int n) {
        if (n < 0 || n >= this.r.Fmap.size()) {
            return null;
        }
        jq_Field jq_Field2 = (jq_Field)this.r.Fmap.get(n);
        return jq_Field2;
    }

    public int getFieldIndex(jq_Field jq_Field2) {
        if (!this.r.Fmap.contains(jq_Field2)) {
            return -1;
        }
        int n = this.r.Fmap.get(jq_Field2);
        return n;
    }

    public jq_Reference getType(int n) {
        if (n < 0 || n >= this.r.Tmap.size()) {
            return null;
        }
        jq_Reference jq_Reference2 = (jq_Reference)this.r.Tmap.get(n);
        return jq_Reference2;
    }

    public int getTypeIndex(jq_Type jq_Type2) {
        if (!this.r.Tmap.contains(jq_Type2)) {
            return -1;
        }
        int n = this.r.Tmap.get(jq_Type2);
        return n;
    }

    public jq_Method getName(int n) {
        if (n < 0 || n >= this.r.Nmap.size()) {
            return null;
        }
        jq_Method jq_Method2 = (jq_Method)this.r.Nmap.get(n);
        return jq_Method2;
    }

    public int getNameIndex(jq_Method jq_Method2) {
        if (!this.r.Nmap.contains(jq_Method2)) {
            return -1;
        }
        int n = this.r.Nmap.get(jq_Method2);
        return n;
    }

    public jq_Method getMethod(int n) {
        if (n < 0 || n >= this.r.Mmap.size()) {
            return null;
        }
        jq_Method jq_Method2 = (jq_Method)this.r.Mmap.get(n);
        return jq_Method2;
    }

    public int getMethodIndex(jq_Method jq_Method2) {
        if (!this.r.Mmap.contains(jq_Method2)) {
            return -1;
        }
        int n = this.r.Mmap.get(jq_Method2);
        return n;
    }

    TypedBDDFactory.TypedBDD getDomains(TypedBDDFactory.TypedBDD typedBDD) {
        TypedBDDFactory.TypedBDD typedBDD2 = (TypedBDDFactory.TypedBDD)typedBDD.getFactory().one();
        Set set = typedBDD.getDomainSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            BDDDomain bDDDomain = (BDDDomain)iterator.next();
            typedBDD2.andWith(bDDDomain.set());
        }
        return typedBDD2;
    }

    BDDDomain parseDomain(String string) {
        int n = 0;
        while (n < this.r.bdd.numberOfDomains()) {
            if (string.equals(this.r.bdd.getDomain(n).getName())) {
                return this.r.bdd.getDomain(n);
            }
            ++n;
        }
        return null;
    }

    TypedBDDFactory.TypedBDD parseBDDWithCheck(List list, String string) throws Exception {
        TypedBDDFactory.TypedBDD typedBDD = this.parseBDD(list, string);
        if (typedBDD == null) {
            this.printAvailableBDDs(list);
            throw new Exception("No such BDD: " + string);
        }
        return typedBDD;
    }

    BDDPairing parsePairing(String string) {
        try {
            Class clazz = class$Compil3r$Analysis$IPA$PA;
            if (clazz == null) {
                clazz = class$Compil3r$Analysis$IPA$PA = PAResults.class$("[LCompil3r.Analysis.IPA.PA;", false);
            }
            Field field = clazz.getDeclaredField(string);
            Class<?> clazz2 = field.getType();
            Class clazz3 = class$org$sf$javabdd$BDDPairing;
            if (clazz3 == null) {
                clazz3 = class$org$sf$javabdd$BDDPairing = PAResults.class$("[Lorg.sf.javabdd.BDDPairing;", false);
            }
            if (clazz2 == clazz3) {
                return (BDDPairing)field.get(this.r);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private final TypedBDDFactory.TypedBDD lookupBDDField(String string, Class clazz, Object object) {
        try {
            Field field = clazz.getDeclaredField(string);
            Class<?> clazz2 = field.getType();
            Class clazz3 = class$org$sf$javabdd$BDD;
            if (clazz3 == null) {
                clazz3 = class$org$sf$javabdd$BDD = PAResults.class$("[Lorg.sf.javabdd.BDD;", false);
            }
            if (clazz2 == clazz3) {
                return (TypedBDDFactory.TypedBDD)field.get(object);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    TypedBDDFactory.TypedBDD parseBDD(List list, String string) {
        TypedBDDFactory.TypedBDD typedBDD;
        int n = string.indexOf(40);
        if (n > 0) {
            int n2 = string.indexOf(41);
            if (n2 <= n) {
                return null;
            }
            String string2 = string.substring(0, n);
            BDDDomain bDDDomain = this.parseDomain(string2);
            if (bDDDomain == null) {
                return null;
            }
            long l = Long.parseLong(string.substring(n + 1, n2));
            return (TypedBDDFactory.TypedBDD)bDDDomain.ithVar(l);
        }
        Class clazz = class$Compil3r$Analysis$IPA$PA;
        if (clazz == null) {
            clazz = class$Compil3r$Analysis$IPA$PA = PAResults.class$("[LCompil3r.Analysis.IPA.PA;", false);
        }
        if ((typedBDD = this.lookupBDDField(string, clazz, this.r)) != null) {
            return typedBDD;
        }
        Class clazz2 = class$Compil3r$Analysis$IPA$PAResults;
        if (clazz2 == null) {
            clazz2 = class$Compil3r$Analysis$IPA$PAResults = PAResults.class$("[LCompil3r.Analysis.IPA.PAResults;", false);
        }
        if ((typedBDD = this.lookupBDDField(string, clazz2, this)) != null) {
            return typedBDD;
        }
        BDDDomain bDDDomain = this.parseDomain(string);
        if (bDDDomain != null) {
            return (TypedBDDFactory.TypedBDD)bDDDomain.domain();
        }
        TypedBDDFactory.TypedBDD typedBDD2 = (TypedBDDFactory.TypedBDD)this.storedBDDs.get(string);
        if (typedBDD2 != null) {
            return typedBDD2;
        }
        try {
            int n3 = Integer.parseInt(string) - 1;
            if (n3 >= 0 && n3 < list.size()) {
                return (TypedBDDFactory.TypedBDD)list.get(n3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string.equals("$last")) {
            return (TypedBDDFactory.TypedBDD)list.get(list.size() - 1);
        }
        if (string.equals("$one")) {
            return (TypedBDDFactory.TypedBDD)this.r.bdd.one();
        }
        if (string.equals("$zero")) {
            return (TypedBDDFactory.TypedBDD)this.r.bdd.zero();
        }
        return null;
    }

    TypedBDDFactory.TypedBDD parseBDDset(List list, String string) {
        BDDDomain bDDDomain = this.parseDomain(string);
        if (bDDDomain != null) {
            return (TypedBDDFactory.TypedBDD)bDDDomain.set();
        }
        return this.parseBDD(list, string);
    }

    public String toString(TypedBDDFactory.TypedBDD typedBDD, int n) {
        if (typedBDD == null) {
            return "<you passed 'null' to PAResult.toString>";
        }
        if (typedBDD.isZero()) {
            return "<empty>";
        }
        TypedBDDFactory.TypedBDD typedBDD2 = (TypedBDDFactory.TypedBDD)typedBDD.getFactory().one();
        Set set = typedBDD.getDomainSet();
        Object object = set.iterator();
        while (object.hasNext()) {
            BDDDomain bDDDomain = (BDDDomain)object.next();
            typedBDD2.andWith(bDDDomain.set());
        }
        object = new StringBuffer();
        int n2 = 0;
        Iterator iterator = typedBDD.iterator();
        while (iterator.hasNext()) {
            if (n >= 0 && n2 > n - 1) {
                ((StringBuffer)object).append("\tand " + ((long)typedBDD.satCount((BDD)typedBDD2) - (long)n) + " others.");
                ((StringBuffer)object).append(Strings.lineSep);
                break;
            }
            TypedBDDFactory.TypedBDD typedBDD3 = (TypedBDDFactory.TypedBDD)iterator.next();
            ((StringBuffer)object).append("\t(");
            ((StringBuffer)object).append(typedBDD3.toStringWithDomains((BDD.BDDToString)this.r.TS));
            ((StringBuffer)object).append(')');
            ((StringBuffer)object).append(Strings.lineSep);
            ++n2;
        }
        return ((StringBuffer)object).toString();
    }

    public BDD calculateHeapConnectivity(BDD bDD) {
        BDD bDD2 = this.r.bdd.zero();
        BDD bDD3 = this.r.hP.exist(this.r.Fset);
        while (true) {
            BDD bDD4 = bDD.relprod(bDD3, this.r.H1set);
            bDD4.replaceWith(this.r.H2toH1);
            bDD4.applyWith(bDD2.id(), BDDFactory.diff);
            bDD2.orWith(bDD4.id());
            if (bDD4.isZero()) break;
            bDD = bDD4;
            ++this.heapConnectivitySteps;
        }
        bDD3.free();
        ++this.heapConnectivityQueries;
        return bDD2;
    }

    public BDD calculateCommonSupertype(BDD bDD) {
        BDD bDD2;
        BDD bDD3;
        if (bDD.isZero()) {
            return this.r.bdd.zero();
        }
        BDD bDD4 = this.r.T1.domain();
        Iterator iterator = bDD.iterator(this.r.T2set);
        while (iterator.hasNext()) {
            bDD3 = (BDD)iterator.next();
            bDD2 = bDD3.relprod(this.r.aT, this.r.T2set);
            bDD3.free();
            bDD4.andWith(bDD2);
        }
        iterator = bDD4.iterator(this.r.T1set);
        while (iterator.hasNext()) {
            bDD3 = (BDD)iterator.next();
            bDD2 = bDD3.relprod(this.r.aT, this.r.T1set);
            bDD3.free();
            bDD2.replaceWith(this.r.T2toT1);
            bDD2.andWith(bDD4.id());
            if (bDD2.satCount(this.r.T1set) != 1.0) continue;
            return bDD2;
        }
        System.out.println("No subtype matches! " + bDD4.toStringWithDomains((BDD.BDDToString)this.r.TS));
        return this.r.bdd.zero();
    }

    public BDD calculateUseDef(BDD bDD) {
        BDD bDD2 = this.r.A.relprod(bDD, this.r.V1set);
        bDD2.replaceWith(this.r.V2toV1);
        BDD bDD3 = bDD.replace(this.r.V1toV2);
        BDD bDD4 = this.r.L.relprod(bDD3, this.r.V2set);
        bDD3.free();
        BDD bDD5 = this.r.vP.relprod(bDD4, this.r.V1set);
        bDD4.free();
        BDD bDD6 = this.r.hP.relprod(bDD5, this.r.H1Fset);
        bDD5.free();
        bDD6.replaceWith(this.r.H2toH1);
        BDD bDD7 = this.r.vP.relprod(bDD6, this.r.H1set);
        bDD6.free();
        bDD7.orWith(bDD2);
        return bDD7;
    }

    public BDD calculateDefUse(BDD bDD) {
        BDD bDD2 = bDD.replace(this.r.V1toV2);
        BDD bDD3 = this.r.A.relprod(bDD2, this.r.V2set);
        BDD bDD4 = this.r.S.relprod(bDD2, this.r.V2set);
        bDD2.free();
        BDD bDD5 = this.r.vP.relprod(bDD4, this.r.V1set);
        bDD4.free();
        BDD bDD6 = this.r.vP.relprod(bDD5, this.r.H1set);
        bDD5.free();
        BDD bDD7 = this.r.L.relprod(bDD6, this.r.V1Fset);
        bDD7.replaceWith(this.r.V2toV1);
        bDD7.orWith(bDD3);
        return bDD7;
    }

    public void defUseGraph(BDD bDD, boolean bl, DataOutput dataOutput) throws IOException {
        dataOutput.writeBytes("digraph \"");
        if (bl) {
            dataOutput.writeBytes("DefUse");
        } else {
            dataOutput.writeBytes("UseDef");
        }
        dataOutput.writeBytes("\" {\n");
        HashWorklist hashWorklist = new HashWorklist(true);
        BDD bDD2 = bDD.id();
        int n = -1;
        MethodSummary.Node node = null;
        while (true) {
            if (!bDD2.isZero()) {
                String string;
                int n2 = (int)bDD2.scanVar(this.r.V1);
                MethodSummary.Node node2 = this.getVariableNode(n2);
                if (hashWorklist.add(node2)) {
                    string = this.r.LONG_LOCATIONS ? this.r.findInMap(this.r.Vmap, n2) : node2.toString();
                    dataOutput.writeBytes("n" + n2 + " [label=\"" + string + "\"];\n");
                }
                if (node != null) {
                    if (bl) {
                        dataOutput.writeBytes("n" + n + " -> n" + n2 + ";\n");
                    } else {
                        dataOutput.writeBytes("n" + n2 + " -> n" + n + ";\n");
                    }
                }
                string = this.r.V1.ithVar(n2);
                string.andWith(this.r.V1c.domain());
                bDD2.applyWith((BDD)string, BDDFactory.diff);
                continue;
            }
            if (hashWorklist.isEmpty()) break;
            node = (MethodSummary.Node)hashWorklist.pull();
            n = this.getVariableIndex(node);
            BDD bDD3 = this.r.V1.ithVar(n);
            bDD3.andWith(this.r.V1c.domain());
            bDD2 = bl ? this.calculateDefUse(bDD3) : this.calculateUseDef(bDD3);
        }
        dataOutput.writeBytes("}\n");
    }

    public void printUseDefChain(BDD bDD) {
        BDD bDD2 = this.r.bdd.zero();
        bDD = bDD.id();
        int n = 1;
        while (!bDD.isZero()) {
            System.out.println("Step " + n + ':');
            System.out.println(bDD.toStringWithDomains((BDD.BDDToString)this.r.TS));
            bDD2.orWith(bDD.id());
            BDD bDD3 = this.r.A.relprod(bDD, this.r.V1set);
            bDD.replaceWith(this.r.V1toV2);
            BDD bDD4 = this.r.L.relprod(bDD, this.r.V2set);
            bDD.free();
            BDD bDD5 = this.r.vP.relprod(bDD4, this.r.V1set);
            bDD4.free();
            BDD bDD6 = this.r.hP.relprod(bDD5, this.r.H1Fset);
            bDD5.free();
            bDD6.replaceWith(this.r.H2toH1);
            BDD bDD7 = this.r.vP.relprod(bDD6, this.r.H1set);
            bDD6.free();
            bDD = bDD3;
            bDD.replaceWith(this.r.V2toV1);
            bDD.orWith(bDD7);
            bDD.applyWith(bDD2.id(), BDDFactory.diff);
            ++n;
        }
    }

    public void printDefUseChain(BDD bDD) {
        BDD bDD2 = this.r.bdd.zero();
        bDD = bDD.id();
        int n = 1;
        while (!bDD.isZero()) {
            System.out.println("Step " + n + ':');
            System.out.println(bDD.toStringWithDomains((BDD.BDDToString)this.r.TS));
            bDD2.orWith(bDD.id());
            BDD bDD3 = this.r.A.relprod(bDD, this.r.V2set);
            bDD.replaceWith(this.r.V2toV1);
            BDD bDD4 = this.r.L.relprod(bDD, this.r.V1set);
            bDD.free();
            BDD bDD5 = this.r.vP.relprod(bDD4, this.r.V2set);
            bDD4.free();
            BDD bDD6 = this.r.hP.relprod(bDD5, this.r.H2Fset);
            bDD5.free();
            bDD6.replaceWith(this.r.H1toH2);
            BDD bDD7 = this.r.vP.relprod(bDD6, this.r.H2set);
            bDD6.free();
            bDD = bDD3;
            bDD.replaceWith(this.r.V1toV2);
            bDD.orWith(bDD7);
            bDD.applyWith(bDD2.id(), BDDFactory.diff);
            ++n;
        }
    }

    public BDD getReachableVars(BDD bDD) {
        BDD bDD2 = this.r.bdd.zero();
        BDD bDD3 = this.r.mI.exist(this.r.Nset);
        BDD bDD4 = bDD.id();
        BDD bDD5 = this.r.Iset.and(this.r.V2c.set());
        BDD bDD6 = this.r.CONTEXT_SENSITIVE || this.r.OBJECT_SENSITIVE ? this.r.IEcs : this.r.IE;
        int n = 1;
        while (true) {
            BDD bDD7 = bDD4.relprod(this.r.mV, this.r.Mset);
            bDD2.orWith(bDD7);
            BDD bDD8 = bDD4.relprod(bDD3, this.r.Mset);
            bDD8.replaceWith(this.r.V1ctoV2c);
            BDD bDD9 = bDD8.relprod(bDD6, bDD5);
            bDD4.orWith(bDD9);
            bDD4.applyWith(bDD.id(), BDDFactory.diff);
            if (bDD4.isZero()) break;
            bDD.orWith(bDD4.id());
            ++n;
        }
        return bDD2;
    }

    public BDD getTransitiveModSet(BDD bDD) {
        BDD bDD2 = this.getReachableVars(bDD);
        BDD bDD3 = this.r.S.relprod(bDD2, this.r.V2set);
        BDD bDD4 = bDD3.relprod(this.r.vP, this.r.V1set);
        return bDD4;
    }

    public BDD getTransitiveRefSet(BDD bDD) {
        BDD bDD2 = this.getReachableVars(bDD);
        BDD bDD3 = this.r.L.relprod(bDD2, this.r.V2set);
        BDD bDD4 = bDD3.relprod(this.r.vP, this.r.V1set);
        return bDD4;
    }

    public BDD getThreadLocalObjects() {
        Set set;
        Object object;
        jq_Method jq_Method2;
        jq_NameAndDesc jq_NameAndDesc2 = new jq_NameAndDesc("main", "([Ljava/lang/String;)V");
        jq_Method jq_Method3 = null;
        Iterator iterator = this.r.Mmap.iterator();
        while (iterator.hasNext()) {
            jq_Method2 = (jq_Method)iterator.next();
            if (!jq_NameAndDesc2.equals(jq_Method2.getNameAndDesc())) continue;
            jq_Method3 = jq_Method2;
            System.out.println("Using main() method: " + jq_Method3);
            break;
        }
        iterator = this.r.bdd.zero();
        jq_Method2 = this.r.bdd.zero();
        if (jq_Method3 != null) {
            int n = this.r.Mmap.get(jq_Method3);
            object = this.r.M.ithVar(n);
            object.andWith(this.r.V1c.ithVar(0));
            System.out.println("Main: " + object.toStringWithDomains());
            BDD bDD = this.getReachableVars((BDD)object);
            object.free();
            System.out.println("Reachable vars: " + bDD.satCount(this.r.V1set));
            set = bDD.relprod(this.r.vP, this.r.V1set);
            bDD.free();
            System.out.println("Reachable objects: " + set.satCount(this.r.H1set));
            iterator.orWith((BDD)set);
        }
        Iterator iterator2 = PA.thread_runs.keySet().iterator();
        while (iterator2.hasNext()) {
            object = (jq_Method)iterator2.next();
            int n = this.r.Mmap.get(object);
            set = (Set)PA.thread_runs.get(object);
            if (set == null) {
                System.out.println("Unknown run() method: " + object);
                continue;
            }
            Iterator iterator3 = set.iterator();
            int n2 = 0;
            while (iterator3.hasNext()) {
                MethodSummary.Node node = (MethodSummary.Node)iterator3.next();
                BDD bDD = this.r.M.ithVar(n);
                bDD.andWith(this.r.V1c.ithVar(n2));
                System.out.println("Thread: " + bDD.toStringWithDomains() + " Object: " + node);
                BDD bDD2 = this.getReachableVars(bDD);
                bDD.free();
                System.out.println("Reachable vars: " + bDD2.satCount(this.r.V1set));
                BDD bDD3 = bDD2.relprod(this.r.vP, this.r.V1set);
                bDD2.free();
                System.out.println("Reachable objects: " + bDD3.satCount(this.r.H1set));
                BDD bDD4 = iterator.and(bDD3);
                System.out.println("Shared objects: " + bDD4.satCount(this.r.H1set));
                jq_Method2.orWith(bDD4);
                iterator.orWith(bDD3);
                ++n2;
            }
        }
        System.out.println("All shared objects: " + jq_Method2.satCount(this.r.H1set));
        iterator.applyWith((BDD)jq_Method2, BDDFactory.diff);
        System.out.println("All local objects: " + iterator.satCount(this.r.H1set));
        return iterator;
    }

    public void initializeExtraDomains() {
        if (this.H3 == null) {
            this.H3 = this.r.makeDomain("H3", this.r.H_BITS);
            this.H1toH3 = this.r.bdd.makePair(this.r.H1, this.H3);
        }
    }

    public BDD getHashcodeTakenVars() {
        jq_NameAndDesc jq_NameAndDesc2 = new jq_NameAndDesc("hashCode", "()I");
        jq_Method jq_Method2 = PrimordialClassLoader.getJavaLangObject().getDeclaredInstanceMethod(jq_NameAndDesc2);
        BDD bDD = this.r.M.ithVar(this.r.Mmap.get(jq_Method2));
        BDD bDD2 = this.r.IE.relprod(bDD, this.r.Mset);
        bDD2.andWith(this.r.Z.ithVar(0));
        System.out.println("Invokes: " + bDD2.toStringWithDomains());
        BDD bDD3 = this.r.actual.relprod(bDD2, this.r.Iset.and(this.r.Zset));
        System.out.println("Actual: " + bDD3.toStringWithDomains());
        bDD3.replaceWith(this.r.V2toV1);
        jq_NameAndDesc2 = new jq_NameAndDesc("identityHashCode", "(Ljava/lang/Object;)I");
        jq_Method2 = PrimordialClassLoader.getJavaLangSystem().getDeclaredStaticMethod(jq_NameAndDesc2);
        bDD = this.r.M.ithVar(this.r.Mmap.get(jq_Method2));
        bDD2 = this.r.IE.relprod(bDD, this.r.Mset);
        bDD2.andWith(this.r.Z.ithVar(1));
        System.out.println("Invokes: " + bDD2.toStringWithDomains());
        BDD bDD4 = this.r.actual.relprod(bDD2, this.r.Iset.and(this.r.Zset));
        System.out.println("Actual: " + bDD4.toStringWithDomains());
        bDD4.replaceWith(this.r.V2toV1);
        bDD3.orWith(bDD4);
        if (this.r.CONTEXT_SENSITIVE || this.r.OBJECT_SENSITIVE) {
            bDD3.andWith(this.r.V1c.set());
        }
        return bDD3;
    }

    public BDD getEncapsulatedHeapObjects() {
        this.initializeExtraDomains();
        BDD bDD = this.r.hP.exist(this.r.H1cH2cset).exist(this.r.Fset);
        BDD bDD2 = this.r.H1.set().and(this.r.H2.set());
        BDD bDD3 = this.r.H1.buildEquals(this.H3).andWith(this.r.H2.domain());
        BDD bDD4 = this.r.H1.set().andWith(this.H3.set());
        BDD bDD5 = bDD.replace(this.H1toH3);
        bDD5.andWith(bDD.id());
        BDD bDD6 = bDD5.applyAll(bDD3, BDDFactory.imp, bDD4);
        bDD5.free();
        bDD3.free();
        bDD6.andWith(bDD.id());
        System.out.println("Number = " + bDD6.satCount(bDD2));
        BDD bDD7 = this.r.bdd.zero();
        int n = 0;
        int n2 = 0;
        while (n2 < this.r.Hmap.size()) {
            BDD bDD8 = this.r.H2.ithVar(n2);
            BDD bDD9 = bDD.restrict(bDD8);
            if (bDD9.satCount(this.r.H1.set()) == 1.0) {
                ++n;
                bDD7.orWith(bDD8.and(bDD9));
            }
            bDD8.free();
            bDD9.free();
            ++n2;
        }
        System.out.println("Number = " + bDD7.satCount(bDD2));
        if (!bDD6.equals(bDD7)) {
            System.out.println("a has extra: " + bDD6.apply(bDD7, BDDFactory.diff).toStringWithDomains());
            System.out.println("a is missing: " + bDD7.apply(bDD6, BDDFactory.diff).toStringWithDomains());
        }
        return bDD7;
    }

    public TypedBDDFactory.TypedBDD typesThatOverrideEquals() {
        jq_NameAndDesc jq_NameAndDesc2 = new jq_NameAndDesc("equals", "(Ljava/lang/Object;)Z");
        jq_InstanceMethod jq_InstanceMethod2 = PrimordialClassLoader.getJavaLangObject().getDeclaredInstanceMethod(jq_NameAndDesc2);
        BDD bDD = this.r.N.ithVar(this.getNameIndex(jq_InstanceMethod2));
        BDD bDD2 = this.r.cha.restrict(bDD);
        BDD bDD3 = bDD2.exist(this.r.Mset);
        bDD2.free();
        return (TypedBDDFactory.TypedBDD)bDD3;
    }

    public TypedBDDFactory.TypedBDD showArguments(TypedBDDFactory.TypedBDD typedBDD) {
        return (TypedBDDFactory.TypedBDD)this.r.actual.and((BDD)typedBDD).replaceWith(this.r.bdd.makePair(this.r.V2, this.r.V1)).and(this.r.vP);
    }

    public TypedBDDFactory.TypedBDD listAppleAndOranges(boolean bl) {
        jq_NameAndDesc jq_NameAndDesc2 = new jq_NameAndDesc("equals", "(Ljava/lang/Object;)Z");
        jq_InstanceMethod jq_InstanceMethod2 = PrimordialClassLoader.getJavaLangObject().getDeclaredInstanceMethod(jq_NameAndDesc2);
        BDD bDD = this.r.N.ithVar(this.getNameIndex(jq_InstanceMethod2));
        TypedBDDFactory.TypedBDD typedBDD = (TypedBDDFactory.TypedBDD)this.r.mI.restrict(bDD).exist(this.r.Mset);
        TypedBDDFactory.TypedBDD typedBDD2 = this.typesThatOverrideEquals();
        Iterator iterator = typedBDD.iterator();
        TypedBDDFactory.TypedBDD typedBDD3 = (TypedBDDFactory.TypedBDD)this.r.bdd.zero();
        BDDPairing bDDPairing = this.r.bdd.makePair(this.r.V2, this.r.V1);
        while (iterator.hasNext()) {
            BDD bDD2 = (BDD)iterator.next();
            BDD bDD3 = this.r.actual.restrict(bDD2).relprod(this.r.Z.ithVar(0), this.r.Zset);
            bDD3.replaceWith(bDDPairing);
            BDD bDD4 = this.r.vP.relprod(bDD3, this.r.V1set);
            BDD bDD5 = bDD4.and(this.r.hT);
            bDD4.free();
            bDD5.applyWith(typedBDD2.and(this.r.H1set), BDDFactory.diff);
            bDD4 = bDD5.exist(this.r.T2set);
            bDD5.free();
            BDD bDD6 = this.r.actual.restrict(bDD2).relprod(this.r.Z.ithVar(1), this.r.Zset);
            bDD6.replaceWith(bDDPairing);
            BDD bDD7 = this.r.vP.relprod(bDD6, this.r.V1set);
            if (bDD4.and(bDD7).isZero()) {
                typedBDD3.orWith(bDD2);
            }
            bDD4.free();
            bDD7.free();
        }
        return typedBDD3;
    }

    public void printStats() throws IOException {
        Object object;
        BDD bDD;
        Object object2;
        System.out.println("Number of types=" + this.r.Tmap.size());
        System.out.println("Number of methods=" + this.r.Mmap.size());
        int n = 0;
        Iterator iterator = this.r.Mmap.iterator();
        while (iterator.hasNext()) {
            jq_Method jq_Method2 = (jq_Method)iterator.next();
            if (jq_Method2.getBytecode() == null) continue;
            n += jq_Method2.getBytecode().length;
        }
        System.out.println("Number of bytecodes=" + n);
        System.out.println("Number of virtual call sites=" + this.r.Imap.size());
        System.out.println("Number of virtual call names=" + this.r.Nmap.size());
        System.out.println("Number of variables=" + this.r.Vmap.size());
        System.out.println("Number of heap objects=" + this.r.Hmap.size());
        System.out.println("Number of fields=" + this.r.Fmap.size());
        System.out.println("Number of callgraph edges=" + this.r.IE.satCount(this.r.Iset.and(this.r.Mset)));
        iterator = this.r.vP.exist(this.r.H1set);
        iterator.orWith(this.r.A.exist(this.r.V2set));
        iterator.orWith(this.r.A.exist(this.r.V1set).replaceWith(this.r.V2toV1));
        iterator.orWith(this.r.L.exist(this.r.V2Fset));
        iterator.orWith(this.r.L.exist(this.r.V1Fset).replaceWith(this.r.V2toV1));
        double d = this.r.vP.satCount(this.r.V1H1set);
        double d2 = iterator.satCount(this.r.V1set);
        System.out.println("Points-to: " + d + " / " + d2 + " = " + d / d2);
        BDD bDD2 = this.r.vP.exist(this.r.V1set);
        double d3 = this.r.hP.satCount(this.r.H1FH2set);
        double d4 = this.r.hP.exist(this.r.H2set).satCount(this.r.H1Fset);
        double d5 = bDD2.satCount(this.r.H1set);
        System.out.println("Heap object points to (all fields): " + d3 + " / " + d5 + " = " + d3 / d5);
        long l = 0L;
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        int n3 = 0;
        while (n3 < this.r.Hmap.size() && n3 < 4000) {
            object2 = this.r.H1.ithVar(n3);
            if (this.r.CONTEXT_SENSITIVE) {
                object2.andWith(this.r.H1c.domain());
            }
            bDD = this.calculateHeapConnectivity((BDD)object2);
            l = (long)((double)l + bDD.satCount(this.r.H1set));
            ++n2;
            bDD.free();
            object = this.r.hP.relprod((BDD)object2, this.r.H1set);
            l2 = (long)((double)l2 + object.satCount(this.r.H2Fset));
            l3 = (long)((double)l3 + object.exist(this.r.H2set).satCount(this.r.Fset));
            object2.free();
            ++n3;
        }
        System.out.println("Heap connectivity: " + l + " / " + n2 + " = " + (double)l / (double)n2 + "           ");
        System.out.println("Heap chain length: " + this.heapConnectivitySteps + " / " + this.heapConnectivityQueries + " = " + (double)this.heapConnectivitySteps / (double)this.heapConnectivityQueries);
        System.out.println("Heap points-to, per field: " + l2 + " / " + l3 + " = " + (double)l2 / (double)l3);
        BDD bDD3 = this.r.hP.exist(this.r.H1set);
        int n4 = 0;
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        HashSet<jq_Class> hashSet = new HashSet<jq_Class>();
        int n7 = 0;
        while (n7 < this.r.Fmap.size()) {
            BDD bDD4 = this.r.F.ithVar(n7);
            object2 = bDD3.restrict(bDD4);
            if (object2.isZero()) {
                ++n5;
            } else {
                object2.replaceWith(this.r.H2toH1);
                if (object2.satCount(this.r.H1set) == 1.0) {
                    ++n2;
                }
                bDD = object2.relprod(this.r.hT, this.r.H1set);
                object = (jq_Field)this.r.Fmap.get(n7);
                if (bDD.satCount(this.r.T2set) == 1.0) {
                    ++n4;
                } else if (object != null && !((jq_Member)object).isStatic()) {
                    hashSet.add(((jq_Member)object).getDeclaringClass());
                }
                BDD bDD5 = this.calculateCommonSupertype(bDD);
                if (object != null) {
                    int n8 = this.r.Tmap.get(((jq_Field)object).getType());
                    BDD bDD6 = this.r.T1.ithVar(n8);
                    if (!bDD5.equals(bDD6)) {
                        bDD5.replaceWith(this.r.T1toT2);
                        if (bDD5.andWith(bDD6).and(this.r.aT).isZero()) {
                            System.out.println("Field " + object);
                            System.out.println(" Declared: " + ((jq_Field)object).getType() + " Computed: " + bDD5.toStringWithDomains((BDD.BDDToString)this.r.TS));
                        } else {
                            ++n6;
                        }
                    }
                    bDD6.free();
                }
                bDD.free();
                bDD5.free();
                object2.free();
                bDD4.free();
            }
            ++n7;
        }
        System.out.println("Refined-type fields: " + n6 + " / " + this.r.Fmap.size() + " = " + (double)n6 / (double)this.r.Fmap.size());
        System.out.println("Single-type fields: " + n4 + " / " + this.r.Fmap.size() + " = " + (double)n4 / (double)this.r.Fmap.size());
        System.out.println("Single-object fields: " + n2 + " / " + this.r.Fmap.size() + " = " + (double)n2 / (double)this.r.Fmap.size());
        System.out.println("Unused fields: " + n5 + " / " + this.r.Fmap.size() + " = " + (double)n5 / (double)this.r.Fmap.size());
        System.out.println("Poly classes: " + hashSet.size());
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream("polyclasses"));
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            object2 = (jq_Class)iterator2.next();
            dataOutputStream.writeBytes(((jq_Class)object2).getJDKName() + '\n');
        }
        if (this.r.CONTEXT_SENSITIVE) {
            System.out.println("Thread-local objects: " + this.countThreadLocalObjects());
        }
        bDD3 = this.getHashcodeTakenVars();
        BDD bDD7 = bDD3.relprod(this.r.vP, this.r.V1set);
        System.out.println("Hashcode taken objects: " + bDD7.satCount(this.r.H1set));
        bDD7 = bDD7.exist(this.r.H1c.set());
        System.out.println("Hashcode taken objects (no context): " + bDD7.satCount(this.r.H1.set()));
        System.out.println("Hashcode never taken objects (no context): " + ((double)this.r.Hmap.size() - bDD7.satCount(this.r.H1.set())));
        bDD3 = this.r.sync;
        if (this.r.CONTEXT_SENSITIVE || this.r.OBJECT_SENSITIVE) {
            bDD3.andWith(this.r.H1c.domain());
        }
        bDD7 = bDD3.relprod(this.r.vP, this.r.V1set);
        System.out.println("Locked objects: " + bDD7.satCount(this.r.H1set));
        bDD7 = bDD7.exist(this.r.H1c.set());
        System.out.println("Locked objects (no context): " + bDD7.satCount(this.r.H1.set()));
        System.out.println("Never locked objects (no context): " + ((double)this.r.Hmap.size() - bDD7.satCount(this.r.H1.set())));
        bDD3 = this.r.mI.exist(this.r.Mset.and(this.r.Nset));
        double d6 = bDD3.satCount(this.r.Iset);
        System.out.println("Virtual call sites: " + d6);
        double d7 = this.r.IE.satCount(this.r.IMset);
        System.out.println("Average vcall targets = " + d7 + " / " + d6 + " = " + d7 / d6);
    }

    public int countPointsTo(BDD bDD) {
        BDD bDD2 = this.r.vP.relprod(bDD, this.r.V1set);
        double d = bDD2.satCount(this.r.H1.set());
        return (int)d;
    }

    public int countTransitiveReachingDefs(BDD bDD) {
        BDD bDD2 = this.r.bdd.zero();
        bDD = bDD.id();
        int n = 1;
        while (!bDD.isZero()) {
            bDD2.orWith(bDD.id());
            BDD bDD3 = this.r.A.relprod(bDD, this.r.V1set);
            bDD.replaceWith(this.r.V1toV2);
            BDD bDD4 = this.r.L.relprod(bDD, this.r.V2set);
            bDD.free();
            BDD bDD5 = this.r.vP.relprod(bDD4, this.r.V1set);
            bDD4.free();
            BDD bDD6 = this.r.hP.relprod(bDD5, this.r.H1Fset);
            bDD5.free();
            bDD6.replaceWith(this.r.H2toH1);
            BDD bDD7 = this.r.vP.relprod(bDD6, this.r.H1set);
            bDD6.free();
            bDD = bDD3;
            bDD.replaceWith(this.r.V2toV1);
            bDD.orWith(bDD7);
            bDD.applyWith(bDD2.id(), BDDFactory.diff);
            ++n;
        }
        double d = bDD2.satCount(this.r.V1.set());
        return (int)d;
    }

    public int countThreadLocalObjects() {
        BDD bDD = this.getThreadLocalObjects();
        double d = bDD.satCount(this.r.H1set);
        return (int)d;
    }

    public Set getCallTargets(ProgramLocation.QuadProgramLocation quadProgramLocation) {
        BDD bDD;
        ProgramLocation programLocation = LoadedCallGraph.mapCall(quadProgramLocation);
        quadProgramLocation = null;
        if (programLocation.isSingleTarget()) {
            LinearSet linearSet = new LinearSet();
            linearSet.add(programLocation.getTargetMethod());
            return linearSet;
        }
        if (!this.r.Imap.contains(programLocation)) {
            System.err.println("No call information about " + programLocation.toString());
            return new LinearSet();
        }
        BDD bDD2 = this.r.actual.restrict(this.r.Z.ithVar(0));
        bDD2.replaceWith(this.r.bdd.makePair(this.r.V2, this.r.V1));
        BDD bDD3 = this.r.mI.exist(this.r.Mset);
        BDD bDD4 = bDD2.and(bDD3);
        bDD2.free();
        bDD3.free();
        BDD bDD5 = bDD4.relprod(this.r.vP, this.r.V1set);
        BDD bDD6 = bDD5.relprod(this.r.hT, this.r.H1set);
        bDD5.free();
        BDD bDD7 = bDD6.relprod(this.r.cha, this.r.T2Nset);
        bDD6.free();
        this.r.IE.orWith(bDD7.id());
        if (this.r.CONTEXT_SENSITIVE || this.r.THREAD_SENSITIVE) {
            bDD7.andWith(this.r.IEfilter.id());
            this.r.IEcs.orWith(bDD7.id());
            bDD = bDD7.exist(this.r.V1cV2cset);
            bDD7.free();
        } else {
            bDD = bDD7;
        }
        int n = this.r.Imap.size();
        int n2 = this.r.Imap.get(programLocation);
        BDD bDD8 = this.r.I.ithVar(n2);
        bDD.restrictWith(bDD8);
        System.err.println(((TypedBDDFactory.TypedBDD)bDD).getDomainSet().toString() + ": " + bDD.satCount());
        return new PACallGraph.BDDSet(bDD, this.r.M, this.r.Mmap);
    }

    public Set getCallTargets2(ProgramLocation programLocation) {
        Collection collection = this.cg.getTargetMethods(programLocation);
        return new HashSet(collection);
    }

    public Set mod(ProgramLocation.QuadProgramLocation quadProgramLocation, BasicBlock basicBlock) {
        if (quadProgramLocation.isCall()) {
            ProgramLocation programLocation = LoadedCallGraph.mapCall(quadProgramLocation);
            if (!this.r.Imap.contains(programLocation)) {
                return null;
            }
            int n = this.r.Imap.get(programLocation);
            BDD bDD = this.r.I.ithVar(n);
            BDD bDD2 = this.r.IEcs.relprod(bDD, this.r.V2c.set().and(this.r.Iset));
            BDD bDD3 = this.getTransitiveModSet(bDD2);
            BDD bDD4 = bDD3.exist(this.r.H1c.set());
            return new HeapLocationSet(bDD4);
        }
        jq_Method jq_Method2 = quadProgramLocation.getMethod();
        Quad quad = quadProgramLocation.getQuad();
        boolean bl = false;
        if (basicBlock != null) {
            bl = true;
        }
        Assert._assert(bl);
        return this.mod(jq_Method2, basicBlock, quad);
    }

    public Set ref(ProgramLocation.QuadProgramLocation quadProgramLocation, BasicBlock basicBlock) {
        if (quadProgramLocation.isCall()) {
            ProgramLocation programLocation = LoadedCallGraph.mapCall(quadProgramLocation);
            if (!this.r.Imap.contains(programLocation)) {
                return null;
            }
            int n = this.r.Imap.get(quadProgramLocation);
            BDD bDD = this.r.I.ithVar(n);
            BDD bDD2 = this.r.IEcs.relprod(bDD, this.r.V2c.set().and(this.r.Iset));
            BDD bDD3 = this.getTransitiveRefSet(bDD2);
            BDD bDD4 = bDD3.exist(this.r.H1c.set());
            return new HeapLocationSet(bDD4);
        }
        return null;
    }

    public Set mod(jq_Method jq_Method2, BasicBlock basicBlock, Quad quad) {
        MethodSummary.Node node;
        jq_Field jq_Field2;
        RegisterFactory.Register register;
        MethodSummary methodSummary = MethodSummary.getSummary(CodeCache.getCode(jq_Method2));
        if (quad.getOperator() instanceof Operator.AStore) {
            register = ((Operand.RegisterOperand)Operator.AStore.getBase(quad)).getRegister();
            jq_Field2 = null;
        } else {
            Assert._assert(quad.getOperator() instanceof Operator.Putfield);
            register = ((Operand.RegisterOperand)Operator.Putfield.getBase(quad)).getRegister();
            jq_Field2 = Operator.Putfield.getField(quad).getField();
        }
        Collection collection = methodSummary.getRegisterAtLocation(basicBlock, quad, register);
        BDD bDD = this.r.bdd.zero();
        BDD bDD2 = collection.iterator();
        while (bDD2.hasNext()) {
            node = (MethodSummary.Node)bDD2.next();
            Assert._assert(this.r.Vmap.contains(node));
            int n = this.r.Vmap.get(node);
            bDD.orWith(this.r.V1.ithVar(n));
        }
        bDD.andWith(this.r.V1c.domain());
        bDD2 = this.r.vP.relprod(bDD, this.r.V1set);
        node = bDD2.exist(this.r.H1c.set());
        node.andWith(this.r.F.ithVar(this.r.Fmap.get(jq_Field2)));
        return new HeapLocationSet((BDD)node);
    }

    public boolean isAliased(SSALocation sSALocation, SSALocation sSALocation2) {
        return sSALocation.equals(sSALocation2);
    }

    public Set getAliases(jq_Method jq_Method2, SSALocation sSALocation) {
        return Collections.EMPTY_SET;
    }

    public boolean hasAliases(jq_Method jq_Method2, SSALocation sSALocation, ContextSet contextSet) {
        return false;
    }

    public boolean hasAliases(jq_Method jq_Method2, SSALocation sSALocation) {
        return false;
    }

    public void showSource(TypedBDDFactory.TypedBDD typedBDD, int n, int n2) {
        PA pA = this.r;
        SourceLister sourceLister = new SourceLister();
        BDD.BDDToString bDDToString = new BDD.BDDToString(this, n, n2, sourceLister, pA){
            final /* synthetic */ PAResults this$0;
            final /* synthetic */ int val$before;
            final /* synthetic */ int val$after;
            final /* synthetic */ SourceLister val$sourceLister;
            final /* synthetic */ PA val$fr;

            final String findInMap(IndexMap indexMap, int n) {
                if (n >= indexMap.size()) {
                    return "not in map\n";
                }
                Object object = indexMap.get(n);
                if (object instanceof ProgramLocation) {
                    return this.val$sourceLister.list((ProgramLocation)object, true, this.val$before, this.val$after);
                }
                Class<?> clazz = object.getClass();
                try {
                    Method method = clazz.getMethod("getLocation", new Class[0]);
                    ProgramLocation programLocation = (ProgramLocation)method.invoke(object, null);
                    if (programLocation != null) {
                        return this.val$sourceLister.list(programLocation, true, this.val$before, this.val$after);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                return "no source available for " + object + '\n';
            }

            public final String elementName(int n, long l) {
                String string = "" + l + '\n';
                switch (n) {
                    case 0: 
                    case 1: {
                        return string + this.findInMap(this.val$fr.Vmap, (int)l);
                    }
                    case 2: {
                        return string + this.findInMap(this.val$fr.Imap, (int)l);
                    }
                    case 3: 
                    case 4: {
                        return string + this.findInMap(this.val$fr.Hmap, (int)l);
                    }
                }
                return string + "does not implement map index#" + n + '\n';
            }

            public final String elementNames(int n, long l, long l2) {
                return "big sets not implemented";
            }
            {
                this.this$0 = pAResults;
                this.val$before = n;
                this.val$after = n2;
                this.val$sourceLister = sourceLister;
                this.val$fr = pA;
            }
        };
        Iterator iterator = typedBDD.iterator();
        while (iterator.hasNext()) {
            TypedBDDFactory.TypedBDD typedBDD2 = (TypedBDDFactory.TypedBDD)iterator.next();
            System.out.println(typedBDD2.toStringWithDomains(bDDToString));
        }
    }

    public void computeGini(PathNumbering pathNumbering) {
        if (!(pathNumbering instanceof SCCPathNumbering)) {
            System.out.println(pathNumbering.getClass() + " is not using a SCC numbering");
            return;
        }
        SCCTopSortedGraph sCCTopSortedGraph = ((SCCPathNumbering)pathNumbering).getSCCGraph();
        List list = sCCTopSortedGraph.list();
        int[] nArray = new int[list.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            SCComponent sCComponent = (SCComponent)list.get(n2);
            nArray[n2] = sCComponent.size();
            n += sCComponent.size();
            ++n2;
        }
        int[] nArray2 = new int[n];
        Arrays.sort(nArray);
        System.arraycopy(nArray, 0, nArray2, n - nArray.length, nArray.length);
        double d = 0.0;
        int n3 = 0;
        while (n3 < n) {
            d += (double)((2 * (n3 + 1) - n - 1) * nArray2[n3]);
            ++n3;
        }
        d = d / (double)n / (double)(n - 1);
        System.out.println("Gini-Coefficient is " + d);
        n3 = 20;
        System.out.print(n3 + " largest SCCs are :");
        int n4 = nArray.length - 1;
        while (n4 >= 0 && n4 > nArray.length - 1 - n3) {
            System.out.print(" " + nArray[n4]);
            --n4;
        }
        System.out.println();
    }

    public void computeCastPrecision(boolean bl) {
        double d;
        MethodSummary.Node node;
        this.casts = this.r.bdd.zero();
        int n = 0;
        while (n < this.r.Vmap.size()) {
            node = (MethodSummary.Node)this.r.Vmap.get(n);
            if (node instanceof MethodSummary.CheckCastNode) {
                this.casts.orWith(this.r.V1.ithVar(n));
            }
            ++n;
        }
        BDD bDD = this.r.A.relprod(this.casts, this.r.V1cV2cset);
        node = this.r.bdd.makePair(this.r.V2, this.r.V1);
        BDD bDD2 = this.r.V1c.set();
        BDD bDD3 = this.r.vP.relprod(bDD.exist(this.r.V1.set()).replaceWith((BDDPairing)node), bDD2);
        BDD bDD4 = this.r.vP.relprod(bDD.exist(this.r.V2.set()), bDD2);
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        this.alwaysfail = (TypedBDDFactory.TypedBDD)this.r.bdd.zero();
        this.perfectcasts = (TypedBDDFactory.TypedBDD)this.r.bdd.zero();
        this.emptycasts = (TypedBDDFactory.TypedBDD)this.r.bdd.zero();
        int n2 = 0;
        while (n2 < this.r.Vmap.size()) {
            MethodSummary.Node node2 = (MethodSummary.Node)this.r.Vmap.get(n2);
            if (node2 instanceof MethodSummary.CheckCastNode) {
                TypedBDDFactory.TypedBDD typedBDD = (TypedBDDFactory.TypedBDD)this.r.V1.ithVar(n2);
                TypedBDDFactory.TypedBDD typedBDD2 = (TypedBDDFactory.TypedBDD)bDD4.restrict((BDD)typedBDD);
                BDD bDD5 = bDD.restrict((BDD)typedBDD);
                bDD5.replaceWith((BDDPairing)node);
                TypedBDDFactory.TypedBDD typedBDD3 = (TypedBDDFactory.TypedBDD)bDD3.relprod(bDD5, this.r.V1.set());
                if (typedBDD2.equals((BDD)typedBDD3)) {
                    this.perfectcasts.orWith((BDD)typedBDD);
                } else {
                    d = typedBDD2.satCount(this.r.H1set);
                    double d2 = typedBDD3.satCount(this.r.H1set);
                    if (d2 == 0.0) {
                        this.emptycasts.orWith((BDD)typedBDD);
                    } else {
                        if (d == 0.0) {
                            this.alwaysfail.orWith((BDD)typedBDD);
                        }
                        arrayList.add(new Triple(new Double(d), new Double(d2), "V1(" + n2 + ')' + this.r.longForm(node2)));
                    }
                }
                bDD5.free();
                typedBDD3.free();
                typedBDD2.free();
            }
            ++n2;
        }
        if (bl) {
            Object[] objectArray = arrayList.toArray();
            Arrays.sort(objectArray, new Comparator(this){
                final /* synthetic */ PAResults this$0;

                public final int compare(Object object, Object object2) {
                    int n;
                    double d = PAResults.access$0((Triple)object);
                    double d2 = PAResults.access$0((Triple)object2);
                    if (Double.isNaN(d)) {
                        return -1;
                    }
                    if (Double.isNaN(d2)) {
                        return 1;
                    }
                    if (d < d2) {
                        n = -1;
                    } else {
                        n = 0;
                        if (d > d2) {
                            n = 1;
                        }
                    }
                    return n;
                }
                {
                    this.this$0 = pAResults;
                }
            });
            int n3 = 0;
            while (n3 < objectArray.length) {
                System.out.println("#" + n3 + " z=" + PAResults.zHelper((Triple)objectArray[n3]) + ' ' + objectArray[n3]);
                ++n3;
            }
        }
        double d3 = this.casts.isZero() ? 0.0 : this.casts.satCount(this.r.V1.set());
        double d4 = this.perfectcasts.isZero() ? 0.0 : this.perfectcasts.satCount(this.r.V1.set());
        double d5 = this.emptycasts.isZero() ? 0.0 : this.emptycasts.satCount(this.r.V1.set());
        d = this.alwaysfail.isZero() ? 0.0 : this.alwaysfail.satCount(this.r.V1.set());
        System.out.println("#casts=" + d3);
        System.out.println("#perfectcasts (casts that provably always succeed)=" + d4);
        System.out.println("#perfect-cast ratio=" + d4 / d3);
        System.out.println("#emptycasts (casts with empty predecessor points-to set)=" + d5);
        System.out.println("#alwaysfail (casts with empty compatible points-to sets)=" + d);
    }

    private static final double zHelper(Triple triple) {
        double d = (Double)triple.left;
        double d2 = (Double)triple.middle;
        return PAResults.zcompute(d, d2 - d);
    }

    public static double zcompute(double d, double d2, double d3) {
        double d4 = 1.0 - d3;
        double d5 = d + d2;
        double d6 = d / d5;
        return (d6 - d3) / Math.sqrt(d3 * d4 / d5);
    }

    public static double zcompute(double d, double d2) {
        return PAResults.zcompute(d, d2, p0);
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }

    static /* synthetic */ double access$0(Triple triple) {
        return PAResults.zHelper(triple);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.storedBDDs = new HashMap();
    }

    public PAResults(PA pA) {
        this.this();
        this.r = pA;
    }

    public class HeapLocationSet
    extends AbstractSet {
        BDD heapLocations;

        public int size() {
            return (int)this.heapLocations.satCount(PAResults.this.r.H1.set().and(PAResults.this.r.Fset));
        }

        public Iterator iterator() {
            Iterator iterator = this.heapLocations.iterator(PAResults.this.r.H1.set().and(PAResults.this.r.Fset));
            return new UnmodifiableIterator(this, iterator){
                final /* synthetic */ HeapLocationSet this$0;
                final /* synthetic */ Iterator val$i;

                public final boolean hasNext() {
                    return this.val$i.hasNext();
                }

                public final Object next() {
                    BDD bDD = (BDD)this.val$i.next();
                    int n = (int)bDD.scanVar(this.this$0.PAResults.this.r.H1);
                    int n2 = (int)bDD.scanVar(this.this$0.PAResults.this.r.F);
                    MethodSummary.Node node = (MethodSummary.Node)this.this$0.PAResults.this.r.Hmap.get(n);
                    jq_Field jq_Field2 = (jq_Field)this.this$0.PAResults.this.r.Fmap.get(n2);
                    return new HeapLocation(node, jq_Field2);
                }
                {
                    this.this$0 = heapLocationSet;
                    this.val$i = iterator;
                }
            };
        }

        HeapLocationSet(BDD bDD) {
            this.heapLocations = bDD;
        }
    }

    public static class HeapLocation
    implements SSALocation {
        MethodSummary.Node n;
        jq_Field f;

        public boolean equals(HeapLocation heapLocation) {
            boolean bl = false;
            if (this.n.equals(heapLocation.n) && this.f == heapLocation.f) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            return this.equals((HeapLocation)object);
        }

        public int hashCode() {
            int n = this.n.hashCode();
            if (this.f != null) {
                n ^= this.f.hashCode();
            }
            return n;
        }

        public String toString() {
            String string = this.f == null ? "[]" : "." + this.f.getName().toString();
            return this.n.toString_short() + string;
        }

        public String toString(PA pA) {
            String string = this.f == null ? "[]" : "." + this.f.getName().toString();
            return pA.longForm(this.n) + string;
        }

        private HeapLocation(MethodSummary.Node node, jq_Field jq_Field2) {
            this.n = node;
            this.f = jq_Field2;
            boolean bl = false;
            if (node != null) {
                bl = true;
            }
            Assert._assert(bl);
        }

        public static class FACTORY {
            static HashMap _locationMap;

            HeapLocation createHeapLocation(MethodSummary.Node node, jq_Field jq_Field2) {
                Pair pair = new Pair(node, jq_Field2);
                HeapLocation heapLocation = (HeapLocation)_locationMap.get(pair);
                if (heapLocation == null) {
                    heapLocation = new HeapLocation(node, jq_Field2);
                    _locationMap.put(pair, heapLocation);
                }
                return heapLocation;
            }
        }
    }
}

