/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPSSA;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_Method;
import Clazz.jq_StaticMethod;
import Compil3r.Analysis.IPA.PAResults;
import Compil3r.Analysis.IPA.PointerAnalysisResults;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Analysis.IPSSA.ContextSet;
import Compil3r.Analysis.IPSSA.SSABinding;
import Compil3r.Analysis.IPSSA.SSADefinition;
import Compil3r.Analysis.IPSSA.SSAIterator;
import Compil3r.Analysis.IPSSA.SSALocation;
import Compil3r.Analysis.IPSSA.SSAProcInfo;
import Compil3r.Analysis.IPSSA.SSAValue;
import Compil3r.Analysis.IPSSA.Utils.SSAGraphPrinter;
import Compil3r.BytecodeAnalysis.TypeAnalysis;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.BasicBlockVisitor;
import Compil3r.Quad.CallGraph;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadIterator;
import Compil3r.Quad.QuadVisitor;
import Compil3r.Quad.RegisterFactory;
import Main.HostedVM;
import Util.Assert;
import Util.Collections.AppendIterator;
import Util.Graphs.SCCTopSortedGraph;
import Util.Graphs.SCComponent;
import Util.Graphs.Traversals;
import Util.Templates.ListIterator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IPSSABuilder
implements Runnable {
    private static HashMap _builderMap = new HashMap();
    protected int _verbosity;
    private PointerAnalysisResults _ptr;
    private ApplicationLaunchingPad _appPad;
    private Collection _classes;
    boolean PRINT_CFG;
    boolean PRINT_SSA_GRAPH;
    boolean RUN_BUILDER;
    boolean RUN_APPS;

    public PAResults getPAResults() {
        return (PAResults)this._ptr;
    }

    public CallGraph getCallGraph() {
        return this._ptr.getCallGraph();
    }

    protected void processSCC(SCComponent sCComponent) {
        SSABuilder sSABuilder;
        jq_Method jq_Method2;
        Set set = sCComponent.nodeSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            jq_Method2 = (jq_Method)iterator.next();
            if (this.skipMethod(jq_Method2)) continue;
            sSABuilder = new SSABuilder(jq_Method2, this._ptr, this._verbosity);
            boolean bl = false;
            if (_builderMap.get(jq_Method2) == null) {
                bl = true;
            }
            Assert._assert(bl);
            _builderMap.put(jq_Method2, sSABuilder);
            sSABuilder.run(0);
            sSABuilder.run(1);
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            jq_Method2 = (jq_Method)iterator.next();
            if (this.skipMethod(jq_Method2)) continue;
            sSABuilder = (SSABuilder)_builderMap.get(jq_Method2);
            boolean bl = false;
            if (sSABuilder != null) {
                bl = true;
            }
            Assert._assert(bl);
            sSABuilder.run(2);
        }
    }

    public void run() {
        if (this.RUN_BUILDER) {
            Object object;
            Object object2;
            if (this._classes.size() == 1) {
                System.out.println("Analyzing one class...");
            } else if (this._classes.size() > 1) {
                System.out.println("Analyzing these " + this._classes.size() + " classes...");
            }
            LinkedList<jq_StaticMethod> linkedList = new LinkedList<jq_StaticMethod>();
            Iterator iterator = this._classes.iterator();
            while (iterator.hasNext()) {
                object2 = (jq_Class)iterator.next();
                linkedList.addAll(Arrays.asList(((jq_Class)object2).getDeclaredStaticMethods()));
            }
            System.out.println("Using " + linkedList.size() + " root(s)...");
            object2 = this.getCallGraph();
            Object object3 = ((CallGraph)object2).getAllMethods().iterator();
            while (object3.hasNext()) {
                object = (jq_Method)object3.next();
                if (this.skipMethod((jq_Method)object)) continue;
                System.err.println("Allowing \t" + object);
            }
            object3 = SCCTopSortedGraph.topSort(SCComponent.buildSCC(linkedList, ((CallGraph)object2).getNavigator()));
            System.err.println("Found " + ((SCCTopSortedGraph)object3).list().size() + " components");
            object = Traversals.postOrder(((SCCTopSortedGraph)object3).getNavigator(), ((SCCTopSortedGraph)object3).getFirst()).iterator();
            while (object.hasNext()) {
                SCComponent sCComponent = (SCComponent)object.next();
                this.processSCC(sCComponent);
            }
        }
        if (this.RUN_APPS) {
            this._appPad.run();
        }
    }

    public boolean skipMethod(jq_Method jq_Method2) {
        jq_Class jq_Class2 = jq_Method2.getDeclaringClass();
        if (!this._classes.contains(jq_Class2)) {
            if (this._verbosity > 3) {
                System.err.println("Skipping " + jq_Method2);
            }
            return true;
        }
        return false;
    }

    public static SSABuilder getBuilder(jq_Method jq_Method2) {
        return (SSABuilder)_builderMap.get(jq_Method2);
    }

    public static boolean isLoad(Quad quad) {
        boolean bl = false;
        if (quad.getOperator() instanceof Operator.Getfield || quad.getOperator() instanceof Operator.Getstatic) {
            bl = true;
        }
        return bl;
    }

    public static boolean isStore(Quad quad) {
        boolean bl = false;
        if (quad.getOperator() instanceof Operator.Putfield || quad.getOperator() instanceof Operator.Putstatic) {
            bl = true;
        }
        return bl;
    }

    public static boolean isCall(Quad quad) {
        return quad.getOperator() instanceof Operator.Invoke;
    }

    private static final String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static final RegisterFactory.Register getOnlyDefinedRegister(Quad quad) {
        ListIterator.RegisterOperand registerOperand = quad.getDefinedRegisters().registerOperandIterator();
        if (!registerOperand.hasNext()) {
            return null;
        }
        RegisterFactory.Register register = registerOperand.nextRegisterOperand().getRegister();
        Assert._assert(registerOperand.hasNext() ^ true, "More than one defined register");
        return register;
    }

    private static final RegisterFactory.Register getOnlyUsedRegister(Quad quad) {
        ListIterator.RegisterOperand registerOperand = quad.getUsedRegisters().registerOperandIterator();
        if (!registerOperand.hasNext()) {
            return null;
        }
        RegisterFactory.Register register = registerOperand.nextRegisterOperand().getRegister();
        Assert._assert(registerOperand.hasNext() ^ true, "More than one used register");
        return register;
    }

    private final /* synthetic */ void this() {
        this._ptr = null;
        this._appPad = null;
        this._classes = null;
        this.PRINT_CFG = System.getProperty("ipssa.print_cfg", "no").equals("no") ^ true;
        this.PRINT_SSA_GRAPH = System.getProperty("ipssa.print_ssa", "no").equals("no") ^ true;
        this.RUN_BUILDER = System.getProperty("ipssa.run_builder", "no").equals("no") ^ true;
        this.RUN_APPS = System.getProperty("ipssa.run_apps", "no").equals("no") ^ true;
    }

    public IPSSABuilder(Collection collection, int n) {
        this.this();
        CodeCache.AlwaysMap = true;
        this._verbosity = n;
        this._classes = collection;
        try {
            String string = System.getProperty("pa.resultdir");
            String[] stringArray = null;
            if (string != null) {
                stringArray = new String[]{string};
                System.err.println("Reading pointer analysis results from directory " + string);
            }
            this._ptr = PAResults.loadResults(stringArray, null);
        }
        catch (IOException iOException) {
            System.err.println("Caught an exception: " + iOException.toString());
            iOException.printStackTrace();
            System.exit(1);
        }
        if (this.RUN_APPS) {
            this._appPad = new ApplicationLaunchingPad(this, true);
        }
    }

    class SSABuilder {
        protected int _verbosity;
        protected jq_Method _method;
        protected ControlFlowGraph _cfg;
        protected SSAProcInfo.Query _q;
        private PointerAnalysisResults _ptr;

        public ControlFlowGraph getCFG() {
            return this._cfg;
        }

        public SSAProcInfo.Query getQuery() {
            return this._q;
        }

        protected int addBinding(Quad quad, SSALocation sSALocation, SSAValue sSAValue) {
            if (this._ptr.hasAliases(this._method, sSALocation)) {
                int n = 0;
                Iterator iterator = this._ptr.getAliases(this._method, sSALocation).iterator();
                while (iterator.hasNext()) {
                    ContextSet.ContextLocationPair contextLocationPair = (ContextSet.ContextLocationPair)iterator.next();
                    n += this.addBinding(quad, contextLocationPair.getLocation(), sSAValue, contextLocationPair.getContext());
                }
                return n;
            }
            this.addBinding(quad, sSALocation, sSAValue, null);
            return 1;
        }

        private final int addBinding(Quad quad, SSALocation sSALocation, SSAValue sSAValue, ContextSet contextSet) {
            SSAProcInfo.SSABindingAnnote sSABindingAnnote;
            if (quad != this._q.getFirstQuad()) {
                this.initializeLocation(sSALocation);
            }
            if ((sSABindingAnnote = (SSAProcInfo.SSABindingAnnote)this._q._bindingMap.get(quad)) == null) {
                sSABindingAnnote = new SSAProcInfo.SSABindingAnnote();
                this._q._bindingMap.put(quad, sSABindingAnnote);
            }
            int n = 0;
            if (contextSet == null) {
                sSABindingAnnote.addBinding(sSALocation, sSAValue, quad, this._method);
                ++n;
                if (quad != this._q.getFirstQuad()) {
                    n += this.markIteratedDominanceFrontier(sSALocation, quad);
                }
            } else {
                SSADefinition sSADefinition = this.makeTemporary(sSAValue, quad, contextSet);
                ++n;
                SSADefinition sSADefinition2 = this._q.getLastDefinitionFor(sSALocation, quad, true);
                SSAValue.SigmaPhi sigmaPhi = new SSAValue.SigmaPhi(contextSet, sSADefinition, sSADefinition2);
                sSABindingAnnote.addBinding(sSALocation, sigmaPhi, quad, this._method);
                ++n;
                n += this.markIteratedDominanceFrontier(sSALocation, quad);
            }
            return n;
        }

        private final int initializeLocation(SSALocation sSALocation) {
            if (this._q.getDefinitionFor(sSALocation, this._q.getFirstQuad()) == null) {
                if (sSALocation instanceof SSALocation.LocalLocation) {
                    return this.addBinding(this._q.getFirstQuad(), sSALocation, null, null);
                }
                return this.addBinding(this._q.getFirstQuad(), sSALocation, new SSAValue.FormalIn(), null);
            }
            return 0;
        }

        private final int markIteratedDominanceFrontier(SSALocation sSALocation, Quad quad) {
            if (sSALocation instanceof SSALocation.Unique) {
                return 0;
            }
            int n = 0;
            HashSet hashSet = new HashSet();
            this._q.getDominatorQuery().getIteratedDominanceFrontier(quad, hashSet);
            if (this._verbosity > 2) {
                System.err.println("There are " + hashSet.size() + " element(s) on the frontier");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Quad quad2 = (Quad)iterator.next();
                Assert._assert(quad2.getOperator() instanceof Operator.Special.NOP, "Expected the quad on the dominance frontier to be a NOP, not a " + quad2);
                if (this._q.getDefinitionFor(sSALocation, quad2) != null) continue;
                SSAValue.Gamma gamma = new SSAValue.Gamma();
                n += this.addBinding(quad2, sSALocation, gamma, null);
                if (this._verbosity <= 3) continue;
                System.err.println("Created a gamma function for " + sSALocation + " at " + quad2);
            }
            return n;
        }

        private final SSADefinition makeTemporary(SSAValue sSAValue, Quad quad, ContextSet contextSet) {
            SSALocation.Temporary temporary = SSALocation.Temporary.FACTORY.get();
            this.addBinding(quad, temporary, sSAValue, contextSet);
            SSADefinition sSADefinition = this._q.getDefinitionFor(temporary, quad);
            boolean bl = false;
            if (sSADefinition != null) {
                bl = true;
            }
            Assert._assert(bl);
            return sSADefinition;
        }

        void run(int n) {
            Quad quad;
            Object object;
            Object object2;
            if (n == 0) {
                this._cfg.visitBasicBlocks(new LiftMergesVisitor());
                this._q = SSAProcInfo.retrieveQuery(this._method);
                if (this._verbosity > 2) {
                    System.out.println("Created query: " + this._q.toString());
                }
                if (this._verbosity > 0) {
                    String string = this._method.toString();
                    string = string.length() > 40 ? string.substring(40) : IPSSABuilder.repeat(" ", 40 - string.length()) + string;
                    System.out.println("============= Processing method " + string + " in IPSSABuilder =============");
                }
                return;
            }
            if (n == 1) {
                object2 = new Stage1Visitor(this._method);
                object = new QuadIterator(this._cfg, true);
                while (((QuadIterator)object).hasNext()) {
                    quad = ((QuadIterator)object).nextQuad();
                    quad.accept((QuadVisitor)object2);
                }
                if (this._verbosity > 2) {
                    System.err.println("Created a total of " + ((Stage1Visitor)object2).getBindingCount() + " bindings");
                }
                object2 = null;
            }
            if (n == 2) {
                object2 = new Stage2Visitor(this._method);
                object = new QuadIterator(this._cfg, true);
                while (((QuadIterator)object).hasNext()) {
                    quad = ((QuadIterator)object).nextQuad();
                    quad.accept((QuadVisitor)object2);
                }
            }
            if (n == 3) {
                if (IPSSABuilder.this.PRINT_CFG) {
                    this._q.printDot();
                }
                if (IPSSABuilder.this.PRINT_SSA_GRAPH) {
                    try {
                        object2 = new FileOutputStream("ssa.dot");
                        object = new PrintStream((OutputStream)object2);
                        SSAGraphPrinter.printAllToDot((PrintStream)object);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.exit(2);
                    }
                }
            }
        }

        SSABuilder(jq_Method jq_Method2, PointerAnalysisResults pointerAnalysisResults, int n) {
            this._method = jq_Method2;
            this._cfg = CodeCache.getCode(this._method);
            this._verbosity = n;
            this._q = null;
            this._ptr = pointerAnalysisResults;
        }

        private class LiftMergesVisitor
        implements BasicBlockVisitor {
            public void visitBasicBlock(BasicBlock basicBlock) {
                if (basicBlock.getPredecessors().size() > 1) {
                    Quad quad = Operator.Special.create(0, Operator.Special.NOP.INSTANCE);
                    int n = basicBlock.size();
                    basicBlock.addQuad(0, quad);
                    boolean bl = false;
                    if (n + 1 == basicBlock.size()) {
                        bl = true;
                    }
                    Assert._assert(bl);
                }
            }

            private LiftMergesVisitor() {
            }
        }

        private class Stage1Visitor
        extends QuadVisitor.EmptyVisitor {
            jq_Method _method;
            SSAProcInfo.Helper _h;
            SSAProcInfo.Query _q;
            private int _bindings;

            int getBindingCount() {
                return this._bindings;
            }

            public void visitGetstatic(Quad quad) {
                this.processLoad(quad);
            }

            public void visitGetfield(Quad quad) {
                this.processLoad(quad);
            }

            private final void processLoad(Quad quad) {
                this.markDestinations(quad);
            }

            public void visitPutfield(Quad quad) {
                this.processStore(quad);
            }

            public void visitPutstatic(Quad quad) {
                this.processStore(quad);
            }

            public void visitMove(Quad quad) {
                this.markDestinations(quad);
            }

            public void visitALoad(Quad quad) {
                this.processLoad(quad);
            }

            public void visitAStore(Quad quad) {
                this.print(quad);
            }

            public void visitNew(Quad quad) {
                this.markDestinations(quad);
            }

            public void visitNewArray(Quad quad) {
                this.markDestinations(quad);
            }

            public void visitReturn(Quad quad) {
                this.print(quad);
            }

            public void visitInvoke(Quad quad) {
                this.processDefs(quad);
            }

            private final void markDestinations(Quad quad) {
                RegisterFactory.Register register = IPSSABuilder.getOnlyDefinedRegister(quad);
                boolean bl = false;
                if (register != null) {
                    bl = true;
                }
                Assert._assert(bl);
                SSALocation.LocalLocation localLocation = SSALocation.LocalLocation.FACTORY.createLocalLocation(register);
                SSABuilder.this.addBinding(quad, localLocation, null, null);
            }

            private final void processStore(Quad quad) {
                this.processDefs(quad);
            }

            private final void processDefs(Quad quad) {
                ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this._method, quad);
                boolean bl = false;
                if (IPSSABuilder.isCall(quad) || IPSSABuilder.isStore(quad)) {
                    bl = true;
                }
                Assert._assert(bl);
                Set set = SSABuilder.this._ptr.mod(quadProgramLocation, this._q.getDominatorQuery().getBasicBlock(quad));
                if (set != null && set.size() > 0) {
                    if (SSABuilder.this._verbosity > 2) {
                        System.out.print("Found " + set.size() + " mods at " + quadProgramLocation.toString() + ": [ ");
                    }
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        SSALocation sSALocation = (SSALocation)iterator.next();
                        if (SSABuilder.this._verbosity > 2) {
                            System.out.print(sSALocation.toString(SSABuilder.this._ptr.getPAResults()) + ' ');
                        }
                        if (IPSSABuilder.isCall(quad)) {
                            this._bindings += SSABuilder.this.addBinding(quad, sSALocation, new SSAValue.ActualOut(), null);
                            continue;
                        }
                        if (IPSSABuilder.isStore(quad)) {
                            this._bindings += SSABuilder.this.addBinding(quad, sSALocation, null, null);
                            continue;
                        }
                        Assert._assert(false);
                    }
                    if (SSABuilder.this._verbosity > 2) {
                        System.out.println("]\n");
                    }
                }
            }

            public void visitQuad(Quad quad) {
                this.print(quad);
            }

            protected void print(Quad quad, boolean bl) {
                if (!bl) {
                    return;
                }
                ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this._method, quad);
                String string = null;
                try {
                    string = "" + quadProgramLocation.getSourceFile() + ':' + quadProgramLocation.getLineNumber();
                }
                catch (Exception exception) {
                    string = "<unknown>";
                }
                System.out.println("Visited quad # " + quad.toString() + "\t\t\t at " + string);
            }

            protected void printAlways(Quad quad) {
                this.print(quad, true);
            }

            protected void print(Quad quad) {
                this.print(quad, false);
            }

            protected void warn(String string) {
                System.err.println(string);
            }

            Stage1Visitor(jq_Method jq_Method2) {
                this._method = jq_Method2;
                this._h = SSAProcInfo.retrieveHelper(this._method);
                this._q = SSAProcInfo.retrieveQuery(this._method);
                this._bindings = 0;
            }
        }

        private class Stage2Visitor
        extends QuadVisitor.EmptyVisitor {
            private jq_Method _method;
            private SSAProcInfo.Query _q;
            private SSAProcInfo.Helper _h;

            public void visitGetstatic(Quad quad) {
                this.processLoad(quad);
            }

            public void visitGetfield(Quad quad) {
                this.processLoad(quad);
            }

            public void visitPutfield(Quad quad) {
                this.processStore(quad);
            }

            public void visitPutstatic(Quad quad) {
                this.processStore(quad);
            }

            public void visitMove(Quad quad) {
                boolean bl = false;
                if (this._q.getBindingCount(quad) == 1) {
                    bl = true;
                }
                Assert._assert(bl);
                SSABinding sSABinding = this._q.getBindingIterator(quad).nextBinding();
                boolean bl2 = false;
                if (sSABinding.getValue() == null) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                sSABinding.setValue(this.markUses(quad));
            }

            public void visitALoad(Quad quad) {
                this.processLoad(quad);
            }

            public void visitAStore(Quad quad) {
                this.processStore(quad);
            }

            public void visitNew(Quad quad) {
                boolean bl = false;
                if (this._q.getBindingCount(quad) == 1) {
                    bl = true;
                }
                Assert._assert(bl);
                SSABinding sSABinding = this._q.getBindingIterator(quad).nextBinding();
                boolean bl2 = false;
                if (sSABinding.getValue() == null) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                sSABinding.setValue(this.makeAlloc(quad));
            }

            public void visitNewArray(Quad quad) {
                boolean bl = false;
                if (this._q.getBindingCount(quad) == 1) {
                    bl = true;
                }
                Assert._assert(bl);
                SSABinding sSABinding = this._q.getBindingIterator(quad).nextBinding();
                boolean bl2 = false;
                if (sSABinding.getValue() == null) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                sSABinding.setValue(this.makeAlloc(quad));
            }

            public void visitReturn(Quad quad) {
            }

            public void visitInvoke(Quad quad) {
                this.processCall(quad);
            }

            private final void processStore(Quad quad) {
                SSAIterator.BindingIterator bindingIterator = this._q.getBindingIterator(quad);
                while (bindingIterator.hasNext()) {
                    SSABinding sSABinding = bindingIterator.nextBinding();
                    boolean bl = false;
                    if (sSABinding.getValue() == null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    sSABinding.setValue(this.markUses(quad));
                }
            }

            public void visitSpecial(Quad quad) {
                if (quad.getOperator() instanceof Operator.Special.NOP) {
                    SSAIterator.BindingIterator bindingIterator = this._q.getBindingIterator(quad);
                    while (bindingIterator.hasNext()) {
                        SSABinding sSABinding = bindingIterator.nextBinding();
                        SSAValue sSAValue = sSABinding.getValue();
                        if (sSAValue == null || !(sSAValue instanceof SSAValue.Gamma)) continue;
                        SSAValue.Gamma gamma = (SSAValue.Gamma)sSAValue;
                        this.fillInGamma(quad, gamma);
                    }
                }
            }

            private final void fillInGamma(Quad quad, SSAValue.Gamma gamma) {
                SSALocation sSALocation = gamma.getDestination().getLocation();
                BasicBlock basicBlock = this._q.getDominatorQuery().getBasicBlock(quad);
                boolean bl = false;
                if (basicBlock != null) {
                    bl = true;
                }
                Assert._assert(bl);
                boolean bl2 = false;
                if (basicBlock.size() > 0) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                boolean bl3 = false;
                if (basicBlock.getQuad(0) == quad) {
                    bl3 = true;
                }
                Assert._assert(bl3);
                ListIterator.BasicBlock basicBlock2 = basicBlock.getPredecessors().basicBlockIterator();
                while (basicBlock2.hasNext()) {
                    BasicBlock basicBlock3 = basicBlock2.nextBasicBlock();
                    Quad quad2 = basicBlock3.isEntry() ? this._q.getFirstQuad() : basicBlock3.getLastQuad();
                    SSADefinition sSADefinition = this._q.getLastDefinitionFor(sSALocation, quad2, false);
                    gamma.add(sSADefinition, null);
                }
            }

            private final void processLoad(Quad quad) {
                SSALocation sSALocation;
                Object object;
                ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this._method, quad);
                Assert._assert(IPSSABuilder.isLoad(quad));
                Set set = SSABuilder.this._ptr.ref(quadProgramLocation, this._q.getDominatorQuery().getBasicBlock(quad));
                SSAValue.OmegaPhi omegaPhi = new SSAValue.OmegaPhi();
                if (set != null && set.size() > 0) {
                    if (SSABuilder.this._verbosity > 2) {
                        System.out.print("Found " + set.size() + " refs at " + quadProgramLocation.toString() + ": [ ");
                    }
                    object = set.iterator();
                    while (object.hasNext()) {
                        sSALocation = (SSALocation)object.next();
                        if (SSABuilder.this._verbosity > 2) {
                            System.out.print(sSALocation.toString(SSABuilder.this._ptr.getPAResults()) + ' ');
                        }
                        SSABuilder.this.initializeLocation(sSALocation);
                        SSADefinition sSADefinition = this._q.getLastDefinitionFor(sSALocation, quad, true);
                        boolean bl = false;
                        if (sSADefinition != null) {
                            bl = true;
                        }
                        Assert._assert(bl);
                        if (SSABuilder.this._verbosity > 1) {
                            System.out.println("Using " + sSADefinition + " at " + quad);
                        }
                        omegaPhi.addUsedDefinition(sSADefinition);
                    }
                    if (SSABuilder.this._verbosity > 2) {
                        System.out.println("]\n");
                    }
                }
                boolean bl = false;
                if (this._q.getBindingCount(quad) == 1) {
                    bl = true;
                }
                Assert._assert(bl, "Have " + this._q.getBindingCount(quad) + " bindings at " + quad);
                object = this._q.getBindingIterator(quad).nextBinding();
                boolean bl2 = false;
                if (((SSABinding)object).getValue() == null) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                Assert._assert(((SSABinding)object).getDestination().getLocation() instanceof SSALocation.LocalLocation);
                sSALocation = (SSALocation.LocalLocation)((SSABinding)object).getDestination().getLocation();
                boolean bl3 = false;
                if (((SSALocation.LocalLocation)sSALocation).getRegister() == IPSSABuilder.getOnlyDefinedRegister(quad)) {
                    bl3 = true;
                }
                Assert._assert(bl3);
                ((SSABinding)object).setValue(omegaPhi);
            }

            private final void processCall(Quad quad) {
                SSADefinition sSADefinition;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Assert._assert(IPSSABuilder.isCall(quad));
                ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this._method, quad);
                Set set = SSABuilder.this._ptr.getCallTargets(quadProgramLocation);
                if (set.size() == 0) {
                    System.err.println("No targets of call " + quad);
                    return;
                }
                Iterator iterator = this._q.getBindingIterator(quad);
                while (((SSAIterator.BindingIterator)iterator).hasNext()) {
                    object6 = ((SSAIterator.BindingIterator)iterator).nextBinding();
                    Assert._assert(((SSABinding)object6).getValue() instanceof SSAValue.ActualOut);
                    object5 = (SSAValue.ActualOut)((SSABinding)object6).getValue();
                    object4 = ((SSABinding)object6).getDestination().getLocation();
                    object3 = set.iterator();
                    while (object3.hasNext()) {
                        object2 = (jq_Method)object3.next();
                        object = IPSSABuilder.getBuilder((jq_Method)object2);
                        if (object == null) {
                            Assert._assert(false, "Method " + object2 + " hasn't been processed");
                        }
                        ((SSABuilder)object).initializeLocation((SSALocation)object4);
                        sSADefinition = ((SSABuilder)object).getQuery().getLastDefinitionFor((SSALocation)object4, ((SSABuilder)object).getCFG().exit().getLastQuad(), false);
                        ((SSAValue.ActualOut)object5).add(sSADefinition, (jq_Method)object2);
                    }
                }
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    object6 = (jq_Method)iterator.next();
                    if (IPSSABuilder.this.skipMethod((jq_Method)object6)) continue;
                    object5 = IPSSABuilder.getBuilder((jq_Method)object6);
                    if (object5 == null) {
                        Assert._assert(false, "Method " + object6 + " hasn't been processed yet");
                    }
                    object4 = ((SSABuilder)object5).getQuery().getBindingIterator(((SSABuilder)object5).getQuery().getFirstQuad());
                    while (object4.hasNext()) {
                        object3 = (SSABinding)object4.next();
                        if (!(((SSABinding)object3).getValue() instanceof SSAValue.FormalIn)) continue;
                        object2 = ((SSABinding)object3).getDestination().getLocation();
                        object = (SSAValue.FormalIn)((SSABinding)object3).getValue();
                        if (!((SSAValue.FormalIn)object).hasCallSite(quad)) {
                            SSABuilder.this.initializeLocation((SSALocation)object2);
                            sSADefinition = this._q.getLastDefinitionFor((SSALocation)object2, quad, true);
                            boolean bl = false;
                            if (sSADefinition != null) {
                                bl = true;
                            }
                            Assert._assert(bl);
                            ((SSAValue.FormalIn)object).add(sSADefinition, quad);
                            continue;
                        }
                        Assert._assert(false, "Already added a definition for " + object6 + " to " + object + ". Recursion?");
                    }
                }
            }

            private final SSAValue.Normal markUses(Quad quad) {
                SSAValue.UseCollection useCollection = SSAValue.UseCollection.FACTORY.createUseCollection();
                ListIterator.RegisterOperand registerOperand = quad.getUsedRegisters().registerOperandIterator();
                while (registerOperand.hasNext()) {
                    RegisterFactory.Register register = registerOperand.nextRegisterOperand().getRegister();
                    SSALocation.LocalLocation localLocation = SSALocation.LocalLocation.FACTORY.createLocalLocation(register);
                    SSABuilder.this.initializeLocation(localLocation);
                    SSADefinition sSADefinition = this._q.getLastDefinitionFor(localLocation, quad, true);
                    boolean bl = false;
                    if (sSADefinition != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    useCollection.addUsedDefinition(sSADefinition);
                }
                return useCollection;
            }

            private final SSAValue makeAlloc(Quad quad) {
                return SSAValue.Alloc.FACTORY.createAlloc(quad);
            }

            Stage2Visitor(jq_Method jq_Method2) {
                this._method = jq_Method2;
                this._h = SSAProcInfo.retrieveHelper(this._method);
                this._q = SSAProcInfo.retrieveQuery(this._method);
            }
        }
    }

    public static class ApplicationLaunchingPad
    implements Runnable {
        LinkedList _applications;
        boolean _verbosity;
        private IPSSABuilder _builder;

        public void addApplication(Application application) {
            this._applications.addLast(application);
        }

        public IPSSABuilder getBuilder() {
            return this._builder;
        }

        public void run() {
            Iterator iterator = this._applications.iterator();
            while (iterator.hasNext()) {
                Application application = (Application)iterator.next();
                if (this._verbosity) {
                    System.out.println("Running application " + application.getName());
                }
                application.run();
            }
        }

        private final void readConfig() {
            String string = "app.config";
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string2.charAt(0) == '#') {
                        string2 = bufferedReader.readLine();
                        continue;
                    }
                    Application application = Application.create(this._builder, string2);
                    if (application != null) {
                        this.addApplication(application);
                        application.setBuilder(this.getBuilder());
                    } else {
                        System.err.println("Skipped " + string2);
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Couldn't read file " + string);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        public ApplicationLaunchingPad(IPSSABuilder iPSSABuilder, boolean bl) {
            this._builder = iPSSABuilder;
            this._applications = new LinkedList();
            this._verbosity = bl;
            this.readConfig();
        }

        public ApplicationLaunchingPad(IPSSABuilder iPSSABuilder, Application application, boolean bl) {
            this(iPSSABuilder, bl);
            this.addApplication(application);
        }

        public ApplicationLaunchingPad(IPSSABuilder iPSSABuilder) {
            this(iPSSABuilder, false);
        }
    }

    public static abstract class Application
    implements Runnable {
        private String _name;
        protected IPSSABuilder _builder;

        public void initialize() {
        }

        protected void setBuilder(IPSSABuilder iPSSABuilder) {
            this._builder = iPSSABuilder;
        }

        protected IPSSABuilder getBuilder() {
            return this._builder;
        }

        public static Application create(IPSSABuilder iPSSABuilder, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
            Application application = null;
            try {
                Class<?> clazz = Class.forName(string2);
                try {
                    application = (Application)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    return null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    return null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return null;
            }
            if (application == null) {
                System.err.println("Can't create an instance of " + string2);
                return null;
            }
            application.setBuilder(iPSSABuilder);
            application.setName(string3);
            application.parseParams(vector.toArray());
            application.initialize();
            return application;
        }

        private final void setName(String string) {
            this._name = string;
        }

        public String getName() {
            return this._name;
        }

        protected abstract void parseParams(String[] var1);

        private final void parseParams(Object[] objectArray) {
            String[] stringArray = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                stringArray[n] = (String)objectArray[n];
                ++n;
            }
            this.parseParams(stringArray);
        }

        public abstract void run();

        public Application() {
            this(null, null);
        }

        public Application(IPSSABuilder iPSSABuilder, String string, String[] stringArray) {
            this.parseParams(stringArray);
            this._name = string;
            this._builder = iPSSABuilder;
        }

        Application(String string, String string2) {
            this._name = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
            this.parseParams((String[])vector.toArray());
        }
    }

    public static class Main {
        static boolean _verbose = false;

        public static void main(String[] stringArray) {
            Object object;
            Object object2;
            Object object3;
            HostedVM.initialize();
            TypeAnalysis.classesToAnalyze = new HashSet();
            Iterator iterator = null;
            Object var2_2 = null;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-file")) {
                    try {
                        object3 = new BufferedReader(new FileReader(stringArray[++n]));
                        object2 = new LinkedList();
                        while ((object = ((BufferedReader)object3).readLine()) != null) {
                            if (((String)object).length() == 0 || ((String)object).startsWith("%") || ((String)object).startsWith("#")) continue;
                            ((LinkedList)object2).add(object);
                        }
                        iterator = new AppendIterator(((AbstractSequentialList)object2).iterator(), iterator);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        System.exit(2);
                    }
                } else if (stringArray[n].endsWith("*")) {
                    iterator = new AppendIterator(PrimordialClassLoader.loader.listPackage(stringArray[n].substring(0, stringArray[n].length() - 1)), iterator);
                } else if (stringArray[n].charAt(0) == '-') {
                    Main.usage();
                    System.exit(2);
                } else {
                    object3 = stringArray[n];
                    iterator = new AppendIterator(Collections.singleton(object3).iterator(), iterator);
                }
                ++n;
            }
            if (iterator == null) {
                System.err.println("At least one class is requred for execution");
                System.exit(2);
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                if (((String)object3).endsWith(".properties")) continue;
                if (((String)object3).endsWith(".class")) {
                    object3 = ((String)object3).substring(0, ((String)object3).length() - 6);
                }
                object2 = "L" + ((String)object3).replace('.', '/') + ';';
                object = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType((String)object2);
                System.err.println("Preparing class [" + (String)object2 + "] ...");
                ((jq_Class)object).prepare();
                linkedList.add(object);
            }
            object3 = new IPSSABuilder(linkedList, 2);
            ((IPSSABuilder)object3).run();
        }

        private static final void usage() {
            System.err.println("Usage: ");
        }
    }
}

