/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPSSA.Utils;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_Method;
import Compil3r.Analysis.FlowInsensitive.MethodSummary;
import Compil3r.Analysis.IPA.PAResultSelector;
import Compil3r.Analysis.IPSSA.IPSSABuilder;
import Compil3r.Analysis.IPSSA.SSADefinition;
import Util.Assert;
import java.util.StringTokenizer;
import org.sf.javabdd.TypedBDDFactory;

public abstract class AnalysisObjectSpec {
    static final String RETURN = "return";
    static final String PARAM = "param";
    String _type;
    String[] _args;

    static jq_Method getMethodByName(String string, String string2) {
        if (string.endsWith(".properties")) {
            return null;
        }
        if (string.endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
        }
        String string3 = "L" + string + ';';
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType(string3);
        jq_Class2.prepare();
        return jq_Class2.getDeclaredMethod(string2);
    }

    private AnalysisObjectSpec(String string, String[] stringArray) {
        this._type = string;
        this._args = (String[])stringArray.clone();
    }

    public static class PAObjectSpec
    extends AnalysisObjectSpec {
        TypedBDDFactory.TypedBDD _bdd;
        PAResultSelector _sel;

        public static PAObjectSpec create(PAResultSelector pAResultSelector, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            Assert._assert(stringTokenizer.hasMoreTokens());
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            return new PAObjectSpec(pAResultSelector, string2, stringArray);
        }

        public TypedBDDFactory.TypedBDD getBDD() throws UnknownAnalysisObjectExeption {
            if (this._bdd != null) {
                return this._bdd;
            }
            if (this._type.equals(AnalysisObjectSpec.RETURN)) {
                jq_Method jq_Method2 = PAObjectSpec.getMethodByName(this._args[0], this._args[1]);
                this._bdd = this._sel.getReturnBDD(jq_Method2);
            } else if (this._type.equals(AnalysisObjectSpec.PARAM)) {
                jq_Method jq_Method3 = PAObjectSpec.getMethodByName(this._args[0], this._args[1]);
                int n = Integer.parseInt(this._args[2]);
                this._bdd = this._sel.getFormalParamBDD(jq_Method3, n);
            } else {
                throw new UnknownAnalysisObjectExeption("Unknown type " + this._type);
            }
            return this._bdd;
        }

        public MethodSummary.Node getNode() throws UnknownAnalysisObjectExeption {
            return this._sel.getNode(this.getBDD());
        }

        public String toString() {
            return this._type + " [" + this._args.toString() + ']';
        }

        PAObjectSpec(PAResultSelector pAResultSelector, String string, String[] stringArray) {
            super(string, stringArray);
            this._sel = pAResultSelector;
            this._bdd = null;
        }
    }

    public static class IPSSAObjectSpec
    extends AnalysisObjectSpec {
        static final String DEFINITION = "definition";
        SSADefinition _definition;
        IPSSABuilder _builder;

        public static IPSSAObjectSpec create(IPSSABuilder iPSSABuilder, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            Assert._assert(stringTokenizer.hasMoreTokens());
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            return new IPSSAObjectSpec(iPSSABuilder, string2, stringArray);
        }

        public SSADefinition getDefinition() throws UnknownAnalysisObjectExeption {
            if (this._definition != null) {
                return this._definition;
            }
            if (this._type.equals(AnalysisObjectSpec.RETURN)) {
                this._definition = null;
            } else if (this._type.equals(AnalysisObjectSpec.PARAM)) {
                this._definition = null;
            } else if (this._type.equals(DEFINITION)) {
                this._definition = SSADefinition.Helper.lookupDefinition(this._args[0]);
                if (this._definition == null) {
                    throw new UnknownAnalysisObjectExeption("Can't find definition " + this._args[0]);
                }
            } else {
                throw new UnknownAnalysisObjectExeption("Unknown type " + this._type);
            }
            return this._definition;
        }

        IPSSAObjectSpec(IPSSABuilder iPSSABuilder, String string, String[] stringArray) {
            super(string, stringArray);
            this._builder = iPSSABuilder;
            this._definition = null;
        }
    }

    public static class UnknownAnalysisObjectExeption
    extends Exception {
        public UnknownAnalysisObjectExeption(String string) {
            super(string);
        }
    }
}

