/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPSSA.Utils;

import Compil3r.Analysis.IPSSA.SSADefinition;
import Compil3r.Analysis.IPSSA.SSAIterator;
import Compil3r.Analysis.IPSSA.SSAValue;
import Compil3r.Analysis.IPSSA.Utils.DefinitionSet;
import Util.Assert;
import Util.Collections.Pair;
import java.io.PrintStream;
import java.util.HashSet;

public class SSAGraphPrinter {
    private static final void collectReachedDefinitions(SSADefinition sSADefinition, DefinitionSet definitionSet) {
        if (definitionSet.contains(sSADefinition)) {
            return;
        }
        definitionSet.add(sSADefinition);
        SSAIterator.ValueIterator valueIterator = sSADefinition.getUseIterator();
        while (valueIterator.hasNext()) {
            SSAValue sSAValue = (SSAValue)valueIterator.next();
            SSADefinition sSADefinition2 = sSAValue.getDestination();
            boolean bl = false;
            if (sSADefinition2 != null) {
                bl = true;
            }
            Assert._assert(bl);
            SSAGraphPrinter.collectReachedDefinitions(sSADefinition2, definitionSet);
        }
    }

    private static final void printDefinitions(DefinitionSet definitionSet, PrintStream printStream) {
        SSAGraphPrinter.printDefinitions(definitionSet.getDefinitionIterator(), printStream);
    }

    private static final void printDefinitions(SSAIterator.DefinitionIterator definitionIterator, PrintStream printStream, boolean bl) {
        SSADefinition sSADefinition;
        Object object;
        Object object2;
        Object object3;
        HashSet<Pair> hashSet = new HashSet<Pair>();
        printStream.println("digraph G {\n");
        while (definitionIterator.hasNext()) {
            object3 = definitionIterator.nextDefinition();
            boolean bl2 = false;
            if (object3 != null) {
                bl2 = true;
            }
            Assert._assert(bl2);
            if (!bl) {
                printStream.println("\t\"" + object3 + "\" [shape=box];");
            }
            object2 = ((SSADefinition)object3).getUseIterator();
            if (!((SSADefinition)object3).getUseIterator().hasNext()) continue;
            do {
                object = ((SSAIterator.ValueIterator)object2).nextValue();
                sSADefinition = ((SSAValue)object).getDestination();
                boolean bl3 = false;
                if (sSADefinition != null) {
                    bl3 = true;
                }
                Assert._assert(bl3, "Destination of " + object + " is null");
                if (((SSADefinition)object3).getID() < sSADefinition.getID()) {
                    hashSet.add(new Pair(object3, sSADefinition));
                    continue;
                }
                hashSet.add(new Pair(sSADefinition, object3));
            } while (((SSAIterator.ValueIterator)object2).hasNext());
        }
        printStream.println("\n");
        object3 = hashSet.iterator();
        while (object3.hasNext()) {
            object2 = (Pair)object3.next();
            object = (SSADefinition)((Pair)object2).left;
            sSADefinition = (SSADefinition)((Pair)object2).right;
            boolean bl4 = false;
            if (object != null && sSADefinition != null) {
                bl4 = true;
            }
            Assert._assert(bl4);
            printStream.println("\t\"" + object + "\" -> \"" + sSADefinition + "\" \n");
        }
        printStream.println("}\n");
    }

    private static final void printDefinitions(SSAIterator.DefinitionIterator definitionIterator, PrintStream printStream) {
        SSAGraphPrinter.printDefinitions(definitionIterator, printStream, true);
    }

    public static void printToDot(DefinitionSet definitionSet, PrintStream printStream) {
        DefinitionSet definitionSet2 = new DefinitionSet();
        SSAIterator.DefinitionIterator definitionIterator = definitionSet.getDefinitionIterator();
        while (definitionIterator.hasNext()) {
            SSADefinition sSADefinition = definitionIterator.nextDefinition();
            SSAGraphPrinter.collectReachedDefinitions(sSADefinition, definitionSet2);
        }
        SSAGraphPrinter.printDefinitions(definitionSet2, printStream);
    }

    public static void printToDot(SSADefinition sSADefinition, PrintStream printStream) {
        DefinitionSet definitionSet = new DefinitionSet();
        SSAGraphPrinter.collectReachedDefinitions(sSADefinition, definitionSet);
        SSAGraphPrinter.printDefinitions(definitionSet, printStream);
    }

    public static void printAllToDot(PrintStream printStream) {
        SSAGraphPrinter.printDefinitions(SSADefinition.Helper.getAllDefinitionIterator(), printStream);
    }
}

