/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.BytecodeAnalysis;

import Compil3r.BytecodeAnalysis.ControlFlowGraph;
import Compil3r.BytecodeAnalysis.ExceptionHandlerIterator;
import Compil3r.BytecodeAnalysis.ExceptionHandlerSet;
import Util.Assert;

public class BasicBlock {
    public final int id;
    final int start;
    int end;
    BasicBlock[] predecessors;
    BasicBlock[] successors;
    ExceptionHandlerSet exception_handler_set;
    boolean isSubroutineRet;
    int startingStackDepth;

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getNumberOfPredecessors() {
        return this.predecessors.length;
    }

    public int getNumberOfSuccessors() {
        return this.successors.length;
    }

    public BasicBlock getPredecessor(int n) {
        return this.predecessors[n];
    }

    public BasicBlock getSuccessor(int n) {
        return this.successors[n];
    }

    public boolean isSubroutineRet() {
        return this.isSubroutineRet;
    }

    void setSubroutineRet(ControlFlowGraph controlFlowGraph, BasicBlock basicBlock) {
        this.isSubroutineRet = true;
        boolean bl = false;
        if (this.successors.length == 0) {
            bl = true;
        }
        Assert._assert(bl);
        this.successors = new BasicBlock[basicBlock.predecessors.length];
        int n = 0;
        while (n < this.successors.length) {
            BasicBlock basicBlock2;
            int n2 = basicBlock.predecessors[n].id + 1;
            boolean bl2 = false;
            if (n2 < controlFlowGraph.getNumberOfBasicBlocks()) {
                bl2 = true;
            }
            Assert._assert(bl2);
            this.successors[n] = basicBlock2 = controlFlowGraph.getBasicBlock(n2);
            BasicBlock[] basicBlockArray = new BasicBlock[basicBlock2.predecessors.length + 1];
            if (basicBlock2.predecessors.length != 0) {
                System.arraycopy(basicBlock2.predecessors, 0, basicBlockArray, 0, basicBlock2.predecessors.length);
            }
            basicBlockArray[basicBlock2.predecessors.length] = this;
            basicBlock2.predecessors = basicBlockArray;
            ++n;
        }
    }

    public ExceptionHandlerIterator getExceptionHandlers() {
        if (this.exception_handler_set == null) {
            return ExceptionHandlerIterator.nullIterator();
        }
        return this.exception_handler_set.iterator();
    }

    void addExceptionHandler_first(ExceptionHandlerSet exceptionHandlerSet) {
        boolean bl = false;
        if (exceptionHandlerSet.parent == null) {
            bl = true;
        }
        Assert._assert(bl);
        exceptionHandlerSet.parent = this.exception_handler_set;
        this.exception_handler_set = exceptionHandlerSet;
    }

    ExceptionHandlerSet addExceptionHandler(ExceptionHandlerSet exceptionHandlerSet) {
        if (exceptionHandlerSet.parent == this.exception_handler_set) {
            this.exception_handler_set = exceptionHandlerSet;
            return this.exception_handler_set;
        }
        this.exception_handler_set = new ExceptionHandlerSet(exceptionHandlerSet.getHandler(), this.exception_handler_set);
        return this.exception_handler_set;
    }

    public String toString() {
        return "BB" + this.id + " (" + this.start + '-' + this.end + ')';
    }

    BasicBlock(int n, int n2) {
        this.id = n;
        this.start = n2;
    }
}

