/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.BytecodeAnalysis;

import Clazz.jq_Method;
import Clazz.jq_TryCatchBC;
import Compil3r.BytecodeAnalysis.BasicBlock;
import Compil3r.BytecodeAnalysis.BytecodeVisitor;
import Compil3r.BytecodeAnalysis.ExceptionHandler;
import Compil3r.BytecodeAnalysis.ExceptionHandlerIterator;
import Compil3r.BytecodeAnalysis.ExceptionHandlerSet;
import Compil3r.BytecodeAnalysis.JSRInfo;
import Compil3r.BytecodeAnalysis.LiveRefAnalysis;
import Util.Assert;
import Util.BitString;
import Util.Collections.UnmodifiableIterator;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

public class ControlFlowGraph {
    public static final boolean TRACE = false;
    private final BasicBlock[] basic_blocks;
    private final BasicBlock[] handler_entries;
    private Map jsr_info;

    public BasicBlock getEntry() {
        return this.basic_blocks[0];
    }

    public BasicBlock getExit() {
        return this.basic_blocks[1];
    }

    public int getNumberOfBasicBlocks() {
        return this.basic_blocks.length;
    }

    public BasicBlock getBasicBlock(int n) {
        return this.basic_blocks[n];
    }

    public void addJSRInfo(BasicBlock basicBlock, BasicBlock basicBlock2, boolean[] blArray) {
        if (this.jsr_info == null) {
            this.jsr_info = new HashMap();
        }
        JSRInfo jSRInfo = new JSRInfo(basicBlock, basicBlock2, blArray);
        this.jsr_info.put(basicBlock, jSRInfo);
        this.jsr_info.put(basicBlock2, jSRInfo);
    }

    public JSRInfo getJSRInfo(BasicBlock basicBlock) {
        return this.jsr_info != null ? (JSRInfo)this.jsr_info.get(basicBlock) : null;
    }

    public BasicBlock getBasicBlockByBytecodeIndex(int n) {
        int n2;
        int n3 = 2;
        int n4 = this.basic_blocks.length - 1;
        while (true) {
            n2 = n3 + n4 >> 1;
            if (n3 > n4) break;
            int n5 = this.basic_blocks[n2].start;
            if (n < n5) {
                n4 = n2 - 1;
                continue;
            }
            n3 = n2 + 1;
        }
        BasicBlock basicBlock = this.basic_blocks[n2];
        boolean bl = false;
        if (basicBlock.start == n) {
            bl = true;
        }
        Assert._assert(bl);
        return basicBlock;
    }

    public RPOBasicBlockIterator reversePostOrderIterator() {
        return new RPOBasicBlockIterator(this.basic_blocks, this.basic_blocks[0]);
    }

    public RPOBasicBlockIterator reversePostOrderIterator(BasicBlock basicBlock) {
        return new RPOBasicBlockIterator(this.basic_blocks, basicBlock);
    }

    public static ControlFlowGraph computeCFG(jq_Method jq_Method2) {
        Object object;
        int n;
        Object object2;
        InitialPass initialPass = new InitialPass(jq_Method2);
        initialPass.forwardTraversal();
        byte[] byArray = jq_Method2.getBytecode();
        BitString bitString = initialPass.getBasicBlockStart();
        BitString bitString2 = initialPass.getBranchLocations();
        if (!bitString.get(byArray.length)) {
            bitString.set(byArray.length);
        }
        jq_TryCatchBC[] jq_TryCatchBCArray = jq_Method2.getExceptionTable();
        int n2 = 0;
        while (n2 < jq_TryCatchBCArray.length) {
            object2 = jq_TryCatchBCArray[n2];
            bitString.set(((jq_TryCatchBC)object2).getStartPC());
            bitString.set(((jq_TryCatchBC)object2).getEndPC());
            bitString.set(((jq_TryCatchBC)object2).getHandlerPC());
            ++n2;
        }
        n2 = bitString.numberOfOnes();
        object2 = new int[++n2];
        ControlFlowGraph controlFlowGraph = new ControlFlowGraph(n2, jq_TryCatchBCArray.length);
        controlFlowGraph.basic_blocks[0] = new BasicBlock(0, -1);
        controlFlowGraph.basic_blocks[1] = new BasicBlock(1, -1);
        int n3 = 2;
        Object object3 = null;
        object3 = new BasicBlock(2, 0);
        controlFlowGraph.basic_blocks[2] = object3;
        BitString.ForwardBitStringIterator forwardBitStringIterator = bitString.iterator();
        Assert._assert(((UnmodifiableIterator)forwardBitStringIterator).hasNext());
        while (true) {
            Assert._assert(((UnmodifiableIterator)forwardBitStringIterator).hasNext());
            int n4 = ((BitString.BitStringIterator)forwardBitStringIterator).nextIndex();
            controlFlowGraph.basic_blocks[n3 - 1].end = n4 - 1;
            if (n4 == byArray.length) break;
            controlFlowGraph.basic_blocks[n3] = new BasicBlock(n3, n4);
            object3 = controlFlowGraph.basic_blocks[n3];
            ++n3;
        }
        Assert._assert(((UnmodifiableIterator)forwardBitStringIterator).hasNext() ^ true);
        boolean bl = false;
        if (n3 == n2) {
            bl = true;
        }
        Assert._assert(bl);
        controlFlowGraph.basic_blocks[0].end = -1;
        controlFlowGraph.basic_blocks[0].successors = new BasicBlock[1];
        controlFlowGraph.basic_blocks[0].successors[0] = controlFlowGraph.basic_blocks[2];
        controlFlowGraph.basic_blocks[1].successors = new BasicBlock[0];
        controlFlowGraph.basic_blocks[0].predecessors = controlFlowGraph.basic_blocks[1].successors;
        ((BasicBlock)object3).end = byArray.length - 1;
        object2[2] = true;
        forwardBitStringIterator = bitString2.iterator();
        n3 = 2;
        BranchVisitor branchVisitor = new BranchVisitor(jq_Method2, controlFlowGraph, (int[])object2);
        while (((UnmodifiableIterator)forwardBitStringIterator).hasNext()) {
            n = ((BitString.BitStringIterator)forwardBitStringIterator).nextIndex();
            object3 = controlFlowGraph.basic_blocks[n3];
            while (n > ((BasicBlock)object3).end) {
                ((BasicBlock)object3).successors = new BasicBlock[1];
                ((BasicBlock)object3).successors[0] = controlFlowGraph.basic_blocks[n3 + 1];
                object = ((BasicBlock)object3).successors[0];
                Object object4 = object2;
                int n4 = ++n3;
                object4[n4] = object4[n4] + true;
                object3 = object;
            }
            branchVisitor.bb = object3;
            branchVisitor.setLocation(n);
            branchVisitor.visitBytecode();
            ++n3;
        }
        if (n3 != n2) {
            boolean bl2 = false;
            if (n3 == n2 - 1) {
                bl2 = true;
            }
            Assert._assert(bl2);
            controlFlowGraph.basic_blocks[n3].successors = new BasicBlock[0];
        }
        n3 = 1;
        while (n3 < n2) {
            object3 = controlFlowGraph.basic_blocks[n3];
            ((BasicBlock)object3).predecessors = new BasicBlock[object2[n3]];
            boolean bl3 = false;
            if (((BasicBlock)object3).successors != null) {
                bl3 = true;
            }
            Assert._assert(bl3);
            object2[n3] = -1;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            object3 = controlFlowGraph.basic_blocks[n3];
            n = 0;
            while (n < ((BasicBlock)object3).successors.length) {
                object = ((BasicBlock)object3).successors[n];
                Object object5 = object2;
                int n5 = ((BasicBlock)object).id;
                reference v7 = object5[n5] + true;
                object5[n5] = v7;
                ((BasicBlock)object).predecessors[v7] = object3;
                ++n;
            }
            ++n3;
        }
        n = jq_TryCatchBCArray.length - 1;
        while (n >= 0) {
            object = jq_TryCatchBCArray[n];
            object3 = controlFlowGraph.getBasicBlockByBytecodeIndex(((jq_TryCatchBC)object).getStartPC());
            if (((BasicBlock)object3).start >= ((jq_TryCatchBC)object).getEndPC()) {
                throw new VerifyError("Exception handler " + n + ' ' + object + ": start (" + ((BasicBlock)object3).start + ") comes after end (" + ((jq_TryCatchBC)object).getEndPC() + ')');
            }
            int n7 = (((jq_TryCatchBC)object).getEndPC() == byArray.length ? n2 : controlFlowGraph.getBasicBlockByBytecodeIndex((int)((jq_TryCatchBC)object).getEndPC()).id) - ((BasicBlock)object3).id;
            BasicBlock basicBlock = controlFlowGraph.getBasicBlockByBytecodeIndex(((jq_TryCatchBC)object).getHandlerPC());
            ExceptionHandler exceptionHandler = new ExceptionHandler(((jq_TryCatchBC)object).getExceptionType(), n7, basicBlock);
            ExceptionHandlerSet exceptionHandlerSet = new ExceptionHandlerSet(exceptionHandler, null);
            ((BasicBlock)object3).addExceptionHandler_first(exceptionHandlerSet);
            int n8 = ((BasicBlock)object3).id;
            while (((BasicBlock)object3).getStart() < ((jq_TryCatchBC)object).getEndPC()) {
                exceptionHandler.handledBlocks[((BasicBlock)object3).id - n8] = object3;
                exceptionHandlerSet = ((BasicBlock)object3).addExceptionHandler(exceptionHandlerSet);
                object3 = controlFlowGraph.basic_blocks[((BasicBlock)object3).id + 1];
            }
            --n;
        }
        if (initialPass.nJsrs > 0) {
            LiveRefAnalysis liveRefAnalysis = new LiveRefAnalysis(jq_Method2);
            liveRefAnalysis.compute(controlFlowGraph);
        }
        return controlFlowGraph;
    }

    private ControlFlowGraph(int n, int n2) {
        this.basic_blocks = new BasicBlock[n];
        this.handler_entries = new BasicBlock[n2];
    }

    public static class RPOBasicBlockIterator
    implements BasicBlockIterator {
        private BasicBlock[] rpo;
        private int index;

        private final void visit(boolean[] blArray, BasicBlock basicBlock) {
            Object object;
            int n = basicBlock.getNumberOfSuccessors();
            int n2 = 0;
            while (n2 < n) {
                object = basicBlock.getSuccessor(n2);
                if (!blArray[((BasicBlock)object).id]) {
                    blArray[((BasicBlock)object).id] = true;
                    this.visit(blArray, (BasicBlock)object);
                }
                ++n2;
            }
            ExceptionHandlerIterator exceptionHandlerIterator = basicBlock.getExceptionHandlers();
            while (exceptionHandlerIterator.hasNext()) {
                object = exceptionHandlerIterator.nextEH();
                BasicBlock basicBlock2 = ((ExceptionHandler)object).getEntry();
                if (blArray[basicBlock2.id]) continue;
                blArray[basicBlock2.id] = true;
                this.visit(blArray, basicBlock2);
            }
            this.rpo[--this.index] = basicBlock;
        }

        public boolean hasNext() {
            boolean bl = false;
            if (this.index < this.rpo.length - 1) {
                bl = true;
            }
            return bl;
        }

        public BasicBlock nextBB() {
            return this.rpo[++this.index];
        }

        public Object next() {
            return this.nextBB();
        }

        public int nextIndex() {
            return this.index + 1;
        }

        public boolean hasPrevious() {
            boolean bl = false;
            if (this.index >= 0 && this.rpo[this.index] != null) {
                bl = true;
            }
            return bl;
        }

        public BasicBlock previousBB() {
            return this.rpo[this.index--];
        }

        public Object previous() {
            return this.previousBB();
        }

        public int previousIndex() {
            return this.index;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void jumpToEnd() {
            this.index = this.rpo.length - 1;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.rpo.length) {
                stringBuffer.append(this.rpo[n]);
                if (n == this.index) {
                    stringBuffer.append(" * ");
                } else {
                    stringBuffer.append("   ");
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        RPOBasicBlockIterator(BasicBlock[] basicBlockArray, BasicBlock basicBlock) {
            this.index = basicBlockArray.length;
            this.rpo = new BasicBlock[this.index];
            boolean[] blArray = new boolean[this.index];
            this.visit(blArray, basicBlock);
            --this.index;
        }
    }

    public static class InitialPass
    extends BytecodeVisitor {
        private BitString basic_block_start;
        private BitString branch_locations;
        private int nJsrs;
        private int nRets;
        private int nExits;

        public String toString() {
            return "CFG1/" + this.method.getName();
        }

        public BitString getBasicBlockStart() {
            return this.basic_block_start;
        }

        public BitString getBranchLocations() {
            return this.branch_locations;
        }

        public int getNumberOfExits() {
            return this.nExits;
        }

        private final void addBranch(int n) {
            this.basic_block_start.set(n);
            this.endBB();
        }

        private final void endBB() {
            this.branch_locations.set(this.i_start);
            this.basic_block_start.set(this.i_end + 1);
        }

        public void visitJSR(int n) {
            super.visitJSR(n);
            ++this.nJsrs;
            this.addBranch(n);
        }

        public void visitGOTO(int n) {
            super.visitGOTO(n);
            this.addBranch(n);
        }

        public void visitIRETURN() {
            super.visitIRETURN();
            ++this.nExits;
            this.endBB();
        }

        public void visitLRETURN() {
            super.visitLRETURN();
            ++this.nExits;
            this.endBB();
        }

        public void visitFRETURN() {
            super.visitFRETURN();
            ++this.nExits;
            this.endBB();
        }

        public void visitDRETURN() {
            super.visitDRETURN();
            ++this.nExits;
            this.endBB();
        }

        public void visitARETURN() {
            super.visitARETURN();
            ++this.nExits;
            this.endBB();
        }

        public void visitVRETURN() {
            super.visitVRETURN();
            ++this.nExits;
            this.endBB();
        }

        public void visitATHROW() {
            super.visitATHROW();
            ++this.nExits;
            this.endBB();
        }

        public void visitRET(int n) {
            super.visitRET(n);
            ++this.nRets;
            this.endBB();
        }

        public void visitIF(byte by, int n) {
            super.visitIF(by, n);
            this.addBranch(n);
        }

        public void visitIFREF(byte by, int n) {
            super.visitIFREF(by, n);
            this.addBranch(n);
        }

        public void visitIFCMP(byte by, int n) {
            super.visitIFCMP(by, n);
            this.addBranch(n);
        }

        public void visitIFREFCMP(byte by, int n) {
            super.visitIFREFCMP(by, n);
            this.addBranch(n);
        }

        public void visitTABLESWITCH(int n, int n2, int n3, int[] nArray) {
            super.visitTABLESWITCH(n, n2, n3, nArray);
            int n4 = 0;
            while (n4 < nArray.length) {
                this.basic_block_start.set(nArray[n4]);
                ++n4;
            }
            this.addBranch(n);
        }

        public void visitLOOKUPSWITCH(int n, int[] nArray, int[] nArray2) {
            super.visitLOOKUPSWITCH(n, nArray, nArray2);
            int n2 = 0;
            while (n2 < nArray2.length) {
                this.basic_block_start.set(nArray2[n2]);
                ++n2;
            }
            this.addBranch(n);
        }

        InitialPass(jq_Method jq_Method2) {
            super(jq_Method2);
            this.basic_block_start = new BitString(this.bcs.length + 1);
            this.branch_locations = new BitString(this.bcs.length);
            this.basic_block_start.set(0);
        }
    }

    static class BranchVisitor
    extends BytecodeVisitor {
        private final ControlFlowGraph cfg;
        private final int[] n_pred;
        BasicBlock bb;

        void setLocation(int n) {
            this.i_start = n;
            this.i_end = n - 1;
        }

        public void visitJSR(int n) {
            super.visitJSR(n);
            BasicBlock basicBlock = this.cfg.getBasicBlockByBytecodeIndex(n);
            int n2 = basicBlock.id;
            this.n_pred[n2] = this.n_pred[n2] + 1;
            this.bb.successors = new BasicBlock[1];
            this.bb.successors[0] = basicBlock;
        }

        public void visitRET(int n) {
            super.visitRET(n);
            this.bb.successors = new BasicBlock[0];
        }

        public void visitGOTO(int n) {
            super.visitGOTO(n);
            BasicBlock basicBlock = this.cfg.getBasicBlockByBytecodeIndex(n);
            int n2 = basicBlock.id;
            this.n_pred[n2] = this.n_pred[n2] + 1;
            this.bb.successors = new BasicBlock[1];
            this.bb.successors[0] = basicBlock;
        }

        private final void RETURNhelper() {
            BasicBlock basicBlock = this.cfg.basic_blocks[1];
            int n = basicBlock.id;
            this.n_pred[n] = this.n_pred[n] + 1;
            this.bb.successors = new BasicBlock[1];
            this.bb.successors[0] = basicBlock;
        }

        public void visitIRETURN() {
            super.visitIRETURN();
            this.RETURNhelper();
        }

        public void visitLRETURN() {
            super.visitLRETURN();
            this.RETURNhelper();
        }

        public void visitFRETURN() {
            super.visitFRETURN();
            this.RETURNhelper();
        }

        public void visitDRETURN() {
            super.visitDRETURN();
            this.RETURNhelper();
        }

        public void visitARETURN() {
            super.visitARETURN();
            this.RETURNhelper();
        }

        public void visitVRETURN() {
            super.visitVRETURN();
            this.RETURNhelper();
        }

        public void visitATHROW() {
            super.visitATHROW();
            this.RETURNhelper();
        }

        private final void CONDBRANCHhelper(int n) {
            int n2 = this.bb.id;
            BasicBlock basicBlock = this.cfg.basic_blocks[n2 + 1];
            int n3 = basicBlock.id;
            this.n_pred[n3] = this.n_pred[n3] + 1;
            BasicBlock basicBlock2 = this.cfg.getBasicBlockByBytecodeIndex(n);
            int n4 = basicBlock2.id;
            this.n_pred[n4] = this.n_pred[n4] + 1;
            this.bb.successors = new BasicBlock[2];
            this.bb.successors[0] = basicBlock;
            this.bb.successors[1] = basicBlock2;
        }

        public void visitIF(byte by, int n) {
            super.visitIF(by, n);
            this.CONDBRANCHhelper(n);
        }

        public void visitIFREF(byte by, int n) {
            super.visitIFREF(by, n);
            this.CONDBRANCHhelper(n);
        }

        public void visitIFCMP(byte by, int n) {
            super.visitIFCMP(by, n);
            this.CONDBRANCHhelper(n);
        }

        public void visitIFREFCMP(byte by, int n) {
            super.visitIFREFCMP(by, n);
            this.CONDBRANCHhelper(n);
        }

        public void visitTABLESWITCH(int n, int n2, int n3, int[] nArray) {
            super.visitTABLESWITCH(n, n2, n3, nArray);
            BasicBlock basicBlock = this.cfg.getBasicBlockByBytecodeIndex(n);
            int n4 = basicBlock.id;
            this.n_pred[n4] = this.n_pred[n4] + 1;
            this.bb.successors = new BasicBlock[nArray.length + 1];
            this.bb.successors[0] = basicBlock;
            int n5 = 0;
            while (n5 < nArray.length) {
                basicBlock = this.cfg.getBasicBlockByBytecodeIndex(nArray[n5]);
                int n6 = basicBlock.id;
                this.n_pred[n6] = this.n_pred[n6] + 1;
                this.bb.successors[n5 + 1] = basicBlock;
                ++n5;
            }
        }

        public void visitLOOKUPSWITCH(int n, int[] nArray, int[] nArray2) {
            super.visitLOOKUPSWITCH(n, nArray, nArray2);
            BasicBlock basicBlock = this.cfg.getBasicBlockByBytecodeIndex(n);
            int n2 = basicBlock.id;
            this.n_pred[n2] = this.n_pred[n2] + 1;
            this.bb.successors = new BasicBlock[nArray2.length + 1];
            this.bb.successors[0] = basicBlock;
            int n3 = 0;
            while (n3 < nArray2.length) {
                basicBlock = this.cfg.getBasicBlockByBytecodeIndex(nArray2[n3]);
                int n4 = basicBlock.id;
                this.n_pred[n4] = this.n_pred[n4] + 1;
                this.bb.successors[n3 + 1] = basicBlock;
                ++n3;
            }
        }

        BranchVisitor(jq_Method jq_Method2, ControlFlowGraph controlFlowGraph, int[] nArray) {
            super(jq_Method2);
            this.cfg = controlFlowGraph;
            this.n_pred = nArray;
        }
    }

    public static interface BasicBlockIterator
    extends ListIterator {
        public BasicBlock nextBB();

        public BasicBlock previousBB();
    }
}

