/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.BytecodeAnalysis;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_InstanceField;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_StaticField;
import Clazz.jq_Type;
import Compil3r.BytecodeAnalysis.BasicBlock;
import Compil3r.BytecodeAnalysis.BytecodeVisitor;
import Compil3r.BytecodeAnalysis.ControlFlowGraph;
import Compil3r.BytecodeAnalysis.ExceptionHandler;
import Compil3r.BytecodeAnalysis.ExceptionHandlerIterator;
import Run_Time.TypeCheck;
import Util.Assert;
import Util.BitString;
import Util.Collections.LinearSet;
import Util.Collections.UnmodifiableIterator;
import Util.Strings;
import java.util.Set;

public class LiveRefAnalysis {
    public static final byte NOT_LIVE = 0;
    public static final byte LIVE_INT = 1;
    public static final byte LIVE_FLOAT = 2;
    public static final byte LIVE_LONG1 = 3;
    public static final byte LIVE_LONG2 = 4;
    public static final byte LIVE_DOUBLE1 = 5;
    public static final byte LIVE_DOUBLE2 = 6;
    public static final byte LIVE_REF = 7;
    public static final byte LIVE_DERIVED_REF = 8;
    public static final byte LIVE_RETADDR = 9;
    public static final String[] TYPE_NAMES = new String[]{"NOT_LIVE", "LIVE_INT", "LIVE_FLOAT", "LIVE_LONG1", "LIVE_LONG2", "LIVE_DOUBLE1", "LIVE_DOUBLE2", "LIVE_REF", "LIVE_DERIVED_REF", "LIVE_RETADDR"};
    public static final byte SET_TO_INT = 33;
    public static final byte SET_TO_FLOAT = 34;
    public static final byte SET_TO_LONG1 = 35;
    public static final byte SET_TO_LONG2 = 36;
    public static final byte SET_TO_DOUBLE1 = 37;
    public static final byte SET_TO_DOUBLE2 = 38;
    public static final byte SET_TO_REF = 39;
    public static final byte SET_TO_DERIVED_REF = 40;
    public static final byte SET_TO_RETADDR = 41;
    public static boolean ALWAYS_TRACE = false;
    private jq_Method method;
    private ExactState[] start_states;
    private ExactState[] end_states;

    public ExactState getState(BasicBlock basicBlock) {
        return this.start_states[basicBlock.id];
    }

    public void compute() {
        ControlFlowGraph controlFlowGraph = ControlFlowGraph.computeCFG(this.method);
        this.compute(controlFlowGraph);
    }

    public void compute(ControlFlowGraph controlFlowGraph) {
        BasicBlock basicBlock;
        Object object;
        Object object2;
        FirstPassVisitor firstPassVisitor = new FirstPassVisitor(this.method, controlFlowGraph);
        this.start_states = new ExactState[controlFlowGraph.getNumberOfBasicBlocks()];
        this.end_states = new ExactState[controlFlowGraph.getNumberOfBasicBlocks()];
        this.start_states[2] = ExactState.allocateInitialState(this.method);
        do {
            firstPassVisitor.go_again = false;
            object2 = controlFlowGraph.reversePostOrderIterator();
            object = ((ControlFlowGraph.RPOBasicBlockIterator)object2).nextBB();
            boolean bl = false;
            if (object == controlFlowGraph.getEntry()) {
                bl = true;
            }
            Assert._assert(bl);
            while (((ControlFlowGraph.RPOBasicBlockIterator)object2).hasNext()) {
                if (ALWAYS_TRACE) {
                    System.out.println("Iteration : " + ((ControlFlowGraph.RPOBasicBlockIterator)object2).toString());
                }
                basicBlock = ((ControlFlowGraph.RPOBasicBlockIterator)object2).nextBB();
                if (ALWAYS_TRACE) {
                    System.out.println(basicBlock + " : start state " + this.start_states[basicBlock.id]);
                }
                firstPassVisitor.traverseBB(basicBlock);
                if (!ALWAYS_TRACE) continue;
                System.out.println(basicBlock + " : end state " + this.end_states[basicBlock.id]);
            }
        } while (firstPassVisitor.go_again);
        object2 = new SecondPassVisitor(this.method, firstPassVisitor.getBytecodeStart());
        do {
            ((SecondPassVisitor)object2).go_again = false;
            object = controlFlowGraph.reversePostOrderIterator();
            ((ControlFlowGraph.RPOBasicBlockIterator)object).jumpToEnd();
            while (((ControlFlowGraph.RPOBasicBlockIterator)object).hasPrevious()) {
                if (ALWAYS_TRACE) {
                    System.out.println("Iteration : " + ((ControlFlowGraph.RPOBasicBlockIterator)object).toString());
                }
                basicBlock = ((ControlFlowGraph.RPOBasicBlockIterator)object).previousBB();
                if (ALWAYS_TRACE) {
                    System.out.println(basicBlock + " : end state " + this.end_states[basicBlock.id]);
                }
                ((SecondPassVisitor)object2).traverseBB(basicBlock);
                if (!ALWAYS_TRACE) continue;
                System.out.println(basicBlock + " : start state " + this.start_states[basicBlock.id]);
            }
        } while (((SecondPassVisitor)object2).go_again);
    }

    public void dump() {
        int n = 0;
        while (n < this.start_states.length) {
            if (this.start_states[n] != null) {
                System.out.println("BB" + n + " start: " + this.start_states[n].toString());
            }
            if (this.end_states[n] != null) {
                System.out.println("BB" + n + " end: " + this.end_states[n].toString());
            }
            ++n;
        }
        System.out.println();
    }

    public LiveRefAnalysis(jq_Method jq_Method2) {
        this.method = jq_Method2;
    }

    public static abstract class Type {
        public abstract Type findCommonSuperclass(Type var1);

        public abstract boolean isReferenceType();

        public Type getElementType() {
            return NullConstant.INSTANCE;
        }
    }

    public static class SystemType
    extends Type {
        public static final SystemType INT = new SystemType(jq_Primitive.INT);
        public static final SystemType FLOAT = new SystemType(jq_Primitive.FLOAT);
        public static final SystemType LONG = new SystemType(jq_Primitive.LONG);
        public static final SystemType DOUBLE = new SystemType(jq_Primitive.DOUBLE);
        public static final SystemType OBJECT = new SystemType(PrimordialClassLoader.getJavaLangObject());
        private final jq_Type type;

        public jq_Type getType() {
            return this.type;
        }

        public Type findCommonSuperclass(Type type) {
            if (type instanceof SystemType) {
                SystemType systemType = (SystemType)type;
                jq_Type jq_Type2 = TypeCheck.findCommonSuperclass(this.type, systemType.type, true);
                if (jq_Type2 == null) {
                    return null;
                }
                if (jq_Type2 == this.type) {
                    return this;
                }
                if (jq_Type2 == systemType.type) {
                    return systemType;
                }
                if (ALWAYS_TRACE) {
                    System.out.println("Superclass of " + this + " and " + type + " is " + jq_Type2);
                }
                return new SystemType(jq_Type2);
            }
            if (type instanceof NullConstant && this.type.isReferenceType()) {
                return this;
            }
            return null;
        }

        public Type getElementType() {
            jq_Array jq_Array2 = (jq_Array)this.type;
            if (jq_Array2.getElementType().isAddressType()) {
                return DerivedRef.INSTANCE;
            }
            return new SystemType(jq_Array2.getElementType());
        }

        public boolean equals(SystemType systemType) {
            boolean bl = false;
            if (this.type == systemType.type) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            return this.equals((SystemType)object);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean isReferenceType() {
            return this.type.isReferenceType();
        }

        public String toString() {
            return this.type.toString();
        }

        SystemType(jq_Type jq_Type2) {
            if (jq_Type2.isIntLike()) {
                jq_Type2 = jq_Primitive.INT;
            }
            this.type = jq_Type2;
        }
    }

    public static class DerivedRef
    extends Type {
        public static final DerivedRef INSTANCE = new DerivedRef();

        public Type findCommonSuperclass(Type type) {
            if (type instanceof DerivedRef) {
                return this;
            }
            return null;
        }

        public boolean isReferenceType() {
            return false;
        }

        public String toString() {
            return "DerivedRef";
        }
    }

    public static class NullConstant
    extends Type {
        public static final NullConstant INSTANCE = new NullConstant();

        public Type findCommonSuperclass(Type type) {
            if (type.isReferenceType()) {
                return type;
            }
            return null;
        }

        public boolean isReferenceType() {
            return true;
        }

        public String toString() {
            return "NULL";
        }
    }

    public static class HalfOfNumber
    extends Type {
        public static final HalfOfNumber INSTANCE = new HalfOfNumber();

        public Type findCommonSuperclass(Type type) {
            if (type instanceof HalfOfNumber) {
                return type;
            }
            return null;
        }

        public boolean isReferenceType() {
            return false;
        }

        public String toString() {
            return "HALF";
        }
    }

    public static class Retaddr
    extends Type {
        int location;

        public Type findCommonSuperclass(Type type) {
            if (type instanceof Retaddr && this.equals((Retaddr)type)) {
                return this;
            }
            return null;
        }

        public boolean equals(Retaddr retaddr) {
            boolean bl = false;
            if (this.location == retaddr.location) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            return this.equals((Retaddr)object);
        }

        public int hashCode() {
            return this.location;
        }

        public boolean isReferenceType() {
            return false;
        }

        public String toString() {
            return "RetAddr:" + this.location;
        }

        Retaddr(int n) {
            this.location = n;
        }
    }

    public static class ExactJSRState
    extends ExactState {
        protected boolean[] mayChangeLocals;
        protected boolean[] mustChangeLocals;

        public ExactState copy() {
            ExactJSRState exactJSRState = new ExactJSRState(this.stack.length, this.locals.length);
            System.arraycopy(this.stack, 0, exactJSRState.stack, 0, this.stackDepth);
            System.arraycopy(this.locals, 0, exactJSRState.locals, 0, this.locals.length);
            System.arraycopy(this.mayChangeLocals, 0, exactJSRState.mayChangeLocals, 0, this.mayChangeLocals.length);
            System.arraycopy(this.mustChangeLocals, 0, exactJSRState.mustChangeLocals, 0, this.mustChangeLocals.length);
            exactJSRState.stackDepth = this.stackDepth;
            return exactJSRState;
        }

        public ExactJSRState copyAsJSR() {
            if (ALWAYS_TRACE) {
                System.out.println("nested jsr's! adding nesting level");
            }
            return super.copyAsJSR();
        }

        public ExactState copyJSR(ExactJSRState exactJSRState) {
            if (ALWAYS_TRACE) {
                System.out.println("nested jsr's! removing nesting level");
            }
            ExactJSRState exactJSRState2 = new ExactJSRState(this.stack.length, this.locals.length);
            System.arraycopy(exactJSRState.stack, 0, exactJSRState2.stack, 0, exactJSRState.stackDepth);
            System.arraycopy(this.locals, 0, exactJSRState2.locals, 0, this.locals.length);
            exactJSRState2.stackDepth = exactJSRState.stackDepth;
            int n = 0;
            while (n < this.locals.length) {
                if (exactJSRState.mayChangeLocals[n]) {
                    if (ALWAYS_TRACE) {
                        System.out.println("nested jsr may change local " + n);
                    }
                    this.locals[n] = exactJSRState.locals[n];
                    this.mayChangeLocals[n] = true;
                    if (exactJSRState.mustChangeLocals[n]) {
                        this.mustChangeLocals[n] = true;
                    }
                }
                ++n;
            }
            return exactJSRState2;
        }

        public ExactState copyHandler(jq_Type jq_Type2) {
            ExactJSRState exactJSRState = new ExactJSRState(this.stack.length, this.locals.length);
            System.arraycopy(this.locals, 0, exactJSRState.locals, 0, this.locals.length);
            System.arraycopy(this.mayChangeLocals, 0, exactJSRState.mayChangeLocals, 0, this.mayChangeLocals.length);
            System.arraycopy(this.mustChangeLocals, 0, exactJSRState.mustChangeLocals, 0, this.mustChangeLocals.length);
            exactJSRState.stackDepth = 1;
            exactJSRState.stack[0] = new SystemType(jq_Type2);
            return exactJSRState;
        }

        public boolean mergeBeforeJSR(ExactState exactState) {
            return super.merge(exactState);
        }

        public boolean merge(ExactState exactState) {
            Type type;
            boolean bl = false;
            if (this.stackDepth == exactState.stackDepth) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            int n = 0;
            while (n < this.stackDepth) {
                if (this.stack[n] != null) {
                    if (exactState.stack[n] == null) {
                        this.stack[n] = null;
                        bl2 = true;
                    } else {
                        type = this.stack[n].findCommonSuperclass(exactState.stack[n]);
                        if (type != this.stack[n]) {
                            bl2 = true;
                        }
                        this.stack[n] = type;
                    }
                }
                ++n;
            }
            n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    if (exactState.locals[n] == null) {
                        this.locals[n] = null;
                        bl2 = true;
                    } else {
                        type = this.locals[n].findCommonSuperclass(exactState.locals[n]);
                        if (type != this.locals[n]) {
                            bl2 = true;
                        }
                        this.locals[n] = type;
                    }
                }
                ++n;
            }
            if (exactState instanceof ExactJSRState) {
                ExactJSRState exactJSRState = (ExactJSRState)exactState;
                int n2 = 0;
                while (n2 < this.mayChangeLocals.length) {
                    if (exactJSRState.mayChangeLocals[n2] && !this.mayChangeLocals[n2]) {
                        if (ALWAYS_TRACE) {
                            System.out.println("updated: may change local " + n2 + " during merge");
                        }
                        this.mayChangeLocals[n2] = true;
                        bl2 = true;
                    }
                    if (!exactJSRState.mustChangeLocals[n2] && this.mustChangeLocals[n2]) {
                        this.mustChangeLocals[n2] = false;
                        bl2 = true;
                    }
                    ++n2;
                }
            }
            return bl2;
        }

        public boolean mergeWithHandler(ExactState exactState) {
            boolean bl = false;
            if (this.stackDepth == 1) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            int n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    if (exactState.locals[n] == null) {
                        this.locals[n] = null;
                        bl2 = true;
                    } else {
                        Type type = this.locals[n].findCommonSuperclass(exactState.locals[n]);
                        if (type != this.locals[n]) {
                            bl2 = true;
                        }
                        this.locals[n] = type;
                    }
                }
                ++n;
            }
            if (exactState instanceof ExactJSRState) {
                ExactJSRState exactJSRState = (ExactJSRState)exactState;
                int n2 = 0;
                while (n2 < this.mayChangeLocals.length) {
                    if (exactJSRState.mayChangeLocals[n2] && !this.mayChangeLocals[n2]) {
                        if (ALWAYS_TRACE) {
                            System.out.println("updated: may change local " + n2 + " during exception handler merge");
                        }
                        this.mayChangeLocals[n2] = true;
                        bl2 = true;
                    }
                    if (!exactJSRState.mustChangeLocals[n2] && this.mustChangeLocals[n2]) {
                        this.mustChangeLocals[n2] = false;
                        bl2 = true;
                    }
                    ++n2;
                }
            }
            return bl2;
        }

        void setLocal_I(int n) {
            super.setLocal_I(n);
            this.mustChangeLocals[n] = true;
            this.mayChangeLocals[n] = true;
        }

        void setLocal_F(int n) {
            super.setLocal_F(n);
            this.mustChangeLocals[n] = true;
            this.mayChangeLocals[n] = true;
        }

        void setLocal_L(int n) {
            super.setLocal_L(n);
            this.mustChangeLocals[n] = true;
            this.mayChangeLocals[n] = true;
            this.mustChangeLocals[n + 1] = true;
            this.mayChangeLocals[n + 1] = true;
        }

        void setLocal_D(int n) {
            super.setLocal_D(n);
            this.mustChangeLocals[n] = true;
            this.mayChangeLocals[n] = true;
            this.mustChangeLocals[n + 1] = true;
            this.mayChangeLocals[n + 1] = true;
        }

        void setLocal(int n, Type type) {
            super.setLocal(n, type);
            this.mustChangeLocals[n] = true;
            this.mayChangeLocals[n] = true;
        }

        public String toString_live() {
            StringBuffer stringBuffer = new StringBuffer("Live Locals: { ");
            int n = 0;
            while (n < this.locals.length) {
                if (this.getLocal(n) != null) {
                    stringBuffer.append(n);
                    stringBuffer.append('=');
                    stringBuffer.append(this.locals[n].toString());
                    if (this.mayChangeLocals[n]) {
                        stringBuffer.append('*');
                    }
                    if (this.mustChangeLocals[n]) {
                        stringBuffer.append('&');
                    }
                    if (n < this.locals.length - 1) {
                        stringBuffer.append(',');
                    }
                }
                ++n;
            }
            stringBuffer.append(" }");
            if (this.stackDepth > 0) {
                stringBuffer.append(Strings.lineSep);
                stringBuffer.append("Stack: {");
                n = 0;
                while (n < this.stackDepth) {
                    stringBuffer.append(n);
                    stringBuffer.append('=');
                    stringBuffer.append(this.stack[n] == null ? "null" : this.stack[n].toString());
                    if (n < this.stackDepth - 1) {
                        stringBuffer.append(',');
                    }
                    ++n;
                }
                stringBuffer.append(" }");
            }
            return stringBuffer.toString();
        }

        public String toString() {
            if (this.liveness != null) {
                return this.toString_live();
            }
            StringBuffer stringBuffer = new StringBuffer("Locals: { ");
            int n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    stringBuffer.append(n);
                    stringBuffer.append('=');
                    stringBuffer.append(this.locals[n].toString());
                    if (this.mayChangeLocals[n]) {
                        stringBuffer.append('*');
                    }
                    if (this.mustChangeLocals[n]) {
                        stringBuffer.append('&');
                    }
                    if (n < this.locals.length - 1) {
                        stringBuffer.append(',');
                    }
                }
                ++n;
            }
            stringBuffer.append(" }");
            if (this.stackDepth > 0) {
                stringBuffer.append(Strings.lineSep);
                stringBuffer.append("Stack: {");
                n = 0;
                while (n < this.stackDepth) {
                    stringBuffer.append(n);
                    stringBuffer.append('=');
                    stringBuffer.append(this.stack[n] == null ? "null" : this.stack[n].toString());
                    if (n < this.stackDepth - 1) {
                        stringBuffer.append(',');
                    }
                    ++n;
                }
                stringBuffer.append(" }");
            }
            return stringBuffer.toString();
        }

        ExactJSRState(int n, int n2) {
            super(n, n2);
            this.mayChangeLocals = new boolean[n2];
            this.mustChangeLocals = new boolean[n2];
        }
    }

    public static class ExactState {
        protected int stackDepth;
        protected Type[] stack;
        protected Type[] locals;
        protected boolean[] liveness;
        protected Set last_uses;

        public static ExactState allocateEmptyState(jq_Method jq_Method2) {
            return new ExactState(jq_Method2.getMaxStack(), jq_Method2.getMaxLocals());
        }

        public static ExactState allocateInitialState(jq_Method jq_Method2) {
            ExactState exactState = new ExactState(jq_Method2.getMaxStack(), jq_Method2.getMaxLocals());
            jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
            int n = 0;
            int n2 = 0;
            while (n < jq_TypeArray.length) {
                exactState.locals[n2] = new SystemType(jq_TypeArray[n]);
                if (jq_TypeArray[n].getReferenceSize() == 8) {
                    exactState.locals[++n2] = HalfOfNumber.INSTANCE;
                }
                ++n;
                ++n2;
            }
            return exactState;
        }

        public void allocateLiveness() {
            if (this.liveness == null) {
                this.liveness = new boolean[this.locals.length];
            }
        }

        public void initializeLastUses() {
            this.last_uses = new LinearSet();
        }

        public boolean compareLiveness(ExactState exactState) {
            if (exactState.liveness == null) {
                return true;
            }
            int n = 0;
            while (n < this.liveness.length) {
                if (this.liveness[n] != exactState.liveness[n]) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public ExactState copy() {
            ExactState exactState = new ExactState(this.stack.length, this.locals.length);
            System.arraycopy(this.stack, 0, exactState.stack, 0, this.stackDepth);
            System.arraycopy(this.locals, 0, exactState.locals, 0, this.locals.length);
            if (this.liveness != null) {
                exactState.liveness = new boolean[this.liveness.length];
                System.arraycopy(this.liveness, 0, exactState.liveness, 0, this.liveness.length);
            }
            exactState.stackDepth = this.stackDepth;
            return exactState;
        }

        public ExactJSRState copyAsJSR() {
            ExactJSRState exactJSRState = new ExactJSRState(this.stack.length, this.locals.length);
            System.arraycopy(this.stack, 0, exactJSRState.stack, 0, this.stackDepth);
            System.arraycopy(this.locals, 0, exactJSRState.locals, 0, this.locals.length);
            exactJSRState.stackDepth = this.stackDepth;
            return exactJSRState;
        }

        public ExactState copyJSR(ExactJSRState exactJSRState) {
            ExactState exactState = new ExactState(this.stack.length, this.locals.length);
            System.arraycopy(exactJSRState.stack, 0, exactState.stack, 0, exactJSRState.stackDepth);
            System.arraycopy(this.locals, 0, exactState.locals, 0, this.locals.length);
            exactState.stackDepth = exactJSRState.stackDepth;
            int n = 0;
            while (n < this.locals.length) {
                if (exactJSRState.mayChangeLocals[n]) {
                    this.locals[n] = exactJSRState.locals[n];
                }
                ++n;
            }
            return exactState;
        }

        public ExactState copyHandler(jq_Type jq_Type2) {
            ExactState exactState = new ExactState(this.stack.length, this.locals.length);
            System.arraycopy(this.locals, 0, exactState.locals, 0, this.locals.length);
            exactState.stackDepth = 1;
            exactState.stack[0] = new SystemType(jq_Type2);
            return exactState;
        }

        public boolean mergeLiveness(ExactState exactState) {
            if (exactState.liveness == null) {
                return false;
            }
            if (this.liveness == null) {
                this.liveness = new boolean[this.locals.length];
                System.arraycopy(exactState.liveness, 0, this.liveness, 0, this.liveness.length);
                return true;
            }
            boolean bl = false;
            int n = 0;
            while (n < this.liveness.length) {
                if (!this.liveness[n] && exactState.liveness[n]) {
                    this.liveness[n] = true;
                    bl = true;
                }
                ++n;
            }
            return bl;
        }

        public boolean merge(ExactState exactState) {
            Type type;
            boolean bl = false;
            if (this.stackDepth == exactState.stackDepth) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            int n = 0;
            while (n < this.stackDepth) {
                if (this.stack[n] != null) {
                    if (exactState.stack[n] == null) {
                        this.stack[n] = null;
                        bl2 = true;
                    } else {
                        type = this.stack[n].findCommonSuperclass(exactState.stack[n]);
                        if (type != this.stack[n]) {
                            bl2 = true;
                        }
                        this.stack[n] = type;
                    }
                }
                ++n;
            }
            n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    if (exactState.locals[n] == null) {
                        this.locals[n] = null;
                        bl2 = true;
                    } else {
                        type = this.locals[n].findCommonSuperclass(exactState.locals[n]);
                        if (type != this.locals[n]) {
                            bl2 = true;
                        }
                        this.locals[n] = type;
                    }
                }
                ++n;
            }
            return bl2;
        }

        public boolean mergeJSR(ExactState exactState, ExactJSRState exactJSRState) {
            Type type;
            boolean bl = false;
            if (this.stackDepth == exactJSRState.stackDepth) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            int n = 0;
            while (n < this.stackDepth) {
                if (this.stack[n] != null) {
                    if (exactJSRState.stack[n] == null) {
                        this.stack[n] = null;
                        bl2 = true;
                    } else {
                        type = this.stack[n].findCommonSuperclass(exactJSRState.stack[n]);
                        if (type != this.stack[n]) {
                            bl2 = true;
                        }
                        this.stack[n] = type;
                    }
                }
                ++n;
            }
            n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    type = exactJSRState.mayChangeLocals[n] ? exactJSRState.locals[n] : exactState.locals[n];
                    if (type == null) {
                        this.locals[n] = null;
                        bl2 = true;
                    } else {
                        Type type2 = this.locals[n].findCommonSuperclass(type);
                        if (type2 != this.locals[n]) {
                            bl2 = true;
                        }
                        this.locals[n] = type2;
                    }
                }
                ++n;
            }
            return bl2;
        }

        public boolean mergeWithHandler(ExactState exactState) {
            boolean bl = false;
            if (this.stackDepth == 1) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            int n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    if (exactState.locals[n] == null) {
                        this.locals[n] = null;
                        bl2 = true;
                    } else {
                        Type type = this.locals[n].findCommonSuperclass(exactState.locals[n]);
                        if (type != this.locals[n]) {
                            bl2 = true;
                        }
                        this.locals[n] = type;
                    }
                }
                ++n;
            }
            return bl2;
        }

        void push_I() {
            this.stack[this.stackDepth++] = SystemType.INT;
        }

        void push_F() {
            this.stack[this.stackDepth++] = SystemType.FLOAT;
        }

        void push_L() {
            this.stack[this.stackDepth++] = SystemType.LONG;
            this.stack[this.stackDepth++] = HalfOfNumber.INSTANCE;
        }

        void push_D() {
            this.stack[this.stackDepth++] = SystemType.DOUBLE;
            this.stack[this.stackDepth++] = HalfOfNumber.INSTANCE;
        }

        void push_R() {
            this.stack[this.stackDepth++] = DerivedRef.INSTANCE;
        }

        void push_RetAddr(int n) {
            this.stack[this.stackDepth++] = new Retaddr(n);
        }

        void pop_I() {
            --this.stackDepth;
            Assert._assert(this.stack[this.stackDepth].equals(SystemType.INT));
        }

        void pop_F() {
            --this.stackDepth;
            Assert._assert(this.stack[this.stackDepth].equals(SystemType.FLOAT));
        }

        void pop_L() {
            this.stackDepth -= 2;
            Assert._assert(this.stack[this.stackDepth].equals(SystemType.LONG));
            boolean bl = false;
            if (this.stack[this.stackDepth + 1] == HalfOfNumber.INSTANCE) {
                bl = true;
            }
            Assert._assert(bl);
        }

        void pop_D() {
            this.stackDepth -= 2;
            Assert._assert(this.stack[this.stackDepth].equals(SystemType.DOUBLE));
            boolean bl = false;
            if (this.stack[this.stackDepth + 1] == HalfOfNumber.INSTANCE) {
                bl = true;
            }
            Assert._assert(bl);
        }

        void pop_A() {
            --this.stackDepth;
            Assert._assert(this.stack[this.stackDepth].isReferenceType());
        }

        void pop_R() {
            --this.stackDepth;
            boolean bl = false;
            if (this.stack[this.stackDepth] == DerivedRef.INSTANCE) {
                bl = true;
            }
            Assert._assert(bl);
        }

        Type pop() {
            return this.stack[--this.stackDepth];
        }

        void push(Type type) {
            this.stack[this.stackDepth++] = type;
        }

        void pop(jq_Type jq_Type2) {
            if (jq_Type2.isAddressType()) {
                this.pop_R();
            } else if (jq_Type2.isReferenceType()) {
                this.pop_A();
            } else if (jq_Type2.isIntLike()) {
                this.pop_I();
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                this.pop_F();
            } else if (jq_Type2 == jq_Primitive.LONG) {
                this.pop_L();
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                this.pop_D();
            } else {
                Assert.UNREACHABLE();
            }
        }

        public int getStackDepth() {
            return this.stackDepth;
        }

        public Type getStack(int n) {
            return this.stack[n];
        }

        void setLocal_I(int n) {
            this.locals[n] = SystemType.INT;
        }

        void setLocal_F(int n) {
            this.locals[n] = SystemType.FLOAT;
        }

        void setLocal_L(int n) {
            this.locals[n] = SystemType.LONG;
            this.locals[n + 1] = HalfOfNumber.INSTANCE;
        }

        void setLocal_D(int n) {
            this.locals[n] = SystemType.DOUBLE;
            this.locals[n + 1] = HalfOfNumber.INSTANCE;
        }

        void setLocal_R(int n) {
            this.locals[n] = DerivedRef.INSTANCE;
        }

        void setLocal(int n, Type type) {
            this.locals[n] = type;
        }

        public Type getLocal(int n) {
            return this.locals[n];
        }

        public Type getLiveLocal(int n) {
            if (this.liveness[n]) {
                return this.locals[n];
            }
            return null;
        }

        void liveLocal_I(int n, int n2) {
            this.checkLastUse(n, n2);
            this.liveness[n2] = true;
        }

        void liveLocal_F(int n, int n2) {
            this.checkLastUse(n, n2);
            this.liveness[n2] = true;
        }

        void liveLocal_L(int n, int n2) {
            this.checkLastUse(n, n2);
            this.liveness[n2] = true;
            this.checkLastUse(n, n2 + 1);
            this.liveness[n2 + 1] = true;
        }

        void liveLocal_D(int n, int n2) {
            this.checkLastUse(n, n2);
            this.liveness[n2] = true;
            this.checkLastUse(n, n2 + 1);
            this.liveness[n2 + 1] = true;
        }

        void liveLocal_A(int n, int n2) {
            this.checkLastUse(n, n2);
            this.liveness[n2] = true;
        }

        void deadLocal_I(int n) {
            this.liveness[n] = false;
        }

        void deadLocal_F(int n) {
            this.liveness[n] = false;
        }

        void deadLocal_L(int n) {
            this.liveness[n] = false;
            this.liveness[n + 1] = false;
        }

        void deadLocal_D(int n) {
            this.liveness[n] = false;
            this.liveness[n + 1] = false;
        }

        void deadLocal_A(int n) {
            this.liveness[n] = false;
        }

        void checkLastUse(int n, int n2) {
            if (!this.liveness[n2]) {
                if (ALWAYS_TRACE) {
                    System.out.println(n + ": Last use of local " + n2);
                }
                this.last_uses.add(new LastUse(n, n2));
            }
        }

        public int getNumberOfLocals() {
            return this.locals.length;
        }

        public String toString_live() {
            StringBuffer stringBuffer = new StringBuffer("Live Locals: { ");
            int n = 0;
            while (n < this.locals.length) {
                if (this.getLiveLocal(n) != null) {
                    stringBuffer.append(n);
                    stringBuffer.append('=');
                    stringBuffer.append(this.getLiveLocal(n).toString());
                    if (n < this.locals.length - 1) {
                        stringBuffer.append(',');
                    }
                }
                ++n;
            }
            stringBuffer.append(" }");
            if (this.stackDepth > 0) {
                stringBuffer.append(Strings.lineSep);
                stringBuffer.append("Stack: {");
                n = 0;
                while (n < this.stackDepth) {
                    stringBuffer.append(n);
                    stringBuffer.append('=');
                    stringBuffer.append(this.stack[n] == null ? "null" : this.stack[n].toString());
                    if (n < this.stackDepth - 1) {
                        stringBuffer.append(',');
                    }
                    ++n;
                }
                stringBuffer.append(" }");
            }
            return stringBuffer.toString();
        }

        public String toString() {
            if (this.liveness != null) {
                return this.toString_live();
            }
            StringBuffer stringBuffer = new StringBuffer("Locals: { ");
            int n = 0;
            while (n < this.locals.length) {
                if (this.getLocal(n) != null) {
                    stringBuffer.append(n);
                    stringBuffer.append('=');
                    stringBuffer.append(this.getLocal(n).toString());
                    if (n < this.locals.length - 1) {
                        stringBuffer.append(',');
                    }
                }
                ++n;
            }
            stringBuffer.append(" }");
            if (this.stackDepth > 0) {
                stringBuffer.append(Strings.lineSep);
                stringBuffer.append("Stack: {");
                n = 0;
                while (n < this.stackDepth) {
                    stringBuffer.append(n);
                    stringBuffer.append('=');
                    stringBuffer.append(this.stack[n] == null ? "null" : this.stack[n].toString());
                    if (n < this.stackDepth - 1) {
                        stringBuffer.append(',');
                    }
                    ++n;
                }
                stringBuffer.append(" }");
            }
            return stringBuffer.toString();
        }

        ExactState(int n, int n2) {
            this.stack = new Type[n];
            this.locals = new Type[n2];
            this.stackDepth = 0;
        }

        static class LastUse {
            int bci;
            int i;

            LastUse(int n, int n2) {
                this.bci = n;
                this.i = n2;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FirstPassVisitor
    extends BytecodeVisitor {
        private BitString bytecode_start;
        private ExactState current_state;
        private BasicBlock current_bb;
        private ControlFlowGraph cfg;
        boolean go_again;
        boolean endsWithJSR;
        boolean endsWithRET;

        public String toString() {
            return "LR1/" + this.method.getName();
        }

        boolean isEndOfBB(BasicBlock basicBlock) {
            boolean bl = false;
            if (this.i_start > basicBlock.getEnd()) {
                bl = true;
            }
            return bl;
        }

        public BitString getBytecodeStart() {
            return this.bytecode_start;
        }

        public void traverseBB(BasicBlock basicBlock) {
            if (LiveRefAnalysis.this.start_states[basicBlock.id] == null) {
                if (this.TRACE) {
                    this.out.println("Basic block " + basicBlock + " is unreachable!");
                }
                return;
            }
            if (basicBlock.getStart() == -1) {
                return;
            }
            if (this.TRACE) {
                this.out.println("Visiting " + basicBlock);
            }
            this.current_state = LiveRefAnalysis.this.start_states[basicBlock.id].copy();
            this.current_bb = basicBlock;
            this.endsWithJSR = false;
            this.endsWithRET = false;
            this.i_end = basicBlock.getStart() - 1;
            while (true) {
                this.i_start = this.i_end + 1;
                if (this.isEndOfBB(basicBlock)) break;
                this.bytecode_start.set(this.i_start);
                try {
                    this.visitBytecode();
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("EXCEPTION OCCURRED while analyzing " + this.method + " bc " + this.i_start);
                    throw runtimeException;
                }
            }
            ((LiveRefAnalysis)LiveRefAnalysis.this).end_states[basicBlock.id] = this.current_state;
            if (this.endsWithRET) {
                int n = 0;
                while (n < basicBlock.getNumberOfSuccessors()) {
                    BasicBlock basicBlock2 = this.cfg.getBasicBlock(basicBlock.getSuccessor((int)n).id - 1);
                    if (this.TRACE) {
                        this.out.println("Merging with jsr successor " + basicBlock.getSuccessor(n) + " from jsr call at " + basicBlock2);
                    }
                    if (LiveRefAnalysis.this.start_states[basicBlock2.id] != null) {
                        if (this.mergeJSRStateWith(basicBlock2, basicBlock.getSuccessor(n))) {
                            this.go_again = true;
                        }
                    } else if (this.TRACE) {
                        this.out.println("jsr " + basicBlock2 + " is not yet reached (or is unreachable");
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < basicBlock.getNumberOfSuccessors()) {
                    if (basicBlock.getSuccessor((int)n).id != 1) {
                        if (this.TRACE) {
                            this.out.println("Merging with successor " + basicBlock.getSuccessor(n));
                        }
                        if (this.mergeStateWith(basicBlock.getSuccessor(n), this.endsWithJSR)) {
                            this.go_again = true;
                        }
                    }
                    ++n;
                }
            }
        }

        private final boolean mergeWithExceptionHandlers() {
            boolean bl = false;
            ExceptionHandlerIterator exceptionHandlerIterator = this.current_bb.getExceptionHandlers();
            while (exceptionHandlerIterator.hasNext()) {
                ExceptionHandler exceptionHandler = exceptionHandlerIterator.nextEH();
                BasicBlock basicBlock = exceptionHandler.getEntry();
                jq_Class jq_Class2 = exceptionHandler.getExceptionType();
                if (jq_Class2 == null) {
                    jq_Class2 = PrimordialClassLoader.getJavaLangThrowable();
                }
                if (this.TRACE) {
                    this.out.println("Merging with handler " + basicBlock + " type " + jq_Class2);
                }
                if (LiveRefAnalysis.this.start_states[basicBlock.id] == null) {
                    bl = true;
                    ((LiveRefAnalysis)LiveRefAnalysis.this).start_states[basicBlock.id] = this.current_state.copyHandler(jq_Class2);
                    continue;
                }
                if (!LiveRefAnalysis.this.start_states[basicBlock.id].mergeWithHandler(this.current_state)) continue;
                bl = true;
            }
            if (bl) {
                this.go_again = true;
            }
            return bl;
        }

        private final boolean mergeStateWith(BasicBlock basicBlock, boolean bl) {
            if (LiveRefAnalysis.this.start_states[basicBlock.id] == null) {
                ((LiveRefAnalysis)LiveRefAnalysis.this).start_states[basicBlock.id] = bl ? this.current_state.copyAsJSR() : this.current_state.copy();
                return true;
            }
            if (bl) {
                Assert._assert(LiveRefAnalysis.this.start_states[basicBlock.id] instanceof ExactJSRState);
                return ((ExactJSRState)LiveRefAnalysis.this.start_states[basicBlock.id]).mergeBeforeJSR(this.current_state);
            }
            return LiveRefAnalysis.this.start_states[basicBlock.id].merge(this.current_state);
        }

        private final boolean mergeJSRStateWith(BasicBlock basicBlock, BasicBlock basicBlock2) {
            Assert._assert(this.current_state instanceof ExactJSRState);
            if (LiveRefAnalysis.this.end_states[basicBlock.id] == null) {
                System.err.println(this.method + " ::: Warning! Successor of JSR block " + basicBlock + " has not yet been visited.");
                return false;
            }
            ExactJSRState exactJSRState = (ExactJSRState)this.current_state;
            if (LiveRefAnalysis.this.start_states[basicBlock2.id] == null) {
                ((LiveRefAnalysis)LiveRefAnalysis.this).start_states[basicBlock2.id] = LiveRefAnalysis.this.end_states[basicBlock.id].copyJSR(exactJSRState);
                return true;
            }
            return LiveRefAnalysis.this.start_states[basicBlock2.id].mergeJSR(LiveRefAnalysis.this.end_states[basicBlock.id], exactJSRState);
        }

        public void visitNOP() {
            super.visitNOP();
        }

        public void visitACONST(Object object) {
            super.visitACONST(object);
            this.current_state.push(NullConstant.INSTANCE);
        }

        public void visitICONST(int n) {
            super.visitICONST(n);
            this.current_state.push_I();
        }

        public void visitLCONST(long l) {
            super.visitLCONST(l);
            this.current_state.push_L();
        }

        public void visitFCONST(float f) {
            super.visitFCONST(f);
            this.current_state.push_F();
        }

        public void visitDCONST(double d) {
            super.visitDCONST(d);
            this.current_state.push_D();
        }

        public void visitILOAD(int n) {
            super.visitILOAD(n);
            this.current_state.push_I();
        }

        public void visitLLOAD(int n) {
            super.visitLLOAD(n);
            this.current_state.push_L();
        }

        public void visitFLOAD(int n) {
            super.visitFLOAD(n);
            this.current_state.push_F();
        }

        public void visitDLOAD(int n) {
            super.visitDLOAD(n);
            this.current_state.push_D();
        }

        public void visitALOAD(int n) {
            super.visitALOAD(n);
            this.current_state.push(this.current_state.getLocal(n));
        }

        public void visitISTORE(int n) {
            super.visitISTORE(n);
            this.current_state.pop_I();
            this.current_state.setLocal_I(n);
        }

        public void visitLSTORE(int n) {
            super.visitLSTORE(n);
            this.current_state.pop_L();
            this.current_state.setLocal_L(n);
        }

        public void visitFSTORE(int n) {
            super.visitFSTORE(n);
            this.current_state.pop_F();
            this.current_state.setLocal_F(n);
        }

        public void visitDSTORE(int n) {
            super.visitDSTORE(n);
            this.current_state.pop_D();
            this.current_state.setLocal_D(n);
        }

        public void visitASTORE(int n) {
            super.visitASTORE(n);
            this.current_state.setLocal(n, this.current_state.pop());
        }

        public void visitIALOAD() {
            super.visitIALOAD();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.current_state.push_I();
            this.mergeWithExceptionHandlers();
        }

        public void visitLALOAD() {
            super.visitLALOAD();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.current_state.push_L();
            this.mergeWithExceptionHandlers();
        }

        public void visitFALOAD() {
            super.visitFALOAD();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.current_state.push_F();
            this.mergeWithExceptionHandlers();
        }

        public void visitDALOAD() {
            super.visitDALOAD();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.current_state.push_D();
            this.mergeWithExceptionHandlers();
        }

        public void visitAALOAD() {
            super.visitAALOAD();
            this.current_state.pop_I();
            Type type = this.current_state.pop();
            Type type2 = type.getElementType();
            this.current_state.push(type2);
            this.mergeWithExceptionHandlers();
        }

        public void visitBALOAD() {
            super.visitBALOAD();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.current_state.push_I();
            this.mergeWithExceptionHandlers();
        }

        public void visitCALOAD() {
            super.visitCALOAD();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.current_state.push_I();
            this.mergeWithExceptionHandlers();
        }

        public void visitSALOAD() {
            super.visitSALOAD();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.current_state.push_I();
            this.mergeWithExceptionHandlers();
        }

        public void visitIASTORE() {
            super.visitIASTORE();
            this.current_state.pop_I();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitLASTORE() {
            super.visitLASTORE();
            this.current_state.pop_L();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitFASTORE() {
            super.visitFASTORE();
            this.current_state.pop_F();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitDASTORE() {
            super.visitDASTORE();
            this.current_state.pop_D();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitAASTORE() {
            super.visitAASTORE();
            Type type = this.current_state.pop();
            this.current_state.pop_I();
            Type type2 = this.current_state.pop();
            if (type instanceof DerivedRef) {
                Assert._assert(type2.getElementType() instanceof DerivedRef);
            }
            this.mergeWithExceptionHandlers();
        }

        public void visitBASTORE() {
            super.visitBASTORE();
            this.current_state.pop_I();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitCASTORE() {
            super.visitCASTORE();
            this.current_state.pop_I();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitSASTORE() {
            super.visitSASTORE();
            this.current_state.pop_I();
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitPOP() {
            super.visitPOP();
            this.current_state.pop();
        }

        public void visitPOP2() {
            super.visitPOP2();
            this.current_state.pop();
            this.current_state.pop();
        }

        public void visitDUP() {
            super.visitDUP();
            Type type = this.current_state.pop();
            this.current_state.push(type);
            this.current_state.push(type);
        }

        public void visitDUP_x1() {
            super.visitDUP_x1();
            Type type = this.current_state.pop();
            Type type2 = this.current_state.pop();
            this.current_state.push(type);
            this.current_state.push(type2);
            this.current_state.push(type);
        }

        public void visitDUP_x2() {
            super.visitDUP_x2();
            Type type = this.current_state.pop();
            Type type2 = this.current_state.pop();
            Type type3 = this.current_state.pop();
            this.current_state.push(type);
            this.current_state.push(type3);
            this.current_state.push(type2);
            this.current_state.push(type);
        }

        public void visitDUP2() {
            super.visitDUP2();
            Type type = this.current_state.pop();
            Type type2 = this.current_state.pop();
            this.current_state.push(type2);
            this.current_state.push(type);
            this.current_state.push(type2);
            this.current_state.push(type);
        }

        public void visitDUP2_x1() {
            super.visitDUP2_x1();
            Type type = this.current_state.pop();
            Type type2 = this.current_state.pop();
            Type type3 = this.current_state.pop();
            this.current_state.push(type2);
            this.current_state.push(type);
            this.current_state.push(type3);
            this.current_state.push(type2);
            this.current_state.push(type);
        }

        public void visitDUP2_x2() {
            super.visitDUP2_x2();
            Type type = this.current_state.pop();
            Type type2 = this.current_state.pop();
            Type type3 = this.current_state.pop();
            Type type4 = this.current_state.pop();
            this.current_state.push(type2);
            this.current_state.push(type);
            this.current_state.push(type4);
            this.current_state.push(type3);
            this.current_state.push(type2);
            this.current_state.push(type);
        }

        public void visitSWAP() {
            super.visitSWAP();
            Type type = this.current_state.pop();
            Type type2 = this.current_state.pop();
            this.current_state.push(type);
            this.current_state.push(type2);
        }

        public void visitIBINOP(byte by) {
            super.visitIBINOP(by);
            this.current_state.pop_I();
        }

        public void visitLBINOP(byte by) {
            super.visitLBINOP(by);
            this.current_state.pop_L();
        }

        public void visitFBINOP(byte by) {
            super.visitFBINOP(by);
            this.current_state.pop_F();
        }

        public void visitDBINOP(byte by) {
            super.visitDBINOP(by);
            this.current_state.pop_D();
        }

        public void visitIUNOP(byte by) {
            super.visitIUNOP(by);
        }

        public void visitLUNOP(byte by) {
            super.visitLUNOP(by);
        }

        public void visitFUNOP(byte by) {
            super.visitFUNOP(by);
        }

        public void visitDUNOP(byte by) {
            super.visitDUNOP(by);
        }

        public void visitISHIFT(byte by) {
            super.visitISHIFT(by);
            this.current_state.pop_I();
        }

        public void visitLSHIFT(byte by) {
            super.visitLSHIFT(by);
            this.current_state.pop_I();
        }

        public void visitIINC(int n, int n2) {
            super.visitIINC(n, n2);
        }

        public void visitI2L() {
            super.visitI2L();
            this.current_state.pop_I();
            this.current_state.push_L();
        }

        public void visitI2F() {
            super.visitI2F();
            this.current_state.pop_I();
            this.current_state.push_F();
        }

        public void visitI2D() {
            super.visitI2D();
            this.current_state.pop_I();
            this.current_state.push_D();
        }

        public void visitL2I() {
            super.visitL2I();
            this.current_state.pop_L();
            this.current_state.push_I();
        }

        public void visitL2F() {
            super.visitL2F();
            this.current_state.pop_L();
            this.current_state.push_F();
        }

        public void visitL2D() {
            super.visitL2D();
            this.current_state.pop_L();
            this.current_state.push_D();
        }

        public void visitF2I() {
            super.visitF2I();
            this.current_state.pop_F();
            this.current_state.push_I();
        }

        public void visitF2L() {
            super.visitF2L();
            this.current_state.pop_F();
            this.current_state.push_L();
        }

        public void visitF2D() {
            super.visitF2D();
            this.current_state.pop_F();
            this.current_state.push_D();
        }

        public void visitD2I() {
            super.visitD2I();
            this.current_state.pop_D();
            this.current_state.push_I();
        }

        public void visitD2L() {
            super.visitD2L();
            this.current_state.pop_D();
            this.current_state.push_L();
        }

        public void visitD2F() {
            super.visitD2F();
            this.current_state.pop_D();
            this.current_state.push_F();
        }

        public void visitI2B() {
            super.visitI2B();
        }

        public void visitI2C() {
            super.visitI2C();
        }

        public void visitI2S() {
            super.visitI2S();
        }

        public void visitLCMP2() {
            super.visitLCMP2();
            this.current_state.pop_L();
            this.current_state.pop_L();
            this.current_state.push_I();
        }

        public void visitFCMP2(byte by) {
            super.visitFCMP2(by);
            this.current_state.pop_F();
            this.current_state.pop_F();
            this.current_state.push_I();
        }

        public void visitDCMP2(byte by) {
            super.visitDCMP2(by);
            this.current_state.pop_D();
            this.current_state.pop_D();
            this.current_state.push_I();
        }

        public void visitIF(byte by, int n) {
            super.visitIF(by, n);
            this.current_state.pop_I();
        }

        public void visitIFREF(byte by, int n) {
            super.visitIFREF(by, n);
            this.current_state.pop_A();
        }

        public void visitIFCMP(byte by, int n) {
            super.visitIFCMP(by, n);
            this.current_state.pop_I();
            this.current_state.pop_I();
        }

        public void visitIFREFCMP(byte by, int n) {
            super.visitIFREFCMP(by, n);
            this.current_state.pop_A();
            this.current_state.pop_A();
        }

        public void visitGOTO(int n) {
            super.visitGOTO(n);
        }

        public void visitJSR(int n) {
            super.visitJSR(n);
            this.endsWithJSR = true;
            this.current_state.push_RetAddr(n);
        }

        public void visitRET(int n) {
            super.visitRET(n);
            Retaddr retaddr = (Retaddr)this.current_state.getLocal(n);
            this.endsWithRET = true;
            BasicBlock basicBlock = this.cfg.getBasicBlockByBytecodeIndex(retaddr.location);
            if (this.current_bb.getNumberOfSuccessors() == 0) {
                if (this.TRACE) {
                    this.out.println("Adding jsr subroutine edges to " + this.current_bb);
                }
                this.current_bb.setSubroutineRet(this.cfg, basicBlock);
                if (this.TRACE) {
                    this.out.println("Number of jsr subroutine edges: " + this.current_bb.getNumberOfSuccessors());
                    int n2 = 0;
                    while (n2 < this.current_bb.getNumberOfSuccessors()) {
                        this.out.println("Successor " + n2 + ": " + this.current_bb.getSuccessor(n2));
                        ++n2;
                    }
                }
            }
            this.cfg.addJSRInfo(basicBlock, this.current_bb, ((ExactJSRState)this.current_state).mayChangeLocals);
        }

        public void visitTABLESWITCH(int n, int n2, int n3, int[] nArray) {
            super.visitTABLESWITCH(n, n2, n3, nArray);
            this.current_state.pop_I();
        }

        public void visitLOOKUPSWITCH(int n, int[] nArray, int[] nArray2) {
            super.visitLOOKUPSWITCH(n, nArray, nArray2);
            this.current_state.pop_I();
        }

        public void visitIRETURN() {
            super.visitIRETURN();
        }

        public void visitLRETURN() {
            super.visitLRETURN();
        }

        public void visitFRETURN() {
            super.visitFRETURN();
        }

        public void visitDRETURN() {
            super.visitDRETURN();
        }

        public void visitARETURN() {
            super.visitARETURN();
        }

        public void visitVRETURN() {
            super.visitVRETURN();
        }

        public void visitIGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitIGETSTATIC(jq_StaticField2);
            this.current_state.push_I();
        }

        public void visitLGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitLGETSTATIC(jq_StaticField2);
            this.current_state.push_L();
        }

        public void visitFGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitFGETSTATIC(jq_StaticField2);
            this.current_state.push_F();
        }

        public void visitDGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitDGETSTATIC(jq_StaticField2);
            this.current_state.push_D();
        }

        public void visitAGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitAGETSTATIC(jq_StaticField2);
            Type type = jq_StaticField2.getType().isAddressType() ? DerivedRef.INSTANCE : new SystemType(jq_StaticField2.getType());
            this.current_state.push(type);
        }

        public void visitZGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitZGETSTATIC(jq_StaticField2);
            this.current_state.push_I();
        }

        public void visitBGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitBGETSTATIC(jq_StaticField2);
            this.current_state.push_I();
        }

        public void visitCGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitCGETSTATIC(jq_StaticField2);
            this.current_state.push_I();
        }

        public void visitSGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitSGETSTATIC(jq_StaticField2);
            this.current_state.push_I();
        }

        public void visitIPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitIPUTSTATIC(jq_StaticField2);
            this.current_state.pop_I();
        }

        public void visitLPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitLPUTSTATIC(jq_StaticField2);
            this.current_state.pop_L();
        }

        public void visitFPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitFPUTSTATIC(jq_StaticField2);
            this.current_state.pop_F();
        }

        public void visitDPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitDPUTSTATIC(jq_StaticField2);
            this.current_state.pop_D();
        }

        public void visitAPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitAPUTSTATIC(jq_StaticField2);
            if (jq_StaticField2.getType().isAddressType()) {
                this.current_state.pop_R();
            } else {
                this.current_state.pop_A();
            }
        }

        public void visitZPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitZPUTSTATIC(jq_StaticField2);
            this.current_state.pop_I();
        }

        public void visitBPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitBPUTSTATIC(jq_StaticField2);
            this.current_state.pop_I();
        }

        public void visitCPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitCPUTSTATIC(jq_StaticField2);
            this.current_state.pop_I();
        }

        public void visitSPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitSPUTSTATIC(jq_StaticField2);
            this.current_state.pop_I();
        }

        public void visitIGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitIGETFIELD(jq_InstanceField2);
            this.current_state.pop_A();
            this.current_state.push_I();
            this.mergeWithExceptionHandlers();
        }

        public void visitLGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitLGETFIELD(jq_InstanceField2);
            this.current_state.pop_A();
            this.current_state.push_L();
            this.mergeWithExceptionHandlers();
        }

        public void visitFGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitFGETFIELD(jq_InstanceField2);
            this.current_state.pop_A();
            this.current_state.push_F();
            this.mergeWithExceptionHandlers();
        }

        public void visitDGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitDGETFIELD(jq_InstanceField2);
            this.current_state.pop_A();
            this.current_state.push_D();
            this.mergeWithExceptionHandlers();
        }

        public void visitAGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitAGETFIELD(jq_InstanceField2);
            this.current_state.pop_A();
            Type type = jq_InstanceField2.getType().isAddressType() ? DerivedRef.INSTANCE : new SystemType(jq_InstanceField2.getType());
            this.current_state.push(type);
            this.mergeWithExceptionHandlers();
        }

        public void visitBGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitBGETFIELD(jq_InstanceField2);
            this.current_state.pop_A();
            this.current_state.push_I();
            this.mergeWithExceptionHandlers();
        }

        public void visitCGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitCGETFIELD(jq_InstanceField2);
            this.current_state.pop_A();
            this.current_state.push_I();
            this.mergeWithExceptionHandlers();
        }

        public void visitSGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitSGETFIELD(jq_InstanceField2);
            this.current_state.pop_A();
            this.current_state.push_I();
            this.mergeWithExceptionHandlers();
        }

        public void visitZGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitZGETFIELD(jq_InstanceField2);
            this.current_state.pop_A();
            this.current_state.push_I();
            this.mergeWithExceptionHandlers();
        }

        public void visitIPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitIPUTFIELD(jq_InstanceField2);
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitLPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitLPUTFIELD(jq_InstanceField2);
            this.current_state.pop_L();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitFPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitFPUTFIELD(jq_InstanceField2);
            this.current_state.pop_F();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitDPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitDPUTFIELD(jq_InstanceField2);
            this.current_state.pop_D();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitAPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitAPUTFIELD(jq_InstanceField2);
            if (jq_InstanceField2.getType().isAddressType()) {
                this.current_state.pop_R();
            } else {
                this.current_state.pop_A();
            }
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitBPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitBPUTFIELD(jq_InstanceField2);
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitCPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitCPUTFIELD(jq_InstanceField2);
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitSPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitSPUTFIELD(jq_InstanceField2);
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitZPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitZPUTFIELD(jq_InstanceField2);
            this.current_state.pop_I();
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        private final void INVOKEhelper(jq_Method jq_Method2) {
            jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
            int n = jq_TypeArray.length - 1;
            while (n >= 0) {
                this.current_state.pop(jq_TypeArray[n]);
                --n;
            }
            this.mergeWithExceptionHandlers();
        }

        public void visitIINVOKE(byte by, jq_Method jq_Method2) {
            super.visitIINVOKE(by, jq_Method2);
            this.INVOKEhelper(jq_Method2);
            this.current_state.push_I();
        }

        public void visitLINVOKE(byte by, jq_Method jq_Method2) {
            super.visitLINVOKE(by, jq_Method2);
            this.INVOKEhelper(jq_Method2);
            this.current_state.push_L();
        }

        public void visitFINVOKE(byte by, jq_Method jq_Method2) {
            super.visitFINVOKE(by, jq_Method2);
            this.INVOKEhelper(jq_Method2);
            this.current_state.push_F();
        }

        public void visitDINVOKE(byte by, jq_Method jq_Method2) {
            super.visitDINVOKE(by, jq_Method2);
            this.INVOKEhelper(jq_Method2);
            this.current_state.push_D();
        }

        public void visitAINVOKE(byte by, jq_Method jq_Method2) {
            super.visitAINVOKE(by, jq_Method2);
            this.INVOKEhelper(jq_Method2);
            Type type = jq_Method2.getReturnType().isAddressType() ? DerivedRef.INSTANCE : new SystemType(jq_Method2.getReturnType());
            this.current_state.push(type);
        }

        public void visitVINVOKE(byte by, jq_Method jq_Method2) {
            super.visitVINVOKE(by, jq_Method2);
            this.INVOKEhelper(jq_Method2);
        }

        public void visitNEW(jq_Type jq_Type2) {
            super.visitNEW(jq_Type2);
            this.current_state.push(new SystemType(jq_Type2));
            this.mergeWithExceptionHandlers();
        }

        public void visitNEWARRAY(jq_Array jq_Array2) {
            super.visitNEWARRAY(jq_Array2);
            this.current_state.pop_I();
            this.current_state.push(new SystemType(jq_Array2));
            this.mergeWithExceptionHandlers();
        }

        public void visitCHECKCAST(jq_Type jq_Type2) {
            super.visitCHECKCAST(jq_Type2);
            this.current_state.pop_A();
            this.current_state.push(new SystemType(jq_Type2));
            this.mergeWithExceptionHandlers();
        }

        public void visitINSTANCEOF(jq_Type jq_Type2) {
            super.visitINSTANCEOF(jq_Type2);
            this.current_state.pop_A();
            this.current_state.push_I();
        }

        public void visitARRAYLENGTH() {
            super.visitARRAYLENGTH();
            this.current_state.pop_A();
            this.current_state.push_I();
            this.mergeWithExceptionHandlers();
        }

        public void visitATHROW() {
            super.visitATHROW();
            this.mergeWithExceptionHandlers();
        }

        public void visitMONITOR(byte by) {
            super.visitMONITOR(by);
            this.current_state.pop_A();
            this.mergeWithExceptionHandlers();
        }

        public void visitMULTINEWARRAY(jq_Type jq_Type2, char n) {
            super.visitMULTINEWARRAY(jq_Type2, (char)n);
            int n2 = 0;
            while (n2 < n) {
                this.current_state.pop_I();
                ++n2;
            }
            this.current_state.push(new SystemType(jq_Type2));
            this.mergeWithExceptionHandlers();
        }

        private final /* synthetic */ void this() {
            this.go_again = false;
            this.endsWithJSR = false;
            this.endsWithRET = false;
        }

        FirstPassVisitor(jq_Method jq_Method2, ControlFlowGraph controlFlowGraph) {
            super(jq_Method2);
            this.this();
            this.bytecode_start = new BitString(this.bcs.length);
            this.current_state = ExactState.allocateEmptyState(jq_Method2);
            this.cfg = controlFlowGraph;
            this.TRACE = ALWAYS_TRACE;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SecondPassVisitor
    extends BytecodeVisitor {
        private BitString bytecode_start;
        private BasicBlock current_bb;
        private ExactState current_state;
        boolean go_again;

        public String toString() {
            return "LR2/" + this.method.getName();
        }

        public void traverseBB(BasicBlock basicBlock) {
            if (LiveRefAnalysis.this.end_states[basicBlock.id] == null || LiveRefAnalysis.this.start_states[basicBlock.id] == null) {
                if (this.TRACE) {
                    this.out.println("Basic block " + basicBlock + " is unreachable!");
                }
                return;
            }
            if (basicBlock.getStart() == -1) {
                return;
            }
            if (this.TRACE) {
                this.out.println("Visiting " + basicBlock);
            }
            this.current_state = LiveRefAnalysis.this.end_states[basicBlock.id].copy();
            this.current_state.allocateLiveness();
            this.current_state.initializeLastUses();
            this.current_bb = basicBlock;
            this.i_end = basicBlock.getEnd();
            BitString.BackwardBitStringIterator backwardBitStringIterator = this.bytecode_start.backwardsIterator(this.i_end);
            while (((UnmodifiableIterator)backwardBitStringIterator).hasNext()) {
                this.i_start = ((BitString.BitStringIterator)backwardBitStringIterator).nextIndex();
                this.i_end = this.i_start - 1;
                this.visitBytecode();
                if (this.i_start <= basicBlock.getStart()) break;
            }
            if (this.current_state.compareLiveness(LiveRefAnalysis.this.start_states[basicBlock.id])) {
                this.go_again = true;
            }
            ((LiveRefAnalysis)LiveRefAnalysis.this).start_states[basicBlock.id] = this.current_state;
            int n = 0;
            while (n < basicBlock.getNumberOfPredecessors()) {
                this.mergeStateWith(basicBlock.getPredecessor(n));
                ++n;
            }
        }

        private final boolean mergeStateWith(BasicBlock basicBlock) {
            if (LiveRefAnalysis.this.end_states[basicBlock.id] == null) {
                ((LiveRefAnalysis)LiveRefAnalysis.this).end_states[basicBlock.id] = this.current_state.copy();
                return true;
            }
            return LiveRefAnalysis.this.end_states[basicBlock.id].mergeLiveness(this.current_state);
        }

        public void visitPEI() {
            ExceptionHandlerIterator exceptionHandlerIterator = this.current_bb.getExceptionHandlers();
            while (exceptionHandlerIterator.hasNext()) {
                ExceptionHandler exceptionHandler = exceptionHandlerIterator.nextEH();
                BasicBlock basicBlock = exceptionHandler.getEntry();
                if (LiveRefAnalysis.this.start_states[basicBlock.id] == null) {
                    if (!this.TRACE) continue;
                    this.out.println("No live var info for handler " + basicBlock + " yet");
                    continue;
                }
                if (this.TRACE) {
                    this.out.println("Merging current state " + this.current_state + " with live var info from handler " + basicBlock + ": " + LiveRefAnalysis.this.start_states[basicBlock.id]);
                }
                if (!this.current_state.mergeLiveness(LiveRefAnalysis.this.start_states[basicBlock.id]) || !this.TRACE) continue;
                this.out.println("Change in current state: " + this.current_state);
            }
        }

        public void visitILOAD(int n) {
            super.visitILOAD(n);
            this.current_state.liveLocal_I(this.i_start, n);
        }

        public void visitLLOAD(int n) {
            super.visitLLOAD(n);
            this.current_state.liveLocal_L(this.i_start, n);
        }

        public void visitFLOAD(int n) {
            super.visitFLOAD(n);
            this.current_state.liveLocal_F(this.i_start, n);
        }

        public void visitDLOAD(int n) {
            super.visitDLOAD(n);
            this.current_state.liveLocal_D(this.i_start, n);
        }

        public void visitALOAD(int n) {
            super.visitALOAD(n);
            this.current_state.liveLocal_A(this.i_start, n);
        }

        public void visitISTORE(int n) {
            super.visitISTORE(n);
            this.current_state.deadLocal_I(n);
        }

        public void visitLSTORE(int n) {
            super.visitLSTORE(n);
            this.current_state.deadLocal_L(n);
        }

        public void visitFSTORE(int n) {
            super.visitFSTORE(n);
            this.current_state.deadLocal_F(n);
        }

        public void visitDSTORE(int n) {
            super.visitDSTORE(n);
            this.current_state.deadLocal_D(n);
        }

        public void visitASTORE(int n) {
            super.visitASTORE(n);
            this.current_state.deadLocal_A(n);
        }

        private final /* synthetic */ void this() {
            this.go_again = false;
        }

        SecondPassVisitor(jq_Method jq_Method2, BitString bitString) {
            super(jq_Method2);
            this.this();
            this.bytecode_start = bitString;
            this.current_state = ExactState.allocateEmptyState(jq_Method2);
            this.TRACE = ALWAYS_TRACE;
        }
    }
}

