/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.BytecodeAnalysis;

import Allocator.DefaultHeapAllocator;
import Allocator.HeapAllocator;
import Bootstrap.BootstrapRootSet;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_ClassFileConstants;
import Clazz.jq_FieldVisitor;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Method;
import Clazz.jq_MethodVisitor;
import Clazz.jq_StaticField;
import Clazz.jq_Type;
import Clazz.jq_TypeVisitor;
import Compil3r.BytecodeAnalysis.BytecodeVisitor;
import Compil3r.Reference.x86.x86ReferenceLinker;
import Run_Time.Arrays;
import Run_Time.ExceptionDeliverer;
import Run_Time.MathSupport;
import Run_Time.Monitor;
import Run_Time.Reflection;
import Run_Time.TypeCheck;
import Run_Time.Unsafe;
import Util.Assert;
import Util.IO.Textualizable;
import Util.Strings;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Trimmer {
    public static boolean TRACE = false;
    public static final PrintStream out = System.out;
    private final BootstrapRootSet rs;
    private final List methodWorklist = new LinkedList();
    private final Set invokedVirtualMethods = new HashSet();
    private final Set invokedInterfaceMethods = new HashSet();

    public BootstrapRootSet getRootSet() {
        return this.rs;
    }

    public void addToWorklist(jq_Method jq_Method2) {
        this.methodWorklist.add(jq_Method2);
    }

    public void addInvokedInterfaceMethod(jq_InstanceMethod jq_InstanceMethod2) {
        this.invokedInterfaceMethods.add(jq_InstanceMethod2);
    }

    public void addInvokedVirtualMethod(jq_InstanceMethod jq_InstanceMethod2) {
        this.invokedVirtualMethods.add(jq_InstanceMethod2);
    }

    /*
     * Unable to fully structure code
     */
    public void go() {
        ** GOTO lbl11
        {
            var1_1 = (jq_Method)this.methodWorklist.remove(0);
            if (Trimmer.TRACE) {
                Trimmer.out.println("Pulling method " + var1_1 + " from worklist");
            }
            if (var1_1.getBytecode() != null) {
                var2_2 = new TrimmerVisitor(var1_1);
                var2_2.forwardTraversal();
            }
            do {
                if (!this.methodWorklist.isEmpty()) continue block0;
                this.rs.addNecessarySubfieldsOfVisitedObjects();
lbl11:
                // 2 sources

            } while (!this.methodWorklist.isEmpty());
        }
    }

    public void addNecessaryInterfaceMethodImplementations(jq_Class jq_Class2, jq_Class jq_Class3) {
        Textualizable textualizable;
        jq_Class3.prepare();
        Assert._assert(jq_Class3.isInterface());
        jq_InstanceMethod[] jq_InstanceMethodArray = jq_Class3.getVirtualMethods();
        int n = 0;
        while (n < jq_InstanceMethodArray.length) {
            jq_InstanceMethod jq_InstanceMethod2 = jq_InstanceMethodArray[n];
            if (this.invokedInterfaceMethods.contains(jq_InstanceMethod2) && (textualizable = jq_Class2.getVirtualMethod(jq_InstanceMethod2.getNameAndDesc())) != null) {
                this.rs.addNecessaryMethod((jq_Method)textualizable);
            }
            ++n;
        }
        jq_Class[] jq_ClassArray = jq_Class3.getInterfaces();
        int n2 = 0;
        while (n2 < jq_ClassArray.length) {
            textualizable = jq_ClassArray[n2];
            this.addNecessaryInterfaceMethodImplementations(jq_Class2, (jq_Class)textualizable);
            ++n2;
        }
    }

    public Trimmer(jq_Method jq_Method2, Set set, boolean bl) {
        this(set, bl);
        this.rs.addNecessaryMethod(jq_Method2);
    }

    public Trimmer(Set set, boolean bl) {
        this.rs = new BootstrapRootSet(bl);
        this.rs.registerNecessaryMethodListener(new AddMethodToWorklist());
        this.rs.registerNecessaryFieldListener(new AddStaticFieldContents());
        this.rs.registerNecessaryTypeListener(new UpkeepForNewlyDiscoveredClasses());
        this.rs.addDefaultRoots();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.rs.addNecessaryType((jq_Type)iterator.next());
        }
    }

    public class AddMethodToWorklist
    extends jq_MethodVisitor.EmptyVisitor {
        public void visitMethod(jq_Method jq_Method2) {
            Trimmer.this.addToWorklist(jq_Method2);
        }
    }

    public class AddStaticFieldContents
    extends jq_FieldVisitor.EmptyVisitor {
        public void visitStaticField(jq_StaticField jq_StaticField2) {
            if (jq_StaticField2.getType().isPrimitiveType()) {
                return;
            }
            if (jq_StaticField2.getType().isAddressType()) {
                return;
            }
            Object object = Reflection.getstatic_A(jq_StaticField2);
            Trimmer.this.rs.addObjectAndSubfields(object);
        }
    }

    class TrimmerVisitor
    extends BytecodeVisitor {
        public String toString() {
            return "Trim/" + Strings.left(this.method.getName().toString(), 10);
        }

        public void forwardTraversal() throws VerifyError {
            if (this.TRACE) {
                this.out.println(this + ": Starting traversal.");
            }
            super.forwardTraversal();
            if (this.TRACE) {
                this.out.println(this + ": Finished traversal.");
            }
        }

        public void visitBytecode() throws VerifyError {
            super.visitBytecode();
        }

        public void visitAASTORE() {
            super.visitAASTORE();
            this.INVOKEhelper((byte)1, TypeCheck._arrayStoreCheck);
        }

        public void visitLBINOP(byte by) {
            super.visitLBINOP(by);
            switch (by) {
                case 3: {
                    this.INVOKEhelper((byte)1, MathSupport._ldiv);
                    break;
                }
                case 4: {
                    this.INVOKEhelper((byte)1, MathSupport._lrem);
                    break;
                }
            }
        }

        public void visitF2I() {
            super.visitF2I();
            Trimmer.this.rs.addNecessaryField(MathSupport._maxint);
            Trimmer.this.rs.addNecessaryField(MathSupport._minint);
        }

        public void visitD2I() {
            super.visitD2I();
            Trimmer.this.rs.addNecessaryField(MathSupport._maxint);
            Trimmer.this.rs.addNecessaryField(MathSupport._minint);
        }

        public void visitF2L() {
            super.visitF2L();
            Trimmer.this.rs.addNecessaryField(MathSupport._maxlong);
            Trimmer.this.rs.addNecessaryField(MathSupport._minlong);
        }

        public void visitD2L() {
            super.visitD2L();
            Trimmer.this.rs.addNecessaryField(MathSupport._maxlong);
            Trimmer.this.rs.addNecessaryField(MathSupport._minlong);
        }

        private final void GETSTATIChelper(jq_StaticField jq_StaticField2) {
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            Trimmer.this.rs.addNecessaryField(jq_StaticField2);
        }

        public void visitIGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitIGETSTATIC(jq_StaticField2);
            this.GETSTATIChelper(jq_StaticField2);
        }

        public void visitLGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitLGETSTATIC(jq_StaticField2);
            this.GETSTATIChelper(jq_StaticField2);
        }

        public void visitFGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitFGETSTATIC(jq_StaticField2);
            this.GETSTATIChelper(jq_StaticField2);
        }

        public void visitDGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitDGETSTATIC(jq_StaticField2);
            this.GETSTATIChelper(jq_StaticField2);
        }

        public void visitAGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitAGETSTATIC(jq_StaticField2);
            this.GETSTATIChelper(jq_StaticField2);
        }

        public void visitZGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitZGETSTATIC(jq_StaticField2);
            this.GETSTATIChelper(jq_StaticField2);
        }

        public void visitBGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitBGETSTATIC(jq_StaticField2);
            this.GETSTATIChelper(jq_StaticField2);
        }

        public void visitCGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitCGETSTATIC(jq_StaticField2);
            this.GETSTATIChelper(jq_StaticField2);
        }

        public void visitSGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitSGETSTATIC(jq_StaticField2);
            this.GETSTATIChelper(jq_StaticField2);
        }

        private final void PUTSTATIChelper(jq_StaticField jq_StaticField2) {
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            Trimmer.this.rs.addNecessaryField(jq_StaticField2);
        }

        public void visitIPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitIPUTSTATIC(jq_StaticField2);
            this.PUTSTATIChelper(jq_StaticField2);
        }

        public void visitLPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitLPUTSTATIC(jq_StaticField2);
            this.PUTSTATIChelper(jq_StaticField2);
        }

        public void visitFPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitFPUTSTATIC(jq_StaticField2);
            this.PUTSTATIChelper(jq_StaticField2);
        }

        public void visitDPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitDPUTSTATIC(jq_StaticField2);
            this.PUTSTATIChelper(jq_StaticField2);
        }

        public void visitAPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitAPUTSTATIC(jq_StaticField2);
            this.PUTSTATIChelper(jq_StaticField2);
        }

        public void visitZPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitZPUTSTATIC(jq_StaticField2);
            this.PUTSTATIChelper(jq_StaticField2);
        }

        public void visitBPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitBPUTSTATIC(jq_StaticField2);
            this.PUTSTATIChelper(jq_StaticField2);
        }

        public void visitCPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitCPUTSTATIC(jq_StaticField2);
            this.PUTSTATIChelper(jq_StaticField2);
        }

        public void visitSPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitSPUTSTATIC(jq_StaticField2);
            this.PUTSTATIChelper(jq_StaticField2);
        }

        private final void GETFIELDhelper(jq_InstanceField jq_InstanceField2) {
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            Trimmer.this.rs.addNecessaryField(jq_InstanceField2);
        }

        public void visitIGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitIGETFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitLGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitLGETFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitFGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitFGETFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitDGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitDGETFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitAGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitAGETFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitBGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitBGETFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitCGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitCGETFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitSGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitSGETFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitZGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitZGETFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitIPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitIPUTFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitLPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitLPUTFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitFPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitFPUTFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitDPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitDPUTFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitAPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitAPUTFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitBPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitBPUTFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitCPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitCPUTFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitSPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitSPUTFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        public void visitZPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitZPUTFIELD(jq_InstanceField2);
            this.GETFIELDhelper(jq_InstanceField2);
        }

        private final void INVOKEhelper(byte by, jq_Method jq_Method2) {
            jq_Method2 = (jq_Method)this.tryResolve(jq_Method2);
            switch (by) {
                case 1: {
                    if (jq_Method2.getDeclaringClass() == Unsafe._class) {
                        return;
                    }
                    Trimmer.this.rs.addNecessaryMethod(x86ReferenceLinker._invokestatic);
                    Trimmer.this.rs.addNecessaryMethod(jq_Method2);
                    break;
                }
                case 2: {
                    Trimmer.this.rs.addNecessaryMethod(x86ReferenceLinker._invokespecial);
                    jq_Method2 = jq_Class.getInvokespecialTarget(this.method.getDeclaringClass(), (jq_InstanceMethod)jq_Method2);
                    Trimmer.this.rs.addNecessaryMethod(jq_Method2);
                    break;
                }
                case 3: {
                    Trimmer.this.rs.addNecessaryMethod(x86ReferenceLinker._invokeinterface);
                    Trimmer.this.rs.addAllInterfaceMethodImplementations((jq_InstanceMethod)jq_Method2);
                    Trimmer.this.addInvokedInterfaceMethod((jq_InstanceMethod)jq_Method2);
                    break;
                }
                case 0: {
                    Trimmer.this.rs.addAllVirtualMethodImplementations((jq_InstanceMethod)jq_Method2);
                    Trimmer.this.addInvokedVirtualMethod((jq_InstanceMethod)jq_Method2);
                }
            }
        }

        public void visitIINVOKE(byte by, jq_Method jq_Method2) {
            super.visitIINVOKE(by, jq_Method2);
            this.INVOKEhelper(by, jq_Method2);
        }

        public void visitLINVOKE(byte by, jq_Method jq_Method2) {
            super.visitLINVOKE(by, jq_Method2);
            this.INVOKEhelper(by, jq_Method2);
        }

        public void visitFINVOKE(byte by, jq_Method jq_Method2) {
            super.visitFINVOKE(by, jq_Method2);
            this.INVOKEhelper(by, jq_Method2);
        }

        public void visitDINVOKE(byte by, jq_Method jq_Method2) {
            super.visitDINVOKE(by, jq_Method2);
            this.INVOKEhelper(by, jq_Method2);
        }

        public void visitAINVOKE(byte by, jq_Method jq_Method2) {
            super.visitAINVOKE(by, jq_Method2);
            this.INVOKEhelper(by, jq_Method2);
        }

        public void visitVINVOKE(byte by, jq_Method jq_Method2) {
            super.visitVINVOKE(by, jq_Method2);
            this.INVOKEhelper(by, jq_Method2);
        }

        public void visitNEW(jq_Type jq_Type2) {
            super.visitNEW(jq_Type2);
            this.INVOKEhelper((byte)1, HeapAllocator._clsinitAndAllocateObject);
            Trimmer.this.rs.addNecessaryType(jq_Type2);
        }

        public void visitNEWARRAY(jq_Array jq_Array2) {
            super.visitNEWARRAY(jq_Array2);
            this.INVOKEhelper((byte)1, DefaultHeapAllocator._allocateArray);
            Trimmer.this.rs.addNecessaryType(jq_Array2);
        }

        public void visitATHROW() {
            super.visitATHROW();
            this.INVOKEhelper((byte)1, ExceptionDeliverer._athrow);
        }

        public void visitCHECKCAST(jq_Type jq_Type2) {
            super.visitCHECKCAST(jq_Type2);
            this.INVOKEhelper((byte)1, TypeCheck._checkcast);
        }

        public void visitINSTANCEOF(jq_Type jq_Type2) {
            super.visitINSTANCEOF(jq_Type2);
            this.INVOKEhelper((byte)1, TypeCheck._instance_of);
        }

        public void visitMONITOR(byte by) {
            super.visitMONITOR(by);
            if (by == 0) {
                this.INVOKEhelper((byte)1, Monitor._monitorenter);
            } else {
                this.INVOKEhelper((byte)1, Monitor._monitorexit);
            }
        }

        public void visitMULTINEWARRAY(jq_Type jq_Type2, char n) {
            super.visitMULTINEWARRAY(jq_Type2, (char)n);
            this.INVOKEhelper((byte)1, Arrays._multinewarray);
            Trimmer.this.rs.addNecessaryType(jq_Type2);
            int n2 = 0;
            while (n2 < n) {
                if (!jq_Type2.isArrayType()) break;
                jq_Type2 = ((jq_Array)jq_Type2).getElementType();
                Trimmer.this.rs.addNecessaryType(jq_Type2);
                ++n2;
            }
        }

        TrimmerVisitor(jq_Method jq_Method2) {
            super(jq_Method2);
        }
    }

    public class UpkeepForNewlyDiscoveredClasses
    extends jq_TypeVisitor.EmptyVisitor {
        public void visitClass(jq_Class jq_Class2) {
            jq_ClassFileConstants jq_ClassFileConstants2;
            jq_InstanceMethod[] jq_InstanceMethodArray = jq_Class2.getDeclaredInstanceMethods();
            int n = 0;
            while (n < jq_InstanceMethodArray.length) {
                jq_InstanceMethod jq_InstanceMethod2 = jq_InstanceMethodArray[n];
                if (jq_InstanceMethod2.isOverriding() && (jq_ClassFileConstants2 = jq_Class2.getSuperclass().getVirtualMethod(jq_InstanceMethod2.getNameAndDesc())) != null && Trimmer.this.invokedVirtualMethods.contains(jq_ClassFileConstants2)) {
                    if (TRACE) {
                        out.println("Method " + jq_InstanceMethod2 + " is necessary because it overrides " + jq_ClassFileConstants2);
                    }
                    Trimmer.this.rs.addNecessaryMethod(jq_InstanceMethod2);
                }
                ++n;
            }
            jq_Class[] jq_ClassArray = jq_Class2.getInterfaces();
            int n2 = 0;
            while (n2 < jq_ClassArray.length) {
                jq_ClassFileConstants2 = jq_ClassArray[n2];
                Trimmer.this.addNecessaryInterfaceMethodImplementations(jq_Class2, (jq_Class)jq_ClassFileConstants2);
                ++n2;
            }
        }
    }
}

