/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.BytecodeAnalysis;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_Field;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Compil3r.BytecodeAnalysis.BasicBlock;
import Compil3r.BytecodeAnalysis.CallTargets;
import Compil3r.BytecodeAnalysis.ControlFlowGraph;
import Compil3r.BytecodeAnalysis.ExceptionHandler;
import Compil3r.BytecodeAnalysis.ExceptionHandlerIterator;
import Compil3r.BytecodeAnalysis.StackDepthVisitor;
import Run_Time.Reflection;
import Run_Time.TypeCheck;
import UTF.Utf8;
import Util.Assert;
import Util.Collections.IdentityHashCodeWrapper;
import Util.Collections.LinearSet;
import Util.Strings;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class TypeAnalysis {
    static Map summaries = new HashMap();
    public static int nBytesAnalyzed;
    public static int nMethods;
    public static Set classesToAnalyze;
    public static boolean TRACE_MAIN;
    public static boolean TRACE_ITERATION;
    public static boolean DUMP_SUMMARY;
    public static final PrintStream out_ta;

    public static void dump() throws IOException {
        out_ta.println("Total number of methods analyzed: " + nMethods);
        out_ta.println("Total number of bytes of code analyzed: " + nBytesAnalyzed);
        if (MethodCallSequence.modeler != null) {
            MethodCallSequence.modeler.dump();
        }
    }

    public static AnalysisSummary analyze(jq_Method jq_Method2) {
        AnalysisSummary analysisSummary = (AnalysisSummary)summaries.get(jq_Method2);
        if (analysisSummary != null) {
            return analysisSummary;
        }
        return TypeAnalysis.analyze(jq_Method2, new Stack(), new LinearSet());
    }

    static AnalysisSummary analyze(jq_Method jq_Method2, Stack stack, Set set) {
        BasicBlock basicBlock;
        Object object;
        if (TRACE_MAIN) {
            out_ta.println("Analyzing " + jq_Method2 + " depth " + stack.size());
        }
        nBytesAnalyzed += jq_Method2.getBytecode().length;
        ++nMethods;
        stack.push(jq_Method2);
        ControlFlowGraph controlFlowGraph = ControlFlowGraph.computeCFG(jq_Method2);
        AnalysisState[] analysisStateArray = new AnalysisState[controlFlowGraph.getNumberOfBasicBlocks()];
        AnalysisState[] analysisStateArray2 = new AnalysisState[controlFlowGraph.getNumberOfBasicBlocks()];
        analysisStateArray[2] = AnalysisState.makeEntry(jq_Method2);
        TypeAnalysisVisitor typeAnalysisVisitor = new TypeAnalysisVisitor(jq_Method2, controlFlowGraph, stack, set, analysisStateArray, analysisStateArray2);
        int n = 0;
        while (n < controlFlowGraph.getNumberOfBasicBlocks()) {
            object = controlFlowGraph.getBasicBlock(n);
            ((BasicBlock)object).startingStackDepth = Integer.MAX_VALUE;
            ++n;
        }
        controlFlowGraph.getBasicBlock((int)2).startingStackDepth = 0;
        do {
            if (TRACE_ITERATION) {
                out_ta.println("Computing reverse post order");
            }
            object = controlFlowGraph.reversePostOrderIterator();
            basicBlock = ((ControlFlowGraph.RPOBasicBlockIterator)object).nextBB();
            boolean bl = false;
            if (basicBlock == controlFlowGraph.getEntry()) {
                bl = true;
            }
            Assert._assert(bl);
            n = 0;
            while (((ControlFlowGraph.RPOBasicBlockIterator)object).hasNext()) {
                BasicBlock basicBlock2 = ((ControlFlowGraph.RPOBasicBlockIterator)object).nextBB();
                boolean bl2 = false;
                if (basicBlock2.id != 0) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                if (basicBlock2.id == 1) continue;
                if (analysisStateArray[basicBlock2.id] == null) {
                    if (!TRACE_ITERATION) continue;
                    out_ta.println("Can't find in set for " + basicBlock2);
                    continue;
                }
                typeAnalysisVisitor.currentState = analysisStateArray[basicBlock2.id].copy_deep();
                typeAnalysisVisitor.change = false;
                if (TRACE_ITERATION) {
                    out_ta.println("Visiting basic block " + basicBlock2 + " stack depth " + basicBlock2.startingStackDepth + " state=");
                }
                if (TRACE_ITERATION) {
                    typeAnalysisVisitor.currentState.dump();
                }
                typeAnalysisVisitor.currentStackDepth = basicBlock2.startingStackDepth;
                typeAnalysisVisitor.dontMergeWithSuccessors = false;
                typeAnalysisVisitor.visitBasicBlock(basicBlock2);
                if (TRACE_ITERATION && typeAnalysisVisitor.change) {
                    out_ta.println("Change in sets detected within the basic block!");
                }
                n |= typeAnalysisVisitor.change;
                if (typeAnalysisVisitor.dontMergeWithSuccessors) {
                    if (TRACE_ITERATION) {
                        out_ta.println("skipping merge with successors of " + basicBlock2);
                    }
                } else {
                    int n2 = 0;
                    while (n2 < basicBlock2.getNumberOfSuccessors()) {
                        BasicBlock basicBlock3 = basicBlock2.getSuccessor(n2);
                        if (analysisStateArray[basicBlock3.id] != null) {
                            if (analysisStateArray[basicBlock3.id].union_deep(typeAnalysisVisitor.currentState)) {
                                if (TRACE_ITERATION) {
                                    out_ta.println("In set for " + basicBlock3 + " changed!");
                                }
                                n = 1;
                            } else if (TRACE_ITERATION) {
                                out_ta.println("In set for " + basicBlock3 + " did not change");
                            }
                            if (basicBlock3.id == 1) {
                                boolean bl3 = false;
                                if (typeAnalysisVisitor.currentStackDepth == 0) {
                                    bl3 = true;
                                }
                                Assert._assert(bl3);
                                basicBlock3.startingStackDepth = 0;
                            } else {
                                boolean bl4 = false;
                                if (basicBlock3.startingStackDepth == typeAnalysisVisitor.currentStackDepth) {
                                    bl4 = true;
                                }
                                Assert._assert(bl4, "Stack depth mismatch: " + basicBlock3 + '=' + basicBlock3.startingStackDepth + ", " + typeAnalysisVisitor + '=' + typeAnalysisVisitor.currentStackDepth);
                            }
                        } else {
                            if (TRACE_ITERATION) {
                                out_ta.println("No in set for " + basicBlock3 + " yet");
                            }
                            analysisStateArray[basicBlock3.id] = typeAnalysisVisitor.currentState.copy_deep();
                            n = 1;
                            basicBlock3.startingStackDepth = typeAnalysisVisitor.currentStackDepth;
                        }
                        ++n2;
                    }
                }
                analysisStateArray2[basicBlock2.id] = typeAnalysisVisitor.currentState;
            }
        } while (n != 0);
        if (TRACE_ITERATION) {
            out_ta.println("Finished iteration of " + jq_Method2 + ", building summary.");
        }
        object = typeAnalysisVisitor.summary;
        ((AnalysisSummary)object).finish(analysisStateArray[1], analysisStateArray[0]);
        basicBlock = stack.pop();
        boolean bl = false;
        if (basicBlock == jq_Method2) {
            bl = true;
        }
        Assert._assert(bl);
        if (TRACE_MAIN) {
            out_ta.println("Finished " + jq_Method2 + " depth " + stack.size());
        }
        if (DUMP_SUMMARY) {
            ((AnalysisSummary)object).dump(false);
        }
        return object;
    }

    static {
        TRACE_MAIN = true;
        TRACE_ITERATION = false;
        DUMP_SUMMARY = false;
        out_ta = System.out;
    }

    static class SetOfLocations {
        public static final boolean TRACE_SET_CREATION = false;
        public static final boolean TRACE_DEREFERENCES = false;
        public static final boolean TRACE_FILTER = false;
        public static final boolean TRACE_CALLHISTORY = false;
        public static final boolean TRACE_UNION = false;
        public static final boolean MERGE_DEREFS = true;
        private final LinearSet sources = new LinearSet();

        public String toString() {
            return this.sources + '@' + Integer.toHexString(this.hashCode());
        }

        static SetOfLocations makeParamSet(ParamLocation paramLocation) {
            SetOfLocations setOfLocations = new SetOfLocations();
            setOfLocations.sources.add(paramLocation);
            return setOfLocations;
        }

        static SetOfLocations makeStaticFieldSet(jq_StaticField jq_StaticField2) {
            SetOfLocations setOfLocations = new SetOfLocations();
            StaticFieldLocation staticFieldLocation = new StaticFieldLocation(jq_StaticField2, jq_StaticField2.getType());
            staticFieldLocation.methodSequences = new MethodCallSequences(true);
            setOfLocations.sources.add(staticFieldLocation);
            return setOfLocations;
        }

        static SetOfLocations makeDerefSet(DereferenceLocation dereferenceLocation) {
            SetOfLocations setOfLocations = new SetOfLocations();
            setOfLocations.sources.add(dereferenceLocation);
            return setOfLocations;
        }

        static SetOfLocations makeNewSet(jq_Type jq_Type2, jq_Method jq_Method2, int n) {
            SetOfLocations setOfLocations = new SetOfLocations();
            AllocationLocation allocationLocation = new AllocationLocation(jq_Type2, jq_Method2, n);
            allocationLocation.methodSequences = new MethodCallSequences(false);
            setOfLocations.sources.add(allocationLocation);
            return setOfLocations;
        }

        static SetOfLocations makeConstantSet(Object object, jq_Type jq_Type2, jq_Method jq_Method2, int n) {
            SetOfLocations setOfLocations = new SetOfLocations();
            LoadConstantLocation loadConstantLocation = new LoadConstantLocation(object, jq_Type2, jq_Method2, n);
            loadConstantLocation.methodSequences = new MethodCallSequences(true);
            setOfLocations.sources.add(loadConstantLocation);
            return setOfLocations;
        }

        static SetOfLocations makeJSRSubroutine(BasicBlock basicBlock) {
            SetOfLocations setOfLocations = new SetOfLocations();
            JSRSubroutine jSRSubroutine = new JSRSubroutine(basicBlock);
            setOfLocations.sources.add(jSRSubroutine);
            return setOfLocations;
        }

        static SetOfLocations makeEmptySet() {
            SetOfLocations setOfLocations = new SetOfLocations();
            return setOfLocations;
        }

        static SetOfLocations makeSeed(jq_Type jq_Type2) {
            SetOfLocations setOfLocations = new SetOfLocations();
            return setOfLocations;
        }

        SetOfLocations dereference(Dereference dereference, jq_Method jq_Method2, int n) {
            Object object = this.sources.iterator();
            while (object.hasNext()) {
                OutsideProgramLocation outsideProgramLocation;
                SetOfLocations setOfLocations;
                ProgramLocation programLocation = (ProgramLocation)object.next();
                if (!(programLocation instanceof OutsideProgramLocation) || (setOfLocations = (outsideProgramLocation = (OutsideProgramLocation)programLocation).getOutsideEdge(dereference)) == null || setOfLocations.size() == 0) continue;
                DereferenceLocation dereferenceLocation = (DereferenceLocation)setOfLocations.iterator().next();
                return this.dereference(dereferenceLocation);
            }
            object = new DereferenceLocation(dereference, jq_Method2, n, dereference.getType());
            ((DereferenceLocation)object).methodSequences = new MethodCallSequences(true);
            return this.dereference((DereferenceLocation)object);
        }

        SetOfLocations dereference(DereferenceLocation dereferenceLocation) {
            Dereference dereference = dereferenceLocation.deref;
            SetOfLocations setOfLocations = new SetOfLocations();
            boolean bl = false;
            Iterator iterator = this.sources.iterator();
            while (iterator.hasNext()) {
                ProgramLocation programLocation = (ProgramLocation)iterator.next();
                if (programLocation.isFromOutside()) {
                    bl = true;
                    ((OutsideProgramLocation)programLocation).addOutsideEdge(dereferenceLocation);
                }
                setOfLocations.addAll(programLocation.dereference(dereference));
            }
            if (bl) {
                setOfLocations.add(dereferenceLocation);
            }
            return setOfLocations;
        }

        SetOfLocations dereference(Dereference dereference, SetOfLocations setOfLocations, HashMap hashMap) {
            Object object;
            ProgramLocation programLocation;
            SetOfLocations setOfLocations2 = new SetOfLocations();
            boolean bl = false;
            Iterator iterator = this.sources.iterator();
            while (iterator.hasNext()) {
                programLocation = (ProgramLocation)iterator.next();
                if (programLocation.isFromOutside()) {
                    bl = true;
                    object = setOfLocations.iterator();
                    while (object.hasNext()) {
                        DereferenceLocation dereferenceLocation = (DereferenceLocation)object.next();
                        DereferenceLocation dereferenceLocation2 = (DereferenceLocation)dereferenceLocation.copy_shallow(hashMap);
                        ((OutsideProgramLocation)programLocation).addOutsideEdge(dereferenceLocation2);
                    }
                }
                setOfLocations2.addAll(programLocation.dereference(dereference));
            }
            if (bl) {
                iterator = setOfLocations.iterator();
                while (iterator.hasNext()) {
                    programLocation = (DereferenceLocation)iterator.next();
                    object = (DereferenceLocation)((DereferenceLocation)programLocation).copy_shallow(hashMap);
                    setOfLocations2.add((ProgramLocation)object);
                }
            }
            return setOfLocations2;
        }

        void store(Dereference dereference, SetOfLocations setOfLocations) {
            Iterator iterator = this.sources.iterator();
            while (iterator.hasNext()) {
                ProgramLocation programLocation = (ProgramLocation)iterator.next();
                programLocation.store_weak(dereference, setOfLocations);
            }
        }

        boolean addAll(SetOfLocations setOfLocations) {
            if (setOfLocations != null) {
                return this.sources.addAll((Collection)setOfLocations.sources);
            }
            return false;
        }

        void add(ProgramLocation programLocation) {
            this.sources.add(programLocation);
        }

        SetOfLocations filterByType(jq_Type jq_Type2) {
            SetOfLocations setOfLocations = new SetOfLocations();
            Iterator iterator = this.sources.iterator();
            while (iterator.hasNext()) {
                ProgramLocation programLocation = (ProgramLocation)iterator.next();
                ProgramLocation programLocation2 = programLocation.filterByType(jq_Type2);
                if (programLocation2 == null) continue;
                setOfLocations.sources.add(programLocation2);
            }
            return setOfLocations;
        }

        SetOfLocations copy_shallow() {
            SetOfLocations setOfLocations = new SetOfLocations();
            setOfLocations.sources.addAll((Collection)this.sources);
            return setOfLocations;
        }

        SetOfLocations copy_deep(HashMap hashMap) {
            SetOfLocations setOfLocations = (SetOfLocations)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (setOfLocations == null) {
                setOfLocations = new SetOfLocations();
                hashMap.put(IdentityHashCodeWrapper.create(this), setOfLocations);
                Iterator iterator = this.sources.iterator();
                while (iterator.hasNext()) {
                    ProgramLocation programLocation = (ProgramLocation)iterator.next();
                    setOfLocations.sources.add(programLocation.copy_deep(hashMap));
                }
            }
            return setOfLocations;
        }

        void mustCall(MethodCall methodCall, String string) {
            Iterator iterator = this.sources.iterator();
            while (iterator.hasNext()) {
                ProgramLocation programLocation = (ProgramLocation)iterator.next();
                programLocation.mustCall(methodCall, string);
            }
        }

        void mayCall(MethodCall methodCall, String string) {
            Iterator iterator = this.sources.iterator();
            while (iterator.hasNext()) {
                ProgramLocation programLocation = (ProgramLocation)iterator.next();
                programLocation.mayCall(methodCall, string);
            }
        }

        boolean union_deep(SetOfLocations setOfLocations, HashMap hashMap, Stack stack) {
            if (this == setOfLocations) {
                return false;
            }
            if (stack.contains(this)) {
                return false;
            }
            stack.push(this);
            boolean bl = false;
            Iterator iterator = setOfLocations.sources.iterator();
            while (iterator.hasNext()) {
                ProgramLocation programLocation = (ProgramLocation)iterator.next();
                ProgramLocation programLocation2 = (ProgramLocation)this.sources.get(programLocation);
                if (programLocation2 == null) {
                    programLocation2 = programLocation.copy_deep(hashMap);
                    this.sources.add(programLocation2);
                    bl = true;
                    continue;
                }
                if (!programLocation2.union_deep(programLocation, hashMap, stack)) continue;
                bl = true;
            }
            iterator = stack.pop();
            boolean bl2 = false;
            if (iterator == this) {
                bl2 = true;
            }
            Assert._assert(bl2);
            return bl;
        }

        jq_Type getType() {
            Iterator iterator = this.sources.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ProgramLocation programLocation = (ProgramLocation)iterator.next();
            jq_Type jq_Type2 = programLocation.getType();
            while (iterator.hasNext()) {
                programLocation = (ProgramLocation)iterator.next();
                jq_Type jq_Type3 = programLocation.getType();
                if (jq_Type2 == null) {
                    jq_Type2 = jq_Type3;
                }
                if (jq_Type3 == null) continue;
                jq_Type2 = TypeCheck.findCommonSuperclass(jq_Type2, jq_Type3, true);
            }
            return jq_Type2;
        }

        boolean containsOutsideNode() {
            Iterator iterator = this.sources.iterator();
            while (iterator.hasNext()) {
                ProgramLocation programLocation = (ProgramLocation)iterator.next();
                if (!programLocation.isFromOutside()) continue;
                return true;
            }
            return false;
        }

        Iterator iterator() {
            return this.sources.iterator();
        }

        int size() {
            return this.sources.size();
        }

        boolean contains(ProgramLocation programLocation) {
            return this.sources.contains(programLocation);
        }

        private SetOfLocations() {
        }
    }

    static abstract class Dereference {
        public abstract jq_Type getType();

        Dereference() {
        }
    }

    static class ArrayDereference
    extends Dereference {
        private final jq_Array array_type;

        public boolean equals(ArrayDereference arrayDereference) {
            boolean bl = false;
            if (this.array_type == arrayDereference.array_type) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof ArrayDereference) {
                return this.equals((ArrayDereference)object);
            }
            return false;
        }

        public int hashCode() {
            return this.array_type.hashCode();
        }

        public String toString() {
            return "[]";
        }

        public jq_Type getType() {
            return this.array_type.getElementType();
        }

        ArrayDereference(jq_Array jq_Array2) {
            this.array_type = jq_Array2;
        }
    }

    static class FieldDereference
    extends Dereference {
        private final jq_Field field;

        public boolean equals(FieldDereference fieldDereference) {
            boolean bl = false;
            if (this.field == fieldDereference.field) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof FieldDereference) {
                return this.equals((FieldDereference)object);
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public String toString() {
            return this.field.getName().toString();
        }

        public jq_Type getType() {
            return this.field.getType();
        }

        FieldDereference(jq_Field jq_Field2) {
            this.field = jq_Field2;
        }
    }

    static abstract class ProgramLocation {
        public static final boolean TRACE_UNION = false;
        public static final boolean TRACE_ADD_EDGE = false;
        public static final boolean TRACE_COPY = false;
        public static final boolean TRACE_FILTER = false;
        protected Map inside_edges;
        protected MethodCallSequences methodSequences;

        public abstract ProgramLocation copy_deep(HashMap var1);

        protected void copyInsideEdges_deep(ProgramLocation programLocation, HashMap hashMap) {
            boolean bl = false;
            if (programLocation.inside_edges == null) {
                bl = true;
            }
            Assert._assert(bl);
            if (this.inside_edges != null) {
                programLocation.inside_edges = new HashMap();
                Iterator iterator = this.inside_edges.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    SetOfLocations setOfLocations = (SetOfLocations)entry.getValue();
                    programLocation.inside_edges.put(entry.getKey(), setOfLocations.copy_deep(hashMap));
                }
            }
        }

        SetOfLocations dereference(Dereference dereference) {
            if (this.inside_edges != null) {
                return (SetOfLocations)this.inside_edges.get(dereference);
            }
            return null;
        }

        SetOfLocations store_weak(Dereference dereference, SetOfLocations setOfLocations) {
            SetOfLocations setOfLocations2 = SetOfLocations.makeEmptySet();
            setOfLocations2.addAll(setOfLocations);
            if (this.inside_edges == null) {
                this.inside_edges = new HashMap();
                this.inside_edges.put(dereference, setOfLocations2);
            } else {
                SetOfLocations setOfLocations3 = (SetOfLocations)this.inside_edges.get(dereference);
                if (setOfLocations3 != null) {
                    setOfLocations2.addAll(setOfLocations3);
                }
                this.inside_edges.put(dereference, setOfLocations2);
            }
            return setOfLocations2;
        }

        boolean union_deep(ProgramLocation programLocation, HashMap hashMap, Stack stack) {
            if (this == programLocation) {
                return false;
            }
            if (stack.contains(this)) {
                return false;
            }
            stack.push(this);
            boolean bl = false;
            if (this.methodSequences.union_deep(programLocation.methodSequences)) {
                bl = true;
            }
            if (this.unionInsideEdges_deep(programLocation, hashMap, stack)) {
                bl = true;
            }
            Object e = stack.pop();
            boolean bl2 = false;
            if (e == this) {
                bl2 = true;
            }
            Assert._assert(bl2);
            return bl;
        }

        protected boolean unionInsideEdges_deep(ProgramLocation programLocation, HashMap hashMap, Stack stack) {
            if (this == programLocation) {
                return false;
            }
            boolean bl = false;
            if (programLocation.inside_edges != null) {
                if (this.inside_edges == null) {
                    this.inside_edges = new HashMap();
                }
                Iterator iterator = programLocation.inside_edges.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    SetOfLocations setOfLocations = (SetOfLocations)this.inside_edges.get(entry.getKey());
                    SetOfLocations setOfLocations2 = (SetOfLocations)entry.getValue();
                    if (setOfLocations == null) {
                        setOfLocations = setOfLocations2.copy_deep(hashMap);
                        this.inside_edges.put(entry.getKey(), setOfLocations);
                        bl = true;
                        continue;
                    }
                    if (!setOfLocations.union_deep(setOfLocations2, hashMap, stack)) continue;
                    bl = true;
                }
            }
            return bl;
        }

        public abstract ProgramLocation filterByType(jq_Type var1);

        public abstract jq_Type getType();

        public boolean isFromOutside() {
            return false;
        }

        void mustCall(MethodCall methodCall, String string) {
            if (this.getType() == null) {
                return;
            }
            this.methodSequences.mustCall(string, this.getType(), methodCall);
        }

        void mayCall(MethodCall methodCall, String string) {
            if (this.getType() == null) {
                return;
            }
            this.methodSequences.mayCall(string, this.getType(), methodCall);
        }

        void addFirstCalledToMayCall(MethodCallSequences methodCallSequences, String string) {
            if (this.getType() == null) {
                return;
            }
            this.methodSequences.addFirstCalledToMayCall(string, this.getType(), methodCallSequences);
        }

        void updateMustCall(MethodCallSequences methodCallSequences) {
            if (this.getType() == null) {
                return;
            }
            this.methodSequences.updateMustCall(this.getType(), methodCallSequences);
        }

        public final Map getInsideEdges() {
            return this.inside_edges;
        }

        public final void initInsideEdges() {
            this.inside_edges = new HashMap();
        }

        public final MethodCallSequences getMethodCallSequences() {
            return this.methodSequences;
        }

        protected ProgramLocation() {
        }
    }

    static abstract class OutsideProgramLocation
    extends ProgramLocation {
        private Map outside_edges;

        public abstract jq_Type getOriginalType();

        public final Map getOutsideEdges() {
            return this.outside_edges;
        }

        public final void addOutsideEdge(DereferenceLocation dereferenceLocation) {
            SetOfLocations setOfLocations;
            if (this.outside_edges == null) {
                this.outside_edges = new HashMap();
            }
            if ((setOfLocations = (SetOfLocations)this.outside_edges.get(dereferenceLocation.deref)) == null) {
                this.outside_edges.put(dereferenceLocation.deref, SetOfLocations.makeDerefSet(dereferenceLocation));
            } else {
                setOfLocations.add(dereferenceLocation);
            }
        }

        public final SetOfLocations getOutsideEdge(Dereference dereference) {
            if (this.outside_edges == null) {
                return null;
            }
            return (SetOfLocations)this.outside_edges.get(dereference);
        }

        protected void copyOutsideEdges_deep(OutsideProgramLocation outsideProgramLocation, HashMap hashMap) {
            boolean bl = false;
            if (outsideProgramLocation.outside_edges == null) {
                bl = true;
            }
            Assert._assert(bl);
            if (this.outside_edges != null) {
                outsideProgramLocation.outside_edges = new HashMap();
                Iterator iterator = this.outside_edges.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    SetOfLocations setOfLocations = (SetOfLocations)entry.getValue();
                    outsideProgramLocation.outside_edges.put(entry.getKey(), setOfLocations.copy_deep(hashMap));
                }
            }
        }

        protected final boolean unionOutsideEdges_deep(OutsideProgramLocation outsideProgramLocation, HashMap hashMap, Stack stack) {
            if (this == outsideProgramLocation) {
                return false;
            }
            boolean bl = false;
            if (outsideProgramLocation.outside_edges != null) {
                if (this.outside_edges == null) {
                    this.outside_edges = new HashMap();
                }
                Iterator iterator = outsideProgramLocation.outside_edges.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    SetOfLocations setOfLocations = (SetOfLocations)this.outside_edges.get(entry.getKey());
                    SetOfLocations setOfLocations2 = (SetOfLocations)entry.getValue();
                    if (setOfLocations == null) {
                        setOfLocations = setOfLocations2.copy_deep(hashMap);
                        Iterator iterator2 = setOfLocations.iterator();
                        while (iterator2.hasNext()) {
                            ((ProgramLocation)iterator2.next()).methodSequences.setExposed();
                        }
                        this.outside_edges.put(entry.getKey(), setOfLocations);
                        bl = true;
                        continue;
                    }
                    if (!setOfLocations.union_deep(setOfLocations2, hashMap, stack)) continue;
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean union_deep(ProgramLocation programLocation, HashMap hashMap, Stack stack) {
            if (this == programLocation) {
                return false;
            }
            boolean bl = super.union_deep(programLocation, hashMap, stack);
            if (stack.contains(this)) {
                return false;
            }
            stack.push(this);
            if (this.unionOutsideEdges_deep((OutsideProgramLocation)programLocation, hashMap, stack)) {
                bl = true;
            }
            Object e = stack.pop();
            boolean bl2 = false;
            if (e == this) {
                bl2 = true;
            }
            Assert._assert(bl2);
            return bl;
        }

        public final boolean isFromOutside() {
            return true;
        }

        protected OutsideProgramLocation() {
        }
    }

    static class AllocationLocation
    extends ProgramLocation {
        jq_Type createdType;
        jq_Method method;
        int bcIndex;

        public ProgramLocation copy_deep(HashMap hashMap) {
            AllocationLocation allocationLocation = (AllocationLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (allocationLocation == null) {
                allocationLocation = new AllocationLocation(this.createdType, this.method, this.bcIndex);
                allocationLocation.methodSequences = this.methodSequences.copy_deep();
                hashMap.put(IdentityHashCodeWrapper.create(this), allocationLocation);
                this.copyInsideEdges_deep(allocationLocation, hashMap);
            }
            return allocationLocation;
        }

        public ProgramLocation copy_shallow(HashMap hashMap) {
            AllocationLocation allocationLocation = (AllocationLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (allocationLocation == null) {
                allocationLocation = new AllocationLocation(this.createdType, this.method, this.bcIndex);
                allocationLocation.methodSequences = new MethodCallSequences(true);
                hashMap.put(IdentityHashCodeWrapper.create(this), allocationLocation);
            }
            return allocationLocation;
        }

        public jq_Type getType() {
            return this.createdType;
        }

        public ProgramLocation filterByType(jq_Type jq_Type2) {
            if (jq_Type2 == null) {
                return this;
            }
            this.createdType.prepare();
            jq_Type2.prepare();
            if (TypeCheck.isAssignable(this.createdType, jq_Type2)) {
                return this;
            }
            return null;
        }

        public boolean equals(AllocationLocation allocationLocation) {
            boolean bl = false;
            if (this.method == allocationLocation.method && this.bcIndex == allocationLocation.bcIndex) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof AllocationLocation) {
                return this.equals((AllocationLocation)object);
            }
            return false;
        }

        public int hashCode() {
            return this.method.hashCode() ^ this.bcIndex;
        }

        public String toString() {
            return "ocs:" + this.createdType + '@' + this.method.getName() + ':' + this.bcIndex + ' ' + this.methodSequences;
        }

        AllocationLocation(jq_Type jq_Type2, jq_Method jq_Method2, int n) {
            this.createdType = jq_Type2;
            this.method = jq_Method2;
            this.bcIndex = n;
        }
    }

    static class LoadConstantLocation
    extends ProgramLocation {
        Object constant;
        jq_Type type;
        jq_Method method;
        int bcIndex;

        public ProgramLocation copy_deep(HashMap hashMap) {
            LoadConstantLocation loadConstantLocation = (LoadConstantLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (loadConstantLocation == null) {
                loadConstantLocation = new LoadConstantLocation(this.constant, this.type, this.method, this.bcIndex);
                loadConstantLocation.methodSequences = this.methodSequences.copy_deep();
                hashMap.put(IdentityHashCodeWrapper.create(this), loadConstantLocation);
            }
            return loadConstantLocation;
        }

        public ProgramLocation copy_shallow(HashMap hashMap) {
            LoadConstantLocation loadConstantLocation = (LoadConstantLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (loadConstantLocation == null) {
                loadConstantLocation = new LoadConstantLocation(this.constant, this.type, this.method, this.bcIndex);
                loadConstantLocation.methodSequences = new MethodCallSequences(true);
                hashMap.put(IdentityHashCodeWrapper.create(this), loadConstantLocation);
            }
            return loadConstantLocation;
        }

        public jq_Type getType() {
            return this.type;
        }

        public ProgramLocation filterByType(jq_Type jq_Type2) {
            if (this.type == null || jq_Type2 == null) {
                return this;
            }
            this.type.prepare();
            jq_Type2.prepare();
            if (TypeCheck.isAssignable(this.type, jq_Type2)) {
                return this;
            }
            return null;
        }

        public boolean equals(LoadConstantLocation loadConstantLocation) {
            boolean bl = false;
            if (this.constant == loadConstantLocation.constant) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof LoadConstantLocation) {
                return this.equals((LoadConstantLocation)object);
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            if (this.constant != null) {
                n = this.constant.hashCode();
            }
            return n;
        }

        public String toString() {
            return "lc:" + this.constant + ' ' + this.methodSequences;
        }

        LoadConstantLocation(Object object, jq_Type jq_Type2, jq_Method jq_Method2, int n) {
            this.constant = object;
            this.type = jq_Type2;
            this.method = jq_Method2;
            this.bcIndex = n;
        }
    }

    static class ParamLocation
    extends OutsideProgramLocation {
        jq_Method method;
        int paramNum;
        jq_Type declaredType;

        public jq_Type getOriginalType() {
            return this.method.getParamTypes()[this.paramNum];
        }

        public ProgramLocation copy_deep(HashMap hashMap) {
            ParamLocation paramLocation = (ParamLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (paramLocation == null) {
                paramLocation = new ParamLocation(this.method, this.paramNum, this.declaredType);
                paramLocation.methodSequences = this.methodSequences.copy_deep();
                hashMap.put(IdentityHashCodeWrapper.create(this), paramLocation);
                this.copyInsideEdges_deep(paramLocation, hashMap);
                this.copyOutsideEdges_deep(paramLocation, hashMap);
            }
            return paramLocation;
        }

        public ProgramLocation copy_shallow(HashMap hashMap) {
            ParamLocation paramLocation = (ParamLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (paramLocation == null) {
                paramLocation = new ParamLocation(this.method, this.paramNum, this.declaredType);
                paramLocation.methodSequences = new MethodCallSequences(true);
                hashMap.put(IdentityHashCodeWrapper.create(this), paramLocation);
            }
            return paramLocation;
        }

        public jq_Type getType() {
            return this.declaredType;
        }

        public ProgramLocation filterByType(jq_Type jq_Type2) {
            if (jq_Type2 == null) {
                return this;
            }
            this.declaredType.prepare();
            jq_Type2.prepare();
            if (TypeCheck.isAssignable(this.declaredType, jq_Type2)) {
                return this;
            }
            ParamLocation paramLocation = new ParamLocation(this.method, this.paramNum, jq_Type2);
            paramLocation.methodSequences = this.methodSequences.copy_deep();
            return paramLocation;
        }

        public boolean equals(ParamLocation paramLocation) {
            boolean bl = false;
            if (this.method == paramLocation.method && this.paramNum == paramLocation.paramNum) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof ParamLocation) {
                return this.equals((ParamLocation)object);
            }
            return false;
        }

        public int hashCode() {
            return this.method.hashCode() ^ this.paramNum;
        }

        public String toString() {
            return this.method.getName() + ":p" + this.paramNum + ' ' + this.methodSequences;
        }

        ParamLocation(jq_Method jq_Method2, int n, jq_Type jq_Type2) {
            this.method = jq_Method2;
            this.paramNum = n;
            this.declaredType = jq_Type2;
        }
    }

    static class StaticFieldLocation
    extends OutsideProgramLocation {
        jq_StaticField field;
        jq_Type type;

        public jq_Type getOriginalType() {
            return this.field.getType();
        }

        public ProgramLocation copy_deep(HashMap hashMap) {
            StaticFieldLocation staticFieldLocation = (StaticFieldLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (staticFieldLocation == null) {
                staticFieldLocation = new StaticFieldLocation(this.field, this.type);
                staticFieldLocation.methodSequences = this.methodSequences.copy_deep();
                hashMap.put(IdentityHashCodeWrapper.create(this), staticFieldLocation);
                this.copyInsideEdges_deep(staticFieldLocation, hashMap);
                this.copyOutsideEdges_deep(staticFieldLocation, hashMap);
            }
            return staticFieldLocation;
        }

        public ProgramLocation copy_shallow(HashMap hashMap) {
            StaticFieldLocation staticFieldLocation = (StaticFieldLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (staticFieldLocation == null) {
                staticFieldLocation = new StaticFieldLocation(this.field, this.type);
                staticFieldLocation.methodSequences = new MethodCallSequences(true);
                hashMap.put(IdentityHashCodeWrapper.create(this), staticFieldLocation);
            }
            return staticFieldLocation;
        }

        public jq_Type getType() {
            return this.type;
        }

        public ProgramLocation filterByType(jq_Type jq_Type2) {
            if (jq_Type2 == null) {
                return this;
            }
            this.type.prepare();
            jq_Type2.prepare();
            if (TypeCheck.isAssignable(this.type, jq_Type2)) {
                return this;
            }
            StaticFieldLocation staticFieldLocation = new StaticFieldLocation(this.field, jq_Type2);
            staticFieldLocation.methodSequences = this.methodSequences.copy_deep();
            return staticFieldLocation;
        }

        public boolean equals(StaticFieldLocation staticFieldLocation) {
            boolean bl = false;
            if (this.field == staticFieldLocation.field) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof StaticFieldLocation) {
                return this.equals((StaticFieldLocation)object);
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public String toString() {
            return "sf:" + this.field.getName() + ' ' + this.methodSequences;
        }

        StaticFieldLocation(jq_StaticField jq_StaticField2, jq_Type jq_Type2) {
            this.field = jq_StaticField2;
            this.type = jq_Type2;
        }
    }

    static class DereferenceLocation
    extends OutsideProgramLocation {
        Dereference deref;
        jq_Method method;
        int bcIndex;
        jq_Type type;

        public jq_Type getOriginalType() {
            return this.deref.getType();
        }

        public ProgramLocation copy_deep(HashMap hashMap) {
            DereferenceLocation dereferenceLocation = (DereferenceLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (dereferenceLocation == null) {
                dereferenceLocation = new DereferenceLocation(this.deref, this.method, this.bcIndex, this.type);
                dereferenceLocation.methodSequences = this.methodSequences.copy_deep();
                hashMap.put(IdentityHashCodeWrapper.create(this), dereferenceLocation);
                this.copyInsideEdges_deep(dereferenceLocation, hashMap);
                this.copyOutsideEdges_deep(dereferenceLocation, hashMap);
            }
            return dereferenceLocation;
        }

        public ProgramLocation copy_shallow(HashMap hashMap) {
            DereferenceLocation dereferenceLocation = (DereferenceLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (dereferenceLocation == null) {
                dereferenceLocation = new DereferenceLocation(this.deref, this.method, this.bcIndex, this.type);
                dereferenceLocation.methodSequences = new MethodCallSequences(true);
                hashMap.put(IdentityHashCodeWrapper.create(this), dereferenceLocation);
            }
            return dereferenceLocation;
        }

        public jq_Type getType() {
            return this.type;
        }

        public ProgramLocation filterByType(jq_Type jq_Type2) {
            if (jq_Type2 == null) {
                return this;
            }
            this.type.prepare();
            jq_Type2.prepare();
            if (TypeCheck.isAssignable(this.type, jq_Type2)) {
                return this;
            }
            DereferenceLocation dereferenceLocation = new DereferenceLocation(this.deref, this.method, this.bcIndex, jq_Type2);
            dereferenceLocation.methodSequences = this.methodSequences.copy_deep();
            return dereferenceLocation;
        }

        public boolean equals(DereferenceLocation dereferenceLocation) {
            boolean bl = false;
            if (this.method == dereferenceLocation.method && (this.bcIndex == -1 || dereferenceLocation.bcIndex == -1 || this.bcIndex == dereferenceLocation.bcIndex) && this.deref.equals(dereferenceLocation.deref)) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof DereferenceLocation) {
                return this.equals((DereferenceLocation)object);
            }
            return false;
        }

        public int hashCode() {
            return this.deref.hashCode() ^ this.method.hashCode();
        }

        public String toString() {
            return "dl:" + this.deref + "(type=" + this.type + ")@" + this.method.getName() + ':' + this.bcIndex + ' ' + this.methodSequences;
        }

        DereferenceLocation(Dereference dereference, jq_Method jq_Method2, int n, jq_Type jq_Type2) {
            this.deref = dereference;
            this.method = jq_Method2;
            this.bcIndex = n;
            this.type = jq_Type2;
        }
    }

    static class CaughtLocation
    extends OutsideProgramLocation {
        jq_Method method;
        int bcIndex;
        jq_Type type;
        jq_Type originalType;

        public jq_Type getOriginalType() {
            return this.originalType;
        }

        public ProgramLocation copy_deep(HashMap hashMap) {
            CaughtLocation caughtLocation = (CaughtLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (caughtLocation == null) {
                caughtLocation = new CaughtLocation(this.method, this.bcIndex, this.type);
                caughtLocation.methodSequences = this.methodSequences.copy_deep();
                hashMap.put(IdentityHashCodeWrapper.create(this), caughtLocation);
                this.copyInsideEdges_deep(caughtLocation, hashMap);
                this.copyOutsideEdges_deep(caughtLocation, hashMap);
            }
            return caughtLocation;
        }

        public ProgramLocation copy_shallow(HashMap hashMap) {
            CaughtLocation caughtLocation = (CaughtLocation)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (caughtLocation == null) {
                caughtLocation = new CaughtLocation(this.method, this.bcIndex, this.type);
                caughtLocation.methodSequences = new MethodCallSequences(true);
                hashMap.put(IdentityHashCodeWrapper.create(this), caughtLocation);
            }
            return caughtLocation;
        }

        public jq_Type getType() {
            return this.type;
        }

        public ProgramLocation filterByType(jq_Type jq_Type2) {
            if (jq_Type2 == null) {
                return this;
            }
            this.type.prepare();
            jq_Type2.prepare();
            if (TypeCheck.isAssignable(this.type, jq_Type2)) {
                return this;
            }
            CaughtLocation caughtLocation = new CaughtLocation(this.method, this.bcIndex, jq_Type2);
            caughtLocation.methodSequences = this.methodSequences.copy_deep();
            return caughtLocation;
        }

        public boolean equals(CaughtLocation caughtLocation) {
            boolean bl = false;
            if (this.method == caughtLocation.method && this.bcIndex == caughtLocation.bcIndex) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof CaughtLocation) {
                return this.equals((CaughtLocation)object);
            }
            return false;
        }

        public int hashCode() {
            return this.method.hashCode() ^ this.bcIndex;
        }

        public String toString() {
            return this.method.getName() + ':' + this.bcIndex + "(caught exception)";
        }

        CaughtLocation(jq_Method jq_Method2, int n, jq_Type jq_Type2) {
            this.method = jq_Method2;
            this.bcIndex = n;
            this.originalType = this.type = jq_Type2;
        }
    }

    static class MethodCall {
        jq_Method caller;
        int bc_i;
        jq_Method method;

        jq_Method getMethod() {
            return this.method;
        }

        public Utf8 getName() {
            return this.method.getName();
        }

        public String toString() {
            String string = this.method.getDeclaringClass().getJDKName();
            string = string.substring(string.lastIndexOf(46) + 1);
            return string + '.' + this.method.getName() + "()@" + this.caller.getName() + ':' + this.bc_i;
        }

        public boolean equals(MethodCall methodCall) {
            boolean bl = false;
            if (this.method == methodCall.method) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            return this.equals((MethodCall)object);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public MethodCall asType(jq_Class jq_Class2) {
            jq_Method jq_Method2 = (jq_Method)jq_Class2.getDeclaredMember(this.method.getNameAndDesc());
            return new MethodCall(this.caller, this.bc_i, jq_Method2);
        }

        MethodCall(jq_Method jq_Method2, int n, jq_Method jq_Method3) {
            this.caller = jq_Method2;
            this.bc_i = n;
            this.method = jq_Method3;
        }
    }

    public static class MethodCallSequences {
        private boolean exposed;
        private Map modelsByType;

        boolean isEmpty() {
            boolean bl = false;
            if (this.modelsByType.size() == 0) {
                bl = true;
            }
            return bl;
        }

        void setExposed() {
            this.exposed = true;
            Iterator iterator = this.modelsByType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                MethodCallSequence methodCallSequence = (MethodCallSequence)entry.getValue();
                methodCallSequence.setExposed();
            }
        }

        MethodCallSequences copy_deep() {
            MethodCallSequences methodCallSequences = new MethodCallSequences(this.exposed);
            Iterator iterator = this.modelsByType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                MethodCallSequence methodCallSequence = (MethodCallSequence)entry.getValue();
                methodCallSequences.modelsByType.put(entry.getKey(), methodCallSequence.copy_deep());
            }
            return methodCallSequences;
        }

        private final void addAllSubClasses(jq_Class jq_Class2, jq_Method jq_Method2, LinearSet linearSet) {
            jq_Class[] jq_ClassArray = jq_Class2.getSubClasses();
            int n = 0;
            while (n < jq_ClassArray.length) {
                jq_Class jq_Class3 = jq_ClassArray[n];
                if (jq_Class3.getDeclaredMember(jq_Method2.getNameAndDesc()) != null) {
                    linearSet.add(jq_Class3);
                }
                this.addAllSubClasses(jq_Class3, jq_Method2, linearSet);
                ++n;
            }
        }

        private final void addAllSubInterfaces(jq_Class jq_Class2, jq_Method jq_Method2, LinearSet linearSet) {
            jq_Class[] jq_ClassArray = jq_Class2.getSubInterfaces();
            int n = 0;
            while (n < jq_ClassArray.length) {
                jq_Class jq_Class3 = jq_ClassArray[n];
                if (jq_Class3.getDeclaredMember(jq_Method2.getNameAndDesc()) != null) {
                    linearSet.add(jq_Class3);
                }
                this.addAllSubInterfaces(jq_Class3, jq_Method2, linearSet);
                ++n;
            }
        }

        private final void addAllSuperInterfaces(jq_Class jq_Class2, jq_Method jq_Method2, LinearSet linearSet) {
            jq_Class2.prepare();
            jq_Class[] jq_ClassArray = jq_Class2.getInterfaces();
            int n = 0;
            while (n < jq_ClassArray.length) {
                jq_Class jq_Class3 = jq_ClassArray[n];
                if (jq_Class3.getDeclaredMember(jq_Method2.getNameAndDesc()) != null) {
                    linearSet.add(jq_Class3);
                }
                this.addAllSuperInterfaces(jq_Class3, jq_Method2, linearSet);
                ++n;
            }
        }

        Iterator getEffectiveTypes(jq_Type jq_Type2, jq_Method jq_Method2) {
            LinearSet linearSet = new LinearSet();
            if (jq_Type2.isClassType()) {
                jq_Class jq_Class2 = (jq_Class)jq_Type2;
                while (jq_Class2 != null) {
                    jq_Class2.load();
                    if (jq_Class2.getDeclaredMember(jq_Method2.getNameAndDesc()) != null) {
                        linearSet.add(jq_Class2);
                    }
                    jq_Class2 = jq_Class2.getSuperclass();
                }
                this.addAllSubClasses((jq_Class)jq_Type2, jq_Method2, linearSet);
                if (((jq_Class)jq_Type2).isInterface()) {
                    this.addAllSuperInterfaces((jq_Class)jq_Type2, jq_Method2, linearSet);
                    this.addAllSubInterfaces((jq_Class)jq_Type2, jq_Method2, linearSet);
                }
            }
            return linearSet.iterator();
        }

        void mustCall(String string, jq_Type jq_Type2, MethodCall methodCall) {
            Iterator iterator = this.getEffectiveTypes(jq_Type2, methodCall.getMethod());
            while (iterator.hasNext()) {
                jq_Class jq_Class2 = (jq_Class)iterator.next();
                MethodCallSequence methodCallSequence = (MethodCallSequence)this.modelsByType.get(jq_Class2);
                if (methodCallSequence == null) {
                    methodCallSequence = new MethodCallSequence(this.exposed);
                    this.modelsByType.put(jq_Class2, methodCallSequence);
                }
                MethodCall methodCall2 = methodCall.asType(jq_Class2);
                methodCallSequence.mustCall(string, jq_Class2, methodCall2);
            }
        }

        void mayCall(String string, jq_Type jq_Type2, MethodCall methodCall) {
            Iterator iterator = this.getEffectiveTypes(jq_Type2, methodCall.getMethod());
            while (iterator.hasNext()) {
                jq_Class jq_Class2 = (jq_Class)iterator.next();
                MethodCallSequence methodCallSequence = (MethodCallSequence)this.modelsByType.get(jq_Class2);
                if (methodCallSequence == null) {
                    methodCallSequence = new MethodCallSequence(this.exposed);
                    this.modelsByType.put(jq_Class2, methodCallSequence);
                }
                MethodCall methodCall2 = methodCall.asType(jq_Class2);
                methodCallSequence.mayCall(string, jq_Class2, methodCall2);
            }
        }

        void addFirstCalledToMayCall(String string, jq_Type jq_Type2, MethodCallSequences methodCallSequences) {
            Iterator iterator = methodCallSequences.modelsByType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                jq_Class jq_Class2 = (jq_Class)entry.getKey();
                MethodCallSequence methodCallSequence = (MethodCallSequence)entry.getValue();
                MethodCallSequence methodCallSequence2 = (MethodCallSequence)this.modelsByType.get(jq_Class2);
                if (methodCallSequence2 == null) {
                    methodCallSequence2 = new MethodCallSequence(this.exposed);
                    this.modelsByType.put(jq_Class2, methodCallSequence2);
                }
                methodCallSequence2.addToMayCall(string, jq_Class2, methodCallSequence.firstCalled);
            }
        }

        void updateMustCall(jq_Type jq_Type2, MethodCallSequences methodCallSequences) {
            Iterator iterator = methodCallSequences.modelsByType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                jq_Class jq_Class2 = (jq_Class)entry.getKey();
                MethodCallSequence methodCallSequence = (MethodCallSequence)entry.getValue();
                MethodCallSequence methodCallSequence2 = (MethodCallSequence)this.modelsByType.get(jq_Class2);
                if (methodCallSequence2 == null) {
                    methodCallSequence2 = new MethodCallSequence(this.exposed);
                    this.modelsByType.put(jq_Class2, methodCallSequence2);
                }
                methodCallSequence2.updateMustCall(methodCallSequence);
            }
        }

        boolean union_deep(MethodCallSequences methodCallSequences) {
            boolean bl = false;
            if (methodCallSequences.exposed && !this.exposed) {
                bl = true;
                this.exposed = true;
            }
            Iterator iterator = methodCallSequences.modelsByType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                MethodCallSequence methodCallSequence = (MethodCallSequence)entry.getValue();
                MethodCallSequence methodCallSequence2 = (MethodCallSequence)this.modelsByType.get(entry.getKey());
                if (methodCallSequence2 == null) {
                    methodCallSequence2 = methodCallSequence.copy_deep();
                    this.modelsByType.put(entry.getKey(), methodCallSequence2);
                    bl = true;
                    continue;
                }
                if (!methodCallSequence2.union_deep(methodCallSequence)) continue;
                bl = true;
            }
            return bl;
        }

        boolean intersect_deep(MethodCallSequences methodCallSequences) {
            boolean bl = false;
            if (!methodCallSequences.exposed && this.exposed) {
                bl = true;
                this.exposed = false;
            }
            Iterator iterator = methodCallSequences.modelsByType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                MethodCallSequence methodCallSequence = (MethodCallSequence)entry.getValue();
                MethodCallSequence methodCallSequence2 = (MethodCallSequence)this.modelsByType.get(entry.getKey());
                if (methodCallSequence2 == null) {
                    methodCallSequence2 = methodCallSequence.copy_deep();
                    this.modelsByType.put(entry.getKey(), methodCallSequence2);
                    bl = true;
                    continue;
                }
                if (!methodCallSequence2.intersect_deep(methodCallSequence)) continue;
                bl = true;
            }
            return bl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            if (this.exposed) {
                stringBuffer.append("outer+");
            }
            Iterator iterator = this.modelsByType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuffer.append(" TypeModel:" + entry.getKey());
                stringBuffer.append(" Last:" + entry.getValue());
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        public String printFirstCalled() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            Iterator iterator = this.modelsByType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuffer.append(" TypeModel:" + entry.getKey());
                stringBuffer.append(" First:" + ((MethodCallSequence)entry.getValue()).getFirstCalled());
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        MethodCallSequences(boolean bl) {
            this.exposed = bl;
            this.modelsByType = new HashMap();
        }
    }

    public static class MethodCallSequence {
        public static Modeler modeler;
        private boolean exposed;
        private Set firstCalled;
        private Set lastCalled;

        void setExposed() {
            this.exposed = true;
        }

        boolean union_deep(MethodCallSequence methodCallSequence) {
            boolean bl = false;
            if (methodCallSequence.exposed && !this.exposed) {
                bl = true;
                this.exposed = true;
            }
            if (this.firstCalled.addAll(methodCallSequence.firstCalled)) {
                bl = true;
            }
            if (this.lastCalled.addAll(methodCallSequence.lastCalled)) {
                bl = true;
            }
            return bl;
        }

        boolean intersect_deep(MethodCallSequence methodCallSequence) {
            boolean bl = false;
            if (!methodCallSequence.exposed && this.exposed) {
                bl = true;
                this.exposed = false;
            }
            if (this.firstCalled.addAll(methodCallSequence.firstCalled)) {
                bl = true;
            }
            if (this.lastCalled.addAll(methodCallSequence.lastCalled)) {
                bl = true;
            }
            return bl;
        }

        void mustCall(String string, jq_Type jq_Type2, MethodCall methodCall) {
            if (this.exposed) {
                this.firstCalled.add(methodCall);
            }
            this.exposed = false;
            if (modeler != null) {
                modeler.checkModel(string, jq_Type2, this.lastCalled, methodCall);
            }
            this.lastCalled.clear();
            this.lastCalled.add(methodCall);
        }

        void mayCall(String string, jq_Type jq_Type2, MethodCall methodCall) {
            if (this.exposed) {
                this.firstCalled.add(methodCall);
            }
            if (modeler != null) {
                modeler.checkModel(string, jq_Type2, this.lastCalled, methodCall);
            }
            this.lastCalled.add(methodCall);
        }

        void updateMustCall(MethodCallSequence methodCallSequence) {
            if (this.exposed) {
                this.firstCalled.addAll(methodCallSequence.lastCalled);
            }
            if (!methodCallSequence.exposed) {
                this.exposed = false;
                this.lastCalled.clear();
            }
            this.lastCalled.addAll(methodCallSequence.lastCalled);
        }

        void addToMayCall(String string, jq_Type jq_Type2, Set set) {
            if (this.exposed) {
                this.firstCalled.addAll(set);
            }
            if (modeler != null) {
                modeler.checkModel(string, jq_Type2, this.lastCalled, set);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("{");
            Iterator iterator = this.lastCalled.iterator();
            while (iterator.hasNext()) {
                MethodCall methodCall = (MethodCall)iterator.next();
                stringBuffer.append(methodCall.getName().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(',');
            }
            if (this.exposed) {
                stringBuffer.append("+outer");
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }

        MethodCallSequence copy_deep() {
            return new MethodCallSequence(this);
        }

        boolean isExposed() {
            return this.exposed;
        }

        Set getFirstCalled() {
            return this.firstCalled;
        }

        Set getLastCalled() {
            return this.lastCalled;
        }

        MethodCallSequence(boolean bl) {
            this.firstCalled = new LinearSet();
            this.lastCalled = new LinearSet();
            this.exposed = bl;
        }

        MethodCallSequence(MethodCallSequence methodCallSequence) {
            this.firstCalled = new LinearSet(methodCallSequence.firstCalled);
            this.lastCalled = new LinearSet(methodCallSequence.lastCalled);
            this.exposed = methodCallSequence.exposed;
        }

        public static abstract class Modeler {
            public void checkModel(String string, jq_Type jq_Type2, Set set, Set set2) {
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    this.checkModel(string, jq_Type2, set, (MethodCall)iterator.next());
                }
            }

            public abstract void checkModel(String var1, jq_Type var2, Set var3, MethodCall var4);

            public abstract void dump() throws IOException;
        }
    }

    static class AnalysisState {
        public static final boolean TRACE_VARIABLES = false;
        public static final boolean TRACE_STATIC = false;
        ParamLocation[] parameters;
        Map static_variables;
        SetOfLocations[] variables;

        static AnalysisState makeEntry(jq_Method jq_Method2) {
            AnalysisState analysisState = new AnalysisState();
            jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
            char c = jq_Method2.getMaxLocals();
            char c2 = jq_Method2.getMaxStack();
            analysisState.parameters = new ParamLocation[jq_TypeArray.length];
            analysisState.variables = new SetOfLocations[c + c2];
            int n = 0;
            int n2 = 0;
            while (n < jq_TypeArray.length) {
                jq_Type jq_Type2 = jq_TypeArray[n];
                if (jq_Type2.isReferenceType()) {
                    ParamLocation paramLocation = new ParamLocation(jq_Method2, n, jq_Type2);
                    paramLocation.methodSequences = new MethodCallSequences(true);
                    analysisState.parameters[n] = paramLocation;
                    analysisState.variables[n2] = SetOfLocations.makeParamSet(paramLocation);
                } else if (jq_Type2.getReferenceSize() == 8) {
                    ++n2;
                }
                ++n;
                ++n2;
            }
            analysisState.static_variables = new HashMap();
            return analysisState;
        }

        static AnalysisState makeExit(jq_Method jq_Method2) {
            AnalysisState analysisState = new AnalysisState();
            jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
            analysisState.parameters = new ParamLocation[jq_TypeArray.length];
            int n = 0;
            int n2 = 0;
            while (n < jq_TypeArray.length) {
                jq_Type jq_Type2 = jq_TypeArray[n];
                if (jq_Type2.isReferenceType()) {
                    ParamLocation paramLocation = new ParamLocation(jq_Method2, n, jq_Type2);
                    paramLocation.methodSequences = new MethodCallSequences(true);
                    analysisState.parameters[n] = paramLocation;
                } else if (jq_Type2.getReferenceSize() == 8) {
                    ++n2;
                }
                ++n;
                ++n2;
            }
            analysisState.static_variables = new HashMap();
            return analysisState;
        }

        public SetOfLocations get(int n) {
            return this.variables[n];
        }

        public void put(int n, SetOfLocations setOfLocations) {
            if (setOfLocations != null) {
                setOfLocations = setOfLocations.copy_shallow();
            }
            this.variables[n] = setOfLocations;
        }

        public void move(int n, int n2) {
            this.variables[n] = this.variables[n2].copy_shallow();
        }

        public SetOfLocations getStaticField(jq_StaticField jq_StaticField2) {
            return (SetOfLocations)this.static_variables.get(jq_StaticField2);
        }

        public void putStaticField(jq_StaticField jq_StaticField2, SetOfLocations setOfLocations) {
            this.static_variables.put(jq_StaticField2, setOfLocations);
        }

        public AnalysisState copy_deep() {
            return new AnalysisState(this);
        }

        public boolean union_deep(AnalysisState analysisState) {
            if (this == analysisState) {
                return false;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (this.parameters.length == analysisState.parameters.length) {
                bl2 = true;
            }
            Assert._assert(bl2);
            HashMap hashMap = new HashMap();
            Stack stack = new Stack();
            int n = 0;
            while (n < this.parameters.length) {
                if (analysisState.parameters[n] != null) {
                    boolean bl3 = false;
                    if (this.parameters[n] != null) {
                        bl3 = true;
                    }
                    Assert._assert(bl3);
                    if (this.parameters[n].union_deep(analysisState.parameters[n], hashMap, stack)) {
                        bl = true;
                    }
                }
                ++n;
            }
            if (this.variables != null) {
                n = 0;
                while (n < this.variables.length) {
                    if (analysisState.variables[n] == null) {
                        if (this.variables[n] != null) {
                            bl = true;
                            this.variables[n] = null;
                        }
                    } else if (this.variables[n] != null && this.variables[n].union_deep(analysisState.variables[n], hashMap, stack)) {
                        bl = true;
                    }
                    ++n;
                }
            }
            Iterator iterator = analysisState.static_variables.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SetOfLocations setOfLocations = (SetOfLocations)entry.getValue();
                SetOfLocations setOfLocations2 = (SetOfLocations)this.static_variables.get(entry.getKey());
                if (setOfLocations2 == null) {
                    setOfLocations2 = setOfLocations.copy_deep(hashMap);
                    jq_StaticField jq_StaticField2 = (jq_StaticField)entry.getKey();
                    StaticFieldLocation staticFieldLocation = new StaticFieldLocation(jq_StaticField2, jq_StaticField2.getType());
                    staticFieldLocation.methodSequences = new MethodCallSequences(true);
                    setOfLocations2.add(staticFieldLocation);
                    this.static_variables.put(entry.getKey(), setOfLocations2);
                    continue;
                }
                if (!setOfLocations2.union_deep(setOfLocations, hashMap, stack)) continue;
                bl = true;
            }
            return bl;
        }

        public AnalysisState merge_jsr(AnalysisState analysisState) {
            boolean bl = false;
            if (this.parameters.length == analysisState.parameters.length) {
                bl = true;
            }
            Assert._assert(bl);
            AnalysisState analysisState2 = this.copy_deep();
            HashMap hashMap = new HashMap();
            Stack stack = new Stack();
            int n = 0;
            while (n < analysisState2.parameters.length) {
                if (analysisState.parameters[n] != null) {
                    boolean bl2 = false;
                    if (analysisState2.parameters[n] != null) {
                        bl2 = true;
                    }
                    Assert._assert(bl2);
                    analysisState2.parameters[n].union_deep(analysisState.parameters[n], hashMap, stack);
                }
                ++n;
            }
            if (analysisState2.variables != null) {
                n = 0;
                while (n < analysisState2.variables.length) {
                    if (analysisState.variables[n] != null) {
                        if (analysisState2.variables[n] == null) {
                            analysisState2.variables[n] = analysisState.variables[n].copy_deep(hashMap);
                        } else {
                            analysisState2.variables[n].union_deep(analysisState.variables[n], hashMap, stack);
                        }
                    }
                    ++n;
                }
            }
            Iterator iterator = analysisState.static_variables.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SetOfLocations setOfLocations = (SetOfLocations)entry.getValue();
                SetOfLocations setOfLocations2 = (SetOfLocations)analysisState2.static_variables.get(entry.getKey());
                if (setOfLocations2 == null) {
                    setOfLocations2 = setOfLocations.copy_deep(hashMap);
                    jq_StaticField jq_StaticField2 = (jq_StaticField)entry.getKey();
                    StaticFieldLocation staticFieldLocation = new StaticFieldLocation(jq_StaticField2, jq_StaticField2.getType());
                    staticFieldLocation.methodSequences = new MethodCallSequences(true);
                    setOfLocations2.add(staticFieldLocation);
                    analysisState2.static_variables.put(entry.getKey(), setOfLocations2);
                    continue;
                }
                setOfLocations2.union_deep(setOfLocations, hashMap, stack);
            }
            return analysisState2;
        }

        public void dump() {
            Object object;
            HashSet hashSet = new HashSet();
            int n = 0;
            while (n < this.parameters.length) {
                if (this.parameters[n] != null) {
                    out_ta.print(Strings.left("P" + n + ':', 4));
                    object = this.parameters[n].toString();
                    out_ta.print((String)object);
                    AnalysisSummary.dump_recurse(out_ta, hashSet, 4 + ((String)object).length(), this.parameters[n]);
                }
                ++n;
            }
            if (this.static_variables != null) {
                Iterator iterator = this.static_variables.entrySet().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    jq_StaticField jq_StaticField2 = (jq_StaticField)object.getKey();
                    SetOfLocations setOfLocations = (SetOfLocations)object.getValue();
                    String string = jq_StaticField2.getName().toString() + ':';
                    out_ta.print(string);
                    AnalysisSummary.dump_recurse(out_ta, hashSet, string.length(), setOfLocations);
                }
            }
            out_ta.println();
            if (this.variables != null) {
                out_ta.println("Variables (" + this.variables.length + " total)");
                int n2 = 0;
                while (n2 < this.variables.length) {
                    if (this.variables[n2] != null) {
                        out_ta.println("  " + n2 + ": " + this.variables[n2]);
                    }
                    ++n2;
                }
            }
        }

        private AnalysisState() {
        }

        AnalysisState(AnalysisState analysisState) {
            this.parameters = new ParamLocation[analysisState.parameters.length];
            HashMap hashMap = new HashMap();
            int n = 0;
            while (n < this.parameters.length) {
                if (analysisState.parameters[n] != null) {
                    this.parameters[n] = (ParamLocation)analysisState.parameters[n].copy_deep(hashMap);
                }
                ++n;
            }
            if (analysisState.variables != null) {
                this.variables = new SetOfLocations[analysisState.variables.length];
                n = 0;
                while (n < this.variables.length) {
                    if (analysisState.variables[n] != null) {
                        this.variables[n] = analysisState.variables[n].copy_deep(hashMap);
                    }
                    ++n;
                }
            }
            this.static_variables = new HashMap();
            Iterator iterator = analysisState.static_variables.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SetOfLocations setOfLocations = (SetOfLocations)entry.getValue();
                this.static_variables.put(entry.getKey(), setOfLocations.copy_deep(hashMap));
            }
        }
    }

    public static class AnalysisSummary {
        public static final boolean TRIM_SUMMARIES = true;
        public static boolean TRACE_TRIM = false;
        jq_Method method;
        ParamLocation[] params;
        Map static_vars;
        ParamLocation[] params_ex;
        Map static_vars_ex;
        SetOfLocations returned;
        SetOfLocations thrown;

        void addToReturned(SetOfLocations setOfLocations) {
            HashMap hashMap = new HashMap();
            if (this.returned == null) {
                this.returned = setOfLocations.copy_deep(hashMap);
            } else {
                this.returned.union_deep(setOfLocations, hashMap, new Stack());
            }
        }

        void addToThrown(SetOfLocations setOfLocations) {
            HashMap hashMap = new HashMap();
            if (this.thrown == null) {
                this.thrown = setOfLocations.copy_deep(hashMap);
            } else {
                this.thrown.union_deep(setOfLocations, hashMap, new Stack());
            }
        }

        /*
         * Unable to fully structure code
         */
        void finish(AnalysisState var1_1, AnalysisState var2_2) {
            block38: {
                block37: {
                    if (var1_1 != null) {
                        v0 = false;
                        if (var1_1.parameters != null) {
                            v0 = true;
                        }
                        Assert._assert(v0);
                        this.params = var1_1.parameters;
                        this.static_vars = var1_1.static_variables;
                    } else {
                        this.params = null;
                        this.static_vars = null;
                    }
                    if (var2_2 != null) {
                        v1 = false;
                        if (var2_2.parameters != null) {
                            v1 = true;
                        }
                        Assert._assert(v1);
                        this.params_ex = var2_2.parameters;
                        this.static_vars_ex = var2_2.static_variables;
                    } else {
                        this.params_ex = null;
                        this.static_vars_ex = null;
                    }
                    if (AnalysisSummary.TRACE_TRIM) {
                        TypeAnalysis.out_ta.println("Summary before trimming:");
                        this.dump(false);
                    }
                    if (this.params == null) break block37;
                    if (AnalysisSummary.TRACE_TRIM) {
                        TypeAnalysis.out_ta.println("Trimming normal exit...");
                    }
                    var3_3 = new HashSet<E>();
                    var4_4 = new HashSet<OutsideProgramLocation>();
                    if (this.returned != null) {
                        var5_5 = this.returned.iterator();
                        while (var5_5.hasNext()) {
                            var3_3.add(var5_5.next());
                        }
                    }
                    var5_6 = 0;
                    while (var5_6 < this.params.length) {
                        if (this.params[var5_6] != null) {
                            AnalysisSummary.necessaryHelper(var3_3, this.params[var5_6], var4_4);
                        }
                        ++var5_6;
                    }
                    var5_7 = this.static_vars.entrySet().iterator();
                    while (var5_7.hasNext()) {
                        var6_14 = var5_7.next();
                        var7_15 = (SetOfLocations)var6_14.getValue();
                        var8_16 = var7_15.iterator();
                        if (var7_15.size() != 1) ** GOTO lbl60
                        var9_17 = (ProgramLocation)var8_16.next();
                        if (!(var9_17 instanceof StaticFieldLocation) || ((StaticFieldLocation)var9_17).field != var6_14.getKey()) {
                            var3_3.add(var9_17);
                        }
                        AnalysisSummary.necessaryHelper(var3_3, var9_17, var4_4);
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            var9_17 = (ProgramLocation)var8_16.next();
                            var3_3.add(var9_17);
                            AnalysisSummary.necessaryHelper(var3_3, var9_17, var4_4);
lbl60:
                            // 2 sources

                            ** while (var8_16.hasNext())
                        }
lbl61:
                        // 1 sources

                    }
                    if (AnalysisSummary.TRACE_TRIM) {
                        TypeAnalysis.out_ta.println("Necessary set: " + var3_3);
                    }
                    var4_4 = new HashSet<E>();
                    var5_8 = 0;
                    while (var5_8 < this.params.length) {
                        if (this.params[var5_8] != null) {
                            var4_4.add(this.params[var5_8]);
                            this.trimHelper(this.params[var5_8], var3_3, var4_4);
                        }
                        ++var5_8;
                    }
                    var5_9 = this.static_vars.entrySet().iterator();
                    while (var5_9.hasNext()) {
                        var6_14 = var5_9.next();
                        var7_15 = (SetOfLocations)var6_14.getValue();
                        var8_16 = var7_15.iterator();
                        while (var8_16.hasNext()) {
                            var9_17 = (ProgramLocation)var8_16.next();
                            if (!(var9_17 instanceof OutsideProgramLocation)) continue;
                            var10_18 = (OutsideProgramLocation)var9_17;
                            var4_4.add(var10_18);
                            if (!this.trimHelper(var10_18, var3_3, var4_4)) continue;
                            if (AnalysisSummary.TRACE_TRIM) {
                                TypeAnalysis.out_ta.println("static field node " + var10_18 + " is useless, removing it");
                            }
                            var8_16.remove();
                        }
                        if (var7_15.size() != 0) continue;
                        if (AnalysisSummary.TRACE_TRIM) {
                            TypeAnalysis.out_ta.println("all edges from static field " + var6_14.getKey() + " have been removed");
                        }
                        var5_9.remove();
                    }
                }
                if (this.params_ex == null) break block38;
                if (AnalysisSummary.TRACE_TRIM) {
                    TypeAnalysis.out_ta.println("Trimming exceptional exit...");
                }
                var3_3 = new HashSet<E>();
                var4_4 = new HashSet<E>();
                if (this.thrown != null) {
                    var5_9 = this.thrown.iterator();
                    while (var5_9.hasNext()) {
                        var3_3.add(var5_9.next());
                    }
                }
                var5_10 = 0;
                while (var5_10 < this.params_ex.length) {
                    if (this.params_ex[var5_10] != null) {
                        var4_4.add(this.params_ex[var5_10]);
                        AnalysisSummary.necessaryHelper(var3_3, this.params_ex[var5_10], var4_4);
                    }
                    ++var5_10;
                }
                var5_11 = this.static_vars_ex.entrySet().iterator();
                while (var5_11.hasNext()) {
                    var6_14 = var5_11.next();
                    var7_15 = (SetOfLocations)var6_14.getValue();
                    var8_16 = var7_15.iterator();
                    if (var7_15.size() != 1) ** GOTO lbl134
                    var9_17 = (ProgramLocation)var8_16.next();
                    if (!(var9_17 instanceof StaticFieldLocation) || ((StaticFieldLocation)var9_17).field != var6_14.getKey()) {
                        var3_3.add(var9_17);
                    }
                    AnalysisSummary.necessaryHelper(var3_3, var9_17, var4_4);
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        var9_17 = (ProgramLocation)var8_16.next();
                        var3_3.add(var9_17);
                        AnalysisSummary.necessaryHelper(var3_3, var9_17, var4_4);
lbl134:
                        // 2 sources

                        ** while (var8_16.hasNext())
                    }
lbl135:
                    // 1 sources

                }
                if (AnalysisSummary.TRACE_TRIM) {
                    TypeAnalysis.out_ta.println("Necessary set: " + var3_3);
                }
                var4_4 = new HashSet<E>();
                var5_12 = 0;
                while (var5_12 < this.params_ex.length) {
                    if (this.params_ex[var5_12] != null) {
                        var4_4.add(this.params_ex[var5_12]);
                        this.trimHelper(this.params_ex[var5_12], var3_3, var4_4);
                    }
                    ++var5_12;
                }
                var5_13 = this.static_vars_ex.entrySet().iterator();
                while (var5_13.hasNext()) {
                    var6_14 = var5_13.next();
                    var7_15 = (SetOfLocations)var6_14.getValue();
                    var8_16 = var7_15.iterator();
                    while (var8_16.hasNext()) {
                        var9_17 = (ProgramLocation)var8_16.next();
                        if (!(var9_17 instanceof OutsideProgramLocation)) continue;
                        var10_18 = (OutsideProgramLocation)var9_17;
                        var4_4.add(var10_18);
                        if (!this.trimHelper(var10_18, var3_3, var4_4)) continue;
                        if (AnalysisSummary.TRACE_TRIM) {
                            TypeAnalysis.out_ta.println("static field node " + var10_18 + " is useless, removing it");
                        }
                        var8_16.remove();
                    }
                    if (var7_15.size() != 0) continue;
                    if (AnalysisSummary.TRACE_TRIM) {
                        TypeAnalysis.out_ta.println("all edges from static field " + var6_14.getKey() + " have been removed");
                    }
                    var5_13.remove();
                }
            }
        }

        private static final boolean necessaryHelper(HashSet hashSet, ProgramLocation programLocation, HashSet hashSet2) {
            ProgramLocation programLocation2;
            Iterator iterator;
            SetOfLocations setOfLocations;
            Map.Entry entry;
            Iterator iterator2;
            Map map;
            if (hashSet2.contains(programLocation)) {
                return hashSet.contains(programLocation);
            }
            hashSet2.add(programLocation);
            if (programLocation instanceof OutsideProgramLocation && (map = ((OutsideProgramLocation)programLocation).getOutsideEdges()) != null) {
                iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = iterator2.next();
                    setOfLocations = (SetOfLocations)entry.getValue();
                    iterator = setOfLocations.iterator();
                    while (iterator.hasNext()) {
                        programLocation2 = (OutsideProgramLocation)iterator.next();
                        if (!AnalysisSummary.necessaryHelper(hashSet, programLocation2, hashSet2)) continue;
                        hashSet.add(programLocation);
                    }
                }
            }
            if ((map = programLocation.getInsideEdges()) != null) {
                iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = iterator2.next();
                    setOfLocations = (SetOfLocations)entry.getValue();
                    iterator = setOfLocations.iterator();
                    while (iterator.hasNext()) {
                        programLocation2 = (ProgramLocation)iterator.next();
                        hashSet.add(programLocation2);
                        hashSet.add(programLocation);
                        AnalysisSummary.necessaryHelper(hashSet, programLocation2, hashSet2);
                    }
                }
            }
            return hashSet.contains(programLocation);
        }

        private final boolean trimHelper(OutsideProgramLocation outsideProgramLocation, HashSet hashSet, HashSet hashSet2) {
            Object object;
            Object object2;
            Map map = outsideProgramLocation.getOutsideEdges();
            if (map != null) {
                object2 = map.entrySet().iterator();
                while (object2.hasNext()) {
                    OutsideProgramLocation outsideProgramLocation2;
                    object = (Map.Entry)object2.next();
                    SetOfLocations setOfLocations = (SetOfLocations)object.getValue();
                    MethodCallSequences methodCallSequences = new MethodCallSequences(false);
                    Object object3 = setOfLocations.iterator();
                    while (object3.hasNext()) {
                        outsideProgramLocation2 = (OutsideProgramLocation)object3.next();
                        if (hashSet2.contains(outsideProgramLocation2)) continue;
                        hashSet2.add(outsideProgramLocation2);
                        if (this.trimHelper(outsideProgramLocation2, hashSet, hashSet2)) {
                            if (TRACE_TRIM) {
                                out_ta.println("node " + outsideProgramLocation2 + " is useless, removing it");
                            }
                            object3.remove();
                            continue;
                        }
                        methodCallSequences.union_deep(outsideProgramLocation2.methodSequences);
                    }
                    if (setOfLocations.size() == 0) {
                        if (TRACE_TRIM) {
                            out_ta.println("all outside edges of " + outsideProgramLocation + " field " + object.getKey() + " have been removed");
                        }
                        object2.remove();
                        continue;
                    }
                    if (setOfLocations.size() <= 1) continue;
                    object3 = (Dereference)object.getKey();
                    outsideProgramLocation2 = new DereferenceLocation((Dereference)object3, this.method, -1, ((Dereference)object3).getType());
                    ((DereferenceLocation)outsideProgramLocation2).methodSequences = methodCallSequences;
                    object.setValue(SetOfLocations.makeDerefSet((DereferenceLocation)outsideProgramLocation2));
                    if (!TRACE_TRIM) continue;
                    out_ta.println("made summary deref " + outsideProgramLocation2);
                }
            }
            object2 = outsideProgramLocation.getInsideEdges();
            object = outsideProgramLocation.getMethodCallSequences();
            return !(map != null && map.size() != 0 || object2 != null && object2.size() != 0 || !((MethodCallSequences)object).isEmpty() || hashSet.contains(outsideProgramLocation));
        }

        boolean union_deep(AnalysisSummary analysisSummary) {
            int n;
            ParamLocation paramLocation;
            Object object;
            int n2;
            int n3;
            boolean bl = false;
            HashMap<IdentityHashCodeWrapper, ParamLocation> hashMap = new HashMap<IdentityHashCodeWrapper, ParamLocation>();
            Stack stack = new Stack();
            if (analysisSummary.params != null) {
                if (this.params == null) {
                    jq_Type[] jq_TypeArray = this.method.getParamTypes();
                    this.params = new ParamLocation[jq_TypeArray.length];
                    n3 = 0;
                    n2 = 0;
                    while (n3 < jq_TypeArray.length) {
                        object = jq_TypeArray[n3];
                        if (((jq_Type)object).isReferenceType()) {
                            paramLocation = new ParamLocation(this.method, n3, (jq_Type)object);
                            paramLocation.methodSequences = new MethodCallSequences(true);
                            this.params[n3] = paramLocation;
                        } else if (((jq_Type)object).getReferenceSize() == 8) {
                            ++n2;
                        }
                        ++n3;
                        ++n2;
                    }
                }
                n = 0;
                while (n < analysisSummary.params.length) {
                    if (analysisSummary.params[n] != null) {
                        boolean bl2 = false;
                        if (this.params[n] != null) {
                            bl2 = true;
                        }
                        Assert._assert(bl2);
                        hashMap.put(IdentityHashCodeWrapper.create(analysisSummary.params[n]), this.params[n]);
                    }
                    ++n;
                }
            }
            if (analysisSummary.params_ex != null) {
                if (this.params_ex == null) {
                    jq_Type[] jq_TypeArray = this.method.getParamTypes();
                    this.params_ex = new ParamLocation[jq_TypeArray.length];
                    n3 = 0;
                    n2 = 0;
                    while (n3 < jq_TypeArray.length) {
                        object = jq_TypeArray[n3];
                        if (((jq_Type)object).isReferenceType()) {
                            paramLocation = new ParamLocation(this.method, n3, (jq_Type)object);
                            paramLocation.methodSequences = new MethodCallSequences(true);
                            this.params_ex[n3] = paramLocation;
                        } else if (((jq_Type)object).getReferenceSize() == 8) {
                            ++n2;
                        }
                        ++n3;
                        ++n2;
                    }
                }
                n = 0;
                while (n < analysisSummary.params_ex.length) {
                    if (analysisSummary.params_ex[n] != null) {
                        boolean bl3 = false;
                        if (this.params_ex[n] != null) {
                            bl3 = true;
                        }
                        Assert._assert(bl3);
                        hashMap.put(IdentityHashCodeWrapper.create(analysisSummary.params_ex[n]), this.params_ex[n]);
                    }
                    ++n;
                }
            }
            if (analysisSummary.params != null) {
                boolean bl4 = false;
                if (this.params != null) {
                    bl4 = true;
                }
                Assert._assert(bl4);
                boolean bl5 = false;
                if (this.params.length == analysisSummary.params.length) {
                    bl5 = true;
                }
                Assert._assert(bl5);
                n = 0;
                while (n < this.params.length) {
                    if (this.params[n] == null) {
                        boolean bl6 = false;
                        if (analysisSummary.params[n] == null) {
                            bl6 = true;
                        }
                        Assert._assert(bl6);
                    } else {
                        boolean bl7 = false;
                        if (analysisSummary.params[n] != null) {
                            bl7 = true;
                        }
                        Assert._assert(bl7);
                        if (this.params[n].union_deep(analysisSummary.params[n], hashMap, stack)) {
                            bl = true;
                        }
                    }
                    ++n;
                }
            }
            if (analysisSummary.params_ex != null) {
                boolean bl8 = false;
                if (this.params_ex != null) {
                    bl8 = true;
                }
                Assert._assert(bl8);
                boolean bl9 = false;
                if (this.params_ex.length == analysisSummary.params_ex.length) {
                    bl9 = true;
                }
                Assert._assert(bl9);
                n = 0;
                while (n < this.params_ex.length) {
                    if (this.params_ex[n] == null) {
                        boolean bl10 = false;
                        if (analysisSummary.params_ex[n] == null) {
                            bl10 = true;
                        }
                        Assert._assert(bl10);
                    } else {
                        boolean bl11 = false;
                        if (analysisSummary.params_ex[n] != null) {
                            bl11 = true;
                        }
                        Assert._assert(bl11);
                        if (this.params_ex[n].union_deep(analysisSummary.params_ex[n], hashMap, stack)) {
                            bl = true;
                        }
                    }
                    ++n;
                }
            }
            if (analysisSummary.static_vars != null) {
                if (this.static_vars == null) {
                    this.static_vars = new HashMap();
                }
                Iterator iterator = analysisSummary.static_vars.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    SetOfLocations setOfLocations = (SetOfLocations)entry.getValue();
                    object = (SetOfLocations)this.static_vars.get(entry.getKey());
                    if (object == null) {
                        this.static_vars.put(entry.getKey(), setOfLocations.copy_deep(hashMap));
                        continue;
                    }
                    ((SetOfLocations)object).union_deep(setOfLocations, hashMap, stack);
                }
            }
            if (analysisSummary.static_vars_ex != null) {
                if (this.static_vars_ex == null) {
                    this.static_vars_ex = new HashMap();
                }
                Iterator iterator = analysisSummary.static_vars_ex.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    SetOfLocations setOfLocations = (SetOfLocations)entry.getValue();
                    object = (SetOfLocations)this.static_vars_ex.get(entry.getKey());
                    if (object == null) {
                        this.static_vars_ex.put(entry.getKey(), setOfLocations.copy_deep(hashMap));
                        continue;
                    }
                    ((SetOfLocations)object).union_deep(setOfLocations, hashMap, stack);
                }
            }
            if (analysisSummary.returned != null) {
                if (this.returned == null) {
                    this.returned = analysisSummary.returned.copy_deep(hashMap);
                } else {
                    this.returned.union_deep(analysisSummary.returned, hashMap, stack);
                }
            }
            if (analysisSummary.thrown != null) {
                if (this.thrown == null) {
                    this.thrown = analysisSummary.thrown.copy_deep(hashMap);
                } else {
                    this.thrown.union_deep(analysisSummary.thrown, hashMap, stack);
                }
            }
            return bl;
        }

        AnalysisSummary copy_deep() {
            SetOfLocations setOfLocations;
            SetOfLocations setOfLocations2;
            jq_StaticField jq_StaticField2;
            Object object;
            int n;
            AnalysisSummary analysisSummary = new AnalysisSummary(this.method);
            HashMap hashMap = new HashMap();
            if (this.params != null) {
                analysisSummary.params = new ParamLocation[this.method.getParamTypes().length];
                n = 0;
                while (n < this.params.length) {
                    object = this.params[n];
                    if (object != null) {
                        analysisSummary.params[n] = (ParamLocation)((ParamLocation)object).copy_deep(hashMap);
                    }
                    ++n;
                }
            }
            if (this.params_ex != null) {
                analysisSummary.params_ex = new ParamLocation[this.method.getParamTypes().length];
                n = 0;
                while (n < this.params_ex.length) {
                    object = this.params_ex[n];
                    if (object != null) {
                        analysisSummary.params_ex[n] = (ParamLocation)((ParamLocation)object).copy_deep(hashMap);
                    }
                    ++n;
                }
            }
            if (this.static_vars != null) {
                analysisSummary.static_vars = new HashMap();
                Iterator iterator = this.static_vars.entrySet().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    jq_StaticField2 = (jq_StaticField)object.getKey();
                    setOfLocations2 = (SetOfLocations)object.getValue();
                    boolean bl = false;
                    if (setOfLocations2 != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    analysisSummary.static_vars.put(jq_StaticField2, setOfLocations2.copy_deep(hashMap));
                }
            }
            if (this.static_vars_ex != null) {
                analysisSummary.static_vars_ex = new HashMap();
                Iterator iterator = this.static_vars_ex.entrySet().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    jq_StaticField2 = (jq_StaticField)object.getKey();
                    setOfLocations2 = (SetOfLocations)object.getValue();
                    boolean bl = false;
                    if (setOfLocations2 != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    analysisSummary.static_vars_ex.put(jq_StaticField2, setOfLocations2.copy_deep(hashMap));
                }
            }
            if ((setOfLocations = this.returned) != null) {
                analysisSummary.returned = setOfLocations.copy_deep(hashMap);
            }
            if ((setOfLocations = this.thrown) != null) {
                analysisSummary.thrown = setOfLocations.copy_deep(hashMap);
            }
            return analysisSummary;
        }

        boolean equivalent(AnalysisSummary analysisSummary) {
            return true;
        }

        static void dump_recurse(PrintStream printStream, Set set, int n, ProgramLocation programLocation) {
            String string;
            SetOfLocations setOfLocations;
            Dereference dereference;
            Map.Entry entry;
            Iterator iterator;
            boolean bl = false;
            if (programLocation.getInsideEdges() != null) {
                iterator = programLocation.getInsideEdges().entrySet().iterator();
                bl = iterator.hasNext();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    dereference = (Dereference)entry.getKey();
                    setOfLocations = (SetOfLocations)entry.getValue();
                    string = "-" + dereference.toString() + "->";
                    out_ta.print(string);
                    AnalysisSummary.dump_recurse(printStream, set, n + string.length(), setOfLocations);
                    if (!iterator.hasNext()) continue;
                    out_ta.print(Strings.left("", n));
                }
            }
            if (programLocation instanceof OutsideProgramLocation && ((OutsideProgramLocation)programLocation).getOutsideEdges() != null) {
                iterator = ((OutsideProgramLocation)programLocation).getOutsideEdges().entrySet().iterator();
                if (bl && iterator.hasNext()) {
                    out_ta.print(Strings.left("", n));
                }
                bl |= iterator.hasNext();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    dereference = (Dereference)entry.getKey();
                    setOfLocations = (SetOfLocations)entry.getValue();
                    string = "=" + dereference.toString() + "=>";
                    out_ta.print(string);
                    AnalysisSummary.dump_recurse(printStream, set, n + string.length(), setOfLocations);
                    if (!iterator.hasNext()) continue;
                    out_ta.print(Strings.left("", n));
                }
            }
            if (!bl) {
                out_ta.println();
            }
        }

        static void dump_recurse(PrintStream printStream, Set set, int n, SetOfLocations setOfLocations) {
            if (set.contains(setOfLocations)) {
                out_ta.println("<backedge to " + Integer.toHexString(setOfLocations.hashCode()) + '>');
                return;
            }
            set.add(setOfLocations);
            out_ta.println(Integer.toHexString(setOfLocations.hashCode()));
            Iterator iterator = setOfLocations.sources.iterator();
            while (iterator.hasNext()) {
                ProgramLocation programLocation = (ProgramLocation)iterator.next();
                String string = programLocation.toString();
                out_ta.print(Strings.left("", n));
                out_ta.print(string);
                AnalysisSummary.dump_recurse(printStream, set, n + string.length(), programLocation);
            }
        }

        void dump(boolean bl) {
            Map map;
            Object object;
            ParamLocation[] paramLocationArray;
            PrintStream printStream = System.out;
            out_ta.println((bl ? "Exception" : "Regular") + " Summary for method " + this.method + ':');
            HashSet hashSet = new HashSet();
            ParamLocation[] paramLocationArray2 = paramLocationArray = bl ? this.params_ex : this.params;
            if (paramLocationArray != null) {
                int n = 0;
                while (n < paramLocationArray.length) {
                    if (paramLocationArray[n] != null) {
                        out_ta.print(Strings.left("P" + n + ':', 4));
                        object = paramLocationArray[n].toString();
                        out_ta.print((String)object);
                        AnalysisSummary.dump_recurse(printStream, hashSet, 4 + ((String)object).length(), paramLocationArray[n]);
                    }
                    ++n;
                }
            }
            Map map2 = map = bl ? this.static_vars_ex : this.static_vars;
            if (map != null) {
                object = map.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    jq_StaticField jq_StaticField2 = (jq_StaticField)entry.getKey();
                    SetOfLocations setOfLocations = (SetOfLocations)entry.getValue();
                    String string = jq_StaticField2.getName().toString() + ':';
                    out_ta.print(string);
                    AnalysisSummary.dump_recurse(printStream, hashSet, string.length(), setOfLocations);
                }
            }
            out_ta.println();
            if (this.returned != null) {
                object = "Returned: ";
                out_ta.print((String)object);
                AnalysisSummary.dump_recurse(printStream, hashSet, ((String)object).length(), this.returned);
            }
            if (this.thrown != null) {
                object = "Thrown: ";
                out_ta.print((String)object);
                AnalysisSummary.dump_recurse(printStream, hashSet, ((String)object).length(), this.thrown);
            }
            out_ta.println();
        }

        AnalysisSummary(jq_Method jq_Method2) {
            this.method = jq_Method2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class TypeAnalysisVisitor
    extends StackDepthVisitor {
        public static boolean ALWAYS_TRACE = false;
        public static HashSet trace_method_names = new HashSet();
        public static int MAX_DEPTH = 8;
        public static boolean BY_PACKAGE = false;
        final int nParams;
        final int nLocals;
        final int nStack;
        AnalysisState currentState;
        final Map loc_map;
        final AnalysisSummary summary;
        final AnalysisState[] in_states;
        final AnalysisState[] out_states;
        BasicBlock currentBB;
        boolean change;
        final Stack callStack;
        Set do_it_again;
        boolean dontMergeWithSuccessors;

        public String toString() {
            return "TA/" + this.method.getName();
        }

        boolean shouldRecordMethod(ProgramLocation programLocation, jq_Method jq_Method2) {
            if (this.method instanceof jq_InstanceMethod && programLocation.equals(this.currentState.parameters[0])) {
                if (this.TRACE) {
                    this.out.println("Skipping recording call to " + jq_Method2 + " on this");
                }
                return false;
            }
            return true;
        }

        public void visitBasicBlock(BasicBlock basicBlock) {
            this.currentBB = basicBlock;
            super.visitBasicBlock(basicBlock);
        }

        public void visitACONST(Object object) {
            super.visitACONST(object);
            jq_Reference jq_Reference2 = null;
            if (object != null) {
                jq_Reference2 = Reflection.getTypeOf(object);
            }
            SetOfLocations setOfLocations = SetOfLocations.makeConstantSet(object, jq_Reference2, this.method, this.i_start);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations);
        }

        public void visitALOAD(int n) {
            this.currentState.move(this.nLocals + this.currentStackDepth, n);
            super.visitALOAD(n);
        }

        public void visitISTORE(int n) {
            super.visitISTORE(n);
            this.currentState.put(n, null);
        }

        public void visitFSTORE(int n) {
            super.visitFSTORE(n);
            this.currentState.put(n, null);
        }

        public void visitLSTORE(int n) {
            super.visitLSTORE(n);
            this.currentState.put(n, null);
            this.currentState.put(n + 1, null);
        }

        public void visitDSTORE(int n) {
            super.visitDSTORE(n);
            this.currentState.put(n, null);
            this.currentState.put(n + 1, null);
        }

        public void visitASTORE(int n) {
            this.currentState.move(n, this.nLocals + this.currentStackDepth - 1);
            super.visitASTORE(n);
        }

        public void visitIALOAD() {
            this.currentState.put(this.nLocals + this.currentStackDepth - 2, null);
            super.visitIALOAD();
        }

        public void visitFALOAD() {
            this.currentState.put(this.nLocals + this.currentStackDepth - 2, null);
            super.visitFALOAD();
        }

        public void visitLALOAD() {
            this.currentState.put(this.nLocals + this.currentStackDepth - 2, null);
            super.visitLALOAD();
        }

        public void visitDALOAD() {
            this.currentState.put(this.nLocals + this.currentStackDepth - 2, null);
            super.visitDALOAD();
        }

        public void visitAALOAD() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 2);
            super.visitAALOAD();
            jq_Type jq_Type2 = setOfLocations.getType();
            jq_Array jq_Array2 = jq_Type2 instanceof jq_Array ? (jq_Array)jq_Type2 : PrimordialClassLoader.getJavaLangObject().getArrayTypeForElementType();
            ArrayDereference arrayDereference = new ArrayDereference(jq_Array2);
            SetOfLocations setOfLocations2 = setOfLocations.dereference((Dereference)arrayDereference, this.method, this.i_start);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations2);
        }

        public void visitAASTORE() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 3);
            SetOfLocations setOfLocations2 = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            this.currentState.put(this.nLocals + this.currentStackDepth - 3, null);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, null);
            super.visitAASTORE();
            jq_Type jq_Type2 = setOfLocations.getType();
            jq_Array jq_Array2 = jq_Type2 instanceof jq_Array ? (jq_Array)jq_Type2 : PrimordialClassLoader.getJavaLangObject().getArrayTypeForElementType();
            ArrayDereference arrayDereference = new ArrayDereference(jq_Array2);
            setOfLocations.store(arrayDereference, setOfLocations2);
        }

        public void visitARETURN() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, null);
            this.summary.addToReturned(setOfLocations);
            super.visitARETURN();
        }

        public void visitAGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitAGETSTATIC(jq_StaticField2);
            SetOfLocations setOfLocations = this.currentState.getStaticField(jq_StaticField2);
            if (setOfLocations == null) {
                if (this.TRACE) {
                    this.out.println("No writes to static field " + jq_StaticField2 + " yet");
                }
                setOfLocations = SetOfLocations.makeStaticFieldSet(jq_StaticField2);
                this.currentState.putStaticField(jq_StaticField2, setOfLocations);
            } else if (this.TRACE) {
                this.out.println("Writes to static field " + jq_StaticField2 + ": " + setOfLocations);
            }
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations);
        }

        public void visitAPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitAPUTSTATIC(jq_StaticField2);
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth);
            this.currentState.put(this.nLocals + this.currentStackDepth, null);
            SetOfLocations setOfLocations2 = this.currentState.getStaticField(jq_StaticField2);
            if (setOfLocations2 == null) {
                if (this.TRACE) {
                    this.out.println("First write to static field " + jq_StaticField2 + ": " + setOfLocations);
                }
            } else if (this.TRACE) {
                this.out.println("Already had write to static field " + jq_StaticField2 + ": " + setOfLocations2 + "! replacing with " + setOfLocations);
            }
            this.currentState.putStaticField(jq_StaticField2, setOfLocations);
        }

        public void visitAGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitAGETFIELD(jq_InstanceField2);
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            FieldDereference fieldDereference = new FieldDereference(jq_InstanceField2);
            SetOfLocations setOfLocations2 = setOfLocations.dereference((Dereference)fieldDereference, this.method, this.i_start);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations2);
        }

        public void visitAPUTFIELD(jq_InstanceField jq_InstanceField2) {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 2);
            SetOfLocations setOfLocations2 = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            this.currentState.put(this.nLocals + this.currentStackDepth - 2, null);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, null);
            super.visitAPUTFIELD(jq_InstanceField2);
            FieldDereference fieldDereference = new FieldDereference(jq_InstanceField2);
            setOfLocations.store(fieldDereference, setOfLocations2);
        }

        void visitInvoke(byte by, jq_Method jq_Method2) {
            Object object;
            CallTargets callTargets;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Iterator iterator;
            if (by != 1) {
                iterator = this.currentState.get(this.nLocals + this.currentStackDepth - jq_Method2.getReturnWords());
                object5 = ((SetOfLocations)((Object)iterator)).iterator();
                while (object5.hasNext()) {
                    object4 = (ProgramLocation)object5.next();
                    if (!this.shouldRecordMethod((ProgramLocation)object4, jq_Method2)) continue;
                    object3 = "" + this.method + ':' + this.i_start;
                    object2 = new MethodCall(this.method, this.i_start, jq_Method2);
                    ((ProgramLocation)object4).mustCall((MethodCall)object2, (String)object3);
                }
                object5 = ((SetOfLocations)((Object)iterator)).iterator();
                callTargets = CallTargets.NoCallTarget.INSTANCE;
                while (object5.hasNext()) {
                    object4 = (ProgramLocation)object5.next();
                    object3 = (jq_Reference)((ProgramLocation)object4).getType();
                    object2 = object3 == null ? CallTargets.NoCallTarget.INSTANCE : CallTargets.getTargets(this.method.getDeclaringClass(), jq_Method2, by, (jq_Reference)object3, ((ProgramLocation)object4).isFromOutside() ^ true, true);
                    callTargets = callTargets.union((CallTargets)object2);
                }
            } else {
                callTargets = CallTargets.getStaticTargets((jq_StaticMethod)jq_Method2);
            }
            if (this.TRACE) {
                this.out.println("Method call targets: " + callTargets);
            }
            iterator = callTargets.iterator();
            object5 = new LinearSet();
            while (iterator.hasNext()) {
                object4 = (jq_Method)iterator.next();
                object3 = ((jq_Member)object4).getDeclaringClass();
                ((jq_Class)object3).prepare();
                if (((jq_Method)object4).isNative()) {
                    if (!this.TRACE) continue;
                    this.out.println("Native method call! from " + this.method + ':' + this.i_start + " to " + object4);
                    continue;
                }
                object2 = (AnalysisSummary)summaries.get(object4);
                if (this.callStack.contains(object4)) {
                    if (this.TRACE) {
                        this.out.println("Call stack contains " + object4 + "! doing interprocedural iteration.");
                    }
                    this.do_it_again.add(object4);
                    if (object2 == null) continue;
                    object5.add(object2);
                    continue;
                }
                if (this.do_it_again.contains(object4)) {
                    if (this.TRACE) {
                        this.out.println("Performing interprocedural iteration on " + object4);
                    }
                    boolean bl = false;
                    if (object2 != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    while (true) {
                        if (((AnalysisSummary)object2).equivalent((AnalysisSummary)(object = TypeAnalysis.analyze((jq_Method)object4, this.callStack, this.do_it_again)))) {
                            if (this.TRACE) {
                                this.out.println("Summaries are equivalent! Finished iterating " + object4);
                            }
                            summaries.put(object4, object2);
                            this.do_it_again.remove(object4);
                            break;
                        }
                        if (this.TRACE) {
                            this.out.println("Summaries are different! Continuing iteration of " + object4);
                        }
                        Assert._assert(this.do_it_again.contains(object4));
                    }
                }
                if (object2 == null) {
                    if (this.callStack.size() >= MAX_DEPTH) {
                        if (!this.TRACE) continue;
                        this.out.println("Exceeded maximum depth, skipping call target " + object4);
                        continue;
                    }
                    if (BY_PACKAGE && !this.method.getDeclaringClass().isInSamePackage(((jq_Member)object4).getDeclaringClass())) {
                        if (!this.TRACE) continue;
                        this.out.println("Call target " + object4 + " is not in the same package as " + this.method + ", skipping.");
                        continue;
                    }
                    if (classesToAnalyze != null && !classesToAnalyze.contains(((jq_Member)object4).getDeclaringClass())) {
                        if (!this.TRACE) continue;
                        this.out.println("Call target " + object4 + " is not in the set of classes to analyze, skipping.");
                        continue;
                    }
                    object2 = TypeAnalysis.analyze((jq_Method)object4, this.callStack, this.do_it_again);
                    boolean bl = false;
                    if (object2 != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    summaries.put(object4, object2);
                    if (this.TRACE) {
                        this.out.println("Cached result of analysis of method " + object4 + ':');
                    }
                }
                object5.add(object2);
            }
            if (object5.size() == 0) {
                if (this.TRACE) {
                    this.out.println("No analysis results!");
                }
                if (((jq_Type)(object4 = jq_Method2.getReturnType())).isReferenceType()) {
                    object3 = SetOfLocations.makeSeed((jq_Type)object4);
                    this.currentState.put(this.nLocals + this.currentStackDepth - 1, (SetOfLocations)object3);
                }
                object3 = new CaughtLocation(this.method, this.i_start, PrimordialClassLoader.getJavaLangThrowable());
                ((CaughtLocation)object3).methodSequences = new MethodCallSequences(true);
                object2 = new SetOfLocations();
                ((SetOfLocations)object2).add((ProgramLocation)object3);
                this.summary.addToThrown((SetOfLocations)object2);
                if (this.TRACE) {
                    this.out.println("Call can throw " + object2 + ", unioning with exception exit");
                }
                if (this.in_states[0] == null) {
                    if (this.TRACE) {
                        this.out.println("First exceptional path, copying set");
                    }
                    this.in_states[0] = this.currentState.copy_deep();
                } else {
                    this.in_states[0].union_deep(this.currentState);
                }
                object = this.currentBB.getExceptionHandlers();
                while (((ExceptionHandlerIterator)object).hasNext()) {
                    ExceptionHandler exceptionHandler = ((ExceptionHandlerIterator)object).nextEH();
                    this.unionWithExceptionHandler((SetOfLocations)object2, exceptionHandler);
                }
                return;
            }
            if (object5.size() == 1) {
                object4 = (AnalysisSummary)object5.iterator().next();
            } else {
                iterator = object5.iterator();
                object4 = ((AnalysisSummary)iterator.next()).copy_deep();
                while (iterator.hasNext()) {
                    ((AnalysisSummary)object4).union_deep((AnalysisSummary)iterator.next());
                }
            }
            object3 = this.currentState.copy_deep();
            object2 = this.applySummary(this.currentState, jq_Method2, (AnalysisSummary)object4, false);
            object2 = this.applySummary((AnalysisState)object3, jq_Method2, (AnalysisSummary)object4, true);
            object = new CaughtLocation(this.method, this.i_start, PrimordialClassLoader.getJavaLangThrowable());
            ((CaughtLocation)object).methodSequences = new MethodCallSequences(true);
            if (object2 == null) {
                object2 = new SetOfLocations();
            }
            ((SetOfLocations)object2).add((ProgramLocation)object);
            this.summary.addToThrown((SetOfLocations)object2);
            if (this.TRACE) {
                this.out.println("Call can throw " + object2 + ", unioning with exception exit");
            }
            if (this.in_states[0] == null) {
                if (this.TRACE) {
                    this.out.println("First exceptional path, copying set");
                }
                this.in_states[0] = ((AnalysisState)object3).copy_deep();
            } else {
                this.in_states[0].union_deep((AnalysisState)object3);
            }
            ExceptionHandlerIterator exceptionHandlerIterator = this.currentBB.getExceptionHandlers();
            while (exceptionHandlerIterator.hasNext()) {
                ExceptionHandler exceptionHandler = exceptionHandlerIterator.nextEH();
                this.unionWithExceptionHandler((SetOfLocations)object2, exceptionHandler);
            }
        }

        void unionWithExceptionHandler(SetOfLocations setOfLocations, ExceptionHandler exceptionHandler) {
            SetOfLocations[] setOfLocationsArray = new SetOfLocations[this.method.getMaxStack()];
            BasicBlock basicBlock = exceptionHandler.getEntry();
            SetOfLocations setOfLocations2 = setOfLocations.filterByType(exceptionHandler.getExceptionType());
            if (setOfLocations2.size() == 0) {
                return;
            }
            if (this.TRACE) {
                this.out.println("Exceptions " + setOfLocations2 + " can go to handler " + exceptionHandler);
            }
            int n = this.method.getMaxLocals();
            System.arraycopy(this.currentState.variables, n, setOfLocationsArray, 0, setOfLocationsArray.length);
            this.currentState.variables[n] = setOfLocations2;
            ++n;
            while (n < setOfLocationsArray.length) {
                this.currentState.variables[n] = null;
                ++n;
            }
            if (this.in_states[basicBlock.id] != null) {
                boolean bl = false;
                if (basicBlock.startingStackDepth == 1) {
                    bl = true;
                }
                Assert._assert(bl);
                if (this.in_states[basicBlock.id].union_deep(this.currentState)) {
                    if (this.TRACE) {
                        this.out.println("In set for exception handler " + basicBlock + " changed!");
                    }
                    this.change = true;
                }
            } else {
                if (this.TRACE) {
                    this.out.println("No in set for exception handler " + basicBlock + " yet");
                }
                this.in_states[basicBlock.id] = this.currentState.copy_deep();
                this.change = true;
                basicBlock.startingStackDepth = 1;
            }
            System.arraycopy(setOfLocationsArray, 0, this.currentState.variables, this.method.getMaxLocals(), setOfLocationsArray.length);
        }

        static boolean isInMultimap(HashMap hashMap, ProgramLocation programLocation, SetOfLocations setOfLocations) {
            SetOfLocations setOfLocations2 = (SetOfLocations)hashMap.get(programLocation);
            if (setOfLocations2 == null) {
                return false;
            }
            Iterator iterator = setOfLocations.iterator();
            while (iterator.hasNext()) {
                if (setOfLocations2.contains((ProgramLocation)iterator.next())) continue;
                return false;
            }
            return true;
        }

        static boolean addToMultimap(HashMap hashMap, ProgramLocation programLocation, SetOfLocations setOfLocations) {
            SetOfLocations setOfLocations2 = (SetOfLocations)hashMap.get(programLocation);
            if (setOfLocations2 == null) {
                setOfLocations2 = SetOfLocations.makeEmptySet();
                hashMap.put(programLocation, setOfLocations2);
            }
            return setOfLocations2.addAll(setOfLocations);
        }

        SetOfLocations mapCalleeSetIntoCaller(HashMap hashMap, HashMap hashMap2, HashMap hashMap3, SetOfLocations setOfLocations) {
            if (this.TRACE) {
                this.out.println("Mapping callee set " + setOfLocations + " to caller");
            }
            Stack stack = new Stack();
            SetOfLocations setOfLocations2 = SetOfLocations.makeEmptySet();
            Iterator iterator = setOfLocations.iterator();
            while (iterator.hasNext()) {
                SetOfLocations setOfLocations3;
                ProgramLocation programLocation = (ProgramLocation)iterator.next();
                if (programLocation instanceof OutsideProgramLocation) {
                    setOfLocations3 = (SetOfLocations)hashMap2.get(programLocation);
                    if (this.TRACE) {
                        this.out.println("Outside callee node " + programLocation + " corresponds to caller set " + setOfLocations3);
                    }
                    if (setOfLocations3 == null) continue;
                    OutsideProgramLocation outsideProgramLocation = (OutsideProgramLocation)programLocation;
                    if (outsideProgramLocation.getOriginalType() != outsideProgramLocation.getType()) {
                        if (this.TRACE) {
                            this.out.println("Cast occurred on callee outside node " + outsideProgramLocation + " to type " + outsideProgramLocation.getType() + ", filtering our nodes " + setOfLocations3);
                        }
                        setOfLocations3 = setOfLocations3.filterByType(outsideProgramLocation.getType());
                    }
                    setOfLocations2.union_deep(setOfLocations3, hashMap, stack);
                    continue;
                }
                setOfLocations3 = (SetOfLocations)hashMap3.get(programLocation);
                if (setOfLocations3 == null) {
                    setOfLocations3 = SetOfLocations.makeEmptySet();
                    setOfLocations3.add(programLocation.copy_deep(hashMap));
                    hashMap3.put(programLocation, setOfLocations3);
                }
                if (this.TRACE) {
                    this.out.println("Inside callee node " + programLocation + " corresponds to caller node " + setOfLocations3);
                }
                setOfLocations2.union_deep(setOfLocations3, hashMap, stack);
            }
            if (this.TRACE) {
                this.out.println("Result of mapping callee set " + setOfLocations + " to caller: " + setOfLocations2);
            }
            return setOfLocations2;
        }

        public SetOfLocations applySummary(AnalysisState analysisState, jq_Method jq_Method2, AnalysisSummary analysisSummary, boolean bl) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Map.Entry entry;
            Map map;
            Object object7;
            Object object8;
            Object object9;
            boolean bl2 = false;
            if (analysisSummary != null) {
                bl2 = true;
            }
            Assert._assert(bl2);
            if (this.TRACE) {
                this.out.println(" --------======> APPLYING " + (bl ? "EXCEPTION" : "") + " SUMMARY " + jq_Method2 + ':');
                analysisSummary.dump(bl);
                this.out.println(" --------======> TO STATE");
                analysisState.dump();
            }
            jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
            HashMap hashMap = new HashMap();
            Stack<Object> stack = new Stack<Object>();
            boolean bl3 = false;
            if (analysisSummary.params != null) {
                bl3 = true;
            }
            Assert._assert(bl3);
            ParamLocation[] paramLocationArray = !bl ? analysisSummary.params : analysisSummary.params_ex;
            if (paramLocationArray != null) {
                int n = 0;
                int n2 = 0;
                while (n < jq_TypeArray.length) {
                    object9 = jq_TypeArray[n];
                    if (((jq_Type)object9).isPrimitiveType()) {
                        if (((jq_Type)object9).getReferenceSize() == 8) {
                            ++n2;
                        }
                    } else {
                        object8 = analysisState.get(this.nLocals + this.currentStackDepth - jq_Method2.getReturnWords() + n2);
                        analysisState.put(this.nLocals + this.currentStackDepth - jq_Method2.getReturnWords() + n2, null);
                        object7 = paramLocationArray[n];
                        if (this.TRACE) {
                            this.out.println("Param " + n + " Callee outside node " + object7 + " matches caller set " + object8);
                        }
                        TypeAnalysisVisitor.addToMultimap(hashMap, (ProgramLocation)object7, (SetOfLocations)object8);
                        Assert._assert(stack.contains(object7) ^ true);
                        stack.push(object7);
                    }
                    ++n;
                    ++n2;
                }
            }
            if ((map = !bl ? analysisSummary.static_vars : analysisSummary.static_vars_ex) != null) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    object9 = iterator.next();
                    object8 = (jq_StaticField)object9.getKey();
                    object7 = (SetOfLocations)object9.getValue();
                    entry = ((SetOfLocations)object7).iterator();
                    while (entry.hasNext()) {
                        object6 = (ProgramLocation)entry.next();
                        if (!(object6 instanceof StaticFieldLocation)) continue;
                        object5 = (StaticFieldLocation)object6;
                        if (object8 != ((StaticFieldLocation)object5).field) continue;
                        object4 = (SetOfLocations)analysisState.static_variables.get(((StaticFieldLocation)object5).field);
                        if (object4 == null) {
                            if (this.TRACE) {
                                this.out.println("Callee has static field " + ((StaticFieldLocation)object5).field + " that caller doesn't have: " + object5);
                            }
                            object4 = SetOfLocations.makeStaticFieldSet(((StaticFieldLocation)object5).field);
                            analysisState.static_variables.put(((StaticFieldLocation)object5).field, object4);
                        } else if (this.TRACE) {
                            this.out.println("Callee has static field " + ((StaticFieldLocation)object5).field + " as node " + object5 + " that matches caller set " + object4);
                        }
                        TypeAnalysisVisitor.addToMultimap(hashMap, (ProgramLocation)object5, (SetOfLocations)object4);
                        if (stack.contains(object5)) {
                            this.out.println(this.method + " ERROR!! callee node worklist (" + stack + ") already contains sf node: " + object5);
                            Assert.UNREACHABLE();
                        }
                        stack.push(object5);
                    }
                }
            }
            HashMap hashMap2 = new HashMap();
            while (!stack.empty()) {
                object9 = (OutsideProgramLocation)stack.pop();
                if (((OutsideProgramLocation)object9).getOutsideEdges() == null) continue;
                object8 = (SetOfLocations)hashMap.get(object9);
                if (this.TRACE) {
                    this.out.println("Visiting outside edges of node " + object9 + ", matches caller set " + object8);
                }
                boolean bl4 = false;
                if (object8 != null) {
                    bl4 = true;
                }
                Assert._assert(bl4);
                object7 = ((OutsideProgramLocation)object9).getOutsideEdges().entrySet().iterator();
                while (object7.hasNext()) {
                    entry = (Map.Entry)object7.next();
                    object6 = (Dereference)entry.getKey();
                    object5 = (SetOfLocations)entry.getValue();
                    object4 = ((SetOfLocations)object8).dereference((Dereference)object6, (SetOfLocations)object5, hashMap2);
                    object3 = ((SetOfLocations)object5).iterator();
                    while (object3.hasNext()) {
                        object2 = (DereferenceLocation)object3.next();
                        if (((DereferenceLocation)object2).deref.getType() != ((DereferenceLocation)object2).getType()) {
                            if (this.TRACE) {
                                this.out.println("Cast occurred on callee outside node " + object2 + " to type " + ((DereferenceLocation)object2).getType() + ", filtering our nodes " + object4);
                            }
                            object4 = ((SetOfLocations)object4).filterByType(((DereferenceLocation)object2).getType());
                        }
                        if (!TypeAnalysisVisitor.addToMultimap(hashMap, (ProgramLocation)object2, (SetOfLocations)object4)) continue;
                        if (this.TRACE) {
                            this.out.println("Set changed for callee outside node " + object2 + " after adding " + object4 + ", adding to worklist");
                        }
                        stack.push(object2);
                    }
                }
            }
            object9 = hashMap.entrySet().iterator();
            object8 = new HashMap();
            while (object9.hasNext()) {
                object7 = (Map.Entry)object9.next();
                entry = (OutsideProgramLocation)object7.getKey();
                object6 = (SetOfLocations)object7.getValue();
                if (((ProgramLocation)((Object)entry)).getInsideEdges() == null) continue;
                if (this.TRACE) {
                    this.out.println("Adding inside edges of callee outside node " + entry + " to caller set " + object6);
                }
                object5 = ((ProgramLocation)((Object)entry)).getInsideEdges().entrySet().iterator();
                while (object5.hasNext()) {
                    object4 = (Map.Entry)object5.next();
                    object3 = (Dereference)object4.getKey();
                    object2 = (SetOfLocations)object4.getValue();
                    object = this.mapCalleeSetIntoCaller(hashMap2, hashMap, (HashMap)object8, (SetOfLocations)object2);
                    ((SetOfLocations)object6).store((Dereference)object3, (SetOfLocations)object);
                }
            }
            object9 = hashMap.entrySet().iterator();
            object7 = new HashMap();
            if (this.TRACE) {
                this.out.println("Adding callee method call sequences...");
            }
            while (object9.hasNext()) {
                entry = object9.next();
                object6 = (ProgramLocation)entry.getKey();
                object5 = ((ProgramLocation)object6).getMethodCallSequences();
                if (((MethodCallSequences)object5).isEmpty()) continue;
                object4 = (SetOfLocations)entry.getValue();
                if (this.TRACE) {
                    this.out.println("Adding callee sequence " + object5 + " on caller nodes " + object4);
                }
                object3 = ((SetOfLocations)object4).iterator();
                while (object3.hasNext()) {
                    object2 = (ProgramLocation)object3.next();
                    object = (MethodCallSequences)((HashMap)object7).get(object2);
                    if (object == null) {
                        object = ((MethodCallSequences)object5).copy_deep();
                        ((HashMap)object7).put(object2, object);
                        if (!this.TRACE) continue;
                        this.out.println("First method call sequence on " + object2 + ": " + object);
                        continue;
                    }
                    if (this.TRACE) {
                        this.out.println("Intersecting method call sequence on " + object2 + ": " + object5);
                    }
                    ((MethodCallSequences)object).intersect_deep((MethodCallSequences)object5);
                    if (!this.TRACE) continue;
                    this.out.println("Result of intersection: " + object);
                }
            }
            object9 = ((HashMap)object7).entrySet().iterator();
            while (object9.hasNext()) {
                entry = object9.next();
                object6 = (ProgramLocation)entry.getKey();
                object5 = (MethodCallSequences)entry.getValue();
                if (bl) {
                    if (this.TRACE) {
                        this.out.println("Merging to exceptional exit method sequence " + object5 + " for node " + object6);
                    }
                    ((ProgramLocation)object6).methodSequences.union_deep((MethodCallSequences)object5);
                    continue;
                }
                if (this.TRACE) {
                    this.out.println("Applying first called method sets " + ((MethodCallSequences)object5).printFirstCalled() + " to node " + object6);
                }
                object4 = "Method call at " + this.method + ':' + this.i_start;
                ((ProgramLocation)object6).addFirstCalledToMayCall((MethodCallSequences)object5, (String)object4);
                ((ProgramLocation)object6).updateMustCall((MethodCallSequences)object5);
            }
            if (!bl) {
                if (analysisSummary.returned != null) {
                    entry = this.mapCalleeSetIntoCaller(hashMap2, hashMap, (HashMap)object8, analysisSummary.returned);
                    analysisState.put(this.nLocals + this.currentStackDepth - 1, (SetOfLocations)((Object)entry));
                } else if (jq_Method2.getReturnType().isReferenceType()) {
                    entry = SetOfLocations.makeSeed(jq_Method2.getReturnType());
                    this.currentState.put(this.nLocals + this.currentStackDepth - 1, (SetOfLocations)((Object)entry));
                }
                if (analysisSummary.thrown != null) {
                    entry = this.mapCalleeSetIntoCaller(hashMap2, hashMap, (HashMap)object8, analysisSummary.thrown);
                    return entry;
                }
            }
            return null;
        }

        public void visitIINVOKE(byte by, jq_Method jq_Method2) {
            super.visitIINVOKE(by, jq_Method2);
            this.visitInvoke(by, jq_Method2);
        }

        public void visitLINVOKE(byte by, jq_Method jq_Method2) {
            super.visitLINVOKE(by, jq_Method2);
            this.visitInvoke(by, jq_Method2);
        }

        public void visitFINVOKE(byte by, jq_Method jq_Method2) {
            super.visitFINVOKE(by, jq_Method2);
            this.visitInvoke(by, jq_Method2);
        }

        public void visitDINVOKE(byte by, jq_Method jq_Method2) {
            super.visitDINVOKE(by, jq_Method2);
            this.visitInvoke(by, jq_Method2);
        }

        public void visitAINVOKE(byte by, jq_Method jq_Method2) {
            super.visitAINVOKE(by, jq_Method2);
            this.visitInvoke(by, jq_Method2);
        }

        public void visitVINVOKE(byte by, jq_Method jq_Method2) {
            super.visitVINVOKE(by, jq_Method2);
            this.visitInvoke(by, jq_Method2);
        }

        public void visitNEW(jq_Type jq_Type2) {
            super.visitNEW(jq_Type2);
            SetOfLocations setOfLocations = SetOfLocations.makeNewSet(jq_Type2, this.method, this.i_start);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations);
        }

        public void visitNEWARRAY(jq_Array jq_Array2) {
            super.visitNEWARRAY(jq_Array2);
            SetOfLocations setOfLocations = SetOfLocations.makeNewSet(jq_Array2, this.method, this.i_start);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations);
        }

        public void visitCHECKCAST(jq_Type jq_Type2) {
            super.visitCHECKCAST(jq_Type2);
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            SetOfLocations setOfLocations2 = setOfLocations.filterByType(jq_Type2);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations2);
        }

        public void visitATHROW() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, null);
            this.summary.addToThrown(setOfLocations);
            if (this.in_states[0] == null) {
                if (this.TRACE) {
                    this.out.println("First exceptional path, copying set");
                }
                this.in_states[0] = this.currentState.copy_deep();
            } else {
                this.in_states[0].union_deep(this.currentState);
            }
            this.dontMergeWithSuccessors = true;
            super.visitATHROW();
        }

        public void visitMONITOR(byte by) {
            super.visitMONITOR(by);
        }

        public void visitMULTINEWARRAY(jq_Type jq_Type2, char c) {
            super.visitMULTINEWARRAY(jq_Type2, c);
            SetOfLocations setOfLocations = SetOfLocations.makeNewSet(jq_Type2, this.method, this.i_start);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations);
        }

        public void visitPOP() {
            super.visitPOP();
            this.currentState.put(this.nLocals + this.currentStackDepth, null);
        }

        public void visitPOP2() {
            super.visitPOP2();
            this.currentState.put(this.nLocals + this.currentStackDepth, null);
            this.currentState.put(this.nLocals + this.currentStackDepth + 1, null);
        }

        public void visitDUP() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            this.currentState.put(this.nLocals + this.currentStackDepth, setOfLocations);
            super.visitDUP();
        }

        public void visitDUP_x1() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            SetOfLocations setOfLocations2 = this.currentState.get(this.nLocals + this.currentStackDepth - 2);
            this.currentState.put(this.nLocals + this.currentStackDepth - 2, setOfLocations);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations2);
            this.currentState.put(this.nLocals + this.currentStackDepth, setOfLocations);
            super.visitDUP_x1();
        }

        public void visitDUP_x2() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            SetOfLocations setOfLocations2 = this.currentState.get(this.nLocals + this.currentStackDepth - 2);
            SetOfLocations setOfLocations3 = this.currentState.get(this.nLocals + this.currentStackDepth - 3);
            this.currentState.put(this.nLocals + this.currentStackDepth - 3, setOfLocations);
            this.currentState.put(this.nLocals + this.currentStackDepth - 2, setOfLocations3);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations2);
            this.currentState.put(this.nLocals + this.currentStackDepth, setOfLocations);
            super.visitDUP_x2();
        }

        public void visitDUP2() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            SetOfLocations setOfLocations2 = this.currentState.get(this.nLocals + this.currentStackDepth - 2);
            this.currentState.put(this.nLocals + this.currentStackDepth, setOfLocations2);
            this.currentState.put(this.nLocals + this.currentStackDepth + 1, setOfLocations);
            super.visitDUP2();
        }

        public void visitDUP2_x1() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            SetOfLocations setOfLocations2 = this.currentState.get(this.nLocals + this.currentStackDepth - 2);
            SetOfLocations setOfLocations3 = this.currentState.get(this.nLocals + this.currentStackDepth - 3);
            this.currentState.put(this.nLocals + this.currentStackDepth - 3, setOfLocations2);
            this.currentState.put(this.nLocals + this.currentStackDepth - 2, setOfLocations);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations3);
            this.currentState.put(this.nLocals + this.currentStackDepth, setOfLocations2);
            this.currentState.put(this.nLocals + this.currentStackDepth + 1, setOfLocations);
            super.visitDUP2_x1();
        }

        public void visitDUP2_x2() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            SetOfLocations setOfLocations2 = this.currentState.get(this.nLocals + this.currentStackDepth - 2);
            SetOfLocations setOfLocations3 = this.currentState.get(this.nLocals + this.currentStackDepth - 3);
            SetOfLocations setOfLocations4 = this.currentState.get(this.nLocals + this.currentStackDepth - 4);
            this.currentState.put(this.nLocals + this.currentStackDepth - 4, setOfLocations2);
            this.currentState.put(this.nLocals + this.currentStackDepth - 3, setOfLocations);
            this.currentState.put(this.nLocals + this.currentStackDepth - 2, setOfLocations4);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations3);
            this.currentState.put(this.nLocals + this.currentStackDepth, setOfLocations2);
            this.currentState.put(this.nLocals + this.currentStackDepth + 1, setOfLocations);
            super.visitDUP2_x2();
        }

        public void visitSWAP() {
            SetOfLocations setOfLocations = this.currentState.get(this.nLocals + this.currentStackDepth - 1);
            SetOfLocations setOfLocations2 = this.currentState.get(this.nLocals + this.currentStackDepth - 2);
            this.currentState.put(this.nLocals + this.currentStackDepth - 2, setOfLocations);
            this.currentState.put(this.nLocals + this.currentStackDepth - 1, setOfLocations2);
            super.visitSWAP();
        }

        public void visitJSR(int n) {
            boolean bl = false;
            if (this.currentBB.getNumberOfSuccessors() == 1) {
                bl = true;
            }
            Assert._assert(bl);
            BasicBlock basicBlock = this.currentBB.getSuccessor(0);
            SetOfLocations setOfLocations = SetOfLocations.makeJSRSubroutine(basicBlock);
            if (this.TRACE) {
                this.out.println("Made JSR subroutine from " + this.currentBB + " to target " + basicBlock);
            }
            this.currentState.put(this.nLocals + this.currentStackDepth, setOfLocations);
            super.visitJSR(n);
        }

        public void visitRET(int n) {
            super.visitRET(n);
            this.dontMergeWithSuccessors = true;
            SetOfLocations setOfLocations = this.currentState.get(n);
            Iterator iterator = setOfLocations.iterator();
            while (iterator.hasNext()) {
                int n2;
                JSRSubroutine jSRSubroutine = (JSRSubroutine)iterator.next();
                BasicBlock basicBlock = jSRSubroutine.jsub_bb;
                if (this.currentBB.getNumberOfSuccessors() == 0) {
                    if (this.TRACE) {
                        this.out.println("Adding jsr subroutine edges to " + this.currentBB);
                    }
                    this.change = true;
                    this.currentBB.setSubroutineRet(this.cfg, basicBlock);
                    if (this.TRACE) {
                        this.out.println("Number of jsr subroutine edges: " + this.currentBB.getNumberOfSuccessors());
                        n2 = 0;
                        while (n2 < this.currentBB.getNumberOfSuccessors()) {
                            this.out.println("Successor " + n2 + ": " + this.currentBB.getSuccessor(n2));
                            ++n2;
                        }
                    }
                }
                n2 = 0;
                while (n2 < basicBlock.getNumberOfPredecessors()) {
                    BasicBlock basicBlock2 = basicBlock.getPredecessor(n2);
                    AnalysisState analysisState = this.out_states[basicBlock2.id];
                    if (this.TRACE) {
                        this.out.println("Merging jsr subroutine info from " + this.currentBB + " and " + basicBlock2 + " into " + this.cfg.getBasicBlock(basicBlock2.id + 1));
                    }
                    if (analysisState == null) {
                        if (this.TRACE) {
                            this.out.println(basicBlock2 + " has not been analyzed yet!");
                        }
                    } else {
                        this.in_states[basicBlock2.id + 1] = analysisState.merge_jsr(this.currentState);
                        this.cfg.getBasicBlock((int)(basicBlock2.id + 1)).startingStackDepth = this.currentStackDepth;
                    }
                    ++n2;
                }
            }
        }

        private final /* synthetic */ void this() {
            this.dontMergeWithSuccessors = false;
        }

        TypeAnalysisVisitor(jq_Method jq_Method2, ControlFlowGraph controlFlowGraph, Stack stack, Set set, AnalysisState[] analysisStateArray, AnalysisState[] analysisStateArray2) {
            super(jq_Method2, controlFlowGraph);
            this.this();
            this.nParams = jq_Method2.getParamWords();
            this.nLocals = jq_Method2.getMaxLocals();
            this.nStack = jq_Method2.getMaxStack();
            this.loc_map = new HashMap();
            this.summary = new AnalysisSummary(jq_Method2);
            this.callStack = stack;
            this.do_it_again = set;
            this.TRACE = ALWAYS_TRACE;
            if (trace_method_names.contains(jq_Method2.getName().toString())) {
                this.TRACE = true;
            }
            this.in_states = analysisStateArray;
            this.out_states = analysisStateArray2;
        }
    }

    static class JSRSubroutine
    extends ProgramLocation {
        BasicBlock jsub_bb;

        public ProgramLocation filterByType(jq_Type jq_Type2) {
            return this;
        }

        public jq_Type getType() {
            return null;
        }

        boolean union_deep(ProgramLocation programLocation, HashMap hashMap, Stack stack) {
            boolean bl = false;
            if (((JSRSubroutine)programLocation).jsub_bb == this.jsub_bb) {
                bl = true;
            }
            Assert._assert(bl);
            return false;
        }

        public ProgramLocation copy_deep(HashMap hashMap) {
            JSRSubroutine jSRSubroutine = (JSRSubroutine)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (jSRSubroutine == null) {
                jSRSubroutine = new JSRSubroutine(this.jsub_bb);
                hashMap.put(IdentityHashCodeWrapper.create(this), jSRSubroutine);
            }
            return jSRSubroutine;
        }

        public ProgramLocation copy_shallow(HashMap hashMap) {
            JSRSubroutine jSRSubroutine = (JSRSubroutine)hashMap.get(IdentityHashCodeWrapper.create(this));
            if (jSRSubroutine == null) {
                jSRSubroutine = new JSRSubroutine(this.jsub_bb);
                hashMap.put(IdentityHashCodeWrapper.create(this), jSRSubroutine);
            }
            return jSRSubroutine;
        }

        public boolean equals(JSRSubroutine jSRSubroutine) {
            boolean bl = false;
            if (this.jsub_bb == jSRSubroutine.jsub_bb) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof JSRSubroutine) {
                return this.equals((JSRSubroutine)object);
            }
            return false;
        }

        public int hashCode() {
            return this.jsub_bb.hashCode();
        }

        public String toString() {
            return "jsrsub:" + this.jsub_bb;
        }

        JSRSubroutine(BasicBlock basicBlock) {
            this.jsub_bb = basicBlock;
        }
    }

    public static class ScalarReplacementVisitor
    extends TypeAnalysisVisitor {
        public String toString() {
            return "SR/" + this.method.getName();
        }

        ScalarReplacementVisitor(jq_Method jq_Method2, ControlFlowGraph controlFlowGraph, Stack stack, Set set, AnalysisState[] analysisStateArray, AnalysisState[] analysisStateArray2) {
            super(jq_Method2, controlFlowGraph, stack, set, analysisStateArray, analysisStateArray2);
        }
    }
}

