/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Dataflow;

import Clazz.jq_Class;
import Clazz.jq_Method;
import Clazz.jq_Type;
import Compil3r.Dataflow.Fact;
import Compil3r.Dataflow.IterativeSolver;
import Compil3r.Dataflow.PriorityQueueSolver;
import Compil3r.Dataflow.Problem;
import Compil3r.Dataflow.Solver;
import Compil3r.Dataflow.SortedSetSolver;
import Compil3r.Dataflow.TransferFunction;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.Quad;
import Compil3r.Quad.RegisterFactory;
import Main.HostedVM;
import Util.BitString;
import Util.Collections.Pair;
import Util.Collections.UnmodifiableIterator;
import Util.Graphs.EdgeGraph;
import Util.Graphs.Graph;
import Util.Strings;
import Util.Templates.List;
import Util.Templates.ListIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ReachingDefs
extends Problem {
    static final boolean TRACE = false;
    Quad[] quads;
    Map transferFunctions;
    RDSet emptySet;
    RDTransferFunction emptyTF;

    public void initialize(Graph graph) {
        Object object;
        Quad quad;
        Object object2;
        Object object3;
        ControlFlowGraph controlFlowGraph = (ControlFlowGraph)((EdgeGraph)graph).getGraph();
        int n = controlFlowGraph.getMaxQuadID() + 1;
        HashMap<RegisterFactory.Register, BitString> hashMap = new HashMap<RegisterFactory.Register, BitString>();
        this.transferFunctions = new HashMap();
        this.quads = new Quad[n];
        this.emptySet = new RDSet(n);
        this.emptyTF = new RDTransferFunction(n);
        List.BasicBlock basicBlock = controlFlowGraph.reversePostOrder(controlFlowGraph.entry());
        Iterator<Object> iterator = basicBlock.basicBlockIterator();
        while (iterator.hasNext()) {
            object3 = iterator.nextBasicBlock();
            object2 = new BitString(n);
            Object object4 = ((BasicBlock)object3).iterator();
            while (object4.hasNext()) {
                quad = object4.nextQuad();
                if (!((BasicBlock)object3).getExceptionHandlers().isEmpty()) {
                    this.handleEdges((BasicBlock)object3, ((BasicBlock)object3).getExceptionHandlerEntries(), (BitString)object2, null);
                }
                if (quad.getDefinedRegisters().isEmpty()) continue;
                int n2 = quad.getID();
                this.quads[n2] = quad;
                object = quad.getDefinedRegisters().registerOperandIterator();
                while (object.hasNext()) {
                    RegisterFactory.Register register = object.nextRegisterOperand().getRegister();
                    BitString bitString = (BitString)hashMap.get(register);
                    if (bitString == null) {
                        bitString = new BitString(n);
                        hashMap.put(register, bitString);
                    } else {
                        ((BitString)object2).minus(bitString);
                    }
                    bitString.set(n2);
                }
                ((BitString)object2).set(n2);
            }
            object4 = new RDTransferFunction((BitString)object2, new BitString(n));
            this.handleEdges((BasicBlock)object3, ((BasicBlock)object3).getSuccessors(), (BitString)object2, (RDTransferFunction)object4);
        }
        iterator = this.transferFunctions.values().iterator();
        while (iterator.hasNext()) {
            object3 = (RDTransferFunction)iterator.next();
            object2 = ((RDTransferFunction)object3).gen.iterator();
            while (((UnmodifiableIterator)object2).hasNext()) {
                int n3 = ((BitString.BitStringIterator)object2).nextIndex();
                quad = this.quads[n3];
                ListIterator.RegisterOperand registerOperand = quad.getDefinedRegisters().registerOperandIterator();
                while (registerOperand.hasNext()) {
                    object = registerOperand.nextRegisterOperand().getRegister();
                    ((RDTransferFunction)object3).kill.or((BitString)hashMap.get(object));
                }
            }
        }
    }

    private final void handleEdges(BasicBlock basicBlock, List.BasicBlock basicBlock2, BitString bitString, RDTransferFunction rDTransferFunction) {
        ListIterator.BasicBlock basicBlock3 = basicBlock2.basicBlockIterator();
        while (basicBlock3.hasNext()) {
            BasicBlock basicBlock4 = basicBlock3.nextBasicBlock();
            Pair pair = new Pair(basicBlock, basicBlock4);
            RDTransferFunction rDTransferFunction2 = (RDTransferFunction)this.transferFunctions.get(pair);
            if (rDTransferFunction2 == null) {
                rDTransferFunction2 = rDTransferFunction != null ? rDTransferFunction : new RDTransferFunction(bitString.size());
                this.transferFunctions.put(pair, rDTransferFunction2);
            }
            rDTransferFunction2.gen.or(bitString);
        }
    }

    public boolean direction() {
        return true;
    }

    public Fact boundary() {
        return this.emptySet;
    }

    public Fact interior() {
        return this.emptySet;
    }

    public TransferFunction getTransferFunction(Object object) {
        RDTransferFunction rDTransferFunction = (RDTransferFunction)this.transferFunctions.get(object);
        if (rDTransferFunction == null) {
            rDTransferFunction = this.emptyTF;
        }
        return rDTransferFunction;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        HostedVM.initialize();
        HashSet<jq_Method> hashSet = new HashSet<jq_Method>();
        int n = 0;
        while (n < stringArray.length) {
            object2 = stringArray[n];
            object = (jq_Class)jq_Type.parseType((String)object2);
            ((jq_Class)object).load();
            hashSet.addAll(Arrays.asList(((jq_Class)object).getDeclaredStaticMethods()));
            hashSet.addAll(Arrays.asList(((jq_Class)object).getDeclaredInstanceMethods()));
            ++n;
        }
        ReachingDefs reachingDefs = new ReachingDefs();
        object2 = new IterativeSolver();
        object = new SortedSetSolver(BBComparator.INSTANCE);
        PriorityQueueSolver priorityQueueSolver = new PriorityQueueSolver();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            jq_Method jq_Method2 = (jq_Method)iterator.next();
            if (jq_Method2.getBytecode() == null) continue;
            System.out.println("Method " + jq_Method2);
            ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
            System.out.println(controlFlowGraph.fullDump());
            ReachingDefs.solve(controlFlowGraph, (Solver)object2, reachingDefs);
            ReachingDefs.solve(controlFlowGraph, (Solver)object, reachingDefs);
            ReachingDefs.solve(controlFlowGraph, priorityQueueSolver, reachingDefs);
            ReachingDefs.dumpResults(controlFlowGraph, (Solver)object2);
            ReachingDefs.compareResults(controlFlowGraph, (Solver)object2, (Solver)object);
            ReachingDefs.compareResults(controlFlowGraph, (Solver)object, priorityQueueSolver);
        }
    }

    private static final void solve(ControlFlowGraph controlFlowGraph, Solver solver, Problem problem) {
        solver.initialize(problem, new EdgeGraph(controlFlowGraph));
        solver.solve();
    }

    private static final void dumpResults(ControlFlowGraph controlFlowGraph, Solver solver) {
        ListIterator.BasicBlock basicBlock = controlFlowGraph.reversePostOrderIterator();
        while (basicBlock.hasNext()) {
            BasicBlock basicBlock2 = (BasicBlock)basicBlock.next();
            Fact fact = solver.getDataflowValue(basicBlock2);
            System.out.println(basicBlock2 + ": " + fact);
        }
    }

    private static final void compareResults(ControlFlowGraph controlFlowGraph, Solver solver, Solver solver2) {
        ListIterator.BasicBlock basicBlock = controlFlowGraph.reversePostOrderIterator();
        while (basicBlock.hasNext()) {
            Fact fact;
            BasicBlock basicBlock2 = (BasicBlock)basicBlock.next();
            Fact fact2 = solver.getDataflowValue(basicBlock2);
            if (fact2.equals(fact = solver2.getDataflowValue(basicBlock2))) continue;
            System.out.println("MISMATCH");
            System.out.println(solver.getClass() + " says " + fact2);
            System.out.println(solver2.getClass() + " says " + fact);
        }
    }

    public static class RDTransferFunction
    implements TransferFunction {
        protected final BitString gen;
        protected final BitString kill;

        public String toString() {
            return "Gen: " + this.gen + Strings.lineSep + "Kill: " + this.kill;
        }

        public Fact apply(Fact fact) {
            RDSet rDSet = (RDSet)fact;
            BitString bitString = new BitString(rDSet.reachingDefs.size());
            bitString.or(rDSet.reachingDefs);
            bitString.minus(this.kill);
            bitString.or(this.gen);
            return new RDSet(bitString);
        }

        RDTransferFunction(int n) {
            this.gen = new BitString(n);
            this.kill = new BitString(n);
        }

        RDTransferFunction(BitString bitString, BitString bitString2) {
            this.gen = bitString;
            this.kill = bitString2;
        }
    }

    public static class RDSet
    implements Fact {
        protected final BitString reachingDefs;

        public Fact merge(Fact fact) {
            RDSet rDSet = (RDSet)fact;
            BitString bitString = new BitString(this.reachingDefs.size());
            bitString.or(this.reachingDefs);
            boolean bl = bitString.or(rDSet.reachingDefs);
            if (!bl) {
                return this;
            }
            return new RDSet(bitString);
        }

        public boolean equals(Fact fact) {
            return this.reachingDefs.equals(((RDSet)fact).reachingDefs);
        }

        public String toString() {
            return this.reachingDefs.toString();
        }

        protected RDSet(int n) {
            this.reachingDefs = new BitString(n);
        }

        protected RDSet(BitString bitString) {
            this.reachingDefs = bitString;
        }
    }

    public static class BBComparator
    implements Comparator {
        public static final BBComparator INSTANCE = new BBComparator();

        public int compare(Object object, Object object2) {
            BasicBlock basicBlock;
            BasicBlock basicBlock2;
            if (object == object2) {
                return 0;
            }
            if (object instanceof Pair) {
                basicBlock2 = (BasicBlock)((Pair)object).left;
                if (object2 instanceof Pair) {
                    BasicBlock basicBlock3 = (BasicBlock)((Pair)object).right;
                    BasicBlock basicBlock4 = (BasicBlock)((Pair)object2).left;
                    BasicBlock basicBlock5 = (BasicBlock)((Pair)object2).right;
                    int n = this.compare(basicBlock2, basicBlock4);
                    if (n == 0) {
                        n = this.compare(basicBlock3, basicBlock5);
                    }
                    return n;
                }
                basicBlock = (BasicBlock)object2;
            } else {
                basicBlock2 = (BasicBlock)object;
                basicBlock = object2 instanceof Pair ? (BasicBlock)((Pair)object2).left : (BasicBlock)object2;
            }
            int n = this.compare(basicBlock2, basicBlock);
            if (n == 0) {
                n = object2 instanceof Pair ? 1 : -1;
            }
            return n;
        }

        public int compare(BasicBlock basicBlock, BasicBlock basicBlock2) {
            if (basicBlock == basicBlock2) {
                return 0;
            }
            if (basicBlock.getID() < basicBlock2.getID()) {
                return -1;
            }
            return 1;
        }

        private BBComparator() {
        }
    }
}

