/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Dataflow;

import Compil3r.Dataflow.Fact;
import Compil3r.Dataflow.Problem;
import Util.Collections.Factories;
import Util.Collections.MapFactory;
import Util.Graphs.Graph;
import java.util.Iterator;
import java.util.Map;

public abstract class Solver {
    protected Problem problem;
    protected final MapFactory factory;
    protected Map dataflowValues;

    public boolean direction() {
        return this.problem.direction();
    }

    public abstract Iterator allLocations();

    public abstract Iterator boundaryLocations();

    public void initialize(Problem problem, Graph graph) {
        this.problem = problem;
        problem.initialize(graph);
    }

    public abstract void solve();

    public void reset() {
        this.dataflowValues = null;
    }

    protected void initializeDataflowValueMap() {
        Object e;
        this.dataflowValues = this.factory.makeMap();
        Iterator iterator = this.allLocations();
        while (iterator.hasNext()) {
            e = iterator.next();
            this.dataflowValues.put(e, this.problem.interior());
        }
        iterator = this.boundaryLocations();
        while (iterator.hasNext()) {
            e = iterator.next();
            this.dataflowValues.put(e, this.problem.boundary());
        }
    }

    public Fact getDataflowValue(Object object) {
        return (Fact)this.dataflowValues.get(object);
    }

    protected Solver(MapFactory mapFactory) {
        this.factory = mapFactory;
    }

    protected Solver() {
        this(Factories.hashMapFactory);
    }
}

