/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Compil3r.Quad.ExceptionHandler;
import Compil3r.Quad.ExceptionHandlerList;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadVisitor;
import Util.Assert;
import Util.Collections.BackwardIterator;
import Util.Strings;
import Util.Templates.List;
import Util.Templates.ListIterator;
import Util.Templates.ListWrapper;
import Util.Templates.UnmodifiableList;
import java.util.ArrayList;
import java.util.List;

public class BasicBlock {
    private static final int EXCEPTION_HANDLER_ENTRY = 1;
    private static final int JSR_ENTRY = 2;
    private static final int ENDS_IN_RET = 4;
    private int id_number;
    private final List instructions;
    private final List successors;
    private final List predecessors;
    private ExceptionHandlerList exception_handler_list;
    private int flags;

    static BasicBlock createStartNode() {
        return new BasicBlock();
    }

    static BasicBlock createEndNode(int n) {
        return new BasicBlock(n);
    }

    static BasicBlock createBasicBlock(int n, int n2, int n3, int n4) {
        return new BasicBlock(n, n2, n3, n4, null);
    }

    static BasicBlock createBasicBlock(int n, int n2, int n3, int n4, ExceptionHandlerList exceptionHandlerList) {
        return new BasicBlock(n, n2, n3, n4, exceptionHandlerList);
    }

    public boolean isEntry() {
        boolean bl = false;
        if (this.predecessors == null) {
            bl = true;
        }
        return bl;
    }

    public boolean isExit() {
        boolean bl = false;
        if (this.successors == null) {
            bl = true;
        }
        return bl;
    }

    public ListIterator.Quad iterator() {
        if (this.instructions == null) {
            return ListWrapper.Quad.EmptyIterator.INSTANCE;
        }
        return new ListWrapper.Quad.Iterator(this.instructions.listIterator());
    }

    public ListIterator.Quad backwardIterator() {
        if (this.instructions == null) {
            return ListWrapper.Quad.EmptyIterator.INSTANCE;
        }
        return new ListWrapper.Quad.Iterator(new BackwardIterator(this.instructions.listIterator()));
    }

    public void visitQuads(QuadVisitor quadVisitor) {
        ListIterator.Quad quad = this.iterator();
        while (quad.hasNext()) {
            Quad quad2 = quad.nextQuad();
            quad2.accept(quadVisitor);
        }
    }

    public void backwardVisitQuads(QuadVisitor quadVisitor) {
        ListIterator.Quad quad = this.backwardIterator();
        while (quad.hasNext()) {
            Quad quad2 = quad.nextQuad();
            quad2.accept(quadVisitor);
        }
    }

    public int size() {
        if (this.instructions == null) {
            return 0;
        }
        return this.instructions.size();
    }

    public Quad getQuad(int n) {
        return (Quad)this.instructions.get(n);
    }

    public Quad getLastQuad() {
        if (this.size() == 0) {
            return null;
        }
        return (Quad)this.instructions.get(this.instructions.size() - 1);
    }

    public int getQuadIndex(Quad quad) {
        return this.instructions.indexOf(quad);
    }

    public Quad removeQuad(int n) {
        return (Quad)this.instructions.remove(n);
    }

    public boolean removeQuad(Quad quad) {
        return this.instructions.remove(quad);
    }

    public void removeAllQuads() {
        this.instructions.clear();
    }

    public void addQuad(int n, Quad quad) {
        boolean bl = false;
        if (this.instructions != null) {
            bl = true;
        }
        Assert._assert(bl, "Cannot add instructions to entry/exit basic block");
        this.instructions.add(n, quad);
    }

    public void appendQuad(Quad quad) {
        boolean bl = false;
        if (this.instructions != null) {
            bl = true;
        }
        Assert._assert(bl, "Cannot add instructions to entry/exit basic block");
        this.instructions.add(quad);
    }

    public void addPredecessor(BasicBlock basicBlock) {
        boolean bl = false;
        if (this.predecessors != null) {
            bl = true;
        }
        Assert._assert(bl, "Cannot add predecessor to entry basic block");
        this.predecessors.add(basicBlock);
    }

    public void addSuccessor(BasicBlock basicBlock) {
        boolean bl = false;
        if (this.successors != null) {
            bl = true;
        }
        Assert._assert(bl, "Cannot add successor to exit basic block");
        this.successors.add(basicBlock);
    }

    public boolean removePredecessor(BasicBlock basicBlock) {
        boolean bl = false;
        if (this.predecessors != null) {
            bl = true;
        }
        Assert._assert(bl, "Cannot remove predecessor from entry basic block");
        return this.predecessors.remove(basicBlock);
    }

    public void removePredecessor(int n) {
        boolean bl = false;
        if (this.predecessors != null) {
            bl = true;
        }
        Assert._assert(bl, "Cannot remove predecessor from entry basic block");
        this.predecessors.remove(n);
    }

    public boolean removeSuccessor(BasicBlock basicBlock) {
        boolean bl = false;
        if (this.successors != null) {
            bl = true;
        }
        Assert._assert(bl, "Cannot remove successor from exit basic block");
        return this.successors.remove(basicBlock);
    }

    public void removeSuccessor(int n) {
        boolean bl = false;
        if (this.successors != null) {
            bl = true;
        }
        Assert._assert(bl, "Cannot remove successor from exit basic block");
        this.successors.remove(n);
    }

    public void removeAllPredecessors() {
        boolean bl = false;
        if (this.predecessors != null) {
            bl = true;
        }
        Assert._assert(bl, "Cannot remove predecessors from entry basic block");
        this.predecessors.clear();
    }

    public void removeAllSuccessors() {
        boolean bl = false;
        if (this.successors != null) {
            bl = true;
        }
        Assert._assert(bl, "Cannot remove successors from exit basic block");
        this.successors.clear();
    }

    public int getNumberOfSuccessors() {
        if (this.successors == null) {
            return 0;
        }
        return this.successors.size();
    }

    public int getNumberOfPredecessors() {
        if (this.predecessors == null) {
            return 0;
        }
        return this.predecessors.size();
    }

    public BasicBlock getFallthroughSuccessor() {
        if (this.successors == null) {
            return null;
        }
        return (BasicBlock)this.successors.get(0);
    }

    public BasicBlock getFallthroughPredecessor() {
        if (this.predecessors == null) {
            return null;
        }
        return (BasicBlock)this.predecessors.get(0);
    }

    public List.BasicBlock getSuccessors() {
        if (this.successors == null) {
            return UnmodifiableList.BasicBlock.getEmptyList();
        }
        return new ListWrapper.BasicBlock(this.successors);
    }

    public List.BasicBlock getPredecessors() {
        if (this.predecessors == null) {
            return UnmodifiableList.BasicBlock.getEmptyList();
        }
        return new ListWrapper.BasicBlock(this.predecessors);
    }

    void addExceptionHandler_first(ExceptionHandlerList exceptionHandlerList) {
        exceptionHandlerList.getHandler().addHandledBasicBlock(this);
        boolean bl = false;
        if (exceptionHandlerList.parent == null) {
            bl = true;
        }
        Assert._assert(bl);
        exceptionHandlerList.parent = this.exception_handler_list;
        this.exception_handler_list = exceptionHandlerList;
    }

    ExceptionHandlerList addExceptionHandler(ExceptionHandlerList exceptionHandlerList) {
        exceptionHandlerList.getHandler().addHandledBasicBlock(this);
        if (exceptionHandlerList.parent == this.exception_handler_list) {
            this.exception_handler_list = exceptionHandlerList;
            return this.exception_handler_list;
        }
        this.exception_handler_list = new ExceptionHandlerList(exceptionHandlerList.getHandler(), this.exception_handler_list);
        return this.exception_handler_list;
    }

    void setExceptionHandlerList(ExceptionHandlerList exceptionHandlerList) {
        this.exception_handler_list = exceptionHandlerList;
    }

    public ExceptionHandlerList getExceptionHandlers() {
        if (this.exception_handler_list == null) {
            return ExceptionHandlerList.getEmptyList();
        }
        return this.exception_handler_list;
    }

    public void appendExceptionHandlerList(ExceptionHandlerList exceptionHandlerList) {
        if (exceptionHandlerList == null || exceptionHandlerList.size() == 0) {
            return;
        }
        ExceptionHandlerList exceptionHandlerList2 = this.exception_handler_list;
        if (exceptionHandlerList2 == null) {
            this.exception_handler_list = exceptionHandlerList;
            return;
        }
        while (exceptionHandlerList2 != exceptionHandlerList) {
            ExceptionHandlerList exceptionHandlerList3 = exceptionHandlerList2.getParent();
            if (exceptionHandlerList3 == null) {
                exceptionHandlerList2.setParent(exceptionHandlerList);
                return;
            }
            exceptionHandlerList2 = exceptionHandlerList3;
        }
        return;
    }

    public int getID() {
        return this.id_number;
    }

    public List.BasicBlock getExceptionHandlerEntries() {
        if (this.exception_handler_list == null) {
            return UnmodifiableList.BasicBlock.getEmptyList();
        }
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>(this.exception_handler_list.size());
        ListIterator.ExceptionHandler exceptionHandler = this.exception_handler_list.exceptionHandlerIterator();
        while (exceptionHandler.hasNext()) {
            ExceptionHandler exceptionHandler2 = exceptionHandler.nextExceptionHandler();
            arrayList.add(exceptionHandler2.getEntry());
        }
        return new ListWrapper.BasicBlock(arrayList);
    }

    public boolean isExceptionHandlerEntry() {
        boolean bl = false;
        if ((this.flags & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setExceptionHandlerEntry() {
        this.flags |= 1;
    }

    public boolean isJSREntry() {
        boolean bl = false;
        if ((this.flags & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setJSREntry() {
        this.flags |= 2;
    }

    public boolean endsInRet() {
        Quad quad = this.getLastQuad();
        if (quad == null) {
            return false;
        }
        boolean bl = false;
        if (quad.getOperator() == Operator.Ret.RET.INSTANCE) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        if (this.isEntry()) {
            boolean bl = false;
            if (this.getID() == 0) {
                bl = true;
            }
            Assert._assert(bl);
            return "BB0 (ENTRY)";
        }
        if (this.isExit()) {
            boolean bl = false;
            if (this.getID() == 1) {
                bl = true;
            }
            Assert._assert(bl);
            return "BB1 (EXIT)";
        }
        return "BB" + this.getID();
    }

    public String fullDump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString());
        stringBuffer.append("\t(in: ");
        ListIterator.BasicBlock basicBlock = this.getPredecessors().basicBlockIterator();
        if (!basicBlock.hasNext()) {
            stringBuffer.append("<none>");
        } else {
            stringBuffer.append(basicBlock.nextBasicBlock().toString());
            while (basicBlock.hasNext()) {
                stringBuffer.append(", ");
                stringBuffer.append(basicBlock.nextBasicBlock().toString());
            }
        }
        stringBuffer.append(", out: ");
        basicBlock = this.getSuccessors().basicBlockIterator();
        if (!basicBlock.hasNext()) {
            stringBuffer.append("<none>");
        } else {
            stringBuffer.append(basicBlock.nextBasicBlock().toString());
            while (basicBlock.hasNext()) {
                stringBuffer.append(", ");
                stringBuffer.append(basicBlock.nextBasicBlock().toString());
            }
        }
        stringBuffer.append(')');
        ListIterator.ExceptionHandler exceptionHandler = this.getExceptionHandlers().exceptionHandlerIterator();
        if (exceptionHandler.hasNext()) {
            stringBuffer.append(Strings.lineSep + "\texception handlers: ");
            stringBuffer.append(exceptionHandler.next().toString());
            while (exceptionHandler.hasNext()) {
                stringBuffer.append(", ");
                stringBuffer.append(exceptionHandler.next().toString());
            }
        }
        stringBuffer.append(Strings.lineSep);
        ListIterator.Quad quad = this.iterator();
        while (quad.hasNext()) {
            stringBuffer.append(quad.nextQuad().toString());
            stringBuffer.append(Strings.lineSep);
        }
        stringBuffer.append(Strings.lineSep);
        return stringBuffer.toString();
    }

    private BasicBlock() {
        this.id_number = 0;
        this.instructions = null;
        this.predecessors = null;
        this.successors = new ArrayList(1);
        this.exception_handler_list = null;
    }

    private BasicBlock(int n) {
        this.id_number = 1;
        this.instructions = null;
        this.successors = null;
        this.predecessors = new ArrayList(n);
        this.exception_handler_list = null;
    }

    private BasicBlock(int n, int n2, int n3, int n4, ExceptionHandlerList exceptionHandlerList) {
        this.id_number = n;
        this.predecessors = new ArrayList(n2);
        this.successors = new ArrayList(n3);
        this.instructions = new ArrayList(n4);
        this.exception_handler_list = exceptionHandlerList;
    }
}

