/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Class;
import Clazz.jq_Method;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ExceptionHandler;
import Main.HostedVM;
import Util.Collections.AppendList;
import Util.Graphs.Navigator;
import Util.Graphs.SCCTopSortedGraph;
import Util.Graphs.SCComponent;
import Util.Templates.List;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ControlFlowGraphNavigator
implements Navigator {
    public static final ControlFlowGraphNavigator INSTANCE = new ControlFlowGraphNavigator();
    protected ControlFlowGraph cfg;

    public Collection next(Object object) {
        BasicBlock basicBlock = (BasicBlock)object;
        List.BasicBlock basicBlock2 = basicBlock.getSuccessors();
        List.BasicBlock basicBlock3 = basicBlock.getExceptionHandlerEntries();
        if (this.cfg == null || basicBlock3.isEmpty()) {
            return basicBlock2;
        }
        return new AppendList(basicBlock2, basicBlock3);
    }

    public Collection prev(Object object) {
        BasicBlock basicBlock = (BasicBlock)object;
        List list = basicBlock.getPredecessors();
        if (this.cfg == null || !basicBlock.isExceptionHandlerEntry()) {
            return list;
        }
        Iterator iterator = this.cfg.getExceptionHandlersMatchingEntry(basicBlock);
        while (iterator.hasNext()) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)iterator.next();
            list = new AppendList(list, exceptionHandler.getHandledBasicBlocks());
        }
        return list;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        HostedVM.initialize();
        HashSet<jq_StaticMethod> hashSet = new HashSet<jq_StaticMethod>();
        int n = 0;
        while (n < stringArray.length) {
            object2 = stringArray[n];
            object = (jq_Class)jq_Type.parseType((String)object2);
            ((jq_Class)object).load();
            hashSet.addAll(Arrays.asList(((jq_Class)object).getDeclaredStaticMethods()));
            ++n;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object2 = (jq_Method)iterator.next();
            if (((jq_Method)object2).getBytecode() == null) continue;
            System.out.println("Method " + object2);
            object = CodeCache.getCode((jq_Method)object2);
            ControlFlowGraphNavigator controlFlowGraphNavigator = new ControlFlowGraphNavigator((ControlFlowGraph)object);
            SCComponent sCComponent = SCComponent.buildSCC(((ControlFlowGraph)object).entry(), (Navigator)controlFlowGraphNavigator);
            SCCTopSortedGraph sCCTopSortedGraph = SCCTopSortedGraph.topSort(sCComponent);
            Iterator iterator2 = sCCTopSortedGraph.getFirst().listTopSort().iterator();
            while (iterator2.hasNext()) {
                SCComponent sCComponent2 = (SCComponent)iterator2.next();
                System.out.println(sCComponent2);
            }
        }
    }

    public ControlFlowGraphNavigator(ControlFlowGraph controlFlowGraph) {
        this.cfg = controlFlowGraph;
    }

    protected ControlFlowGraphNavigator() {
    }
}

