/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Class;
import Clazz.jq_Method;
import Clazz.jq_MethodVisitor;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.BasicBlockVisitor;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ExceptionHandler;
import Main.HostedVM;
import Util.BitString;
import Util.Templates.List;
import Util.Templates.ListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Dominators
extends jq_MethodVisitor.EmptyVisitor
implements BasicBlockVisitor {
    public static final boolean TRACE = false;
    public final boolean direction;
    public BitString[] dominators;
    protected boolean change;
    protected ControlFlowGraph cfg;
    protected BasicBlock[] bbs;
    private BitString temp;

    public void visitMethod(jq_Method jq_Method2) {
        if (jq_Method2.getBytecode() == null) {
            return;
        }
        this.cfg = CodeCache.getCode(jq_Method2);
        this.bbs = new BasicBlock[this.cfg.getNumberOfBasicBlocks()];
        this.dominators = new BitString[this.cfg.getNumberOfBasicBlocks()];
        this.temp = new BitString(this.dominators.length);
        int n = this.direction;
        this.dominators[n] = new BitString(this.dominators.length);
        this.dominators[n].setAll();
        this.dominators[1 - n] = new BitString(this.dominators.length);
        this.dominators[1 - n].set(1 - n);
        int n2 = 2;
        while (n2 < this.dominators.length) {
            this.dominators[n2] = new BitString(this.dominators.length);
            this.dominators[n2].setAll();
            ++n2;
        }
        List.BasicBlock basicBlock = this.direction ? this.cfg.reversePostOrder(this.cfg.entry()) : this.cfg.reversePostOrderOnReverseGraph(this.cfg.exit());
        do {
            BasicBlock basicBlock2;
            this.change = false;
            ListIterator.BasicBlock basicBlock3 = basicBlock.basicBlockIterator();
            this.bbs[basicBlock2.getID()] = basicBlock2 = basicBlock3.nextBasicBlock();
            while (basicBlock3.hasNext()) {
                BasicBlock basicBlock4 = basicBlock3.nextBasicBlock();
                this.visitBasicBlock(basicBlock4);
            }
        } while (this.change);
    }

    public void visitBasicBlock(BasicBlock basicBlock) {
        Object object;
        this.bbs[basicBlock.getID()] = basicBlock;
        this.temp.setAll();
        ListIterator.BasicBlock basicBlock2 = this.direction ? basicBlock.getPredecessors().basicBlockIterator() : basicBlock.getSuccessors().basicBlockIterator();
        while (basicBlock2.hasNext()) {
            object = basicBlock2.nextBasicBlock();
            this.temp.and(this.dominators[((BasicBlock)object).getID()]);
        }
        if (this.direction) {
            if (basicBlock.isExceptionHandlerEntry()) {
                object = this.cfg.getExceptionHandlersMatchingEntry(basicBlock);
                while (object.hasNext()) {
                    ExceptionHandler exceptionHandler = (ExceptionHandler)object.next();
                    basicBlock2 = exceptionHandler.getHandledBasicBlocks().basicBlockIterator();
                    while (basicBlock2.hasNext()) {
                        BasicBlock basicBlock3 = basicBlock2.nextBasicBlock();
                        this.temp.and(this.dominators[basicBlock3.getID()]);
                    }
                }
            }
        } else {
            object = basicBlock.getExceptionHandlers().exceptionHandlerIterator();
            while (object.hasNext()) {
                ExceptionHandler exceptionHandler = (ExceptionHandler)object.next();
                BasicBlock basicBlock4 = exceptionHandler.getEntry();
                this.temp.and(this.dominators[basicBlock4.getID()]);
            }
        }
        this.temp.set(basicBlock.getID());
        if (!this.temp.equals(this.dominators[basicBlock.getID()])) {
            this.dominators[basicBlock.getID()].copyBits(this.temp);
            this.change = true;
        }
    }

    public DominatorNode computeTree() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new ArrayList());
        int n = 1;
        while (true) {
            ArrayList<DominatorNode> arrayList2 = new ArrayList<DominatorNode>();
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.dominators.length) {
                if (this.dominators[n2].numberOfOnes() == n) {
                    DominatorNode dominatorNode;
                    bl = true;
                    this.temp.copyBits(this.dominators[n2]);
                    this.temp.clear(n2);
                    DominatorNode dominatorNode2 = null;
                    Iterator iterator = ((ArrayList)arrayList.get(n - 1)).iterator();
                    while (iterator.hasNext()) {
                        dominatorNode = (DominatorNode)iterator.next();
                        if (!this.temp.equals(this.dominators[dominatorNode.getBasicBlock().getID()])) continue;
                        dominatorNode2 = dominatorNode;
                        break;
                    }
                    dominatorNode = new DominatorNode(this.bbs[n2], dominatorNode2);
                    if (dominatorNode2 != null) {
                        dominatorNode2.addChild(dominatorNode);
                    }
                    arrayList2.add(dominatorNode);
                }
                ++n2;
            }
            arrayList.add(arrayList2);
            if (!bl) break;
            ++n;
        }
        DominatorNode dominatorNode = (DominatorNode)((ArrayList)arrayList.get(1)).get(0);
        return dominatorNode;
    }

    public static void main(String[] stringArray) {
        HostedVM.initialize();
        jq_Class jq_Class2 = (jq_Class)jq_Type.parseType(stringArray[0]);
        jq_Class2.load();
        Dominators dominators = new Dominators();
        jq_StaticMethod[] jq_StaticMethodArray = jq_Class2.getDeclaredStaticMethods();
        int n = 0;
        while (n < jq_StaticMethodArray.length) {
            dominators.visitMethod(jq_StaticMethodArray[n]);
            DominatorNode dominatorNode = dominators.computeTree();
            dominatorNode.dumpTree();
            ++n;
        }
    }

    public Dominators(boolean bl) {
        this.direction = bl;
    }

    public Dominators() {
        this(false);
    }

    public static class DominatorNode {
        public final BasicBlock bb;
        public final DominatorNode parent;
        public final ArrayList children;

        public BasicBlock getBasicBlock() {
            return this.bb;
        }

        public DominatorNode getParent() {
            return this.parent;
        }

        public int getNumberOfChildren() {
            return this.children.size();
        }

        public DominatorNode getChild(int n) {
            return (DominatorNode)this.children.get(n);
        }

        public List getChildren() {
            return this.children;
        }

        public void addChild(DominatorNode dominatorNode) {
            this.children.add(dominatorNode);
        }

        public String toString() {
            return this.bb.toString();
        }

        public void dumpTree() {
            System.out.println("Node: " + this.toString());
            System.out.println("Children of :" + this.toString());
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((DominatorNode)iterator.next()).dumpTree();
            }
            System.out.println("End of children of :" + this.toString());
        }

        public DominatorNode(BasicBlock basicBlock, DominatorNode dominatorNode) {
            this.bb = basicBlock;
            this.parent = dominatorNode;
            this.children = new ArrayList();
        }
    }
}

