/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad.IPA;

import Clazz.jq_Method;
import Compil3r.Quad.CallGraph;
import Util.Assert;
import Util.Graphs.Navigator;
import Util.Graphs.SCCTopSortedGraph;
import Util.Graphs.SCComponent;
import Util.Graphs.Traversals;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Solver {
    public static final boolean TIMINGS = false;
    public static final boolean TRACE = false;
    public static final boolean TRACE_WORKLIST = false;
    CallGraph cg;
    Map predecessors;
    Collection roots;

    public abstract boolean visit(jq_Method var1, boolean var2);

    public abstract void dispose(jq_Method var1);

    void go() {
        long l = System.currentTimeMillis();
        Navigator navigator = this.cg.getNavigator();
        this.predecessors = Traversals.buildPredecessorMap(navigator, this.roots);
        Set set = SCComponent.buildSCC(this.roots, navigator);
        SCCTopSortedGraph sCCTopSortedGraph = SCCTopSortedGraph.topSort(set);
        SCComponent sCComponent = sCCTopSortedGraph.getLast();
        while (sCComponent != null) {
            jq_Method jq_Method2;
            Object[] objectArray = sCComponent.nodes();
            boolean bl = false;
            int n = 0;
            while (n < objectArray.length) {
                jq_Method2 = (jq_Method)objectArray[n];
                if (this.visit(jq_Method2, sCComponent.isLoop())) {
                    bl = true;
                }
                ++n;
            }
            if (sCComponent.isLoop() && bl) continue;
            n = 0;
            while (n < objectArray.length) {
                jq_Method2 = (jq_Method)objectArray[n];
                Iterator iterator = navigator.next(jq_Method2).iterator();
                while (iterator.hasNext()) {
                    jq_Method jq_Method3 = (jq_Method)iterator.next();
                    Set set2 = (Set)this.predecessors.get(jq_Method3);
                    boolean bl2 = set2.remove(jq_Method2);
                    Assert._assert(bl2);
                    if (!set2.isEmpty()) continue;
                    this.dispose(jq_Method3);
                }
                ++n;
            }
            sCComponent = sCComponent.prevTopSort();
        }
    }
}

