/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Class;
import Clazz.jq_ClassFileConstants;
import Clazz.jq_FakeInstanceMethod;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_Type;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Quad.CachedCallGraph;
import Compil3r.Quad.CallGraph;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.LoadedCallGraph;
import Compil3r.Quad.Quad;
import Util.Assert;
import Util.Collections.GenericInvertibleMultiMap;
import Util.Collections.GenericMultiMap;
import Util.Collections.InvertibleMultiMap;
import Util.Collections.MapFactory;
import Util.Collections.MultiMap;
import Util.Collections.SetFactory;
import Util.Collections.SortedArraySet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class LoadedCallGraph
extends CallGraph {
    public static Comparator type_comparator = new 1();
    public static Comparator member_comparator = new 2();
    public static Comparator callsite_comparator = new 3();
    public static final MapFactory treeMapFactory = new 4();
    public static final SortedArraySetFactory sortedArraySetFactory = new SortedArraySetFactory();
    protected Set methods = new LinkedHashSet();
    protected Set roots = new LinkedHashSet();
    protected MultiMap callSites = new GenericMultiMap();
    protected InvertibleMultiMap edges = new GenericInvertibleMultiMap();
    protected boolean bcCallSites;

    public static void write(CallGraph callGraph, DataOutput dataOutput) throws IOException {
        jq_ClassFileConstants jq_ClassFileConstants2;
        Assert._assert(callGraph.getAllMethods().containsAll(callGraph.getRoots()));
        GenericMultiMap genericMultiMap = new GenericMultiMap(treeMapFactory, sortedArraySetFactory);
        Iterator<Object> iterator = callGraph.getAllMethods().iterator();
        while (iterator.hasNext()) {
            jq_ClassFileConstants2 = (jq_Method)iterator.next();
            genericMultiMap.add(((jq_Member)jq_ClassFileConstants2).getDeclaringClass(), jq_ClassFileConstants2);
        }
        iterator = genericMultiMap.keySet().iterator();
        while (iterator.hasNext()) {
            jq_ClassFileConstants2 = (jq_Class)iterator.next();
            dataOutput.writeBytes("CLASS " + ((jq_Class)jq_ClassFileConstants2).getJDKName().replace('.', '/') + '\n');
            Iterator iterator2 = genericMultiMap.getValues(jq_ClassFileConstants2).iterator();
            while (iterator2.hasNext()) {
                jq_Method jq_Method2 = (jq_Method)iterator2.next();
                dataOutput.writeBytes(" METHOD " + jq_Method2.getName() + ' ' + jq_Method2.getDesc());
                if (callGraph.getRoots().contains(jq_Method2)) {
                    dataOutput.writeBytes(" ROOT");
                }
                if (jq_Method2 instanceof jq_FakeInstanceMethod) {
                    dataOutput.writeBytes(" FAKE");
                }
                dataOutput.writeByte(10);
                Set set = sortedArraySetFactory.makeSet(callsite_comparator, callGraph.getCallSites(jq_Method2));
                Iterator iterator3 = set.iterator();
                while (iterator3.hasNext()) {
                    ProgramLocation programLocation = (ProgramLocation)iterator3.next();
                    dataOutput.writeBytes("  CALLSITE " + programLocation.getBytecodeIndex() + '\n');
                    Set set2 = sortedArraySetFactory.makeSet(callGraph.getTargetMethods(programLocation));
                    Iterator iterator4 = set2.iterator();
                    while (iterator4.hasNext()) {
                        jq_Method jq_Method3 = (jq_Method)iterator4.next();
                        dataOutput.writeBytes("   TARGET " + jq_Method3.getDeclaringClass().getJDKName().replace('.', '/') + '.' + jq_Method3.getName() + ' ' + jq_Method3.getDesc());
                        if (jq_Method3 instanceof jq_FakeInstanceMethod) {
                            dataOutput.writeBytes(" FAKE");
                        }
                        dataOutput.writeBytes("\n");
                    }
                }
            }
        }
    }

    protected void read(DataInput dataInput) throws IOException {
        StringTokenizer stringTokenizer;
        String string;
        jq_Class jq_Class2 = null;
        jq_Method jq_Method2 = null;
        int n = -1;
        while ((string = dataInput.readLine()) != null && (stringTokenizer = new StringTokenizer(string = string.trim(), ". ")).hasMoreTokens()) {
            Object object;
            boolean bl;
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("CLASS")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IOException();
                }
                string3 = stringTokenizer.nextToken();
                jq_Class2 = (jq_Class)jq_Type.parseType(string3);
                jq_Class2.load();
                continue;
            }
            if (string4.equals("METHOD")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IOException();
                }
                string3 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IOException();
                }
                string2 = stringTokenizer.nextToken();
                boolean bl2 = false;
                bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (((String)object).equals("ROOT")) {
                        bl2 = true;
                    }
                    if (!((String)object).equals("FAKE")) continue;
                    bl = true;
                }
                jq_Method2 = bl ? jq_FakeInstanceMethod.fakeMethod(jq_Class2, string3, string2) : (jq_Method)jq_Class2.getDeclaredMember(string3, string2);
                if (jq_Method2 == null) {
                    System.err.println("Cannot find \"" + string3 + "\" \"" + string2 + "\" in " + jq_Class2);
                    continue;
                }
                this.methods.add(jq_Method2);
                if (!bl2) continue;
                this.roots.add(jq_Method2);
                continue;
            }
            if (string4.equals("CALLSITE")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IOException();
                }
                string3 = stringTokenizer.nextToken();
                n = Integer.parseInt(string3);
                this.bcCallSites = true;
                continue;
            }
            if (!string4.equals("TARGET")) continue;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IOException();
            }
            string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IOException();
            }
            string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IOException();
            }
            String string5 = stringTokenizer.nextToken();
            bl = false;
            if (stringTokenizer.hasMoreTokens() && ((String)(object = stringTokenizer.nextToken())).equals("FAKE")) {
                bl = true;
            }
            object = (jq_Class)jq_Type.parseType(string3);
            ((jq_Class)object).load();
            jq_Method jq_Method3 = bl ? jq_FakeInstanceMethod.fakeMethod((jq_Class)object, string2, string5) : (jq_Method)((jq_Class)object).getDeclaredMember(string2, string5);
            if (jq_Method2 == null) continue;
            if (jq_Method3 == null) {
                System.err.println("Cannot find \"" + string2 + "\" \"" + string5 + "\" in " + object);
                continue;
            }
            boolean bl3 = false;
            if (jq_Method3 != null) {
                bl3 = true;
            }
            Assert._assert(bl3);
            this.add(jq_Method2, n, jq_Method3);
        }
    }

    public void add(jq_Method jq_Method2, int n, jq_Method jq_Method3) {
        ProgramLocation.BCProgramLocation bCProgramLocation = new ProgramLocation.BCProgramLocation(jq_Method2, n);
        this.callSites.add(jq_Method2, bCProgramLocation);
        this.edges.add(bCProgramLocation, jq_Method3);
    }

    public void setRoots(Collection collection) {
        Assert._assert(this.roots.equals(collection));
    }

    public Collection getRoots() {
        return this.roots;
    }

    public Collection getTargetMethods(Object object, ProgramLocation programLocation) {
        if (programLocation instanceof ProgramLocation.QuadProgramLocation) {
            programLocation = LoadedCallGraph.mapCall(programLocation);
        }
        return this.edges.getValues(programLocation);
    }

    public Set entrySet() {
        return this.edges.entrySet();
    }

    public Collection getAllCallSites() {
        return this.edges.keySet();
    }

    public Collection getAllMethods() {
        return this.methods;
    }

    public Collection getCallees(jq_Method jq_Method2) {
        Collection collection = CachedCallGraph.getFromMultiMap(this.callSites, this.edges, jq_Method2);
        return collection;
    }

    public Collection getCallers(jq_Method jq_Method2) {
        MultiMap multiMap = this.edges.invert();
        Collection collection = multiMap.getValues(jq_Method2);
        return collection;
    }

    public Collection getCallerMethods(jq_Method jq_Method2) {
        MultiMap multiMap = this.edges.invert();
        Collection collection = multiMap.getValues(jq_Method2);
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return Collections.EMPTY_SET;
        }
        ProgramLocation programLocation = (ProgramLocation)iterator.next();
        if (!iterator.hasNext()) {
            return Collections.singleton(programLocation.getMethod());
        }
        LinkedHashSet<jq_Method> linkedHashSet = new LinkedHashSet<jq_Method>();
        while (true) {
            linkedHashSet.add(programLocation.getMethod());
            if (!iterator.hasNext()) break;
            programLocation = (ProgramLocation)iterator.next();
        }
        return linkedHashSet;
    }

    public Collection getCallSites(jq_Method jq_Method2) {
        Collection collection = this.callSites.getValues(jq_Method2);
        return collection;
    }

    public Set keySet() {
        return this.edges.keySet();
    }

    public static ProgramLocation mapCall(ProgramLocation programLocation) {
        if (programLocation instanceof ProgramLocation.QuadProgramLocation) {
            Integer n;
            jq_Method jq_Method2 = programLocation.getMethod();
            Map map = CodeCache.getBCMap(jq_Method2);
            Quad quad = ((ProgramLocation.QuadProgramLocation)programLocation).getQuad();
            if (quad == null) {
                Assert.UNREACHABLE("Error: cannot find call site " + programLocation);
            }
            if ((n = (Integer)map.get(quad)) == null) {
                Assert.UNREACHABLE("Error: no mapping for quad " + quad);
            }
            int n2 = n;
            programLocation = new ProgramLocation.BCProgramLocation(jq_Method2, n2);
        }
        return programLocation;
    }

    public LoadedCallGraph(String string) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        this.read(dataInputStream);
    }

    public static class SortedArraySetFactory
    extends SetFactory {
        public Set makeSet(Comparator comparator, Collection collection) {
            Set set = SortedArraySet.FACTORY.makeSet(comparator);
            set.addAll(collection);
            return set;
        }

        public Set makeSet(Collection collection) {
            return this.makeSet(member_comparator, collection);
        }
    }
}

