/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Field;
import Clazz.jq_Method;
import Clazz.jq_Reference;
import Clazz.jq_Type;
import Compil3r.BytecodeAnalysis.BytecodeVisitor;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.Quad;
import Compil3r.Quad.RegisterFactory;
import Memory.Address;
import Memory.HeapAddress;
import Run_Time.Reflection;
import Util.Assert;

public interface Operand {
    public Quad getQuad();

    public void attachToQuad(Quad var1);

    public Operand copy();

    public boolean isSimilar(Operand var1);

    public static abstract class Util {
        public static boolean isNullConstant(Operand operand) {
            boolean bl = false;
            if (operand instanceof AConstOperand && ((AConstOperand)operand).getValue() == null) {
                bl = true;
            }
            return bl;
        }

        public static boolean isConstant(Operand operand) {
            boolean bl = false;
            if (operand instanceof AConstOperand || operand instanceof PConstOperand || operand instanceof IConstOperand || operand instanceof FConstOperand || operand instanceof LConstOperand || operand instanceof DConstOperand) {
                bl = true;
            }
            return bl;
        }
    }

    public static class RegisterOperand
    implements Operand {
        public static final int PRECISE_TYPE = 1;
        private Quad instruction;
        private RegisterFactory.Register register;
        private jq_Type type;
        private int flags;
        public Object scratchObject;

        public RegisterFactory.Register getRegister() {
            return this.register;
        }

        public void setRegister(RegisterFactory.Register register) {
            this.register = register;
        }

        public jq_Type getType() {
            return this.type;
        }

        public void setType(jq_Type jq_Type2) {
            this.type = jq_Type2;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int n) {
            this.flags = n;
        }

        public void meetFlags(int n) {
            this.flags &= n;
        }

        public boolean isExactType() {
            boolean bl = false;
            if ((this.flags & 1) != 0) {
                bl = true;
            }
            return bl;
        }

        public void clearExactType() {
            this.flags &= 0xFFFFFFFE;
        }

        public boolean hasMoreConservativeFlags(RegisterOperand registerOperand) {
            boolean bl = false;
            if (registerOperand.getFlags() == (this.getFlags() | registerOperand.getFlags())) {
                bl = true;
            }
            return bl;
        }

        public Operand copy() {
            return new RegisterOperand(this.register, this.type, this.flags);
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof RegisterOperand && ((RegisterOperand)operand).getRegister() == this.getRegister()) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.register + ' ' + (this.type == null ? "<g>" : this.type.shortName());
        }

        public RegisterOperand(RegisterFactory.Register register, jq_Type jq_Type2) {
            this(register, jq_Type2, 0);
        }

        public RegisterOperand(RegisterFactory.Register register, jq_Type jq_Type2, int n) {
            this.register = register;
            this.type = jq_Type2;
            this.flags = n;
        }
    }

    public static class AConstOperand
    implements Const4Operand {
        private Quad instruction;
        private Object value;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public String toString() {
            if (this.value instanceof String) {
                return "AConst: \"" + this.value + '\"';
            }
            return "AConst: " + this.value;
        }

        public jq_Reference getType() {
            if (this.value == null) {
                return null;
            }
            return Reflection.getTypeOf(this.value);
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public Operand copy() {
            return new AConstOperand(this.value);
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof AConstOperand && ((AConstOperand)operand).getValue() == this.getValue()) {
                bl = true;
            }
            return bl;
        }

        public int getBits() {
            return HeapAddress.addressOf(this.value).to32BitValue();
        }

        public AConstOperand(Object object) {
            this.value = object;
        }
    }

    public static class PConstOperand
    implements Const4Operand {
        private Quad instruction;
        private Address value;

        public Address getValue() {
            return this.value;
        }

        public void setValue(Address address) {
            this.value = address;
        }

        public String toString() {
            return "PConst: " + (this.value == null ? "<null>" : this.value.stringRep());
        }

        public jq_Reference getType() {
            return Address._class;
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public Operand copy() {
            return new PConstOperand(this.value);
        }

        public boolean isSimilar(Operand operand) {
            if (!(operand instanceof PConstOperand)) {
                return false;
            }
            PConstOperand pConstOperand = (PConstOperand)operand;
            boolean bl = false;
            if (this.getValue() == null && (pConstOperand.getValue() == null || pConstOperand.getValue().isNull()) || this.getValue().difference(pConstOperand.getValue()) == 0) {
                bl = true;
            }
            return bl;
        }

        public int getBits() {
            int n = 0;
            if (this.value != null) {
                n = this.value.to32BitValue();
            }
            return n;
        }

        public PConstOperand(Address address) {
            this.value = address;
        }
    }

    public static class IConstOperand
    implements Const4Operand {
        private Quad instruction;
        private int value;

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public String toString() {
            return "IConst: " + this.value;
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public Operand copy() {
            return new IConstOperand(this.value);
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof IConstOperand && ((IConstOperand)operand).getValue() == this.getValue()) {
                bl = true;
            }
            return bl;
        }

        public int getBits() {
            return this.value;
        }

        public IConstOperand(int n) {
            this.value = n;
        }
    }

    public static class FConstOperand
    implements Const4Operand {
        private Quad instruction;
        private float value;

        public float getValue() {
            return this.value;
        }

        public void setValue(float f) {
            this.value = f;
        }

        public String toString() {
            return "FConst: " + this.value;
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public Operand copy() {
            return new FConstOperand(this.value);
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof FConstOperand && ((FConstOperand)operand).getValue() == this.getValue()) {
                bl = true;
            }
            return bl;
        }

        public int getBits() {
            return Float.floatToRawIntBits(this.value);
        }

        public FConstOperand(float f) {
            this.value = f;
        }
    }

    public static class LConstOperand
    implements Const8Operand {
        private Quad instruction;
        private long value;

        public long getValue() {
            return this.value;
        }

        public void setValue(long l) {
            this.value = l;
        }

        public String toString() {
            return "LConst: " + this.value;
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public Operand copy() {
            return new LConstOperand(this.value);
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof LConstOperand && ((LConstOperand)operand).getValue() == this.getValue()) {
                bl = true;
            }
            return bl;
        }

        public long getBits() {
            return this.value;
        }

        public LConstOperand(long l) {
            this.value = l;
        }
    }

    public static class DConstOperand
    implements Const8Operand {
        private Quad instruction;
        private double value;

        public double getValue() {
            return this.value;
        }

        public void setValue(double d) {
            this.value = d;
        }

        public String toString() {
            return "DConst: " + this.value;
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public Operand copy() {
            return new DConstOperand(this.value);
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof DConstOperand && ((DConstOperand)operand).getValue() == this.getValue()) {
                bl = true;
            }
            return bl;
        }

        public long getBits() {
            return Double.doubleToRawLongBits(this.value);
        }

        public DConstOperand(double d) {
            this.value = d;
        }
    }

    public static class UnnecessaryGuardOperand
    implements Operand {
        private Quad instruction;

        public String toString() {
            return "<no guard>";
        }

        public Operand copy() {
            return new UnnecessaryGuardOperand();
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public boolean isSimilar(Operand operand) {
            return operand instanceof UnnecessaryGuardOperand;
        }
    }

    public static class ConditionOperand
    implements Operand {
        private Quad instruction;
        byte condition;

        public byte getCondition() {
            return this.condition;
        }

        public void setCondition(byte by) {
            this.condition = by;
        }

        public String toString() {
            return BytecodeVisitor.cmpopnames[this.condition];
        }

        public Operand copy() {
            return new ConditionOperand(this.condition);
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof ConditionOperand && ((ConditionOperand)operand).getCondition() == this.getCondition()) {
                bl = true;
            }
            return bl;
        }

        public ConditionOperand(byte by) {
            this.condition = by;
        }
    }

    public static class FieldOperand
    implements Operand {
        private Quad instruction;
        jq_Field field;

        public jq_Field getField() {
            return this.field;
        }

        public void setField(jq_Field jq_Field2) {
            this.field = jq_Field2;
        }

        public void resolve() {
            this.field = (jq_Field)this.field.resolve();
        }

        public String toString() {
            return "." + this.field.getName();
        }

        public Operand copy() {
            return new FieldOperand(this.field);
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof FieldOperand && ((FieldOperand)operand).getField() == this.getField()) {
                bl = true;
            }
            return bl;
        }

        public FieldOperand(jq_Field jq_Field2) {
            this.field = jq_Field2;
        }
    }

    public static class TypeOperand
    implements Operand {
        private Quad instruction;
        jq_Type type;

        public jq_Type getType() {
            return this.type;
        }

        public void setType(jq_Type jq_Type2) {
            this.type = jq_Type2;
        }

        public String toString() {
            return this.type.toString();
        }

        public Operand copy() {
            return new TypeOperand(this.type);
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof TypeOperand && ((TypeOperand)operand).getType() == this.getType()) {
                bl = true;
            }
            return bl;
        }

        TypeOperand(jq_Type jq_Type2) {
            this.type = jq_Type2;
        }
    }

    public static class TargetOperand
    implements Operand {
        private Quad instruction;
        BasicBlock target;

        public BasicBlock getTarget() {
            return this.target;
        }

        public void setTarget(BasicBlock basicBlock) {
            this.target = basicBlock;
        }

        public String toString() {
            return this.target.toString();
        }

        public Operand copy() {
            return new TargetOperand(this.target);
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof TargetOperand && ((TargetOperand)operand).getTarget() == this.getTarget()) {
                bl = true;
            }
            return bl;
        }

        public TargetOperand(BasicBlock basicBlock) {
            this.target = basicBlock;
        }
    }

    public static class MethodOperand
    implements Operand {
        private Quad instruction;
        jq_Method target;

        public jq_Method getMethod() {
            return this.target;
        }

        public void setMethod(jq_Method jq_Method2) {
            this.target = jq_Method2;
        }

        public void resolve() {
            this.target = (jq_Method)this.target.resolve();
        }

        public String toString() {
            return this.target.toString();
        }

        public Operand copy() {
            return new MethodOperand(this.target);
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand instanceof MethodOperand && ((MethodOperand)operand).getMethod() == this.getMethod()) {
                bl = true;
            }
            return bl;
        }

        public MethodOperand(jq_Method jq_Method2) {
            this.target = jq_Method2;
        }
    }

    public static class IntValueTableOperand
    implements Operand {
        private Quad instruction;
        int[] table;

        public void set(int n, int n2) {
            this.table[n] = n2;
        }

        public int get(int n) {
            return this.table[n];
        }

        public int size() {
            return this.table.length;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("{ ");
            if (this.table.length > 0) {
                stringBuffer.append(this.table[0]);
                int n = 1;
                while (n < this.table.length) {
                    stringBuffer.append(", ");
                    stringBuffer.append(this.table[n]);
                    ++n;
                }
            }
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }

        public Operand copy() {
            int[] nArray = new int[this.table.length];
            System.arraycopy(this.table, 0, nArray, 0, nArray.length);
            return new IntValueTableOperand(nArray);
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public boolean isSimilar(Operand operand) {
            return false;
        }

        public IntValueTableOperand(int[] nArray) {
            this.table = nArray;
        }
    }

    public static class BasicBlockTableOperand
    implements Operand {
        private Quad instruction;
        BasicBlock[] table;

        public void set(int n, BasicBlock basicBlock) {
            this.table[n] = basicBlock;
        }

        public BasicBlock get(int n) {
            return this.table[n];
        }

        public int size() {
            return this.table.length;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("{ ");
            if (this.table.length > 0) {
                stringBuffer.append(this.table[0]);
                int n = 1;
                while (n < this.table.length) {
                    stringBuffer.append(", ");
                    stringBuffer.append(this.table[n]);
                    ++n;
                }
            }
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }

        public Operand copy() {
            BasicBlock[] basicBlockArray = new BasicBlock[this.table.length];
            System.arraycopy(this.table, 0, basicBlockArray, 0, basicBlockArray.length);
            return new BasicBlockTableOperand(basicBlockArray);
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public boolean isSimilar(Operand operand) {
            return false;
        }

        public BasicBlockTableOperand(BasicBlock[] basicBlockArray) {
            this.table = basicBlockArray;
        }
    }

    public static class ParamListOperand
    implements Operand {
        private Quad instruction;
        RegisterOperand[] params;

        public void set(int n, RegisterOperand registerOperand) {
            this.params[n] = registerOperand;
        }

        public RegisterOperand get(int n) {
            return this.params[n];
        }

        public int length() {
            return this.params.length;
        }

        public int words() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.params.length) {
                ++n;
                if (this.params[n2].getType().getReferenceSize() == 8) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("(");
            if (this.params.length > 0) {
                stringBuffer.append(this.params[0]);
                int n = 1;
                while (n < this.params.length) {
                    stringBuffer.append(", ");
                    stringBuffer.append(this.params[n]);
                    ++n;
                }
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public Operand copy() {
            RegisterOperand[] registerOperandArray = new RegisterOperand[this.params.length];
            int n = 0;
            while (n < registerOperandArray.length) {
                registerOperandArray[n] = (RegisterOperand)this.params[n].copy();
                ++n;
            }
            return new ParamListOperand(registerOperandArray);
        }

        public void attachToQuad(Quad quad) {
            boolean bl = false;
            if (this.instruction == null) {
                bl = true;
            }
            Assert._assert(bl);
            this.instruction = quad;
        }

        public Quad getQuad() {
            return this.instruction;
        }

        public boolean isSimilar(Operand operand) {
            return false;
        }

        public ParamListOperand(RegisterOperand[] registerOperandArray) {
            this.params = registerOperandArray;
        }
    }

    public static interface Const4Operand
    extends Operand {
        public int getBits();
    }

    public static interface Const8Operand
    extends Operand {
        public long getBits();
    }
}

