/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Class;
import Compil3r.CompilationState;
import Compil3r.Quad.Operand;
import Compil3r.Quad.Operator;
import Compil3r.Quad.QuadVisitor;
import Interpreter.QuadInterpreter;
import Util.Strings;
import Util.Templates.List;
import Util.Templates.UnmodifiableList;

public class Quad {
    public static final boolean DETERMINISTIC = true;
    private Operator operator;
    private Operand operand1;
    private Operand operand2;
    private Operand operand3;
    private Operand operand4;
    private int id_number;

    Operand getOp1() {
        return this.operand1;
    }

    Operand getOp2() {
        return this.operand2;
    }

    Operand getOp3() {
        return this.operand3;
    }

    Operand getOp4() {
        return this.operand4;
    }

    public void setOp1(Operand operand) {
        this.operand1 = operand;
    }

    public void setOp2(Operand operand) {
        this.operand2 = operand;
    }

    public void setOp3(Operand operand) {
        this.operand3 = operand;
    }

    public void setOp4(Operand operand) {
        this.operand4 = operand;
    }

    public Quad copy(int n) {
        Operand operand = this.operand1 != null ? this.operand1.copy() : null;
        Operand operand2 = this.operand2 != null ? this.operand2.copy() : null;
        Operand operand3 = this.operand3 != null ? this.operand3.copy() : null;
        Operand operand4 = this.operand4 != null ? this.operand4.copy() : null;
        return new Quad(n, this.operator, operand, operand2, operand3, operand4);
    }

    public UnmodifiableList.Operand getAllOperands() {
        int n = 0;
        if (this.operand1 != null) {
            ++n;
        }
        if (this.operand2 != null) {
            n += 2;
        }
        if (this.operand3 != null) {
            n += 4;
        }
        if (this.operand4 != null) {
            n += 8;
        }
        switch (n) {
            case 0: {
                return UnmodifiableList.Operand.EMPTY;
            }
            case 1: {
                return new UnmodifiableList.Operand(this.operand1);
            }
            case 2: {
                return new UnmodifiableList.Operand(this.operand2);
            }
            case 3: {
                return new UnmodifiableList.Operand(this.operand1, this.operand2);
            }
            case 4: {
                return new UnmodifiableList.Operand(this.operand3);
            }
            case 5: {
                return new UnmodifiableList.Operand(this.operand1, this.operand3);
            }
            case 6: {
                return new UnmodifiableList.Operand(this.operand2, this.operand3);
            }
            case 7: {
                return new UnmodifiableList.Operand(this.operand1, this.operand2, this.operand3);
            }
            case 8: {
                return new UnmodifiableList.Operand(this.operand4);
            }
            case 9: {
                return new UnmodifiableList.Operand(this.operand1, this.operand4);
            }
            case 10: {
                return new UnmodifiableList.Operand(this.operand2, this.operand4);
            }
            case 11: {
                return new UnmodifiableList.Operand(this.operand1, this.operand2, this.operand4);
            }
            case 12: {
                return new UnmodifiableList.Operand(this.operand3, this.operand4);
            }
            case 13: {
                return new UnmodifiableList.Operand(this.operand1, this.operand3, this.operand4);
            }
            case 14: {
                return new UnmodifiableList.Operand(this.operand2, this.operand3, this.operand4);
            }
        }
        return new UnmodifiableList.Operand(this.operand1, this.operand2, this.operand3, this.operand4);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void accept(QuadVisitor quadVisitor) {
        this.operator.accept(this, quadVisitor);
    }

    public int getID() {
        return this.id_number;
    }

    public List.jq_Class getThrownExceptions() {
        Operand operand;
        if (this.operator == Operator.Return.THROW_A.INSTANCE && (operand = Operator.Return.getSrc(this)) instanceof Operand.RegisterOperand) {
            return new UnmodifiableList.jq_Class((jq_Class)((Operand.RegisterOperand)operand).getType());
        }
        return CompilationState.DEFAULT.getThrownExceptions(this);
    }

    public List.RegisterOperand getDefinedRegisters() {
        return this.operator.getDefinedRegisters(this);
    }

    public List.RegisterOperand getUsedRegisters() {
        return this.operator.getUsedRegisters(this);
    }

    public void interpret(QuadInterpreter quadInterpreter) {
        this.operator.interpret(this, quadInterpreter);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Strings.left(Integer.toString(this.id_number), 4));
        stringBuffer.append(Strings.left(this.operator.toString(), 24));
        if (this.operand1 == null) {
            if (this.operand2 == null) {
                return stringBuffer.toString();
            }
            stringBuffer.append("    \t");
        } else {
            stringBuffer.append(this.operand1.toString());
            if (this.operand2 == null) {
                return stringBuffer.toString();
            }
            stringBuffer.append(",\t");
        }
        stringBuffer.append(this.operand2.toString());
        if (this.operand3 == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(",\t");
        stringBuffer.append(this.operand3.toString());
        if (this.operand4 == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(",\t");
        stringBuffer.append(this.operand4.toString());
        return stringBuffer.toString();
    }

    public String toString_short() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Strings.left(Integer.toString(this.id_number), 4));
        stringBuffer.append(this.operator.toString());
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.getID();
    }

    Quad(int n, Operator operator) {
        this.id_number = n;
        this.operator = operator;
    }

    Quad(int n, Operator operator, Operand operand) {
        this.id_number = n;
        this.operator = operator;
        this.operand1 = operand;
    }

    Quad(int n, Operator operator, Operand operand, Operand operand2) {
        this.id_number = n;
        this.operator = operator;
        this.operand1 = operand;
        this.operand2 = operand2;
    }

    Quad(int n, Operator operator, Operand operand, Operand operand2, Operand operand3) {
        this.id_number = n;
        this.operator = operator;
        this.operand1 = operand;
        this.operand2 = operand2;
        this.operand3 = operand3;
    }

    Quad(int n, Operator operator, Operand operand, Operand operand2, Operand operand3, Operand operand4) {
        this.id_number = n;
        this.operator = operator;
        this.operand1 = operand;
        this.operand2 = operand2;
        this.operand3 = operand3;
        this.operand4 = operand4;
    }
}

