/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Class;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ExceptionHandler;
import Compil3r.Quad.Quad;
import Util.Graphs.Navigator;
import Util.Templates.List;
import Util.Templates.ListIterator;
import Util.Templates.UnmodifiableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class QuadIterator
implements ListIterator.Quad {
    protected final ControlFlowGraph cfg;
    protected final ListIterator.BasicBlock rpoBasicBlocks;
    protected BasicBlock previousBasicBlock;
    protected BasicBlock currentBasicBlock;
    protected BasicBlock nextBasicBlock;
    protected ListIterator.Quad quadsInCurrentBasicBlock;
    protected int lastIndex;
    protected Quad lastQuad;

    protected void updateNextBB() {
        do {
            if (!this.rpoBasicBlocks.hasNext()) {
                this.nextBasicBlock = null;
                break;
            }
            this.nextBasicBlock = this.rpoBasicBlocks.nextBasicBlock();
        } while (this.nextBasicBlock.size() <= 0);
    }

    protected void updatePreviousBB() {
        BasicBlock basicBlock;
        while ((basicBlock = this.rpoBasicBlocks.previousBasicBlock()) != this.previousBasicBlock) {
        }
        do {
            if (!this.rpoBasicBlocks.hasPrevious()) {
                this.previousBasicBlock = null;
                break;
            }
            this.previousBasicBlock = this.rpoBasicBlocks.previousBasicBlock();
        } while (this.previousBasicBlock.size() <= 0);
        while ((basicBlock = this.rpoBasicBlocks.nextBasicBlock()) != this.nextBasicBlock) {
        }
    }

    public BasicBlock getCurrentBasicBlock() {
        return this.currentBasicBlock;
    }

    public Quad getCurrentQuad() {
        return this.lastQuad;
    }

    public Quad nextQuad() {
        if (!this.quadsInCurrentBasicBlock.hasNext()) {
            if (this.nextBasicBlock == null) {
                throw new NoSuchElementException();
            }
            this.previousBasicBlock = this.currentBasicBlock;
            this.currentBasicBlock = this.nextBasicBlock;
            this.quadsInCurrentBasicBlock = this.currentBasicBlock.iterator();
            this.updateNextBB();
        }
        ++this.lastIndex;
        this.lastQuad = this.quadsInCurrentBasicBlock.nextQuad();
        return this.lastQuad;
    }

    public Object next() {
        return this.nextQuad();
    }

    public boolean hasNext() {
        if (this.quadsInCurrentBasicBlock.hasNext()) {
            return true;
        }
        boolean bl = false;
        if (this.nextBasicBlock != null) {
            bl = true;
        }
        return bl;
    }

    protected Quad getFirstQuad(BasicBlock basicBlock) {
        while (!basicBlock.isExit()) {
            if (basicBlock.size() > 0) {
                return basicBlock.getQuad(0);
            }
            basicBlock = basicBlock.getFallthroughSuccessor();
        }
        return null;
    }

    protected Quad getLastQuad(BasicBlock basicBlock) {
        while (!basicBlock.isEntry()) {
            if (basicBlock.size() > 0) {
                return basicBlock.getLastQuad();
            }
            if (basicBlock.getPredecessors().isEmpty()) {
                return null;
            }
            basicBlock = basicBlock.getFallthroughPredecessor();
        }
        return null;
    }

    public void set(Object object) {
        this.quadsInCurrentBasicBlock.set(object);
    }

    public int nextIndex() {
        return this.lastIndex + 1;
    }

    public Quad previousQuad() {
        if (!this.quadsInCurrentBasicBlock.hasPrevious()) {
            if (this.previousBasicBlock == null) {
                throw new NoSuchElementException();
            }
            this.nextBasicBlock = this.currentBasicBlock;
            this.currentBasicBlock = this.previousBasicBlock;
            this.quadsInCurrentBasicBlock = this.currentBasicBlock.iterator();
            while (this.quadsInCurrentBasicBlock.hasNext()) {
                this.quadsInCurrentBasicBlock.nextQuad();
            }
            this.updatePreviousBB();
        }
        this.lastQuad = this.quadsInCurrentBasicBlock.previousQuad();
        --this.lastIndex;
        return this.lastQuad;
    }

    public Object previous() {
        return this.previousQuad();
    }

    public void remove() {
        this.quadsInCurrentBasicBlock.remove();
        this.lastQuad = null;
        --this.lastIndex;
    }

    public int previousIndex() {
        return this.lastIndex;
    }

    public boolean hasPrevious() {
        if (this.quadsInCurrentBasicBlock.hasPrevious()) {
            return true;
        }
        boolean bl = false;
        if (this.previousBasicBlock != null) {
            bl = true;
        }
        return bl;
    }

    public void add(Object object) {
        this.quadsInCurrentBasicBlock.add(object);
        this.lastQuad = null;
        ++this.lastIndex;
    }

    public Iterator successors() {
        return this.successors1().iterator();
    }

    public Collection successors1() {
        Object object;
        if (this.lastQuad == null) {
            throw new IllegalStateException();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        ListIterator.jq_Class jq_Class2 = this.lastQuad.getThrownExceptions().classIterator();
        while (jq_Class2.hasNext()) {
            object = jq_Class2.nextClass();
            ListIterator.ExceptionHandler exceptionHandler = this.currentBasicBlock.getExceptionHandlers().mayCatch((jq_Class)object).exceptionHandlerIterator();
            while (exceptionHandler.hasNext()) {
                ExceptionHandler exceptionHandler2 = exceptionHandler.nextExceptionHandler();
                hashSet.add(this.getFirstQuad(exceptionHandler2.getEntry()));
            }
            if (this.currentBasicBlock.getExceptionHandlers().mustCatch((jq_Class)object) != null) continue;
            hashSet.add(null);
        }
        if (this.quadsInCurrentBasicBlock.hasNext()) {
            object = this.quadsInCurrentBasicBlock.nextQuad();
            if (object != this.lastQuad) {
                hashSet.add(object);
                this.quadsInCurrentBasicBlock.previousQuad();
                return hashSet;
            }
            if (this.quadsInCurrentBasicBlock.hasNext()) {
                object = this.quadsInCurrentBasicBlock.nextQuad();
                hashSet.add(object);
                this.quadsInCurrentBasicBlock.previousQuad();
                this.quadsInCurrentBasicBlock.previousQuad();
                return hashSet;
            }
            this.quadsInCurrentBasicBlock.previousQuad();
        }
        object = this.currentBasicBlock.getSuccessors().basicBlockIterator();
        while (object.hasNext()) {
            hashSet.add(this.getFirstQuad(object.nextBasicBlock()));
        }
        return hashSet;
    }

    public Iterator predecessors() {
        return this.predecessors1().iterator();
    }

    public Collection predecessors1() {
        if (this.lastQuad == null) {
            throw new IllegalStateException();
        }
        if (this.quadsInCurrentBasicBlock.hasPrevious()) {
            Quad quad = this.quadsInCurrentBasicBlock.previousQuad();
            if (quad != this.lastQuad) {
                this.quadsInCurrentBasicBlock.nextQuad();
                return new UnmodifiableList.Quad(quad);
            }
            if (this.quadsInCurrentBasicBlock.hasPrevious()) {
                quad = this.quadsInCurrentBasicBlock.previousQuad();
                this.quadsInCurrentBasicBlock.nextQuad();
                this.quadsInCurrentBasicBlock.nextQuad();
                return new UnmodifiableList.Quad(quad);
            }
            this.quadsInCurrentBasicBlock.nextQuad();
        }
        HashSet<Quad> hashSet = new HashSet<Quad>();
        ListIterator.BasicBlock basicBlock = this.currentBasicBlock.getPredecessors().basicBlockIterator();
        while (basicBlock.hasNext()) {
            hashSet.add(this.getLastQuad(basicBlock.nextBasicBlock()));
        }
        if (this.currentBasicBlock.isExceptionHandlerEntry()) {
            Iterator iterator = this.cfg.getExceptionHandlersMatchingEntry(this.currentBasicBlock);
            while (iterator.hasNext()) {
                ExceptionHandler exceptionHandler = (ExceptionHandler)iterator.next();
                ListIterator.BasicBlock basicBlock2 = exceptionHandler.getHandledBasicBlocks().basicBlockIterator();
                while (basicBlock2.hasNext()) {
                    BasicBlock basicBlock3 = basicBlock2.nextBasicBlock();
                    QuadIterator.addQuadsThatReachHandler(basicBlock3, hashSet, exceptionHandler);
                }
            }
        }
        return hashSet;
    }

    private static final void addQuadsThatReachHandler(BasicBlock basicBlock, Set set, ExceptionHandler exceptionHandler) {
        ListIterator.Quad quad = basicBlock.iterator();
        while (quad.hasNext()) {
            Quad quad2 = quad.nextQuad();
            ListIterator.jq_Class jq_Class2 = quad2.getThrownExceptions().classIterator();
            while (jq_Class2.hasNext()) {
                jq_Class jq_Class3 = (jq_Class)jq_Class2.next();
                List.ExceptionHandler exceptionHandler2 = basicBlock.getExceptionHandlers().mayCatch(jq_Class3);
                if (!exceptionHandler2.contains(exceptionHandler)) continue;
                set.add(quad2);
            }
        }
    }

    public Navigator getNavigator() {
        return new Navigator(this){
            final /* synthetic */ QuadIterator this$0;

            public final Collection next(Object object) {
                if (object == this.this$0.lastQuad) {
                    return this.this$0.successors1();
                }
                return this.search(object, true);
            }

            public final Collection prev(Object object) {
                if (object == this.this$0.lastQuad) {
                    return this.this$0.predecessors1();
                }
                return this.search(object, false);
            }

            private final Collection search(Object object, boolean bl) {
                Quad quad = this.this$0.lastQuad;
                Collection collection = null;
                if (this.this$0.searchBackward(object)) {
                    collection = bl ? this.this$0.successors1() : this.this$0.predecessors1();
                }
                this.this$0.searchForward(quad);
                if (collection == null) {
                    if (this.this$0.searchForward(object)) {
                        Collection collection2 = collection = bl ? this.this$0.successors1() : this.this$0.predecessors1();
                    }
                    if (collection == null) {
                        throw new UnsupportedOperationException();
                    }
                    this.this$0.searchBackward(quad);
                }
                return collection;
            }
            {
                this.this$0 = quadIterator;
            }
        };
    }

    public boolean searchForward(Object object) {
        while (this.hasNext()) {
            if (object != this.nextQuad()) continue;
            return true;
        }
        return false;
    }

    public boolean searchBackward(Object object) {
        while (this.hasPrevious()) {
            if (object != this.previousQuad()) continue;
            return true;
        }
        return false;
    }

    public QuadIterator(ControlFlowGraph controlFlowGraph) {
        this(controlFlowGraph, true);
    }

    public QuadIterator(ControlFlowGraph controlFlowGraph, boolean bl) {
        this.cfg = controlFlowGraph;
        this.rpoBasicBlocks = bl ? controlFlowGraph.reversePostOrderIterator() : controlFlowGraph.postOrderOnReverseGraphIterator();
        this.rpoBasicBlocks.nextBasicBlock();
        this.previousBasicBlock = null;
        this.currentBasicBlock = this.rpoBasicBlocks.nextBasicBlock();
        this.updateNextBB();
        this.quadsInCurrentBasicBlock = this.currentBasicBlock.iterator();
        if (!bl) {
            while (this.hasNext()) {
                this.nextQuad();
            }
        }
        this.lastIndex = -1;
        this.lastQuad = null;
    }
}

