/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Class;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Compil3r.Quad.CHACallGraph;
import Compil3r.Quad.CachedCallGraph;
import Compil3r.Quad.CallGraph;
import Main.HostedVM;
import Util.Graphs.CountPaths;
import Util.Graphs.Navigator;
import Util.Graphs.SCCTopSortedGraph;
import Util.Graphs.SCComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class RootedCHACallGraph
extends CHACallGraph {
    Collection roots;

    public Collection getRoots() {
        return this.roots;
    }

    public void setRoots(Collection collection) {
        this.roots = collection;
    }

    public static void main(String[] stringArray) {
        HostedVM.initialize();
        jq_Class jq_Class2 = (jq_Class)jq_Type.parseType(stringArray[0]);
        jq_Class2.prepare();
        System.out.print("Building call graph...");
        long l = System.currentTimeMillis();
        CallGraph callGraph = new RootedCHACallGraph();
        callGraph = new CachedCallGraph(callGraph);
        List<jq_StaticMethod> list = Arrays.asList(jq_Class2.getDeclaredStaticMethods());
        callGraph.setRoots(list);
        l = System.currentTimeMillis() - l;
        System.out.println("done. (" + (double)l / 1000.0 + " seconds)");
        RootedCHACallGraph.test(callGraph);
    }

    public static void test(CallGraph callGraph) {
        System.out.print("Building navigator...");
        long l = System.currentTimeMillis();
        Navigator navigator = callGraph.getNavigator();
        l = System.currentTimeMillis() - l;
        System.out.println("done. (" + (double)l / 1000.0 + " seconds)");
        System.out.print("Building strongly-connected components...");
        l = System.currentTimeMillis();
        Set set = SCComponent.buildSCC(callGraph.getRoots(), navigator);
        l = System.currentTimeMillis() - l;
        System.out.println("done. (" + (double)l / 1000.0 + " seconds)");
        System.out.print("Topologically sorting strongly-connected components...");
        l = System.currentTimeMillis();
        SCCTopSortedGraph sCCTopSortedGraph = SCCTopSortedGraph.topSort(set);
        l = System.currentTimeMillis() - l;
        System.out.println("done. (" + (double)l / 1000.0 + " seconds)");
        System.out.println("Number of paths (k=infinity) = " + CountPaths.countPaths(sCCTopSortedGraph.getNavigator(), set));
    }

    public RootedCHACallGraph() {
    }

    public RootedCHACallGraph(Set set) {
        super(set);
    }
}

