/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad.x86;

import Allocator.CodeAllocator;
import Allocator.DefaultCodeAllocator;
import Allocator.DefaultHeapAllocator;
import Allocator.HeapAllocator;
import Assembler.x86.Code2CodeReference;
import Assembler.x86.Code2HeapReference;
import Assembler.x86.DirectBindCall;
import Assembler.x86.x86;
import Assembler.x86.x86Assembler;
import Assembler.x86.x86Constants;
import Bootstrap.BootImage;
import Bootstrap.BootstrapCodeAddress;
import Bootstrap.BootstrapCodeAllocator;
import Bootstrap.BootstrapHeapAddress;
import Bootstrap.ObjectTraverser;
import ClassLib.ClassLibInterface;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_CompiledCode;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Clazz.jq_TryCatch;
import Clazz.jq_Type;
import Compil3r.Compil3rInterface;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.BasicBlockVisitor;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ExceptionHandler;
import Compil3r.Quad.ExceptionHandlerList;
import Compil3r.Quad.Operand;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadIterator;
import Compil3r.Quad.QuadVisitor;
import Compil3r.Quad.RegisterFactory;
import Compil3r.Quad.x86.x86QuadExceptionDeliverer;
import Compil3r.Reference.x86.x86ReferenceLinker;
import Main.HostedVM;
import Main.jq;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Run_Time.ExceptionDeliverer;
import Run_Time.MathSupport;
import Run_Time.Monitor;
import Run_Time.Reflection;
import Run_Time.SystemInterface;
import Run_Time.TypeCheck;
import Run_Time.Unsafe;
import Util.Assert;
import Util.Collections.AppendIterator;
import Util.Strings;
import Util.Templates.ListIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleCompiler
implements x86Constants,
BasicBlockVisitor,
QuadVisitor {
    public static boolean ALWAYS_TRACE = false;
    public static boolean TRACE_STUBS = false;
    public static final Set TraceMethod_MethodNames = new HashSet();
    public static final Set TraceMethod_ClassNames = new HashSet();
    public static final Set TraceQuad_MethodNames = new HashSet();
    public static final Set TraceQuad_ClassNames = new HashSet();
    public static final int DEFAULT_ALIGNMENT = 32;
    public static byte THREAD_BLOCK_PREFIX = (byte)100;
    public static int THREAD_BLOCK_OFFSET = 20;
    public boolean TraceQuads;
    public boolean TraceMethods;
    public boolean TraceArguments;
    public ControlFlowGraph cfg;
    public jq_Method method;
    public Map registerLocations;
    public boolean TRACE;
    private x86Assembler asm;
    private int n_paramwords;
    private List code_relocs;
    private List data_relocs;
    boolean handled;

    public void init(jq_Method jq_Method2) {
        this.init(CodeCache.getCode(jq_Method2));
    }

    public void init(ControlFlowGraph controlFlowGraph) {
        this.cfg = controlFlowGraph;
        this.method = controlFlowGraph.getMethod();
        this.TRACE = ALWAYS_TRACE;
        if (TraceQuad_MethodNames.contains(this.method.getName().toString())) {
            this.TraceQuads = true;
            this.TraceMethods = true;
        } else if (TraceQuad_ClassNames.contains(this.method.getDeclaringClass().getName().toString())) {
            this.TraceQuads = true;
            this.TraceMethods = true;
        } else if (TraceMethod_MethodNames.contains(this.method.getName().toString())) {
            this.TraceQuads = false;
            this.TraceMethods = true;
        } else if (TraceMethod_ClassNames.contains(this.method.getDeclaringClass().getName().toString())) {
            this.TraceQuads = false;
            this.TraceMethods = true;
        } else {
            this.TraceQuads = false;
            this.TraceMethods = false;
        }
        this.TraceArguments = false;
        this.registerLocations = new HashMap();
        this.code_relocs = new LinkedList();
        this.data_relocs = new LinkedList();
    }

    public String toString() {
        return "x86Quad/" + Strings.left(this.method.getName().toString(), 10);
    }

    public final void emitCallRelative(jq_Method jq_Method2) {
        SimpleCompiler.emitCallRelative(jq_Method2, this.asm, this.code_relocs);
    }

    public static final void emitCallRelative(jq_Method jq_Method2, x86Assembler x86Assembler2, List list) {
        x86Assembler2.emitCALL_rel32(x86.CALL_rel32, 0);
        DirectBindCall directBindCall = new DirectBindCall((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), jq_Method2);
        list.add(directBindCall);
        if (ALWAYS_TRACE) {
            System.out.println("Direct bind call: " + directBindCall);
        }
    }

    public final void emitPushAddressOf(Object object) {
        SimpleCompiler.emitPushAddressOf(object, this.asm, this.data_relocs);
    }

    public static final void emitPushAddressOf(Object object, x86Assembler x86Assembler2, List list) {
        if (object != null) {
            HeapAddress heapAddress = HeapAddress.addressOf(object);
            x86Assembler2.emit1_Imm32(x86.PUSH_i32, heapAddress.to32BitValue());
            Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
            list.add(code2HeapReference);
            if (ALWAYS_TRACE) {
                System.out.println("Code2Heap reference: " + code2HeapReference);
            }
        } else {
            x86Assembler2.emit1_Imm8(x86.PUSH_i8, (byte)0);
        }
    }

    public final void emitPushMemory(jq_StaticField jq_StaticField2) {
        SimpleCompiler.emitPushMemory(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitPushMemory(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.PUSH_m, heapAddress.to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final void emitPushMemory8(jq_StaticField jq_StaticField2) {
        SimpleCompiler.emitPushMemory8(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitPushMemory8(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.PUSH_m, heapAddress.offset(4).to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), (HeapAddress)heapAddress.offset(4));
        list.add(code2HeapReference);
        x86Assembler2.emit2_Mem(x86.PUSH_m, heapAddress.to32BitValue());
        code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final void emitPopMemory(jq_StaticField jq_StaticField2) {
        SimpleCompiler.emitPopMemory(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitPopMemory(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.POP_m, heapAddress.to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final void emitPopMemory8(jq_StaticField jq_StaticField2) {
        SimpleCompiler.emitPopMemory8(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitPopMemory8(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.POP_m, heapAddress.to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
        x86Assembler2.emit2_Mem(x86.POP_m, heapAddress.offset(4).to32BitValue());
        code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), (HeapAddress)heapAddress.offset(4));
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final void emitCallMemory(jq_StaticField jq_StaticField2) {
        SimpleCompiler.emitCallMemory(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitCallMemory(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.CALL_m, heapAddress.to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final void emitFLD64(jq_StaticField jq_StaticField2) {
        SimpleCompiler.emitFLD64(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitFLD64(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.FLD_m64, heapAddress.to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final List getCodeRelocs() {
        return this.code_relocs;
    }

    public final List getDataRelocs() {
        return this.data_relocs;
    }

    public static final jq_CompiledCode generate_compile_stub(jq_Method jq_Method2) {
        if (TRACE_STUBS) {
            System.out.println("x86 Quad Compiler: generating compile stub for " + jq_Method2);
        }
        x86Assembler x86Assembler2 = new x86Assembler(0, 24, 0, 32);
        x86Assembler2.setEntrypoint();
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        if (TRACE_STUBS) {
            SimpleCompiler.emitPushAddressOf(SystemInterface.toCString("Stub compile: " + jq_Method2), x86Assembler2, linkedList2);
            SimpleCompiler.emitCallMemory(SystemInterface._debugwriteln, x86Assembler2, linkedList2);
        }
        SimpleCompiler.emitPushAddressOf(jq_Method2, x86Assembler2, linkedList2);
        SimpleCompiler.emitCallRelative(jq_Method._compile, x86Assembler2, linkedList);
        x86Assembler2.emit2_Mem(x86.JMP_m, jq_CompiledCode._entrypoint.getOffset(), 0);
        return x86Assembler2.getCodeBuffer().allocateCodeBlock(null, null, null, null, 0, linkedList, linkedList2);
    }

    int getParamOffset(int n) {
        boolean bl = false;
        if (n < this.n_paramwords) {
            bl = true;
        }
        Assert._assert(bl);
        return this.n_paramwords - n + 1 << 2;
    }

    int getStackOffset(Operand.RegisterOperand registerOperand) {
        return this.getStackOffset(registerOperand.getRegister());
    }

    int getStackOffset(RegisterFactory.Register register) {
        Integer n = (Integer)this.registerLocations.get(register);
        return n;
    }

    int getStackFrameWords() {
        return this.cfg.getRegisterFactory().totalSize();
    }

    void initializeRegisterLocations() {
        int n = -(this.getStackFrameWords() << 2);
        RegisterFactory registerFactory = this.cfg.getRegisterFactory();
        Iterator iterator = registerFactory.iterator();
        while (iterator.hasNext()) {
            RegisterFactory.Register register = (RegisterFactory.Register)iterator.next();
            this.registerLocations.put(register, new Integer(n));
            if (this.TRACE) {
                System.out.println("Register: " + register + " offset: " + n);
            }
            n += 4;
        }
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        Assert._assert(bl);
    }

    public final jq_CompiledCode compile() {
        if (this.TRACE) {
            System.out.println("x86 Quad Compiler: compiling " + this.method);
        }
        if (jq.RunningNative) {
            Unsafe.getThreadBlock().disableThreadSwitch();
        }
        try {
            this.initializeRegisterLocations();
            int n = 0;
            jq_Type[] jq_TypeArray = new QuadIterator(this.cfg);
            while (jq_TypeArray.hasNext()) {
                ++n;
                jq_TypeArray.next();
            }
            this.asm = new x86Assembler(n, n * 8, 5, 32);
            this.asm.skip(5);
            this.asm.setEntrypoint();
            jq_TypeArray = this.method.getParamTypes();
            this.n_paramwords = this.method.getParamWords();
            int n2 = this.getStackFrameWords();
            this.asm.emitShort_Reg(x86.PUSH_r, 5);
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 5, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, -n2 << 2, 4);
            if (this.TraceMethods) {
                this.emitPushAddressOf(SystemInterface.toCString("Entering: " + this.method));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            RegisterFactory registerFactory = this.cfg.getRegisterFactory();
            int n3 = 0;
            int n4 = 0;
            while (n3 < jq_TypeArray.length) {
                int n5;
                int n6;
                if (jq_TypeArray[n3].getReferenceSize() == 8) {
                    n6 = this.getParamOffset(n4 + 1);
                    n5 = this.getStackOffset(registerFactory.getLocal(n4, jq_TypeArray[n3]));
                    this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 0, n6, 5);
                    this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 0, n5, 5);
                    n6 = this.getParamOffset(n4);
                    n5 = this.getStackOffset(registerFactory.getLocal(n4 + 1, jq_TypeArray[n3]));
                    this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 0, n6, 5);
                    this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 0, n5, 5);
                    ++n4;
                } else {
                    n6 = this.getParamOffset(n4);
                    n5 = this.getStackOffset(registerFactory.getLocal(n4, jq_TypeArray[n3]));
                    this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 0, n6, 5);
                    this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 0, n5, 5);
                }
                ++n3;
                ++n4;
            }
            if (this.method.isSynchronized()) {
                if (this.method.isStatic()) {
                    if (this.TraceQuads) {
                        this.emitPushAddressOf(SystemInterface.toCString("entry: STATIC SYNCH ENTER"));
                        this.emitCallMemory(SystemInterface._debugwriteln);
                    }
                    Class clazz = Reflection.getJDKType(this.method.getDeclaringClass());
                    boolean bl = false;
                    if (clazz != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    this.emitPushAddressOf(clazz);
                } else {
                    if (this.TraceQuads) {
                        this.emitPushAddressOf(SystemInterface.toCString("entry: INSTANCE SYNCH ENTER"));
                        this.emitCallMemory(SystemInterface._debugwriteln);
                    }
                    this.asm.emit2_Mem(x86.PUSH_m, this.getParamOffset(0), 5);
                }
                this.emitCallRelative(Monitor._monitorenter);
            }
            this.cfg.visitBasicBlocks(this);
            LinkedList<jq_TryCatch> linkedList = new LinkedList<jq_TryCatch>();
            jq_TryCatch[] jq_TryCatchArray = this.cfg.reversePostOrderIterator();
            while (jq_TryCatchArray.hasNext()) {
                BasicBlock basicBlock = (BasicBlock)jq_TryCatchArray.next();
                ExceptionHandlerList exceptionHandlerList = basicBlock.getExceptionHandlers();
                int n7 = this.asm.getBranchTarget(basicBlock);
                int n8 = this.asm.getBranchTarget(new Integer(basicBlock.getID()));
                ListIterator.ExceptionHandler exceptionHandler = exceptionHandlerList.exceptionHandlerIterator();
                while (exceptionHandler.hasNext()) {
                    ExceptionHandler exceptionHandler2 = (ExceptionHandler)exceptionHandler.next();
                    int n9 = this.asm.getBranchTarget(exceptionHandler2.getEntry());
                    ListIterator.Quad quad = exceptionHandler2.getEntry().iterator();
                    Assert._assert(quad.hasNext());
                    Quad quad2 = (Quad)quad.next();
                    Assert._assert(quad2.getOperator() instanceof Operator.Special.GET_EXCEPTION);
                    Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)Operator.Special.getOp1(quad2);
                    jq_TryCatch jq_TryCatch2 = new jq_TryCatch(n7, n8, n9, exceptionHandler2.getExceptionType(), this.getStackOffset(registerOperand));
                    linkedList.add(jq_TryCatch2);
                }
            }
            jq_TryCatchArray = linkedList.toArray(new jq_TryCatch[linkedList.size()]);
            jq_CompiledCode jq_CompiledCode2 = this.asm.getCodeBuffer().allocateCodeBlock(this.method, jq_TryCatchArray, null, x86QuadExceptionDeliverer.INSTANCE, n2 * 4, this.code_relocs, this.data_relocs);
            CodeCache.free(this.cfg);
            if (jq.RunningNative) {
                Unsafe.getThreadBlock().enableThreadSwitch();
            }
            return jq_CompiledCode2;
        }
        catch (RuntimeException runtimeException) {
            SystemInterface.debugwriteln("Exception occurred while compiling: " + this.method);
            SystemInterface.debugwriteln("Exception: " + runtimeException);
            runtimeException.printStackTrace();
            SystemInterface.die(-1);
            return null;
        }
    }

    public void visitBasicBlock(BasicBlock basicBlock) {
        this.asm.recordBranchTarget(basicBlock);
        this.asm.resolveForwardBranches(basicBlock);
        ListIterator.Quad quad = basicBlock.iterator();
        while (quad.hasNext()) {
            this.handled = false;
            Quad quad2 = quad.nextQuad();
            quad2.accept(this);
            Assert._assert(this.handled, quad2.toString());
        }
        if (basicBlock.getFallthroughSuccessor() != null) {
            this.branchHelper((byte)7, basicBlock.getFallthroughSuccessor());
        }
        this.asm.recordBranchTarget(new Integer(basicBlock.getID()));
    }

    private final int getPairedRegister(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 0;
            }
        }
        Assert.UNREACHABLE();
        return 0;
    }

    private final void loadOperand(Operand operand, int n) {
        if (operand instanceof Operand.RegisterOperand) {
            int n2 = this.getStackOffset((Operand.RegisterOperand)operand);
            this.asm.emit2_Reg_Mem(x86.MOV_r_m32, n, n2, 5);
            if (((Operand.RegisterOperand)operand).getType().getReferenceSize() == 8) {
                this.asm.emit2_Reg_Mem(x86.MOV_r_m32, this.getPairedRegister(n), n2 + 4, 5);
            }
        } else if (operand instanceof Operand.AConstOperand) {
            Object object = ((Operand.AConstOperand)operand).getValue();
            this.emitPushAddressOf(object);
            this.asm.emitShort_Reg(x86.POP_r, n);
        } else if (operand instanceof Operand.Const4Operand) {
            int n3 = ((Operand.Const4Operand)operand).getBits();
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, n, n3);
        } else if (operand instanceof Operand.Const8Operand) {
            long l = ((Operand.Const8Operand)operand).getBits();
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, n, (int)l);
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, this.getPairedRegister(n), (int)(l >> 32));
        } else {
            Assert.UNREACHABLE("x86 register " + n + ": " + operand);
        }
    }

    private final void storeOperand(Operand.RegisterOperand registerOperand, int n) {
        int n2 = this.getStackOffset(registerOperand);
        this.asm.emit2_Reg_Mem(x86.MOV_m_r32, n, n2, 5);
        if (registerOperand.getType().getReferenceSize() == 8) {
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, this.getPairedRegister(n), n2 + 4, 5);
        }
    }

    public void visitExceptionThrower(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " PEI: " + quad);
        }
    }

    public void visitLoad(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Load: " + quad);
        }
    }

    public void visitStore(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Store: " + quad);
        }
    }

    public void visitBranch(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Branch: " + quad);
        }
    }

    public void visitCondBranch(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " CondBranch: " + quad);
        }
    }

    public void visitCheck(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Check: " + quad);
        }
    }

    public void visitStaticField(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " StaticField: " + quad);
        }
    }

    public void visitInstanceField(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " InstanceField: " + quad);
        }
    }

    public void visitArray(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Array: " + quad);
        }
    }

    public void visitAllocation(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Allocation: " + quad);
        }
    }

    public void visitTypeCheck(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " TypeCheck: " + quad);
        }
    }

    public void visitALoad(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " ALoad: " + quad);
        }
        this.loadOperand(Operator.ALoad.getBase(quad), 0);
        this.loadOperand(Operator.ALoad.getIndex(quad), 3);
        jq_Type jq_Type2 = ((Operator.ALoad)quad.getOperator()).getType();
        int n = jq_Type2.getReferenceSize();
        switch (n) {
            case 4: {
                this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 1, 0, 3, 128, 0);
                break;
            }
            case 2: {
                if (jq_Type2 == jq_Primitive.CHAR) {
                    this.asm.emit3_Reg_Mem(x86.MOVZX_r_m16, 1, 0, 3, 64, 0);
                    break;
                }
                this.asm.emit3_Reg_Mem(x86.MOVSX_r_m16, 1, 0, 3, 64, 0);
                break;
            }
            case 1: {
                this.asm.emit3_Reg_Mem(x86.MOVSX_r_m8, 1, 0, 3, 0, 0);
                break;
            }
            case 8: {
                this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 1, 0, 3, 192, 0);
                this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 3, 0, 3, 192, 4);
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.storeOperand(Operator.ALoad.getDest(quad), 1);
        this.handled = true;
    }

    public void visitAStore(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " AStore: " + quad);
        }
        this.loadOperand(Operator.AStore.getBase(quad), 0);
        this.loadOperand(Operator.AStore.getIndex(quad), 2);
        this.loadOperand(Operator.AStore.getValue(quad), 1);
        jq_Type jq_Type2 = ((Operator.AStore)quad.getOperator()).getType();
        int n = jq_Type2.getReferenceSize();
        switch (n) {
            case 4: {
                this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 1, 0, 2, 128, 0);
                break;
            }
            case 2: {
                this.asm.emitprefix((byte)102);
                this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 1, 0, 2, 64, 0);
                break;
            }
            case 1: {
                this.asm.emit2_Reg_Mem(x86.MOV_m_r8, 1, 0, 2, 0, 0);
                break;
            }
            case 8: {
                this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 1, 0, 2, 192, 0);
                this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, 0, 2, 192, 4);
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.handled = true;
    }

    public void visitALength(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " ALength: " + quad);
        }
        this.loadOperand(Operator.ALength.getSrc(quad), 0);
        this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 0, -12, 0);
        this.storeOperand(Operator.ALength.getDest(quad), 0);
        this.handled = true;
    }

    public void visitBinary(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Binary: " + quad);
        }
        this.loadOperand(Operator.Binary.getSrc1(quad), 0);
        this.loadOperand(Operator.Binary.getSrc2(quad), 3);
        Operator.Binary binary = (Operator.Binary)quad.getOperator();
        if (binary instanceof Operator.Binary.ADD_I || binary instanceof Operator.Binary.ADD_P) {
            this.asm.emitARITH_Reg_Reg(x86.ADD_r_r32, 0, 3);
        } else if (binary instanceof Operator.Binary.SUB_I || binary instanceof Operator.Binary.SUB_P) {
            this.asm.emitARITH_Reg_Reg(x86.SUB_r_r32, 0, 3);
        } else if (binary instanceof Operator.Binary.MUL_I) {
            this.asm.emit2_Reg(x86.IMUL_rda_r32, 3);
        } else if (binary instanceof Operator.Binary.DIV_I) {
            this.asm.emit1(x86.CWD);
            this.asm.emit2_Reg(x86.IDIV_r32, 3);
        } else if (binary instanceof Operator.Binary.REM_I) {
            this.asm.emit1(x86.CWD);
            this.asm.emit2_Reg(x86.IDIV_r32, 3);
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 2);
        } else if (binary instanceof Operator.Binary.AND_I) {
            this.asm.emitARITH_Reg_Reg(x86.AND_r_r32, 0, 3);
        } else if (binary instanceof Operator.Binary.OR_I) {
            this.asm.emitARITH_Reg_Reg(x86.OR_r_r32, 0, 3);
        } else if (binary instanceof Operator.Binary.XOR_I) {
            this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 0, 3);
        } else if (binary instanceof Operator.Binary.ADD_L) {
            this.asm.emitARITH_Reg_Reg(x86.ADD_r_r32, 0, 3);
            this.asm.emitARITH_Reg_Reg(x86.ADC_r_r32, 2, 1);
        } else if (binary instanceof Operator.Binary.SUB_L) {
            this.asm.emitARITH_Reg_Reg(x86.SUB_r_r32, 0, 3);
            this.asm.emitARITH_Reg_Reg(x86.SBB_r_r32, 2, 1);
        } else if (binary instanceof Operator.Binary.MUL_L) {
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 6, 0);
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 7, 2);
            this.asm.emitARITH_Reg_Reg(x86.OR_r_r32, 2, 1);
            this.asm.emitCJUMP_Short(x86.JNE, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emit2_Reg(x86.MUL_rda_r32, 3);
            this.asm.emitJUMP_Short(x86.JMP, (byte)0);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            n = this.asm.getCurrentOffset();
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 6);
            this.asm.emit2_Reg(x86.MUL_rda_r32, 1);
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 1, 0);
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 7);
            this.asm.emit2_Reg(x86.MUL_rda_r32, 3);
            this.asm.emitARITH_Reg_Reg(x86.ADD_r_r32, 1, 0);
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 6);
            this.asm.emit2_Reg(x86.MUL_rda_r32, 3);
            this.asm.emitARITH_Reg_Reg(x86.ADD_r_r32, 2, 1);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        } else if (binary instanceof Operator.Binary.DIV_L) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.emitCallRelative(MathSupport._ldiv);
        } else if (binary instanceof Operator.Binary.REM_L) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.emitCallRelative(MathSupport._lrem);
        } else if (binary instanceof Operator.Binary.AND_L) {
            this.asm.emitARITH_Reg_Reg(x86.AND_r_r32, 0, 3);
            this.asm.emitARITH_Reg_Reg(x86.AND_r_r32, 2, 1);
        } else if (binary instanceof Operator.Binary.OR_L) {
            this.asm.emitARITH_Reg_Reg(x86.OR_r_r32, 0, 3);
            this.asm.emitARITH_Reg_Reg(x86.OR_r_r32, 2, 1);
        } else if (binary instanceof Operator.Binary.XOR_L) {
            this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 0, 3);
            this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 2, 1);
        } else if (binary instanceof Operator.Binary.ADD_F) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
            this.asm.emit2_Mem(x86.FADD_m32, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
            this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else if (binary instanceof Operator.Binary.SUB_F) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
            this.asm.emit2_Mem(x86.FSUB_m32, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
            this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else if (binary instanceof Operator.Binary.MUL_F) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
            this.asm.emit2_Mem(x86.FMUL_m32, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
            this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else if (binary instanceof Operator.Binary.DIV_F) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
            this.asm.emit2_Mem(x86.FDIV_m32, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
            this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else if (binary instanceof Operator.Binary.REM_F) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
            this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
            this.asm.emit2(x86.FPREM);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
            this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
            this.asm.emit2_FPReg(x86.FFREE, 0);
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else if (binary instanceof Operator.Binary.ADD_D) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
            this.asm.emit2_Mem(x86.FADD_m64, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
            this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
        } else if (binary instanceof Operator.Binary.SUB_D) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
            this.asm.emit2_Mem(x86.FSUB_m64, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
            this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
        } else if (binary instanceof Operator.Binary.MUL_D) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
            this.asm.emit2_Mem(x86.FMUL_m64, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
            this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
        } else if (binary instanceof Operator.Binary.DIV_D) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
            this.asm.emit2_Mem(x86.FDIV_m64, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
            this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
        } else if (binary instanceof Operator.Binary.REM_D) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
            this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
            this.asm.emit2(x86.FPREM);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
            this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
            this.asm.emit2_FPReg(x86.FFREE, 0);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
        } else if (binary instanceof Operator.Binary.SHL_I) {
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 1, 3);
            this.asm.emit2_Reg(x86.SHL_r32_rc, 0);
        } else if (binary instanceof Operator.Binary.SHR_I) {
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 1, 3);
            this.asm.emit2_Reg(x86.SAR_r32_rc, 0);
        } else if (binary instanceof Operator.Binary.USHR_I) {
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 1, 3);
            this.asm.emit2_Reg(x86.SHR_r32_rc, 0);
        } else if (binary instanceof Operator.Binary.SHL_L) {
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 1, 3);
            this.asm.emitARITH_Reg_Imm(x86.AND_r_i32, 1, 63);
            this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 1, 32);
            this.asm.emitCJUMP_Short(x86.JAE, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitSHLD_r_r_rc(2, 0);
            this.asm.emit2_Reg(x86.SHL_r32_rc, 0);
            this.asm.emitJUMP_Short(x86.JMP, (byte)0);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            n = this.asm.getCurrentOffset();
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 2, 0);
            this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 0, 0);
            this.asm.emit2_Reg(x86.SHL_r32_rc, 2);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        } else if (binary instanceof Operator.Binary.SHR_L) {
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 1, 3);
            this.asm.emitARITH_Reg_Imm(x86.AND_r_i32, 1, 63);
            this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 1, 32);
            this.asm.emitCJUMP_Short(x86.JAE, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitSHRD_r_r_rc(0, 2);
            this.asm.emit2_Reg(x86.SAR_r32_rc, 2);
            this.asm.emitJUMP_Short(x86.JMP, (byte)0);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            n = this.asm.getCurrentOffset();
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 2);
            this.asm.emit2_SHIFT_Reg_Imm8(x86.SAR_r32_i, 2, (byte)31);
            this.asm.emit2_Reg(x86.SAR_r32_rc, 0);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        } else if (binary instanceof Operator.Binary.USHR_L) {
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 1, 3);
            this.asm.emitARITH_Reg_Imm(x86.AND_r_i32, 1, 63);
            this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 1, 32);
            this.asm.emitCJUMP_Short(x86.JAE, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitSHRD_r_r_rc(0, 2);
            this.asm.emit2_Reg(x86.SHR_r32_rc, 2);
            this.asm.emitJUMP_Short(x86.JMP, (byte)0);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            n = this.asm.getCurrentOffset();
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 2);
            this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 2, 2);
            this.asm.emit2_Reg(x86.SHR_r32_rc, 0);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        } else if (binary instanceof Operator.Binary.CMP_L) {
            this.asm.emitARITH_Reg_Reg(x86.SUB_r_r32, 0, 3);
            this.asm.emitARITH_Reg_Reg(x86.SBB_r_r32, 2, 1);
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, -1);
            this.asm.emitCJUMP_Short(x86.JL, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 1, 1);
            this.asm.emitARITH_Reg_Reg(x86.OR_r_r32, 0, 2);
            this.asm.emitCJUMP_Short(x86.JE, (byte)0);
            int n2 = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg(x86.INC_r32, 1);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            this.asm.patch1(n2 - 1, (byte)(this.asm.getCurrentOffset() - n2));
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 1);
        } else if (binary instanceof Operator.Binary.CMP_FL) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
            this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
            this.asm.emit2(x86.FUCOMPP);
            this.asm.emit2(x86.FNSTSW_ax);
            this.asm.emit1(x86.SAHF);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, -1);
            this.asm.emitCJUMP_Short(x86.JB, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
            this.asm.emitCJUMP_Short(x86.JE, (byte)0);
            int n3 = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg(x86.INC_r32, 1);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            this.asm.patch1(n3 - 1, (byte)(this.asm.getCurrentOffset() - n3));
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 1);
        } else if (binary instanceof Operator.Binary.CMP_FG) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
            this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
            this.asm.emit2(x86.FUCOMPP);
            this.asm.emit2(x86.FNSTSW_ax);
            this.asm.emit1(x86.SAHF);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 1);
            this.asm.emitCJUMP_Short(x86.JB, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
            this.asm.emitCJUMP_Short(x86.JE, (byte)0);
            int n4 = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg(x86.DEC_r32, 1);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            this.asm.patch1(n4 - 1, (byte)(this.asm.getCurrentOffset() - n4));
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 1);
        } else if (binary instanceof Operator.Binary.CMP_DL) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
            this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
            this.asm.emit2(x86.FUCOMPP);
            this.asm.emit2(x86.FNSTSW_ax);
            this.asm.emit1(x86.SAHF);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 16, 4);
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, -1);
            this.asm.emitCJUMP_Short(x86.JB, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
            this.asm.emitCJUMP_Short(x86.JE, (byte)0);
            int n5 = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg(x86.INC_r32, 1);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            this.asm.patch1(n5 - 1, (byte)(this.asm.getCurrentOffset() - n5));
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 1);
        } else if (binary instanceof Operator.Binary.CMP_DG) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
            this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
            this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
            this.asm.emit2(x86.FUCOMPP);
            this.asm.emit2(x86.FNSTSW_ax);
            this.asm.emit1(x86.SAHF);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 16, 4);
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 1);
            this.asm.emitCJUMP_Short(x86.JB, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
            this.asm.emitCJUMP_Short(x86.JE, (byte)0);
            int n6 = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg(x86.DEC_r32, 1);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            this.asm.patch1(n6 - 1, (byte)(this.asm.getCurrentOffset() - n6));
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 1);
        } else if (binary instanceof Operator.Binary.ALIGN_P) {
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 1, 3);
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 3, 1);
            this.asm.emit2_Reg(x86.SHL_r32_rc, 3);
            this.asm.emitShort_Reg(x86.DEC_r32, 3);
            this.asm.emitARITH_Reg_Reg(x86.ADD_r_r32, 0, 3);
            this.asm.emit2_Reg(x86.NOT_r32, 3);
            this.asm.emitARITH_Reg_Reg(x86.AND_r_r32, 0, 3);
        } else {
            Assert.UNREACHABLE(quad.toString());
        }
        this.storeOperand(Operator.Binary.getDest(quad), 0);
        this.handled = true;
    }

    public void visitBoundsCheck(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " BoundsCheck: " + quad);
        }
        this.loadOperand(Operator.BoundsCheck.getRef(quad), 0);
        this.loadOperand(Operator.BoundsCheck.getIndex(quad), 3);
        this.asm.emitARITH_Reg_Mem(x86.CMP_r_m32, 3, -12, 0);
        this.asm.emitCJUMP_Short(x86.JB, (byte)2);
        this.asm.emit1_Imm8(x86.INT_i8, (byte)5);
        this.handled = true;
    }

    public void visitCheckCast(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " CheckCast: " + quad);
        }
        this.loadOperand(Operator.CheckCast.getSrc(quad), 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        jq_Type jq_Type2 = Operator.CheckCast.getType(quad).getType();
        this.emitPushAddressOf(jq_Type2);
        this.emitCallRelative(TypeCheck._checkcast);
        this.storeOperand(Operator.CheckCast.getDest(quad), 0);
        this.handled = true;
    }

    public void visitGetfield(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Getfield: " + quad);
        }
        jq_InstanceField jq_InstanceField2 = (jq_InstanceField)Operator.Getfield.getField(quad).getField();
        this.loadOperand(Operator.Getfield.getBase(quad), 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        if (jq_InstanceField2.getWidth() == 1) {
            if (jq_InstanceField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(10);
                this.emitPushAddressOf(jq_InstanceField2);
                this.emitCallRelative(x86ReferenceLinker._getfield1);
                this.asm.endDynamicPatch();
            } else {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit3_Reg_Mem(x86.MOVSX_r_m8, 3, jq_InstanceField2.getOffset(), 0);
                this.asm.emitShort_Reg(x86.PUSH_r, 3);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else if (jq_InstanceField2.getWidth() == 4) {
            if (jq_InstanceField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(10);
                this.emitPushAddressOf(jq_InstanceField2);
                this.emitCallRelative(x86ReferenceLinker._getfield4);
                this.asm.endDynamicPatch();
            } else {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit2_Mem(x86.PUSH_m, jq_InstanceField2.getOffset(), 0);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else if (jq_InstanceField2.getWidth() == 8) {
            if (jq_InstanceField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(13);
                this.emitPushAddressOf(jq_InstanceField2);
                this.emitCallRelative(x86ReferenceLinker._getfield8);
                this.asm.endDynamicPatch();
            } else {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit2_Mem(x86.PUSH_m, jq_InstanceField2.getOffset() + 4, 0);
                this.asm.emit2_Mem(x86.PUSH_m, jq_InstanceField2.getOffset(), 0);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
        } else if (jq_InstanceField2.getType() == jq_Primitive.SHORT) {
            if (jq_InstanceField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(10);
                this.emitPushAddressOf(jq_InstanceField2);
                this.emitCallRelative(x86ReferenceLinker._sgetfield);
                this.asm.endDynamicPatch();
            } else {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit3_Reg_Mem(x86.MOVSX_r_m16, 3, jq_InstanceField2.getOffset(), 0);
                this.asm.emitShort_Reg(x86.PUSH_r, 3);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else if (jq_InstanceField2.getType() == jq_Primitive.CHAR) {
            if (jq_InstanceField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(10);
                this.emitPushAddressOf(jq_InstanceField2);
                this.emitCallRelative(x86ReferenceLinker._cgetfield);
                this.asm.endDynamicPatch();
            } else {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit3_Reg_Mem(x86.MOVZX_r_m16, 3, jq_InstanceField2.getOffset(), 0);
                this.asm.emitShort_Reg(x86.PUSH_r, 3);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else {
            Assert.UNREACHABLE();
        }
        this.storeOperand(Operator.Getfield.getDest(quad), 0);
        this.handled = true;
    }

    public void visitGetstatic(Quad quad) {
        jq_StaticField jq_StaticField2;
        if (this.TRACE) {
            System.out.println(this + " Getstatic: " + quad);
        }
        if ((jq_StaticField2 = (jq_StaticField)Operator.Getstatic.getField(quad).getField()).getWidth() == 8) {
            if (jq_StaticField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(12);
                this.emitPushAddressOf(jq_StaticField2);
                this.emitCallRelative(x86ReferenceLinker._getstatic8);
                this.asm.endDynamicPatch();
            } else {
                this.emitPushMemory(jq_StaticField2);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
        } else {
            if (jq_StaticField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(10);
                this.emitPushAddressOf(jq_StaticField2);
                this.emitCallRelative(x86ReferenceLinker._getstatic4);
                this.asm.endDynamicPatch();
            } else {
                this.emitPushMemory(jq_StaticField2);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
        }
        this.storeOperand(Operator.Getstatic.getDest(quad), 0);
        this.handled = true;
    }

    public void visitGoto(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Goto: " + quad);
        }
        this.branchHelper((byte)7, Operator.Goto.getTarget(quad).getTarget());
        this.handled = true;
    }

    private final void branchHelper(byte by, BasicBlock basicBlock) {
        if (by == 7) {
            if (this.asm.containsTarget(basicBlock)) {
                this.asm.emitJUMP_Back(x86.JMP, basicBlock);
            } else {
                this.asm.emitJUMP_Forw(x86.JMP, basicBlock);
            }
        } else {
            x86 x862 = null;
            switch (by) {
                case 0: {
                    x862 = x86.JE;
                    break;
                }
                case 1: {
                    x862 = x86.JNE;
                    break;
                }
                case 2: {
                    x862 = x86.JL;
                    break;
                }
                case 3: {
                    x862 = x86.JGE;
                    break;
                }
                case 4: {
                    x862 = x86.JLE;
                    break;
                }
                case 5: {
                    x862 = x86.JG;
                    break;
                }
                case 6: {
                    x862 = x86.JAE;
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
            if (this.asm.containsTarget(basicBlock)) {
                this.asm.emitCJUMP_Back(x862, basicBlock);
            } else {
                this.asm.emitCJUMP_Forw(x862, basicBlock);
            }
        }
        this.handled = true;
    }

    public void visitInstanceOf(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " InstanceOf: " + quad);
        }
        this.loadOperand(Operator.InstanceOf.getSrc(quad), 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        jq_Type jq_Type2 = Operator.InstanceOf.getType(quad).getType();
        this.emitPushAddressOf(jq_Type2);
        this.emitCallRelative(TypeCheck._instance_of);
        this.storeOperand(Operator.InstanceOf.getDest(quad), 0);
        this.handled = true;
    }

    public void visitIntIfCmp(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " IntIfCmp: " + quad);
        }
        this.loadOperand(Operator.IntIfCmp.getSrc1(quad), 0);
        this.loadOperand(Operator.IntIfCmp.getSrc2(quad), 1);
        this.asm.emitARITH_Reg_Reg(x86.CMP_r_r32, 0, 1);
        this.branchHelper(Operator.IntIfCmp.getCond(quad).getCondition(), Operator.IntIfCmp.getTarget(quad).getTarget());
        this.handled = true;
    }

    private final void INVOKEDPATCHhelper(byte by, jq_Method jq_Method2) {
        jq_StaticMethod jq_StaticMethod2;
        int n;
        switch (by) {
            case 0: {
                n = 16;
                jq_StaticMethod2 = x86ReferenceLinker._invokevirtual;
                break;
            }
            case 1: {
                n = 11;
                jq_StaticMethod2 = x86ReferenceLinker._invokestatic;
                break;
            }
            case 2: {
                n = 11;
                jq_StaticMethod2 = x86ReferenceLinker._invokespecial;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.asm.startDynamicPatch(n);
        this.emitPushAddressOf(jq_Method2);
        this.emitCallRelative(jq_StaticMethod2);
        this.asm.endDynamicPatch();
        this.handled = true;
    }

    private final void INVOKENODPATCHhelper(byte by, jq_Method jq_Method2) {
        switch (by) {
            case 0: {
                int n = (jq_Method2.getParamWords() << 2) - 4;
                int n2 = ((jq_InstanceMethod)jq_Method2).getOffset();
                this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 0, n, 4);
                this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 3, -4, 0);
                this.asm.emit2_Mem(x86.CALL_m, n2, 3);
                break;
            }
            case 2: {
                jq_Method2 = jq_Class.getInvokespecialTarget(this.method.getDeclaringClass(), (jq_InstanceMethod)jq_Method2);
                this.emitCallRelative(jq_Method2);
                break;
            }
            case 1: {
                this.emitCallRelative(jq_Method2);
                break;
            }
            case 3: {
                this.emitPushAddressOf(jq_Method2);
                this.emitCallRelative(x86ReferenceLinker._invokeinterface);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, jq_Method2.getParamWords() << 2, 4);
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.handled = true;
    }

    private final void INVOKEhelper(byte by, jq_Method jq_Method2) {
        switch (by) {
            case 0: {
                if (jq_Method2.needsDynamicLink(this.method)) {
                    this.INVOKEDPATCHhelper(by, jq_Method2);
                    break;
                }
                this.INVOKENODPATCHhelper(by, jq_Method2);
                break;
            }
            case 1: 
            case 2: {
                if (jq_Method2.needsDynamicLink(this.method)) {
                    this.INVOKEDPATCHhelper(by, jq_Method2);
                    break;
                }
                this.INVOKENODPATCHhelper(by, jq_Method2);
                break;
            }
            case 3: {
                this.INVOKENODPATCHhelper(by, jq_Method2);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.handled = true;
    }

    public void visitInvoke(Quad quad) {
        jq_Type jq_Type2;
        if (this.TRACE) {
            System.out.println(this + " Invoke: " + quad);
        }
        byte by = ((Operator.Invoke)quad.getOperator()).getType();
        Operand.ParamListOperand paramListOperand = Operator.Invoke.getParamList(quad);
        int n = 0;
        while (n < paramListOperand.length()) {
            Operand.RegisterOperand registerOperand = paramListOperand.get(n);
            this.loadOperand(registerOperand, 0);
            if (registerOperand.getType().getReferenceSize() == 8) {
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
            }
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            ++n;
        }
        jq_Method jq_Method2 = Operator.Invoke.getMethod(quad).getMethod();
        this.INVOKEhelper(by, jq_Method2);
        int n2 = paramListOperand.words() - jq_Method2.getParamWords();
        if (n2 != 0) {
            this.asm.emit2_Reg_Mem(x86.LEA, 4, n2 << 2, 4);
        }
        if ((jq_Type2 = ((Operator.Invoke)quad.getOperator()).getReturnType()).getReferenceSize() > 0) {
            this.storeOperand(Operator.Invoke.getDest(quad), 0);
        }
        this.handled = true;
    }

    public void visitJsr(Quad quad) {
        BasicBlock basicBlock;
        if (this.TRACE) {
            System.out.println(this + " Jsr: " + quad);
        }
        if (this.asm.containsTarget(basicBlock = Operator.Jsr.getSuccessor(quad).getTarget())) {
            int n = this.asm.getBranchTarget(basicBlock);
            CodeAddress codeAddress = (CodeAddress)this.asm.getStartAddress().offset(n);
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 0, codeAddress.to32BitValue());
            Code2CodeReference code2CodeReference = new Code2CodeReference((CodeAddress)this.asm.getCurrentAddress().offset(-4), codeAddress);
            this.code_relocs.add(code2CodeReference);
        } else {
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 0, 0x77777777);
            this.asm.recordAbsoluteReference(4, basicBlock);
            Code2CodeReference code2CodeReference = new Code2CodeReference((CodeAddress)this.asm.getCurrentAddress().offset(-4), null);
            this.code_relocs.add(code2CodeReference);
        }
        this.storeOperand(Operator.Jsr.getDest(quad), 0);
        this.branchHelper((byte)7, Operator.Jsr.getTarget(quad).getTarget());
        this.handled = true;
    }

    public void visitLookupSwitch(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " LookupSwitch: " + quad);
        }
        this.loadOperand(Operator.LookupSwitch.getSrc(quad), 0);
        int n = Operator.LookupSwitch.getSize(quad);
        int n2 = 0;
        while (n2 < n) {
            int n3 = Operator.LookupSwitch.getMatch(quad, n2);
            this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 0, n3);
            BasicBlock basicBlock = Operator.LookupSwitch.getTarget(quad, n2);
            this.branchHelper((byte)0, basicBlock);
            ++n2;
        }
        this.branchHelper((byte)7, Operator.LookupSwitch.getDefault(quad).getTarget());
        this.handled = true;
    }

    public void visitMemLoad(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " MemLoad: " + quad);
        }
        this.loadOperand(Operator.MemLoad.getAddress(quad), 0);
        Operator.MemLoad memLoad = (Operator.MemLoad)quad.getOperator();
        if (memLoad instanceof Operator.MemLoad.PEEK_1) {
            this.asm.emit3_Reg_Mem(x86.MOVSX_r_m8, 1, 0, 0);
        } else if (memLoad instanceof Operator.MemLoad.PEEK_2) {
            this.asm.emit3_Reg_Mem(x86.MOVSX_r_m16, 1, 0, 0);
        } else if (memLoad instanceof Operator.MemLoad.PEEK_4) {
            this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 1, 0, 0);
        } else if (memLoad instanceof Operator.MemLoad.PEEK_8) {
            this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 1, 0, 0);
            this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 3, 4, 0);
        } else if (memLoad instanceof Operator.MemLoad.PEEK_P) {
            this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 1, 0, 0);
        } else {
            Assert.UNREACHABLE(quad.toString());
        }
        this.storeOperand(Operator.MemLoad.getDest(quad), 1);
        this.handled = true;
    }

    public void visitMemStore(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " MemStore: " + quad);
        }
        this.loadOperand(Operator.MemStore.getAddress(quad), 0);
        this.loadOperand(Operator.MemStore.getValue(quad), 3);
        Operator.MemStore memStore = (Operator.MemStore)quad.getOperator();
        if (memStore instanceof Operator.MemStore.POKE_1) {
            this.asm.emit2_Reg_Mem(x86.MOV_m_r8, 3, 0, 0);
        } else if (memStore instanceof Operator.MemStore.POKE_2) {
            this.asm.emitprefix((byte)102);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, 0, 0);
        } else if (memStore instanceof Operator.MemStore.POKE_4) {
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, 0, 0);
        } else if (memStore instanceof Operator.MemStore.POKE_8) {
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, 0, 0);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 1, 4, 0);
        } else if (memStore instanceof Operator.MemStore.POKE_P) {
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, 0, 0);
        } else {
            Assert.UNREACHABLE(quad.toString());
        }
        this.handled = true;
    }

    public void visitMonitor(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Monitor: " + quad);
        }
        this.loadOperand(Operator.Monitor.getSrc(quad), 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        jq_StaticMethod jq_StaticMethod2 = quad.getOperator() instanceof Operator.Monitor.MONITORENTER ? Monitor._monitorenter : Monitor._monitorexit;
        this.emitCallRelative(jq_StaticMethod2);
        this.handled = true;
    }

    public void visitMove(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Move: " + quad);
        }
        Operand.RegisterOperand registerOperand = Operator.Move.getDest(quad);
        Operand operand = Operator.Move.getSrc(quad);
        this.loadOperand(operand, 0);
        this.storeOperand(registerOperand, 0);
        this.handled = true;
    }

    public void visitNew(Quad quad) {
        jq_Type jq_Type2;
        if (this.TRACE) {
            System.out.println(this + " New: " + quad);
        }
        if ((jq_Type2 = Operator.New.getType(quad).getType()).isClassType() && !jq_Type2.needsDynamicLink(this.method)) {
            jq_Class jq_Class2 = (jq_Class)jq_Type2;
            this.asm.emitPUSH_i(jq_Class2.getInstanceSize());
            this.emitPushAddressOf(jq_Class2.getVTable());
            this.emitCallRelative(DefaultHeapAllocator._allocateObject);
        } else {
            this.emitPushAddressOf(jq_Type2);
            this.emitCallRelative(HeapAllocator._clsinitAndAllocateObject);
        }
        this.storeOperand(Operator.New.getDest(quad), 0);
        this.handled = true;
    }

    public void visitNewArray(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " NewArray: " + quad);
        }
        jq_Array jq_Array2 = (jq_Array)Operator.NewArray.getType(quad).getType();
        if (jq.RunningNative) {
            jq_Array2.cls_initialize();
        }
        byte by = jq_Array2.getLogElementSize();
        this.loadOperand(Operator.NewArray.getSize(quad), 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        if (by != 0) {
            this.asm.emit2_SHIFT_Mem_Imm8(x86.SHL_m32_i, 0, 4, by);
        }
        this.asm.emitARITH_Mem_Imm(x86.ADD_m_i32, 0, 4, 12);
        this.emitPushAddressOf(jq_Array2.getVTable());
        this.emitCallRelative(DefaultHeapAllocator._allocateArray);
        this.storeOperand(Operator.NewArray.getDest(quad), 0);
        this.handled = true;
    }

    public void visitNullCheck(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " NullCheck: " + quad);
        }
        this.loadOperand(Operator.NullCheck.getSrc(quad), 0);
        this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 0, 0, 0);
        this.handled = true;
    }

    public void visitPutfield(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Putfield: " + quad);
        }
        jq_InstanceField jq_InstanceField2 = (jq_InstanceField)Operator.Putfield.getField(quad).getField();
        this.loadOperand(Operator.Putfield.getBase(quad), 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        this.loadOperand(Operator.Putfield.getSrc(quad), 0);
        if (jq_InstanceField2.getWidth() == 8) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
        }
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        if (jq_InstanceField2.getWidth() == 1) {
            if (jq_InstanceField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(10);
                this.emitPushAddressOf(jq_InstanceField2);
                this.emitCallRelative(x86ReferenceLinker._putfield1);
                this.asm.endDynamicPatch();
            } else {
                this.asm.emitShort_Reg(x86.POP_r, 3);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit2_Reg_Mem(x86.MOV_m_r8, 3, jq_InstanceField2.getOffset(), 0);
            }
        } else if (jq_InstanceField2.getWidth() == 4) {
            if (jq_InstanceField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(10);
                this.emitPushAddressOf(jq_InstanceField2);
                this.emitCallRelative(x86ReferenceLinker._putfield4);
                this.asm.endDynamicPatch();
            } else {
                this.asm.emitShort_Reg(x86.POP_r, 3);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, jq_InstanceField2.getOffset(), 0);
            }
        } else if (jq_InstanceField2.getWidth() == 8) {
            if (jq_InstanceField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(15);
                this.emitPushAddressOf(jq_InstanceField2);
                this.emitCallRelative(x86ReferenceLinker._putfield8);
                this.asm.endDynamicPatch();
            } else {
                this.asm.emitShort_Reg(x86.POP_r, 3);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
                this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, jq_InstanceField2.getOffset(), 2);
                this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 0, jq_InstanceField2.getOffset() + 4, 2);
            }
        } else if (jq_InstanceField2.getWidth() == 2) {
            if (jq_InstanceField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(10);
                this.emitPushAddressOf(jq_InstanceField2);
                this.emitCallRelative(x86ReferenceLinker._putfield2);
                this.asm.endDynamicPatch();
            } else {
                this.asm.emitShort_Reg(x86.POP_r, 3);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitprefix((byte)102);
                this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, jq_InstanceField2.getOffset(), 0);
            }
        } else {
            Assert.UNREACHABLE(quad.toString());
        }
        this.handled = true;
    }

    public void visitPutstatic(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Putstatic: " + quad);
        }
        jq_StaticField jq_StaticField2 = (jq_StaticField)Operator.Putstatic.getField(quad).getField();
        this.loadOperand(Operator.Putstatic.getSrc(quad), 0);
        if (jq_StaticField2.getWidth() == 8) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            if (jq_StaticField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(12);
                this.emitPushAddressOf(jq_StaticField2);
                this.emitCallRelative(x86ReferenceLinker._putstatic8);
                this.asm.endDynamicPatch();
            } else {
                this.emitPopMemory8(jq_StaticField2);
            }
        } else {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            if (jq_StaticField2.needsDynamicLink(this.method)) {
                this.asm.startDynamicPatch(10);
                this.emitPushAddressOf(jq_StaticField2);
                this.emitCallRelative(x86ReferenceLinker._putstatic4);
                this.asm.endDynamicPatch();
            } else {
                this.emitPopMemory(jq_StaticField2);
            }
        }
        this.handled = true;
    }

    public void visitRet(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Ret: " + quad);
        }
        this.asm.emit2_Mem(x86.JMP_m, this.getStackOffset(Operator.Ret.getTarget(quad)), 5);
        this.handled = true;
    }

    public void visitReturn(Quad quad) {
        Operator.Return return_;
        if (this.TRACE) {
            System.out.println(this + " Return: " + quad);
        }
        if ((return_ = (Operator.Return)quad.getOperator()) instanceof Operator.Return.THROW_A) {
            this.loadOperand(Operator.Return.getSrc(quad), 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.emitCallRelative(ExceptionDeliverer._athrow);
        }
        if (this.method.isSynchronized()) {
            this.SYNCHEXIThelper();
        }
        if (this.TraceMethods) {
            this.emitPushAddressOf(SystemInterface.toCString("Leaving: " + this.method));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        if (!(return_ instanceof Operator.Return.RETURN_V)) {
            this.loadOperand(Operator.Return.getSrc(quad), 0);
        }
        this.asm.emit1(x86.LEAVE);
        this.asm.emit1_Imm16(x86.RET_i, (char)(this.n_paramwords << 2));
        this.handled = true;
    }

    private final void SYNCHEXIThelper() {
        if (this.method.isStatic()) {
            if (this.TraceQuads) {
                this.emitPushAddressOf(SystemInterface.toCString("exit: STATIC SYNCH EXIT"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            Class clazz = Reflection.getJDKType(this.method.getDeclaringClass());
            boolean bl = false;
            if (clazz != null) {
                bl = true;
            }
            Assert._assert(bl);
            this.emitPushAddressOf(clazz);
        } else {
            if (this.TraceQuads) {
                this.emitPushAddressOf(SystemInterface.toCString("exit: INSTANCE SYNCH EXIT"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emit2_Mem(x86.PUSH_m, this.getParamOffset(0), 5);
        }
        this.emitCallRelative(Monitor._monitorexit);
        this.handled = true;
    }

    public void visitSpecial(Quad quad) {
        Operator.Special special;
        if (this.TRACE) {
            System.out.println(this + " Special: " + quad);
        }
        if (!((special = (Operator.Special)quad.getOperator()) instanceof Operator.Special.GET_EXCEPTION)) {
            if (special instanceof Operator.Special.GET_BASE_POINTER) {
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 5);
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 0);
            } else if (special instanceof Operator.Special.GET_STACK_POINTER) {
                this.asm.emitShort_Reg(x86.PUSH_r, 4);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 0);
            } else if (special instanceof Operator.Special.GET_THREAD_BLOCK) {
                this.asm.emitprefix(THREAD_BLOCK_PREFIX);
                this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 0, THREAD_BLOCK_OFFSET);
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 0);
            } else if (special instanceof Operator.Special.SET_THREAD_BLOCK) {
                this.loadOperand(Operator.Special.getOp2(quad), 0);
                this.asm.emitprefix(THREAD_BLOCK_PREFIX);
                this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 0, THREAD_BLOCK_OFFSET);
            } else if (special instanceof Operator.Special.ALLOCA) {
                this.loadOperand(Operator.Special.getOp2(quad), 0);
                this.asm.emit2_Reg(x86.NEG_r32, 0);
                this.asm.emitARITH_Reg_Reg(x86.ADD_r_r32, 0, 4);
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 4, 0);
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 0);
            } else if (special instanceof Operator.Special.ATOMICADD_I) {
                this.loadOperand(Operator.Special.getOp2(quad), 0);
                this.loadOperand(Operator.Special.getOp3(quad), 3);
                if (jq.SMP) {
                    this.asm.emitprefix((byte)-16);
                }
                this.asm.emitARITH_Reg_Mem(x86.ADD_m_r32, 3, 0, 0);
            } else if (special instanceof Operator.Special.ATOMICSUB_I) {
                this.loadOperand(Operator.Special.getOp2(quad), 0);
                this.loadOperand(Operator.Special.getOp3(quad), 3);
                if (jq.SMP) {
                    this.asm.emitprefix((byte)-16);
                }
                this.asm.emitARITH_Reg_Mem(x86.SUB_m_r32, 3, 0, 0);
            } else if (special instanceof Operator.Special.ATOMICAND_I) {
                this.loadOperand(Operator.Special.getOp2(quad), 0);
                this.loadOperand(Operator.Special.getOp3(quad), 3);
                if (jq.SMP) {
                    this.asm.emitprefix((byte)-16);
                }
                this.asm.emitARITH_Reg_Mem(x86.AND_m_r32, 3, 0, 0);
            } else if (special instanceof Operator.Special.ATOMICCAS4) {
                this.loadOperand(Operator.Special.getOp2(quad), 1);
                this.loadOperand(Operator.Special.getOp3(quad), 0);
                this.loadOperand(Operator.Special.getOp4(quad), 3);
                if (jq.SMP) {
                    this.asm.emitprefix((byte)-16);
                }
                this.asm.emit3_Reg_Mem(x86.CMPXCHG_32, 3, 0, 1);
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 0);
            } else if (special instanceof Operator.Special.ATOMICCAS8) {
                this.loadOperand(Operator.Special.getOp2(quad), 7);
                this.loadOperand(Operator.Special.getOp3(quad), 0);
                this.loadOperand(Operator.Special.getOp4(quad), 7);
                if (jq.SMP) {
                    this.asm.emitprefix((byte)-16);
                }
                this.asm.emit3_Reg_Mem(x86.CMPXCHG8B, 0, 0, 7);
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 0);
            } else if (special instanceof Operator.Special.LONG_JUMP) {
                this.loadOperand(Operator.Special.getOp1(quad), 1);
                this.loadOperand(Operator.Special.getOp3(quad), 3);
                this.loadOperand(Operator.Special.getOp4(quad), 0);
                this.loadOperand(Operator.Special.getOp2(quad), 5);
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 4, 3);
                this.asm.emit2_Reg(x86.JMP_r, 1);
            } else if (special instanceof Operator.Special.POP_FP32) {
                this.asm.emit2_Reg_Mem(x86.LEA, 4, -4, 4);
                this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 0);
            } else if (special instanceof Operator.Special.POP_FP64) {
                this.asm.emit2_Reg_Mem(x86.LEA, 4, -8, 4);
                this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 0);
            } else if (special instanceof Operator.Special.PUSH_FP32) {
                this.loadOperand(Operator.Special.getOp2(quad), 0);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
            } else if (special instanceof Operator.Special.PUSH_FP64) {
                this.loadOperand(Operator.Special.getOp2(quad), 0);
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
            } else if (special instanceof Operator.Special.GET_EAX) {
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 0);
            } else if (special instanceof Operator.Special.PUSHARG_I || special instanceof Operator.Special.PUSHARG_P) {
                this.loadOperand(Operator.Special.getOp2(quad), 0);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
            } else if (special instanceof Operator.Special.INVOKE_L || special instanceof Operator.Special.INVOKE_P) {
                this.loadOperand(Operator.Special.getOp2(quad), 0);
                this.asm.emit2_Reg(x86.CALL_r, 0);
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 0);
            } else if (special instanceof Operator.Special.ISEQ) {
                this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
                this.asm.emitCJUMP_Short(x86.JNE, (byte)0);
                int n = this.asm.getCurrentOffset();
                this.asm.emitShort_Reg(x86.INC_r32, 1);
                this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 1);
            } else if (special instanceof Operator.Special.ISGE) {
                this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
                this.asm.emitCJUMP_Short(x86.JL, (byte)0);
                int n = this.asm.getCurrentOffset();
                this.asm.emitShort_Reg(x86.INC_r32, 1);
                this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                this.storeOperand((Operand.RegisterOperand)Operator.Special.getOp1(quad), 1);
            } else {
                Assert.UNREACHABLE(quad.toString());
            }
        }
        this.handled = true;
    }

    public void visitStoreCheck(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " StoreCheck: " + quad);
        }
        this.loadOperand(Operator.StoreCheck.getElement(quad), 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        this.loadOperand(Operator.StoreCheck.getRef(quad), 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        this.emitCallRelative(TypeCheck._arrayStoreCheck);
        this.handled = true;
    }

    public void visitTableSwitch(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " TableSwitch: " + quad);
        }
        int n = Operator.TableSwitch.getLow(quad).getValue();
        Operand.BasicBlockTableOperand basicBlockTableOperand = Operator.TableSwitch.getTargetTable(quad);
        this.loadOperand(Operator.TableSwitch.getSrc(quad), 0);
        if (n != 0) {
            this.asm.emitARITH_Reg_Imm(x86.SUB_r_i32, 0, n);
        }
        this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 0, basicBlockTableOperand.size());
        this.branchHelper((byte)6, Operator.TableSwitch.getDefault(quad).getTarget());
        this.asm.emitCALL_rel32(x86.CALL_rel32, 0);
        int n2 = this.asm.getCurrentOffset();
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emit2_Reg_Mem(x86.LEA, 2, 1, 0, 128, 127);
        int n3 = this.asm.getCurrentOffset();
        this.asm.emitARITH_Reg_Mem(x86.ADD_r_m32, 2, -4, 2);
        this.asm.emit2_Reg(x86.JMP_r, 2);
        this.asm.patch1(n3 - 1, (byte)(this.asm.getCurrentOffset() - n2 + 4));
        int n4 = 0;
        while (n4 < basicBlockTableOperand.size()) {
            BasicBlock basicBlock = basicBlockTableOperand.get(n4);
            if (this.asm.containsTarget(basicBlock)) {
                int n5 = this.asm.getBranchTarget(basicBlock) - this.asm.getCurrentOffset() + 4;
                this.asm.emitDATA(n5);
            } else {
                this.asm.emitDATA(0x77777777);
                this.asm.recordForwardBranch(4, basicBlock);
            }
            ++n4;
        }
        this.handled = true;
    }

    public void visitUnary(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " Unary: " + quad);
        }
        this.loadOperand(Operator.Unary.getSrc(quad), 0);
        Operator.Unary unary = (Operator.Unary)quad.getOperator();
        if (unary instanceof Operator.Unary.NEG_I) {
            this.asm.emit2_Reg(x86.NEG_r32, 0);
        } else if (unary instanceof Operator.Unary.NEG_L) {
            this.asm.emit2_Reg(x86.NEG_r32, 2);
            this.asm.emit2_Reg(x86.NEG_r32, 0);
            this.asm.emitARITH_Reg_Imm(x86.SBB_r_i32, 2, 0);
        } else if (unary instanceof Operator.Unary.NEG_F) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
            this.asm.emit2(x86.FCHS);
            this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else if (unary instanceof Operator.Unary.NEG_D) {
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
            this.asm.emit2(x86.FCHS);
            this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
        } else if (unary instanceof Operator.Unary.INT_2LONG) {
            this.asm.emit1(x86.CWD);
        } else if (unary instanceof Operator.Unary.INT_2FLOAT) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emit2_Mem(x86.FILD_m32, 0, 4);
            this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
        } else if (unary instanceof Operator.Unary.INT_2DOUBLE) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
            this.asm.emit2_Mem(x86.FILD_m32, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, -4, 4);
            this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
        } else if (!(unary instanceof Operator.Unary.LONG_2INT)) {
            if (unary instanceof Operator.Unary.LONG_2FLOAT) {
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                this.asm.emit2_Mem(x86.FILD_m64, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
                this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
                this.asm.emitShort_Reg(x86.POP_r, 0);
            } else if (unary instanceof Operator.Unary.LONG_2DOUBLE) {
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                this.asm.emit2_Mem(x86.FILD_m64, 0, 4);
                this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
            } else if (unary instanceof Operator.Unary.FLOAT_2INT) {
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
                this.toIntHelper();
                this.asm.emitShort_Reg(x86.POP_r, 0);
            } else if (unary instanceof Operator.Unary.FLOAT_2LONG) {
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, -4, 4);
                this.toLongHelper();
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
            } else if (unary instanceof Operator.Unary.FLOAT_2DOUBLE) {
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, -4, 4);
                this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
            } else if (unary instanceof Operator.Unary.DOUBLE_2INT) {
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
                this.toIntHelper();
                this.asm.emitShort_Reg(x86.POP_r, 0);
            } else if (unary instanceof Operator.Unary.DOUBLE_2LONG) {
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
                this.toLongHelper();
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
            } else if (unary instanceof Operator.Unary.DOUBLE_2FLOAT) {
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
                this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
                this.asm.emitShort_Reg(x86.POP_r, 0);
            } else if (unary instanceof Operator.Unary.INT_2BYTE) {
                this.asm.emit3_Reg_Reg(x86.MOVSX_r_r8, 0, 0);
            } else if (unary instanceof Operator.Unary.INT_2SHORT) {
                this.asm.emit3_Reg_Reg(x86.MOVSX_r_r16, 0, 0);
            } else if (unary instanceof Operator.Unary.INT_2CHAR) {
                this.asm.emit3_Reg_Reg(x86.MOVZX_r_r16, 0, 0);
            } else if (!(unary instanceof Operator.Unary.FLOAT_2INTBITS || unary instanceof Operator.Unary.INTBITS_2FLOAT || unary instanceof Operator.Unary.DOUBLE_2LONGBITS || unary instanceof Operator.Unary.LONGBITS_2DOUBLE || unary instanceof Operator.Unary.OBJECT_2ADDRESS || unary instanceof Operator.Unary.ADDRESS_2OBJECT || unary instanceof Operator.Unary.INT_2ADDRESS || unary instanceof Operator.Unary.ADDRESS_2INT)) {
                if (unary instanceof Operator.Unary.ISNULL_P) {
                    this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
                    this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 0, 0);
                    this.asm.emitCJUMP_Short(x86.JNE, (byte)0);
                    int n = this.asm.getCurrentOffset();
                    this.asm.emitShort_Reg(x86.INC_r32, 1);
                    this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                    this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 1);
                } else {
                    Assert.UNREACHABLE(quad.toString());
                }
            }
        }
        this.storeOperand(Operator.Binary.getDest(quad), 0);
        this.handled = true;
    }

    private final void toIntHelper() {
        this.emitFLD64(MathSupport._maxint);
        this.asm.emit2_FPReg(x86.FUCOMIP, 1);
        this.asm.emitCJUMP_Short(x86.JP, (byte)0);
        int n = this.asm.getCurrentOffset();
        this.asm.emitCJUMP_Short(x86.JBE, (byte)0);
        int n2 = this.asm.getCurrentOffset();
        this.emitFLD64(MathSupport._minint);
        this.asm.emit2_FPReg(x86.FUCOMIP, 1);
        this.asm.emitCJUMP_Short(x86.JAE, (byte)0);
        int n3 = this.asm.getCurrentOffset();
        this.asm.emit2_Reg_Mem(x86.LEA, 4, -8, 4);
        this.asm.emit2_Mem(x86.FNSTCW, 4, 4);
        this.asm.emit2_Mem(x86.FNSTCW, 0, 4);
        this.asm.emitARITH_Mem_Imm(x86.OR_m_i32, 4, 4, 3072);
        this.asm.emit2(x86.FNCLEX);
        this.asm.emit2_Mem(x86.FLDCW, 4, 4);
        this.asm.emit2_Mem(x86.FISTP_m32, 8, 4);
        this.asm.emit2(x86.FNCLEX);
        this.asm.emit2_Mem(x86.FLDCW, 0, 4);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n4 = this.asm.getCurrentOffset();
        this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, 0);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n5 = this.asm.getCurrentOffset();
        this.asm.patch1(n2 - 1, (byte)(this.asm.getCurrentOffset() - n2));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, Integer.MAX_VALUE);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n6 = this.asm.getCurrentOffset();
        this.asm.patch1(n3 - 1, (byte)(this.asm.getCurrentOffset() - n3));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, Integer.MIN_VALUE);
        this.asm.patch1(n5 - 1, (byte)(this.asm.getCurrentOffset() - n5));
        this.asm.patch1(n6 - 1, (byte)(this.asm.getCurrentOffset() - n6));
        this.asm.emit2_FPReg(x86.FFREE, 0);
        this.asm.patch1(n4 - 1, (byte)(this.asm.getCurrentOffset() - n4));
        this.handled = true;
    }

    private final void toLongHelper() {
        this.emitFLD64(MathSupport._maxlong);
        this.asm.emit2_FPReg(x86.FUCOMIP, 1);
        this.asm.emitCJUMP_Short(x86.JP, (byte)0);
        int n = this.asm.getCurrentOffset();
        this.asm.emitCJUMP_Short(x86.JBE, (byte)0);
        int n2 = this.asm.getCurrentOffset();
        this.emitFLD64(MathSupport._minlong);
        this.asm.emit2_FPReg(x86.FUCOMIP, 1);
        this.asm.emitCJUMP_Short(x86.JAE, (byte)0);
        int n3 = this.asm.getCurrentOffset();
        this.asm.emit2_Reg_Mem(x86.LEA, 4, -8, 4);
        this.asm.emit2_Mem(x86.FNSTCW, 4, 4);
        this.asm.emit2_Mem(x86.FNSTCW, 0, 4);
        this.asm.emitARITH_Mem_Imm(x86.OR_m_i32, 4, 4, 3072);
        this.asm.emit2(x86.FNCLEX);
        this.asm.emit2_Mem(x86.FLDCW, 4, 4);
        this.asm.emit2_Mem(x86.FISTP_m64, 8, 4);
        this.asm.emit2(x86.FNCLEX);
        this.asm.emit2_Mem(x86.FLDCW, 0, 4);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n4 = this.asm.getCurrentOffset();
        this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, 0);
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 4, 4, 0);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n5 = this.asm.getCurrentOffset();
        this.asm.patch1(n2 - 1, (byte)(this.asm.getCurrentOffset() - n2));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, -1);
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 4, 4, Integer.MAX_VALUE);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n6 = this.asm.getCurrentOffset();
        this.asm.patch1(n3 - 1, (byte)(this.asm.getCurrentOffset() - n3));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, 0);
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 4, 4, Integer.MIN_VALUE);
        this.asm.patch1(n5 - 1, (byte)(this.asm.getCurrentOffset() - n5));
        this.asm.patch1(n6 - 1, (byte)(this.asm.getCurrentOffset() - n6));
        this.asm.emit2_FPReg(x86.FFREE, 0);
        this.asm.patch1(n4 - 1, (byte)(this.asm.getCurrentOffset() - n4));
        this.handled = true;
    }

    public void visitZeroCheck(Quad quad) {
        if (this.TRACE) {
            System.out.println(this + " ZeroCheck: " + quad);
        }
        this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 0, 0);
        this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 2, 2);
        this.loadOperand(Operator.ZeroCheck.getSrc(quad), 3);
        this.asm.emit2_Reg(x86.IDIV_r32, 3);
        this.handled = true;
    }

    public void visitQuad(Quad quad) {
        Assert._assert(this.handled, quad.toString());
    }

    public static void main(String[] stringArray) {
        ObjectTraverser objectTraverser;
        HostedVM.initialize();
        CodeAddress.FACTORY = BootstrapCodeAddress.FACTORY;
        HeapAddress.FACTORY = BootstrapHeapAddress.FACTORY;
        ClassLibInterface.useJoeqClasslib(true);
        CodeAllocator.initializeCompiledMethodMap();
        BootstrapCodeAllocator bootstrapCodeAllocator = BootstrapCodeAllocator.DEFAULT;
        DefaultCodeAllocator.default_allocator = bootstrapCodeAllocator;
        bootstrapCodeAllocator.init();
        Reflection.obj_trav = objectTraverser = ClassLibInterface.DEFAULT.getObjectTraverser();
        objectTraverser.initialize();
        BootImage bootImage = BootImage.DEFAULT;
        bootImage.enableAllocations();
        String string = stringArray[0];
        jq_Class jq_Class2 = (jq_Class)jq_Type.parseType(string);
        jq_Class2.cls_initialize();
        ALWAYS_TRACE = true;
        x86Assembler.TRACE = true;
        AppendIterator appendIterator = Arrays.asList(jq_Class2.getDeclaredStaticMethods()).iterator();
        appendIterator = new AppendIterator(appendIterator, Arrays.asList(jq_Class2.getDeclaredInstanceMethods()).iterator());
        while (appendIterator.hasNext()) {
            jq_Method jq_Method2 = (jq_Method)appendIterator.next();
            if (jq_Method2.getBytecode() == null) continue;
            ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
            SimpleCompiler simpleCompiler = new SimpleCompiler(controlFlowGraph);
            jq_CompiledCode jq_CompiledCode2 = simpleCompiler.compile();
            jq_Method2.setDefaultCompiledVersion(jq_CompiledCode2);
        }
    }

    public SimpleCompiler() {
    }

    public SimpleCompiler(ControlFlowGraph controlFlowGraph) {
        this.init(controlFlowGraph);
    }

    public SimpleCompiler(jq_Method jq_Method2) {
        this.init(jq_Method2);
    }

    public static class Factory
    implements Compil3rInterface {
        public static final Factory INSTANCE = new Factory();

        public jq_CompiledCode compile(jq_Method jq_Method2) {
            return new SimpleCompiler(jq_Method2).compile();
        }
    }
}

