/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Reference.x86;

import Allocator.DefaultHeapAllocator;
import Allocator.HeapAllocator;
import Assembler.x86.Code2HeapReference;
import Assembler.x86.DirectBindCall;
import Assembler.x86.x86;
import Assembler.x86.x86Assembler;
import Assembler.x86.x86Constants;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_BytecodeMap;
import Clazz.jq_Class;
import Clazz.jq_ClassFileConstants;
import Clazz.jq_CompiledCode;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Method;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Clazz.jq_TryCatch;
import Clazz.jq_TryCatchBC;
import Clazz.jq_Type;
import Compil3r.BytecodeAnalysis.BytecodeVisitor;
import Compil3r.Compil3rInterface;
import Compil3r.CompilationState;
import Compil3r.Reference.x86.x86ReferenceExceptionDeliverer;
import Compil3r.Reference.x86.x86ReferenceLinker;
import Main.jq;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Run_Time.Arrays;
import Run_Time.ExceptionDeliverer;
import Run_Time.MathSupport;
import Run_Time.Monitor;
import Run_Time.Reflection;
import Run_Time.SystemInterface;
import Run_Time.TypeCheck;
import Run_Time.Unsafe;
import UTF.Utf8;
import Util.Assert;
import Util.Strings;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class x86ReferenceCompiler
extends BytecodeVisitor
implements x86Constants,
jq_ClassFileConstants {
    public static boolean ALWAYS_TRACE = false;
    public static boolean TRACE_STUBS = false;
    public static final Set TraceMethod_MethodNames = new HashSet();
    public static final Set TraceMethod_ClassNames = new HashSet();
    public static final Set TraceBytecode_MethodNames = new HashSet();
    public static final Set TraceBytecode_ClassNames = new HashSet();
    public static final int DEFAULT_ALIGNMENT = 32;
    public static byte THREAD_BLOCK_PREFIX = (byte)100;
    public static int THREAD_BLOCK_OFFSET = 20;
    public static final Utf8 peek = Utf8.get("peek");
    public static final Utf8 peek1 = Utf8.get("peek1");
    public static final Utf8 peek2 = Utf8.get("peek2");
    public static final Utf8 peek4 = Utf8.get("peek4");
    public static final Utf8 peek8 = Utf8.get("peek8");
    public static final Utf8 poke = Utf8.get("poke");
    public static final Utf8 poke1 = Utf8.get("poke1");
    public static final Utf8 poke2 = Utf8.get("poke2");
    public static final Utf8 poke4 = Utf8.get("poke4");
    public static final Utf8 poke8 = Utf8.get("poke8");
    public static final Utf8 offset = Utf8.get("offset");
    public static final Utf8 align = Utf8.get("align");
    public static final Utf8 difference = Utf8.get("difference");
    public static final Utf8 isNull = Utf8.get("isNull");
    public static final Utf8 addressOf = Utf8.get("addressOf");
    public static final Utf8 address32 = Utf8.get("address32");
    public static final Utf8 asObject = Utf8.get("asObject");
    public static final Utf8 asReferenceType = Utf8.get("asReferenceType");
    public static final Utf8 to32BitValue = Utf8.get("to32BitValue");
    public static final Utf8 stringRep = Utf8.get("stringRep");
    public static final Utf8 getNull = Utf8.get("getNull");
    public static final Utf8 size = Utf8.get("size");
    public static final Utf8 logSize = Utf8.get("logSize");
    public static final Utf8 pageAlign = Utf8.get("pageAlign");
    public static final Utf8 getBasePointer = Utf8.get("getBasePointer");
    public static final Utf8 getStackPointer = Utf8.get("getStackPointer");
    public static final Utf8 alloca = Utf8.get("alloca");
    public static final Utf8 atomicAdd = Utf8.get("atomicAdd");
    public static final Utf8 atomicSub = Utf8.get("atomicSub");
    public static final Utf8 atomicCas4 = Utf8.get("atomicCas4");
    public static final Utf8 atomicCas8 = Utf8.get("atomicCas8");
    public static final Utf8 atomicAnd = Utf8.get("atomicAnd");
    public static final Utf8 min = Utf8.get("min");
    public static final Utf8 max = Utf8.get("max");
    public final boolean TraceBytecodes;
    public final boolean TraceMethods;
    public final boolean TraceArguments;
    private x86Assembler asm;
    private int n_paramwords;
    private List code_relocs;
    private List data_relocs;

    public void init(jq_Method jq_Method2) {
        boolean bl = false;
        if (jq_Method2 == this.method) {
            bl = true;
        }
        Assert._assert(bl);
    }

    public String toString() {
        return "x86RC/" + Strings.left(this.method.getName().toString(), 10);
    }

    private final int getLocalOffset(int n) {
        if (n < this.n_paramwords) {
            return this.n_paramwords - n + 1 << 2;
        }
        return this.n_paramwords - n - 1 << 2;
    }

    public final void emitCallRelative(jq_Method jq_Method2) {
        x86ReferenceCompiler.emitCallRelative(jq_Method2, this.asm, this.code_relocs);
    }

    public static final void emitCallRelative(jq_Method jq_Method2, x86Assembler x86Assembler2, List list) {
        x86Assembler2.emitCALL_rel32(x86.CALL_rel32, 0);
        DirectBindCall directBindCall = new DirectBindCall((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), jq_Method2);
        list.add(directBindCall);
        if (ALWAYS_TRACE) {
            System.out.println("Direct bind call: " + directBindCall);
        }
    }

    public final void emitPushAddressOf(Object object) {
        x86ReferenceCompiler.emitPushAddressOf(object, this.asm, this.data_relocs);
    }

    public static final void emitPushAddressOf(Object object, x86Assembler x86Assembler2, List list) {
        if (object != null) {
            HeapAddress heapAddress = HeapAddress.addressOf(object);
            x86Assembler2.emit1_Imm32(x86.PUSH_i32, heapAddress.to32BitValue());
            Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
            list.add(code2HeapReference);
            if (ALWAYS_TRACE) {
                System.out.println("Code2Heap reference: " + code2HeapReference);
            }
        } else {
            x86Assembler2.emit1_Imm8(x86.PUSH_i8, (byte)0);
        }
    }

    public final void emitPushMemory(jq_StaticField jq_StaticField2) {
        x86ReferenceCompiler.emitPushMemory(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitPushMemory(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.PUSH_m, heapAddress.to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final void emitPushMemory8(jq_StaticField jq_StaticField2) {
        x86ReferenceCompiler.emitPushMemory8(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitPushMemory8(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.PUSH_m, heapAddress.offset(4).to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), (HeapAddress)heapAddress.offset(4));
        list.add(code2HeapReference);
        x86Assembler2.emit2_Mem(x86.PUSH_m, heapAddress.to32BitValue());
        code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final void emitPopMemory(jq_StaticField jq_StaticField2) {
        x86ReferenceCompiler.emitPopMemory(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitPopMemory(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.POP_m, heapAddress.to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final void emitPopMemory8(jq_StaticField jq_StaticField2) {
        x86ReferenceCompiler.emitPopMemory8(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitPopMemory8(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.POP_m, heapAddress.to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
        x86Assembler2.emit2_Mem(x86.POP_m, heapAddress.offset(4).to32BitValue());
        code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), (HeapAddress)heapAddress.offset(4));
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final void emitCallMemory(jq_StaticField jq_StaticField2) {
        x86ReferenceCompiler.emitCallMemory(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitCallMemory(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.CALL_m, heapAddress.to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final void emitFLD64(jq_StaticField jq_StaticField2) {
        x86ReferenceCompiler.emitFLD64(jq_StaticField2, this.asm, this.data_relocs);
    }

    public static final void emitFLD64(jq_StaticField jq_StaticField2, x86Assembler x86Assembler2, List list) {
        HeapAddress heapAddress = jq_StaticField2.getAddress();
        x86Assembler2.emit2_Mem(x86.FLD_m64, heapAddress.to32BitValue());
        Code2HeapReference code2HeapReference = new Code2HeapReference((CodeAddress)x86Assembler2.getCurrentAddress().offset(-4), heapAddress);
        list.add(code2HeapReference);
        if (ALWAYS_TRACE) {
            System.out.println("Code2Heap reference: " + code2HeapReference);
        }
    }

    public final List getCodeRelocs() {
        return this.code_relocs;
    }

    public final List getDataRelocs() {
        return this.data_relocs;
    }

    public static final jq_CompiledCode generate_compile_stub(jq_Method jq_Method2) {
        if (TRACE_STUBS) {
            System.out.println("x86 Reference Compiler: generating compile stub for " + jq_Method2);
        }
        x86Assembler x86Assembler2 = new x86Assembler(0, 24, 0, 32);
        x86Assembler2.setEntrypoint();
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        if (TRACE_STUBS) {
            x86ReferenceCompiler.emitPushAddressOf(SystemInterface.toCString("Stub compile: " + jq_Method2), x86Assembler2, linkedList2);
            x86ReferenceCompiler.emitCallMemory(SystemInterface._debugwriteln, x86Assembler2, linkedList2);
        }
        x86ReferenceCompiler.emitPushAddressOf(jq_Method2, x86Assembler2, linkedList2);
        x86ReferenceCompiler.emitCallRelative(jq_Method._compile, x86Assembler2, linkedList);
        x86Assembler2.emit2_Mem(x86.JMP_m, jq_CompiledCode._entrypoint.getOffset(), 0);
        return x86Assembler2.getCodeBuffer().allocateCodeBlock(null, null, null, null, 0, linkedList, linkedList2);
    }

    public final jq_CompiledCode compile() {
        if (this.TRACE) {
            System.out.println("x86 Reference Compiler: compiling " + this.method);
        }
        if (jq.RunningNative) {
            Unsafe.getThreadBlock().disableThreadSwitch();
        }
        try {
            Comparable<Integer> comparable;
            int n;
            Object object;
            Serializable serializable;
            Object object2;
            Object object3;
            Constable constable;
            this.asm = new x86Assembler(this.bcs.length, this.bcs.length * 8, 5, 32);
            this.asm.skip(5);
            this.asm.setEntrypoint();
            this.n_paramwords = this.method.getParamWords();
            char c = this.method.getMaxLocals();
            boolean bl = false;
            if (this.n_paramwords <= c) {
                bl = true;
            }
            Assert._assert(bl);
            this.asm.emitShort_Reg(x86.PUSH_r, 5);
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 5, 4);
            if (this.n_paramwords != c) {
                this.asm.emit2_Reg_Mem(x86.LEA, 4, this.n_paramwords - c << 2, 4);
            }
            if (this.TraceMethods) {
                this.emitPushAddressOf(SystemInterface.toCString("Entering: " + this.method));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emitPUSH_i(53261);
            if (this.method.isSynchronized()) {
                if (this.method.isStatic()) {
                    if (this.TraceBytecodes) {
                        this.emitPushAddressOf(SystemInterface.toCString("entry: STATIC SYNCH ENTER"));
                        this.emitCallMemory(SystemInterface._debugwriteln);
                    }
                    constable = Reflection.getJDKType(this.method.getDeclaringClass());
                    boolean bl2 = false;
                    if (constable != null) {
                        bl2 = true;
                    }
                    Assert._assert(bl2);
                    this.emitPushAddressOf(constable);
                } else {
                    if (this.TraceBytecodes) {
                        this.emitPushAddressOf(SystemInterface.toCString("entry: INSTANCE SYNCH ENTER"));
                        this.emitCallMemory(SystemInterface._debugwriteln);
                    }
                    this.asm.emit2_Mem(x86.PUSH_m, this.getLocalOffset(0), 5);
                }
                this.emitCallRelative(Monitor._monitorenter);
            }
            this.forwardTraversal();
            constable = new Integer(this.bcs.length);
            this.asm.recordBranchTarget(constable);
            jq_TryCatchBC[] jq_TryCatchBCArray = this.method.getExceptionTable();
            jq_TryCatch[] jq_TryCatchArray = new jq_TryCatch[jq_TryCatchBCArray.length];
            int n2 = 0;
            while (n2 < jq_TryCatchBCArray.length) {
                jq_TryCatchBC jq_TryCatchBC2 = jq_TryCatchBCArray[n2];
                object3 = new Integer(jq_TryCatchBC2.getStartPC());
                object2 = new Integer(jq_TryCatchBC2.getEndPC());
                serializable = new Integer(jq_TryCatchBC2.getHandlerPC());
                object = jq_TryCatchBC2.getExceptionType();
                n = (this.n_paramwords - c << 2) - 4;
                jq_TryCatchArray[n2] = new jq_TryCatch(this.asm.getBranchTarget(object3), this.asm.getBranchTarget(object2), this.asm.getBranchTarget(serializable), (jq_Class)object, n);
                ++n2;
            }
            Map map = this.asm.getBranchTargetMap();
            int n3 = map.size();
            object3 = new int[n3];
            object2 = new int[n3];
            serializable = new ArrayList(map.keySet());
            Collections.sort(serializable);
            object = serializable.iterator();
            n = 0;
            while (n < n3) {
                comparable = (Integer)object.next();
                object2[n] = comparable;
                object3[n] = (Integer)map.get(comparable);
                ++n;
            }
            jq_BytecodeMap jq_BytecodeMap2 = new jq_BytecodeMap((int[])object3, (int[])object2);
            comparable = this.asm.getCodeBuffer().allocateCodeBlock(this.method, jq_TryCatchArray, jq_BytecodeMap2, x86ReferenceExceptionDeliverer.INSTANCE, this.n_paramwords - c << 2, this.code_relocs, this.data_relocs);
            if (jq.RunningNative) {
                Unsafe.getThreadBlock().enableThreadSwitch();
            }
            return comparable;
        }
        catch (RuntimeException runtimeException) {
            SystemInterface.debugwriteln("Exception occurred while compiling: " + this.method);
            SystemInterface.debugwriteln("Exception: " + runtimeException);
            runtimeException.printStackTrace();
            SystemInterface.die(-1);
            return null;
        }
    }

    public void visitBytecode() throws VerifyError {
        Integer n = new Integer(this.i_start);
        this.asm.recordBranchTarget(n);
        this.asm.resolveForwardBranches(n);
        super.visitBytecode();
    }

    public void visitNOP() {
        super.visitNOP();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": NOP"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit1(x86.NOP);
    }

    public void visitACONST(Object object) {
        super.visitACONST(object);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ACONST"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.emitPushAddressOf(object);
    }

    public void visitICONST(int n) {
        super.visitICONST(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ICONST " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitPUSH_i(n);
    }

    public void visitLCONST(long l) {
        super.visitLCONST(l);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LCONST " + l));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitPUSH_i((int)(l >> 32));
        this.asm.emitPUSH_i((int)l);
    }

    public void visitFCONST(float f) {
        super.visitFCONST(f);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": FCONST " + f));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitPUSH_i(Float.floatToRawIntBits(f));
    }

    public void visitDCONST(double d) {
        super.visitDCONST(d);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DCONST " + d));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        long l = Double.doubleToRawLongBits(d);
        this.asm.emitPUSH_i((int)(l >> 32));
        this.asm.emitPUSH_i((int)l);
    }

    public void visitILOAD(int n) {
        super.visitILOAD(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ILOAD " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.PUSH_m, this.getLocalOffset(n), 5);
    }

    public void visitLLOAD(int n) {
        super.visitLLOAD(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LLOAD " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.PUSH_m, this.getLocalOffset(n), 5);
        this.asm.emit2_Mem(x86.PUSH_m, this.getLocalOffset(n + 1), 5);
    }

    public void visitFLOAD(int n) {
        super.visitFLOAD(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": FLOAD " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.PUSH_m, this.getLocalOffset(n), 5);
    }

    public void visitDLOAD(int n) {
        super.visitDLOAD(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DLOAD " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.PUSH_m, this.getLocalOffset(n), 5);
        this.asm.emit2_Mem(x86.PUSH_m, this.getLocalOffset(n + 1), 5);
    }

    public void visitALOAD(int n) {
        super.visitALOAD(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ALOAD " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.PUSH_m, this.getLocalOffset(n), 5);
    }

    public void visitISTORE(int n) {
        super.visitISTORE(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ISTORE " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.POP_m, this.getLocalOffset(n), 5);
    }

    public void visitLSTORE(int n) {
        super.visitLSTORE(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LSTORE " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.POP_m, this.getLocalOffset(n + 1), 5);
        this.asm.emit2_Mem(x86.POP_m, this.getLocalOffset(n), 5);
    }

    public void visitFSTORE(int n) {
        super.visitFSTORE(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": FSTORE " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.POP_m, this.getLocalOffset(n), 5);
    }

    public void visitDSTORE(int n) {
        super.visitDSTORE(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DSTORE " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.POP_m, this.getLocalOffset(n + 1), 5);
        this.asm.emit2_Mem(x86.POP_m, this.getLocalOffset(n), 5);
    }

    public void visitASTORE(int n) {
        super.visitASTORE(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ASTORE " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.POP_m, this.getLocalOffset(n), 5);
    }

    private final void ALOAD4helper() {
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Mem(x86.CMP_r_m32, 3, -12, 0);
        this.asm.emitCJUMP_Short(x86.JB, (byte)2);
        this.asm.emit1_Imm8(x86.INT_i8, (byte)5);
        this.asm.emit2_Mem(x86.PUSH_m, 0, 3, 128, 0);
    }

    private final void ALOAD8helper() {
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Mem(x86.CMP_r_m32, 3, -12, 0);
        this.asm.emitCJUMP_Short(x86.JB, (byte)2);
        this.asm.emit1_Imm8(x86.INT_i8, (byte)5);
        this.asm.emit2_Mem(x86.PUSH_m, 0, 3, 192, 4);
        this.asm.emit2_Mem(x86.PUSH_m, 0, 3, 192, 0);
    }

    public void visitIALOAD() {
        super.visitIALOAD();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": IALOAD"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ALOAD4helper();
    }

    public void visitLALOAD() {
        super.visitLALOAD();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LALOAD"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ALOAD8helper();
    }

    public void visitFALOAD() {
        super.visitFALOAD();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": FALOAD"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ALOAD4helper();
    }

    public void visitDALOAD() {
        super.visitDALOAD();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DALOAD"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ALOAD8helper();
    }

    public void visitAALOAD() {
        super.visitAALOAD();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": AALOAD"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ALOAD4helper();
    }

    public void visitBALOAD() {
        super.visitBALOAD();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": BALOAD"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Mem(x86.CMP_r_m32, 3, -12, 0);
        this.asm.emitCJUMP_Short(x86.JB, (byte)2);
        this.asm.emit1_Imm8(x86.INT_i8, (byte)5);
        this.asm.emit3_Reg_Mem(x86.MOVSX_r_m8, 1, 0, 3, 0, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 1);
    }

    public void visitCALOAD() {
        super.visitCALOAD();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": CALOAD"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Mem(x86.CMP_r_m32, 3, -12, 0);
        this.asm.emitCJUMP_Short(x86.JB, (byte)2);
        this.asm.emit1_Imm8(x86.INT_i8, (byte)5);
        this.asm.emit3_Reg_Mem(x86.MOVZX_r_m16, 1, 0, 3, 64, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 1);
    }

    public void visitSALOAD() {
        super.visitSALOAD();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": SALOAD"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Mem(x86.CMP_r_m32, 3, -12, 0);
        this.asm.emitCJUMP_Short(x86.JB, (byte)2);
        this.asm.emit1_Imm8(x86.INT_i8, (byte)5);
        this.asm.emit3_Reg_Mem(x86.MOVSX_r_m16, 1, 0, 3, 64, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 1);
    }

    private final void ASTORE2helper() {
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Mem(x86.CMP_r_m32, 3, -12, 0);
        this.asm.emitCJUMP_Short(x86.JB, (byte)2);
        this.asm.emit1_Imm8(x86.INT_i8, (byte)5);
        this.asm.emitprefix((byte)102);
        this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 1, 0, 3, 64, 0);
    }

    private final void ASTORE4helper() {
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Mem(x86.CMP_r_m32, 3, -12, 0);
        this.asm.emitCJUMP_Short(x86.JB, (byte)2);
        this.asm.emit1_Imm8(x86.INT_i8, (byte)5);
        this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 1, 0, 3, 128, 0);
    }

    private final void ASTORE8helper() {
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.POP_r, 2);
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Mem(x86.CMP_r_m32, 3, -12, 0);
        this.asm.emitCJUMP_Short(x86.JB, (byte)2);
        this.asm.emit1_Imm8(x86.INT_i8, (byte)5);
        this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 1, 0, 3, 192, 0);
        this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 2, 0, 3, 192, 4);
    }

    public void visitIASTORE() {
        super.visitIASTORE();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": IASTORE"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ASTORE4helper();
    }

    public void visitLASTORE() {
        super.visitLASTORE();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LASTORE"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ASTORE8helper();
    }

    public void visitFASTORE() {
        super.visitFASTORE();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": FASTORE"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ASTORE4helper();
    }

    public void visitDASTORE() {
        super.visitDASTORE();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DASTORE"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ASTORE8helper();
    }

    public void visitAASTORE() {
        super.visitAASTORE();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": AASTORE"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.PUSH_m, 0, 4);
        this.asm.emit2_Mem(x86.PUSH_m, 12, 4);
        this.emitCallRelative(TypeCheck._arrayStoreCheck);
        this.ASTORE4helper();
    }

    public void visitBASTORE() {
        super.visitBASTORE();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": BASTORE"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Mem(x86.CMP_r_m32, 3, -12, 0);
        this.asm.emitCJUMP_Short(x86.JB, (byte)2);
        this.asm.emit1_Imm8(x86.INT_i8, (byte)5);
        this.asm.emit2_Reg_Mem(x86.MOV_m_r8, 1, 0, 3, 0, 0);
    }

    public void visitCASTORE() {
        super.visitCASTORE();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": CASTORE"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ASTORE2helper();
    }

    public void visitSASTORE() {
        super.visitSASTORE();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": SASTORE"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.ASTORE2helper();
    }

    public void visitPOP() {
        super.visitPOP();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": POP"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
    }

    public void visitPOP2() {
        super.visitPOP2();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": POP2"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
    }

    public void visitDUP() {
        super.visitDUP();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DUP"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.PUSH_m, 0, 4);
    }

    public void visitDUP_x1() {
        super.visitDUP_x1();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DUP_x1"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitDUP_x2() {
        super.visitDUP_x2();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DUP_x2"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 1);
        this.asm.emitShort_Reg(x86.PUSH_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitDUP2() {
        super.visitDUP2();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DUP2"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitDUP2_x1() {
        super.visitDUP2_x1();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DUP2_x1"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.PUSH_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 1);
        this.asm.emitShort_Reg(x86.PUSH_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitDUP2_x2() {
        super.visitDUP2_x2();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DUP2_x2"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.POP_r, 2);
        this.asm.emitShort_Reg(x86.PUSH_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 2);
        this.asm.emitShort_Reg(x86.PUSH_r, 1);
        this.asm.emitShort_Reg(x86.PUSH_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitSWAP() {
        super.visitSWAP();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": SWAP"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 3);
    }

    public void visitIBINOP(byte by) {
        super.visitIBINOP(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": IBINOP " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        switch (by) {
            case 0: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitARITH_Reg_Mem(x86.ADD_m_r32, 0, 0, 4);
                break;
            }
            case 1: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitARITH_Reg_Mem(x86.SUB_m_r32, 0, 0, 4);
                break;
            }
            case 2: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit2_Mem(x86.IMUL_rda_m32, 0, 4);
                this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 0, 0, 4);
                break;
            }
            case 3: {
                this.asm.emitShort_Reg(x86.POP_r, 1);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit1(x86.CWD);
                this.asm.emit2_Reg(x86.IDIV_r32, 1);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                break;
            }
            case 4: {
                this.asm.emitShort_Reg(x86.POP_r, 1);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit1(x86.CWD);
                this.asm.emit2_Reg(x86.IDIV_r32, 1);
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                break;
            }
            case 5: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit2_Reg_Mem(x86.AND_m_r32, 0, 0, 4);
                break;
            }
            case 6: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit2_Reg_Mem(x86.OR_m_r32, 0, 0, 4);
                break;
            }
            case 7: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emit2_Reg_Mem(x86.XOR_m_r32, 0, 0, 4);
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
    }

    public void visitLBINOP(byte by) {
        super.visitLBINOP(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LBINOP " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        switch (by) {
            case 0: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 3);
                this.asm.emit2_Reg_Mem(x86.ADD_m_r32, 0, 0, 4);
                this.asm.emit2_Reg_Mem(x86.ADC_m_r32, 3, 4, 4);
                break;
            }
            case 1: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 3);
                this.asm.emit2_Reg_Mem(x86.SUB_m_r32, 0, 0, 4);
                this.asm.emit2_Reg_Mem(x86.SBB_m_r32, 3, 4, 4);
                break;
            }
            case 2: {
                this.asm.emitShort_Reg(x86.POP_r, 3);
                this.asm.emitShort_Reg(x86.POP_r, 1);
                this.asm.emitShort_Reg(x86.POP_r, 6);
                this.asm.emitShort_Reg(x86.POP_r, 7);
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 7);
                this.asm.emitARITH_Reg_Reg(x86.OR_r_r32, 0, 1);
                this.asm.emitCJUMP_Short(x86.JNE, (byte)0);
                int n = this.asm.getCurrentOffset();
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 6);
                this.asm.emit2_Reg(x86.MUL_rda_r32, 3);
                this.asm.emitJUMP_Short(x86.JMP, (byte)0);
                this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                n = this.asm.getCurrentOffset();
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 6);
                this.asm.emit2_Reg(x86.MUL_rda_r32, 1);
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 1, 0);
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 7);
                this.asm.emit2_Reg(x86.MUL_rda_r32, 3);
                this.asm.emitARITH_Reg_Reg(x86.ADD_r_r32, 1, 0);
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 6);
                this.asm.emit2_Reg(x86.MUL_rda_r32, 3);
                this.asm.emitARITH_Reg_Reg(x86.ADD_r_r32, 2, 1);
                this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                break;
            }
            case 3: {
                this.emitCallRelative(MathSupport._ldiv);
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                break;
            }
            case 4: {
                this.emitCallRelative(MathSupport._lrem);
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                break;
            }
            case 5: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
                this.asm.emit2_Reg_Mem(x86.AND_m_r32, 0, 0, 4);
                this.asm.emit2_Reg_Mem(x86.AND_m_r32, 2, 4, 4);
                break;
            }
            case 6: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
                this.asm.emit2_Reg_Mem(x86.OR_m_r32, 0, 0, 4);
                this.asm.emit2_Reg_Mem(x86.OR_m_r32, 2, 4, 4);
                break;
            }
            case 7: {
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
                this.asm.emit2_Reg_Mem(x86.XOR_m_r32, 0, 0, 4);
                this.asm.emit2_Reg_Mem(x86.XOR_m_r32, 2, 4, 4);
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
    }

    public void visitFBINOP(byte by) {
        super.visitFBINOP(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": FBINOP " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        switch (by) {
            case 0: {
                this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
                this.asm.emit2_Mem(x86.FADD_m32, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
                this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
                break;
            }
            case 1: {
                this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
                this.asm.emit2_Mem(x86.FSUB_m32, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
                this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
                break;
            }
            case 2: {
                this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
                this.asm.emit2_Mem(x86.FMUL_m32, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
                this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
                break;
            }
            case 3: {
                this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
                this.asm.emit2_Mem(x86.FDIV_m32, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
                this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
                break;
            }
            case 4: {
                this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
                this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
                this.asm.emit2(x86.FPREM);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
                this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
                this.asm.emit2_FPReg(x86.FFREE, 0);
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
    }

    public void visitDBINOP(byte by) {
        super.visitDBINOP(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DBINOP " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        switch (by) {
            case 0: {
                this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
                this.asm.emit2_Mem(x86.FADD_m64, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
                this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
                break;
            }
            case 1: {
                this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
                this.asm.emit2_Mem(x86.FSUB_m64, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
                this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
                break;
            }
            case 2: {
                this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
                this.asm.emit2_Mem(x86.FMUL_m64, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
                this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
                break;
            }
            case 3: {
                this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
                this.asm.emit2_Mem(x86.FDIV_m64, 0, 4);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
                this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
                break;
            }
            case 4: {
                this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
                this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
                this.asm.emit2(x86.FPREM);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
                this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
                this.asm.emit2_FPReg(x86.FFREE, 0);
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
    }

    public void visitIUNOP(byte by) {
        super.visitIUNOP(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": IUNOP " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        boolean bl = false;
        if (by == 0) {
            bl = true;
        }
        Assert._assert(bl);
        this.asm.emit2_Mem(x86.NEG_m32, 0, 4);
    }

    public void visitLUNOP(byte by) {
        super.visitLUNOP(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LUNOP " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        boolean bl = false;
        if (by == 0) {
            bl = true;
        }
        Assert._assert(bl);
        this.asm.emit2_Mem(x86.NEG_m32, 4, 4);
        this.asm.emit2_Mem(x86.NEG_m32, 0, 4);
        this.asm.emitARITH_Mem_Imm(x86.SBB_m_i32, 4, 4, 0);
    }

    public void visitFUNOP(byte by) {
        super.visitFUNOP(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": FUNOP " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        boolean bl = false;
        if (by == 0) {
            bl = true;
        }
        Assert._assert(bl);
        this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
        this.asm.emit2(x86.FCHS);
        this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
    }

    public void visitDUNOP(byte by) {
        super.visitDUNOP(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DUNOP " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
        this.asm.emit2(x86.FCHS);
        this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
    }

    public void visitISHIFT(byte by) {
        super.visitISHIFT(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ISHIFT " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        switch (by) {
            case 0: {
                this.asm.emitShort_Reg(x86.POP_r, 1);
                this.asm.emit2_Mem(x86.SHL_m32_rc, 0, 4);
                break;
            }
            case 1: {
                this.asm.emitShort_Reg(x86.POP_r, 1);
                this.asm.emit2_Mem(x86.SAR_m32_rc, 0, 4);
                break;
            }
            case 2: {
                this.asm.emitShort_Reg(x86.POP_r, 1);
                this.asm.emit2_Mem(x86.SHR_m32_rc, 0, 4);
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
    }

    public void visitLSHIFT(byte by) {
        super.visitLSHIFT(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LSHIFT" + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        switch (by) {
            case 0: {
                this.asm.emitShort_Reg(x86.POP_r, 1);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
                this.asm.emitARITH_Reg_Imm(x86.AND_r_i32, 1, 63);
                this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 1, 32);
                this.asm.emitCJUMP_Short(x86.JAE, (byte)0);
                int n = this.asm.getCurrentOffset();
                this.asm.emitSHLD_r_r_rc(2, 0);
                this.asm.emit2_Reg(x86.SHL_r32_rc, 0);
                this.asm.emitJUMP_Short(x86.JMP, (byte)0);
                this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                n = this.asm.getCurrentOffset();
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 2, 0);
                this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 0, 0);
                this.asm.emit2_Reg(x86.SHL_r32_rc, 2);
                this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                break;
            }
            case 1: {
                this.asm.emitShort_Reg(x86.POP_r, 1);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
                this.asm.emitARITH_Reg_Imm(x86.AND_r_i32, 1, 63);
                this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 1, 32);
                this.asm.emitCJUMP_Short(x86.JAE, (byte)0);
                int n = this.asm.getCurrentOffset();
                this.asm.emitSHRD_r_r_rc(0, 2);
                this.asm.emit2_Reg(x86.SAR_r32_rc, 2);
                this.asm.emitJUMP_Short(x86.JMP, (byte)0);
                this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                n = this.asm.getCurrentOffset();
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 2);
                this.asm.emit2_SHIFT_Reg_Imm8(x86.SAR_r32_i, 2, (byte)31);
                this.asm.emit2_Reg(x86.SAR_r32_rc, 0);
                this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                break;
            }
            case 2: {
                this.asm.emitShort_Reg(x86.POP_r, 1);
                this.asm.emitShort_Reg(x86.POP_r, 0);
                this.asm.emitShort_Reg(x86.POP_r, 2);
                this.asm.emitARITH_Reg_Imm(x86.AND_r_i32, 1, 63);
                this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 1, 32);
                this.asm.emitCJUMP_Short(x86.JAE, (byte)0);
                int n = this.asm.getCurrentOffset();
                this.asm.emitSHRD_r_r_rc(0, 2);
                this.asm.emit2_Reg(x86.SHR_r32_rc, 2);
                this.asm.emitJUMP_Short(x86.JMP, (byte)0);
                this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                n = this.asm.getCurrentOffset();
                this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 0, 2);
                this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 2, 2);
                this.asm.emit2_Reg(x86.SHR_r32_rc, 0);
                this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
                this.asm.emitShort_Reg(x86.PUSH_r, 2);
                this.asm.emitShort_Reg(x86.PUSH_r, 0);
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
    }

    public void visitIINC(int n, int n2) {
        super.visitIINC(n, n2);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": IINC " + n + ' ' + n2));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitARITH_Mem_Imm(x86.ADD_m_i32, this.getLocalOffset(n), 5, n2);
    }

    public void visitI2L() {
        super.visitI2L();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": I2L"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emit1(x86.CWD);
        this.asm.emitShort_Reg(x86.PUSH_r, 2);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitI2F() {
        super.visitI2F();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": I2F"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FILD_m32, 0, 4);
        this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
    }

    public void visitI2D() {
        super.visitI2D();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": I2D"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FILD_m32, 0, 4);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, -4, 4);
        this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
    }

    public void visitL2I() {
        super.visitL2I();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": L2I"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitL2F() {
        super.visitL2F();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": L2F"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FILD_m64, 0, 4);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
        this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
    }

    public void visitL2D() {
        super.visitL2D();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": L2D"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FILD_m64, 0, 4);
        this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
    }

    private final void toIntHelper() {
        this.emitFLD64(MathSupport._maxint);
        this.asm.emit2_FPReg(x86.FUCOMIP, 1);
        this.asm.emitCJUMP_Short(x86.JP, (byte)0);
        int n = this.asm.getCurrentOffset();
        this.asm.emitCJUMP_Short(x86.JBE, (byte)0);
        int n2 = this.asm.getCurrentOffset();
        this.emitFLD64(MathSupport._minint);
        this.asm.emit2_FPReg(x86.FUCOMIP, 1);
        this.asm.emitCJUMP_Short(x86.JAE, (byte)0);
        int n3 = this.asm.getCurrentOffset();
        this.asm.emit2_Reg_Mem(x86.LEA, 4, -8, 4);
        this.asm.emit2_Mem(x86.FNSTCW, 4, 4);
        this.asm.emit2_Mem(x86.FNSTCW, 0, 4);
        this.asm.emitARITH_Mem_Imm(x86.OR_m_i32, 4, 4, 3072);
        this.asm.emit2(x86.FNCLEX);
        this.asm.emit2_Mem(x86.FLDCW, 4, 4);
        this.asm.emit2_Mem(x86.FISTP_m32, 8, 4);
        this.asm.emit2(x86.FNCLEX);
        this.asm.emit2_Mem(x86.FLDCW, 0, 4);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n4 = this.asm.getCurrentOffset();
        this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, 0);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n5 = this.asm.getCurrentOffset();
        this.asm.patch1(n2 - 1, (byte)(this.asm.getCurrentOffset() - n2));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, Integer.MAX_VALUE);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n6 = this.asm.getCurrentOffset();
        this.asm.patch1(n3 - 1, (byte)(this.asm.getCurrentOffset() - n3));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, Integer.MIN_VALUE);
        this.asm.patch1(n5 - 1, (byte)(this.asm.getCurrentOffset() - n5));
        this.asm.patch1(n6 - 1, (byte)(this.asm.getCurrentOffset() - n6));
        this.asm.emit2_FPReg(x86.FFREE, 0);
        this.asm.patch1(n4 - 1, (byte)(this.asm.getCurrentOffset() - n4));
    }

    private final void toLongHelper() {
        this.emitFLD64(MathSupport._maxlong);
        this.asm.emit2_FPReg(x86.FUCOMIP, 1);
        this.asm.emitCJUMP_Short(x86.JP, (byte)0);
        int n = this.asm.getCurrentOffset();
        this.asm.emitCJUMP_Short(x86.JBE, (byte)0);
        int n2 = this.asm.getCurrentOffset();
        this.emitFLD64(MathSupport._minlong);
        this.asm.emit2_FPReg(x86.FUCOMIP, 1);
        this.asm.emitCJUMP_Short(x86.JAE, (byte)0);
        int n3 = this.asm.getCurrentOffset();
        this.asm.emit2_Reg_Mem(x86.LEA, 4, -8, 4);
        this.asm.emit2_Mem(x86.FNSTCW, 4, 4);
        this.asm.emit2_Mem(x86.FNSTCW, 0, 4);
        this.asm.emitARITH_Mem_Imm(x86.OR_m_i32, 4, 4, 3072);
        this.asm.emit2(x86.FNCLEX);
        this.asm.emit2_Mem(x86.FLDCW, 4, 4);
        this.asm.emit2_Mem(x86.FISTP_m64, 8, 4);
        this.asm.emit2(x86.FNCLEX);
        this.asm.emit2_Mem(x86.FLDCW, 0, 4);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n4 = this.asm.getCurrentOffset();
        this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, 0);
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 4, 4, 0);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n5 = this.asm.getCurrentOffset();
        this.asm.patch1(n2 - 1, (byte)(this.asm.getCurrentOffset() - n2));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, -1);
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 4, 4, Integer.MAX_VALUE);
        this.asm.emitJUMP_Short(x86.JMP, (byte)0);
        int n6 = this.asm.getCurrentOffset();
        this.asm.patch1(n3 - 1, (byte)(this.asm.getCurrentOffset() - n3));
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 0, 4, 0);
        this.asm.emit2_Mem_Imm(x86.MOV_m_i32, 4, 4, Integer.MIN_VALUE);
        this.asm.patch1(n5 - 1, (byte)(this.asm.getCurrentOffset() - n5));
        this.asm.patch1(n6 - 1, (byte)(this.asm.getCurrentOffset() - n6));
        this.asm.emit2_FPReg(x86.FFREE, 0);
        this.asm.patch1(n4 - 1, (byte)(this.asm.getCurrentOffset() - n4));
    }

    public void visitF2I() {
        super.visitF2I();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": F2I"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
        this.toIntHelper();
    }

    public void visitF2L() {
        super.visitF2L();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": F2L"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, -4, 4);
        this.toLongHelper();
    }

    public void visitF2D() {
        super.visitF2D();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": F2D"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, -4, 4);
        this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
    }

    public void visitD2I() {
        super.visitD2I();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": D2I"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
        this.toIntHelper();
    }

    public void visitD2L() {
        super.visitD2L();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": D2L"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
        this.toLongHelper();
    }

    public void visitD2F() {
        super.visitD2F();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": D2F"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
        this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
    }

    public void visitI2B() {
        super.visitI2B();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": I2B"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emit3_Reg_Reg(x86.MOVSX_r_r8, 0, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitI2C() {
        super.visitI2C();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": I2C"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emit3_Reg_Reg(x86.MOVZX_r_r16, 0, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitI2S() {
        super.visitI2S();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": I2S"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emit3_Reg_Reg(x86.MOVSX_r_r16, 0, 0);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitLCMP2() {
        super.visitLCMP2();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LCMP2"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 3);
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitShort_Reg(x86.POP_r, 2);
        this.asm.emitARITH_Reg_Reg(x86.SUB_r_r32, 0, 3);
        this.asm.emitARITH_Reg_Reg(x86.SBB_r_r32, 2, 1);
        this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, -1);
        this.asm.emitCJUMP_Short(x86.JL, (byte)0);
        int n = this.asm.getCurrentOffset();
        this.asm.emitARITH_Reg_Reg(x86.XOR_r_r32, 1, 1);
        this.asm.emitARITH_Reg_Reg(x86.OR_r_r32, 0, 2);
        this.asm.emitCJUMP_Short(x86.JE, (byte)0);
        int n2 = this.asm.getCurrentOffset();
        this.asm.emitShort_Reg(x86.INC_r32, 1);
        this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        this.asm.patch1(n2 - 1, (byte)(this.asm.getCurrentOffset() - n2));
        this.asm.emitShort_Reg(x86.PUSH_r, 1);
    }

    public void visitFCMP2(byte by) {
        super.visitFCMP2(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": FCMP2 " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        if (by == 0) {
            this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
            this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
        } else {
            this.asm.emit2_Mem(x86.FLD_m32, 4, 4);
            this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
        }
        this.asm.emit2(x86.FUCOMPP);
        this.asm.emit2(x86.FNSTSW_ax);
        this.asm.emit1(x86.SAHF);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
        if (by == 0) {
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, -1);
        } else {
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 1);
        }
        this.asm.emitCJUMP_Short(x86.JB, (byte)0);
        int n = this.asm.getCurrentOffset();
        this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
        this.asm.emitCJUMP_Short(x86.JE, (byte)0);
        int n2 = this.asm.getCurrentOffset();
        if (by == 0) {
            this.asm.emitShort_Reg(x86.INC_r32, 1);
        } else {
            this.asm.emitShort_Reg(x86.DEC_r32, 1);
        }
        this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        this.asm.patch1(n2 - 1, (byte)(this.asm.getCurrentOffset() - n2));
        this.asm.emitShort_Reg(x86.PUSH_r, 1);
    }

    public void visitDCMP2(byte by) {
        super.visitDCMP2(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DCMP2 " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        if (by == 0) {
            this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
            this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
        } else {
            this.asm.emit2_Mem(x86.FLD_m64, 8, 4);
            this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
        }
        this.asm.emit2(x86.FUCOMPP);
        this.asm.emit2(x86.FNSTSW_ax);
        this.asm.emit1(x86.SAHF);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, 16, 4);
        if (by == 0) {
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, -1);
        } else {
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 1);
        }
        this.asm.emitCJUMP_Short(x86.JB, (byte)0);
        int n = this.asm.getCurrentOffset();
        this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
        this.asm.emitCJUMP_Short(x86.JE, (byte)0);
        int n2 = this.asm.getCurrentOffset();
        if (by == 0) {
            this.asm.emitShort_Reg(x86.INC_r32, 1);
        } else {
            this.asm.emitShort_Reg(x86.DEC_r32, 1);
        }
        this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
        this.asm.patch1(n2 - 1, (byte)(this.asm.getCurrentOffset() - n2));
        this.asm.emitShort_Reg(x86.PUSH_r, 1);
    }

    private final void branchHelper(byte by, int n) {
        Integer n2 = new Integer(n);
        if (by == 7) {
            if (n <= this.i_start) {
                this.asm.emitJUMP_Back(x86.JMP, n2);
            } else {
                this.asm.emitJUMP_Forw(x86.JMP, n2);
            }
        } else {
            x86 x862 = null;
            switch (by) {
                case 0: {
                    x862 = x86.JE;
                    break;
                }
                case 1: {
                    x862 = x86.JNE;
                    break;
                }
                case 2: {
                    x862 = x86.JL;
                    break;
                }
                case 3: {
                    x862 = x86.JGE;
                    break;
                }
                case 4: {
                    x862 = x86.JLE;
                    break;
                }
                case 5: {
                    x862 = x86.JG;
                    break;
                }
                case 6: {
                    x862 = x86.JAE;
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
            if (n <= this.i_start) {
                this.asm.emitCJUMP_Back(x862, n2);
            } else {
                this.asm.emitCJUMP_Forw(x862, n2);
            }
        }
    }

    public void visitIF(byte by, int n) {
        super.visitIF(by, n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": IF " + by + ' ' + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 0, 0);
        this.branchHelper(by, n);
    }

    public void visitIFREF(byte by, int n) {
        super.visitIFREF(by, n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": IFREF " + by + ' ' + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 0, 0);
        this.branchHelper(by, n);
    }

    public void visitIFCMP(byte by, int n) {
        super.visitIFCMP(by, n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": IFCMP " + by + ' ' + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Reg(x86.CMP_r_r32, 0, 1);
        this.branchHelper(by, n);
    }

    public void visitIFREFCMP(byte by, int n) {
        super.visitIFREFCMP(by, n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": IFREFCMP " + by + ' ' + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitARITH_Reg_Reg(x86.CMP_r_r32, 0, 1);
        this.branchHelper(by, n);
    }

    public void visitGOTO(int n) {
        super.visitGOTO(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GOTO " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.branchHelper((byte)7, n);
    }

    public void visitJSR(int n) {
        super.visitJSR(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": JSR " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        Integer n2 = new Integer(n);
        if (n <= this.i_start) {
            this.asm.emitCALL_Back(x86.CALL_rel32, n2);
        } else {
            this.asm.emitCALL_Forw(x86.CALL_rel32, n2);
        }
    }

    public void visitRET(int n) {
        super.visitRET(n);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": RET " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit2_Mem(x86.JMP_m, this.getLocalOffset(n), 5);
    }

    public void visitTABLESWITCH(int n, int n2, int n3, int[] nArray) {
        super.visitTABLESWITCH(n, n2, n3, nArray);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": TABLESWITCH " + n + ' ' + n2 + ' ' + n3));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        int n4 = n3 - n2 + 1;
        boolean bl = false;
        if (n4 == nArray.length) {
            bl = true;
        }
        Assert._assert(bl);
        this.asm.emitShort_Reg(x86.POP_r, 0);
        if (n2 != 0) {
            this.asm.emitARITH_Reg_Imm(x86.SUB_r_i32, 0, n2);
        }
        this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 0, n4);
        this.branchHelper((byte)6, n);
        this.asm.emitCALL_rel32(x86.CALL_rel32, 0);
        int n5 = this.asm.getCurrentOffset();
        this.asm.emitShort_Reg(x86.POP_r, 1);
        this.asm.emit2_Reg_Mem(x86.LEA, 2, 1, 0, 128, 127);
        int n6 = this.asm.getCurrentOffset();
        this.asm.emitARITH_Reg_Mem(x86.ADD_r_m32, 2, -4, 2);
        this.asm.emit2_Reg(x86.JMP_r, 2);
        this.asm.patch1(n6 - 1, (byte)(this.asm.getCurrentOffset() - n5 + 4));
        int n7 = 0;
        while (n7 < n4) {
            int n8 = nArray[n7];
            Integer n9 = new Integer(n8);
            if (n8 <= this.i_start) {
                int n10 = this.asm.getBranchTarget(n9) - this.asm.getCurrentOffset() + 4;
                this.asm.emitDATA(n10);
            } else {
                this.asm.emitDATA(0x77777777);
                this.asm.recordForwardBranch(4, n9);
            }
            ++n7;
        }
    }

    public void visitLOOKUPSWITCH(int n, int[] nArray, int[] nArray2) {
        super.visitLOOKUPSWITCH(n, nArray, nArray2);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LOOKUPSWITCH " + n));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 0, n3);
            int n4 = nArray2[n2];
            this.branchHelper((byte)0, n4);
            ++n2;
        }
        this.branchHelper((byte)7, n);
    }

    private final void SYNCHEXIThelper() {
        if (this.method.isStatic()) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString("exit: STATIC SYNCH EXIT"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            Class clazz = Reflection.getJDKType(this.method.getDeclaringClass());
            boolean bl = false;
            if (clazz != null) {
                bl = true;
            }
            Assert._assert(bl);
            this.emitPushAddressOf(clazz);
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString("exit: INSTANCE SYNCH EXIT"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emit2_Mem(x86.PUSH_m, this.getLocalOffset(0), 5);
        }
        this.emitCallRelative(Monitor._monitorexit);
    }

    private final void RETURN4helper() {
        if (this.method.isSynchronized()) {
            this.SYNCHEXIThelper();
        }
        if (this.TraceMethods) {
            this.emitPushAddressOf(SystemInterface.toCString("Leaving: " + this.method));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emit1(x86.LEAVE);
        this.asm.emit1_Imm16(x86.RET_i, (char)(this.n_paramwords << 2));
    }

    private final void RETURN8helper() {
        if (this.method.isSynchronized()) {
            this.SYNCHEXIThelper();
        }
        if (this.TraceMethods) {
            this.emitPushAddressOf(SystemInterface.toCString("Leaving: " + this.method));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emitShort_Reg(x86.POP_r, 2);
        this.asm.emit1(x86.LEAVE);
        this.asm.emit1_Imm16(x86.RET_i, (char)(this.n_paramwords << 2));
    }

    public void visitIRETURN() {
        super.visitIRETURN();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": IRETURN"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.RETURN4helper();
    }

    public void visitLRETURN() {
        super.visitLRETURN();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": LRETURN"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.RETURN8helper();
    }

    public void visitFRETURN() {
        super.visitFRETURN();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": FRETURN"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.RETURN4helper();
    }

    public void visitDRETURN() {
        super.visitDRETURN();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": DRETURN"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.RETURN8helper();
    }

    public void visitARETURN() {
        super.visitARETURN();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ARETURN"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.RETURN4helper();
    }

    public void visitVRETURN() {
        super.visitVRETURN();
        if (this.method.isSynchronized()) {
            this.SYNCHEXIThelper();
        }
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": VRETURN"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        if (this.TraceMethods) {
            this.emitPushAddressOf(SystemInterface.toCString("Leaving: " + this.method));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emit1(x86.LEAVE);
        this.asm.emit1_Imm16(x86.RET_i, (char)(this.n_paramwords << 2));
    }

    public void GETSTATIC4helper(jq_StaticField jq_StaticField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_StaticField2 = this.tryResolve(jq_StaticField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GETSTATIC4 " + jq_StaticField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(10);
            this.emitPushAddressOf(jq_StaticField2);
            this.emitCallRelative(x86ReferenceLinker._getstatic4);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GETSTATIC4 " + jq_StaticField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.emitPushMemory(jq_StaticField2);
        }
    }

    static int patch_getstatic4(CodeAddress codeAddress, jq_StaticField jq_StaticField2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke4(905941136);
        codeAddress.offset(-4).poke(jq_StaticField2.getAddress());
        codeAddress.offset(-10).poke2((short)-28528);
        return 6;
    }

    public void GETSTATIC8helper(jq_StaticField jq_StaticField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_StaticField2 = this.tryResolve(jq_StaticField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GETSTATIC8 " + jq_StaticField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(12);
            this.emitPushAddressOf(jq_StaticField2);
            this.emitCallRelative(x86ReferenceLinker._getstatic8);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GETSTATIC8 " + jq_StaticField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.emitPushMemory8(jq_StaticField2);
        }
    }

    static int patch_getstatic8(CodeAddress codeAddress, jq_StaticField jq_StaticField2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke(jq_StaticField2.getAddress().offset(4));
        codeAddress.offset(-4).poke2((short)13823);
        codeAddress.offset(-2).poke(jq_StaticField2.getAddress());
        codeAddress.offset(-10).poke2((short)13823);
        return 10;
    }

    public void visitIGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitIGETSTATIC(jq_StaticField2);
        this.GETSTATIC4helper(jq_StaticField2);
    }

    public void visitLGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitLGETSTATIC(jq_StaticField2);
        this.GETSTATIC8helper(jq_StaticField2);
    }

    public void visitFGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitFGETSTATIC(jq_StaticField2);
        this.GETSTATIC4helper(jq_StaticField2);
    }

    public void visitDGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitDGETSTATIC(jq_StaticField2);
        this.GETSTATIC8helper(jq_StaticField2);
    }

    public void visitAGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitAGETSTATIC(jq_StaticField2);
        this.GETSTATIC4helper(jq_StaticField2);
    }

    public void visitZGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitZGETSTATIC(jq_StaticField2);
        this.GETSTATIC4helper(jq_StaticField2);
    }

    public void visitBGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitBGETSTATIC(jq_StaticField2);
        this.GETSTATIC4helper(jq_StaticField2);
    }

    public void visitCGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitCGETSTATIC(jq_StaticField2);
        this.GETSTATIC4helper(jq_StaticField2);
    }

    public void visitSGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitSGETSTATIC(jq_StaticField2);
        this.GETSTATIC4helper(jq_StaticField2);
    }

    public void PUTSTATIC4helper(jq_StaticField jq_StaticField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_StaticField2 = this.tryResolve(jq_StaticField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTSTATIC4 " + jq_StaticField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(10);
            this.emitPushAddressOf(jq_StaticField2);
            this.emitCallRelative(x86ReferenceLinker._putstatic4);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTSTATIC4 " + jq_StaticField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.emitPopMemory(jq_StaticField2);
        }
    }

    static int patch_putstatic4(CodeAddress codeAddress, jq_StaticField jq_StaticField2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke4(93294736);
        codeAddress.offset(-4).poke(jq_StaticField2.getAddress());
        codeAddress.offset(-10).poke2((short)-28528);
        return 6;
    }

    public void PUTSTATIC8helper(jq_StaticField jq_StaticField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_StaticField2 = this.tryResolve(jq_StaticField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTSTATIC8 " + jq_StaticField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(12);
            this.emitPushAddressOf(jq_StaticField2);
            this.emitCallRelative(x86ReferenceLinker._putstatic8);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTSTATIC8 " + jq_StaticField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.emitPopMemory8(jq_StaticField2);
        }
    }

    static int patch_putstatic8(CodeAddress codeAddress, jq_StaticField jq_StaticField2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke(jq_StaticField2.getAddress().offset(4));
        codeAddress.offset(-4).poke2((short)1423);
        codeAddress.offset(-2).poke(jq_StaticField2.getAddress());
        codeAddress.offset(-10).poke2((short)1423);
        return 10;
    }

    public void visitIPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitIPUTSTATIC(jq_StaticField2);
        this.PUTSTATIC4helper(jq_StaticField2);
    }

    public void visitLPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitLPUTSTATIC(jq_StaticField2);
        this.PUTSTATIC8helper(jq_StaticField2);
    }

    public void visitFPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitFPUTSTATIC(jq_StaticField2);
        this.PUTSTATIC4helper(jq_StaticField2);
    }

    public void visitDPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitDPUTSTATIC(jq_StaticField2);
        this.PUTSTATIC8helper(jq_StaticField2);
    }

    public void visitAPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitAPUTSTATIC(jq_StaticField2);
        this.PUTSTATIC4helper(jq_StaticField2);
    }

    public void visitZPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitZPUTSTATIC(jq_StaticField2);
        this.PUTSTATIC4helper(jq_StaticField2);
    }

    public void visitBPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitBPUTSTATIC(jq_StaticField2);
        this.PUTSTATIC4helper(jq_StaticField2);
    }

    public void visitCPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitCPUTSTATIC(jq_StaticField2);
        this.PUTSTATIC4helper(jq_StaticField2);
    }

    public void visitSPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitSPUTSTATIC(jq_StaticField2);
        this.PUTSTATIC4helper(jq_StaticField2);
    }

    public void GETFIELD1helper(jq_InstanceField jq_InstanceField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2 = this.tryResolve(jq_InstanceField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GETFIELD1 " + jq_InstanceField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(10);
            this.emitPushAddressOf(jq_InstanceField2);
            this.emitCallRelative(x86ReferenceLinker._getfield1);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GETFIELD1 " + jq_InstanceField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit3_Reg_Mem(x86.MOVSX_r_m8, 3, jq_InstanceField2.getOffset(), 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
        }
    }

    static int patch_getfield1(CodeAddress codeAddress, jq_InstanceField jq_InstanceField2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke4(10010127);
        codeAddress.offset(-5).poke4(jq_InstanceField2.getOffset());
        codeAddress.offset(-1).poke1((byte)83);
        codeAddress.offset(-10).poke2((short)22672);
        return 9;
    }

    public void GETFIELD4helper(jq_InstanceField jq_InstanceField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2 = this.tryResolve(jq_InstanceField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GETFIELD4 " + jq_InstanceField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(10);
            this.emitPushAddressOf(jq_InstanceField2);
            this.emitCallRelative(x86ReferenceLinker._getfield4);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GETFIELD4 " + jq_InstanceField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Mem(x86.PUSH_m, jq_InstanceField2.getOffset(), 0);
        }
    }

    static int patch_getfield4(CodeAddress codeAddress, jq_InstanceField jq_InstanceField2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke4(-1325442928);
        codeAddress.offset(-4).poke4(jq_InstanceField2.getOffset());
        codeAddress.offset(-10).poke2((short)-28528);
        return 7;
    }

    public void GETFIELD8helper(jq_InstanceField jq_InstanceField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2 = this.tryResolve(jq_InstanceField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GETFIELD8 " + jq_InstanceField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(13);
            this.emitPushAddressOf(jq_InstanceField2);
            this.emitCallRelative(x86ReferenceLinker._getfield8);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": GETFIELD8 " + jq_InstanceField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Mem(x86.PUSH_m, jq_InstanceField2.getOffset() + 4, 0);
            this.asm.emit2_Mem(x86.PUSH_m, jq_InstanceField2.getOffset(), 0);
        }
    }

    static int patch_getfield8(CodeAddress codeAddress, jq_InstanceField jq_InstanceField2) {
        codeAddress.offset(-10).poke4(11599851);
        codeAddress.offset(-7).poke4(jq_InstanceField2.getOffset() + 4);
        codeAddress.offset(-3).poke2((short)-20225);
        codeAddress.offset(-1).poke4(jq_InstanceField2.getOffset());
        codeAddress.offset(-10).poke1((byte)88);
        return 10;
    }

    public void visitIGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitIGETFIELD(jq_InstanceField2);
        this.GETFIELD4helper(jq_InstanceField2);
    }

    public void visitLGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitLGETFIELD(jq_InstanceField2);
        this.GETFIELD8helper(jq_InstanceField2);
    }

    public void visitFGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitFGETFIELD(jq_InstanceField2);
        this.GETFIELD4helper(jq_InstanceField2);
    }

    public void visitDGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitDGETFIELD(jq_InstanceField2);
        this.GETFIELD8helper(jq_InstanceField2);
    }

    public void visitAGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitAGETFIELD(jq_InstanceField2);
        this.GETFIELD4helper(jq_InstanceField2);
    }

    public void visitBGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitBGETFIELD(jq_InstanceField2);
        this.GETFIELD1helper(jq_InstanceField2);
    }

    public void visitCGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitCGETFIELD(jq_InstanceField2);
        jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2);
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": CGETFIELD " + jq_InstanceField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(10);
            this.emitPushAddressOf(jq_InstanceField2);
            this.emitCallRelative(x86ReferenceLinker._cgetfield);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": CGETFIELD " + jq_InstanceField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit3_Reg_Mem(x86.MOVZX_r_m16, 3, jq_InstanceField2.getOffset(), 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
        }
    }

    static int patch_cgetfield(CodeAddress codeAddress, jq_InstanceField jq_InstanceField2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke4(10008335);
        codeAddress.offset(-5).poke4(jq_InstanceField2.getOffset());
        codeAddress.offset(-1).poke1((byte)83);
        codeAddress.offset(-10).poke2((short)22672);
        return 9;
    }

    public void visitSGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitSGETFIELD(jq_InstanceField2);
        jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2);
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": SGETFIELD " + jq_InstanceField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(10);
            this.emitPushAddressOf(jq_InstanceField2);
            this.emitCallRelative(x86ReferenceLinker._sgetfield);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": SGETFIELD " + jq_InstanceField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit3_Reg_Mem(x86.MOVSX_r_m16, 3, jq_InstanceField2.getOffset(), 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 3);
        }
    }

    static int patch_sgetfield(CodeAddress codeAddress, jq_InstanceField jq_InstanceField2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke4(10010383);
        codeAddress.offset(-5).poke4(jq_InstanceField2.getOffset());
        codeAddress.offset(-1).poke1((byte)83);
        codeAddress.offset(-10).poke2((short)22672);
        return 9;
    }

    public void visitZGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitZGETFIELD(jq_InstanceField2);
        this.GETFIELD1helper(jq_InstanceField2);
    }

    public void PUTFIELD1helper(jq_InstanceField jq_InstanceField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2 = this.tryResolve(jq_InstanceField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTFIELD1 " + jq_InstanceField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(10);
            this.emitPushAddressOf(jq_InstanceField2);
            this.emitCallRelative(x86ReferenceLinker._putfield1);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTFIELD1 " + jq_InstanceField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r8, 3, jq_InstanceField2.getOffset(), 0);
        }
    }

    static int patch_putfield1(CodeAddress codeAddress, jq_InstanceField jq_InstanceField2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke4(-1735894949);
        codeAddress.offset(-4).poke4(jq_InstanceField2.getOffset());
        codeAddress.offset(-10).poke2((short)-28528);
        return 8;
    }

    public void PUTFIELD2helper(jq_InstanceField jq_InstanceField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2 = this.tryResolve(jq_InstanceField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTFIELD2 " + jq_InstanceField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(10);
            this.emitPushAddressOf(jq_InstanceField2);
            this.emitCallRelative(x86ReferenceLinker._putfield2);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTFIELD2 " + jq_InstanceField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitprefix((byte)102);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, jq_InstanceField2.getOffset(), 0);
        }
    }

    static int patch_putfield2(CodeAddress codeAddress, jq_InstanceField jq_InstanceField2) {
        codeAddress.offset(-10).poke4(1717108715);
        codeAddress.offset(-6).poke2((short)-26487);
        codeAddress.offset(-4).poke4(jq_InstanceField2.getOffset());
        codeAddress.offset(-10).poke2((short)23440);
        return 9;
    }

    public void PUTFIELD4helper(jq_InstanceField jq_InstanceField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2 = this.tryResolve(jq_InstanceField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTFIELD4 " + jq_InstanceField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(10);
            this.emitPushAddressOf(jq_InstanceField2);
            this.emitCallRelative(x86ReferenceLinker._putfield4);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTFIELD4 " + jq_InstanceField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, jq_InstanceField2.getOffset(), 0);
        }
    }

    static int patch_putfield4(CodeAddress codeAddress, jq_InstanceField jq_InstanceField2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke4(-1735829413);
        codeAddress.offset(-4).poke4(jq_InstanceField2.getOffset());
        codeAddress.offset(-10).poke2((short)-28528);
        return 8;
    }

    public void PUTFIELD8helper(jq_InstanceField jq_InstanceField2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2 = this.tryResolve(jq_InstanceField2));
        if (bl) {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTFIELD8 " + jq_InstanceField2 + " (dynpatch)"));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.startDynamicPatch(15);
            this.emitPushAddressOf(jq_InstanceField2);
            this.emitCallRelative(x86ReferenceLinker._putfield8);
            this.asm.endDynamicPatch();
        } else {
            if (this.TraceBytecodes) {
                this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": PUTFIELD8 " + jq_InstanceField2));
                this.emitCallMemory(SystemInterface._debugwriteln);
            }
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, jq_InstanceField2.getOffset(), 2);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 0, jq_InstanceField2.getOffset() + 4, 2);
        }
    }

    static int patch_putfield8(CodeAddress codeAddress, jq_InstanceField jq_InstanceField2) {
        codeAddress.offset(-10).poke4(-1990524949);
        codeAddress.offset(-6).poke1((byte)-102);
        codeAddress.offset(-5).poke4(jq_InstanceField2.getOffset());
        codeAddress.offset(-1).poke2((short)-32119);
        codeAddress.offset(1).poke4(jq_InstanceField2.getOffset() + 4);
        codeAddress.offset(-10).poke2((short)22619);
        return 10;
    }

    public void visitIPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitIPUTFIELD(jq_InstanceField2);
        this.PUTFIELD4helper(jq_InstanceField2);
    }

    public void visitLPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitLPUTFIELD(jq_InstanceField2);
        this.PUTFIELD8helper(jq_InstanceField2);
    }

    public void visitFPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitFPUTFIELD(jq_InstanceField2);
        this.PUTFIELD4helper(jq_InstanceField2);
    }

    public void visitDPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitDPUTFIELD(jq_InstanceField2);
        this.PUTFIELD8helper(jq_InstanceField2);
    }

    public void visitAPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitAPUTFIELD(jq_InstanceField2);
        this.PUTFIELD4helper(jq_InstanceField2);
    }

    public void visitBPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitBPUTFIELD(jq_InstanceField2);
        this.PUTFIELD1helper(jq_InstanceField2);
    }

    public void visitCPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitCPUTFIELD(jq_InstanceField2);
        this.PUTFIELD2helper(jq_InstanceField2);
    }

    public void visitSPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitSPUTFIELD(jq_InstanceField2);
        this.PUTFIELD2helper(jq_InstanceField2);
    }

    public void visitZPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitZPUTFIELD(jq_InstanceField2);
        this.PUTFIELD1helper(jq_InstanceField2);
    }

    private final void INVOKEDPATCHhelper(byte by, jq_Method jq_Method2) {
        jq_StaticMethod jq_StaticMethod2;
        int n;
        switch (by) {
            case 0: {
                n = 16;
                jq_StaticMethod2 = x86ReferenceLinker._invokevirtual;
                break;
            }
            case 1: {
                n = 11;
                jq_StaticMethod2 = x86ReferenceLinker._invokestatic;
                break;
            }
            case 2: {
                n = 11;
                jq_StaticMethod2 = x86ReferenceLinker._invokespecial;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": INVOKE " + by + ' ' + jq_Method2 + " (dynpatch)"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.startDynamicPatch(n);
        this.emitPushAddressOf(jq_Method2);
        this.emitCallRelative(jq_StaticMethod2);
        this.asm.endDynamicPatch();
    }

    static int patch_invokevirtual(CodeAddress codeAddress, jq_InstanceMethod jq_InstanceMethod2) {
        codeAddress.offset(-10).poke2((short)-21);
        codeAddress.offset(-8).poke1((byte)36);
        int n = (jq_InstanceMethod2.getParamWords() << 2) - 4;
        codeAddress.offset(-7).poke4(n);
        codeAddress.offset(-3).poke2((short)22667);
        codeAddress.offset(-1).poke1((byte)-4);
        codeAddress.poke2((short)-27649);
        codeAddress.offset(2).poke4(jq_InstanceMethod2.getOffset());
        codeAddress.offset(-10).poke2((short)-31605);
        return 10;
    }

    static int patch_invokestatic(CodeAddress codeAddress, jq_Method jq_Method2) {
        codeAddress.offset(-10).poke4(-1869545493);
        codeAddress.offset(-6).poke2((short)-6000);
        codeAddress.offset(-4).poke4(jq_Method2.getDefaultCompiledVersion().getEntrypoint().difference(codeAddress));
        codeAddress.offset(-10).poke2((short)-28528);
        return 5;
    }

    private final void INVOKENODPATCHhelper(byte by, jq_Method jq_Method2) {
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": INVOKE " + by + ' ' + jq_Method2));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        switch (by) {
            case 0: {
                int n = (jq_Method2.getParamWords() << 2) - 4;
                int n2 = ((jq_InstanceMethod)jq_Method2).getOffset();
                this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 0, n, 4);
                this.asm.emit2_Reg_Mem(x86.MOV_r_m32, 3, -4, 0);
                this.asm.emit2_Mem(x86.CALL_m, n2, 3);
                break;
            }
            case 2: {
                jq_Method2 = jq_Class.getInvokespecialTarget(this.clazz, (jq_InstanceMethod)jq_Method2);
                this.emitCallRelative(jq_Method2);
                break;
            }
            case 1: {
                this.emitCallRelative(jq_Method2);
                break;
            }
            case 3: {
                this.emitPushAddressOf(jq_Method2);
                this.emitCallRelative(x86ReferenceLinker._invokeinterface);
                this.asm.emit2_Reg_Mem(x86.LEA, 4, jq_Method2.getParamWords() << 2, 4);
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
    }

    private final void INVOKEhelper(byte by, jq_Method jq_Method2) {
        jq_Method2 = (jq_Method)this.tryResolve(jq_Method2);
        boolean bl = this.state.needsDynamicLink(this.method, jq_Method2);
        switch (by) {
            case 0: {
                if (bl) {
                    this.INVOKEDPATCHhelper(by, jq_Method2);
                    break;
                }
                this.INVOKENODPATCHhelper(by, jq_Method2);
                break;
            }
            case 1: 
            case 2: {
                if (bl) {
                    this.INVOKEDPATCHhelper(by, jq_Method2);
                    break;
                }
                this.INVOKENODPATCHhelper(by, jq_Method2);
                break;
            }
            case 3: {
                this.INVOKENODPATCHhelper(by, jq_Method2);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public void visitIINVOKE(byte by, jq_Method jq_Method2) {
        super.visitIINVOKE(by, jq_Method2);
        if (jq_Method2.getDeclaringClass() == Unsafe._class) {
            this.gen_unsafe(jq_Method2);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.genAddress(jq_Method2);
            return;
        }
        this.INVOKEhelper(by, jq_Method2);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitLINVOKE(byte by, jq_Method jq_Method2) {
        super.visitLINVOKE(by, jq_Method2);
        if (jq_Method2.getDeclaringClass() == Unsafe._class) {
            this.gen_unsafe(jq_Method2);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.genAddress(jq_Method2);
            return;
        }
        this.INVOKEhelper(by, jq_Method2);
        this.asm.emitShort_Reg(x86.PUSH_r, 2);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitFINVOKE(byte by, jq_Method jq_Method2) {
        super.visitFINVOKE(by, jq_Method2);
        if (jq_Method2.getDeclaringClass() == Unsafe._class) {
            this.gen_unsafe(jq_Method2);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.genAddress(jq_Method2);
            return;
        }
        this.INVOKEhelper(by, jq_Method2);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitDINVOKE(byte by, jq_Method jq_Method2) {
        super.visitDINVOKE(by, jq_Method2);
        if (jq_Method2.getDeclaringClass() == Unsafe._class) {
            this.gen_unsafe(jq_Method2);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.genAddress(jq_Method2);
            return;
        }
        this.INVOKEhelper(by, jq_Method2);
        this.asm.emitShort_Reg(x86.PUSH_r, 2);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitAINVOKE(byte by, jq_Method jq_Method2) {
        super.visitAINVOKE(by, jq_Method2);
        if (jq_Method2.getDeclaringClass() == Unsafe._class) {
            this.gen_unsafe(jq_Method2);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.genAddress(jq_Method2);
            return;
        }
        this.INVOKEhelper(by, jq_Method2);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitVINVOKE(byte by, jq_Method jq_Method2) {
        super.visitVINVOKE(by, jq_Method2);
        if (jq_Method2.getDeclaringClass() == Unsafe._class) {
            this.gen_unsafe(jq_Method2);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.genAddress(jq_Method2);
            return;
        }
        this.INVOKEhelper(by, jq_Method2);
    }

    public void visitNEW(jq_Type jq_Type2) {
        super.visitNEW(jq_Type2);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": NEW " + jq_Type2));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        boolean bl = this.state.needsDynamicLink(this.method, jq_Type2);
        if (jq_Type2.isClassType() && !bl) {
            jq_Class jq_Class2 = (jq_Class)jq_Type2;
            this.asm.emitPUSH_i(jq_Class2.getInstanceSize());
            this.emitPushAddressOf(jq_Class2.getVTable());
            this.emitCallRelative(DefaultHeapAllocator._allocateObject);
        } else {
            this.emitPushAddressOf(jq_Type2);
            this.emitCallRelative(HeapAllocator._clsinitAndAllocateObject);
        }
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitNEWARRAY(jq_Array jq_Array2) {
        super.visitNEWARRAY(jq_Array2);
        if (jq.RunningNative) {
            jq_Array2.cls_initialize();
        }
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": NEWARRAY " + jq_Array2));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        byte by = jq_Array2.getLogElementSize();
        this.asm.emit2_Mem(x86.PUSH_m, 0, 4);
        if (by != 0) {
            this.asm.emit2_SHIFT_Mem_Imm8(x86.SHL_m32_i, 0, 4, by);
        }
        this.asm.emitARITH_Mem_Imm(x86.ADD_m_i32, 0, 4, 12);
        this.emitPushAddressOf(jq_Array2.getVTable());
        this.emitCallRelative(DefaultHeapAllocator._allocateArray);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitARRAYLENGTH() {
        super.visitARRAYLENGTH();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ARRAYLENGTH"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitShort_Reg(x86.POP_r, 0);
        this.asm.emit2_Mem(x86.PUSH_m, -12, 0);
    }

    public void visitATHROW() {
        super.visitATHROW();
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ATHROW"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        if (this.TraceMethods) {
            this.emitPushAddressOf(SystemInterface.toCString("Leaving: " + this.method + " (explicit athrow)"));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.emitCallRelative(ExceptionDeliverer._athrow);
    }

    public void visitCHECKCAST(jq_Type jq_Type2) {
        super.visitCHECKCAST(jq_Type2);
        if (jq_Type2.isAddressType()) {
            return;
        }
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": CHECKCAST " + jq_Type2));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.emitPushAddressOf(jq_Type2);
        this.emitCallRelative(TypeCheck._checkcast);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitINSTANCEOF(jq_Type jq_Type2) {
        super.visitINSTANCEOF(jq_Type2);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": INSTANCEOF " + jq_Type2));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.emitPushAddressOf(jq_Type2);
        this.emitCallRelative(TypeCheck._instance_of);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    public void visitMONITOR(byte by) {
        super.visitMONITOR(by);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": MONITOR " + by));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        jq_StaticMethod jq_StaticMethod2 = by == 0 ? Monitor._monitorenter : Monitor._monitorexit;
        this.emitCallRelative(jq_StaticMethod2);
    }

    public void visitMULTINEWARRAY(jq_Type jq_Type2, char c) {
        super.visitMULTINEWARRAY(jq_Type2, c);
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": MULTINEWARRAY " + jq_Type2 + ' ' + c));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        this.asm.emitPUSH_i(c);
        this.emitPushAddressOf(jq_Type2);
        this.emitCallRelative(Arrays._multinewarray);
        this.asm.emit2_Reg_Mem(x86.LEA, 4, c << 2, 4);
        this.asm.emitShort_Reg(x86.PUSH_r, 0);
    }

    private final void genAddress(jq_Method jq_Method2) {
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": ADDRESS " + jq_Method2));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        if (jq_Method2.getName() == peek1) {
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit3_Reg_Mem(x86.MOVSX_r_m8, 1, 0, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
        } else if (jq_Method2.getName() == peek2) {
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit3_Reg_Mem(x86.MOVSX_r_m16, 1, 0, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
        } else if (jq_Method2.getName() == peek4 || jq_Method2.getName() == peek) {
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Mem(x86.PUSH_m, 0, 0);
        } else if (jq_Method2.getName() == peek8) {
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Mem(x86.PUSH_m, 4, 0);
            this.asm.emit2_Mem(x86.PUSH_m, 0, 0);
        } else if (jq_Method2.getName() == poke1) {
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r8, 3, 0, 0);
        } else if (jq_Method2.getName() == poke2) {
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitprefix((byte)102);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, 0, 0);
        } else if (jq_Method2.getName() == poke4 || jq_Method2.getName() == poke) {
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, 0, 0);
        } else if (jq_Method2.getName() == poke8) {
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 1);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 3, 0, 0);
            this.asm.emit2_Reg_Mem(x86.MOV_m_r32, 1, 4, 0);
        } else if (jq_Method2.getName() == offset) {
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitARITH_Reg_Mem(x86.ADD_m_r32, 0, 0, 4);
        } else if (jq_Method2.getName() == align) {
            this.asm.emitShort_Reg(x86.POP_r, 1);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 3, 1);
            this.asm.emit2_Reg(x86.SHL_r32_rc, 3);
            this.asm.emitShort_Reg(x86.DEC_r32, 3);
            this.asm.emitARITH_Reg_Reg(x86.ADD_r_r32, 0, 3);
            this.asm.emit2_Reg(x86.NOT_r32, 3);
            this.asm.emitARITH_Reg_Reg(x86.AND_r_r32, 0, 3);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
        } else if (jq_Method2.getName() == difference) {
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitARITH_Reg_Mem(x86.SUB_m_r32, 0, 0, 4);
        } else if (jq_Method2.getName() == isNull) {
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitARITH_Reg_Imm(x86.CMP_r_i32, 0, 0);
            this.asm.emitCJUMP_Short(x86.JNE, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg(x86.INC_r32, 1);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
        } else if (jq_Method2.getName() == addressOf || jq_Method2.getName() == address32 || jq_Method2.getName() == asObject || jq_Method2.getName() == asReferenceType || jq_Method2.getName() == to32BitValue) {
            this.asm.emit1(x86.NOP);
        } else if (jq_Method2.getName() == stringRep) {
            jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LUtil/Strings;");
            jq_StaticMethod jq_StaticMethod2 = jq_Class2.getOrCreateStaticMethod("hex8", "(I)Ljava/lang/String;");
            this.emitCallRelative(jq_StaticMethod2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
        } else if (jq_Method2.getName() == getNull || jq_Method2.getName() == min) {
            this.asm.emitPUSH_i(0);
        } else if (jq_Method2.getName() == max) {
            this.asm.emitPUSH_i(Integer.MAX_VALUE);
        } else if (jq_Method2.getName() == size) {
            this.asm.emitPUSH_i(4);
        } else if (jq_Method2.getName() == logSize) {
            this.asm.emitPUSH_i(2);
        } else if (jq_Method2.getName() == pageAlign) {
            this.asm.emitPUSH_i(12);
        } else if (jq_Method2.getName() == getBasePointer) {
            this.asm.emitShort_Reg(x86.PUSH_r, 5);
        } else if (jq_Method2.getName() == getStackPointer) {
            this.asm.emitShort_Reg(x86.PUSH_r, 4);
        } else if (jq_Method2.getName() == alloca) {
            this.asm.emit2_Mem(x86.NEG_m32, 0, 4);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitARITH_Reg_Reg(x86.ADD_r_r32, 0, 4);
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 4, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
        } else if (jq_Method2.getName() == atomicAdd) {
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            if (jq.SMP) {
                this.asm.emitprefix((byte)-16);
            }
            this.asm.emitARITH_Reg_Mem(x86.ADD_m_r32, 3, 0, 0);
        } else if (jq_Method2.getName() == atomicSub) {
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            if (jq.SMP) {
                this.asm.emitprefix((byte)-16);
            }
            this.asm.emitARITH_Reg_Mem(x86.SUB_m_r32, 3, 0, 0);
        } else if (jq_Method2.getName() == atomicCas4) {
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 1);
            if (jq.SMP) {
                this.asm.emitprefix((byte)-16);
            }
            this.asm.emit3_Reg_Mem(x86.CMPXCHG_32, 3, 0, 1);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
        } else if (jq_Method2.getName() == atomicCas8) {
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 1);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 2);
            this.asm.emitShort_Reg(x86.POP_r, 7);
            if (jq.SMP) {
                this.asm.emitprefix((byte)-16);
            }
            this.asm.emit3_Reg_Mem(x86.CMPXCHG8B, 0, 0, 7);
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
        } else if (jq_Method2.getName() == atomicAnd) {
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 0);
            if (jq.SMP) {
                this.asm.emitprefix((byte)-16);
            }
            this.asm.emitARITH_Reg_Mem(x86.AND_m_r32, 3, 0, 0);
        } else if (jq_Method2.getName() == Utf8.get("<init>")) {
            this.INVOKEhelper((byte)2, jq_Method2);
        } else {
            Assert.UNREACHABLE(jq_Method2.toString());
        }
    }

    private final void gen_unsafe(jq_Method jq_Method2) {
        if (this.TraceBytecodes) {
            this.emitPushAddressOf(SystemInterface.toCString(this.i_start + ": UNSAFE " + jq_Method2));
            this.emitCallMemory(SystemInterface._debugwriteln);
        }
        if (jq_Method2 == Unsafe._floatToIntBits || jq_Method2 == Unsafe._intBitsToFloat || jq_Method2 == Unsafe._doubleToLongBits || jq_Method2 == Unsafe._longBitsToDouble) {
            this.asm.emit1(x86.NOP);
        } else if (jq_Method2 == Unsafe._popFP32) {
            this.asm.emit2_Reg_Mem(x86.LEA, 4, -4, 4);
            this.asm.emit2_Mem(x86.FSTP_m32, 0, 4);
        } else if (jq_Method2 == Unsafe._popFP64) {
            this.asm.emit2_Reg_Mem(x86.LEA, 4, -8, 4);
            this.asm.emit2_Mem(x86.FSTP_m64, 0, 4);
        } else if (jq_Method2 == Unsafe._pushFP32) {
            this.asm.emit2_Mem(x86.FLD_m32, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 4, 4);
        } else if (jq_Method2 == Unsafe._pushFP64) {
            this.asm.emit2_Mem(x86.FLD_m64, 0, 4);
            this.asm.emit2_Reg_Mem(x86.LEA, 4, 8, 4);
        } else if (jq_Method2 == Unsafe._EAX) {
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
        } else if (jq_Method2 == Unsafe._pushArg || jq_Method2 == Unsafe._pushArgA) {
            this.asm.emit1(x86.NOP);
        } else if (jq_Method2 == Unsafe._invoke) {
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Reg(x86.CALL_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 2);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
        } else if (jq_Method2 == Unsafe._invokeA) {
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emit2_Reg(x86.CALL_r, 0);
            this.asm.emitShort_Reg(x86.PUSH_r, 0);
        } else if (jq_Method2 == Unsafe._getThreadBlock) {
            this.asm.emitprefix(THREAD_BLOCK_PREFIX);
            this.asm.emit2_Mem(x86.PUSH_m, THREAD_BLOCK_OFFSET);
        } else if (jq_Method2 == Unsafe._setThreadBlock) {
            this.asm.emitprefix(THREAD_BLOCK_PREFIX);
            this.asm.emit2_Mem(x86.POP_m, THREAD_BLOCK_OFFSET);
        } else if (jq_Method2 == Unsafe._longJump) {
            this.asm.emitShort_Reg(x86.POP_r, 0);
            this.asm.emitShort_Reg(x86.POP_r, 3);
            this.asm.emitShort_Reg(x86.POP_r, 5);
            this.asm.emitShort_Reg(x86.POP_r, 1);
            this.asm.emit2_Reg_Reg(x86.MOV_r_r32, 4, 3);
            this.asm.emit2_Reg(x86.JMP_r, 1);
        } else if (jq_Method2 == Unsafe._isEQ) {
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
            this.asm.emitCJUMP_Short(x86.JNE, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg(x86.INC_r32, 1);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
        } else if (jq_Method2 == Unsafe._isGE) {
            this.asm.emitShort_Reg_Imm(x86.MOV_r_i32, 1, 0);
            this.asm.emitCJUMP_Short(x86.JL, (byte)0);
            int n = this.asm.getCurrentOffset();
            this.asm.emitShort_Reg(x86.INC_r32, 1);
            this.asm.patch1(n - 1, (byte)(this.asm.getCurrentOffset() - n));
            this.asm.emitShort_Reg(x86.PUSH_r, 1);
        } else {
            System.err.println(jq_Method2.toString());
            Assert.UNREACHABLE();
        }
    }

    private final /* synthetic */ void this() {
        this.code_relocs = new LinkedList();
        this.data_relocs = new LinkedList();
    }

    public x86ReferenceCompiler(jq_Method jq_Method2) {
        super(CompilationState.DEFAULT, jq_Method2);
        this.this();
        this.TRACE = ALWAYS_TRACE;
        if (TraceBytecode_MethodNames.contains(jq_Method2.getName().toString())) {
            this.TraceBytecodes = true;
            this.TraceMethods = true;
        } else if (TraceBytecode_ClassNames.contains(jq_Method2.getDeclaringClass().getName().toString())) {
            this.TraceBytecodes = true;
            this.TraceMethods = true;
        } else if (TraceMethod_MethodNames.contains(jq_Method2.getName().toString())) {
            this.TraceBytecodes = false;
            this.TraceMethods = true;
        } else if (TraceMethod_ClassNames.contains(jq_Method2.getDeclaringClass().getName().toString())) {
            this.TraceBytecodes = false;
            this.TraceMethods = true;
        } else {
            this.TraceBytecodes = false;
            this.TraceMethods = false;
        }
        this.TraceArguments = false;
    }

    public static class Factory
    implements Compil3rInterface {
        public static final Factory INSTANCE = new Factory();

        public jq_CompiledCode compile(jq_Method jq_Method2) {
            return new x86ReferenceCompiler(jq_Method2).compile();
        }
    }
}

