/*
 * Decompiled with CFR 0.152.
 */
package Debugger;

import Allocator.CodeAllocator;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_CompiledCode;
import Clazz.jq_InstanceField;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Compil3r.BytecodeAnalysis.BytecodeVisitor;
import Compil3r.CompilationState;
import Main.TraceFlags;
import Main.jq;
import Memory.Address;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.Reflection;
import Run_Time.StackCodeWalker;
import Run_Time.SystemInterface;
import Scheduler.jq_NativeThread;
import Util.Assert;
import Util.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class OnlineDebugger {
    public static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    public static boolean debuggerEntryPoint() {
        if (!jq.RunningNative) {
            new InternalError().printStackTrace();
            System.exit(-1);
        }
        SystemInterface.debugwriteln(">>> Entering debugger.");
        StackAddress stackAddress = StackAddress.getBasePointer();
        CodeAddress codeAddress = (CodeAddress)stackAddress.offset(4).peek();
        stackAddress = (StackAddress)stackAddress.peek();
        StackCodeWalker stackCodeWalker = new StackCodeWalker(codeAddress, stackAddress);
        int n = 0;
        SystemInterface.debugwriteln("> " + n + ':' + stackCodeWalker.toString());
        block2: while (true) {
            System.err.print("db> ");
            String string = null;
            try {
                string = in.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                SystemInterface.debugwriteln(">>> Exiting debugger.");
                return true;
            }
            if (string.equals("")) continue;
            if (string.equals("c")) {
                SystemInterface.debugwriteln(">>> Continuing execution.");
                return true;
            }
            if (string.equals("s")) {
                SystemInterface.debugwriteln("Single-step not yet implemented.");
                continue;
            }
            if (string.equals("u")) {
                if (!stackCodeWalker.hasNext()) {
                    SystemInterface.debugwriteln("Reached top.");
                    continue;
                }
                stackCodeWalker.gotoNext();
                SystemInterface.debugwriteln("> " + ++n + ':' + stackCodeWalker.toString());
                continue;
            }
            if (string.equals("d")) {
                if (n == 0) {
                    SystemInterface.debugwriteln("Reached top.");
                    continue;
                }
                StackCodeWalker stackCodeWalker2 = new StackCodeWalker(codeAddress, stackAddress);
                while (true) {
                    if (!stackCodeWalker2.hasNext()) {
                        SystemInterface.debugwriteln("ERROR! Stack is corrupted.");
                        continue block2;
                    }
                    if (stackCodeWalker2.getFP().peek().difference(stackCodeWalker.getFP()) == 0) break;
                    stackCodeWalker2.gotoNext();
                }
                stackCodeWalker = stackCodeWalker2;
                SystemInterface.debugwriteln("> " + --n + ':' + stackCodeWalker.toString());
                continue;
            }
            if (string.equals("bt")) {
                StackCodeWalker stackCodeWalker3 = new StackCodeWalker(codeAddress, stackAddress);
                int n2 = 0;
                while (true) {
                    if (!stackCodeWalker3.hasNext()) continue block2;
                    if (n2 == n) {
                        SystemInterface.debugwriteln("> " + n2 + ':' + stackCodeWalker3.toString());
                        if (stackCodeWalker3.getFP().difference(stackCodeWalker.getFP()) != 0) {
                            SystemInterface.debugwriteln("ERROR! Stack is corrupted. Expected " + stackCodeWalker + " but found " + stackCodeWalker3);
                        }
                    } else {
                        SystemInterface.debugwriteln("  " + n2 + ':' + stackCodeWalker3.toString());
                    }
                    stackCodeWalker3.gotoNext();
                    ++n2;
                }
            }
            if (string.equals("t")) {
                jq_NativeThread.dumpAllThreads();
                continue;
            }
            if (string.equals("sf")) {
                OnlineDebugger.printStackFrame(stackCodeWalker);
                continue;
            }
            if (string.equals("l")) {
                jq_Method jq_Method2 = stackCodeWalker.getMethod();
                if (jq_Method2 == null) {
                    SystemInterface.debugwriteln("Unknown method!");
                    continue;
                }
                if (jq_Method2.getBytecode() == null) {
                    SystemInterface.debugwriteln("No bytecode for method " + jq_Method2 + '!');
                    continue;
                }
                int n3 = stackCodeWalker.getBCIndex();
                if (n3 < 0) {
                    n3 = 0;
                }
                BytecodeLister bytecodeLister = new BytecodeLister(jq_Method2, 0, jq_Method2.getBytecode().length, n3);
                bytecodeLister.forwardTraversal();
                continue;
            }
            if (string.equals("?")) {
                OnlineDebugger.printUsage();
                continue;
            }
            if (string.startsWith("toString ")) {
                if ((string = string.substring(9)).startsWith("0x") || string.startsWith("0X")) {
                    string = string.substring(2);
                }
                int n4 = Integer.parseInt(string, 16);
                HeapAddress heapAddress = HeapAddress.address32(n4);
                Object object = heapAddress.asObject();
                SystemInterface.debugwriteln(object.toString());
                continue;
            }
            if (string.startsWith("dumpObject ")) {
                if ((string = string.substring(11)).startsWith("0x") || string.startsWith("0X")) {
                    string = string.substring(2);
                }
                int n5 = Integer.parseInt(string, 16);
                OnlineDebugger.dumpObject(n5);
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n6 = stringTokenizer.countTokens();
            String[] stringArray = new String[n6];
            int n7 = 0;
            while (n7 < n6) {
                stringArray[n7] = stringTokenizer.nextToken();
                ++n7;
            }
            Assert._assert(stringTokenizer.hasMoreTokens() ^ true);
            n7 = TraceFlags.setTraceFlag(stringArray, 0);
            if (n7 == 0) continue;
        }
    }

    public static void printUsage() {
        SystemInterface.debugwriteln("c: continue, s: step");
        SystemInterface.debugwriteln("l: list bytecode");
        SystemInterface.debugwriteln("dumpObject, toString");
        SystemInterface.debugwriteln("u: up, d: down, sf: stack frame, bt: back trace, t: thread dump");
    }

    public static void dumpObject(int n) {
        HeapAddress heapAddress = HeapAddress.address32(n);
        Object object = heapAddress.asObject();
        OnlineDebugger.dumpObject(object);
    }

    public static void dumpObject(Object object) {
        HeapAddress heapAddress = HeapAddress.addressOf(object);
        jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
        SystemInterface.debugwriteln(heapAddress.stringRep() + " type " + jq_Reference2);
        if (jq_Reference2.isClassType()) {
            jq_Class jq_Class2 = (jq_Class)jq_Reference2;
            jq_InstanceField[] jq_InstanceFieldArray = jq_Class2.getInstanceFields();
            int n = 0;
            while (n < jq_InstanceFieldArray.length) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Strings.left(jq_InstanceFieldArray[n].getName().toString(), 15));
                stringBuffer.append(':');
                if (jq_InstanceFieldArray[n].getType().isReferenceType()) {
                    Address address = heapAddress.offset(jq_InstanceFieldArray[n].getOffset()).peek();
                    stringBuffer.append(address.stringRep());
                } else {
                    stringBuffer.append(Reflection.getfield(object, jq_InstanceFieldArray[n]));
                }
                SystemInterface.debugwriteln(stringBuffer.toString());
                ++n;
            }
        } else {
            jq_Array jq_Array2 = (jq_Array)jq_Reference2;
            int n = Reflection.arraylength(object);
            int n2 = 0;
            while (n2 < n) {
                if (jq_Array2.getElementType().isReferenceType()) {
                    SystemInterface.debugwriteln(n2 + ": " + heapAddress.offset(n2 * HeapAddress.size()).peek().stringRep());
                } else if (jq_Array2.getElementType() == jq_Primitive.FLOAT) {
                    SystemInterface.debugwriteln(n2 + ": " + Float.intBitsToFloat(heapAddress.offset(n2 * 4).peek4()));
                } else if (jq_Array2.getElementType() == jq_Primitive.DOUBLE) {
                    SystemInterface.debugwriteln(n2 + ": " + Double.longBitsToDouble(heapAddress.offset(n2 * 8).peek8()));
                } else if (jq_Array2.getElementType().getReferenceSize() == 1) {
                    SystemInterface.debugwriteln(n2 + ": " + heapAddress.offset(n2).peek1());
                } else if (jq_Array2.getElementType().getReferenceSize() == 2) {
                    SystemInterface.debugwriteln(n2 + ": " + heapAddress.offset(n2 * 2).peek2());
                } else if (jq_Array2.getElementType().getReferenceSize() == 4) {
                    SystemInterface.debugwriteln(n2 + ": " + heapAddress.offset(n2 * 4).peek4());
                } else if (jq_Array2.getElementType().getReferenceSize() == 8) {
                    SystemInterface.debugwriteln(n2 + ": " + heapAddress.offset(n2 * 8).peek8());
                }
                ++n2;
            }
        }
    }

    public static void printStackFrame(StackCodeWalker stackCodeWalker) {
        StackAddress stackAddress = stackCodeWalker.getFP();
        if (stackAddress.isNull()) {
            SystemInterface.debugwriteln("Cannot dump this frame!" + Strings.lineSep);
            return;
        }
        CodeAddress codeAddress = (CodeAddress)stackAddress.offset(4).peek();
        StackAddress stackAddress2 = (StackAddress)stackAddress.peek();
        if (stackAddress.isNull()) {
            SystemInterface.debugwriteln("Cannot dump this frame!" + Strings.lineSep);
            return;
        }
        jq_CompiledCode jq_CompiledCode2 = CodeAllocator.getCodeContaining(codeAddress);
        jq_Method jq_Method2 = null;
        if (jq_CompiledCode2 != null) {
            jq_Method2 = jq_CompiledCode2.getMethod();
        }
        SystemInterface.debugwriteln("Stack frame for " + jq_CompiledCode2);
        if (jq_Method2 != null) {
            SystemInterface.debugwriteln(jq_Method2.getMaxLocals() + " locals, " + jq_Method2.getParamWords() + " param words");
        }
        StackAddress stackAddress3 = stackAddress;
        int n = 0;
        if (jq_Method2 != null) {
            n = (jq_Method2.getParamWords() + 1) * StackAddress.size();
        }
        while (stackAddress3.difference(stackAddress2) <= n) {
            if (stackAddress3.difference(stackAddress) == 0) {
                SystemInterface.debugwriteln("Callee FP:      " + stackAddress3.stringRep() + " : " + stackAddress3.peek().stringRep());
            } else if (stackAddress3.difference(stackAddress2) == StackAddress.size()) {
                CodeAddress codeAddress2 = (CodeAddress)stackAddress3.peek();
                jq_CompiledCode jq_CompiledCode3 = CodeAllocator.getCodeContaining(codeAddress2);
                int n2 = 0;
                if (jq_CompiledCode3 != null) {
                    n2 = codeAddress2.difference(jq_CompiledCode3.getStart());
                }
                SystemInterface.debugwriteln("Caller retaddr: " + stackAddress3.stringRep() + " : " + stackAddress3.peek().stringRep() + "  (offset " + Strings.hex(n2) + ')');
            } else if (jq_Method2 != null && stackAddress3.difference(stackAddress2) > 0) {
                int n3 = jq_Method2.getParamWords() - stackAddress3.difference(stackAddress2) / StackAddress.size() + 1;
                SystemInterface.debugwriteln(Strings.left("Incoming arg " + n3 + ':', 16) + stackAddress3.stringRep() + " : " + stackAddress3.peek().stringRep());
            } else if (stackAddress3.difference(stackAddress) == StackAddress.size()) {
                int n4 = 0;
                if (jq_CompiledCode2 != null) {
                    n4 = codeAddress.difference(jq_CompiledCode2.getStart());
                }
                SystemInterface.debugwriteln("Return address: " + stackAddress3.stringRep() + " : " + stackAddress3.peek().stringRep() + "  (offset " + Strings.hex(n4) + ')');
            } else if (stackAddress2.difference(stackAddress3) == 0) {
                SystemInterface.debugwriteln("Caller FP:      " + stackAddress3.stringRep() + " : " + stackAddress3.peek().stringRep());
            } else if (jq_Method2 != null && stackAddress2.difference(stackAddress3) <= StackAddress.size() * (jq_Method2.getMaxLocals() - jq_Method2.getParamWords())) {
                int n5 = stackAddress2.difference(stackAddress3) / StackAddress.size() - 1;
                SystemInterface.debugwriteln(Strings.left("Local " + n5 + ": ", 16) + stackAddress3.stringRep() + " : " + stackAddress3.peek().stringRep());
            } else if (jq_Method2 != null && stackAddress3.difference(stackAddress) > StackAddress.size()) {
                int n6 = stackAddress2.difference(stackAddress3) / StackAddress.size() - jq_Method2.getMaxLocals() + jq_Method2.getParamWords() - 2;
                SystemInterface.debugwriteln(Strings.left("Stack " + n6 + ": ", 16) + stackAddress3.stringRep() + " : " + stackAddress3.peek().stringRep());
            } else {
                SystemInterface.debugwriteln("                " + stackAddress3.stringRep() + " : " + stackAddress3.peek().stringRep());
            }
            stackAddress3 = (StackAddress)stackAddress3.offset(StackAddress.size());
        }
    }

    public static class BytecodeLister
    extends BytecodeVisitor {
        protected int i_loc;
        protected int i_stop;

        public void forwardTraversal() throws VerifyError {
            this.i_end = -1;
            while (true) {
                this.i_start = this.i_end + 1;
                if (this.i_start == this.i_loc) {
                    this.out.println("Current location:");
                }
                if (this.i_start >= this.i_stop) break;
                this.visitBytecode();
            }
        }

        public String toString() {
            return Strings.left(this.method.getName().toString(), 12);
        }

        public BytecodeLister(jq_Method jq_Method2, int n, int n2, int n3) {
            super(CompilationState.DEFAULT, jq_Method2);
            this.i_end = n - 1;
            this.i_start = n;
            this.i_stop = n2;
            this.i_loc = n3;
            this.out = System.err;
            this.TRACE = true;
        }
    }
}

