/*
 * Decompiled with CFR 0.152.
 */
package Interpreter;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_TryCatchBC;
import Clazz.jq_Type;
import Compil3r.BytecodeAnalysis.BytecodeVisitor;
import Interpreter.ReflectiveInterpreter;
import Memory.Address;
import Memory.HeapAddress;
import Run_Time.Reflection;
import Run_Time.Unsafe;
import Util.Assert;
import java.io.PrintStream;

public abstract class BytecodeInterpreter {
    public static boolean ALWAYS_TRACE;
    protected State istate;
    protected final VMInterface vm;

    public abstract Object invokeMethod(jq_Method var1) throws Throwable;

    public abstract Object invokeUnsafeMethod(jq_Method var1) throws Throwable;

    public Object invokeMethod(jq_Method jq_Method2, State state) throws Throwable {
        Object object;
        jq_Class jq_Class2 = jq_Method2.getDeclaringClass();
        Assert._assert(jq_Class2.isClsInitialized());
        boolean bl = false;
        if (jq_Method2.getBytecode() != null) {
            bl = true;
        }
        Assert._assert(bl);
        jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
        Object[] objectArray = new Object[jq_TypeArray.length];
        int n = jq_TypeArray.length - 1;
        while (n >= 0) {
            jq_Type jq_Type2 = jq_TypeArray[n];
            objectArray[n] = jq_Type2.isPrimitiveType() ? (jq_Type2 == jq_Primitive.LONG ? (Number)new Long(this.istate.pop_L()) : (Number)(jq_Type2 == jq_Primitive.FLOAT ? (Number)new Float(this.istate.pop_F()) : (Number)(jq_Type2 == jq_Primitive.DOUBLE ? (Number)new Double(this.istate.pop_D()) : (Number)new Integer(this.istate.pop_I())))) : this.istate.pop_A();
            --n;
        }
        n = 0;
        int n2 = 0;
        while (n < jq_TypeArray.length) {
            object = jq_TypeArray[n];
            if (((jq_Type)object).isPrimitiveType()) {
                if (object == jq_Primitive.LONG) {
                    long l = (Long)objectArray[n];
                    if (state == null) {
                        Unsafe.pushArg((int)(l >> 32));
                        Unsafe.pushArg((int)l);
                    } else {
                        state.setLocal_L(n2, l);
                    }
                    ++n2;
                } else if (object == jq_Primitive.FLOAT) {
                    float f = ((Float)objectArray[n]).floatValue();
                    if (state == null) {
                        Unsafe.pushArg(Float.floatToRawIntBits(f));
                    } else {
                        state.setLocal_F(n2, f);
                    }
                } else if (object == jq_Primitive.DOUBLE) {
                    long l = Double.doubleToRawLongBits((Double)objectArray[n]);
                    if (state == null) {
                        Unsafe.pushArg((int)(l >> 32));
                        Unsafe.pushArg((int)l);
                    } else {
                        state.setLocal_D(n2, Double.longBitsToDouble(l));
                    }
                    ++n2;
                } else {
                    int n3 = (Integer)objectArray[n];
                    if (state == null) {
                        Unsafe.pushArg(n3);
                    } else {
                        state.setLocal_I(n2, n3);
                    }
                }
            } else {
                Object object2 = objectArray[n];
                if (state == null) {
                    Unsafe.pushArgA(HeapAddress.addressOf(object2));
                } else {
                    state.setLocal_A(n2, object2);
                }
            }
            ++n;
            ++n2;
        }
        if (state == null) {
            jq_Type jq_Type3 = jq_Method2.getReturnType();
            if (jq_Type3.isReferenceType()) {
                Address address = Unsafe.invokeA(jq_Method2.getDefaultCompiledVersion().getEntrypoint());
                if (jq_Type3.isAddressType()) {
                    return address;
                }
                return ((HeapAddress)address).asObject();
            }
            long l = Unsafe.invoke(jq_Method2.getDefaultCompiledVersion().getEntrypoint());
            if (jq_Type3 == jq_Primitive.VOID) {
                return null;
            }
            if (jq_Type3 == jq_Primitive.LONG) {
                return new Long(l);
            }
            if (jq_Type3 == jq_Primitive.FLOAT) {
                return new Float(Float.intBitsToFloat((int)l));
            }
            if (jq_Type3 == jq_Primitive.DOUBLE) {
                return new Double(Double.longBitsToDouble(l));
            }
            return new Integer((int)l);
        }
        State state2 = this.istate;
        this.istate = state;
        MethodInterpreter methodInterpreter = new MethodInterpreter(jq_Method2);
        object = null;
        try {
            jq_Type jq_Type4;
            if (jq_Method2.isSynchronized()) {
                if (!jq_Method2.isStatic()) {
                    if (methodInterpreter.getTraceFlag()) {
                        methodInterpreter.getTraceOut().println("synchronized instance method, locking 'this' object");
                    }
                    object = this.istate.getLocal_A(0);
                    this.vm.monitorenter(object, methodInterpreter);
                } else {
                    if (methodInterpreter.getTraceFlag()) {
                        methodInterpreter.getTraceOut().println("synchronized static method, locking class object");
                    }
                    object = Reflection.getJDKType(jq_Method2.getDeclaringClass());
                    this.vm.monitorenter(object, methodInterpreter);
                }
            }
            methodInterpreter.forwardTraversal();
            this.istate = state2;
            if (jq_Method2.isSynchronized()) {
                if (methodInterpreter.getTraceFlag()) {
                    methodInterpreter.getTraceOut().println("exiting synchronized method, unlocking object");
                }
                this.vm.monitorexit(object);
            }
            Object object3 = (jq_Type4 = jq_Method2.getReturnType()).isReferenceType() ? state.getReturnVal_A() : (jq_Type4 == jq_Primitive.VOID ? null : (jq_Type4 == jq_Primitive.LONG ? (Number)new Long(state.getReturnVal_L()) : (Number)(jq_Type4 == jq_Primitive.FLOAT ? (Number)new Float(state.getReturnVal_F()) : (Number)(jq_Type4 == jq_Primitive.DOUBLE ? (Number)new Double(state.getReturnVal_D()) : (Number)new Integer(state.getReturnVal_I())))));
            if (methodInterpreter.getTraceFlag()) {
                methodInterpreter.getTraceOut().println("Return value: " + object3);
            }
            return object3;
        }
        catch (WrappedException wrappedException) {
            this.istate = state2;
            if (jq_Method2.isSynchronized()) {
                if (methodInterpreter.getTraceFlag()) {
                    methodInterpreter.getTraceOut().println("exiting synchronized method, unlocking object");
                }
                this.vm.monitorexit(object);
            }
            throw wrappedException.t;
        }
    }

    public BytecodeInterpreter(VMInterface vMInterface, State state) {
        this.vm = vMInterface;
        this.istate = state;
    }

    static {
        boolean bl = false;
        if (System.getProperty("interpreter.trace") != null) {
            bl = true;
        }
        ALWAYS_TRACE = bl;
    }

    public static abstract class State {
        public abstract void push_I(int var1);

        public abstract void push_L(long var1);

        public abstract void push_F(float var1);

        public abstract void push_D(double var1);

        public abstract void push_A(Object var1);

        public abstract void push(Object var1);

        public abstract int pop_I();

        public abstract long pop_L();

        public abstract float pop_F();

        public abstract double pop_D();

        public abstract Object pop_A();

        public abstract Object pop();

        public abstract void popAll();

        public abstract Object peek_A(int var1);

        public abstract void setLocal_I(int var1, int var2);

        public abstract void setLocal_L(int var1, long var2);

        public abstract void setLocal_F(int var1, float var2);

        public abstract void setLocal_D(int var1, double var2);

        public abstract void setLocal_A(int var1, Object var2);

        public abstract int getLocal_I(int var1);

        public abstract long getLocal_L(int var1);

        public abstract float getLocal_F(int var1);

        public abstract double getLocal_D(int var1);

        public abstract Object getLocal_A(int var1);

        public abstract void return_I(int var1);

        public abstract void return_L(long var1);

        public abstract void return_F(float var1);

        public abstract void return_D(double var1);

        public abstract void return_A(Object var1);

        public abstract void return_V();

        public abstract int getReturnVal_I();

        public abstract long getReturnVal_L();

        public abstract float getReturnVal_F();

        public abstract double getReturnVal_D();

        public abstract Object getReturnVal_A();
    }

    public static abstract class VMInterface {
        public abstract Object new_obj(jq_Type var1);

        public abstract Object new_array(jq_Type var1, int var2);

        public abstract Object checkcast(Object var1, jq_Type var2);

        public abstract boolean instance_of(Object var1, jq_Type var2);

        public abstract int arraylength(Object var1);

        public abstract void monitorenter(Object var1, MethodInterpreter var2);

        public abstract void monitorexit(Object var1);

        public abstract Object multinewarray(int[] var1, jq_Type var2);
    }

    public static class WrappedException
    extends RuntimeException {
        Throwable t;

        public String toString() {
            return "WrappedException: " + this.t;
        }

        WrappedException(Throwable throwable) {
            this.t = throwable;
        }
    }

    class MethodInterpreter
    extends BytecodeVisitor {
        final String name;

        public String toString() {
            return this.name;
        }

        boolean getTraceFlag() {
            return this.TRACE;
        }

        PrintStream getTraceOut() {
            return this.out;
        }

        public void forwardTraversal() throws VerifyError, WrappedException {
            if (this.TRACE) {
                this.out.println(this + ": Starting traversal.");
            }
            while (true) {
                this.i_start = this.i_end + 1;
                if (this.i_start >= this.bcs.length) break;
                try {
                    super.visitBytecode();
                }
                catch (WrappedException wrappedException) {
                    if (this.TRACE) {
                        this.out.println(this + ": Exception thrown! " + wrappedException.t);
                    }
                    this.handleException(wrappedException.t);
                }
                catch (Throwable throwable) {
                    if (this.TRACE) {
                        this.out.println(this + ": RuntimeException/Error thrown! " + throwable);
                    }
                    this.handleException(throwable);
                }
            }
            if (this.TRACE) {
                this.out.println(this + ": Finished traversal.");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void continueForwardTraversal() throws VerifyError, WrappedException, ReflectiveInterpreter.MonitorExit {
            while (true) {
                this.i_start = this.i_end + 1;
                if (this.i_start >= this.bcs.length) return;
                try {
                    super.visitBytecode();
                    continue;
                }
                catch (ReflectiveInterpreter.MonitorExit monitorExit) {
                    throw monitorExit;
                }
                catch (WrappedException wrappedException) {
                    if (this.TRACE) {
                        this.out.println(this + ": Exception thrown! " + wrappedException.t);
                    }
                    this.handleException(wrappedException.t);
                    continue;
                }
                catch (Throwable throwable) {
                    if (this.TRACE) {
                        this.out.println(this + ": RuntimeException/Error thrown! " + throwable);
                    }
                    this.handleException(throwable);
                    continue;
                }
                break;
            }
        }

        public void visitBytecode() throws WrappedException {
            try {
                super.visitBytecode();
            }
            catch (WrappedException wrappedException) {
                if (this.TRACE) {
                    this.out.println(this + ": Exception thrown! " + wrappedException.t);
                }
                this.handleException(wrappedException.t);
            }
            catch (Throwable throwable) {
                if (this.TRACE) {
                    this.out.println(this + ": RuntimeException/Error thrown! " + throwable);
                }
                this.handleException(throwable);
            }
        }

        private final void handleException(Throwable throwable) throws WrappedException {
            jq_Class jq_Class2 = (jq_Class)jq_Reference.getTypeOf(throwable);
            jq_Class2.prepare();
            jq_TryCatchBC[] jq_TryCatchBCArray = this.method.getExceptionTable();
            int n = 0;
            while (n < jq_TryCatchBCArray.length) {
                if (jq_TryCatchBCArray[n].catches(this.i_start, jq_Class2)) {
                    BytecodeInterpreter.this.istate.popAll();
                    BytecodeInterpreter.this.istate.push_A(throwable);
                    this.branchTo(jq_TryCatchBCArray[n].getHandlerPC());
                    if (this.TRACE) {
                        this.out.println(this + ": Branching to exception handler " + jq_TryCatchBCArray[n]);
                    }
                    return;
                }
                ++n;
            }
            if (this.TRACE) {
                this.out.println(this + ": Uncaught exception, exiting method.");
            }
            throw new WrappedException(throwable);
        }

        protected void branchTo(int n) {
            this.i_end = n - 1;
        }

        public void visitNOP() {
            super.visitNOP();
        }

        public void visitACONST(Object object) {
            super.visitACONST(object);
            BytecodeInterpreter.this.istate.push_A(object);
        }

        public void visitICONST(int n) {
            super.visitICONST(n);
            BytecodeInterpreter.this.istate.push_I(n);
        }

        public void visitLCONST(long l) {
            super.visitLCONST(l);
            BytecodeInterpreter.this.istate.push_L(l);
        }

        public void visitFCONST(float f) {
            super.visitFCONST(f);
            BytecodeInterpreter.this.istate.push_F(f);
        }

        public void visitDCONST(double d) {
            super.visitDCONST(d);
            BytecodeInterpreter.this.istate.push_D(d);
        }

        public void visitILOAD(int n) {
            super.visitILOAD(n);
            BytecodeInterpreter.this.istate.push_I(BytecodeInterpreter.this.istate.getLocal_I(n));
        }

        public void visitLLOAD(int n) {
            super.visitLLOAD(n);
            BytecodeInterpreter.this.istate.push_L(BytecodeInterpreter.this.istate.getLocal_L(n));
        }

        public void visitFLOAD(int n) {
            super.visitFLOAD(n);
            BytecodeInterpreter.this.istate.push_F(BytecodeInterpreter.this.istate.getLocal_F(n));
        }

        public void visitDLOAD(int n) {
            super.visitDLOAD(n);
            BytecodeInterpreter.this.istate.push_D(BytecodeInterpreter.this.istate.getLocal_D(n));
        }

        public void visitALOAD(int n) {
            super.visitALOAD(n);
            BytecodeInterpreter.this.istate.push_A(BytecodeInterpreter.this.istate.getLocal_A(n));
        }

        public void visitISTORE(int n) {
            super.visitISTORE(n);
            BytecodeInterpreter.this.istate.setLocal_I(n, BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitLSTORE(int n) {
            super.visitLSTORE(n);
            BytecodeInterpreter.this.istate.setLocal_L(n, BytecodeInterpreter.this.istate.pop_L());
        }

        public void visitFSTORE(int n) {
            super.visitFSTORE(n);
            BytecodeInterpreter.this.istate.setLocal_F(n, BytecodeInterpreter.this.istate.pop_F());
        }

        public void visitDSTORE(int n) {
            super.visitDSTORE(n);
            BytecodeInterpreter.this.istate.setLocal_D(n, BytecodeInterpreter.this.istate.pop_D());
        }

        public void visitASTORE(int n) {
            super.visitASTORE(n);
            BytecodeInterpreter.this.istate.setLocal_A(n, BytecodeInterpreter.this.istate.pop_A());
        }

        public void visitIALOAD() {
            super.visitIALOAD();
            int n = BytecodeInterpreter.this.istate.pop_I();
            int[] nArray = (int[])BytecodeInterpreter.this.istate.pop_A();
            BytecodeInterpreter.this.istate.push_I(nArray[n]);
        }

        public void visitLALOAD() {
            super.visitLALOAD();
            int n = BytecodeInterpreter.this.istate.pop_I();
            long[] lArray = (long[])BytecodeInterpreter.this.istate.pop_A();
            BytecodeInterpreter.this.istate.push_L(lArray[n]);
        }

        public void visitFALOAD() {
            super.visitFALOAD();
            int n = BytecodeInterpreter.this.istate.pop_I();
            float[] fArray = (float[])BytecodeInterpreter.this.istate.pop_A();
            BytecodeInterpreter.this.istate.push_F(fArray[n]);
        }

        public void visitDALOAD() {
            super.visitDALOAD();
            int n = BytecodeInterpreter.this.istate.pop_I();
            double[] dArray = (double[])BytecodeInterpreter.this.istate.pop_A();
            BytecodeInterpreter.this.istate.push_D(dArray[n]);
        }

        public void visitAALOAD() {
            super.visitAALOAD();
            int n = BytecodeInterpreter.this.istate.pop_I();
            Object[] objectArray = (Object[])BytecodeInterpreter.this.istate.pop_A();
            BytecodeInterpreter.this.istate.push_A(objectArray[n]);
        }

        public void visitBALOAD() {
            byte by;
            super.visitBALOAD();
            int n = BytecodeInterpreter.this.istate.pop_I();
            Object object = BytecodeInterpreter.this.istate.pop_A();
            try {
                by = object.getClass() == Class.forName("[Z") ? ((boolean[])object)[n] : ((byte[])object)[n];
            }
            catch (ClassNotFoundException classNotFoundException) {
                Assert.UNREACHABLE();
                return;
            }
            BytecodeInterpreter.this.istate.push_I(by);
        }

        public void visitCALOAD() {
            super.visitCALOAD();
            int n = BytecodeInterpreter.this.istate.pop_I();
            char[] cArray = (char[])BytecodeInterpreter.this.istate.pop_A();
            BytecodeInterpreter.this.istate.push_I(cArray[n]);
        }

        public void visitSALOAD() {
            super.visitSALOAD();
            int n = BytecodeInterpreter.this.istate.pop_I();
            short[] sArray = (short[])BytecodeInterpreter.this.istate.pop_A();
            BytecodeInterpreter.this.istate.push_I(sArray[n]);
        }

        public void visitIASTORE() {
            super.visitIASTORE();
            int n = BytecodeInterpreter.this.istate.pop_I();
            int n2 = BytecodeInterpreter.this.istate.pop_I();
            int[] nArray = (int[])BytecodeInterpreter.this.istate.pop_A();
            nArray[n2] = n;
        }

        public void visitLASTORE() {
            super.visitLASTORE();
            long l = BytecodeInterpreter.this.istate.pop_L();
            int n = BytecodeInterpreter.this.istate.pop_I();
            long[] lArray = (long[])BytecodeInterpreter.this.istate.pop_A();
            lArray[n] = l;
        }

        public void visitFASTORE() {
            super.visitFASTORE();
            float f = BytecodeInterpreter.this.istate.pop_F();
            int n = BytecodeInterpreter.this.istate.pop_I();
            float[] fArray = (float[])BytecodeInterpreter.this.istate.pop_A();
            fArray[n] = f;
        }

        public void visitDASTORE() {
            super.visitDASTORE();
            double d = BytecodeInterpreter.this.istate.pop_D();
            int n = BytecodeInterpreter.this.istate.pop_I();
            double[] dArray = (double[])BytecodeInterpreter.this.istate.pop_A();
            dArray[n] = d;
        }

        public void visitAASTORE() {
            super.visitAASTORE();
            Object object = BytecodeInterpreter.this.istate.pop_A();
            int n = BytecodeInterpreter.this.istate.pop_I();
            Object[] objectArray = (Object[])BytecodeInterpreter.this.istate.pop_A();
            objectArray[n] = object;
        }

        public void visitBASTORE() {
            super.visitBASTORE();
            int n = BytecodeInterpreter.this.istate.pop_I();
            int n2 = BytecodeInterpreter.this.istate.pop_I();
            Object object = BytecodeInterpreter.this.istate.pop_A();
            try {
                if (object.getClass() == Class.forName("[Z")) {
                    boolean[] blArray = (boolean[])object;
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    blArray[n2] = bl;
                } else {
                    ((byte[])object)[n2] = (byte)n;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Assert.UNREACHABLE();
            }
        }

        public void visitCASTORE() {
            super.visitCASTORE();
            int n = BytecodeInterpreter.this.istate.pop_I();
            int n2 = BytecodeInterpreter.this.istate.pop_I();
            char[] cArray = (char[])BytecodeInterpreter.this.istate.pop_A();
            cArray[n2] = (char)n;
        }

        public void visitSASTORE() {
            super.visitSASTORE();
            int n = BytecodeInterpreter.this.istate.pop_I();
            int n2 = BytecodeInterpreter.this.istate.pop_I();
            short[] sArray = (short[])BytecodeInterpreter.this.istate.pop_A();
            sArray[n2] = (short)n;
        }

        public void visitPOP() {
            super.visitPOP();
            BytecodeInterpreter.this.istate.pop();
        }

        public void visitPOP2() {
            super.visitPOP2();
            BytecodeInterpreter.this.istate.pop();
            BytecodeInterpreter.this.istate.pop();
        }

        public void visitDUP() {
            super.visitDUP();
            Object object = BytecodeInterpreter.this.istate.pop();
            BytecodeInterpreter.this.istate.push(object);
            BytecodeInterpreter.this.istate.push(object);
        }

        public void visitDUP_x1() {
            super.visitDUP_x1();
            Object object = BytecodeInterpreter.this.istate.pop();
            Object object2 = BytecodeInterpreter.this.istate.pop();
            BytecodeInterpreter.this.istate.push(object);
            BytecodeInterpreter.this.istate.push(object2);
            BytecodeInterpreter.this.istate.push(object);
        }

        public void visitDUP_x2() {
            super.visitDUP_x2();
            Object object = BytecodeInterpreter.this.istate.pop();
            Object object2 = BytecodeInterpreter.this.istate.pop();
            Object object3 = BytecodeInterpreter.this.istate.pop();
            BytecodeInterpreter.this.istate.push(object);
            BytecodeInterpreter.this.istate.push(object3);
            BytecodeInterpreter.this.istate.push(object2);
            BytecodeInterpreter.this.istate.push(object);
        }

        public void visitDUP2() {
            super.visitDUP2();
            Object object = BytecodeInterpreter.this.istate.pop();
            Object object2 = BytecodeInterpreter.this.istate.pop();
            BytecodeInterpreter.this.istate.push(object2);
            BytecodeInterpreter.this.istate.push(object);
            BytecodeInterpreter.this.istate.push(object2);
            BytecodeInterpreter.this.istate.push(object);
        }

        public void visitDUP2_x1() {
            super.visitDUP2_x1();
            Object object = BytecodeInterpreter.this.istate.pop();
            Object object2 = BytecodeInterpreter.this.istate.pop();
            Object object3 = BytecodeInterpreter.this.istate.pop();
            BytecodeInterpreter.this.istate.push(object2);
            BytecodeInterpreter.this.istate.push(object);
            BytecodeInterpreter.this.istate.push(object3);
            BytecodeInterpreter.this.istate.push(object2);
            BytecodeInterpreter.this.istate.push(object);
        }

        public void visitDUP2_x2() {
            super.visitDUP2_x2();
            Object object = BytecodeInterpreter.this.istate.pop();
            Object object2 = BytecodeInterpreter.this.istate.pop();
            Object object3 = BytecodeInterpreter.this.istate.pop();
            Object object4 = BytecodeInterpreter.this.istate.pop();
            BytecodeInterpreter.this.istate.push(object2);
            BytecodeInterpreter.this.istate.push(object);
            BytecodeInterpreter.this.istate.push(object4);
            BytecodeInterpreter.this.istate.push(object3);
            BytecodeInterpreter.this.istate.push(object2);
            BytecodeInterpreter.this.istate.push(object);
        }

        public void visitSWAP() {
            super.visitSWAP();
            Object object = BytecodeInterpreter.this.istate.pop();
            Object object2 = BytecodeInterpreter.this.istate.pop();
            BytecodeInterpreter.this.istate.push(object);
            BytecodeInterpreter.this.istate.push(object2);
        }

        public void visitIBINOP(byte by) {
            super.visitIBINOP(by);
            int n = BytecodeInterpreter.this.istate.pop_I();
            int n2 = BytecodeInterpreter.this.istate.pop_I();
            switch (by) {
                case 0: {
                    BytecodeInterpreter.this.istate.push_I(n2 + n);
                    break;
                }
                case 1: {
                    BytecodeInterpreter.this.istate.push_I(n2 - n);
                    break;
                }
                case 2: {
                    BytecodeInterpreter.this.istate.push_I(n2 * n);
                    break;
                }
                case 3: {
                    BytecodeInterpreter.this.istate.push_I(n2 / n);
                    break;
                }
                case 4: {
                    BytecodeInterpreter.this.istate.push_I(n2 % n);
                    break;
                }
                case 5: {
                    BytecodeInterpreter.this.istate.push_I(n2 & n);
                    break;
                }
                case 6: {
                    BytecodeInterpreter.this.istate.push_I(n2 | n);
                    break;
                }
                case 7: {
                    BytecodeInterpreter.this.istate.push_I(n2 ^ n);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void visitLBINOP(byte by) {
            super.visitLBINOP(by);
            long l = BytecodeInterpreter.this.istate.pop_L();
            long l2 = BytecodeInterpreter.this.istate.pop_L();
            switch (by) {
                case 0: {
                    BytecodeInterpreter.this.istate.push_L(l2 + l);
                    break;
                }
                case 1: {
                    BytecodeInterpreter.this.istate.push_L(l2 - l);
                    break;
                }
                case 2: {
                    BytecodeInterpreter.this.istate.push_L(l2 * l);
                    break;
                }
                case 3: {
                    BytecodeInterpreter.this.istate.push_L(l2 / l);
                    break;
                }
                case 4: {
                    BytecodeInterpreter.this.istate.push_L(l2 % l);
                    break;
                }
                case 5: {
                    BytecodeInterpreter.this.istate.push_L(l2 & l);
                    break;
                }
                case 6: {
                    BytecodeInterpreter.this.istate.push_L(l2 | l);
                    break;
                }
                case 7: {
                    BytecodeInterpreter.this.istate.push_L(l2 ^ l);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void visitFBINOP(byte by) {
            super.visitFBINOP(by);
            float f = BytecodeInterpreter.this.istate.pop_F();
            float f2 = BytecodeInterpreter.this.istate.pop_F();
            switch (by) {
                case 0: {
                    BytecodeInterpreter.this.istate.push_F(f2 + f);
                    break;
                }
                case 1: {
                    BytecodeInterpreter.this.istate.push_F(f2 - f);
                    break;
                }
                case 2: {
                    BytecodeInterpreter.this.istate.push_F(f2 * f);
                    break;
                }
                case 3: {
                    BytecodeInterpreter.this.istate.push_F(f2 / f);
                    break;
                }
                case 4: {
                    BytecodeInterpreter.this.istate.push_F(f2 % f);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void visitDBINOP(byte by) {
            super.visitDBINOP(by);
            double d = BytecodeInterpreter.this.istate.pop_D();
            double d2 = BytecodeInterpreter.this.istate.pop_D();
            switch (by) {
                case 0: {
                    BytecodeInterpreter.this.istate.push_D(d2 + d);
                    break;
                }
                case 1: {
                    BytecodeInterpreter.this.istate.push_D(d2 - d);
                    break;
                }
                case 2: {
                    BytecodeInterpreter.this.istate.push_D(d2 * d);
                    break;
                }
                case 3: {
                    BytecodeInterpreter.this.istate.push_D(d2 / d);
                    break;
                }
                case 4: {
                    BytecodeInterpreter.this.istate.push_D(d2 % d);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void visitIUNOP(byte by) {
            super.visitIUNOP(by);
            boolean bl = false;
            if (by == 0) {
                bl = true;
            }
            Assert._assert(bl);
            BytecodeInterpreter.this.istate.push_I(-BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitLUNOP(byte by) {
            super.visitLUNOP(by);
            boolean bl = false;
            if (by == 0) {
                bl = true;
            }
            Assert._assert(bl);
            BytecodeInterpreter.this.istate.push_L(-BytecodeInterpreter.this.istate.pop_L());
        }

        public void visitFUNOP(byte by) {
            super.visitFUNOP(by);
            boolean bl = false;
            if (by == 0) {
                bl = true;
            }
            Assert._assert(bl);
            BytecodeInterpreter.this.istate.push_F(-BytecodeInterpreter.this.istate.pop_F());
        }

        public void visitDUNOP(byte by) {
            super.visitDUNOP(by);
            boolean bl = false;
            if (by == 0) {
                bl = true;
            }
            Assert._assert(bl);
            BytecodeInterpreter.this.istate.push_D(-BytecodeInterpreter.this.istate.pop_D());
        }

        public void visitISHIFT(byte by) {
            super.visitISHIFT(by);
            int n = BytecodeInterpreter.this.istate.pop_I();
            int n2 = BytecodeInterpreter.this.istate.pop_I();
            switch (by) {
                case 0: {
                    BytecodeInterpreter.this.istate.push_I(n2 << n);
                    break;
                }
                case 1: {
                    BytecodeInterpreter.this.istate.push_I(n2 >> n);
                    break;
                }
                case 2: {
                    BytecodeInterpreter.this.istate.push_I(n2 >>> n);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void visitLSHIFT(byte by) {
            super.visitLSHIFT(by);
            int n = BytecodeInterpreter.this.istate.pop_I();
            long l = BytecodeInterpreter.this.istate.pop_L();
            switch (by) {
                case 0: {
                    BytecodeInterpreter.this.istate.push_L(l << n);
                    break;
                }
                case 1: {
                    BytecodeInterpreter.this.istate.push_L(l >> n);
                    break;
                }
                case 2: {
                    BytecodeInterpreter.this.istate.push_L(l >>> n);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void visitIINC(int n, int n2) {
            super.visitIINC(n, n2);
            BytecodeInterpreter.this.istate.setLocal_I(n, BytecodeInterpreter.this.istate.getLocal_I(n) + n2);
        }

        public void visitI2L() {
            super.visitI2L();
            BytecodeInterpreter.this.istate.push_L(BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitI2F() {
            super.visitI2F();
            BytecodeInterpreter.this.istate.push_F(BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitI2D() {
            super.visitI2D();
            BytecodeInterpreter.this.istate.push_D(BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitL2I() {
            super.visitL2I();
            BytecodeInterpreter.this.istate.push_I((int)BytecodeInterpreter.this.istate.pop_L());
        }

        public void visitL2F() {
            super.visitL2F();
            BytecodeInterpreter.this.istate.push_F(BytecodeInterpreter.this.istate.pop_L());
        }

        public void visitL2D() {
            super.visitL2D();
            BytecodeInterpreter.this.istate.push_D(BytecodeInterpreter.this.istate.pop_L());
        }

        public void visitF2I() {
            super.visitF2I();
            BytecodeInterpreter.this.istate.push_I((int)BytecodeInterpreter.this.istate.pop_F());
        }

        public void visitF2L() {
            super.visitF2L();
            BytecodeInterpreter.this.istate.push_L((long)BytecodeInterpreter.this.istate.pop_F());
        }

        public void visitF2D() {
            super.visitF2D();
            BytecodeInterpreter.this.istate.push_D(BytecodeInterpreter.this.istate.pop_F());
        }

        public void visitD2I() {
            super.visitD2I();
            BytecodeInterpreter.this.istate.push_I((int)BytecodeInterpreter.this.istate.pop_D());
        }

        public void visitD2L() {
            super.visitD2L();
            BytecodeInterpreter.this.istate.push_L((long)BytecodeInterpreter.this.istate.pop_D());
        }

        public void visitD2F() {
            super.visitD2F();
            BytecodeInterpreter.this.istate.push_F((float)BytecodeInterpreter.this.istate.pop_D());
        }

        public void visitI2B() {
            super.visitI2B();
            BytecodeInterpreter.this.istate.push_I((byte)BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitI2C() {
            super.visitI2C();
            BytecodeInterpreter.this.istate.push_I((char)BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitI2S() {
            super.visitI2S();
            BytecodeInterpreter.this.istate.push_I((short)BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitLCMP2() {
            super.visitLCMP2();
            long l = BytecodeInterpreter.this.istate.pop_L();
            long l2 = BytecodeInterpreter.this.istate.pop_L();
            State state = BytecodeInterpreter.this.istate;
            int n = 1;
            if (l2 <= l) {
                int n2 = 0;
                if (l2 == l) {
                    n2 = 1;
                }
                n = n2 + -1;
            }
            state.push_I(n);
        }

        public void visitFCMP2(byte by) {
            int n;
            super.visitFCMP2(by);
            float f = BytecodeInterpreter.this.istate.pop_F();
            float f2 = BytecodeInterpreter.this.istate.pop_F();
            if (by == 0) {
                int n2 = 1;
                if (!(f2 > f)) {
                    int n3 = 0;
                    if (f2 == f) {
                        n3 = 1;
                    }
                    n2 = n3 + -1;
                }
                n = n2;
            } else {
                int n4;
                if (f2 < f) {
                    n4 = -1;
                } else {
                    int n5 = 0;
                    if (f2 == f) {
                        n5 = 1;
                    }
                    n4 = 1 - n5;
                }
                n = n4;
            }
            BytecodeInterpreter.this.istate.push_I(n);
        }

        public void visitDCMP2(byte by) {
            int n;
            super.visitDCMP2(by);
            double d = BytecodeInterpreter.this.istate.pop_D();
            double d2 = BytecodeInterpreter.this.istate.pop_D();
            if (by == 0) {
                int n2 = 1;
                if (!(d2 > d)) {
                    int n3 = 0;
                    if (d2 == d) {
                        n3 = 1;
                    }
                    n2 = n3 + -1;
                }
                n = n2;
            } else {
                int n4;
                if (d2 < d) {
                    n4 = -1;
                } else {
                    int n5 = 0;
                    if (d2 == d) {
                        n5 = 1;
                    }
                    n4 = 1 - n5;
                }
                n = n4;
            }
            BytecodeInterpreter.this.istate.push_I(n);
        }

        public void visitIF(byte by, int n) {
            super.visitIF(by, n);
            int n2 = BytecodeInterpreter.this.istate.pop_I();
            switch (by) {
                case 0: {
                    if (n2 != 0) break;
                    this.branchTo(n);
                    break;
                }
                case 1: {
                    if (n2 == 0) break;
                    this.branchTo(n);
                    break;
                }
                case 2: {
                    if (n2 >= 0) break;
                    this.branchTo(n);
                    break;
                }
                case 3: {
                    if (n2 < 0) break;
                    this.branchTo(n);
                    break;
                }
                case 4: {
                    if (n2 > 0) break;
                    this.branchTo(n);
                    break;
                }
                case 5: {
                    if (n2 <= 0) break;
                    this.branchTo(n);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void visitIFREF(byte by, int n) {
            super.visitIFREF(by, n);
            Object object = BytecodeInterpreter.this.istate.pop_A();
            switch (by) {
                case 0: {
                    if (object != null) break;
                    this.branchTo(n);
                    break;
                }
                case 1: {
                    if (object == null) break;
                    this.branchTo(n);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void visitIFCMP(byte by, int n) {
            super.visitIFCMP(by, n);
            int n2 = BytecodeInterpreter.this.istate.pop_I();
            int n3 = BytecodeInterpreter.this.istate.pop_I();
            switch (by) {
                case 0: {
                    if (n3 != n2) break;
                    this.branchTo(n);
                    break;
                }
                case 1: {
                    if (n3 == n2) break;
                    this.branchTo(n);
                    break;
                }
                case 2: {
                    if (n3 >= n2) break;
                    this.branchTo(n);
                    break;
                }
                case 3: {
                    if (n3 < n2) break;
                    this.branchTo(n);
                    break;
                }
                case 4: {
                    if (n3 > n2) break;
                    this.branchTo(n);
                    break;
                }
                case 5: {
                    if (n3 <= n2) break;
                    this.branchTo(n);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void visitIFREFCMP(byte by, int n) {
            super.visitIFREFCMP(by, n);
            Object object = BytecodeInterpreter.this.istate.pop_A();
            Object object2 = BytecodeInterpreter.this.istate.pop_A();
            switch (by) {
                case 0: {
                    if (object2 != object) break;
                    this.branchTo(n);
                    break;
                }
                case 1: {
                    if (object2 == object) break;
                    this.branchTo(n);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void visitGOTO(int n) {
            super.visitGOTO(n);
            this.branchTo(n);
        }

        public void visitJSR(int n) {
            super.visitJSR(n);
            BytecodeInterpreter.this.istate.push_I(this.i_end + 1);
            this.branchTo(n);
        }

        public void visitRET(int n) {
            super.visitRET(n);
            this.branchTo(BytecodeInterpreter.this.istate.getLocal_I(n));
        }

        public void visitTABLESWITCH(int n, int n2, int n3, int[] nArray) {
            super.visitTABLESWITCH(n, n2, n3, nArray);
            int n4 = BytecodeInterpreter.this.istate.pop_I();
            if (n4 < n2 || n4 > n3) {
                this.branchTo(n);
            } else {
                this.branchTo(nArray[n4 - n2]);
            }
        }

        public void visitLOOKUPSWITCH(int n, int[] nArray, int[] nArray2) {
            super.visitLOOKUPSWITCH(n, nArray, nArray2);
            int n2 = BytecodeInterpreter.this.istate.pop_I();
            int n3 = 0;
            while (n3 < nArray.length) {
                if (n2 == nArray[n3]) {
                    this.branchTo(nArray2[n3]);
                    return;
                }
                ++n3;
            }
            this.branchTo(n);
        }

        public void visitIRETURN() {
            super.visitIRETURN();
            BytecodeInterpreter.this.istate.return_I(BytecodeInterpreter.this.istate.pop_I());
            this.i_end = this.bcs.length;
        }

        public void visitLRETURN() {
            super.visitLRETURN();
            BytecodeInterpreter.this.istate.return_L(BytecodeInterpreter.this.istate.pop_L());
            this.i_end = this.bcs.length;
        }

        public void visitFRETURN() {
            super.visitFRETURN();
            BytecodeInterpreter.this.istate.return_F(BytecodeInterpreter.this.istate.pop_F());
            this.i_end = this.bcs.length;
        }

        public void visitDRETURN() {
            super.visitDRETURN();
            BytecodeInterpreter.this.istate.return_D(BytecodeInterpreter.this.istate.pop_D());
            this.i_end = this.bcs.length;
        }

        public void visitARETURN() {
            super.visitARETURN();
            BytecodeInterpreter.this.istate.return_A(BytecodeInterpreter.this.istate.pop_A());
            this.i_end = this.bcs.length;
        }

        public void visitVRETURN() {
            super.visitVRETURN();
            BytecodeInterpreter.this.istate.return_V();
            this.i_end = this.bcs.length;
        }

        public void visitIGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitIGETSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            BytecodeInterpreter.this.istate.push_I(Reflection.getstatic_I(jq_StaticField2));
        }

        public void visitLGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitLGETSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            BytecodeInterpreter.this.istate.push_L(Reflection.getstatic_L(jq_StaticField2));
        }

        public void visitFGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitFGETSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            BytecodeInterpreter.this.istate.push_F(Reflection.getstatic_F(jq_StaticField2));
        }

        public void visitDGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitDGETSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            BytecodeInterpreter.this.istate.push_D(Reflection.getstatic_D(jq_StaticField2));
        }

        public void visitAGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitAGETSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            BytecodeInterpreter.this.istate.push_A(Reflection.getstatic_A(jq_StaticField2));
        }

        public void visitZGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitZGETSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            BytecodeInterpreter.this.istate.push_I(Reflection.getstatic_Z(jq_StaticField2) ? 1 : 0);
        }

        public void visitBGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitBGETSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            BytecodeInterpreter.this.istate.push_I(Reflection.getstatic_B(jq_StaticField2));
        }

        public void visitCGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitCGETSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            BytecodeInterpreter.this.istate.push_I(Reflection.getstatic_C(jq_StaticField2));
        }

        public void visitSGETSTATIC(jq_StaticField jq_StaticField2) {
            super.visitSGETSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            BytecodeInterpreter.this.istate.push_I(Reflection.getstatic_S(jq_StaticField2));
        }

        public void visitIPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitIPUTSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            Reflection.putstatic_I(jq_StaticField2, BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitLPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitLPUTSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            Reflection.putstatic_L(jq_StaticField2, BytecodeInterpreter.this.istate.pop_L());
        }

        public void visitFPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitFPUTSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            Reflection.putstatic_F(jq_StaticField2, BytecodeInterpreter.this.istate.pop_F());
        }

        public void visitDPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitDPUTSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            Reflection.putstatic_D(jq_StaticField2, BytecodeInterpreter.this.istate.pop_D());
        }

        public void visitAPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitAPUTSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            Reflection.putstatic_A(jq_StaticField2, BytecodeInterpreter.this.istate.pop_A());
        }

        public void visitZPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitZPUTSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            boolean bl = false;
            if (BytecodeInterpreter.this.istate.pop_I() != 0) {
                bl = true;
            }
            Reflection.putstatic_Z(jq_StaticField2, bl);
        }

        public void visitBPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitBPUTSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            Reflection.putstatic_B(jq_StaticField2, (byte)BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitCPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitCPUTSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            Reflection.putstatic_C(jq_StaticField2, (char)BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitSPUTSTATIC(jq_StaticField jq_StaticField2) {
            super.visitSPUTSTATIC(jq_StaticField2);
            jq_StaticField2 = this.tryResolve(jq_StaticField2);
            jq_StaticField2.getDeclaringClass().cls_initialize();
            Reflection.putstatic_S(jq_StaticField2, (short)BytecodeInterpreter.this.istate.pop_I());
        }

        public void visitIGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitIGETFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            BytecodeInterpreter.this.istate.push_I(Reflection.getfield_I(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2));
        }

        public void visitLGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitLGETFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            BytecodeInterpreter.this.istate.push_L(Reflection.getfield_L(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2));
        }

        public void visitFGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitFGETFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            BytecodeInterpreter.this.istate.push_F(Reflection.getfield_F(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2));
        }

        public void visitDGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitDGETFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            BytecodeInterpreter.this.istate.push_D(Reflection.getfield_D(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2));
        }

        public void visitAGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitAGETFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            BytecodeInterpreter.this.istate.push_A(Reflection.getfield_A(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2));
        }

        public void visitBGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitBGETFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            BytecodeInterpreter.this.istate.push_I(Reflection.getfield_B(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2));
        }

        public void visitCGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitCGETFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            BytecodeInterpreter.this.istate.push_I(Reflection.getfield_C(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2));
        }

        public void visitSGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitSGETFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            BytecodeInterpreter.this.istate.push_I(Reflection.getfield_S(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2));
        }

        public void visitZGETFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitZGETFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            BytecodeInterpreter.this.istate.push_I(Reflection.getfield_Z(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2) ? 1 : 0);
        }

        public void visitIPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitIPUTFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            int n = BytecodeInterpreter.this.istate.pop_I();
            Reflection.putfield_I(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2, n);
        }

        public void visitLPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitLPUTFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            long l = BytecodeInterpreter.this.istate.pop_L();
            Reflection.putfield_L(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2, l);
        }

        public void visitFPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitFPUTFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            float f = BytecodeInterpreter.this.istate.pop_F();
            Reflection.putfield_F(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2, f);
        }

        public void visitDPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitDPUTFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            double d = BytecodeInterpreter.this.istate.pop_D();
            Reflection.putfield_D(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2, d);
        }

        public void visitAPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitAPUTFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            Object object = BytecodeInterpreter.this.istate.pop_A();
            Reflection.putfield_A(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2, object);
        }

        public void visitBPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitBPUTFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            byte by = (byte)BytecodeInterpreter.this.istate.pop_I();
            Reflection.putfield_B(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2, by);
        }

        public void visitCPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitCPUTFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            char c = (char)BytecodeInterpreter.this.istate.pop_I();
            Reflection.putfield_C(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2, c);
        }

        public void visitSPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitSPUTFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            short s = (short)BytecodeInterpreter.this.istate.pop_I();
            Reflection.putfield_S(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2, s);
        }

        public void visitZPUTFIELD(jq_InstanceField jq_InstanceField2) {
            super.visitZPUTFIELD(jq_InstanceField2);
            jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
            boolean bl = false;
            if (BytecodeInterpreter.this.istate.pop_I() != 0) {
                bl = true;
            }
            boolean bl2 = bl;
            Reflection.putfield_Z(BytecodeInterpreter.this.istate.pop_A(), jq_InstanceField2, bl2);
        }

        protected Object INVOKEhelper(byte by, jq_Method jq_Method2) {
            jq_Method2 = (jq_Method)this.tryResolve(jq_Method2);
            jq_Class jq_Class2 = jq_Method2.getDeclaringClass();
            jq_Class2.cls_initialize();
            if (jq_Class2 == Unsafe._class || jq_Class2.isAddressType()) {
                try {
                    return BytecodeInterpreter.this.invokeUnsafeMethod(jq_Method2);
                }
                catch (Throwable throwable) {
                    if (this.TRACE) {
                        this.out.println(this + ": " + jq_Method2 + " threw " + throwable);
                    }
                    throw new WrappedException(throwable);
                }
            }
            if (by == 2) {
                jq_Method2 = jq_Class.getInvokespecialTarget(this.clazz, (jq_InstanceMethod)jq_Method2);
            } else if (by != 1) {
                Object object = BytecodeInterpreter.this.istate.peek_A(jq_Method2.getParamWords() - 1);
                jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
                jq_Reference2.cls_initialize();
                if (by == 3) {
                    if (!jq_Reference2.implementsInterface(jq_Method2.getDeclaringClass())) {
                        throw new IncompatibleClassChangeError();
                    }
                    if (jq_Reference2.isArrayType()) {
                        jq_Reference2 = PrimordialClassLoader.getJavaLangObject();
                    }
                } else {
                    boolean bl = false;
                    if (by == 0) {
                        bl = true;
                    }
                    Assert._assert(bl);
                }
                jq_Method jq_Method3 = jq_Method2;
                jq_Method2 = jq_Reference2.getVirtualMethod(jq_Method2.getNameAndDesc());
                if (this.TRACE) {
                    this.out.println(this + ": virtual method target " + jq_Method2);
                }
                if (jq_Method2 == null) {
                    throw new AbstractMethodError("no such method " + jq_Method3.toString() + " in type " + jq_Reference2);
                }
                if (jq_Method2.isAbstract()) {
                    throw new AbstractMethodError("method " + jq_Method3.toString() + " on type " + jq_Reference2 + " is abstract");
                }
            }
            try {
                return BytecodeInterpreter.this.invokeMethod(jq_Method2);
            }
            catch (Throwable throwable) {
                if (this.TRACE) {
                    this.out.println(this + ": " + jq_Method2 + " threw " + throwable);
                }
                throw new WrappedException(throwable);
            }
        }

        public void visitIINVOKE(byte by, jq_Method jq_Method2) {
            super.visitIINVOKE(by, jq_Method2);
            BytecodeInterpreter.this.istate.push_I((Integer)this.INVOKEhelper(by, jq_Method2));
        }

        public void visitLINVOKE(byte by, jq_Method jq_Method2) {
            super.visitLINVOKE(by, jq_Method2);
            BytecodeInterpreter.this.istate.push_L((Long)this.INVOKEhelper(by, jq_Method2));
        }

        public void visitFINVOKE(byte by, jq_Method jq_Method2) {
            super.visitFINVOKE(by, jq_Method2);
            BytecodeInterpreter.this.istate.push_F(((Float)this.INVOKEhelper(by, jq_Method2)).floatValue());
        }

        public void visitDINVOKE(byte by, jq_Method jq_Method2) {
            super.visitDINVOKE(by, jq_Method2);
            BytecodeInterpreter.this.istate.push_D((Double)this.INVOKEhelper(by, jq_Method2));
        }

        public void visitAINVOKE(byte by, jq_Method jq_Method2) {
            super.visitAINVOKE(by, jq_Method2);
            BytecodeInterpreter.this.istate.push_A(this.INVOKEhelper(by, jq_Method2));
        }

        public void visitVINVOKE(byte by, jq_Method jq_Method2) {
            super.visitVINVOKE(by, jq_Method2);
            this.INVOKEhelper(by, jq_Method2);
        }

        public void visitNEW(jq_Type jq_Type2) {
            super.visitNEW(jq_Type2);
            BytecodeInterpreter.this.istate.push_A(BytecodeInterpreter.this.vm.new_obj(jq_Type2));
        }

        public void visitNEWARRAY(jq_Array jq_Array2) {
            super.visitNEWARRAY(jq_Array2);
            BytecodeInterpreter.this.istate.push_A(BytecodeInterpreter.this.vm.new_array(jq_Array2, BytecodeInterpreter.this.istate.pop_I()));
        }

        public void visitCHECKCAST(jq_Type jq_Type2) {
            super.visitCHECKCAST(jq_Type2);
            BytecodeInterpreter.this.istate.push_A(BytecodeInterpreter.this.vm.checkcast(BytecodeInterpreter.this.istate.pop_A(), jq_Type2));
        }

        public void visitINSTANCEOF(jq_Type jq_Type2) {
            super.visitINSTANCEOF(jq_Type2);
            BytecodeInterpreter.this.istate.push_I(BytecodeInterpreter.this.vm.instance_of(BytecodeInterpreter.this.istate.pop_A(), jq_Type2) ? 1 : 0);
        }

        public void visitARRAYLENGTH() {
            super.visitARRAYLENGTH();
            BytecodeInterpreter.this.istate.push_I(BytecodeInterpreter.this.vm.arraylength(BytecodeInterpreter.this.istate.pop_A()));
        }

        public void visitATHROW() {
            super.visitATHROW();
            throw new WrappedException((Throwable)BytecodeInterpreter.this.istate.pop_A());
        }

        public void visitMONITOR(byte by) {
            super.visitMONITOR(by);
            Object object = BytecodeInterpreter.this.istate.pop_A();
            if (by == 0) {
                BytecodeInterpreter.this.vm.monitorenter(object, this);
            } else {
                BytecodeInterpreter.this.vm.monitorexit(object);
            }
        }

        public void visitMULTINEWARRAY(jq_Type jq_Type2, char n) {
            super.visitMULTINEWARRAY(jq_Type2, (char)n);
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n - n2 - 1] = BytecodeInterpreter.this.istate.pop_I();
                ++n2;
            }
            BytecodeInterpreter.this.istate.push_A(BytecodeInterpreter.this.vm.multinewarray(nArray, jq_Type2));
        }

        MethodInterpreter(jq_Method jq_Method2) {
            super(jq_Method2);
            this.i_end = -1;
            String string = jq_Method2.getDeclaringClass().getName().toString();
            int n = string.lastIndexOf(46);
            this.name = string.substring(n + 1) + '/' + jq_Method2.getName();
            this.TRACE = ALWAYS_TRACE;
            this.out = System.err;
        }
    }
}

