/*
 * Decompiled with CFR 0.152.
 */
package Interpreter;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_InstanceField;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_Type;
import Interpreter.BytecodeInterpreter;
import Main.TraceFlags;
import Main.jq;
import Memory.Address;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.Arrays;
import Run_Time.Monitor;
import Run_Time.Reflection;
import Run_Time.SystemInterface;
import Run_Time.TypeCheck;
import Run_Time.Unsafe;
import UTF.Utf8;
import Util.Assert;
import Util.Collections.FilterIterator;
import Util.Convert;
import java.util.HashSet;
import java.util.Set;

public class DirectInterpreter
extends BytecodeInterpreter {
    public static final Set bad_classes = new HashSet();
    public static final Set bad_methods;
    public static final FilterIterator.Filter interpret_filter;

    public Object invokeMethod(jq_Method jq_Method2) throws Throwable {
        jq_Class jq_Class2 = jq_Method2.getDeclaringClass();
        jq_Class2.cls_initialize();
        if (!interpret_filter.isElement(jq_Method2)) {
            Object object = this.invokeMethod(jq_Method2, null);
            return object;
        }
        int n = jq_Method2.getMaxLocals() * HeapAddress.size();
        int n2 = jq_Method2.getMaxStack() * HeapAddress.size();
        StackAddress stackAddress = StackAddress.alloca(n + n2);
        DirectState directState = new DirectState((StackAddress)stackAddress.offset(n + n2), (StackAddress)stackAddress.offset(n2), jq_Method2.getMaxLocals());
        Object object = this.invokeMethod(jq_Method2, directState);
        return object;
    }

    public Object invokeUnsafeMethod(jq_Method jq_Method2) throws Throwable {
        if (jq_Method2 == Unsafe._intBitsToFloat) {
            return new Float(this.istate.pop_F());
        }
        if (jq_Method2 == Unsafe._floatToIntBits) {
            return new Integer(this.istate.pop_I());
        }
        if (jq_Method2 == Unsafe._doubleToLongBits) {
            return new Long(this.istate.pop_L());
        }
        if (jq_Method2 == Unsafe._longBitsToDouble) {
            return new Double(this.istate.pop_D());
        }
        if (jq_Method2 == Unsafe._getThreadBlock) {
            return Unsafe.getThreadBlock();
        }
        if (jq_Method2.getName() == Utf8.get("to32BitValue")) {
            return new Integer(((Address)this.istate.pop()).to32BitValue());
        }
        if (jq_Method2.getName() == Utf8.get("addressOf")) {
            return HeapAddress.addressOf(this.istate.pop_A());
        }
        if (jq_Method2.getName() == Utf8.get("asObject")) {
            return ((HeapAddress)this.istate.pop()).asObject();
        }
        if (jq_Method2.getName() == Utf8.get("offset")) {
            int n = this.istate.pop_I();
            return ((Address)this.istate.pop()).offset(n);
        }
        if (jq_Method2.getName() == Utf8.get("asReferenceType")) {
            return (jq_Reference)((HeapAddress)this.istate.pop()).asObject();
        }
        if (jq_Method2.getName() == Utf8.get("peek")) {
            return ((Address)this.istate.pop()).peek();
        }
        if (jq_Method2.getName() == Utf8.get("peek1")) {
            return new Integer(((Address)this.istate.pop()).peek1());
        }
        if (jq_Method2.getName() == Utf8.get("peek2")) {
            return new Integer(((Address)this.istate.pop()).peek2());
        }
        if (jq_Method2.getName() == Utf8.get("peek4")) {
            return new Integer(((Address)this.istate.pop()).peek4());
        }
        if (jq_Method2.getName() == Utf8.get("peek8")) {
            return new Long(((Address)this.istate.pop()).peek8());
        }
        if (jq_Method2.getName() == Utf8.get("poke")) {
            Address address = (Address)this.istate.pop();
            Address address2 = (Address)this.istate.pop();
            address2.poke(address);
            return null;
        }
        if (jq_Method2.getName() == Utf8.get("poke1")) {
            byte by = (byte)this.istate.pop_I();
            Address address = (Address)this.istate.pop();
            address.poke1(by);
            return null;
        }
        if (jq_Method2.getName() == Utf8.get("poke2")) {
            short s = (short)this.istate.pop_I();
            Address address = (Address)this.istate.pop();
            address.poke2(s);
            return null;
        }
        if (jq_Method2.getName() == Utf8.get("poke4")) {
            int n = this.istate.pop_I();
            Address address = (Address)this.istate.pop();
            address.poke4(n);
            return null;
        }
        if (jq_Method2.getName() == Utf8.get("poke8")) {
            long l = this.istate.pop_L();
            Address address = (Address)this.istate.pop();
            address.poke8(l);
            return null;
        }
        System.err.println(jq_Method2.toString());
        Assert.UNREACHABLE();
        return null;
    }

    public static void main(String[] stringArray) throws Throwable {
        StackAddress stackAddress;
        jq_Type[] jq_TypeArray;
        String string = stringArray[0];
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Assert._assert(jq.RunningNative);
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("L" + string2.replace('.', '/') + ';');
        jq_Class2.cls_initialize();
        jq_Type[] jq_TypeArray2 = null;
        Utf8 utf8 = Utf8.get(string3);
        Object[] objectArray = java.util.Arrays.asList(jq_Class2.getDeclaredStaticMethods()).iterator();
        while (objectArray.hasNext()) {
            jq_TypeArray = objectArray.next();
            if (jq_TypeArray.getName() != utf8) continue;
            jq_TypeArray2 = jq_TypeArray;
            break;
        }
        if (jq_TypeArray2 == null) {
            Assert.UNREACHABLE("root method not found: " + string2 + '.' + string3);
        }
        objectArray = new Object[jq_TypeArray2.getParamWords()];
        jq_TypeArray = jq_TypeArray2.getParamTypes();
        int n2 = 0;
        int n3 = 0;
        while (n2 < jq_TypeArray.length) {
            n3 = TraceFlags.parseArg(objectArray, n2, jq_TypeArray[n2], stringArray, n3);
            ++n2;
        }
        StackAddress stackAddress2 = StackAddress.alloca(objectArray.length * HeapAddress.size());
        StackAddress stackAddress3 = stackAddress = (StackAddress)stackAddress2.offset(objectArray.length * HeapAddress.size());
        DirectState directState = new DirectState(stackAddress, stackAddress3, 0);
        directState.fillInParameters(jq_TypeArray, objectArray);
        Object object = new DirectInterpreter(directState).invokeMethod((jq_Method)jq_TypeArray2);
        System.out.println("Return value: " + object);
    }

    public DirectInterpreter(BytecodeInterpreter.State state) {
        super(new DirectVMInterface(), state);
    }

    static {
        bad_classes.add(SystemInterface._class);
        bad_classes.add(Reflection._class);
        bad_classes.add(PrimordialClassLoader.loader.getOrCreateBSType("LRun_Time/ExceptionDeliverer;"));
        bad_methods = new HashSet();
        bad_methods.add(Arrays._multinewarray);
        interpret_filter = new FilterIterator.Filter(){

            public final boolean isElement(Object object) {
                jq_Method jq_Method2 = (jq_Method)object;
                if (jq_Method2.getBytecode() == null) {
                    return false;
                }
                if (bad_classes.contains(jq_Method2.getDeclaringClass())) {
                    return false;
                }
                return !bad_methods.contains(jq_Method2);
            }
        };
    }

    public static class DirectState
    extends BytecodeInterpreter.State {
        final StackAddress fp;
        final int nlocals;
        StackAddress sp;
        int loResult;
        int hiResult;

        public void fillInParameters(jq_Type[] jq_TypeArray, Object[] objectArray) {
            int n = 0;
            int n2 = 0;
            while (n < jq_TypeArray.length) {
                jq_Type jq_Type2 = jq_TypeArray[n];
                if (jq_Type2.isReferenceType()) {
                    this.push_A(objectArray[n2]);
                } else if (jq_Type2.isIntLike()) {
                    this.push_I(Reflection.unwrapToInt(objectArray[n2]));
                } else if (jq_Type2 == jq_Primitive.FLOAT) {
                    this.push_F(Reflection.unwrapToFloat(objectArray[n2]));
                } else if (jq_Type2 == jq_Primitive.LONG) {
                    this.push_L(Reflection.unwrapToLong(objectArray[n2]));
                    ++n2;
                } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                    this.push_D(Reflection.unwrapToDouble(objectArray[n2]));
                    ++n2;
                } else {
                    Assert.UNREACHABLE();
                }
                ++n;
                ++n2;
            }
        }

        public void push_I(int n) {
            this.sp = (StackAddress)this.sp.offset(-HeapAddress.size());
            this.sp.poke4(n);
        }

        public void push_L(long l) {
            this.push_I((int)(l >> 32));
            this.push_I((int)l);
        }

        public void push_F(float f) {
            this.push_I(Float.floatToRawIntBits(f));
        }

        public void push_D(double d) {
            this.push_L(Double.doubleToRawLongBits(d));
        }

        public void push_A(Object object) {
            this.push_R(HeapAddress.addressOf(object));
        }

        public void push_R(Address address) {
            this.sp = (StackAddress)this.sp.offset(-HeapAddress.size());
            this.sp.poke(address);
        }

        public void push(Object object) {
            this.push_A(object);
        }

        public int pop_I() {
            int n = this.sp.peek4();
            this.sp = (StackAddress)this.sp.offset(HeapAddress.size());
            return n;
        }

        public long pop_L() {
            int n = this.pop_I();
            int n2 = this.pop_I();
            return Convert.twoIntsToLong(n, n2);
        }

        public float pop_F() {
            return Float.intBitsToFloat(this.pop_I());
        }

        public double pop_D() {
            return Double.longBitsToDouble(this.pop_L());
        }

        public Object pop_A() {
            return ((HeapAddress)this.pop_R()).asObject();
        }

        public Address pop_R() {
            Address address = this.sp.peek();
            this.sp = (StackAddress)this.sp.offset(HeapAddress.size());
            return address;
        }

        public Object pop() {
            return this.pop_A();
        }

        public void popAll() {
            this.sp = (StackAddress)this.fp.offset(-(this.nlocals * HeapAddress.size()));
        }

        public Object peek_A(int n) {
            HeapAddress heapAddress = (HeapAddress)this.sp.offset(n * HeapAddress.size()).peek();
            return heapAddress.asObject();
        }

        public void setLocal_I(int n, int n2) {
            this.fp.offset(-(n * HeapAddress.size())).poke4(n2);
        }

        public void setLocal_L(int n, long l) {
            this.setLocal_I(n, (int)(l >> 32));
            this.setLocal_I(n + 1, (int)l);
        }

        public void setLocal_F(int n, float f) {
            this.setLocal_I(n, Float.floatToRawIntBits(f));
        }

        public void setLocal_D(int n, double d) {
            this.setLocal_L(n, Double.doubleToRawLongBits(d));
        }

        public void setLocal_A(int n, Object object) {
            this.setLocal_R(n, HeapAddress.addressOf(object));
        }

        public void setLocal_R(int n, Address address) {
            this.fp.offset(-(n * HeapAddress.size())).poke(address);
        }

        public int getLocal_I(int n) {
            return this.fp.offset(-(n * HeapAddress.size())).peek4();
        }

        public long getLocal_L(int n) {
            int n2 = this.getLocal_I(n + 1);
            int n3 = this.getLocal_I(n);
            return Convert.twoIntsToLong(n2, n3);
        }

        public float getLocal_F(int n) {
            return Float.intBitsToFloat(this.getLocal_I(n));
        }

        public double getLocal_D(int n) {
            return Double.longBitsToDouble(this.getLocal_L(n));
        }

        public Object getLocal_A(int n) {
            return ((HeapAddress)this.getLocal_R(n)).asObject();
        }

        public Address getLocal_R(int n) {
            return this.fp.offset(-(n * HeapAddress.size())).peek();
        }

        public void return_I(int n) {
            this.loResult = n;
        }

        public void return_L(long l) {
            this.loResult = (int)(l >> 32);
            this.hiResult = (int)l;
        }

        public void return_F(float f) {
            this.loResult = Float.floatToRawIntBits(f);
        }

        public void return_D(double d) {
            this.return_L(Double.doubleToRawLongBits(d));
        }

        public void return_A(Object object) {
            this.loResult = HeapAddress.addressOf(object).to32BitValue();
        }

        public void return_V() {
        }

        public int getReturnVal_I() {
            return this.loResult;
        }

        public long getReturnVal_L() {
            return Convert.twoIntsToLong(this.loResult, this.hiResult);
        }

        public float getReturnVal_F() {
            return Float.intBitsToFloat(this.loResult);
        }

        public double getReturnVal_D() {
            return Double.longBitsToDouble(this.getReturnVal_L());
        }

        public Object getReturnVal_A() {
            return ((HeapAddress)this.getReturnVal_R()).asObject();
        }

        public Address getReturnVal_R() {
            return HeapAddress.address32(this.loResult);
        }

        public DirectState(StackAddress stackAddress, StackAddress stackAddress2, int n) {
            this.fp = stackAddress;
            this.sp = stackAddress2;
            this.nlocals = n;
        }
    }

    public static class DirectVMInterface
    extends BytecodeInterpreter.VMInterface {
        public int getstatic_I(jq_StaticField jq_StaticField2) {
            return jq_StaticField2.getAddress().peek4();
        }

        public long getstatic_L(jq_StaticField jq_StaticField2) {
            return jq_StaticField2.getAddress().peek8();
        }

        public float getstatic_F(jq_StaticField jq_StaticField2) {
            return Float.intBitsToFloat(this.getstatic_I(jq_StaticField2));
        }

        public double getstatic_D(jq_StaticField jq_StaticField2) {
            return Double.longBitsToDouble(this.getstatic_L(jq_StaticField2));
        }

        public Object getstatic_A(jq_StaticField jq_StaticField2) {
            return ((HeapAddress)jq_StaticField2.getAddress().peek()).asObject();
        }

        public byte getstatic_B(jq_StaticField jq_StaticField2) {
            return (byte)jq_StaticField2.getAddress().peek4();
        }

        public char getstatic_C(jq_StaticField jq_StaticField2) {
            return (char)jq_StaticField2.getAddress().peek4();
        }

        public short getstatic_S(jq_StaticField jq_StaticField2) {
            return (short)jq_StaticField2.getAddress().peek4();
        }

        public boolean getstatic_Z(jq_StaticField jq_StaticField2) {
            boolean bl = false;
            if (jq_StaticField2.getAddress().peek4() != 0) {
                bl = true;
            }
            return bl;
        }

        public void putstatic_I(jq_StaticField jq_StaticField2, int n) {
            jq_StaticField2.getDeclaringClass().setStaticData(jq_StaticField2, n);
        }

        public void putstatic_L(jq_StaticField jq_StaticField2, long l) {
            jq_StaticField2.getDeclaringClass().setStaticData(jq_StaticField2, l);
        }

        public void putstatic_F(jq_StaticField jq_StaticField2, float f) {
            jq_StaticField2.getDeclaringClass().setStaticData(jq_StaticField2, f);
        }

        public void putstatic_D(jq_StaticField jq_StaticField2, double d) {
            jq_StaticField2.getDeclaringClass().setStaticData(jq_StaticField2, d);
        }

        public void putstatic_A(jq_StaticField jq_StaticField2, Object object) {
            jq_StaticField2.getDeclaringClass().setStaticData(jq_StaticField2, object);
        }

        public void putstatic_Z(jq_StaticField jq_StaticField2, boolean bl) {
            jq_StaticField2.getDeclaringClass().setStaticData(jq_StaticField2, bl ? 1 : 0);
        }

        public void putstatic_B(jq_StaticField jq_StaticField2, byte by) {
            jq_StaticField2.getDeclaringClass().setStaticData(jq_StaticField2, by);
        }

        public void putstatic_C(jq_StaticField jq_StaticField2, char c) {
            jq_StaticField2.getDeclaringClass().setStaticData(jq_StaticField2, c);
        }

        public void putstatic_S(jq_StaticField jq_StaticField2, short s) {
            jq_StaticField2.getDeclaringClass().setStaticData(jq_StaticField2, s);
        }

        public int getfield_I(Object object, jq_InstanceField jq_InstanceField2) {
            return HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).peek4();
        }

        public long getfield_L(Object object, jq_InstanceField jq_InstanceField2) {
            return HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).peek8();
        }

        public float getfield_F(Object object, jq_InstanceField jq_InstanceField2) {
            return Float.intBitsToFloat(this.getfield_I(object, jq_InstanceField2));
        }

        public double getfield_D(Object object, jq_InstanceField jq_InstanceField2) {
            return Double.longBitsToDouble(this.getfield_L(object, jq_InstanceField2));
        }

        public Object getfield_A(Object object, jq_InstanceField jq_InstanceField2) {
            return ((HeapAddress)HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).peek()).asObject();
        }

        public byte getfield_B(Object object, jq_InstanceField jq_InstanceField2) {
            return HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).peek1();
        }

        public char getfield_C(Object object, jq_InstanceField jq_InstanceField2) {
            return (char)HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).peek4();
        }

        public short getfield_S(Object object, jq_InstanceField jq_InstanceField2) {
            return HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).peek2();
        }

        public boolean getfield_Z(Object object, jq_InstanceField jq_InstanceField2) {
            boolean bl = false;
            if (HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).peek1() != 0) {
                bl = true;
            }
            return bl;
        }

        public void putfield_I(Object object, jq_InstanceField jq_InstanceField2, int n) {
            HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).poke4(n);
        }

        public void putfield_L(Object object, jq_InstanceField jq_InstanceField2, long l) {
            HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).poke8(l);
        }

        public void putfield_F(Object object, jq_InstanceField jq_InstanceField2, float f) {
            this.putfield_I(object, jq_InstanceField2, Float.floatToRawIntBits(f));
        }

        public void putfield_D(Object object, jq_InstanceField jq_InstanceField2, double d) {
            this.putfield_L(object, jq_InstanceField2, Double.doubleToRawLongBits(d));
        }

        public void putfield_A(Object object, jq_InstanceField jq_InstanceField2, Object object2) {
            HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).poke(HeapAddress.addressOf(object2));
        }

        public void putfield_B(Object object, jq_InstanceField jq_InstanceField2, byte by) {
            HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).poke1(by);
        }

        public void putfield_C(Object object, jq_InstanceField jq_InstanceField2, char c) {
            HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).poke2((short)(c << 16 >> 16));
        }

        public void putfield_S(Object object, jq_InstanceField jq_InstanceField2, short s) {
            HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).poke2(s);
        }

        public void putfield_Z(Object object, jq_InstanceField jq_InstanceField2, boolean bl) {
            HeapAddress.addressOf(object).offset(jq_InstanceField2.getOffset()).poke1((byte)(bl ? 1 : 0));
        }

        public Object new_obj(jq_Type jq_Type2) {
            return ((jq_Class)jq_Type2).newInstance();
        }

        public Object new_array(jq_Type jq_Type2, int n) {
            return ((jq_Array)jq_Type2).newInstance(n);
        }

        public Object checkcast(Object object, jq_Type jq_Type2) {
            if (jq_Type2.isAddressType()) {
                return object;
            }
            return TypeCheck.checkcast(object, jq_Type2);
        }

        public boolean instance_of(Object object, jq_Type jq_Type2) {
            return TypeCheck.instance_of(object, jq_Type2);
        }

        public int arraylength(Object object) {
            return HeapAddress.addressOf(object).offset(-12).peek4();
        }

        public void monitorenter(Object object, BytecodeInterpreter.MethodInterpreter methodInterpreter) {
            Monitor.monitorenter(object);
        }

        public void monitorexit(Object object) {
            Monitor.monitorexit(object);
        }

        public Object multinewarray(int[] nArray, jq_Type jq_Type2) {
            return Arrays.multinewarray_helper(nArray, 0, (jq_Array)jq_Type2);
        }

        public jq_Reference getJQTypeOf(Object object) {
            return jq_Reference.getTypeOf(object);
        }
    }
}

