/*
 * Decompiled with CFR 0.152.
 */
package Interpreter;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_Initializer;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Type;
import Interpreter.BytecodeInterpreter;
import Main.HostedVM;
import Run_Time.Reflection;
import Run_Time.Unsafe;
import UTF.Utf8;
import Util.Assert;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;

public class ReflectiveInterpreter
extends BytecodeInterpreter {
    static HashSet cantInterpret = new HashSet();

    public Object invokeReflective(jq_Method jq_Method2) throws Throwable {
        Object object;
        jq_Class jq_Class2 = jq_Method2.getDeclaringClass();
        Assert._assert(jq_Class2.isClsInitialized());
        Class clazz = Reflection.getJDKType(jq_Class2);
        jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
        int n = 0;
        if (!jq_Method2.isStatic()) {
            n = 1;
        }
        Class[] classArray = new Class[jq_TypeArray.length - n];
        Object[] objectArray = new Object[jq_TypeArray.length - n];
        int n2 = jq_TypeArray.length - 1;
        while (n2 >= n) {
            classArray[n2 - n] = Reflection.getJDKType(jq_TypeArray[n2]);
            object = classArray[n2 - n];
            if (((Class)object).isPrimitive()) {
                if (object == Integer.TYPE) {
                    objectArray[n2 - n] = new Integer(this.istate.pop_I());
                } else if (object == Long.TYPE) {
                    objectArray[n2 - n] = new Long(this.istate.pop_L());
                } else if (object == Float.TYPE) {
                    objectArray[n2 - n] = new Float(this.istate.pop_F());
                } else if (object == Double.TYPE) {
                    objectArray[n2 - n] = new Double(this.istate.pop_D());
                } else if (object == Byte.TYPE) {
                    objectArray[n2 - n] = new Byte((byte)this.istate.pop_I());
                } else if (object == Short.TYPE) {
                    objectArray[n2 - n] = new Short((short)this.istate.pop_I());
                } else if (object == Character.TYPE) {
                    objectArray[n2 - n] = new Character((char)this.istate.pop_I());
                } else if (object == Boolean.TYPE) {
                    boolean bl = false;
                    if (this.istate.pop_I() != 0) {
                        bl = true;
                    }
                    objectArray[n2 - n] = new Boolean(bl);
                } else {
                    Assert.UNREACHABLE(((Class)object).toString());
                }
            } else {
                objectArray[n2 - n] = this.istate.pop_A();
            }
            --n2;
        }
        try {
            if (jq_Method2 instanceof jq_Initializer) {
                Constructor constructor = clazz.getDeclaredConstructor(classArray);
                constructor.setAccessible(true);
                object = (UninitializedType)this.istate.pop_A();
                boolean bl = false;
                if (((UninitializedType)object).k == jq_Method2.getDeclaringClass()) {
                    bl = true;
                }
                Assert._assert(bl);
                Object t = constructor.newInstance(objectArray);
                ((ReflectiveState)this.istate).replaceUninitializedReferences(t, (UninitializedType)object);
                return null;
            }
            Method method = clazz.getDeclaredMethod(jq_Method2.getName().toString(), classArray);
            method.setAccessible(true);
            object = !jq_Method2.isStatic() ? this.istate.pop_A() : null;
            return method.invoke(object, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Assert.UNREACHABLE("host jdk does not contain method " + jq_Method2);
        }
        catch (InstantiationException instantiationException) {
            Assert.UNREACHABLE();
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.UNREACHABLE();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.UNREACHABLE();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new BytecodeInterpreter.WrappedException(invocationTargetException.getTargetException());
        }
        return null;
    }

    public Object invokeMethod(jq_Method jq_Method2) throws Throwable {
        if (cantInterpret.contains(jq_Method2)) {
            return this.invokeReflective(jq_Method2);
        }
        if (jq_Method2.isNative() || jq_Method2 instanceof jq_Initializer) {
            return this.invokeReflective(jq_Method2);
        }
        ReflectiveState reflectiveState = new ReflectiveState(jq_Method2);
        try {
            return this.invokeMethod(jq_Method2, reflectiveState);
        }
        catch (MonitorExit monitorExit) {
            Assert._assert(jq_Method2.isSynchronized());
            boolean bl = false;
            if (this.istate != reflectiveState) {
                bl = true;
            }
            Assert._assert(bl);
            return reflectiveState.getReturnVal_A();
        }
    }

    public Object invokeUnsafeMethod(jq_Method jq_Method2) throws Throwable {
        if (jq_Method2 == Unsafe._floatToIntBits) {
            return new Integer(Float.floatToRawIntBits(this.istate.pop_F()));
        }
        if (jq_Method2 == Unsafe._intBitsToFloat) {
            return new Float(Float.intBitsToFloat(this.istate.pop_I()));
        }
        if (jq_Method2 == Unsafe._doubleToLongBits) {
            return new Long(Double.doubleToRawLongBits(this.istate.pop_D()));
        }
        if (jq_Method2 == Unsafe._longBitsToDouble) {
            return new Double(Double.longBitsToDouble(this.istate.pop_L()));
        }
        return this.invokeReflective(jq_Method2);
    }

    public static void main(String[] stringArray) throws Throwable {
        Object object;
        String string = stringArray[0];
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        HostedVM.initialize();
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("L" + string2.replace('.', '/') + ';');
        jq_Class2.cls_initialize();
        jq_Method jq_Method2 = null;
        Utf8 utf8 = Utf8.get(string3);
        Object[] objectArray = Arrays.asList(jq_Class2.getDeclaredStaticMethods()).iterator();
        while (objectArray.hasNext()) {
            object = objectArray.next();
            if (((jq_Member)object).getName() != utf8) continue;
            jq_Method2 = object;
            break;
        }
        if (jq_Method2 == null) {
            Assert.UNREACHABLE("root method not found: " + string2 + '.' + string3);
        }
        objectArray = ReflectiveInterpreter.parseMethodArgs(jq_Method2.getParamWords(), jq_Method2.getParamTypes(), stringArray, 0);
        object = new ReflectiveState(objectArray);
        Object object2 = new ReflectiveInterpreter((BytecodeInterpreter.State)object).invokeMethod(jq_Method2);
        System.out.println("Return value: " + object2);
    }

    public static Object[] parseMethodArgs(int n, jq_Type[] jq_TypeArray, String[] stringArray, int n2) {
        Object[] objectArray = new Object[n];
        try {
            int n3 = 0;
            int n4 = 0;
            while (n3 < jq_TypeArray.length) {
                if (jq_TypeArray[n3] == PrimordialClassLoader.getJavaLangString()) {
                    objectArray[n4] = stringArray[++n2];
                } else if (jq_TypeArray[n3] == jq_Primitive.BOOLEAN) {
                    objectArray[n4] = Boolean.valueOf(stringArray[++n2]);
                } else if (jq_TypeArray[n3] == jq_Primitive.BYTE) {
                    objectArray[n4] = Byte.valueOf(stringArray[++n2]);
                } else if (jq_TypeArray[n3] == jq_Primitive.SHORT) {
                    objectArray[n4] = Short.valueOf(stringArray[++n2]);
                } else if (jq_TypeArray[n3] == jq_Primitive.CHAR) {
                    objectArray[n4] = new Character(stringArray[++n2].charAt(0));
                } else if (jq_TypeArray[n3] == jq_Primitive.INT) {
                    objectArray[n4] = Integer.valueOf(stringArray[++n2]);
                } else if (jq_TypeArray[n3] == jq_Primitive.LONG) {
                    objectArray[n4] = Long.valueOf(stringArray[++n2]);
                    if (n != jq_TypeArray.length) {
                        ++n4;
                    }
                } else if (jq_TypeArray[n3] == jq_Primitive.FLOAT) {
                    objectArray[n4] = Float.valueOf(stringArray[++n2]);
                } else if (jq_TypeArray[n3] == jq_Primitive.DOUBLE) {
                    objectArray[n4] = Double.valueOf(stringArray[++n2]);
                    if (n != jq_TypeArray.length) {
                        ++n4;
                    }
                } else if (jq_TypeArray[n3].isArrayType()) {
                    int n5;
                    Object[] objectArray2;
                    if (!stringArray[++n2].equals("{")) {
                        Assert.UNREACHABLE("array parameter doesn't start with {");
                    }
                    int n6 = 0;
                    while (!stringArray[++n2].equals("}")) {
                        ++n6;
                    }
                    jq_Type jq_Type2 = ((jq_Array)jq_TypeArray[n3]).getElementType();
                    if (jq_Type2 == PrimordialClassLoader.getJavaLangString()) {
                        objectArray2 = new String[n6];
                        n5 = 0;
                        while (n5 < n6) {
                            objectArray2[n5] = stringArray[n2 - n6 + n5];
                            ++n5;
                        }
                        objectArray[n4] = objectArray2;
                    } else if (jq_Type2 == jq_Primitive.BOOLEAN) {
                        objectArray2 = new boolean[n6];
                        n5 = 0;
                        while (n5 < n6) {
                            objectArray2[n5] = (String)((Object)Boolean.valueOf(stringArray[n2 - n6 + n5]));
                            ++n5;
                        }
                        objectArray[n4] = objectArray2;
                    } else if (jq_Type2 == jq_Primitive.BYTE) {
                        objectArray2 = new byte[n6];
                        n5 = 0;
                        while (n5 < n6) {
                            objectArray2[n5] = (String)Byte.parseByte(stringArray[n2 - n6 + n5]);
                            ++n5;
                        }
                        objectArray[n4] = objectArray2;
                    } else if (jq_Type2 == jq_Primitive.SHORT) {
                        objectArray2 = new short[n6];
                        n5 = 0;
                        while (n5 < n6) {
                            objectArray2[n5] = (String)Short.parseShort(stringArray[n2 - n6 + n5]);
                            ++n5;
                        }
                        objectArray[n4] = objectArray2;
                    } else if (jq_Type2 == jq_Primitive.CHAR) {
                        objectArray2 = new char[n6];
                        n5 = 0;
                        while (n5 < n6) {
                            objectArray2[n5] = (String)stringArray[n2 - n6 + n5].charAt(0);
                            ++n5;
                        }
                        objectArray[n4] = objectArray2;
                    } else if (jq_Type2 == jq_Primitive.INT) {
                        objectArray2 = new int[n6];
                        n5 = 0;
                        while (n5 < n6) {
                            objectArray2[n5] = (String)Integer.parseInt(stringArray[n2 - n6 + n5]);
                            ++n5;
                        }
                        objectArray[n4] = objectArray2;
                    } else if (jq_Type2 == jq_Primitive.LONG) {
                        objectArray2 = new long[n6];
                        n5 = 0;
                        while (n5 < n6) {
                            objectArray2[n5] = (String)Long.parseLong(stringArray[n2 - n6 + n5]);
                            ++n5;
                        }
                        objectArray[n4] = objectArray2;
                    } else if (jq_Type2 == jq_Primitive.FLOAT) {
                        objectArray2 = new float[n6];
                        n5 = 0;
                        while (n5 < n6) {
                            objectArray2[n5] = (String)Float.parseFloat(stringArray[n2 - n6 + n5]);
                            ++n5;
                        }
                        objectArray[n4] = objectArray2;
                    } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                        objectArray2 = new double[n6];
                        n5 = 0;
                        while (n5 < n6) {
                            objectArray2[n5] = (String)Double.parseDouble(stringArray[n2 - n6 + n5]);
                            ++n5;
                        }
                        objectArray[n4] = objectArray2;
                    } else {
                        Assert.UNREACHABLE("Parsing an argument of type " + jq_TypeArray[n3] + " is not implemented");
                    }
                } else {
                    Assert.UNREACHABLE("Parsing an argument of type " + jq_TypeArray[n3] + " is not implemented");
                }
                ++n3;
                ++n4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            Assert.UNREACHABLE("not enough method arguments");
        }
        return objectArray;
    }

    public ReflectiveInterpreter(BytecodeInterpreter.State state) {
        super(new ReflectiveVMInterface(), state);
    }

    static {
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("Ljava/io/PrintStream;");
        jq_InstanceMethod jq_InstanceMethod2 = jq_Class2.getOrCreateInstanceMethod("write", "(Ljava/lang/String;)V");
        cantInterpret.add(jq_InstanceMethod2);
    }

    public static class ReflectiveState
    extends BytecodeInterpreter.State {
        final Object[] locals;
        final Object[] stack;
        final jq_Method m;
        int sp;
        Object result;

        public void push_I(int n) {
            this.stack[this.sp++] = new Integer(n);
        }

        public void push_L(long l) {
            this.stack[this.sp++] = new Long(l);
            this.stack[this.sp++] = null;
        }

        public void push_F(float f) {
            this.stack[this.sp++] = new Float(f);
        }

        public void push_D(double d) {
            this.stack[this.sp++] = new Double(d);
            this.stack[this.sp++] = null;
        }

        public void push_A(Object object) {
            this.stack[this.sp++] = object;
        }

        public void push(Object object) {
            this.stack[this.sp++] = object;
        }

        public int pop_I() {
            return (Integer)this.stack[--this.sp];
        }

        public long pop_L() {
            --this.sp;
            return (Long)this.stack[--this.sp];
        }

        public float pop_F() {
            return ((Float)this.stack[--this.sp]).floatValue();
        }

        public double pop_D() {
            --this.sp;
            return (Double)this.stack[--this.sp];
        }

        public Object pop_A() {
            return this.stack[--this.sp];
        }

        public Object pop() {
            return this.stack[--this.sp];
        }

        public void popAll() {
            this.sp = 0;
        }

        public Object peek_A(int n) {
            return this.stack[this.sp - n - 1];
        }

        public void setLocal_I(int n, int n2) {
            this.locals[n] = new Integer(n2);
        }

        public void setLocal_L(int n, long l) {
            this.locals[n] = new Long(l);
        }

        public void setLocal_F(int n, float f) {
            this.locals[n] = new Float(f);
        }

        public void setLocal_D(int n, double d) {
            this.locals[n] = new Double(d);
        }

        public void setLocal_A(int n, Object object) {
            this.locals[n] = object;
        }

        public int getLocal_I(int n) {
            return (Integer)this.locals[n];
        }

        public long getLocal_L(int n) {
            return (Long)this.locals[n];
        }

        public float getLocal_F(int n) {
            return ((Float)this.locals[n]).floatValue();
        }

        public double getLocal_D(int n) {
            return (Double)this.locals[n];
        }

        public Object getLocal_A(int n) {
            return this.locals[n];
        }

        public void return_I(int n) {
            this.result = new Integer(n);
        }

        public void return_L(long l) {
            this.result = new Long(l);
        }

        public void return_F(float f) {
            this.result = new Float(f);
        }

        public void return_D(double d) {
            this.result = new Double(d);
        }

        public void return_A(Object object) {
            this.result = object;
        }

        public void return_V() {
        }

        public int getReturnVal_I() {
            return (Integer)this.result;
        }

        public long getReturnVal_L() {
            return (Long)this.result;
        }

        public float getReturnVal_F() {
            return ((Float)this.result).floatValue();
        }

        public double getReturnVal_D() {
            return (Double)this.result;
        }

        public Object getReturnVal_A() {
            return this.result;
        }

        void replaceUninitializedReferences(Object object, UninitializedType uninitializedType) {
            int n = this.sp;
            while (--n >= 0) {
                if (this.stack[n] != uninitializedType) continue;
                this.stack[n] = object;
            }
            n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] == uninitializedType) {
                    this.locals[n] = object;
                }
                ++n;
            }
        }

        public ReflectiveState(Object[] objectArray) {
            this.m = null;
            this.locals = new Object[0];
            this.stack = objectArray;
            this.sp = objectArray.length;
        }

        public ReflectiveState(jq_Method jq_Method2) {
            this.m = jq_Method2;
            this.locals = new Object[jq_Method2.getMaxLocals()];
            this.stack = new Object[jq_Method2.getMaxStack()];
            this.sp = 0;
        }
    }

    static class UninitializedType {
        jq_Class k;

        UninitializedType(jq_Class jq_Class2) {
            this.k = jq_Class2;
        }
    }

    public static class ReflectiveVMInterface
    extends BytecodeInterpreter.VMInterface {
        public static final ReflectiveVMInterface INSTANCE = new ReflectiveVMInterface();

        public Object new_obj(jq_Type jq_Type2) {
            jq_Type2.cls_initialize();
            return new UninitializedType((jq_Class)jq_Type2);
        }

        public Object new_array(jq_Type jq_Type2, int n) {
            jq_Type2.cls_initialize();
            return Array.newInstance(Reflection.getJDKType(((jq_Array)jq_Type2).getElementType()), n);
        }

        public Object checkcast(Object object, jq_Type jq_Type2) {
            if (object == null) {
                return object;
            }
            if (!Reflection.getJDKType(jq_Type2).isAssignableFrom(object.getClass())) {
                throw new ClassCastException();
            }
            return object;
        }

        public boolean instance_of(Object object, jq_Type jq_Type2) {
            if (object == null) {
                return false;
            }
            return Reflection.getJDKType(jq_Type2).isAssignableFrom(object.getClass());
        }

        public int arraylength(Object object) {
            return Array.getLength(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void monitorenter(Object object, BytecodeInterpreter.MethodInterpreter methodInterpreter) {
            Object object2 = object;
            synchronized (object2) {
                try {
                    methodInterpreter.continueForwardTraversal();
                }
                catch (MonitorExit monitorExit) {
                    boolean bl = false;
                    if (monitorExit.o == object) {
                        bl = true;
                    }
                    Assert._assert(bl, "synchronization blocks are not nested!");
                    return;
                }
                catch (BytecodeInterpreter.WrappedException wrappedException) {
                    throw wrappedException;
                }
                return;
            }
        }

        public void monitorexit(Object object) {
            throw new MonitorExit(object);
        }

        public Object multinewarray(int[] nArray, jq_Type jq_Type2) {
            int n = 0;
            while (n < nArray.length) {
                jq_Type2.cls_initialize();
                jq_Type2 = ((jq_Array)jq_Type2).getElementType();
                ++n;
            }
            return Array.newInstance(Reflection.getJDKType(jq_Type2), nArray);
        }

        ReflectiveVMInterface() {
        }
    }

    static class MonitorExit
    extends RuntimeException {
        Object o;

        MonitorExit(Object object) {
            this.o = object;
        }
    }
}

