/*
 * Decompiled with CFR 0.152.
 */
package Linker.ELF;

import Linker.ELF.ELF;
import Linker.ELF.ELFConstants;
import Linker.ELF.ProgramHeader;
import Linker.ELF.Section;
import Util.Assert;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

abstract class ELFImpl
implements ELF,
ELFConstants {
    protected byte ei_class = 1;
    protected byte ei_data;
    protected int e_type;
    protected int e_machine;
    protected int e_version;
    protected int e_entry;
    protected int e_flags;
    protected List program_headers;
    protected List sections;
    protected Section.StrTabSection section_header_string_table;

    public Section.StrTabSection getSectionHeaderStringTable() {
        return this.section_header_string_table;
    }

    public void setSectionHeaderStringTable(Section.StrTabSection strTabSection) {
        this.section_header_string_table = strTabSection;
    }

    public int getSectionIndex(Section section) {
        if (section == null) {
            return 0;
        }
        return section.getIndex();
    }

    public Section getSection(int n) {
        if (n == 65521) {
            return Section.AbsSection.INSTANCE;
        }
        return (Section)this.sections.get(n);
    }

    public List getSections() {
        return this.sections;
    }

    public void addSection(Section section) {
        this.sections.add(section);
    }

    public void removeSection(Section section) {
        this.sections.remove(section);
    }

    public void addProgramHeader(ProgramHeader programHeader) {
        this.program_headers.add(programHeader);
    }

    public void removeProgramHeader(ProgramHeader programHeader) {
        this.program_headers.remove(programHeader);
    }

    public boolean isLittleEndian() {
        boolean bl = false;
        if (this.ei_data == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isBigEndian() {
        boolean bl = false;
        if (this.ei_data == 2) {
            bl = true;
        }
        return bl;
    }

    public void setLittleEndian() {
        this.ei_data = 1;
    }

    public void setBigEndian() {
        this.ei_data = (byte)2;
    }

    public void write() throws IOException {
        Object object;
        int n;
        int n2;
        int n3;
        if (this.section_header_string_table != null) {
            Assert._assert(this.sections.contains(this.section_header_string_table));
        }
        if (this.section_header_string_table != null) {
            Iterator iterator = this.sections.iterator();
            while (iterator.hasNext()) {
                Section section = (Section)iterator.next();
                this.section_header_string_table.addString(section.getName());
            }
        }
        if (this.program_headers.isEmpty()) {
            n3 = 0;
            n = n2 = ELFImpl.getHeaderSize();
        } else {
            n3 = ELFImpl.getHeaderSize();
            n = n2 = n3 + this.program_headers.size() * ProgramHeader.getSize();
        }
        Iterator iterator = this.sections.iterator();
        Section section = (Section)iterator.next();
        Assert._assert(section instanceof Section.NullSection);
        int n4 = 0;
        while (iterator.hasNext()) {
            section = (Section)iterator.next();
            if (section instanceof Section.StrTabSection) {
                object = (Section.StrTabSection)section;
                if (((Section.StrTabSection)object).getNumberOfEntries() < 10000) {
                    ((Section.StrTabSection)object).super_pack();
                } else {
                    ((Section.StrTabSection)object).pack();
                }
            } else if (section instanceof Section.SymTabSection) {
                object = (Section.SymTabSection)section;
                ((Section.SymTabSection)object).setIndices();
            }
            if (!(section instanceof Section.NoBitsSection)) {
                n2 += section.getSize();
            }
            section.setIndex(++n4);
        }
        this.writeHeader(n3, n2);
        object = this.program_headers.iterator();
        while (object.hasNext()) {
            ProgramHeader programHeader = (ProgramHeader)object.next();
            programHeader.writeHeader(this);
        }
        iterator = this.sections.iterator();
        while (iterator.hasNext()) {
            section = (Section)iterator.next();
            section.writeData(this);
        }
        iterator = this.sections.iterator();
        while (iterator.hasNext()) {
            section = (Section)iterator.next();
            section.writeHeader(this, n);
            if (section instanceof Section.NoBitsSection) continue;
            n += section.getSize();
        }
    }

    void writeHeader(int n, int n2) throws IOException {
        this.writeIdent();
        this.write_half(this.e_type);
        this.write_half(this.e_machine);
        this.write_word(this.e_version);
        this.write_addr(this.e_entry);
        this.write_off(n);
        this.write_off(n2);
        this.write_word(this.e_flags);
        this.write_half(ELFImpl.getHeaderSize());
        this.write_half(ProgramHeader.getSize());
        this.write_half(this.program_headers.size());
        this.write_half(Section.getHeaderSize());
        this.write_half(this.sections.size());
        this.write_half(this.getSectionIndex(this.section_header_string_table));
    }

    void writeIdent() throws IOException {
        this.writeMagicNumber();
        this.write_byte(this.ei_class);
        this.write_byte(this.ei_data);
        this.write_byte((byte)this.e_version);
        int n = 7;
        while (n < 16) {
            this.write_byte((byte)0);
            ++n;
        }
    }

    void writeMagicNumber() throws IOException {
        this.write_byte((byte)127);
        this.write_byte((byte)69);
        this.write_byte((byte)76);
        this.write_byte((byte)70);
    }

    public static int getHeaderSize() {
        return 52;
    }

    public ELFImpl(byte by, int n, int n2, int n3) {
        this.ei_data = by;
        this.e_type = n;
        this.e_machine = n2;
        this.e_version = 1;
        this.program_headers = new LinkedList();
        this.sections = new LinkedList();
    }

    protected ELFImpl() {
        this.ei_data = 1;
        this.e_type = 1;
        this.e_machine = 3;
        this.e_version = 1;
        this.program_headers = new LinkedList();
        this.sections = new LinkedList();
    }
}

