/*
 * Decompiled with CFR 0.152.
 */
package Linker.ELF;

import Linker.ELF.ELFImpl;
import Linker.ELF.ProgramHeader;
import Linker.ELF.Section;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class ELFRandomAccessFile
extends ELFImpl {
    protected RandomAccessFile file;
    protected List section_headers;

    void readHeader() throws IOException {
        int n;
        byte by = this.read_byte();
        if (by != 127) {
            throw new IOException();
        }
        byte by2 = this.read_byte();
        if (by2 != 69) {
            throw new IOException();
        }
        byte by3 = this.read_byte();
        if (by3 != 76) {
            throw new IOException();
        }
        byte by4 = this.read_byte();
        if (by4 != 70) {
            throw new IOException();
        }
        this.ei_class = this.read_byte();
        this.ei_data = this.read_byte();
        byte by5 = this.read_byte();
        int n2 = 7;
        while (n2 < 16) {
            n = this.read_byte();
            if (n != 0) {
                throw new IOException();
            }
            ++n2;
        }
        this.e_type = this.read_half();
        this.e_machine = this.read_half();
        this.e_version = this.read_word();
        if (by5 != (byte)this.e_version) {
            throw new IOException();
        }
        this.e_entry = this.read_addr();
        n2 = this.read_off();
        n = this.read_off();
        this.e_flags = this.read_word();
        int n3 = this.read_half();
        if (n3 != ELFImpl.getHeaderSize()) {
            throw new IOException();
        }
        int n4 = this.read_half();
        int n5 = this.read_half();
        if (n5 > 0 && n4 != ProgramHeader.getSize()) {
            throw new IOException();
        }
        int n6 = this.read_half();
        int n7 = this.read_half();
        if (n7 > 0 && n6 != Section.getHeaderSize()) {
            throw new IOException();
        }
        int n8 = this.read_half();
        this.set_position(n);
        this.section_headers = new ArrayList(n7);
        int n9 = 0;
        while (n9 < n7) {
            Section.UnloadedSection unloadedSection = new Section.UnloadedSection(this);
            this.section_headers.add(unloadedSection);
            Section section = unloadedSection.parseHeader();
            this.sections.add(section);
            ++n9;
        }
        if (n8 != 0) {
            this.section_header_string_table = (Section.StrTabSection)this.sections.get(n8);
            Section.UnloadedSection unloadedSection = (Section.UnloadedSection)this.section_headers.get(n8);
            this.section_headers.set(n8, null);
            this.section_header_string_table.load(unloadedSection, this);
        }
    }

    public Section getSection(int n) {
        if (n == 65521) {
            return Section.AbsSection.INSTANCE;
        }
        Section section = (Section)this.sections.get(n);
        Section.UnloadedSection unloadedSection = (Section.UnloadedSection)this.section_headers.get(n);
        if (unloadedSection != null) {
            this.section_headers.set(n, null);
            try {
                section.load(unloadedSection, this);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return section;
    }

    public void write_byte(byte by) throws IOException {
        this.file.write(by);
    }

    public void write_bytes(byte[] byArray) throws IOException {
        this.file.write(byArray);
    }

    public void write_half(int n) throws IOException {
        if (this.isLittleEndian()) {
            this.file.write((byte)n);
            this.file.write((byte)(n >> 8));
        } else {
            this.file.write((byte)(n >> 8));
            this.file.write((byte)n);
        }
    }

    public void write_word(int n) throws IOException {
        if (this.isLittleEndian()) {
            this.file.write((byte)n);
            this.file.write((byte)(n >> 8));
            this.file.write((byte)(n >> 16));
            this.file.write((byte)(n >> 24));
        } else {
            this.file.write((byte)(n >> 24));
            this.file.write((byte)(n >> 16));
            this.file.write((byte)(n >> 8));
            this.file.write((byte)n);
        }
    }

    public void write_sword(int n) throws IOException {
        this.write_word(n);
    }

    public void write_off(int n) throws IOException {
        this.write_word(n);
    }

    public void write_addr(int n) throws IOException {
        this.write_word(n);
    }

    public void write_sectionname(String string) throws IOException {
        int n = this.section_header_string_table == null ? 0 : this.section_header_string_table.getStringIndex(string);
        this.write_word(n);
    }

    public void set_position(int n) throws IOException {
        this.file.seek(n);
    }

    public byte read_byte() throws IOException {
        return this.file.readByte();
    }

    public void read_bytes(byte[] byArray) throws IOException {
        this.file.readFully(byArray);
    }

    public int read_half() throws IOException {
        int n = this.file.readByte() & 0xFF;
        int n2 = this.file.readByte() & 0xFF;
        int n3 = this.isLittleEndian() ? n2 << 8 | n : n << 8 | n2;
        return n3;
    }

    public int read_word() throws IOException {
        int n = this.file.readByte() & 0xFF;
        int n2 = this.file.readByte() & 0xFF;
        int n3 = this.file.readByte() & 0xFF;
        int n4 = this.file.readByte() & 0xFF;
        int n5 = this.isLittleEndian() ? n4 << 24 | n3 << 16 | n2 << 8 | n : n << 24 | n2 << 16 | n3 << 8 | n4;
        return n5;
    }

    public int read_sword() throws IOException {
        return this.read_word();
    }

    public int read_off() throws IOException {
        return this.read_word();
    }

    public int read_addr() throws IOException {
        return this.read_word();
    }

    public ELFRandomAccessFile(RandomAccessFile randomAccessFile) throws IOException {
        this.file = randomAccessFile;
        this.readHeader();
    }

    public ELFRandomAccessFile(byte by, int n, int n2, int n3, RandomAccessFile randomAccessFile) {
        super(by, n, n2, n3);
        this.file = randomAccessFile;
    }
}

