/*
 * Decompiled with CFR 0.152.
 */
package Linker.ELF;

import Linker.ELF.ELFConstants;
import Linker.ELF.ELFImpl;
import java.io.IOException;

public abstract class ProgramHeader
implements ELFConstants {
    protected int offset;
    protected int vaddr;
    protected int paddr;
    protected int filesz;
    protected int memsz;
    protected int flags;
    protected int align;

    public abstract int getType();

    public int getOffset() {
        return this.offset;
    }

    public int getVAddr() {
        return this.vaddr;
    }

    public int getPAddr() {
        return this.paddr;
    }

    public int getFileSz() {
        return this.filesz;
    }

    public int getMemSz() {
        return this.memsz;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getAlign() {
        return this.align;
    }

    public void writeHeader(ELFImpl eLFImpl) throws IOException {
        eLFImpl.write_word(this.getType());
        eLFImpl.write_off(this.getOffset());
        eLFImpl.write_addr(this.getVAddr());
        eLFImpl.write_addr(this.getPAddr());
        eLFImpl.write_word(this.getFileSz());
        eLFImpl.write_word(this.getMemSz());
        eLFImpl.write_word(this.getFlags());
        eLFImpl.write_word(this.getAlign());
    }

    public static int getSize() {
        return 32;
    }

    public static class NullProgramHeader
    extends ProgramHeader {
        protected String name;
        protected byte[] desc;
        protected int type;

        public final int getType() {
            return 0;
        }
    }

    public static class LoadProgramHeader
    extends ProgramHeader {
        public final int getType() {
            return 1;
        }
    }

    public static class DynamicProgramHeader
    extends ProgramHeader {
        public final int getType() {
            return 2;
        }
    }

    public static class InterpProgramHeader
    extends ProgramHeader {
        public final int getType() {
            return 3;
        }
    }

    public static class NoteProgramHeader
    extends ProgramHeader {
        public final int getType() {
            return 4;
        }
    }

    public static class PHdrProgramHeader
    extends ProgramHeader {
        public final int getType() {
            return 6;
        }
    }
}

