/*
 * Decompiled with CFR 0.152.
 */
package Linker.ELF;

import Linker.ELF.ELF;
import Linker.ELF.ELFConstants;
import Linker.ELF.Section;
import Util.Assert;
import java.io.IOException;

public class SymbolTableEntry
implements ELFConstants {
    protected int index;
    protected String name;
    protected int value;
    protected int size;
    protected byte info;
    protected Section section;

    public final String getName() {
        return this.name;
    }

    public final int getValue() {
        return this.value;
    }

    public final int getSize() {
        return this.size;
    }

    public final byte getBind() {
        return (byte)(this.info >> 4);
    }

    public final byte getType() {
        return (byte)(this.info & 0xF);
    }

    public final byte getInfo() {
        return this.info;
    }

    public final byte getOther() {
        return 0;
    }

    public final int getSHndx() {
        return this.section.getIndex();
    }

    public void setIndex(int n) {
        boolean bl = false;
        if (n != 0) {
            bl = true;
        }
        Assert._assert(bl);
        this.index = n;
    }

    public int getIndex() {
        boolean bl = false;
        if (this.index != 0) {
            bl = true;
        }
        Assert._assert(bl);
        return this.index;
    }

    public void write(ELF eLF, Section.StrTabSection strTabSection) throws IOException {
        eLF.write_word(strTabSection.getStringIndex(this.getName()));
        eLF.write_addr(this.getValue());
        eLF.write_word(this.getSize());
        eLF.write_byte(this.getInfo());
        eLF.write_byte(this.getOther());
        eLF.write_half(this.getSHndx());
    }

    public static SymbolTableEntry read(ELF eLF, Section.StrTabSection strTabSection) throws IOException {
        int n = eLF.read_word();
        int n2 = eLF.read_addr();
        int n3 = eLF.read_word();
        byte by = eLF.read_byte();
        byte by2 = eLF.read_byte();
        int n4 = eLF.read_half();
        String string = n != 0 ? strTabSection.getString(n) : "";
        Section section = eLF.getSection(n4);
        return new SymbolTableEntry(string, n2, n3, (byte)(by >> 4 & 0xF), (byte)(by & 0xF), section);
    }

    public static int getEntrySize() {
        return 16;
    }

    public SymbolTableEntry(String string, int n, int n2, byte by, byte by2, Section section) {
        this.name = string;
        this.value = n;
        this.size = n2;
        this.info = (byte)(by << 4 | by2);
        this.section = section;
    }

    public static class EmptySymbolTableEntry
    extends SymbolTableEntry {
        public static final EmptySymbolTableEntry INSTANCE = new EmptySymbolTableEntry();

        public final int getIndex() {
            return 0;
        }

        public final void setIndex(int n) {
            boolean bl = false;
            if (n == 0) {
                bl = true;
            }
            Assert._assert(bl);
        }

        private EmptySymbolTableEntry() {
            super("", 0, 0, (byte)0, (byte)0, Section.NullSection.INSTANCE);
        }
    }
}

