/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_ClassFileConstants;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Main.HostedVM;
import UTF.Utf8;
import Util.IO.Textualizable;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;

public abstract class ClassDump {
    public static void main(String[] stringArray) {
        HostedVM.initialize();
        String string = stringArray.length > 0 ? stringArray[0] : "LMain/jq;";
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType(string);
        System.out.println("Loading " + jq_Class2 + "...");
        jq_Class2.load();
        System.out.println("Verifying " + jq_Class2 + "...");
        jq_Class2.verify();
        System.out.println("Preparing " + jq_Class2 + "...");
        jq_Class2.prepare();
        System.out.println("Initializing static fields of " + jq_Class2 + "...");
        jq_Class2.sf_initialize();
        ClassDump.dumpClass(System.out, jq_Class2);
        ClassDump.compileClass(System.out, jq_Class2);
    }

    public static void compileClass(PrintStream printStream, jq_Class jq_Class2) {
        ControlFlowGraph controlFlowGraph;
        jq_Method jq_Method2;
        Iterator<jq_Method> iterator = Arrays.asList(jq_Class2.getDeclaredStaticMethods()).iterator();
        while (iterator.hasNext()) {
            jq_Method2 = iterator.next();
            if (jq_Method2.getBytecode() == null) continue;
            printStream.println(jq_Method2.toString());
            controlFlowGraph = CodeCache.getCode(jq_Method2);
            System.out.println(controlFlowGraph.fullDump());
        }
        iterator = Arrays.asList(jq_Class2.getDeclaredInstanceMethods()).iterator();
        while (iterator.hasNext()) {
            jq_Method2 = (jq_InstanceMethod)iterator.next();
            if (jq_Method2.isAbstract() || jq_Method2.getBytecode() == null) continue;
            printStream.println(jq_Method2.toString());
            controlFlowGraph = CodeCache.getCode(jq_Method2);
            System.out.println(controlFlowGraph.fullDump());
        }
    }

    public static void dumpType(PrintStream printStream, jq_Type jq_Type2) {
        if (jq_Type2.isClassType()) {
            printStream.print("class ");
        }
        if (jq_Type2.isArrayType()) {
            printStream.print("array ");
        }
        if (jq_Type2.isPrimitiveType()) {
            printStream.print("primitive ");
        }
        printStream.print(jq_Type2.getName());
    }

    public static void dumpClass(PrintStream printStream, jq_Class jq_Class2) {
        jq_ClassFileConstants jq_ClassFileConstants2;
        Iterator<Textualizable> iterator;
        ClassDump.dumpType(printStream, jq_Class2);
        printStream.println();
        printStream.println("state: " + jq_Class2.getState());
        if (jq_Class2.isLoaded()) {
            byte[] byArray;
            Utf8 utf8;
            Object object;
            printStream.println("java class file version " + jq_Class2.getMajorVersion() + '.' + jq_Class2.getMinorVersion());
            printStream.println("source file name: " + jq_Class2.getSourceFile());
            printStream.print("access flags: ");
            if (jq_Class2.isPublic()) {
                printStream.print("public ");
            }
            if (jq_Class2.isFinal()) {
                printStream.print("final ");
            }
            if (jq_Class2.isSpecial()) {
                printStream.print("special ");
            }
            if (jq_Class2.isInterface()) {
                printStream.print("interface ");
            }
            if (jq_Class2.isAbstract()) {
                printStream.print("abstract ");
            }
            if (jq_Class2.isSynthetic()) {
                printStream.print("synthetic ");
            }
            if (jq_Class2.isDeprecated()) {
                printStream.print("deprecated ");
            }
            printStream.println();
            printStream.println("superclass: " + jq_Class2.getSuperclass().getName());
            printStream.print("known subclasses: ");
            iterator = Arrays.asList(jq_Class2.getSubClasses()).iterator();
            while (iterator.hasNext()) {
                jq_ClassFileConstants2 = (jq_Class)iterator.next();
                printStream.print(jq_ClassFileConstants2.getName() + ' ');
            }
            printStream.println();
            printStream.print("declared interfaces: ");
            iterator = Arrays.asList(jq_Class2.getDeclaredInterfaces()).iterator();
            while (iterator.hasNext()) {
                jq_ClassFileConstants2 = (jq_Class)iterator.next();
                printStream.print(jq_ClassFileConstants2.getName() + ' ');
            }
            printStream.println();
            printStream.print("declared instance fields: ");
            iterator = Arrays.asList(jq_Class2.getDeclaredInstanceFields()).iterator();
            while (iterator.hasNext()) {
                jq_ClassFileConstants2 = (jq_InstanceField)iterator.next();
                printStream.print("" + ((jq_Member)jq_ClassFileConstants2).getName() + ' ');
            }
            printStream.println();
            printStream.print("declared static fields: ");
            iterator = Arrays.asList(jq_Class2.getDeclaredStaticFields()).iterator();
            while (iterator.hasNext()) {
                jq_ClassFileConstants2 = (jq_StaticField)iterator.next();
                printStream.print("" + ((jq_Member)jq_ClassFileConstants2).getName() + ' ');
            }
            printStream.println();
            printStream.print("declared instance methods: ");
            iterator = Arrays.asList(jq_Class2.getDeclaredInstanceMethods()).iterator();
            while (iterator.hasNext()) {
                jq_ClassFileConstants2 = (jq_InstanceMethod)iterator.next();
                printStream.println("" + ((jq_Member)jq_ClassFileConstants2).getName() + ' ');
                printStream.println("method attributes:");
                object = ((jq_Member)jq_ClassFileConstants2).getAttributes().keySet().iterator();
                while (object.hasNext()) {
                    utf8 = (Utf8)object.next();
                    printStream.print("\t" + utf8);
                    byArray = jq_Class2.getAttribute(utf8);
                    printStream.println(": " + (byArray != null ? "(length " + byArray.length + ")\t" : "\t") + byArray);
                }
            }
            printStream.println();
            printStream.print("declared static methods: ");
            iterator = Arrays.asList(jq_Class2.getDeclaredStaticMethods()).iterator();
            while (iterator.hasNext()) {
                jq_ClassFileConstants2 = (jq_StaticMethod)iterator.next();
                printStream.println("" + ((jq_Member)jq_ClassFileConstants2).getName() + ' ');
                printStream.println("method attributes:");
                object = ((jq_Member)jq_ClassFileConstants2).getAttributes().keySet().iterator();
                while (object.hasNext()) {
                    utf8 = (Utf8)object.next();
                    printStream.print("\t" + utf8);
                    byArray = jq_Class2.getAttribute(utf8);
                    printStream.println(": " + (byArray != null ? "(length " + byArray.length + ")\t" : "\t") + byArray);
                }
            }
            printStream.println();
            printStream.print("class initializer: ");
            if (jq_Class2.getClassInitializer() != null) {
                printStream.println("present");
            } else {
                printStream.println("absent");
            }
            printStream.println("constant pool size: " + jq_Class2.getCPCount());
            printStream.println("attributes:");
            iterator = jq_Class2.getAttributes();
            while (iterator.hasNext()) {
                jq_ClassFileConstants2 = (Utf8)((Object)iterator.next());
                object = jq_Class2.getAttribute((Utf8)jq_ClassFileConstants2);
                printStream.println("\t" + jq_ClassFileConstants2 + ": (length " + ((Object)object).length + ")\t" + object);
            }
        }
        if (jq_Class2.isPrepared()) {
            printStream.print("interfaces: ");
            iterator = Arrays.asList(jq_Class2.getInterfaces()).iterator();
            while (iterator.hasNext()) {
                jq_ClassFileConstants2 = iterator.next();
                printStream.print("" + jq_ClassFileConstants2 + ' ');
            }
            printStream.println();
            printStream.print("virtual methods: ");
            iterator = Arrays.asList(jq_Class2.getVirtualMethods()).iterator();
            while (iterator.hasNext()) {
                jq_ClassFileConstants2 = (jq_InstanceMethod)iterator.next();
                printStream.print("" + jq_ClassFileConstants2 + ' ');
            }
            printStream.println();
        }
        jq_Class2.isSFInitialized();
        jq_Class2.isClsInitialized();
    }
}

